/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.utility.tests.internal;

import java.util.NoSuchElementException;
import org.eclipse.jpt.utility.internal.Queue;
import org.eclipse.jpt.utility.internal.SimpleQueue;
import org.eclipse.jpt.utility.tests.internal.MultiThreadedTestCase;
import org.eclipse.jpt.utility.tests.internal.TestTools;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleQueueTests
extends MultiThreadedTestCase {
    public SimpleQueueTests(String name) {
        super(name);
    }

    Queue<String> buildQueue() {
        return new SimpleQueue();
    }

    public void testIsEmpty() {
        Queue<String> queue = this.buildQueue();
        SimpleQueueTests.assertTrue((boolean)queue.isEmpty());
        queue.enqueue((Object)"first");
        SimpleQueueTests.assertFalse((boolean)queue.isEmpty());
        queue.enqueue((Object)"second");
        SimpleQueueTests.assertFalse((boolean)queue.isEmpty());
        queue.dequeue();
        SimpleQueueTests.assertFalse((boolean)queue.isEmpty());
        queue.dequeue();
        SimpleQueueTests.assertTrue((boolean)queue.isEmpty());
    }

    public void testEnqueueAndDequeue() {
        Queue<String> queue = this.buildQueue();
        String first = "first";
        String second = "second";
        queue.enqueue((Object)first);
        queue.enqueue((Object)second);
        SimpleQueueTests.assertEquals((String)first, (String)((String)queue.dequeue()));
        SimpleQueueTests.assertEquals((String)second, (String)((String)queue.dequeue()));
    }

    public void testEnqueueAndPeek() {
        Queue<String> queue = this.buildQueue();
        String first = "first";
        String second = "second";
        queue.enqueue((Object)first);
        queue.enqueue((Object)second);
        SimpleQueueTests.assertEquals((String)first, (String)((String)queue.peek()));
        SimpleQueueTests.assertEquals((String)first, (String)((String)queue.peek()));
        SimpleQueueTests.assertEquals((String)first, (String)((String)queue.dequeue()));
        SimpleQueueTests.assertEquals((String)second, (String)((String)queue.peek()));
        SimpleQueueTests.assertEquals((String)second, (String)((String)queue.peek()));
        SimpleQueueTests.assertEquals((String)second, (String)((String)queue.dequeue()));
    }

    public void testEmptyQueueExceptionPeek() {
        Queue<String> queue = this.buildQueue();
        String first = "first";
        String second = "second";
        queue.enqueue((Object)first);
        queue.enqueue((Object)second);
        SimpleQueueTests.assertEquals((String)first, (String)((String)queue.peek()));
        SimpleQueueTests.assertEquals((String)first, (String)((String)queue.dequeue()));
        SimpleQueueTests.assertEquals((String)second, (String)((String)queue.peek()));
        SimpleQueueTests.assertEquals((String)second, (String)((String)queue.dequeue()));
        boolean exCaught = false;
        try {
            queue.peek();
            SimpleQueueTests.fail();
        }
        catch (NoSuchElementException noSuchElementException) {
            exCaught = true;
        }
        SimpleQueueTests.assertTrue((boolean)exCaught);
    }

    public void testEmptyQueueExceptionDequeue() {
        Queue<String> queue = this.buildQueue();
        String first = "first";
        String second = "second";
        queue.enqueue((Object)first);
        queue.enqueue((Object)second);
        SimpleQueueTests.assertEquals((String)first, (String)((String)queue.peek()));
        SimpleQueueTests.assertEquals((String)first, (String)((String)queue.dequeue()));
        SimpleQueueTests.assertEquals((String)second, (String)((String)queue.peek()));
        SimpleQueueTests.assertEquals((String)second, (String)((String)queue.dequeue()));
        boolean exCaught = false;
        try {
            queue.dequeue();
            SimpleQueueTests.fail();
        }
        catch (NoSuchElementException noSuchElementException) {
            exCaught = true;
        }
        SimpleQueueTests.assertTrue((boolean)exCaught);
    }

    public void testClone() {
        SimpleQueue queue = (SimpleQueue)this.buildQueue();
        queue.enqueue((Object)"first");
        queue.enqueue((Object)"second");
        queue.enqueue((Object)"third");
        this.verifyClone((Queue<String>)queue, (Queue<String>)queue.clone());
    }

    public void testSerialization() throws Exception {
        Queue<String> queue = this.buildQueue();
        queue.enqueue((Object)"first");
        queue.enqueue((Object)"second");
        queue.enqueue((Object)"third");
        this.verifyClone(queue, TestTools.serialize(queue));
    }

    private void verifyClone(Queue<String> original, Queue<String> clone) {
        SimpleQueueTests.assertNotSame(original, clone);
        SimpleQueueTests.assertEquals((String)((String)original.peek()), (String)((String)clone.peek()));
        SimpleQueueTests.assertEquals((String)((String)original.dequeue()), (String)((String)clone.dequeue()));
        SimpleQueueTests.assertEquals((String)((String)original.peek()), (String)((String)clone.peek()));
        SimpleQueueTests.assertEquals((String)((String)original.dequeue()), (String)((String)clone.dequeue()));
        SimpleQueueTests.assertEquals((boolean)original.isEmpty(), (boolean)clone.isEmpty());
        SimpleQueueTests.assertEquals((String)((String)original.peek()), (String)((String)clone.peek()));
        SimpleQueueTests.assertEquals((String)((String)original.dequeue()), (String)((String)clone.dequeue()));
        SimpleQueueTests.assertTrue((boolean)original.isEmpty());
        SimpleQueueTests.assertEquals((boolean)original.isEmpty(), (boolean)clone.isEmpty());
        original.enqueue((Object)"fourth");
        SimpleQueueTests.assertFalse((boolean)original.isEmpty());
        SimpleQueueTests.assertTrue((boolean)clone.isEmpty());
    }
}

