/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.eclipselink.core.tests.internal.context.orm;

import java.util.Iterator;
import java.util.ListIterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.core.context.orm.OrmPersistentType;
import org.eclipse.jpt.core.resource.orm.OrmFactory;
import org.eclipse.jpt.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.eclipselink.core.context.EclipseLinkCacheCoordinationType;
import org.eclipse.jpt.eclipselink.core.context.EclipseLinkCacheType;
import org.eclipse.jpt.eclipselink.core.context.EclipseLinkChangeTrackingType;
import org.eclipse.jpt.eclipselink.core.context.EclipseLinkCustomConverter;
import org.eclipse.jpt.eclipselink.core.context.EclipseLinkExistenceType;
import org.eclipse.jpt.eclipselink.core.context.EclipseLinkExpiryTimeOfDay;
import org.eclipse.jpt.eclipselink.core.context.EclipseLinkObjectTypeConverter;
import org.eclipse.jpt.eclipselink.core.context.EclipseLinkStructConverter;
import org.eclipse.jpt.eclipselink.core.context.EclipseLinkTypeConverter;
import org.eclipse.jpt.eclipselink.core.context.java.JavaEclipseLinkCaching;
import org.eclipse.jpt.eclipselink.core.context.java.JavaEclipseLinkEntity;
import org.eclipse.jpt.eclipselink.core.context.orm.EclipseLinkConverterHolder;
import org.eclipse.jpt.eclipselink.core.context.orm.OrmEclipseLinkCaching;
import org.eclipse.jpt.eclipselink.core.context.orm.OrmEclipseLinkEntity;
import org.eclipse.jpt.eclipselink.core.internal.context.persistence.EclipseLinkPersistenceUnit;
import org.eclipse.jpt.eclipselink.core.resource.orm.CacheCoordinationType;
import org.eclipse.jpt.eclipselink.core.resource.orm.CacheType;
import org.eclipse.jpt.eclipselink.core.resource.orm.EclipseLinkOrmFactory;
import org.eclipse.jpt.eclipselink.core.resource.orm.ExistenceType;
import org.eclipse.jpt.eclipselink.core.resource.orm.XmlChangeTrackingType;
import org.eclipse.jpt.eclipselink.core.resource.orm.XmlConverter;
import org.eclipse.jpt.eclipselink.core.resource.orm.XmlEntity;
import org.eclipse.jpt.eclipselink.core.resource.orm.XmlObjectTypeConverter;
import org.eclipse.jpt.eclipselink.core.resource.orm.XmlStructConverter;
import org.eclipse.jpt.eclipselink.core.resource.orm.XmlTypeConverter;
import org.eclipse.jpt.eclipselink.core.tests.internal.context.orm.EclipseLinkOrmContextModelTestCase;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.jpt.utility.internal.iterators.ArrayIterator;

public class EclipseLinkOrmEntityTests
extends EclipseLinkOrmContextModelTestCase {
    public EclipseLinkOrmEntityTests(String name) {
        super(name);
    }

    private ICompilationUnit createTestEntityForReadOnly() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "org.eclipse.persistence.annotations.ReadOnly"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }
        });
    }

    private ICompilationUnit createTestEntityForCustomizer() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "org.eclipse.persistence.annotations.Customizer"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }
        });
    }

    private ICompilationUnit createTestEntityForChangeTracking() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "org.eclipse.persistence.annotations.ChangeTracking"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }
        });
    }

    private ICompilationUnit createTestEntityForCaching() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }
        });
    }

    private ICompilationUnit createTestEntityForConverters() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }
        });
    }

    private ICompilationUnit createTestEntityForTypeConverters() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }
        });
    }

    private ICompilationUnit createTestEntityForObjectTypeConverters() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }
        });
    }

    private ICompilationUnit createTestEntityForStructConverters() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }
        });
    }

    public void testUpdateReadOnly() throws Exception {
        this.createTestEntityForReadOnly();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        JavaEclipseLinkEntity javaContextEntity = (JavaEclipseLinkEntity)ormPersistentType.getJavaPersistentType().getMapping();
        OrmEclipseLinkEntity ormContextEntity = (OrmEclipseLinkEntity)ormPersistentType.getMapping();
        XmlEntity resourceEntity = (XmlEntity)this.getXmlEntityMappings().getEntities().get(0);
        EclipseLinkOrmEntityTests.assertNull((Object)resourceEntity.getReadOnly());
        EclipseLinkOrmEntityTests.assertFalse((boolean)javaContextEntity.getReadOnly().isReadOnly());
        EclipseLinkOrmEntityTests.assertFalse((boolean)ormContextEntity.getReadOnly().isReadOnly());
        EclipseLinkOrmEntityTests.assertFalse((boolean)ormContextEntity.getReadOnly().isDefaultReadOnly());
        EclipseLinkOrmEntityTests.assertNull((Object)ormContextEntity.getReadOnly().getSpecifiedReadOnly());
        resourceEntity.setReadOnly(Boolean.FALSE);
        EclipseLinkOrmEntityTests.assertEquals((Object)Boolean.FALSE, (Object)resourceEntity.getReadOnly());
        EclipseLinkOrmEntityTests.assertFalse((boolean)javaContextEntity.getReadOnly().isReadOnly());
        EclipseLinkOrmEntityTests.assertFalse((boolean)ormContextEntity.getReadOnly().isReadOnly());
        EclipseLinkOrmEntityTests.assertFalse((boolean)ormContextEntity.getReadOnly().isDefaultReadOnly());
        EclipseLinkOrmEntityTests.assertEquals((Object)Boolean.FALSE, (Object)ormContextEntity.getReadOnly().getSpecifiedReadOnly());
        resourceEntity.setReadOnly(Boolean.TRUE);
        EclipseLinkOrmEntityTests.assertEquals((Object)Boolean.TRUE, (Object)resourceEntity.getReadOnly());
        EclipseLinkOrmEntityTests.assertFalse((boolean)javaContextEntity.getReadOnly().isReadOnly());
        EclipseLinkOrmEntityTests.assertTrue((boolean)ormContextEntity.getReadOnly().isReadOnly());
        EclipseLinkOrmEntityTests.assertFalse((boolean)ormContextEntity.getReadOnly().isDefaultReadOnly());
        EclipseLinkOrmEntityTests.assertEquals((Object)Boolean.TRUE, (Object)ormContextEntity.getReadOnly().getSpecifiedReadOnly());
        resourceEntity.setReadOnly(null);
        javaContextEntity.getReadOnly().setSpecifiedReadOnly(Boolean.TRUE);
        EclipseLinkOrmEntityTests.assertNull((Object)resourceEntity.getReadOnly());
        EclipseLinkOrmEntityTests.assertTrue((boolean)javaContextEntity.getReadOnly().isReadOnly());
        EclipseLinkOrmEntityTests.assertTrue((boolean)ormContextEntity.getReadOnly().isReadOnly());
        EclipseLinkOrmEntityTests.assertTrue((boolean)ormContextEntity.getReadOnly().isDefaultReadOnly());
        EclipseLinkOrmEntityTests.assertNull((Object)ormContextEntity.getReadOnly().getSpecifiedReadOnly());
        ormContextEntity.setSpecifiedMetadataComplete(Boolean.TRUE);
        EclipseLinkOrmEntityTests.assertNull((Object)resourceEntity.getReadOnly());
        EclipseLinkOrmEntityTests.assertTrue((boolean)javaContextEntity.getReadOnly().isReadOnly());
        EclipseLinkOrmEntityTests.assertFalse((boolean)ormContextEntity.getReadOnly().isReadOnly());
        EclipseLinkOrmEntityTests.assertFalse((boolean)ormContextEntity.getReadOnly().isDefaultReadOnly());
        EclipseLinkOrmEntityTests.assertNull((Object)ormContextEntity.getReadOnly().getSpecifiedReadOnly());
        ormContextEntity.setSpecifiedMetadataComplete(null);
        resourceEntity.setReadOnly(Boolean.FALSE);
        EclipseLinkOrmEntityTests.assertEquals((Object)Boolean.FALSE, (Object)resourceEntity.getReadOnly());
        EclipseLinkOrmEntityTests.assertTrue((boolean)javaContextEntity.getReadOnly().isReadOnly());
        EclipseLinkOrmEntityTests.assertFalse((boolean)ormContextEntity.getReadOnly().isReadOnly());
        EclipseLinkOrmEntityTests.assertTrue((boolean)ormContextEntity.getReadOnly().isDefaultReadOnly());
        EclipseLinkOrmEntityTests.assertEquals((Object)Boolean.FALSE, (Object)ormContextEntity.getReadOnly().getSpecifiedReadOnly());
        resourceEntity.setReadOnly(Boolean.TRUE);
        EclipseLinkOrmEntityTests.assertEquals((Object)Boolean.TRUE, (Object)resourceEntity.getReadOnly());
        EclipseLinkOrmEntityTests.assertTrue((boolean)javaContextEntity.getReadOnly().isReadOnly());
        EclipseLinkOrmEntityTests.assertTrue((boolean)ormContextEntity.getReadOnly().isReadOnly());
        EclipseLinkOrmEntityTests.assertTrue((boolean)ormContextEntity.getReadOnly().isDefaultReadOnly());
        EclipseLinkOrmEntityTests.assertEquals((Object)Boolean.TRUE, (Object)ormContextEntity.getReadOnly().getSpecifiedReadOnly());
        resourceEntity.setReadOnly(null);
        javaContextEntity.getReadOnly().setSpecifiedReadOnly(Boolean.FALSE);
        EclipseLinkOrmEntityTests.assertNull((Object)resourceEntity.getReadOnly());
        EclipseLinkOrmEntityTests.assertFalse((boolean)javaContextEntity.getReadOnly().isReadOnly());
        EclipseLinkOrmEntityTests.assertFalse((boolean)ormContextEntity.getReadOnly().isReadOnly());
        EclipseLinkOrmEntityTests.assertFalse((boolean)ormContextEntity.getReadOnly().isDefaultReadOnly());
        EclipseLinkOrmEntityTests.assertNull((Object)ormContextEntity.getReadOnly().getSpecifiedReadOnly());
        resourceEntity.setReadOnly(Boolean.FALSE);
        EclipseLinkOrmEntityTests.assertEquals((Object)Boolean.FALSE, (Object)resourceEntity.getReadOnly());
        EclipseLinkOrmEntityTests.assertFalse((boolean)javaContextEntity.getReadOnly().isReadOnly());
        EclipseLinkOrmEntityTests.assertFalse((boolean)ormContextEntity.getReadOnly().isReadOnly());
        EclipseLinkOrmEntityTests.assertFalse((boolean)ormContextEntity.getReadOnly().isDefaultReadOnly());
        EclipseLinkOrmEntityTests.assertEquals((Object)Boolean.FALSE, (Object)ormContextEntity.getReadOnly().getSpecifiedReadOnly());
        resourceEntity.setReadOnly(Boolean.TRUE);
        EclipseLinkOrmEntityTests.assertEquals((Object)Boolean.TRUE, (Object)resourceEntity.getReadOnly());
        EclipseLinkOrmEntityTests.assertFalse((boolean)javaContextEntity.getReadOnly().isReadOnly());
        EclipseLinkOrmEntityTests.assertTrue((boolean)ormContextEntity.getReadOnly().isReadOnly());
        EclipseLinkOrmEntityTests.assertFalse((boolean)ormContextEntity.getReadOnly().isDefaultReadOnly());
        EclipseLinkOrmEntityTests.assertEquals((Object)Boolean.TRUE, (Object)ormContextEntity.getReadOnly().getSpecifiedReadOnly());
    }

    public void testModifyReadOnly() throws Exception {
        this.createTestEntityForReadOnly();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmEclipseLinkEntity ormContextEntity = (OrmEclipseLinkEntity)ormPersistentType.getMapping();
        XmlEntity resourceEntity = (XmlEntity)this.getXmlEntityMappings().getEntities().get(0);
        EclipseLinkOrmEntityTests.assertNull((Object)resourceEntity.getReadOnly());
        EclipseLinkOrmEntityTests.assertFalse((boolean)ormContextEntity.getReadOnly().isReadOnly());
        EclipseLinkOrmEntityTests.assertFalse((boolean)ormContextEntity.getReadOnly().isDefaultReadOnly());
        EclipseLinkOrmEntityTests.assertNull((Object)ormContextEntity.getReadOnly().getSpecifiedReadOnly());
        ormContextEntity.getReadOnly().setSpecifiedReadOnly(Boolean.TRUE);
        EclipseLinkOrmEntityTests.assertEquals((Object)Boolean.TRUE, (Object)resourceEntity.getReadOnly());
        EclipseLinkOrmEntityTests.assertTrue((boolean)ormContextEntity.getReadOnly().isReadOnly());
        EclipseLinkOrmEntityTests.assertFalse((boolean)ormContextEntity.getReadOnly().isDefaultReadOnly());
        EclipseLinkOrmEntityTests.assertEquals((Object)Boolean.TRUE, (Object)ormContextEntity.getReadOnly().getSpecifiedReadOnly());
        ormContextEntity.getReadOnly().setSpecifiedReadOnly(Boolean.FALSE);
        EclipseLinkOrmEntityTests.assertEquals((Object)Boolean.FALSE, (Object)resourceEntity.getReadOnly());
        EclipseLinkOrmEntityTests.assertFalse((boolean)ormContextEntity.getReadOnly().isReadOnly());
        EclipseLinkOrmEntityTests.assertFalse((boolean)ormContextEntity.getReadOnly().isDefaultReadOnly());
        EclipseLinkOrmEntityTests.assertEquals((Object)Boolean.FALSE, (Object)ormContextEntity.getReadOnly().getSpecifiedReadOnly());
        ormContextEntity.getReadOnly().setSpecifiedReadOnly(null);
        EclipseLinkOrmEntityTests.assertNull((Object)resourceEntity.getReadOnly());
        EclipseLinkOrmEntityTests.assertFalse((boolean)ormContextEntity.getReadOnly().isReadOnly());
        EclipseLinkOrmEntityTests.assertFalse((boolean)ormContextEntity.getReadOnly().isDefaultReadOnly());
        EclipseLinkOrmEntityTests.assertNull((Object)ormContextEntity.getReadOnly().getSpecifiedReadOnly());
    }

    public void testUpdateCustomizerClass() throws Exception {
        this.createTestEntityForCustomizer();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        JavaEclipseLinkEntity javaContextEntity = (JavaEclipseLinkEntity)ormPersistentType.getJavaPersistentType().getMapping();
        OrmEclipseLinkEntity ormContextEntity = (OrmEclipseLinkEntity)ormPersistentType.getMapping();
        XmlEntity resourceEntity = (XmlEntity)this.getXmlEntityMappings().getEntities().get(0);
        EclipseLinkOrmEntityTests.assertNull((Object)resourceEntity.getCustomizer());
        EclipseLinkOrmEntityTests.assertNull((Object)javaContextEntity.getCustomizer().getCustomizerClass());
        EclipseLinkOrmEntityTests.assertNull((Object)ormContextEntity.getCustomizer().getCustomizerClass());
        EclipseLinkOrmEntityTests.assertNull((Object)ormContextEntity.getCustomizer().getDefaultCustomizerClass());
        EclipseLinkOrmEntityTests.assertNull((Object)ormContextEntity.getCustomizer().getSpecifiedCustomizerClass());
        resourceEntity.setCustomizer(OrmFactory.eINSTANCE.createXmlClassReference());
        EclipseLinkOrmEntityTests.assertNull((Object)resourceEntity.getCustomizer().getClassName());
        EclipseLinkOrmEntityTests.assertNull((Object)javaContextEntity.getCustomizer().getCustomizerClass());
        EclipseLinkOrmEntityTests.assertNull((Object)ormContextEntity.getCustomizer().getCustomizerClass());
        EclipseLinkOrmEntityTests.assertNull((Object)ormContextEntity.getCustomizer().getDefaultCustomizerClass());
        EclipseLinkOrmEntityTests.assertNull((Object)ormContextEntity.getCustomizer().getSpecifiedCustomizerClass());
        resourceEntity.getCustomizer().setClassName("foo");
        EclipseLinkOrmEntityTests.assertEquals((String)"foo", (String)resourceEntity.getCustomizer().getClassName());
        EclipseLinkOrmEntityTests.assertNull((Object)javaContextEntity.getCustomizer().getCustomizerClass());
        EclipseLinkOrmEntityTests.assertEquals((String)"foo", (String)ormContextEntity.getCustomizer().getCustomizerClass());
        EclipseLinkOrmEntityTests.assertNull((Object)ormContextEntity.getCustomizer().getDefaultCustomizerClass());
        EclipseLinkOrmEntityTests.assertEquals((String)"foo", (String)ormContextEntity.getCustomizer().getSpecifiedCustomizerClass());
        resourceEntity.getCustomizer().setClassName(null);
        javaContextEntity.getCustomizer().setSpecifiedCustomizerClass("bar");
        EclipseLinkOrmEntityTests.assertNull((Object)resourceEntity.getCustomizer().getClassName());
        EclipseLinkOrmEntityTests.assertEquals((String)"bar", (String)javaContextEntity.getCustomizer().getCustomizerClass());
        EclipseLinkOrmEntityTests.assertEquals((String)"bar", (String)ormContextEntity.getCustomizer().getCustomizerClass());
        EclipseLinkOrmEntityTests.assertEquals((String)"bar", (String)ormContextEntity.getCustomizer().getDefaultCustomizerClass());
        EclipseLinkOrmEntityTests.assertNull((Object)ormContextEntity.getCustomizer().getSpecifiedCustomizerClass());
        ormContextEntity.setSpecifiedMetadataComplete(Boolean.TRUE);
        EclipseLinkOrmEntityTests.assertNull((Object)resourceEntity.getCustomizer().getClassName());
        EclipseLinkOrmEntityTests.assertEquals((String)"bar", (String)javaContextEntity.getCustomizer().getCustomizerClass());
        EclipseLinkOrmEntityTests.assertNull((Object)ormContextEntity.getCustomizer().getCustomizerClass());
        EclipseLinkOrmEntityTests.assertNull((Object)ormContextEntity.getCustomizer().getDefaultCustomizerClass());
        EclipseLinkOrmEntityTests.assertNull((Object)ormContextEntity.getCustomizer().getSpecifiedCustomizerClass());
        ormContextEntity.setSpecifiedMetadataComplete(null);
        resourceEntity.getCustomizer().setClassName("foo");
        EclipseLinkOrmEntityTests.assertEquals((String)"foo", (String)resourceEntity.getCustomizer().getClassName());
        EclipseLinkOrmEntityTests.assertEquals((String)"bar", (String)javaContextEntity.getCustomizer().getCustomizerClass());
        EclipseLinkOrmEntityTests.assertEquals((String)"foo", (String)ormContextEntity.getCustomizer().getCustomizerClass());
        EclipseLinkOrmEntityTests.assertEquals((String)"bar", (String)ormContextEntity.getCustomizer().getDefaultCustomizerClass());
        EclipseLinkOrmEntityTests.assertEquals((String)"foo", (String)ormContextEntity.getCustomizer().getSpecifiedCustomizerClass());
        javaContextEntity.getCustomizer().setSpecifiedCustomizerClass(null);
        resourceEntity.setCustomizer(null);
        EclipseLinkOrmEntityTests.assertNull((Object)resourceEntity.getCustomizer());
        EclipseLinkOrmEntityTests.assertNull((Object)javaContextEntity.getCustomizer().getCustomizerClass());
        EclipseLinkOrmEntityTests.assertNull((Object)ormContextEntity.getCustomizer().getCustomizerClass());
        EclipseLinkOrmEntityTests.assertNull((Object)ormContextEntity.getCustomizer().getDefaultCustomizerClass());
        EclipseLinkOrmEntityTests.assertNull((Object)ormContextEntity.getCustomizer().getSpecifiedCustomizerClass());
    }

    public void testModifyCustomizerClass() throws Exception {
        this.createTestEntityForCustomizer();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmEclipseLinkEntity ormContextEntity = (OrmEclipseLinkEntity)ormPersistentType.getMapping();
        XmlEntity resourceEntity = (XmlEntity)this.getXmlEntityMappings().getEntities().get(0);
        EclipseLinkOrmEntityTests.assertNull((Object)resourceEntity.getCustomizer());
        EclipseLinkOrmEntityTests.assertNull((Object)ormContextEntity.getCustomizer().getCustomizerClass());
        EclipseLinkOrmEntityTests.assertNull((Object)ormContextEntity.getCustomizer().getDefaultCustomizerClass());
        EclipseLinkOrmEntityTests.assertNull((Object)ormContextEntity.getCustomizer().getSpecifiedCustomizerClass());
        ormContextEntity.getCustomizer().setSpecifiedCustomizerClass("foo");
        EclipseLinkOrmEntityTests.assertEquals((String)"foo", (String)resourceEntity.getCustomizer().getClassName());
        EclipseLinkOrmEntityTests.assertEquals((String)"foo", (String)ormContextEntity.getCustomizer().getCustomizerClass());
        EclipseLinkOrmEntityTests.assertNull((Object)ormContextEntity.getCustomizer().getDefaultCustomizerClass());
        EclipseLinkOrmEntityTests.assertEquals((String)"foo", (String)ormContextEntity.getCustomizer().getSpecifiedCustomizerClass());
        ormContextEntity.getCustomizer().setSpecifiedCustomizerClass(null);
        EclipseLinkOrmEntityTests.assertNull((Object)resourceEntity.getCustomizer());
        EclipseLinkOrmEntityTests.assertNull((Object)ormContextEntity.getCustomizer().getCustomizerClass());
        EclipseLinkOrmEntityTests.assertNull((Object)ormContextEntity.getCustomizer().getDefaultCustomizerClass());
        EclipseLinkOrmEntityTests.assertNull((Object)ormContextEntity.getCustomizer().getSpecifiedCustomizerClass());
    }

    public void testUpdateChangeTracking() throws Exception {
        this.createTestEntityForChangeTracking();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        JavaEclipseLinkEntity javaContextEntity = (JavaEclipseLinkEntity)ormPersistentType.getJavaPersistentType().getMapping();
        OrmEclipseLinkEntity ormContextEntity = (OrmEclipseLinkEntity)ormPersistentType.getMapping();
        XmlEntity resourceEntity = (XmlEntity)this.getXmlEntityMappings().getEntities().get(0);
        EclipseLinkOrmEntityTests.assertNull((Object)resourceEntity.getChangeTracking());
        EclipseLinkOrmEntityTests.assertEquals((Object)EclipseLinkChangeTrackingType.AUTO, (Object)javaContextEntity.getChangeTracking().getType());
        EclipseLinkOrmEntityTests.assertEquals((Object)EclipseLinkChangeTrackingType.AUTO, (Object)ormContextEntity.getChangeTracking().getType());
        EclipseLinkOrmEntityTests.assertEquals((Object)EclipseLinkChangeTrackingType.AUTO, (Object)ormContextEntity.getChangeTracking().getDefaultType());
        EclipseLinkOrmEntityTests.assertNull((Object)ormContextEntity.getChangeTracking().getSpecifiedType());
        resourceEntity.setChangeTracking(EclipseLinkOrmFactory.eINSTANCE.createXmlChangeTracking());
        resourceEntity.getChangeTracking().setType(XmlChangeTrackingType.ATTRIBUTE);
        EclipseLinkOrmEntityTests.assertEquals((Object)XmlChangeTrackingType.ATTRIBUTE, (Object)resourceEntity.getChangeTracking().getType());
        EclipseLinkOrmEntityTests.assertEquals((Object)EclipseLinkChangeTrackingType.AUTO, (Object)javaContextEntity.getChangeTracking().getType());
        EclipseLinkOrmEntityTests.assertEquals((Object)EclipseLinkChangeTrackingType.ATTRIBUTE, (Object)ormContextEntity.getChangeTracking().getType());
        EclipseLinkOrmEntityTests.assertEquals((Object)EclipseLinkChangeTrackingType.AUTO, (Object)ormContextEntity.getChangeTracking().getDefaultType());
        EclipseLinkOrmEntityTests.assertEquals((Object)EclipseLinkChangeTrackingType.ATTRIBUTE, (Object)ormContextEntity.getChangeTracking().getSpecifiedType());
        resourceEntity.getChangeTracking().setType(XmlChangeTrackingType.OBJECT);
        EclipseLinkOrmEntityTests.assertEquals((Object)XmlChangeTrackingType.OBJECT, (Object)resourceEntity.getChangeTracking().getType());
        EclipseLinkOrmEntityTests.assertEquals((Object)EclipseLinkChangeTrackingType.AUTO, (Object)javaContextEntity.getChangeTracking().getType());
        EclipseLinkOrmEntityTests.assertEquals((Object)EclipseLinkChangeTrackingType.OBJECT, (Object)ormContextEntity.getChangeTracking().getType());
        EclipseLinkOrmEntityTests.assertEquals((Object)EclipseLinkChangeTrackingType.AUTO, (Object)ormContextEntity.getChangeTracking().getDefaultType());
        EclipseLinkOrmEntityTests.assertEquals((Object)EclipseLinkChangeTrackingType.OBJECT, (Object)ormContextEntity.getChangeTracking().getSpecifiedType());
        resourceEntity.getChangeTracking().setType(XmlChangeTrackingType.DEFERRED);
        EclipseLinkOrmEntityTests.assertEquals((Object)XmlChangeTrackingType.DEFERRED, (Object)resourceEntity.getChangeTracking().getType());
        EclipseLinkOrmEntityTests.assertEquals((Object)EclipseLinkChangeTrackingType.AUTO, (Object)javaContextEntity.getChangeTracking().getType());
        EclipseLinkOrmEntityTests.assertEquals((Object)EclipseLinkChangeTrackingType.DEFERRED, (Object)ormContextEntity.getChangeTracking().getType());
        EclipseLinkOrmEntityTests.assertEquals((Object)EclipseLinkChangeTrackingType.AUTO, (Object)ormContextEntity.getChangeTracking().getDefaultType());
        EclipseLinkOrmEntityTests.assertEquals((Object)EclipseLinkChangeTrackingType.DEFERRED, (Object)ormContextEntity.getChangeTracking().getSpecifiedType());
        resourceEntity.getChangeTracking().setType(XmlChangeTrackingType.AUTO);
        EclipseLinkOrmEntityTests.assertEquals((Object)XmlChangeTrackingType.AUTO, (Object)resourceEntity.getChangeTracking().getType());
        EclipseLinkOrmEntityTests.assertEquals((Object)EclipseLinkChangeTrackingType.AUTO, (Object)javaContextEntity.getChangeTracking().getType());
        EclipseLinkOrmEntityTests.assertEquals((Object)EclipseLinkChangeTrackingType.AUTO, (Object)ormContextEntity.getChangeTracking().getType());
        EclipseLinkOrmEntityTests.assertEquals((Object)EclipseLinkChangeTrackingType.AUTO, (Object)ormContextEntity.getChangeTracking().getDefaultType());
        EclipseLinkOrmEntityTests.assertEquals((Object)EclipseLinkChangeTrackingType.AUTO, (Object)ormContextEntity.getChangeTracking().getSpecifiedType());
        resourceEntity.setChangeTracking(null);
        javaContextEntity.getChangeTracking().setSpecifiedType(EclipseLinkChangeTrackingType.ATTRIBUTE);
        EclipseLinkOrmEntityTests.assertNull((Object)resourceEntity.getChangeTracking());
        EclipseLinkOrmEntityTests.assertEquals((Object)EclipseLinkChangeTrackingType.ATTRIBUTE, (Object)javaContextEntity.getChangeTracking().getType());
        EclipseLinkOrmEntityTests.assertEquals((Object)EclipseLinkChangeTrackingType.ATTRIBUTE, (Object)ormContextEntity.getChangeTracking().getType());
        EclipseLinkOrmEntityTests.assertEquals((Object)EclipseLinkChangeTrackingType.ATTRIBUTE, (Object)ormContextEntity.getChangeTracking().getDefaultType());
        EclipseLinkOrmEntityTests.assertNull((Object)ormContextEntity.getChangeTracking().getSpecifiedType());
        ormContextEntity.setSpecifiedMetadataComplete(Boolean.TRUE);
        EclipseLinkOrmEntityTests.assertNull((Object)resourceEntity.getChangeTracking());
        EclipseLinkOrmEntityTests.assertEquals((Object)EclipseLinkChangeTrackingType.ATTRIBUTE, (Object)javaContextEntity.getChangeTracking().getType());
        EclipseLinkOrmEntityTests.assertEquals((Object)EclipseLinkChangeTrackingType.AUTO, (Object)ormContextEntity.getChangeTracking().getType());
        EclipseLinkOrmEntityTests.assertEquals((Object)EclipseLinkChangeTrackingType.AUTO, (Object)ormContextEntity.getChangeTracking().getDefaultType());
        EclipseLinkOrmEntityTests.assertNull((Object)ormContextEntity.getChangeTracking().getSpecifiedType());
        ormContextEntity.setSpecifiedMetadataComplete(null);
        resourceEntity.setChangeTracking(EclipseLinkOrmFactory.eINSTANCE.createXmlChangeTracking());
        resourceEntity.getChangeTracking().setType(XmlChangeTrackingType.OBJECT);
        EclipseLinkOrmEntityTests.assertEquals((Object)XmlChangeTrackingType.OBJECT, (Object)resourceEntity.getChangeTracking().getType());
        EclipseLinkOrmEntityTests.assertEquals((Object)EclipseLinkChangeTrackingType.ATTRIBUTE, (Object)javaContextEntity.getChangeTracking().getType());
        EclipseLinkOrmEntityTests.assertEquals((Object)EclipseLinkChangeTrackingType.OBJECT, (Object)ormContextEntity.getChangeTracking().getType());
        EclipseLinkOrmEntityTests.assertEquals((Object)EclipseLinkChangeTrackingType.ATTRIBUTE, (Object)ormContextEntity.getChangeTracking().getDefaultType());
        EclipseLinkOrmEntityTests.assertEquals((Object)EclipseLinkChangeTrackingType.OBJECT, (Object)ormContextEntity.getChangeTracking().getSpecifiedType());
    }

    public void testModifyChangeTracking() throws Exception {
        this.createTestEntityForChangeTracking();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmEclipseLinkEntity ormContextEntity = (OrmEclipseLinkEntity)ormPersistentType.getMapping();
        XmlEntity resourceEntity = (XmlEntity)this.getXmlEntityMappings().getEntities().get(0);
        EclipseLinkOrmEntityTests.assertNull((Object)resourceEntity.getChangeTracking());
        EclipseLinkOrmEntityTests.assertEquals((Object)EclipseLinkChangeTrackingType.AUTO, (Object)ormContextEntity.getChangeTracking().getType());
        EclipseLinkOrmEntityTests.assertEquals((Object)EclipseLinkChangeTrackingType.AUTO, (Object)ormContextEntity.getChangeTracking().getDefaultType());
        EclipseLinkOrmEntityTests.assertNull((Object)ormContextEntity.getChangeTracking().getSpecifiedType());
        ormContextEntity.getChangeTracking().setSpecifiedType(EclipseLinkChangeTrackingType.ATTRIBUTE);
        EclipseLinkOrmEntityTests.assertEquals((Object)XmlChangeTrackingType.ATTRIBUTE, (Object)resourceEntity.getChangeTracking().getType());
        EclipseLinkOrmEntityTests.assertEquals((Object)EclipseLinkChangeTrackingType.ATTRIBUTE, (Object)ormContextEntity.getChangeTracking().getType());
        EclipseLinkOrmEntityTests.assertEquals((Object)EclipseLinkChangeTrackingType.AUTO, (Object)ormContextEntity.getChangeTracking().getDefaultType());
        EclipseLinkOrmEntityTests.assertEquals((Object)EclipseLinkChangeTrackingType.ATTRIBUTE, (Object)ormContextEntity.getChangeTracking().getSpecifiedType());
        ormContextEntity.getChangeTracking().setSpecifiedType(EclipseLinkChangeTrackingType.OBJECT);
        EclipseLinkOrmEntityTests.assertEquals((Object)XmlChangeTrackingType.OBJECT, (Object)resourceEntity.getChangeTracking().getType());
        EclipseLinkOrmEntityTests.assertEquals((Object)EclipseLinkChangeTrackingType.OBJECT, (Object)ormContextEntity.getChangeTracking().getType());
        EclipseLinkOrmEntityTests.assertEquals((Object)EclipseLinkChangeTrackingType.AUTO, (Object)ormContextEntity.getChangeTracking().getDefaultType());
        EclipseLinkOrmEntityTests.assertEquals((Object)EclipseLinkChangeTrackingType.OBJECT, (Object)ormContextEntity.getChangeTracking().getSpecifiedType());
        ormContextEntity.getChangeTracking().setSpecifiedType(EclipseLinkChangeTrackingType.DEFERRED);
        EclipseLinkOrmEntityTests.assertEquals((Object)XmlChangeTrackingType.DEFERRED, (Object)resourceEntity.getChangeTracking().getType());
        EclipseLinkOrmEntityTests.assertEquals((Object)EclipseLinkChangeTrackingType.DEFERRED, (Object)ormContextEntity.getChangeTracking().getType());
        EclipseLinkOrmEntityTests.assertEquals((Object)EclipseLinkChangeTrackingType.AUTO, (Object)ormContextEntity.getChangeTracking().getDefaultType());
        EclipseLinkOrmEntityTests.assertEquals((Object)EclipseLinkChangeTrackingType.DEFERRED, (Object)ormContextEntity.getChangeTracking().getSpecifiedType());
        ormContextEntity.getChangeTracking().setSpecifiedType(EclipseLinkChangeTrackingType.AUTO);
        EclipseLinkOrmEntityTests.assertEquals((Object)XmlChangeTrackingType.AUTO, (Object)resourceEntity.getChangeTracking().getType());
        EclipseLinkOrmEntityTests.assertEquals((Object)EclipseLinkChangeTrackingType.AUTO, (Object)ormContextEntity.getChangeTracking().getType());
        EclipseLinkOrmEntityTests.assertEquals((Object)EclipseLinkChangeTrackingType.AUTO, (Object)ormContextEntity.getChangeTracking().getDefaultType());
        EclipseLinkOrmEntityTests.assertEquals((Object)EclipseLinkChangeTrackingType.AUTO, (Object)ormContextEntity.getChangeTracking().getSpecifiedType());
        ormContextEntity.getChangeTracking().setSpecifiedType(null);
        EclipseLinkOrmEntityTests.assertNull((Object)resourceEntity.getChangeTracking());
        EclipseLinkOrmEntityTests.assertEquals((Object)EclipseLinkChangeTrackingType.AUTO, (Object)ormContextEntity.getChangeTracking().getType());
        EclipseLinkOrmEntityTests.assertEquals((Object)EclipseLinkChangeTrackingType.AUTO, (Object)ormContextEntity.getChangeTracking().getDefaultType());
        EclipseLinkOrmEntityTests.assertNull((Object)ormContextEntity.getChangeTracking().getSpecifiedType());
    }

    public void testUpdateCacheType() throws Exception {
        this.createTestEntityForCaching();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        JavaEclipseLinkCaching javaContextCaching = ((JavaEclipseLinkEntity)ormPersistentType.getJavaPersistentType().getMapping()).getCaching();
        OrmEclipseLinkEntity ormContextEntity = (OrmEclipseLinkEntity)ormPersistentType.getMapping();
        OrmEclipseLinkCaching ormContextCaching = ormContextEntity.getCaching();
        XmlEntity resourceEntity = (XmlEntity)this.getXmlEntityMappings().getEntities().get(0);
        EclipseLinkOrmEntityTests.assertEquals(null, (Object)resourceEntity.getCache());
        EclipseLinkOrmEntityTests.assertEquals((Object)EclipseLinkCacheType.SOFT_WEAK, (Object)javaContextCaching.getType());
        EclipseLinkOrmEntityTests.assertEquals((Object)EclipseLinkCacheType.SOFT_WEAK, (Object)ormContextCaching.getType());
        EclipseLinkOrmEntityTests.assertEquals((Object)EclipseLinkCacheType.SOFT_WEAK, (Object)ormContextCaching.getDefaultType());
        EclipseLinkOrmEntityTests.assertEquals(null, (Object)ormContextCaching.getSpecifiedType());
        resourceEntity.setCache(EclipseLinkOrmFactory.eINSTANCE.createXmlCache());
        EclipseLinkOrmEntityTests.assertEquals(null, (Object)resourceEntity.getCache().getType());
        EclipseLinkOrmEntityTests.assertEquals((Object)EclipseLinkCacheType.SOFT_WEAK, (Object)javaContextCaching.getType());
        EclipseLinkOrmEntityTests.assertEquals((Object)EclipseLinkCacheType.SOFT_WEAK, (Object)ormContextCaching.getType());
        EclipseLinkOrmEntityTests.assertEquals((Object)EclipseLinkCacheType.SOFT_WEAK, (Object)ormContextCaching.getDefaultType());
        EclipseLinkOrmEntityTests.assertEquals(null, (Object)ormContextCaching.getSpecifiedType());
        resourceEntity.getCache().setType(CacheType.FULL);
        EclipseLinkOrmEntityTests.assertEquals((Object)CacheType.FULL, (Object)resourceEntity.getCache().getType());
        EclipseLinkOrmEntityTests.assertEquals((Object)EclipseLinkCacheType.SOFT_WEAK, (Object)javaContextCaching.getType());
        EclipseLinkOrmEntityTests.assertEquals((Object)EclipseLinkCacheType.FULL, (Object)ormContextCaching.getType());
        EclipseLinkOrmEntityTests.assertEquals((Object)EclipseLinkCacheType.SOFT_WEAK, (Object)ormContextCaching.getDefaultType());
        EclipseLinkOrmEntityTests.assertEquals((Object)EclipseLinkCacheType.FULL, (Object)ormContextCaching.getSpecifiedType());
        javaContextCaching.setSpecifiedType(EclipseLinkCacheType.WEAK);
        EclipseLinkOrmEntityTests.assertEquals((Object)CacheType.FULL, (Object)resourceEntity.getCache().getType());
        EclipseLinkOrmEntityTests.assertEquals((Object)EclipseLinkCacheType.WEAK, (Object)javaContextCaching.getType());
        EclipseLinkOrmEntityTests.assertEquals((Object)EclipseLinkCacheType.FULL, (Object)ormContextCaching.getType());
        EclipseLinkOrmEntityTests.assertEquals((Object)EclipseLinkCacheType.SOFT_WEAK, (Object)ormContextCaching.getDefaultType());
        EclipseLinkOrmEntityTests.assertEquals((Object)EclipseLinkCacheType.FULL, (Object)ormContextCaching.getSpecifiedType());
        resourceEntity.getCache().setType(null);
        EclipseLinkOrmEntityTests.assertEquals(null, (Object)resourceEntity.getCache().getType());
        EclipseLinkOrmEntityTests.assertEquals((Object)EclipseLinkCacheType.WEAK, (Object)javaContextCaching.getType());
        EclipseLinkOrmEntityTests.assertEquals((Object)EclipseLinkCacheType.SOFT_WEAK, (Object)ormContextCaching.getType());
        EclipseLinkOrmEntityTests.assertEquals((Object)EclipseLinkCacheType.SOFT_WEAK, (Object)ormContextCaching.getDefaultType());
        EclipseLinkOrmEntityTests.assertEquals(null, (Object)ormContextCaching.getSpecifiedType());
        resourceEntity.setCache(null);
        EclipseLinkOrmEntityTests.assertEquals(null, (Object)resourceEntity.getCache());
        EclipseLinkOrmEntityTests.assertEquals((Object)EclipseLinkCacheType.WEAK, (Object)javaContextCaching.getType());
        EclipseLinkOrmEntityTests.assertEquals((Object)EclipseLinkCacheType.WEAK, (Object)ormContextCaching.getType());
        EclipseLinkOrmEntityTests.assertEquals((Object)EclipseLinkCacheType.WEAK, (Object)ormContextCaching.getDefaultType());
        EclipseLinkOrmEntityTests.assertEquals(null, (Object)ormContextCaching.getSpecifiedType());
        ormContextEntity.setSpecifiedMetadataComplete(Boolean.TRUE);
        EclipseLinkOrmEntityTests.assertEquals(null, (Object)resourceEntity.getCache());
        EclipseLinkOrmEntityTests.assertEquals((Object)EclipseLinkCacheType.WEAK, (Object)javaContextCaching.getType());
        EclipseLinkOrmEntityTests.assertEquals((Object)EclipseLinkCacheType.SOFT_WEAK, (Object)ormContextCaching.getType());
        EclipseLinkOrmEntityTests.assertEquals((Object)EclipseLinkCacheType.SOFT_WEAK, (Object)ormContextCaching.getDefaultType());
        EclipseLinkOrmEntityTests.assertEquals(null, (Object)ormContextCaching.getSpecifiedType());
        ormContextEntity.setSpecifiedMetadataComplete(null);
    }

    public void testModifyCacheType() throws Exception {
        this.createTestEntityForCaching();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmEclipseLinkEntity ormContextEntity = (OrmEclipseLinkEntity)ormPersistentType.getMapping();
        OrmEclipseLinkCaching ormContextCaching = ormContextEntity.getCaching();
        XmlEntity resourceEntity = (XmlEntity)this.getXmlEntityMappings().getEntities().get(0);
        EclipseLinkOrmEntityTests.assertEquals(null, (Object)resourceEntity.getCache());
        EclipseLinkOrmEntityTests.assertEquals((Object)EclipseLinkCacheType.SOFT_WEAK, (Object)ormContextCaching.getType());
        EclipseLinkOrmEntityTests.assertEquals((Object)EclipseLinkCacheType.SOFT_WEAK, (Object)ormContextCaching.getDefaultType());
        EclipseLinkOrmEntityTests.assertEquals(null, (Object)ormContextCaching.getSpecifiedType());
        ormContextEntity.getCaching().setSpecifiedType(EclipseLinkCacheType.HARD_WEAK);
        EclipseLinkOrmEntityTests.assertEquals((Object)CacheType.HARD_WEAK, (Object)resourceEntity.getCache().getType());
        EclipseLinkOrmEntityTests.assertEquals((Object)EclipseLinkCacheType.HARD_WEAK, (Object)ormContextCaching.getType());
        EclipseLinkOrmEntityTests.assertEquals((Object)EclipseLinkCacheType.SOFT_WEAK, (Object)ormContextCaching.getDefaultType());
        EclipseLinkOrmEntityTests.assertEquals((Object)EclipseLinkCacheType.HARD_WEAK, (Object)ormContextCaching.getSpecifiedType());
        ormContextEntity.getCaching().setSpecifiedType(null);
        EclipseLinkOrmEntityTests.assertEquals(null, (Object)resourceEntity.getCache());
        EclipseLinkOrmEntityTests.assertEquals((Object)EclipseLinkCacheType.SOFT_WEAK, (Object)ormContextCaching.getType());
        EclipseLinkOrmEntityTests.assertEquals((Object)EclipseLinkCacheType.SOFT_WEAK, (Object)ormContextCaching.getDefaultType());
        EclipseLinkOrmEntityTests.assertEquals(null, (Object)ormContextCaching.getSpecifiedType());
    }

    public void testUpdateCacheCoordinationType() throws Exception {
        this.createTestEntityForCaching();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        JavaEclipseLinkCaching javaContextCaching = ((JavaEclipseLinkEntity)ormPersistentType.getJavaPersistentType().getMapping()).getCaching();
        OrmEclipseLinkEntity ormContextEntity = (OrmEclipseLinkEntity)ormPersistentType.getMapping();
        OrmEclipseLinkCaching ormContextCaching = ormContextEntity.getCaching();
        XmlEntity resourceEntity = (XmlEntity)this.getXmlEntityMappings().getEntities().get(0);
        EclipseLinkOrmEntityTests.assertEquals(null, (Object)resourceEntity.getCache());
        EclipseLinkOrmEntityTests.assertEquals((Object)EclipseLinkCacheCoordinationType.SEND_OBJECT_CHANGES, (Object)javaContextCaching.getCoordinationType());
        EclipseLinkOrmEntityTests.assertEquals((Object)EclipseLinkCacheCoordinationType.SEND_OBJECT_CHANGES, (Object)ormContextCaching.getCoordinationType());
        EclipseLinkOrmEntityTests.assertEquals((Object)EclipseLinkCacheCoordinationType.SEND_OBJECT_CHANGES, (Object)ormContextCaching.getDefaultCoordinationType());
        EclipseLinkOrmEntityTests.assertEquals(null, (Object)ormContextCaching.getSpecifiedCoordinationType());
        resourceEntity.setCache(EclipseLinkOrmFactory.eINSTANCE.createXmlCache());
        EclipseLinkOrmEntityTests.assertEquals(null, (Object)resourceEntity.getCache().getCoordinationType());
        EclipseLinkOrmEntityTests.assertEquals((Object)EclipseLinkCacheCoordinationType.SEND_OBJECT_CHANGES, (Object)javaContextCaching.getCoordinationType());
        EclipseLinkOrmEntityTests.assertEquals((Object)EclipseLinkCacheCoordinationType.SEND_OBJECT_CHANGES, (Object)ormContextCaching.getCoordinationType());
        EclipseLinkOrmEntityTests.assertEquals((Object)EclipseLinkCacheCoordinationType.SEND_OBJECT_CHANGES, (Object)ormContextCaching.getDefaultCoordinationType());
        EclipseLinkOrmEntityTests.assertEquals(null, (Object)ormContextCaching.getSpecifiedCoordinationType());
        resourceEntity.getCache().setCoordinationType(CacheCoordinationType.INVALIDATE_CHANGED_OBJECTS);
        EclipseLinkOrmEntityTests.assertEquals((Object)CacheCoordinationType.INVALIDATE_CHANGED_OBJECTS, (Object)resourceEntity.getCache().getCoordinationType());
        EclipseLinkOrmEntityTests.assertEquals((Object)EclipseLinkCacheCoordinationType.SEND_OBJECT_CHANGES, (Object)javaContextCaching.getCoordinationType());
        EclipseLinkOrmEntityTests.assertEquals((Object)EclipseLinkCacheCoordinationType.INVALIDATE_CHANGED_OBJECTS, (Object)ormContextCaching.getCoordinationType());
        EclipseLinkOrmEntityTests.assertEquals((Object)EclipseLinkCacheCoordinationType.SEND_OBJECT_CHANGES, (Object)ormContextCaching.getDefaultCoordinationType());
        EclipseLinkOrmEntityTests.assertEquals((Object)EclipseLinkCacheCoordinationType.INVALIDATE_CHANGED_OBJECTS, (Object)ormContextCaching.getSpecifiedCoordinationType());
        javaContextCaching.setSpecifiedCoordinationType(EclipseLinkCacheCoordinationType.SEND_NEW_OBJECTS_WITH_CHANGES);
        EclipseLinkOrmEntityTests.assertEquals((Object)CacheCoordinationType.INVALIDATE_CHANGED_OBJECTS, (Object)resourceEntity.getCache().getCoordinationType());
        EclipseLinkOrmEntityTests.assertEquals((Object)EclipseLinkCacheCoordinationType.SEND_NEW_OBJECTS_WITH_CHANGES, (Object)javaContextCaching.getCoordinationType());
        EclipseLinkOrmEntityTests.assertEquals((Object)EclipseLinkCacheCoordinationType.INVALIDATE_CHANGED_OBJECTS, (Object)ormContextCaching.getCoordinationType());
        EclipseLinkOrmEntityTests.assertEquals((Object)EclipseLinkCacheCoordinationType.SEND_OBJECT_CHANGES, (Object)ormContextCaching.getDefaultCoordinationType());
        EclipseLinkOrmEntityTests.assertEquals((Object)EclipseLinkCacheCoordinationType.INVALIDATE_CHANGED_OBJECTS, (Object)ormContextCaching.getSpecifiedCoordinationType());
        resourceEntity.getCache().setCoordinationType(null);
        EclipseLinkOrmEntityTests.assertEquals(null, (Object)resourceEntity.getCache().getCoordinationType());
        EclipseLinkOrmEntityTests.assertEquals((Object)EclipseLinkCacheCoordinationType.SEND_NEW_OBJECTS_WITH_CHANGES, (Object)javaContextCaching.getCoordinationType());
        EclipseLinkOrmEntityTests.assertEquals((Object)EclipseLinkCacheCoordinationType.SEND_OBJECT_CHANGES, (Object)ormContextCaching.getCoordinationType());
        EclipseLinkOrmEntityTests.assertEquals((Object)EclipseLinkCacheCoordinationType.SEND_OBJECT_CHANGES, (Object)ormContextCaching.getDefaultCoordinationType());
        EclipseLinkOrmEntityTests.assertEquals(null, (Object)ormContextCaching.getSpecifiedCoordinationType());
        resourceEntity.setCache(null);
        EclipseLinkOrmEntityTests.assertEquals(null, (Object)resourceEntity.getCache());
        EclipseLinkOrmEntityTests.assertEquals((Object)EclipseLinkCacheCoordinationType.SEND_NEW_OBJECTS_WITH_CHANGES, (Object)javaContextCaching.getCoordinationType());
        EclipseLinkOrmEntityTests.assertEquals((Object)EclipseLinkCacheCoordinationType.SEND_NEW_OBJECTS_WITH_CHANGES, (Object)ormContextCaching.getCoordinationType());
        EclipseLinkOrmEntityTests.assertEquals((Object)EclipseLinkCacheCoordinationType.SEND_NEW_OBJECTS_WITH_CHANGES, (Object)ormContextCaching.getDefaultCoordinationType());
        EclipseLinkOrmEntityTests.assertEquals(null, (Object)ormContextCaching.getSpecifiedCoordinationType());
        ormContextEntity.setSpecifiedMetadataComplete(Boolean.TRUE);
        EclipseLinkOrmEntityTests.assertEquals(null, (Object)resourceEntity.getCache());
        EclipseLinkOrmEntityTests.assertEquals((Object)EclipseLinkCacheCoordinationType.SEND_NEW_OBJECTS_WITH_CHANGES, (Object)javaContextCaching.getCoordinationType());
        EclipseLinkOrmEntityTests.assertEquals((Object)EclipseLinkCacheCoordinationType.SEND_OBJECT_CHANGES, (Object)ormContextCaching.getCoordinationType());
        EclipseLinkOrmEntityTests.assertEquals((Object)EclipseLinkCacheCoordinationType.SEND_OBJECT_CHANGES, (Object)ormContextCaching.getDefaultCoordinationType());
        EclipseLinkOrmEntityTests.assertEquals(null, (Object)ormContextCaching.getSpecifiedCoordinationType());
        ormContextEntity.setSpecifiedMetadataComplete(null);
    }

    public void testModifyCacheCoordinationType() throws Exception {
        this.createTestEntityForCaching();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmEclipseLinkEntity ormContextEntity = (OrmEclipseLinkEntity)ormPersistentType.getMapping();
        OrmEclipseLinkCaching ormContextCaching = ormContextEntity.getCaching();
        XmlEntity resourceEntity = (XmlEntity)this.getXmlEntityMappings().getEntities().get(0);
        EclipseLinkOrmEntityTests.assertEquals(null, (Object)resourceEntity.getCache());
        EclipseLinkOrmEntityTests.assertEquals((Object)EclipseLinkCacheCoordinationType.SEND_OBJECT_CHANGES, (Object)ormContextCaching.getCoordinationType());
        EclipseLinkOrmEntityTests.assertEquals((Object)EclipseLinkCacheCoordinationType.SEND_OBJECT_CHANGES, (Object)ormContextCaching.getDefaultCoordinationType());
        EclipseLinkOrmEntityTests.assertEquals(null, (Object)ormContextCaching.getSpecifiedCoordinationType());
        ormContextEntity.getCaching().setSpecifiedCoordinationType(EclipseLinkCacheCoordinationType.SEND_NEW_OBJECTS_WITH_CHANGES);
        EclipseLinkOrmEntityTests.assertEquals((Object)CacheCoordinationType.SEND_NEW_OBJECTS_WITH_CHANGES, (Object)resourceEntity.getCache().getCoordinationType());
        EclipseLinkOrmEntityTests.assertEquals((Object)EclipseLinkCacheCoordinationType.SEND_NEW_OBJECTS_WITH_CHANGES, (Object)ormContextCaching.getCoordinationType());
        EclipseLinkOrmEntityTests.assertEquals((Object)EclipseLinkCacheCoordinationType.SEND_OBJECT_CHANGES, (Object)ormContextCaching.getDefaultCoordinationType());
        EclipseLinkOrmEntityTests.assertEquals((Object)EclipseLinkCacheCoordinationType.SEND_NEW_OBJECTS_WITH_CHANGES, (Object)ormContextCaching.getSpecifiedCoordinationType());
        ormContextEntity.getCaching().setSpecifiedCoordinationType(null);
        EclipseLinkOrmEntityTests.assertEquals(null, (Object)resourceEntity.getCache());
        EclipseLinkOrmEntityTests.assertEquals((Object)EclipseLinkCacheCoordinationType.SEND_OBJECT_CHANGES, (Object)ormContextCaching.getCoordinationType());
        EclipseLinkOrmEntityTests.assertEquals((Object)EclipseLinkCacheCoordinationType.SEND_OBJECT_CHANGES, (Object)ormContextCaching.getDefaultCoordinationType());
        EclipseLinkOrmEntityTests.assertEquals(null, (Object)ormContextCaching.getSpecifiedCoordinationType());
    }

    public void testUpdateCacheSize() throws Exception {
        this.createTestEntityForCaching();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        JavaEclipseLinkCaching javaContextCaching = ((JavaEclipseLinkEntity)ormPersistentType.getJavaPersistentType().getMapping()).getCaching();
        OrmEclipseLinkEntity ormContextEntity = (OrmEclipseLinkEntity)ormPersistentType.getMapping();
        OrmEclipseLinkCaching ormContextCaching = ormContextEntity.getCaching();
        XmlEntity resourceEntity = (XmlEntity)this.getXmlEntityMappings().getEntities().get(0);
        EclipseLinkOrmEntityTests.assertEquals(null, (Object)resourceEntity.getCache());
        EclipseLinkOrmEntityTests.assertEquals((int)100, (int)javaContextCaching.getSize());
        EclipseLinkOrmEntityTests.assertEquals((int)100, (int)ormContextCaching.getSize());
        EclipseLinkOrmEntityTests.assertEquals((int)100, (int)ormContextCaching.getDefaultSize());
        EclipseLinkOrmEntityTests.assertEquals(null, (Object)ormContextCaching.getSpecifiedSize());
        resourceEntity.setCache(EclipseLinkOrmFactory.eINSTANCE.createXmlCache());
        EclipseLinkOrmEntityTests.assertEquals(null, (Object)resourceEntity.getCache().getSize());
        EclipseLinkOrmEntityTests.assertEquals((int)100, (int)javaContextCaching.getSize());
        EclipseLinkOrmEntityTests.assertEquals((int)100, (int)ormContextCaching.getSize());
        EclipseLinkOrmEntityTests.assertEquals((int)100, (int)ormContextCaching.getDefaultSize());
        EclipseLinkOrmEntityTests.assertEquals(null, (Object)ormContextCaching.getSpecifiedSize());
        resourceEntity.getCache().setSize(new Integer(105));
        EclipseLinkOrmEntityTests.assertEquals((Object)new Integer(105), (Object)resourceEntity.getCache().getSize());
        EclipseLinkOrmEntityTests.assertEquals((int)100, (int)javaContextCaching.getSize());
        EclipseLinkOrmEntityTests.assertEquals((int)105, (int)ormContextCaching.getSize());
        EclipseLinkOrmEntityTests.assertEquals((int)100, (int)ormContextCaching.getDefaultSize());
        EclipseLinkOrmEntityTests.assertEquals((Object)new Integer(105), (Object)ormContextCaching.getSpecifiedSize());
        javaContextCaching.setSpecifiedSize(new Integer(50));
        EclipseLinkOrmEntityTests.assertEquals((Object)new Integer(105), (Object)resourceEntity.getCache().getSize());
        EclipseLinkOrmEntityTests.assertEquals((int)50, (int)javaContextCaching.getSize());
        EclipseLinkOrmEntityTests.assertEquals((int)105, (int)ormContextCaching.getSize());
        EclipseLinkOrmEntityTests.assertEquals((int)50, (int)ormContextCaching.getDefaultSize());
        EclipseLinkOrmEntityTests.assertEquals((Object)new Integer(105), (Object)ormContextCaching.getSpecifiedSize());
        resourceEntity.getCache().setSize(null);
        EclipseLinkOrmEntityTests.assertEquals(null, (Object)resourceEntity.getCache().getSize());
        EclipseLinkOrmEntityTests.assertEquals((int)50, (int)javaContextCaching.getSize());
        EclipseLinkOrmEntityTests.assertEquals((int)50, (int)ormContextCaching.getSize());
        EclipseLinkOrmEntityTests.assertEquals((int)50, (int)ormContextCaching.getDefaultSize());
        EclipseLinkOrmEntityTests.assertEquals(null, (Object)ormContextCaching.getSpecifiedSize());
        resourceEntity.setCache(null);
        EclipseLinkOrmEntityTests.assertEquals(null, (Object)resourceEntity.getCache());
        EclipseLinkOrmEntityTests.assertEquals((int)50, (int)javaContextCaching.getSize());
        EclipseLinkOrmEntityTests.assertEquals((int)50, (int)ormContextCaching.getSize());
        EclipseLinkOrmEntityTests.assertEquals((int)50, (int)ormContextCaching.getDefaultSize());
        EclipseLinkOrmEntityTests.assertEquals(null, (Object)ormContextCaching.getSpecifiedSize());
        ormContextEntity.setSpecifiedMetadataComplete(Boolean.TRUE);
        EclipseLinkOrmEntityTests.assertEquals(null, (Object)resourceEntity.getCache());
        EclipseLinkOrmEntityTests.assertEquals((int)50, (int)javaContextCaching.getSize());
        EclipseLinkOrmEntityTests.assertEquals((int)100, (int)ormContextCaching.getSize());
        EclipseLinkOrmEntityTests.assertEquals((int)100, (int)ormContextCaching.getDefaultSize());
        EclipseLinkOrmEntityTests.assertEquals(null, (Object)ormContextCaching.getSpecifiedSize());
        ormContextEntity.setSpecifiedMetadataComplete(null);
    }

    public void testModifyCacheSize() throws Exception {
        this.createTestEntityForCaching();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmEclipseLinkEntity ormContextEntity = (OrmEclipseLinkEntity)ormPersistentType.getMapping();
        OrmEclipseLinkCaching ormContextCaching = ormContextEntity.getCaching();
        XmlEntity resourceEntity = (XmlEntity)this.getXmlEntityMappings().getEntities().get(0);
        EclipseLinkOrmEntityTests.assertEquals(null, (Object)resourceEntity.getCache());
        EclipseLinkOrmEntityTests.assertEquals((int)100, (int)ormContextCaching.getSize());
        EclipseLinkOrmEntityTests.assertEquals((int)100, (int)ormContextCaching.getDefaultSize());
        EclipseLinkOrmEntityTests.assertEquals(null, (Object)ormContextCaching.getSpecifiedSize());
        ormContextEntity.getCaching().setSpecifiedSize(new Integer(50));
        EclipseLinkOrmEntityTests.assertEquals((Object)new Integer(50), (Object)resourceEntity.getCache().getSize());
        EclipseLinkOrmEntityTests.assertEquals((int)50, (int)ormContextCaching.getSize());
        EclipseLinkOrmEntityTests.assertEquals((int)100, (int)ormContextCaching.getDefaultSize());
        EclipseLinkOrmEntityTests.assertEquals((Object)new Integer(50), (Object)ormContextCaching.getSpecifiedSize());
        ormContextEntity.getCaching().setSpecifiedSize(null);
        EclipseLinkOrmEntityTests.assertEquals(null, (Object)resourceEntity.getCache());
        EclipseLinkOrmEntityTests.assertEquals((int)100, (int)ormContextCaching.getSize());
        EclipseLinkOrmEntityTests.assertEquals((int)100, (int)ormContextCaching.getDefaultSize());
        EclipseLinkOrmEntityTests.assertEquals(null, (Object)ormContextCaching.getSpecifiedSize());
    }

    public void testUpdateCacheAlwaysRefresh() throws Exception {
        this.createTestEntityForCaching();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        JavaEclipseLinkCaching javaContextCaching = ((JavaEclipseLinkEntity)ormPersistentType.getJavaPersistentType().getMapping()).getCaching();
        OrmEclipseLinkEntity ormContextEntity = (OrmEclipseLinkEntity)ormPersistentType.getMapping();
        OrmEclipseLinkCaching ormContextCaching = ormContextEntity.getCaching();
        XmlEntity resourceEntity = (XmlEntity)this.getXmlEntityMappings().getEntities().get(0);
        EclipseLinkOrmEntityTests.assertEquals(null, (Object)resourceEntity.getCache());
        EclipseLinkOrmEntityTests.assertEquals((boolean)false, (boolean)javaContextCaching.isAlwaysRefresh());
        EclipseLinkOrmEntityTests.assertEquals((boolean)false, (boolean)ormContextCaching.isAlwaysRefresh());
        EclipseLinkOrmEntityTests.assertEquals((boolean)false, (boolean)ormContextCaching.isDefaultAlwaysRefresh());
        EclipseLinkOrmEntityTests.assertEquals(null, (Object)ormContextCaching.getSpecifiedAlwaysRefresh());
        resourceEntity.setCache(EclipseLinkOrmFactory.eINSTANCE.createXmlCache());
        EclipseLinkOrmEntityTests.assertEquals(null, (Object)resourceEntity.getCache().getAlwaysRefresh());
        EclipseLinkOrmEntityTests.assertEquals((boolean)false, (boolean)javaContextCaching.isAlwaysRefresh());
        EclipseLinkOrmEntityTests.assertEquals((boolean)false, (boolean)ormContextCaching.isAlwaysRefresh());
        EclipseLinkOrmEntityTests.assertEquals((boolean)false, (boolean)ormContextCaching.isDefaultAlwaysRefresh());
        EclipseLinkOrmEntityTests.assertEquals(null, (Object)ormContextCaching.getSpecifiedAlwaysRefresh());
        resourceEntity.getCache().setAlwaysRefresh(Boolean.TRUE);
        EclipseLinkOrmEntityTests.assertEquals((Object)Boolean.TRUE, (Object)resourceEntity.getCache().getAlwaysRefresh());
        EclipseLinkOrmEntityTests.assertEquals((boolean)false, (boolean)javaContextCaching.isAlwaysRefresh());
        EclipseLinkOrmEntityTests.assertEquals((boolean)true, (boolean)ormContextCaching.isAlwaysRefresh());
        EclipseLinkOrmEntityTests.assertEquals((boolean)false, (boolean)ormContextCaching.isDefaultAlwaysRefresh());
        EclipseLinkOrmEntityTests.assertEquals((Object)Boolean.TRUE, (Object)ormContextCaching.getSpecifiedAlwaysRefresh());
        javaContextCaching.setSpecifiedAlwaysRefresh(Boolean.TRUE);
        EclipseLinkOrmEntityTests.assertEquals((Object)Boolean.TRUE, (Object)resourceEntity.getCache().getAlwaysRefresh());
        EclipseLinkOrmEntityTests.assertEquals((boolean)true, (boolean)javaContextCaching.isAlwaysRefresh());
        EclipseLinkOrmEntityTests.assertEquals((boolean)true, (boolean)ormContextCaching.isAlwaysRefresh());
        EclipseLinkOrmEntityTests.assertEquals((boolean)false, (boolean)ormContextCaching.isDefaultAlwaysRefresh());
        EclipseLinkOrmEntityTests.assertEquals((Object)Boolean.TRUE, (Object)ormContextCaching.getSpecifiedAlwaysRefresh());
        resourceEntity.getCache().setAlwaysRefresh(Boolean.FALSE);
        EclipseLinkOrmEntityTests.assertEquals((Object)Boolean.FALSE, (Object)resourceEntity.getCache().getAlwaysRefresh());
        EclipseLinkOrmEntityTests.assertEquals((boolean)true, (boolean)javaContextCaching.isAlwaysRefresh());
        EclipseLinkOrmEntityTests.assertEquals((boolean)false, (boolean)ormContextCaching.isAlwaysRefresh());
        EclipseLinkOrmEntityTests.assertEquals((boolean)false, (boolean)ormContextCaching.isDefaultAlwaysRefresh());
        EclipseLinkOrmEntityTests.assertEquals((Object)Boolean.FALSE, (Object)ormContextCaching.getSpecifiedAlwaysRefresh());
        resourceEntity.getCache().setAlwaysRefresh(null);
        EclipseLinkOrmEntityTests.assertEquals(null, (Object)resourceEntity.getCache().getAlwaysRefresh());
        EclipseLinkOrmEntityTests.assertEquals((boolean)true, (boolean)javaContextCaching.isAlwaysRefresh());
        EclipseLinkOrmEntityTests.assertEquals((boolean)false, (boolean)ormContextCaching.isAlwaysRefresh());
        EclipseLinkOrmEntityTests.assertEquals((boolean)false, (boolean)ormContextCaching.isDefaultAlwaysRefresh());
        EclipseLinkOrmEntityTests.assertEquals(null, (Object)ormContextCaching.getSpecifiedAlwaysRefresh());
        resourceEntity.setCache(null);
        EclipseLinkOrmEntityTests.assertEquals(null, (Object)resourceEntity.getCache());
        EclipseLinkOrmEntityTests.assertEquals((boolean)true, (boolean)javaContextCaching.isAlwaysRefresh());
        EclipseLinkOrmEntityTests.assertEquals((boolean)true, (boolean)ormContextCaching.isAlwaysRefresh());
        EclipseLinkOrmEntityTests.assertEquals((boolean)true, (boolean)ormContextCaching.isDefaultAlwaysRefresh());
        EclipseLinkOrmEntityTests.assertEquals(null, (Object)ormContextCaching.getSpecifiedAlwaysRefresh());
        ormContextEntity.setSpecifiedMetadataComplete(Boolean.TRUE);
        EclipseLinkOrmEntityTests.assertEquals(null, (Object)resourceEntity.getCache());
        EclipseLinkOrmEntityTests.assertEquals((boolean)true, (boolean)javaContextCaching.isAlwaysRefresh());
        EclipseLinkOrmEntityTests.assertEquals((boolean)false, (boolean)ormContextCaching.isAlwaysRefresh());
        EclipseLinkOrmEntityTests.assertEquals((boolean)false, (boolean)ormContextCaching.isDefaultAlwaysRefresh());
        EclipseLinkOrmEntityTests.assertEquals(null, (Object)ormContextCaching.getSpecifiedAlwaysRefresh());
        ormContextEntity.setSpecifiedMetadataComplete(null);
        EclipseLinkOrmEntityTests.assertEquals(null, (Object)resourceEntity.getCache());
        EclipseLinkOrmEntityTests.assertEquals((boolean)true, (boolean)javaContextCaching.isAlwaysRefresh());
        EclipseLinkOrmEntityTests.assertEquals((boolean)true, (boolean)ormContextCaching.isAlwaysRefresh());
        EclipseLinkOrmEntityTests.assertEquals((boolean)true, (boolean)ormContextCaching.isDefaultAlwaysRefresh());
        EclipseLinkOrmEntityTests.assertEquals(null, (Object)ormContextCaching.getSpecifiedAlwaysRefresh());
    }

    public void testModifyCacheAlwaysRefresh() throws Exception {
        this.createTestEntityForCaching();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmEclipseLinkEntity ormContextEntity = (OrmEclipseLinkEntity)ormPersistentType.getMapping();
        OrmEclipseLinkCaching ormContextCaching = ormContextEntity.getCaching();
        XmlEntity resourceEntity = (XmlEntity)this.getXmlEntityMappings().getEntities().get(0);
        EclipseLinkOrmEntityTests.assertEquals(null, (Object)resourceEntity.getCache());
        EclipseLinkOrmEntityTests.assertEquals((boolean)false, (boolean)ormContextCaching.isAlwaysRefresh());
        EclipseLinkOrmEntityTests.assertEquals((boolean)false, (boolean)ormContextCaching.isDefaultAlwaysRefresh());
        EclipseLinkOrmEntityTests.assertEquals(null, (Object)ormContextCaching.getSpecifiedAlwaysRefresh());
        ormContextEntity.getCaching().setSpecifiedAlwaysRefresh(Boolean.TRUE);
        EclipseLinkOrmEntityTests.assertEquals((Object)Boolean.TRUE, (Object)resourceEntity.getCache().getAlwaysRefresh());
        EclipseLinkOrmEntityTests.assertEquals((boolean)true, (boolean)ormContextCaching.isAlwaysRefresh());
        EclipseLinkOrmEntityTests.assertEquals((boolean)false, (boolean)ormContextCaching.isDefaultAlwaysRefresh());
        EclipseLinkOrmEntityTests.assertEquals((Object)Boolean.TRUE, (Object)ormContextCaching.getSpecifiedAlwaysRefresh());
        ormContextEntity.getCaching().setSpecifiedAlwaysRefresh(null);
        EclipseLinkOrmEntityTests.assertEquals(null, (Object)resourceEntity.getCache());
        EclipseLinkOrmEntityTests.assertEquals((boolean)false, (boolean)ormContextCaching.isAlwaysRefresh());
        EclipseLinkOrmEntityTests.assertEquals((boolean)false, (boolean)ormContextCaching.isDefaultAlwaysRefresh());
        EclipseLinkOrmEntityTests.assertEquals(null, (Object)ormContextCaching.getSpecifiedAlwaysRefresh());
    }

    public void testUpdateCacheRefreshOnlyIfNewer() throws Exception {
        this.createTestEntityForCaching();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        JavaEclipseLinkCaching javaContextCaching = ((JavaEclipseLinkEntity)ormPersistentType.getJavaPersistentType().getMapping()).getCaching();
        OrmEclipseLinkEntity ormContextEntity = (OrmEclipseLinkEntity)ormPersistentType.getMapping();
        OrmEclipseLinkCaching ormContextCaching = ormContextEntity.getCaching();
        XmlEntity resourceEntity = (XmlEntity)this.getXmlEntityMappings().getEntities().get(0);
        EclipseLinkOrmEntityTests.assertEquals(null, (Object)resourceEntity.getCache());
        EclipseLinkOrmEntityTests.assertEquals((boolean)false, (boolean)javaContextCaching.isRefreshOnlyIfNewer());
        EclipseLinkOrmEntityTests.assertEquals((boolean)false, (boolean)ormContextCaching.isRefreshOnlyIfNewer());
        EclipseLinkOrmEntityTests.assertEquals((boolean)false, (boolean)ormContextCaching.isDefaultRefreshOnlyIfNewer());
        EclipseLinkOrmEntityTests.assertEquals(null, (Object)ormContextCaching.getSpecifiedRefreshOnlyIfNewer());
        resourceEntity.setCache(EclipseLinkOrmFactory.eINSTANCE.createXmlCache());
        EclipseLinkOrmEntityTests.assertEquals(null, (Object)resourceEntity.getCache().getRefreshOnlyIfNewer());
        EclipseLinkOrmEntityTests.assertEquals((boolean)false, (boolean)javaContextCaching.isRefreshOnlyIfNewer());
        EclipseLinkOrmEntityTests.assertEquals((boolean)false, (boolean)ormContextCaching.isRefreshOnlyIfNewer());
        EclipseLinkOrmEntityTests.assertEquals((boolean)false, (boolean)ormContextCaching.isDefaultRefreshOnlyIfNewer());
        EclipseLinkOrmEntityTests.assertEquals(null, (Object)ormContextCaching.getSpecifiedRefreshOnlyIfNewer());
        resourceEntity.getCache().setRefreshOnlyIfNewer(Boolean.TRUE);
        EclipseLinkOrmEntityTests.assertEquals((Object)Boolean.TRUE, (Object)resourceEntity.getCache().getRefreshOnlyIfNewer());
        EclipseLinkOrmEntityTests.assertEquals((boolean)false, (boolean)javaContextCaching.isRefreshOnlyIfNewer());
        EclipseLinkOrmEntityTests.assertEquals((boolean)true, (boolean)ormContextCaching.isRefreshOnlyIfNewer());
        EclipseLinkOrmEntityTests.assertEquals((boolean)false, (boolean)ormContextCaching.isDefaultRefreshOnlyIfNewer());
        EclipseLinkOrmEntityTests.assertEquals((Object)Boolean.TRUE, (Object)ormContextCaching.getSpecifiedRefreshOnlyIfNewer());
        javaContextCaching.setSpecifiedRefreshOnlyIfNewer(Boolean.TRUE);
        EclipseLinkOrmEntityTests.assertEquals((Object)Boolean.TRUE, (Object)resourceEntity.getCache().getRefreshOnlyIfNewer());
        EclipseLinkOrmEntityTests.assertEquals((boolean)true, (boolean)javaContextCaching.isRefreshOnlyIfNewer());
        EclipseLinkOrmEntityTests.assertEquals((boolean)true, (boolean)ormContextCaching.isRefreshOnlyIfNewer());
        EclipseLinkOrmEntityTests.assertEquals((boolean)false, (boolean)ormContextCaching.isDefaultRefreshOnlyIfNewer());
        EclipseLinkOrmEntityTests.assertEquals((Object)Boolean.TRUE, (Object)ormContextCaching.getSpecifiedRefreshOnlyIfNewer());
        resourceEntity.getCache().setRefreshOnlyIfNewer(Boolean.FALSE);
        EclipseLinkOrmEntityTests.assertEquals((Object)Boolean.FALSE, (Object)resourceEntity.getCache().getRefreshOnlyIfNewer());
        EclipseLinkOrmEntityTests.assertEquals((boolean)true, (boolean)javaContextCaching.isRefreshOnlyIfNewer());
        EclipseLinkOrmEntityTests.assertEquals((boolean)false, (boolean)ormContextCaching.isRefreshOnlyIfNewer());
        EclipseLinkOrmEntityTests.assertEquals((boolean)false, (boolean)ormContextCaching.isDefaultRefreshOnlyIfNewer());
        EclipseLinkOrmEntityTests.assertEquals((Object)Boolean.FALSE, (Object)ormContextCaching.getSpecifiedRefreshOnlyIfNewer());
        resourceEntity.getCache().setRefreshOnlyIfNewer(null);
        EclipseLinkOrmEntityTests.assertEquals(null, (Object)resourceEntity.getCache().getRefreshOnlyIfNewer());
        EclipseLinkOrmEntityTests.assertEquals((boolean)true, (boolean)javaContextCaching.isRefreshOnlyIfNewer());
        EclipseLinkOrmEntityTests.assertEquals((boolean)false, (boolean)ormContextCaching.isRefreshOnlyIfNewer());
        EclipseLinkOrmEntityTests.assertEquals((boolean)false, (boolean)ormContextCaching.isDefaultRefreshOnlyIfNewer());
        EclipseLinkOrmEntityTests.assertEquals(null, (Object)ormContextCaching.getSpecifiedRefreshOnlyIfNewer());
        resourceEntity.setCache(null);
        EclipseLinkOrmEntityTests.assertEquals(null, (Object)resourceEntity.getCache());
        EclipseLinkOrmEntityTests.assertEquals((boolean)true, (boolean)javaContextCaching.isRefreshOnlyIfNewer());
        EclipseLinkOrmEntityTests.assertEquals((boolean)true, (boolean)ormContextCaching.isRefreshOnlyIfNewer());
        EclipseLinkOrmEntityTests.assertEquals((boolean)true, (boolean)ormContextCaching.isDefaultRefreshOnlyIfNewer());
        EclipseLinkOrmEntityTests.assertEquals(null, (Object)ormContextCaching.getSpecifiedRefreshOnlyIfNewer());
        ormContextEntity.setSpecifiedMetadataComplete(Boolean.TRUE);
        EclipseLinkOrmEntityTests.assertEquals(null, (Object)resourceEntity.getCache());
        EclipseLinkOrmEntityTests.assertEquals((boolean)true, (boolean)javaContextCaching.isRefreshOnlyIfNewer());
        EclipseLinkOrmEntityTests.assertEquals((boolean)false, (boolean)ormContextCaching.isRefreshOnlyIfNewer());
        EclipseLinkOrmEntityTests.assertEquals((boolean)false, (boolean)ormContextCaching.isDefaultRefreshOnlyIfNewer());
        EclipseLinkOrmEntityTests.assertEquals(null, (Object)ormContextCaching.getSpecifiedRefreshOnlyIfNewer());
        ormContextEntity.setSpecifiedMetadataComplete(null);
        EclipseLinkOrmEntityTests.assertEquals(null, (Object)resourceEntity.getCache());
        EclipseLinkOrmEntityTests.assertEquals((boolean)true, (boolean)javaContextCaching.isRefreshOnlyIfNewer());
        EclipseLinkOrmEntityTests.assertEquals((boolean)true, (boolean)ormContextCaching.isRefreshOnlyIfNewer());
        EclipseLinkOrmEntityTests.assertEquals((boolean)true, (boolean)ormContextCaching.isDefaultRefreshOnlyIfNewer());
        EclipseLinkOrmEntityTests.assertEquals(null, (Object)ormContextCaching.getSpecifiedRefreshOnlyIfNewer());
    }

    public void testModifyCacheRefreshOnlyIfNewer() throws Exception {
        this.createTestEntityForCaching();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmEclipseLinkEntity ormContextEntity = (OrmEclipseLinkEntity)ormPersistentType.getMapping();
        OrmEclipseLinkCaching ormContextCaching = ormContextEntity.getCaching();
        XmlEntity resourceEntity = (XmlEntity)this.getXmlEntityMappings().getEntities().get(0);
        EclipseLinkOrmEntityTests.assertEquals(null, (Object)resourceEntity.getCache());
        EclipseLinkOrmEntityTests.assertEquals((boolean)false, (boolean)ormContextCaching.isRefreshOnlyIfNewer());
        EclipseLinkOrmEntityTests.assertEquals((boolean)false, (boolean)ormContextCaching.isDefaultRefreshOnlyIfNewer());
        EclipseLinkOrmEntityTests.assertEquals(null, (Object)ormContextCaching.getSpecifiedRefreshOnlyIfNewer());
        ormContextEntity.getCaching().setSpecifiedRefreshOnlyIfNewer(Boolean.TRUE);
        EclipseLinkOrmEntityTests.assertEquals((Object)Boolean.TRUE, (Object)resourceEntity.getCache().getRefreshOnlyIfNewer());
        EclipseLinkOrmEntityTests.assertEquals((boolean)true, (boolean)ormContextCaching.isRefreshOnlyIfNewer());
        EclipseLinkOrmEntityTests.assertEquals((boolean)false, (boolean)ormContextCaching.isDefaultRefreshOnlyIfNewer());
        EclipseLinkOrmEntityTests.assertEquals((Object)Boolean.TRUE, (Object)ormContextCaching.getSpecifiedRefreshOnlyIfNewer());
        ormContextEntity.getCaching().setSpecifiedRefreshOnlyIfNewer(null);
        EclipseLinkOrmEntityTests.assertEquals(null, (Object)resourceEntity.getCache());
        EclipseLinkOrmEntityTests.assertEquals((boolean)false, (boolean)ormContextCaching.isRefreshOnlyIfNewer());
        EclipseLinkOrmEntityTests.assertEquals((boolean)false, (boolean)ormContextCaching.isDefaultRefreshOnlyIfNewer());
        EclipseLinkOrmEntityTests.assertEquals(null, (Object)ormContextCaching.getSpecifiedRefreshOnlyIfNewer());
    }

    public void testUpdateCacheDisableHits() throws Exception {
        this.createTestEntityForCaching();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        JavaEclipseLinkCaching javaContextCaching = ((JavaEclipseLinkEntity)ormPersistentType.getJavaPersistentType().getMapping()).getCaching();
        OrmEclipseLinkEntity ormContextEntity = (OrmEclipseLinkEntity)ormPersistentType.getMapping();
        OrmEclipseLinkCaching ormContextCaching = ormContextEntity.getCaching();
        XmlEntity resourceEntity = (XmlEntity)this.getXmlEntityMappings().getEntities().get(0);
        EclipseLinkOrmEntityTests.assertEquals(null, (Object)resourceEntity.getCache());
        EclipseLinkOrmEntityTests.assertEquals((boolean)false, (boolean)javaContextCaching.isDisableHits());
        EclipseLinkOrmEntityTests.assertEquals((boolean)false, (boolean)ormContextCaching.isDisableHits());
        EclipseLinkOrmEntityTests.assertEquals((boolean)false, (boolean)ormContextCaching.isDefaultDisableHits());
        EclipseLinkOrmEntityTests.assertEquals(null, (Object)ormContextCaching.getSpecifiedDisableHits());
        resourceEntity.setCache(EclipseLinkOrmFactory.eINSTANCE.createXmlCache());
        EclipseLinkOrmEntityTests.assertEquals(null, (Object)resourceEntity.getCache().getDisableHits());
        EclipseLinkOrmEntityTests.assertEquals((boolean)false, (boolean)javaContextCaching.isDisableHits());
        EclipseLinkOrmEntityTests.assertEquals((boolean)false, (boolean)ormContextCaching.isDisableHits());
        EclipseLinkOrmEntityTests.assertEquals((boolean)false, (boolean)ormContextCaching.isDefaultDisableHits());
        EclipseLinkOrmEntityTests.assertEquals(null, (Object)ormContextCaching.getSpecifiedDisableHits());
        resourceEntity.getCache().setDisableHits(Boolean.TRUE);
        EclipseLinkOrmEntityTests.assertEquals((Object)Boolean.TRUE, (Object)resourceEntity.getCache().getDisableHits());
        EclipseLinkOrmEntityTests.assertEquals((boolean)false, (boolean)javaContextCaching.isDisableHits());
        EclipseLinkOrmEntityTests.assertEquals((boolean)true, (boolean)ormContextCaching.isDisableHits());
        EclipseLinkOrmEntityTests.assertEquals((boolean)false, (boolean)ormContextCaching.isDefaultDisableHits());
        EclipseLinkOrmEntityTests.assertEquals((Object)Boolean.TRUE, (Object)ormContextCaching.getSpecifiedDisableHits());
        javaContextCaching.setSpecifiedDisableHits(Boolean.TRUE);
        EclipseLinkOrmEntityTests.assertEquals((Object)Boolean.TRUE, (Object)resourceEntity.getCache().getDisableHits());
        EclipseLinkOrmEntityTests.assertEquals((boolean)true, (boolean)javaContextCaching.isDisableHits());
        EclipseLinkOrmEntityTests.assertEquals((boolean)true, (boolean)ormContextCaching.isDisableHits());
        EclipseLinkOrmEntityTests.assertEquals((boolean)false, (boolean)ormContextCaching.isDefaultDisableHits());
        EclipseLinkOrmEntityTests.assertEquals((Object)Boolean.TRUE, (Object)ormContextCaching.getSpecifiedDisableHits());
        resourceEntity.getCache().setDisableHits(Boolean.FALSE);
        EclipseLinkOrmEntityTests.assertEquals((Object)Boolean.FALSE, (Object)resourceEntity.getCache().getDisableHits());
        EclipseLinkOrmEntityTests.assertEquals((boolean)true, (boolean)javaContextCaching.isDisableHits());
        EclipseLinkOrmEntityTests.assertEquals((boolean)false, (boolean)ormContextCaching.isDisableHits());
        EclipseLinkOrmEntityTests.assertEquals((boolean)false, (boolean)ormContextCaching.isDefaultDisableHits());
        EclipseLinkOrmEntityTests.assertEquals((Object)Boolean.FALSE, (Object)ormContextCaching.getSpecifiedDisableHits());
        resourceEntity.getCache().setDisableHits(null);
        EclipseLinkOrmEntityTests.assertEquals(null, (Object)resourceEntity.getCache().getDisableHits());
        EclipseLinkOrmEntityTests.assertEquals((boolean)true, (boolean)javaContextCaching.isDisableHits());
        EclipseLinkOrmEntityTests.assertEquals((boolean)false, (boolean)ormContextCaching.isDisableHits());
        EclipseLinkOrmEntityTests.assertEquals((boolean)false, (boolean)ormContextCaching.isDefaultDisableHits());
        EclipseLinkOrmEntityTests.assertEquals(null, (Object)ormContextCaching.getSpecifiedDisableHits());
        resourceEntity.setCache(null);
        EclipseLinkOrmEntityTests.assertEquals(null, (Object)resourceEntity.getCache());
        EclipseLinkOrmEntityTests.assertEquals((boolean)true, (boolean)javaContextCaching.isDisableHits());
        EclipseLinkOrmEntityTests.assertEquals((boolean)true, (boolean)ormContextCaching.isDisableHits());
        EclipseLinkOrmEntityTests.assertEquals((boolean)true, (boolean)ormContextCaching.isDefaultDisableHits());
        EclipseLinkOrmEntityTests.assertEquals(null, (Object)ormContextCaching.getSpecifiedDisableHits());
        ormContextEntity.setSpecifiedMetadataComplete(Boolean.TRUE);
        EclipseLinkOrmEntityTests.assertEquals(null, (Object)resourceEntity.getCache());
        EclipseLinkOrmEntityTests.assertEquals((boolean)true, (boolean)javaContextCaching.isDisableHits());
        EclipseLinkOrmEntityTests.assertEquals((boolean)false, (boolean)ormContextCaching.isDisableHits());
        EclipseLinkOrmEntityTests.assertEquals((boolean)false, (boolean)ormContextCaching.isDefaultDisableHits());
        EclipseLinkOrmEntityTests.assertEquals(null, (Object)ormContextCaching.getSpecifiedDisableHits());
        ormContextEntity.setSpecifiedMetadataComplete(null);
        EclipseLinkOrmEntityTests.assertEquals(null, (Object)resourceEntity.getCache());
        EclipseLinkOrmEntityTests.assertEquals((boolean)true, (boolean)javaContextCaching.isDisableHits());
        EclipseLinkOrmEntityTests.assertEquals((boolean)true, (boolean)ormContextCaching.isDisableHits());
        EclipseLinkOrmEntityTests.assertEquals((boolean)true, (boolean)ormContextCaching.isDefaultDisableHits());
        EclipseLinkOrmEntityTests.assertEquals(null, (Object)ormContextCaching.getSpecifiedDisableHits());
    }

    public void testModifyCacheDisableHits() throws Exception {
        this.createTestEntityForCaching();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmEclipseLinkEntity ormContextEntity = (OrmEclipseLinkEntity)ormPersistentType.getMapping();
        OrmEclipseLinkCaching ormContextCaching = ormContextEntity.getCaching();
        XmlEntity resourceEntity = (XmlEntity)this.getXmlEntityMappings().getEntities().get(0);
        EclipseLinkOrmEntityTests.assertEquals(null, (Object)resourceEntity.getCache());
        EclipseLinkOrmEntityTests.assertEquals((boolean)false, (boolean)ormContextCaching.isDisableHits());
        EclipseLinkOrmEntityTests.assertEquals((boolean)false, (boolean)ormContextCaching.isDefaultDisableHits());
        EclipseLinkOrmEntityTests.assertEquals(null, (Object)ormContextCaching.getSpecifiedDisableHits());
        ormContextEntity.getCaching().setSpecifiedDisableHits(Boolean.TRUE);
        EclipseLinkOrmEntityTests.assertEquals((Object)Boolean.TRUE, (Object)resourceEntity.getCache().getDisableHits());
        EclipseLinkOrmEntityTests.assertEquals((boolean)true, (boolean)ormContextCaching.isDisableHits());
        EclipseLinkOrmEntityTests.assertEquals((boolean)false, (boolean)ormContextCaching.isDefaultDisableHits());
        EclipseLinkOrmEntityTests.assertEquals((Object)Boolean.TRUE, (Object)ormContextCaching.getSpecifiedDisableHits());
        ormContextEntity.getCaching().setSpecifiedDisableHits(null);
        EclipseLinkOrmEntityTests.assertEquals(null, (Object)resourceEntity.getCache());
        EclipseLinkOrmEntityTests.assertEquals((boolean)false, (boolean)ormContextCaching.isDisableHits());
        EclipseLinkOrmEntityTests.assertEquals((boolean)false, (boolean)ormContextCaching.isDefaultDisableHits());
        EclipseLinkOrmEntityTests.assertEquals(null, (Object)ormContextCaching.getSpecifiedDisableHits());
    }

    public void testUpdateCacheShared() throws Exception {
        this.createTestEntityForCaching();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        JavaEclipseLinkCaching javaContextCaching = ((JavaEclipseLinkEntity)ormPersistentType.getJavaPersistentType().getMapping()).getCaching();
        OrmEclipseLinkEntity ormContextEntity = (OrmEclipseLinkEntity)ormPersistentType.getMapping();
        OrmEclipseLinkCaching ormContextCaching = ormContextEntity.getCaching();
        XmlEntity resourceEntity = (XmlEntity)this.getXmlEntityMappings().getEntities().get(0);
        EclipseLinkOrmEntityTests.assertEquals(null, (Object)resourceEntity.getCache());
        EclipseLinkOrmEntityTests.assertEquals((boolean)true, (boolean)javaContextCaching.isShared());
        EclipseLinkOrmEntityTests.assertEquals((boolean)true, (boolean)ormContextCaching.isShared());
        EclipseLinkOrmEntityTests.assertEquals((boolean)true, (boolean)ormContextCaching.isDefaultShared());
        EclipseLinkOrmEntityTests.assertEquals(null, (Object)ormContextCaching.getSpecifiedShared());
        resourceEntity.setCache(EclipseLinkOrmFactory.eINSTANCE.createXmlCache());
        EclipseLinkOrmEntityTests.assertEquals(null, (Object)resourceEntity.getCache().getShared());
        EclipseLinkOrmEntityTests.assertEquals((boolean)true, (boolean)javaContextCaching.isShared());
        EclipseLinkOrmEntityTests.assertEquals((boolean)true, (boolean)ormContextCaching.isShared());
        EclipseLinkOrmEntityTests.assertEquals((boolean)true, (boolean)ormContextCaching.isDefaultShared());
        EclipseLinkOrmEntityTests.assertEquals(null, (Object)ormContextCaching.getSpecifiedShared());
        resourceEntity.getCache().setShared(Boolean.FALSE);
        EclipseLinkOrmEntityTests.assertEquals((Object)Boolean.FALSE, (Object)resourceEntity.getCache().getShared());
        EclipseLinkOrmEntityTests.assertEquals((boolean)true, (boolean)javaContextCaching.isShared());
        EclipseLinkOrmEntityTests.assertEquals((boolean)false, (boolean)ormContextCaching.isShared());
        EclipseLinkOrmEntityTests.assertEquals((boolean)true, (boolean)ormContextCaching.isDefaultShared());
        EclipseLinkOrmEntityTests.assertEquals((Object)Boolean.FALSE, (Object)ormContextCaching.getSpecifiedShared());
        javaContextCaching.setSpecifiedShared(Boolean.FALSE);
        EclipseLinkOrmEntityTests.assertEquals((Object)Boolean.FALSE, (Object)resourceEntity.getCache().getShared());
        EclipseLinkOrmEntityTests.assertEquals((boolean)false, (boolean)javaContextCaching.isShared());
        EclipseLinkOrmEntityTests.assertEquals((boolean)false, (boolean)ormContextCaching.isShared());
        EclipseLinkOrmEntityTests.assertEquals((boolean)true, (boolean)ormContextCaching.isDefaultShared());
        EclipseLinkOrmEntityTests.assertEquals((Object)Boolean.FALSE, (Object)ormContextCaching.getSpecifiedShared());
        resourceEntity.getCache().setShared(Boolean.TRUE);
        EclipseLinkOrmEntityTests.assertEquals((Object)Boolean.TRUE, (Object)resourceEntity.getCache().getShared());
        EclipseLinkOrmEntityTests.assertEquals((boolean)false, (boolean)javaContextCaching.isShared());
        EclipseLinkOrmEntityTests.assertEquals((boolean)true, (boolean)ormContextCaching.isShared());
        EclipseLinkOrmEntityTests.assertEquals((boolean)true, (boolean)ormContextCaching.isDefaultShared());
        EclipseLinkOrmEntityTests.assertEquals((Object)Boolean.TRUE, (Object)ormContextCaching.getSpecifiedShared());
        resourceEntity.getCache().setShared(null);
        EclipseLinkOrmEntityTests.assertEquals(null, (Object)resourceEntity.getCache().getShared());
        EclipseLinkOrmEntityTests.assertEquals((boolean)false, (boolean)javaContextCaching.isShared());
        EclipseLinkOrmEntityTests.assertEquals((boolean)true, (boolean)ormContextCaching.isShared());
        EclipseLinkOrmEntityTests.assertEquals((boolean)true, (boolean)ormContextCaching.isDefaultShared());
        EclipseLinkOrmEntityTests.assertEquals(null, (Object)ormContextCaching.getSpecifiedShared());
        resourceEntity.setCache(null);
        EclipseLinkOrmEntityTests.assertEquals(null, (Object)resourceEntity.getCache());
        EclipseLinkOrmEntityTests.assertEquals((boolean)false, (boolean)javaContextCaching.isShared());
        EclipseLinkOrmEntityTests.assertEquals((boolean)false, (boolean)ormContextCaching.isShared());
        EclipseLinkOrmEntityTests.assertEquals((boolean)false, (boolean)ormContextCaching.isDefaultShared());
        EclipseLinkOrmEntityTests.assertEquals(null, (Object)ormContextCaching.getSpecifiedShared());
        ormContextEntity.setSpecifiedMetadataComplete(Boolean.TRUE);
        EclipseLinkOrmEntityTests.assertEquals(null, (Object)resourceEntity.getCache());
        EclipseLinkOrmEntityTests.assertEquals((boolean)false, (boolean)javaContextCaching.isShared());
        EclipseLinkOrmEntityTests.assertEquals((boolean)true, (boolean)ormContextCaching.isShared());
        EclipseLinkOrmEntityTests.assertEquals((boolean)true, (boolean)ormContextCaching.isDefaultShared());
        EclipseLinkOrmEntityTests.assertEquals(null, (Object)ormContextCaching.getSpecifiedShared());
        ormContextEntity.setSpecifiedMetadataComplete(null);
        EclipseLinkOrmEntityTests.assertEquals(null, (Object)resourceEntity.getCache());
        EclipseLinkOrmEntityTests.assertEquals((boolean)false, (boolean)javaContextCaching.isShared());
        EclipseLinkOrmEntityTests.assertEquals((boolean)false, (boolean)ormContextCaching.isShared());
        EclipseLinkOrmEntityTests.assertEquals((boolean)false, (boolean)ormContextCaching.isDefaultShared());
        EclipseLinkOrmEntityTests.assertEquals(null, (Object)ormContextCaching.getSpecifiedShared());
    }

    public void testModifyCacheShared() throws Exception {
        this.createTestEntityForCaching();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmEclipseLinkEntity ormContextEntity = (OrmEclipseLinkEntity)ormPersistentType.getMapping();
        OrmEclipseLinkCaching ormContextCaching = ormContextEntity.getCaching();
        XmlEntity resourceEntity = (XmlEntity)this.getXmlEntityMappings().getEntities().get(0);
        EclipseLinkOrmEntityTests.assertEquals(null, (Object)resourceEntity.getCache());
        EclipseLinkOrmEntityTests.assertEquals((boolean)true, (boolean)ormContextCaching.isShared());
        EclipseLinkOrmEntityTests.assertEquals((boolean)true, (boolean)ormContextCaching.isDefaultShared());
        EclipseLinkOrmEntityTests.assertEquals(null, (Object)ormContextCaching.getSpecifiedShared());
        ormContextEntity.getCaching().setSpecifiedShared(Boolean.FALSE);
        EclipseLinkOrmEntityTests.assertEquals((Object)Boolean.FALSE, (Object)resourceEntity.getCache().getShared());
        EclipseLinkOrmEntityTests.assertEquals((boolean)false, (boolean)ormContextCaching.isShared());
        EclipseLinkOrmEntityTests.assertEquals((boolean)true, (boolean)ormContextCaching.isDefaultShared());
        EclipseLinkOrmEntityTests.assertEquals((Object)Boolean.FALSE, (Object)ormContextCaching.getSpecifiedShared());
        ormContextEntity.getCaching().setSpecifiedShared(null);
        EclipseLinkOrmEntityTests.assertEquals(null, (Object)resourceEntity.getCache());
        EclipseLinkOrmEntityTests.assertEquals((boolean)true, (boolean)ormContextCaching.isShared());
        EclipseLinkOrmEntityTests.assertEquals((boolean)true, (boolean)ormContextCaching.isDefaultShared());
        EclipseLinkOrmEntityTests.assertEquals(null, (Object)ormContextCaching.getSpecifiedShared());
    }

    public void testSetSpecifiedSharedFalseUnsetsOtherCacheSettings() throws Exception {
        this.createTestEntityForCaching();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmEclipseLinkEntity ormContextEntity = (OrmEclipseLinkEntity)ormPersistentType.getMapping();
        OrmEclipseLinkCaching ormContextCaching = ormContextEntity.getCaching();
        XmlEntity resourceEntity = (XmlEntity)this.getXmlEntityMappings().getEntities().get(0);
        ormContextCaching.setSpecifiedType(EclipseLinkCacheType.HARD_WEAK);
        ormContextCaching.setSpecifiedSize(Integer.valueOf(500));
        ormContextCaching.setSpecifiedAlwaysRefresh(Boolean.FALSE);
        ormContextCaching.setSpecifiedRefreshOnlyIfNewer(Boolean.FALSE);
        ormContextCaching.setSpecifiedDisableHits(Boolean.FALSE);
        ormContextCaching.setSpecifiedCoordinationType(EclipseLinkCacheCoordinationType.INVALIDATE_CHANGED_OBJECTS);
        ormContextCaching.setSpecifiedExistenceType(EclipseLinkExistenceType.ASSUME_NON_EXISTENCE);
        ormContextCaching.setExpiry(Integer.valueOf(8000));
        ormContextCaching.setSpecifiedShared(Boolean.FALSE);
        EclipseLinkOrmEntityTests.assertEquals(null, (Object)ormContextCaching.getSpecifiedType());
        EclipseLinkOrmEntityTests.assertEquals(null, (Object)ormContextCaching.getSpecifiedSize());
        EclipseLinkOrmEntityTests.assertEquals(null, (Object)ormContextCaching.getSpecifiedAlwaysRefresh());
        EclipseLinkOrmEntityTests.assertEquals(null, (Object)ormContextCaching.getSpecifiedRefreshOnlyIfNewer());
        EclipseLinkOrmEntityTests.assertEquals(null, (Object)ormContextCaching.getSpecifiedDisableHits());
        EclipseLinkOrmEntityTests.assertEquals(null, (Object)ormContextCaching.getSpecifiedCoordinationType());
        EclipseLinkOrmEntityTests.assertEquals(null, (Object)ormContextCaching.getExpiry());
        EclipseLinkOrmEntityTests.assertEquals((Object)EclipseLinkExistenceType.ASSUME_NON_EXISTENCE, (Object)ormContextCaching.getSpecifiedExistenceType());
        ormContextCaching.setSpecifiedShared(null);
        EclipseLinkExpiryTimeOfDay timeOfDayExpiry = ormContextCaching.addExpiryTimeOfDay();
        timeOfDayExpiry.setHour(Integer.valueOf(5));
        ormContextCaching.setSpecifiedShared(Boolean.FALSE);
        EclipseLinkOrmEntityTests.assertNull((Object)ormContextCaching.getExpiryTimeOfDay());
        EclipseLinkOrmEntityTests.assertEquals((Object)Boolean.FALSE, (Object)resourceEntity.getCache().getShared());
        EclipseLinkOrmEntityTests.assertNull((Object)resourceEntity.getCache().getExpiryTimeOfDay());
    }

    public void testUpdateExistenceChecking() throws Exception {
        this.createTestEntityForCaching();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        JavaEclipseLinkCaching javaContextCaching = ((JavaEclipseLinkEntity)ormPersistentType.getJavaPersistentType().getMapping()).getCaching();
        OrmEclipseLinkEntity ormContextEntity = (OrmEclipseLinkEntity)ormPersistentType.getMapping();
        OrmEclipseLinkCaching ormContextCaching = ormContextEntity.getCaching();
        XmlEntity resourceEntity = (XmlEntity)this.getXmlEntityMappings().getEntities().get(0);
        EclipseLinkOrmEntityTests.assertEquals(null, (Object)resourceEntity.getExistenceChecking());
        EclipseLinkOrmEntityTests.assertEquals((Object)EclipseLinkExistenceType.CHECK_DATABASE, (Object)javaContextCaching.getExistenceType());
        EclipseLinkOrmEntityTests.assertEquals((Object)EclipseLinkExistenceType.CHECK_DATABASE, (Object)ormContextCaching.getExistenceType());
        EclipseLinkOrmEntityTests.assertEquals((Object)EclipseLinkExistenceType.CHECK_DATABASE, (Object)ormContextCaching.getDefaultExistenceType());
        EclipseLinkOrmEntityTests.assertEquals(null, (Object)ormContextCaching.getSpecifiedExistenceType());
        resourceEntity.setExistenceChecking(ExistenceType.ASSUME_EXISTENCE);
        EclipseLinkOrmEntityTests.assertEquals((Object)ExistenceType.ASSUME_EXISTENCE, (Object)resourceEntity.getExistenceChecking());
        EclipseLinkOrmEntityTests.assertEquals((Object)EclipseLinkExistenceType.CHECK_DATABASE, (Object)javaContextCaching.getExistenceType());
        EclipseLinkOrmEntityTests.assertEquals((Object)EclipseLinkExistenceType.ASSUME_EXISTENCE, (Object)ormContextCaching.getExistenceType());
        EclipseLinkOrmEntityTests.assertEquals((Object)EclipseLinkExistenceType.CHECK_DATABASE, (Object)ormContextCaching.getDefaultExistenceType());
        EclipseLinkOrmEntityTests.assertEquals((Object)EclipseLinkExistenceType.ASSUME_EXISTENCE, (Object)ormContextCaching.getSpecifiedExistenceType());
        javaContextCaching.setSpecifiedExistenceType(EclipseLinkExistenceType.ASSUME_NON_EXISTENCE);
        EclipseLinkOrmEntityTests.assertEquals((Object)ExistenceType.ASSUME_EXISTENCE, (Object)resourceEntity.getExistenceChecking());
        EclipseLinkOrmEntityTests.assertEquals((Object)EclipseLinkExistenceType.ASSUME_NON_EXISTENCE, (Object)javaContextCaching.getExistenceType());
        EclipseLinkOrmEntityTests.assertEquals((Object)EclipseLinkExistenceType.ASSUME_EXISTENCE, (Object)ormContextCaching.getExistenceType());
        EclipseLinkOrmEntityTests.assertEquals((Object)EclipseLinkExistenceType.ASSUME_NON_EXISTENCE, (Object)ormContextCaching.getDefaultExistenceType());
        EclipseLinkOrmEntityTests.assertEquals((Object)EclipseLinkExistenceType.ASSUME_EXISTENCE, (Object)ormContextCaching.getSpecifiedExistenceType());
        resourceEntity.setExistenceChecking(null);
        EclipseLinkOrmEntityTests.assertEquals(null, (Object)resourceEntity.getExistenceChecking());
        EclipseLinkOrmEntityTests.assertEquals((Object)EclipseLinkExistenceType.ASSUME_NON_EXISTENCE, (Object)javaContextCaching.getExistenceType());
        EclipseLinkOrmEntityTests.assertEquals((Object)EclipseLinkExistenceType.ASSUME_NON_EXISTENCE, (Object)ormContextCaching.getExistenceType());
        EclipseLinkOrmEntityTests.assertEquals((Object)EclipseLinkExistenceType.ASSUME_NON_EXISTENCE, (Object)ormContextCaching.getDefaultExistenceType());
        EclipseLinkOrmEntityTests.assertEquals(null, (Object)ormContextCaching.getSpecifiedExistenceType());
        ormContextEntity.setSpecifiedMetadataComplete(Boolean.TRUE);
        EclipseLinkOrmEntityTests.assertEquals(null, (Object)resourceEntity.getExistenceChecking());
        EclipseLinkOrmEntityTests.assertEquals((Object)EclipseLinkExistenceType.ASSUME_NON_EXISTENCE, (Object)javaContextCaching.getExistenceType());
        EclipseLinkOrmEntityTests.assertEquals((Object)EclipseLinkExistenceType.CHECK_DATABASE, (Object)ormContextCaching.getExistenceType());
        EclipseLinkOrmEntityTests.assertEquals((Object)EclipseLinkExistenceType.CHECK_DATABASE, (Object)ormContextCaching.getDefaultExistenceType());
        EclipseLinkOrmEntityTests.assertEquals(null, (Object)ormContextCaching.getSpecifiedExistenceType());
        ormContextEntity.setSpecifiedMetadataComplete(null);
    }

    public void testModifyExistenceChecking() throws Exception {
        this.createTestEntityForCaching();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmEclipseLinkEntity ormContextEntity = (OrmEclipseLinkEntity)ormPersistentType.getMapping();
        OrmEclipseLinkCaching ormContextCaching = ormContextEntity.getCaching();
        XmlEntity resourceEntity = (XmlEntity)this.getXmlEntityMappings().getEntities().get(0);
        EclipseLinkOrmEntityTests.assertEquals(null, (Object)resourceEntity.getExistenceChecking());
        EclipseLinkOrmEntityTests.assertEquals((Object)EclipseLinkExistenceType.CHECK_DATABASE, (Object)ormContextCaching.getExistenceType());
        EclipseLinkOrmEntityTests.assertEquals((Object)EclipseLinkExistenceType.CHECK_DATABASE, (Object)ormContextCaching.getDefaultExistenceType());
        EclipseLinkOrmEntityTests.assertEquals(null, (Object)ormContextCaching.getSpecifiedExistenceType());
        ormContextEntity.getCaching().setSpecifiedExistenceType(EclipseLinkExistenceType.ASSUME_EXISTENCE);
        EclipseLinkOrmEntityTests.assertEquals((Object)ExistenceType.ASSUME_EXISTENCE, (Object)resourceEntity.getExistenceChecking());
        EclipseLinkOrmEntityTests.assertEquals((Object)EclipseLinkExistenceType.ASSUME_EXISTENCE, (Object)ormContextCaching.getExistenceType());
        EclipseLinkOrmEntityTests.assertEquals((Object)EclipseLinkExistenceType.CHECK_DATABASE, (Object)ormContextCaching.getDefaultExistenceType());
        EclipseLinkOrmEntityTests.assertEquals((Object)EclipseLinkExistenceType.ASSUME_EXISTENCE, (Object)ormContextCaching.getSpecifiedExistenceType());
        ormContextEntity.getCaching().setSpecifiedExistenceType(null);
        EclipseLinkOrmEntityTests.assertEquals(null, (Object)resourceEntity.getExistenceChecking());
        EclipseLinkOrmEntityTests.assertEquals((Object)EclipseLinkExistenceType.CHECK_DATABASE, (Object)ormContextCaching.getExistenceType());
        EclipseLinkOrmEntityTests.assertEquals((Object)EclipseLinkExistenceType.CHECK_DATABASE, (Object)ormContextCaching.getDefaultExistenceType());
        EclipseLinkOrmEntityTests.assertEquals(null, (Object)ormContextCaching.getSpecifiedExistenceType());
    }

    public void testUpdateCacheExpiry() throws Exception {
        this.createTestEntityForCaching();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        JavaEclipseLinkCaching javaContextCaching = ((JavaEclipseLinkEntity)ormPersistentType.getJavaPersistentType().getMapping()).getCaching();
        OrmEclipseLinkEntity ormContextEntity = (OrmEclipseLinkEntity)ormPersistentType.getMapping();
        OrmEclipseLinkCaching ormContextCaching = ormContextEntity.getCaching();
        XmlEntity resourceEntity = (XmlEntity)this.getXmlEntityMappings().getEntities().get(0);
        EclipseLinkOrmEntityTests.assertEquals(null, (Object)resourceEntity.getCache());
        EclipseLinkOrmEntityTests.assertEquals(null, (Object)javaContextCaching.getExpiry());
        EclipseLinkOrmEntityTests.assertEquals(null, (Object)ormContextCaching.getExpiry());
        resourceEntity.setCache(EclipseLinkOrmFactory.eINSTANCE.createXmlCache());
        EclipseLinkOrmEntityTests.assertEquals(null, (Object)resourceEntity.getCache().getExpiry());
        EclipseLinkOrmEntityTests.assertEquals(null, (Object)javaContextCaching.getExpiry());
        EclipseLinkOrmEntityTests.assertEquals(null, (Object)ormContextCaching.getExpiry());
        resourceEntity.getCache().setExpiry(new Integer(45));
        EclipseLinkOrmEntityTests.assertEquals((Object)new Integer(45), (Object)resourceEntity.getCache().getExpiry());
        EclipseLinkOrmEntityTests.assertEquals(null, (Object)javaContextCaching.getExpiry());
        EclipseLinkOrmEntityTests.assertEquals((Object)new Integer(45), (Object)ormContextCaching.getExpiry());
        javaContextCaching.setExpiry(new Integer(55));
        EclipseLinkOrmEntityTests.assertEquals((Object)new Integer(45), (Object)resourceEntity.getCache().getExpiry());
        EclipseLinkOrmEntityTests.assertEquals((Object)new Integer(55), (Object)javaContextCaching.getExpiry());
        EclipseLinkOrmEntityTests.assertEquals((Object)new Integer(45), (Object)ormContextCaching.getExpiry());
        resourceEntity.getCache().setExpiry(null);
        EclipseLinkOrmEntityTests.assertEquals(null, (Object)resourceEntity.getCache().getExpiry());
        EclipseLinkOrmEntityTests.assertEquals((Object)new Integer(55), (Object)javaContextCaching.getExpiry());
        EclipseLinkOrmEntityTests.assertEquals(null, (Object)ormContextCaching.getExpiry());
        resourceEntity.setCache(null);
        EclipseLinkOrmEntityTests.assertEquals(null, (Object)resourceEntity.getCache());
        EclipseLinkOrmEntityTests.assertEquals((Object)new Integer(55), (Object)javaContextCaching.getExpiry());
        EclipseLinkOrmEntityTests.assertEquals(null, (Object)ormContextCaching.getExpiry());
        ormContextEntity.setSpecifiedMetadataComplete(Boolean.TRUE);
        EclipseLinkOrmEntityTests.assertEquals(null, (Object)resourceEntity.getCache());
        EclipseLinkOrmEntityTests.assertEquals((Object)new Integer(55), (Object)javaContextCaching.getExpiry());
        EclipseLinkOrmEntityTests.assertEquals(null, (Object)ormContextCaching.getExpiry());
        ormContextEntity.setSpecifiedMetadataComplete(null);
        EclipseLinkOrmEntityTests.assertEquals(null, (Object)resourceEntity.getCache());
        EclipseLinkOrmEntityTests.assertEquals((Object)new Integer(55), (Object)javaContextCaching.getExpiry());
        EclipseLinkOrmEntityTests.assertEquals(null, (Object)ormContextCaching.getExpiry());
    }

    public void testModifyCacheExpiry() throws Exception {
        this.createTestEntityForCaching();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmEclipseLinkEntity ormContextEntity = (OrmEclipseLinkEntity)ormPersistentType.getMapping();
        OrmEclipseLinkCaching ormContextCaching = ormContextEntity.getCaching();
        XmlEntity resourceEntity = (XmlEntity)this.getXmlEntityMappings().getEntities().get(0);
        EclipseLinkOrmEntityTests.assertEquals(null, (Object)resourceEntity.getCache());
        EclipseLinkOrmEntityTests.assertEquals(null, (Object)ormContextCaching.getExpiry());
        ormContextEntity.getCaching().setExpiry(new Integer(60));
        EclipseLinkOrmEntityTests.assertEquals((Object)new Integer(60), (Object)resourceEntity.getCache().getExpiry());
        EclipseLinkOrmEntityTests.assertEquals((Object)new Integer(60), (Object)ormContextCaching.getExpiry());
        ormContextEntity.getCaching().setExpiry(null);
        EclipseLinkOrmEntityTests.assertEquals(null, (Object)resourceEntity.getCache());
        EclipseLinkOrmEntityTests.assertEquals(null, (Object)ormContextCaching.getExpiry());
    }

    public void testUpdateCacheExpiryTimeOfDay() throws Exception {
        this.createTestEntityForCaching();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        JavaEclipseLinkCaching javaContextCaching = ((JavaEclipseLinkEntity)ormPersistentType.getJavaPersistentType().getMapping()).getCaching();
        OrmEclipseLinkEntity ormContextEntity = (OrmEclipseLinkEntity)ormPersistentType.getMapping();
        OrmEclipseLinkCaching ormContextCaching = ormContextEntity.getCaching();
        XmlEntity resourceEntity = (XmlEntity)this.getXmlEntityMappings().getEntities().get(0);
        EclipseLinkOrmEntityTests.assertEquals(null, (Object)resourceEntity.getCache());
        EclipseLinkOrmEntityTests.assertEquals(null, (Object)javaContextCaching.getExpiryTimeOfDay());
        EclipseLinkOrmEntityTests.assertEquals(null, (Object)ormContextCaching.getExpiryTimeOfDay());
        resourceEntity.setCache(EclipseLinkOrmFactory.eINSTANCE.createXmlCache());
        EclipseLinkOrmEntityTests.assertEquals(null, (Object)resourceEntity.getCache().getExpiryTimeOfDay());
        EclipseLinkOrmEntityTests.assertEquals(null, (Object)javaContextCaching.getExpiryTimeOfDay());
        EclipseLinkOrmEntityTests.assertEquals(null, (Object)ormContextCaching.getExpiryTimeOfDay());
        resourceEntity.getCache().setExpiryTimeOfDay(EclipseLinkOrmFactory.eINSTANCE.createXmlTimeOfDay());
        resourceEntity.getCache().getExpiryTimeOfDay().setHour(new Integer(10));
        EclipseLinkOrmEntityTests.assertEquals((Object)new Integer(10), (Object)resourceEntity.getCache().getExpiryTimeOfDay().getHour());
        EclipseLinkOrmEntityTests.assertEquals(null, (Object)javaContextCaching.getExpiryTimeOfDay());
        EclipseLinkOrmEntityTests.assertEquals((Object)new Integer(10), (Object)ormContextCaching.getExpiryTimeOfDay().getHour());
        javaContextCaching.addExpiryTimeOfDay();
        javaContextCaching.getExpiryTimeOfDay().setHour(new Integer(12));
        EclipseLinkOrmEntityTests.assertEquals((Object)new Integer(10), (Object)resourceEntity.getCache().getExpiryTimeOfDay().getHour());
        EclipseLinkOrmEntityTests.assertEquals((Object)new Integer(12), (Object)javaContextCaching.getExpiryTimeOfDay().getHour());
        EclipseLinkOrmEntityTests.assertEquals((Object)new Integer(10), (Object)ormContextCaching.getExpiryTimeOfDay().getHour());
        resourceEntity.getCache().setExpiryTimeOfDay(null);
        EclipseLinkOrmEntityTests.assertEquals(null, (Object)resourceEntity.getCache().getExpiryTimeOfDay());
        EclipseLinkOrmEntityTests.assertEquals((Object)new Integer(12), (Object)javaContextCaching.getExpiryTimeOfDay().getHour());
        EclipseLinkOrmEntityTests.assertEquals(null, (Object)ormContextCaching.getExpiryTimeOfDay());
        resourceEntity.setCache(null);
        EclipseLinkOrmEntityTests.assertEquals(null, (Object)resourceEntity.getCache());
        EclipseLinkOrmEntityTests.assertEquals((Object)new Integer(12), (Object)javaContextCaching.getExpiryTimeOfDay().getHour());
        EclipseLinkOrmEntityTests.assertEquals(null, (Object)ormContextCaching.getExpiryTimeOfDay());
        ormContextEntity.setSpecifiedMetadataComplete(Boolean.TRUE);
        EclipseLinkOrmEntityTests.assertEquals(null, (Object)resourceEntity.getCache());
        EclipseLinkOrmEntityTests.assertEquals((Object)new Integer(12), (Object)javaContextCaching.getExpiryTimeOfDay().getHour());
        EclipseLinkOrmEntityTests.assertEquals(null, (Object)ormContextCaching.getExpiryTimeOfDay());
        ormContextEntity.setSpecifiedMetadataComplete(null);
        EclipseLinkOrmEntityTests.assertEquals(null, (Object)resourceEntity.getCache());
        EclipseLinkOrmEntityTests.assertEquals((Object)new Integer(12), (Object)javaContextCaching.getExpiryTimeOfDay().getHour());
        EclipseLinkOrmEntityTests.assertEquals(null, (Object)ormContextCaching.getExpiryTimeOfDay());
    }

    public void testModifyCacheExpiryTimeOfDay() throws Exception {
        this.createTestEntityForCaching();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmEclipseLinkEntity ormContextEntity = (OrmEclipseLinkEntity)ormPersistentType.getMapping();
        OrmEclipseLinkCaching ormContextCaching = ormContextEntity.getCaching();
        XmlEntity resourceEntity = (XmlEntity)this.getXmlEntityMappings().getEntities().get(0);
        EclipseLinkOrmEntityTests.assertEquals(null, (Object)resourceEntity.getCache());
        EclipseLinkOrmEntityTests.assertEquals(null, (Object)ormContextCaching.getExpiryTimeOfDay());
        ormContextEntity.getCaching().addExpiryTimeOfDay().setHour(new Integer(12));
        EclipseLinkOrmEntityTests.assertEquals((Object)new Integer(12), (Object)resourceEntity.getCache().getExpiryTimeOfDay().getHour());
        EclipseLinkOrmEntityTests.assertEquals((Object)new Integer(12), (Object)ormContextCaching.getExpiryTimeOfDay().getHour());
        ormContextEntity.getCaching().getExpiryTimeOfDay().setMinute(new Integer(35));
        EclipseLinkOrmEntityTests.assertEquals((Object)new Integer(12), (Object)resourceEntity.getCache().getExpiryTimeOfDay().getHour());
        EclipseLinkOrmEntityTests.assertEquals((Object)new Integer(12), (Object)ormContextCaching.getExpiryTimeOfDay().getHour());
        EclipseLinkOrmEntityTests.assertEquals((Object)new Integer(35), (Object)resourceEntity.getCache().getExpiryTimeOfDay().getMinute());
        EclipseLinkOrmEntityTests.assertEquals((Object)new Integer(35), (Object)ormContextCaching.getExpiryTimeOfDay().getMinute());
        ormContextEntity.getCaching().removeExpiryTimeOfDay();
        EclipseLinkOrmEntityTests.assertEquals(null, (Object)resourceEntity.getCache());
        EclipseLinkOrmEntityTests.assertEquals(null, (Object)ormContextCaching.getExpiryTimeOfDay());
    }

    public void testUpdateCustomConverters() throws Exception {
        this.createTestEntityForConverters();
        EclipseLinkPersistenceUnit persistenceUnit = this.getPersistenceUnit();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmEclipseLinkEntity ormContextEntity = (OrmEclipseLinkEntity)ormPersistentType.getMapping();
        EclipseLinkConverterHolder ormContextConverterHolder = ormContextEntity.getConverterHolder();
        XmlEntity resourceEntity = (XmlEntity)this.getXmlEntityMappings().getEntities().get(0);
        EclipseLinkOrmEntityTests.assertEquals((int)0, (int)ormContextConverterHolder.customConvertersSize());
        EclipseLinkOrmEntityTests.assertEquals((int)0, (int)resourceEntity.getConverters().size());
        EclipseLinkOrmEntityTests.assertEquals((int)0, (int)CollectionTools.size((Iterator)persistenceUnit.allConverters()));
        XmlConverter resourceConverter = EclipseLinkOrmFactory.eINSTANCE.createXmlConverter();
        resourceEntity.getConverters().add((Object)resourceConverter);
        resourceConverter.setClassName("Foo");
        resourceConverter.setName("myConverter");
        EclipseLinkOrmEntityTests.assertEquals((int)1, (int)ormContextConverterHolder.customConvertersSize());
        ListIterator ormContextConverters = ormContextConverterHolder.customConverters();
        EclipseLinkCustomConverter ormContextConverter = (EclipseLinkCustomConverter)ormContextConverters.next();
        EclipseLinkOrmEntityTests.assertEquals((String)"Foo", (String)ormContextConverter.getConverterClass());
        EclipseLinkOrmEntityTests.assertEquals((String)"myConverter", (String)ormContextConverter.getName());
        EclipseLinkOrmEntityTests.assertEquals((int)1, (int)resourceEntity.getConverters().size());
        EclipseLinkOrmEntityTests.assertEquals((int)1, (int)CollectionTools.size((Iterator)persistenceUnit.allConverters()));
        XmlConverter resourceConverter2 = EclipseLinkOrmFactory.eINSTANCE.createXmlConverter();
        resourceEntity.getConverters().add(0, (Object)resourceConverter2);
        resourceConverter2.setClassName("Foo2");
        resourceConverter2.setName("myConverter2");
        EclipseLinkOrmEntityTests.assertEquals((int)2, (int)ormContextConverterHolder.customConvertersSize());
        ormContextConverters = ormContextConverterHolder.customConverters();
        ormContextConverter = (EclipseLinkCustomConverter)ormContextConverters.next();
        EclipseLinkOrmEntityTests.assertEquals((String)"Foo2", (String)ormContextConverter.getConverterClass());
        EclipseLinkOrmEntityTests.assertEquals((String)"myConverter2", (String)ormContextConverter.getName());
        ormContextConverter = (EclipseLinkCustomConverter)ormContextConverters.next();
        EclipseLinkOrmEntityTests.assertEquals((String)"Foo", (String)ormContextConverter.getConverterClass());
        EclipseLinkOrmEntityTests.assertEquals((String)"myConverter", (String)ormContextConverter.getName());
        EclipseLinkOrmEntityTests.assertEquals((int)2, (int)resourceEntity.getConverters().size());
        EclipseLinkOrmEntityTests.assertEquals((int)2, (int)CollectionTools.size((Iterator)persistenceUnit.allConverters()));
        resourceEntity.getConverters().move(0, 1);
        EclipseLinkOrmEntityTests.assertEquals((int)2, (int)ormContextConverterHolder.customConvertersSize());
        ormContextConverters = ormContextConverterHolder.customConverters();
        ormContextConverter = (EclipseLinkCustomConverter)ormContextConverters.next();
        EclipseLinkOrmEntityTests.assertEquals((String)"Foo", (String)ormContextConverter.getConverterClass());
        EclipseLinkOrmEntityTests.assertEquals((String)"myConverter", (String)ormContextConverter.getName());
        ormContextConverter = (EclipseLinkCustomConverter)ormContextConverters.next();
        EclipseLinkOrmEntityTests.assertEquals((String)"Foo2", (String)ormContextConverter.getConverterClass());
        EclipseLinkOrmEntityTests.assertEquals((String)"myConverter2", (String)ormContextConverter.getName());
        EclipseLinkOrmEntityTests.assertEquals((int)2, (int)resourceEntity.getConverters().size());
        EclipseLinkOrmEntityTests.assertEquals((int)2, (int)CollectionTools.size((Iterator)persistenceUnit.allConverters()));
        resourceEntity.getConverters().remove(0);
        EclipseLinkOrmEntityTests.assertEquals((int)1, (int)ormContextConverterHolder.customConvertersSize());
        ormContextConverters = ormContextConverterHolder.customConverters();
        ormContextConverter = (EclipseLinkCustomConverter)ormContextConverters.next();
        EclipseLinkOrmEntityTests.assertEquals((String)"Foo2", (String)ormContextConverter.getConverterClass());
        EclipseLinkOrmEntityTests.assertEquals((String)"myConverter2", (String)ormContextConverter.getName());
        EclipseLinkOrmEntityTests.assertEquals((int)1, (int)resourceEntity.getConverters().size());
        EclipseLinkOrmEntityTests.assertEquals((int)1, (int)CollectionTools.size((Iterator)persistenceUnit.allConverters()));
        resourceEntity.getConverters().remove((Object)resourceConverter2);
        EclipseLinkOrmEntityTests.assertEquals((int)0, (int)ormContextConverterHolder.customConvertersSize());
        EclipseLinkOrmEntityTests.assertFalse((boolean)ormContextConverterHolder.customConverters().hasNext());
        EclipseLinkOrmEntityTests.assertEquals((int)0, (int)resourceEntity.getConverters().size());
        EclipseLinkOrmEntityTests.assertEquals((int)0, (int)CollectionTools.size((Iterator)persistenceUnit.allConverters()));
    }

    public void testModifyCustomConverters() throws Exception {
        this.createTestEntityForConverters();
        EclipseLinkPersistenceUnit persistenceUnit = this.getPersistenceUnit();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmEclipseLinkEntity ormContextEntity = (OrmEclipseLinkEntity)ormPersistentType.getMapping();
        EclipseLinkConverterHolder ormContextConverterHolder = ormContextEntity.getConverterHolder();
        XmlEntity resourceEntity = (XmlEntity)this.getXmlEntityMappings().getEntities().get(0);
        EclipseLinkOrmEntityTests.assertEquals((int)0, (int)ormContextConverterHolder.customConvertersSize());
        EclipseLinkOrmEntityTests.assertEquals((int)0, (int)resourceEntity.getConverters().size());
        EclipseLinkOrmEntityTests.assertEquals((int)0, (int)CollectionTools.size((Iterator)persistenceUnit.allConverters()));
        EclipseLinkCustomConverter contextConverter = ormContextConverterHolder.addCustomConverter(0);
        contextConverter.setConverterClass("Foo");
        contextConverter.setName("myConverter");
        EclipseLinkOrmEntityTests.assertEquals((int)1, (int)resourceEntity.getConverters().size());
        EclipseLinkOrmEntityTests.assertEquals((String)"Foo", (String)((XmlConverter)resourceEntity.getConverters().get(0)).getClassName());
        EclipseLinkOrmEntityTests.assertEquals((String)"myConverter", (String)((XmlConverter)resourceEntity.getConverters().get(0)).getName());
        EclipseLinkOrmEntityTests.assertEquals((int)1, (int)ormContextConverterHolder.customConvertersSize());
        ListIterator ormContextConverters = ormContextConverterHolder.customConverters();
        EclipseLinkCustomConverter ormContextConverter = (EclipseLinkCustomConverter)ormContextConverters.next();
        EclipseLinkOrmEntityTests.assertEquals((String)"Foo", (String)ormContextConverter.getConverterClass());
        EclipseLinkOrmEntityTests.assertEquals((String)"myConverter", (String)ormContextConverter.getName());
        EclipseLinkOrmEntityTests.assertEquals((int)1, (int)CollectionTools.size((Iterator)persistenceUnit.allConverters()));
        EclipseLinkCustomConverter contextConverter2 = ormContextConverterHolder.addCustomConverter(0);
        contextConverter2.setConverterClass("Foo2");
        contextConverter2.setName("myConverter2");
        EclipseLinkOrmEntityTests.assertEquals((int)2, (int)resourceEntity.getConverters().size());
        EclipseLinkOrmEntityTests.assertEquals((String)"Foo2", (String)((XmlConverter)resourceEntity.getConverters().get(0)).getClassName());
        EclipseLinkOrmEntityTests.assertEquals((String)"myConverter2", (String)((XmlConverter)resourceEntity.getConverters().get(0)).getName());
        EclipseLinkOrmEntityTests.assertEquals((String)"Foo", (String)((XmlConverter)resourceEntity.getConverters().get(1)).getClassName());
        EclipseLinkOrmEntityTests.assertEquals((String)"myConverter", (String)((XmlConverter)resourceEntity.getConverters().get(1)).getName());
        EclipseLinkOrmEntityTests.assertEquals((int)2, (int)ormContextConverterHolder.customConvertersSize());
        ormContextConverters = ormContextConverterHolder.customConverters();
        ormContextConverter = (EclipseLinkCustomConverter)ormContextConverters.next();
        EclipseLinkOrmEntityTests.assertEquals((String)"Foo2", (String)ormContextConverter.getConverterClass());
        EclipseLinkOrmEntityTests.assertEquals((String)"myConverter2", (String)ormContextConverter.getName());
        ormContextConverter = (EclipseLinkCustomConverter)ormContextConverters.next();
        EclipseLinkOrmEntityTests.assertEquals((String)"Foo", (String)ormContextConverter.getConverterClass());
        EclipseLinkOrmEntityTests.assertEquals((String)"myConverter", (String)ormContextConverter.getName());
        EclipseLinkOrmEntityTests.assertEquals((int)2, (int)CollectionTools.size((Iterator)persistenceUnit.allConverters()));
        ormContextConverterHolder.moveCustomConverter(0, 1);
        EclipseLinkOrmEntityTests.assertEquals((int)2, (int)resourceEntity.getConverters().size());
        EclipseLinkOrmEntityTests.assertEquals((String)"Foo", (String)((XmlConverter)resourceEntity.getConverters().get(0)).getClassName());
        EclipseLinkOrmEntityTests.assertEquals((String)"myConverter", (String)((XmlConverter)resourceEntity.getConverters().get(0)).getName());
        EclipseLinkOrmEntityTests.assertEquals((String)"Foo2", (String)((XmlConverter)resourceEntity.getConverters().get(1)).getClassName());
        EclipseLinkOrmEntityTests.assertEquals((String)"myConverter2", (String)((XmlConverter)resourceEntity.getConverters().get(1)).getName());
        EclipseLinkOrmEntityTests.assertEquals((int)2, (int)ormContextConverterHolder.customConvertersSize());
        ormContextConverters = ormContextConverterHolder.customConverters();
        ormContextConverter = (EclipseLinkCustomConverter)ormContextConverters.next();
        EclipseLinkOrmEntityTests.assertEquals((String)"Foo", (String)ormContextConverter.getConverterClass());
        EclipseLinkOrmEntityTests.assertEquals((String)"myConverter", (String)ormContextConverter.getName());
        ormContextConverter = (EclipseLinkCustomConverter)ormContextConverters.next();
        EclipseLinkOrmEntityTests.assertEquals((String)"Foo2", (String)ormContextConverter.getConverterClass());
        EclipseLinkOrmEntityTests.assertEquals((String)"myConverter2", (String)ormContextConverter.getName());
        EclipseLinkOrmEntityTests.assertEquals((int)2, (int)CollectionTools.size((Iterator)persistenceUnit.allConverters()));
        ormContextConverterHolder.removeCustomConverter(0);
        EclipseLinkOrmEntityTests.assertEquals((int)1, (int)resourceEntity.getConverters().size());
        EclipseLinkOrmEntityTests.assertEquals((String)"Foo2", (String)((XmlConverter)resourceEntity.getConverters().get(0)).getClassName());
        EclipseLinkOrmEntityTests.assertEquals((String)"myConverter2", (String)((XmlConverter)resourceEntity.getConverters().get(0)).getName());
        EclipseLinkOrmEntityTests.assertEquals((int)1, (int)ormContextConverterHolder.customConvertersSize());
        ormContextConverters = ormContextConverterHolder.customConverters();
        ormContextConverter = (EclipseLinkCustomConverter)ormContextConverters.next();
        EclipseLinkOrmEntityTests.assertEquals((String)"Foo2", (String)ormContextConverter.getConverterClass());
        EclipseLinkOrmEntityTests.assertEquals((String)"myConverter2", (String)ormContextConverter.getName());
        EclipseLinkOrmEntityTests.assertEquals((int)1, (int)CollectionTools.size((Iterator)persistenceUnit.allConverters()));
        ormContextConverterHolder.removeCustomConverter(contextConverter2);
        EclipseLinkOrmEntityTests.assertEquals((int)0, (int)ormContextConverterHolder.customConvertersSize());
        EclipseLinkOrmEntityTests.assertFalse((boolean)ormContextConverterHolder.customConverters().hasNext());
        EclipseLinkOrmEntityTests.assertEquals((int)0, (int)resourceEntity.getConverters().size());
        EclipseLinkOrmEntityTests.assertEquals((int)0, (int)CollectionTools.size((Iterator)persistenceUnit.allConverters()));
    }

    public void testUpdateTypeConverters() throws Exception {
        this.createTestEntityForTypeConverters();
        EclipseLinkPersistenceUnit persistenceUnit = this.getPersistenceUnit();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmEclipseLinkEntity ormContextEntity = (OrmEclipseLinkEntity)ormPersistentType.getMapping();
        EclipseLinkConverterHolder ormContextConverterHolder = ormContextEntity.getConverterHolder();
        XmlEntity resourceEntity = (XmlEntity)this.getXmlEntityMappings().getEntities().get(0);
        EclipseLinkOrmEntityTests.assertEquals((int)0, (int)ormContextConverterHolder.typeConvertersSize());
        EclipseLinkOrmEntityTests.assertEquals((int)0, (int)resourceEntity.getTypeConverters().size());
        EclipseLinkOrmEntityTests.assertEquals((int)0, (int)CollectionTools.size((Iterator)persistenceUnit.allConverters()));
        XmlTypeConverter resourceTypeConverter = EclipseLinkOrmFactory.eINSTANCE.createXmlTypeConverter();
        resourceEntity.getTypeConverters().add((Object)resourceTypeConverter);
        resourceTypeConverter.setDataType("Foo");
        resourceTypeConverter.setName("myTypeConverter");
        EclipseLinkOrmEntityTests.assertEquals((int)1, (int)ormContextConverterHolder.typeConvertersSize());
        ListIterator ormContextTypeConverters = ormContextConverterHolder.typeConverters();
        EclipseLinkTypeConverter ormContextTypeConverter = (EclipseLinkTypeConverter)ormContextTypeConverters.next();
        EclipseLinkOrmEntityTests.assertEquals((String)"Foo", (String)ormContextTypeConverter.getDataType());
        EclipseLinkOrmEntityTests.assertEquals((String)"myTypeConverter", (String)ormContextTypeConverter.getName());
        EclipseLinkOrmEntityTests.assertEquals((int)1, (int)resourceEntity.getTypeConverters().size());
        EclipseLinkOrmEntityTests.assertEquals((int)1, (int)CollectionTools.size((Iterator)persistenceUnit.allConverters()));
        XmlTypeConverter resourceTypeConverter2 = EclipseLinkOrmFactory.eINSTANCE.createXmlTypeConverter();
        resourceEntity.getTypeConverters().add(0, (Object)resourceTypeConverter2);
        resourceTypeConverter2.setDataType("Foo2");
        resourceTypeConverter2.setName("myTypeConverter2");
        EclipseLinkOrmEntityTests.assertEquals((int)2, (int)ormContextConverterHolder.typeConvertersSize());
        ormContextTypeConverters = ormContextConverterHolder.typeConverters();
        ormContextTypeConverter = (EclipseLinkTypeConverter)ormContextTypeConverters.next();
        EclipseLinkOrmEntityTests.assertEquals((String)"Foo2", (String)ormContextTypeConverter.getDataType());
        EclipseLinkOrmEntityTests.assertEquals((String)"myTypeConverter2", (String)ormContextTypeConverter.getName());
        ormContextTypeConverter = (EclipseLinkTypeConverter)ormContextTypeConverters.next();
        EclipseLinkOrmEntityTests.assertEquals((String)"Foo", (String)ormContextTypeConverter.getDataType());
        EclipseLinkOrmEntityTests.assertEquals((String)"myTypeConverter", (String)ormContextTypeConverter.getName());
        EclipseLinkOrmEntityTests.assertEquals((int)2, (int)resourceEntity.getTypeConverters().size());
        EclipseLinkOrmEntityTests.assertEquals((int)2, (int)CollectionTools.size((Iterator)persistenceUnit.allConverters()));
        resourceEntity.getTypeConverters().move(0, 1);
        EclipseLinkOrmEntityTests.assertEquals((int)2, (int)ormContextConverterHolder.typeConvertersSize());
        ormContextTypeConverters = ormContextConverterHolder.typeConverters();
        ormContextTypeConverter = (EclipseLinkTypeConverter)ormContextTypeConverters.next();
        EclipseLinkOrmEntityTests.assertEquals((String)"Foo", (String)ormContextTypeConverter.getDataType());
        EclipseLinkOrmEntityTests.assertEquals((String)"myTypeConverter", (String)ormContextTypeConverter.getName());
        ormContextTypeConverter = (EclipseLinkTypeConverter)ormContextTypeConverters.next();
        EclipseLinkOrmEntityTests.assertEquals((String)"Foo2", (String)ormContextTypeConverter.getDataType());
        EclipseLinkOrmEntityTests.assertEquals((String)"myTypeConverter2", (String)ormContextTypeConverter.getName());
        EclipseLinkOrmEntityTests.assertEquals((int)2, (int)resourceEntity.getTypeConverters().size());
        EclipseLinkOrmEntityTests.assertEquals((int)2, (int)CollectionTools.size((Iterator)persistenceUnit.allConverters()));
        resourceEntity.getTypeConverters().remove(0);
        EclipseLinkOrmEntityTests.assertEquals((int)1, (int)ormContextConverterHolder.typeConvertersSize());
        ormContextTypeConverters = ormContextConverterHolder.typeConverters();
        ormContextTypeConverter = (EclipseLinkTypeConverter)ormContextTypeConverters.next();
        EclipseLinkOrmEntityTests.assertEquals((String)"Foo2", (String)ormContextTypeConverter.getDataType());
        EclipseLinkOrmEntityTests.assertEquals((String)"myTypeConverter2", (String)ormContextTypeConverter.getName());
        EclipseLinkOrmEntityTests.assertEquals((int)1, (int)resourceEntity.getTypeConverters().size());
        EclipseLinkOrmEntityTests.assertEquals((int)1, (int)CollectionTools.size((Iterator)persistenceUnit.allConverters()));
        resourceEntity.getTypeConverters().remove((Object)resourceTypeConverter2);
        EclipseLinkOrmEntityTests.assertEquals((int)0, (int)ormContextConverterHolder.typeConvertersSize());
        EclipseLinkOrmEntityTests.assertFalse((boolean)ormContextConverterHolder.typeConverters().hasNext());
        EclipseLinkOrmEntityTests.assertEquals((int)0, (int)resourceEntity.getTypeConverters().size());
        EclipseLinkOrmEntityTests.assertEquals((int)0, (int)CollectionTools.size((Iterator)persistenceUnit.allConverters()));
    }

    public void testModifyTypeConverters() throws Exception {
        this.createTestEntityForTypeConverters();
        EclipseLinkPersistenceUnit persistenceUnit = this.getPersistenceUnit();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmEclipseLinkEntity ormContextEntity = (OrmEclipseLinkEntity)ormPersistentType.getMapping();
        EclipseLinkConverterHolder ormContextConverterHolder = ormContextEntity.getConverterHolder();
        XmlEntity resourceEntity = (XmlEntity)this.getXmlEntityMappings().getEntities().get(0);
        EclipseLinkOrmEntityTests.assertEquals((int)0, (int)ormContextConverterHolder.typeConvertersSize());
        EclipseLinkOrmEntityTests.assertEquals((int)0, (int)resourceEntity.getTypeConverters().size());
        EclipseLinkOrmEntityTests.assertEquals((int)0, (int)CollectionTools.size((Iterator)persistenceUnit.allConverters()));
        EclipseLinkTypeConverter contextTypeConverter = ormContextConverterHolder.addTypeConverter(0);
        contextTypeConverter.setDataType("Foo");
        contextTypeConverter.setName("myTypeConverter");
        EclipseLinkOrmEntityTests.assertEquals((int)1, (int)resourceEntity.getTypeConverters().size());
        EclipseLinkOrmEntityTests.assertEquals((String)"Foo", (String)((XmlTypeConverter)resourceEntity.getTypeConverters().get(0)).getDataType());
        EclipseLinkOrmEntityTests.assertEquals((String)"myTypeConverter", (String)((XmlTypeConverter)resourceEntity.getTypeConverters().get(0)).getName());
        EclipseLinkOrmEntityTests.assertEquals((int)1, (int)ormContextConverterHolder.typeConvertersSize());
        ListIterator ormContextTypeConverters = ormContextConverterHolder.typeConverters();
        EclipseLinkTypeConverter ormContextTypeConverter = (EclipseLinkTypeConverter)ormContextTypeConverters.next();
        EclipseLinkOrmEntityTests.assertEquals((String)"Foo", (String)ormContextTypeConverter.getDataType());
        EclipseLinkOrmEntityTests.assertEquals((String)"myTypeConverter", (String)ormContextTypeConverter.getName());
        EclipseLinkOrmEntityTests.assertEquals((int)1, (int)CollectionTools.size((Iterator)persistenceUnit.allConverters()));
        EclipseLinkTypeConverter contextTypeConverter2 = ormContextConverterHolder.addTypeConverter(0);
        contextTypeConverter2.setDataType("Foo2");
        contextTypeConverter2.setName("myTypeConverter2");
        EclipseLinkOrmEntityTests.assertEquals((int)2, (int)resourceEntity.getTypeConverters().size());
        EclipseLinkOrmEntityTests.assertEquals((String)"Foo2", (String)((XmlTypeConverter)resourceEntity.getTypeConverters().get(0)).getDataType());
        EclipseLinkOrmEntityTests.assertEquals((String)"myTypeConverter2", (String)((XmlTypeConverter)resourceEntity.getTypeConverters().get(0)).getName());
        EclipseLinkOrmEntityTests.assertEquals((String)"Foo", (String)((XmlTypeConverter)resourceEntity.getTypeConverters().get(1)).getDataType());
        EclipseLinkOrmEntityTests.assertEquals((String)"myTypeConverter", (String)((XmlTypeConverter)resourceEntity.getTypeConverters().get(1)).getName());
        EclipseLinkOrmEntityTests.assertEquals((int)2, (int)ormContextConverterHolder.typeConvertersSize());
        ormContextTypeConverters = ormContextConverterHolder.typeConverters();
        ormContextTypeConverter = (EclipseLinkTypeConverter)ormContextTypeConverters.next();
        EclipseLinkOrmEntityTests.assertEquals((String)"Foo2", (String)ormContextTypeConverter.getDataType());
        EclipseLinkOrmEntityTests.assertEquals((String)"myTypeConverter2", (String)ormContextTypeConverter.getName());
        ormContextTypeConverter = (EclipseLinkTypeConverter)ormContextTypeConverters.next();
        EclipseLinkOrmEntityTests.assertEquals((String)"Foo", (String)ormContextTypeConverter.getDataType());
        EclipseLinkOrmEntityTests.assertEquals((String)"myTypeConverter", (String)ormContextTypeConverter.getName());
        EclipseLinkOrmEntityTests.assertEquals((int)2, (int)CollectionTools.size((Iterator)persistenceUnit.allConverters()));
        ormContextConverterHolder.moveTypeConverter(0, 1);
        EclipseLinkOrmEntityTests.assertEquals((int)2, (int)resourceEntity.getTypeConverters().size());
        EclipseLinkOrmEntityTests.assertEquals((String)"Foo", (String)((XmlTypeConverter)resourceEntity.getTypeConverters().get(0)).getDataType());
        EclipseLinkOrmEntityTests.assertEquals((String)"myTypeConverter", (String)((XmlTypeConverter)resourceEntity.getTypeConverters().get(0)).getName());
        EclipseLinkOrmEntityTests.assertEquals((String)"Foo2", (String)((XmlTypeConverter)resourceEntity.getTypeConverters().get(1)).getDataType());
        EclipseLinkOrmEntityTests.assertEquals((String)"myTypeConverter2", (String)((XmlTypeConverter)resourceEntity.getTypeConverters().get(1)).getName());
        EclipseLinkOrmEntityTests.assertEquals((int)2, (int)ormContextConverterHolder.typeConvertersSize());
        ormContextTypeConverters = ormContextConverterHolder.typeConverters();
        ormContextTypeConverter = (EclipseLinkTypeConverter)ormContextTypeConverters.next();
        EclipseLinkOrmEntityTests.assertEquals((String)"Foo", (String)ormContextTypeConverter.getDataType());
        EclipseLinkOrmEntityTests.assertEquals((String)"myTypeConverter", (String)ormContextTypeConverter.getName());
        ormContextTypeConverter = (EclipseLinkTypeConverter)ormContextTypeConverters.next();
        EclipseLinkOrmEntityTests.assertEquals((String)"Foo2", (String)ormContextTypeConverter.getDataType());
        EclipseLinkOrmEntityTests.assertEquals((String)"myTypeConverter2", (String)ormContextTypeConverter.getName());
        EclipseLinkOrmEntityTests.assertEquals((int)2, (int)CollectionTools.size((Iterator)persistenceUnit.allConverters()));
        ormContextConverterHolder.removeTypeConverter(0);
        EclipseLinkOrmEntityTests.assertEquals((int)1, (int)resourceEntity.getTypeConverters().size());
        EclipseLinkOrmEntityTests.assertEquals((String)"Foo2", (String)((XmlTypeConverter)resourceEntity.getTypeConverters().get(0)).getDataType());
        EclipseLinkOrmEntityTests.assertEquals((String)"myTypeConverter2", (String)((XmlTypeConverter)resourceEntity.getTypeConverters().get(0)).getName());
        EclipseLinkOrmEntityTests.assertEquals((int)1, (int)ormContextConverterHolder.typeConvertersSize());
        ormContextTypeConverters = ormContextConverterHolder.typeConverters();
        ormContextTypeConverter = (EclipseLinkTypeConverter)ormContextTypeConverters.next();
        EclipseLinkOrmEntityTests.assertEquals((String)"Foo2", (String)ormContextTypeConverter.getDataType());
        EclipseLinkOrmEntityTests.assertEquals((String)"myTypeConverter2", (String)ormContextTypeConverter.getName());
        EclipseLinkOrmEntityTests.assertEquals((int)1, (int)CollectionTools.size((Iterator)persistenceUnit.allConverters()));
        ormContextConverterHolder.removeTypeConverter(contextTypeConverter2);
        EclipseLinkOrmEntityTests.assertEquals((int)0, (int)ormContextConverterHolder.typeConvertersSize());
        EclipseLinkOrmEntityTests.assertFalse((boolean)ormContextConverterHolder.typeConverters().hasNext());
        EclipseLinkOrmEntityTests.assertEquals((int)0, (int)resourceEntity.getTypeConverters().size());
        EclipseLinkOrmEntityTests.assertEquals((int)0, (int)CollectionTools.size((Iterator)persistenceUnit.allConverters()));
    }

    public void testUpdateObjectTypeConverters() throws Exception {
        this.createTestEntityForObjectTypeConverters();
        EclipseLinkPersistenceUnit persistenceUnit = this.getPersistenceUnit();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmEclipseLinkEntity ormContextEntity = (OrmEclipseLinkEntity)ormPersistentType.getMapping();
        EclipseLinkConverterHolder ormContextConverterHolder = ormContextEntity.getConverterHolder();
        XmlEntity resourceEntity = (XmlEntity)this.getXmlEntityMappings().getEntities().get(0);
        EclipseLinkOrmEntityTests.assertEquals((int)0, (int)ormContextConverterHolder.objectTypeConvertersSize());
        EclipseLinkOrmEntityTests.assertEquals((int)0, (int)resourceEntity.getObjectTypeConverters().size());
        EclipseLinkOrmEntityTests.assertEquals((int)0, (int)CollectionTools.size((Iterator)persistenceUnit.allConverters()));
        XmlObjectTypeConverter resourceObjectTypeConverter = EclipseLinkOrmFactory.eINSTANCE.createXmlObjectTypeConverter();
        resourceEntity.getObjectTypeConverters().add((Object)resourceObjectTypeConverter);
        resourceObjectTypeConverter.setDataType("Foo");
        resourceObjectTypeConverter.setName("myObjectTypeConverter");
        EclipseLinkOrmEntityTests.assertEquals((int)1, (int)ormContextConverterHolder.objectTypeConvertersSize());
        ListIterator ormContextObjectTypeConverters = ormContextConverterHolder.objectTypeConverters();
        EclipseLinkObjectTypeConverter ormContextObjectTypeConverter = (EclipseLinkObjectTypeConverter)ormContextObjectTypeConverters.next();
        EclipseLinkOrmEntityTests.assertEquals((String)"Foo", (String)ormContextObjectTypeConverter.getDataType());
        EclipseLinkOrmEntityTests.assertEquals((String)"myObjectTypeConverter", (String)ormContextObjectTypeConverter.getName());
        EclipseLinkOrmEntityTests.assertEquals((int)1, (int)resourceEntity.getObjectTypeConverters().size());
        EclipseLinkOrmEntityTests.assertEquals((int)1, (int)CollectionTools.size((Iterator)persistenceUnit.allConverters()));
        XmlObjectTypeConverter resourceObjectTypeConverter2 = EclipseLinkOrmFactory.eINSTANCE.createXmlObjectTypeConverter();
        resourceEntity.getObjectTypeConverters().add(0, (Object)resourceObjectTypeConverter2);
        resourceObjectTypeConverter2.setDataType("Foo2");
        resourceObjectTypeConverter2.setName("myObjectTypeConverter2");
        EclipseLinkOrmEntityTests.assertEquals((int)2, (int)ormContextConverterHolder.objectTypeConvertersSize());
        ormContextObjectTypeConverters = ormContextConverterHolder.objectTypeConverters();
        ormContextObjectTypeConverter = (EclipseLinkObjectTypeConverter)ormContextObjectTypeConverters.next();
        EclipseLinkOrmEntityTests.assertEquals((String)"Foo2", (String)ormContextObjectTypeConverter.getDataType());
        EclipseLinkOrmEntityTests.assertEquals((String)"myObjectTypeConverter2", (String)ormContextObjectTypeConverter.getName());
        ormContextObjectTypeConverter = (EclipseLinkObjectTypeConverter)ormContextObjectTypeConverters.next();
        EclipseLinkOrmEntityTests.assertEquals((String)"Foo", (String)ormContextObjectTypeConverter.getDataType());
        EclipseLinkOrmEntityTests.assertEquals((String)"myObjectTypeConverter", (String)ormContextObjectTypeConverter.getName());
        EclipseLinkOrmEntityTests.assertEquals((int)2, (int)resourceEntity.getObjectTypeConverters().size());
        EclipseLinkOrmEntityTests.assertEquals((int)2, (int)CollectionTools.size((Iterator)persistenceUnit.allConverters()));
        resourceEntity.getObjectTypeConverters().move(0, 1);
        EclipseLinkOrmEntityTests.assertEquals((int)2, (int)ormContextConverterHolder.objectTypeConvertersSize());
        ormContextObjectTypeConverters = ormContextConverterHolder.objectTypeConverters();
        ormContextObjectTypeConverter = (EclipseLinkObjectTypeConverter)ormContextObjectTypeConverters.next();
        EclipseLinkOrmEntityTests.assertEquals((String)"Foo", (String)ormContextObjectTypeConverter.getDataType());
        EclipseLinkOrmEntityTests.assertEquals((String)"myObjectTypeConverter", (String)ormContextObjectTypeConverter.getName());
        ormContextObjectTypeConverter = (EclipseLinkObjectTypeConverter)ormContextObjectTypeConverters.next();
        EclipseLinkOrmEntityTests.assertEquals((String)"Foo2", (String)ormContextObjectTypeConverter.getDataType());
        EclipseLinkOrmEntityTests.assertEquals((String)"myObjectTypeConverter2", (String)ormContextObjectTypeConverter.getName());
        EclipseLinkOrmEntityTests.assertEquals((int)2, (int)resourceEntity.getObjectTypeConverters().size());
        EclipseLinkOrmEntityTests.assertEquals((int)2, (int)CollectionTools.size((Iterator)persistenceUnit.allConverters()));
        resourceEntity.getObjectTypeConverters().remove(0);
        EclipseLinkOrmEntityTests.assertEquals((int)1, (int)ormContextConverterHolder.objectTypeConvertersSize());
        ormContextObjectTypeConverters = ormContextConverterHolder.objectTypeConverters();
        ormContextObjectTypeConverter = (EclipseLinkObjectTypeConverter)ormContextObjectTypeConverters.next();
        EclipseLinkOrmEntityTests.assertEquals((String)"Foo2", (String)ormContextObjectTypeConverter.getDataType());
        EclipseLinkOrmEntityTests.assertEquals((String)"myObjectTypeConverter2", (String)ormContextObjectTypeConverter.getName());
        EclipseLinkOrmEntityTests.assertEquals((int)1, (int)resourceEntity.getObjectTypeConverters().size());
        EclipseLinkOrmEntityTests.assertEquals((int)1, (int)CollectionTools.size((Iterator)persistenceUnit.allConverters()));
        resourceEntity.getObjectTypeConverters().remove((Object)resourceObjectTypeConverter2);
        EclipseLinkOrmEntityTests.assertEquals((int)0, (int)ormContextConverterHolder.objectTypeConvertersSize());
        EclipseLinkOrmEntityTests.assertFalse((boolean)ormContextConverterHolder.objectTypeConverters().hasNext());
        EclipseLinkOrmEntityTests.assertEquals((int)0, (int)resourceEntity.getObjectTypeConverters().size());
        EclipseLinkOrmEntityTests.assertEquals((int)0, (int)CollectionTools.size((Iterator)persistenceUnit.allConverters()));
    }

    public void testModifyObjectTypeConverters() throws Exception {
        this.createTestEntityForObjectTypeConverters();
        EclipseLinkPersistenceUnit persistenceUnit = this.getPersistenceUnit();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmEclipseLinkEntity ormContextEntity = (OrmEclipseLinkEntity)ormPersistentType.getMapping();
        EclipseLinkConverterHolder ormContextConverterHolder = ormContextEntity.getConverterHolder();
        XmlEntity resourceEntity = (XmlEntity)this.getXmlEntityMappings().getEntities().get(0);
        EclipseLinkOrmEntityTests.assertEquals((int)0, (int)ormContextConverterHolder.objectTypeConvertersSize());
        EclipseLinkOrmEntityTests.assertEquals((int)0, (int)resourceEntity.getObjectTypeConverters().size());
        EclipseLinkOrmEntityTests.assertEquals((int)0, (int)CollectionTools.size((Iterator)persistenceUnit.allConverters()));
        EclipseLinkObjectTypeConverter contextObjectTypeConverter = ormContextConverterHolder.addObjectTypeConverter(0);
        contextObjectTypeConverter.setDataType("Foo");
        contextObjectTypeConverter.setName("myObjectTypeConverter");
        EclipseLinkOrmEntityTests.assertEquals((int)1, (int)resourceEntity.getObjectTypeConverters().size());
        EclipseLinkOrmEntityTests.assertEquals((String)"Foo", (String)((XmlObjectTypeConverter)resourceEntity.getObjectTypeConverters().get(0)).getDataType());
        EclipseLinkOrmEntityTests.assertEquals((String)"myObjectTypeConverter", (String)((XmlObjectTypeConverter)resourceEntity.getObjectTypeConverters().get(0)).getName());
        EclipseLinkOrmEntityTests.assertEquals((int)1, (int)ormContextConverterHolder.objectTypeConvertersSize());
        ListIterator ormContextObjectTypeConverters = ormContextConverterHolder.objectTypeConverters();
        EclipseLinkObjectTypeConverter ormContextObjectTypeConverter = (EclipseLinkObjectTypeConverter)ormContextObjectTypeConverters.next();
        EclipseLinkOrmEntityTests.assertEquals((String)"Foo", (String)ormContextObjectTypeConverter.getDataType());
        EclipseLinkOrmEntityTests.assertEquals((String)"myObjectTypeConverter", (String)ormContextObjectTypeConverter.getName());
        EclipseLinkOrmEntityTests.assertEquals((int)1, (int)CollectionTools.size((Iterator)persistenceUnit.allConverters()));
        EclipseLinkObjectTypeConverter contextObjectTypeConverter2 = ormContextConverterHolder.addObjectTypeConverter(0);
        contextObjectTypeConverter2.setDataType("Foo2");
        contextObjectTypeConverter2.setName("myObjectTypeConverter2");
        EclipseLinkOrmEntityTests.assertEquals((int)2, (int)resourceEntity.getObjectTypeConverters().size());
        EclipseLinkOrmEntityTests.assertEquals((String)"Foo2", (String)((XmlObjectTypeConverter)resourceEntity.getObjectTypeConverters().get(0)).getDataType());
        EclipseLinkOrmEntityTests.assertEquals((String)"myObjectTypeConverter2", (String)((XmlObjectTypeConverter)resourceEntity.getObjectTypeConverters().get(0)).getName());
        EclipseLinkOrmEntityTests.assertEquals((String)"Foo", (String)((XmlObjectTypeConverter)resourceEntity.getObjectTypeConverters().get(1)).getDataType());
        EclipseLinkOrmEntityTests.assertEquals((String)"myObjectTypeConverter", (String)((XmlObjectTypeConverter)resourceEntity.getObjectTypeConverters().get(1)).getName());
        EclipseLinkOrmEntityTests.assertEquals((int)2, (int)ormContextConverterHolder.objectTypeConvertersSize());
        ormContextObjectTypeConverters = ormContextConverterHolder.objectTypeConverters();
        ormContextObjectTypeConverter = (EclipseLinkObjectTypeConverter)ormContextObjectTypeConverters.next();
        EclipseLinkOrmEntityTests.assertEquals((String)"Foo2", (String)ormContextObjectTypeConverter.getDataType());
        EclipseLinkOrmEntityTests.assertEquals((String)"myObjectTypeConverter2", (String)ormContextObjectTypeConverter.getName());
        ormContextObjectTypeConverter = (EclipseLinkObjectTypeConverter)ormContextObjectTypeConverters.next();
        EclipseLinkOrmEntityTests.assertEquals((String)"Foo", (String)ormContextObjectTypeConverter.getDataType());
        EclipseLinkOrmEntityTests.assertEquals((String)"myObjectTypeConverter", (String)ormContextObjectTypeConverter.getName());
        EclipseLinkOrmEntityTests.assertEquals((int)2, (int)CollectionTools.size((Iterator)persistenceUnit.allConverters()));
        ormContextConverterHolder.moveObjectTypeConverter(0, 1);
        EclipseLinkOrmEntityTests.assertEquals((int)2, (int)resourceEntity.getObjectTypeConverters().size());
        EclipseLinkOrmEntityTests.assertEquals((String)"Foo", (String)((XmlObjectTypeConverter)resourceEntity.getObjectTypeConverters().get(0)).getDataType());
        EclipseLinkOrmEntityTests.assertEquals((String)"myObjectTypeConverter", (String)((XmlObjectTypeConverter)resourceEntity.getObjectTypeConverters().get(0)).getName());
        EclipseLinkOrmEntityTests.assertEquals((String)"Foo2", (String)((XmlObjectTypeConverter)resourceEntity.getObjectTypeConverters().get(1)).getDataType());
        EclipseLinkOrmEntityTests.assertEquals((String)"myObjectTypeConverter2", (String)((XmlObjectTypeConverter)resourceEntity.getObjectTypeConverters().get(1)).getName());
        EclipseLinkOrmEntityTests.assertEquals((int)2, (int)ormContextConverterHolder.objectTypeConvertersSize());
        ormContextObjectTypeConverters = ormContextConverterHolder.objectTypeConverters();
        ormContextObjectTypeConverter = (EclipseLinkObjectTypeConverter)ormContextObjectTypeConverters.next();
        EclipseLinkOrmEntityTests.assertEquals((String)"Foo", (String)ormContextObjectTypeConverter.getDataType());
        EclipseLinkOrmEntityTests.assertEquals((String)"myObjectTypeConverter", (String)ormContextObjectTypeConverter.getName());
        ormContextObjectTypeConverter = (EclipseLinkObjectTypeConverter)ormContextObjectTypeConverters.next();
        EclipseLinkOrmEntityTests.assertEquals((String)"Foo2", (String)ormContextObjectTypeConverter.getDataType());
        EclipseLinkOrmEntityTests.assertEquals((String)"myObjectTypeConverter2", (String)ormContextObjectTypeConverter.getName());
        EclipseLinkOrmEntityTests.assertEquals((int)2, (int)CollectionTools.size((Iterator)persistenceUnit.allConverters()));
        ormContextConverterHolder.removeObjectTypeConverter(0);
        EclipseLinkOrmEntityTests.assertEquals((int)1, (int)resourceEntity.getObjectTypeConverters().size());
        EclipseLinkOrmEntityTests.assertEquals((String)"Foo2", (String)((XmlObjectTypeConverter)resourceEntity.getObjectTypeConverters().get(0)).getDataType());
        EclipseLinkOrmEntityTests.assertEquals((String)"myObjectTypeConverter2", (String)((XmlObjectTypeConverter)resourceEntity.getObjectTypeConverters().get(0)).getName());
        EclipseLinkOrmEntityTests.assertEquals((int)1, (int)ormContextConverterHolder.objectTypeConvertersSize());
        ormContextObjectTypeConverters = ormContextConverterHolder.objectTypeConverters();
        ormContextObjectTypeConverter = (EclipseLinkObjectTypeConverter)ormContextObjectTypeConverters.next();
        EclipseLinkOrmEntityTests.assertEquals((String)"Foo2", (String)ormContextObjectTypeConverter.getDataType());
        EclipseLinkOrmEntityTests.assertEquals((String)"myObjectTypeConverter2", (String)ormContextObjectTypeConverter.getName());
        EclipseLinkOrmEntityTests.assertEquals((int)1, (int)CollectionTools.size((Iterator)persistenceUnit.allConverters()));
        ormContextConverterHolder.removeObjectTypeConverter(contextObjectTypeConverter2);
        EclipseLinkOrmEntityTests.assertEquals((int)0, (int)ormContextConverterHolder.objectTypeConvertersSize());
        EclipseLinkOrmEntityTests.assertFalse((boolean)ormContextConverterHolder.objectTypeConverters().hasNext());
        EclipseLinkOrmEntityTests.assertEquals((int)0, (int)resourceEntity.getObjectTypeConverters().size());
        EclipseLinkOrmEntityTests.assertEquals((int)0, (int)CollectionTools.size((Iterator)persistenceUnit.allConverters()));
    }

    public void testUpdateStructConverters() throws Exception {
        this.createTestEntityForStructConverters();
        EclipseLinkPersistenceUnit persistenceUnit = this.getPersistenceUnit();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmEclipseLinkEntity ormContextEntity = (OrmEclipseLinkEntity)ormPersistentType.getMapping();
        EclipseLinkConverterHolder ormContextConverterHolder = ormContextEntity.getConverterHolder();
        XmlEntity resourceEntity = (XmlEntity)this.getXmlEntityMappings().getEntities().get(0);
        EclipseLinkOrmEntityTests.assertEquals((int)0, (int)ormContextConverterHolder.structConvertersSize());
        EclipseLinkOrmEntityTests.assertEquals((int)0, (int)resourceEntity.getStructConverters().size());
        EclipseLinkOrmEntityTests.assertEquals((int)0, (int)CollectionTools.size((Iterator)persistenceUnit.allConverters()));
        XmlStructConverter resourceStructConverter = EclipseLinkOrmFactory.eINSTANCE.createXmlStructConverter();
        resourceEntity.getStructConverters().add((Object)resourceStructConverter);
        resourceStructConverter.setConverter("Foo");
        resourceStructConverter.setName("myStructConverter");
        EclipseLinkOrmEntityTests.assertEquals((int)1, (int)ormContextConverterHolder.structConvertersSize());
        ListIterator ormContextStructConverters = ormContextConverterHolder.structConverters();
        EclipseLinkStructConverter ormContextStructConverter = (EclipseLinkStructConverter)ormContextStructConverters.next();
        EclipseLinkOrmEntityTests.assertEquals((String)"Foo", (String)ormContextStructConverter.getConverterClass());
        EclipseLinkOrmEntityTests.assertEquals((String)"myStructConverter", (String)ormContextStructConverter.getName());
        EclipseLinkOrmEntityTests.assertEquals((int)1, (int)resourceEntity.getStructConverters().size());
        EclipseLinkOrmEntityTests.assertEquals((int)1, (int)CollectionTools.size((Iterator)persistenceUnit.allConverters()));
        XmlStructConverter resourceStructConverter2 = EclipseLinkOrmFactory.eINSTANCE.createXmlStructConverter();
        resourceEntity.getStructConverters().add(0, (Object)resourceStructConverter2);
        resourceStructConverter2.setConverter("Foo2");
        resourceStructConverter2.setName("myStructConverter2");
        EclipseLinkOrmEntityTests.assertEquals((int)2, (int)ormContextConverterHolder.structConvertersSize());
        ormContextStructConverters = ormContextConverterHolder.structConverters();
        ormContextStructConverter = (EclipseLinkStructConverter)ormContextStructConverters.next();
        EclipseLinkOrmEntityTests.assertEquals((String)"Foo2", (String)ormContextStructConverter.getConverterClass());
        EclipseLinkOrmEntityTests.assertEquals((String)"myStructConverter2", (String)ormContextStructConverter.getName());
        ormContextStructConverter = (EclipseLinkStructConverter)ormContextStructConverters.next();
        EclipseLinkOrmEntityTests.assertEquals((String)"Foo", (String)ormContextStructConverter.getConverterClass());
        EclipseLinkOrmEntityTests.assertEquals((String)"myStructConverter", (String)ormContextStructConverter.getName());
        EclipseLinkOrmEntityTests.assertEquals((int)2, (int)resourceEntity.getStructConverters().size());
        EclipseLinkOrmEntityTests.assertEquals((int)2, (int)CollectionTools.size((Iterator)persistenceUnit.allConverters()));
        resourceEntity.getStructConverters().move(0, 1);
        EclipseLinkOrmEntityTests.assertEquals((int)2, (int)ormContextConverterHolder.structConvertersSize());
        ormContextStructConverters = ormContextConverterHolder.structConverters();
        ormContextStructConverter = (EclipseLinkStructConverter)ormContextStructConverters.next();
        EclipseLinkOrmEntityTests.assertEquals((String)"Foo", (String)ormContextStructConverter.getConverterClass());
        EclipseLinkOrmEntityTests.assertEquals((String)"myStructConverter", (String)ormContextStructConverter.getName());
        ormContextStructConverter = (EclipseLinkStructConverter)ormContextStructConverters.next();
        EclipseLinkOrmEntityTests.assertEquals((String)"Foo2", (String)ormContextStructConverter.getConverterClass());
        EclipseLinkOrmEntityTests.assertEquals((String)"myStructConverter2", (String)ormContextStructConverter.getName());
        EclipseLinkOrmEntityTests.assertEquals((int)2, (int)resourceEntity.getStructConverters().size());
        EclipseLinkOrmEntityTests.assertEquals((int)2, (int)CollectionTools.size((Iterator)persistenceUnit.allConverters()));
        resourceEntity.getStructConverters().remove(0);
        EclipseLinkOrmEntityTests.assertEquals((int)1, (int)ormContextConverterHolder.structConvertersSize());
        ormContextStructConverters = ormContextConverterHolder.structConverters();
        ormContextStructConverter = (EclipseLinkStructConverter)ormContextStructConverters.next();
        EclipseLinkOrmEntityTests.assertEquals((String)"Foo2", (String)ormContextStructConverter.getConverterClass());
        EclipseLinkOrmEntityTests.assertEquals((String)"myStructConverter2", (String)ormContextStructConverter.getName());
        EclipseLinkOrmEntityTests.assertEquals((int)1, (int)resourceEntity.getStructConverters().size());
        EclipseLinkOrmEntityTests.assertEquals((int)1, (int)CollectionTools.size((Iterator)persistenceUnit.allConverters()));
        resourceEntity.getStructConverters().remove((Object)resourceStructConverter2);
        EclipseLinkOrmEntityTests.assertEquals((int)0, (int)ormContextConverterHolder.structConvertersSize());
        EclipseLinkOrmEntityTests.assertFalse((boolean)ormContextConverterHolder.structConverters().hasNext());
        EclipseLinkOrmEntityTests.assertEquals((int)0, (int)resourceEntity.getStructConverters().size());
        EclipseLinkOrmEntityTests.assertEquals((int)0, (int)CollectionTools.size((Iterator)persistenceUnit.allConverters()));
    }

    public void testModifyStructConverters() throws Exception {
        this.createTestEntityForStructConverters();
        EclipseLinkPersistenceUnit persistenceUnit = this.getPersistenceUnit();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmEclipseLinkEntity ormContextEntity = (OrmEclipseLinkEntity)ormPersistentType.getMapping();
        EclipseLinkConverterHolder ormContextConverterHolder = ormContextEntity.getConverterHolder();
        XmlEntity resourceEntity = (XmlEntity)this.getXmlEntityMappings().getEntities().get(0);
        EclipseLinkOrmEntityTests.assertEquals((int)0, (int)ormContextConverterHolder.structConvertersSize());
        EclipseLinkOrmEntityTests.assertEquals((int)0, (int)resourceEntity.getStructConverters().size());
        EclipseLinkOrmEntityTests.assertEquals((int)0, (int)CollectionTools.size((Iterator)persistenceUnit.allConverters()));
        EclipseLinkStructConverter contextStructConverter = ormContextConverterHolder.addStructConverter(0);
        contextStructConverter.setConverterClass("Foo");
        contextStructConverter.setName("myStructConverter");
        EclipseLinkOrmEntityTests.assertEquals((int)1, (int)resourceEntity.getStructConverters().size());
        EclipseLinkOrmEntityTests.assertEquals((String)"Foo", (String)((XmlStructConverter)resourceEntity.getStructConverters().get(0)).getConverter());
        EclipseLinkOrmEntityTests.assertEquals((String)"myStructConverter", (String)((XmlStructConverter)resourceEntity.getStructConverters().get(0)).getName());
        EclipseLinkOrmEntityTests.assertEquals((int)1, (int)ormContextConverterHolder.structConvertersSize());
        ListIterator ormContextStructConverters = ormContextConverterHolder.structConverters();
        EclipseLinkStructConverter ormContextStructConverter = (EclipseLinkStructConverter)ormContextStructConverters.next();
        EclipseLinkOrmEntityTests.assertEquals((String)"Foo", (String)ormContextStructConverter.getConverterClass());
        EclipseLinkOrmEntityTests.assertEquals((String)"myStructConverter", (String)ormContextStructConverter.getName());
        EclipseLinkOrmEntityTests.assertEquals((int)1, (int)CollectionTools.size((Iterator)persistenceUnit.allConverters()));
        EclipseLinkStructConverter contextStructConverter2 = ormContextConverterHolder.addStructConverter(0);
        contextStructConverter2.setConverterClass("Foo2");
        contextStructConverter2.setName("myStructConverter2");
        EclipseLinkOrmEntityTests.assertEquals((int)2, (int)resourceEntity.getStructConverters().size());
        EclipseLinkOrmEntityTests.assertEquals((String)"Foo2", (String)((XmlStructConverter)resourceEntity.getStructConverters().get(0)).getConverter());
        EclipseLinkOrmEntityTests.assertEquals((String)"myStructConverter2", (String)((XmlStructConverter)resourceEntity.getStructConverters().get(0)).getName());
        EclipseLinkOrmEntityTests.assertEquals((String)"Foo", (String)((XmlStructConverter)resourceEntity.getStructConverters().get(1)).getConverter());
        EclipseLinkOrmEntityTests.assertEquals((String)"myStructConverter", (String)((XmlStructConverter)resourceEntity.getStructConverters().get(1)).getName());
        EclipseLinkOrmEntityTests.assertEquals((int)2, (int)ormContextConverterHolder.structConvertersSize());
        ormContextStructConverters = ormContextConverterHolder.structConverters();
        ormContextStructConverter = (EclipseLinkStructConverter)ormContextStructConverters.next();
        EclipseLinkOrmEntityTests.assertEquals((String)"Foo2", (String)ormContextStructConverter.getConverterClass());
        EclipseLinkOrmEntityTests.assertEquals((String)"myStructConverter2", (String)ormContextStructConverter.getName());
        ormContextStructConverter = (EclipseLinkStructConverter)ormContextStructConverters.next();
        EclipseLinkOrmEntityTests.assertEquals((String)"Foo", (String)ormContextStructConverter.getConverterClass());
        EclipseLinkOrmEntityTests.assertEquals((String)"myStructConverter", (String)ormContextStructConverter.getName());
        EclipseLinkOrmEntityTests.assertEquals((int)2, (int)CollectionTools.size((Iterator)persistenceUnit.allConverters()));
        ormContextConverterHolder.moveStructConverter(0, 1);
        EclipseLinkOrmEntityTests.assertEquals((int)2, (int)resourceEntity.getStructConverters().size());
        EclipseLinkOrmEntityTests.assertEquals((String)"Foo", (String)((XmlStructConverter)resourceEntity.getStructConverters().get(0)).getConverter());
        EclipseLinkOrmEntityTests.assertEquals((String)"myStructConverter", (String)((XmlStructConverter)resourceEntity.getStructConverters().get(0)).getName());
        EclipseLinkOrmEntityTests.assertEquals((String)"Foo2", (String)((XmlStructConverter)resourceEntity.getStructConverters().get(1)).getConverter());
        EclipseLinkOrmEntityTests.assertEquals((String)"myStructConverter2", (String)((XmlStructConverter)resourceEntity.getStructConverters().get(1)).getName());
        EclipseLinkOrmEntityTests.assertEquals((int)2, (int)ormContextConverterHolder.structConvertersSize());
        ormContextStructConverters = ormContextConverterHolder.structConverters();
        ormContextStructConverter = (EclipseLinkStructConverter)ormContextStructConverters.next();
        EclipseLinkOrmEntityTests.assertEquals((String)"Foo", (String)ormContextStructConverter.getConverterClass());
        EclipseLinkOrmEntityTests.assertEquals((String)"myStructConverter", (String)ormContextStructConverter.getName());
        ormContextStructConverter = (EclipseLinkStructConverter)ormContextStructConverters.next();
        EclipseLinkOrmEntityTests.assertEquals((String)"Foo2", (String)ormContextStructConverter.getConverterClass());
        EclipseLinkOrmEntityTests.assertEquals((String)"myStructConverter2", (String)ormContextStructConverter.getName());
        EclipseLinkOrmEntityTests.assertEquals((int)2, (int)CollectionTools.size((Iterator)persistenceUnit.allConverters()));
        ormContextConverterHolder.removeStructConverter(0);
        EclipseLinkOrmEntityTests.assertEquals((int)1, (int)resourceEntity.getStructConverters().size());
        EclipseLinkOrmEntityTests.assertEquals((String)"Foo2", (String)((XmlStructConverter)resourceEntity.getStructConverters().get(0)).getConverter());
        EclipseLinkOrmEntityTests.assertEquals((String)"myStructConverter2", (String)((XmlStructConverter)resourceEntity.getStructConverters().get(0)).getName());
        EclipseLinkOrmEntityTests.assertEquals((int)1, (int)ormContextConverterHolder.structConvertersSize());
        ormContextStructConverters = ormContextConverterHolder.structConverters();
        ormContextStructConverter = (EclipseLinkStructConverter)ormContextStructConverters.next();
        EclipseLinkOrmEntityTests.assertEquals((String)"Foo2", (String)ormContextStructConverter.getConverterClass());
        EclipseLinkOrmEntityTests.assertEquals((String)"myStructConverter2", (String)ormContextStructConverter.getName());
        EclipseLinkOrmEntityTests.assertEquals((int)1, (int)CollectionTools.size((Iterator)persistenceUnit.allConverters()));
        ormContextConverterHolder.removeStructConverter(contextStructConverter2);
        EclipseLinkOrmEntityTests.assertEquals((int)0, (int)ormContextConverterHolder.structConvertersSize());
        EclipseLinkOrmEntityTests.assertFalse((boolean)ormContextConverterHolder.structConverters().hasNext());
        EclipseLinkOrmEntityTests.assertEquals((int)0, (int)resourceEntity.getStructConverters().size());
        EclipseLinkOrmEntityTests.assertEquals((int)0, (int)CollectionTools.size((Iterator)persistenceUnit.allConverters()));
    }
}

