/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.eclipselink.core.tests.internal.context.orm;

import java.util.Iterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.core.context.FetchType;
import org.eclipse.jpt.core.context.orm.OrmJoinColumn;
import org.eclipse.jpt.core.context.orm.OrmPersistentAttribute;
import org.eclipse.jpt.core.context.orm.OrmPersistentType;
import org.eclipse.jpt.core.jpa2.context.orm.OrmCascade2_0;
import org.eclipse.jpt.core.tests.internal.projects.TestJavaProject;
import org.eclipse.jpt.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.eclipselink.core.context.EclipseLinkJoinFetchType;
import org.eclipse.jpt.eclipselink.core.context.EclipseLinkRelationshipMapping;
import org.eclipse.jpt.eclipselink.core.internal.context.orm.OrmEclipseLinkManyToOneMapping;
import org.eclipse.jpt.eclipselink.core.internal.context.orm.OrmEclipseLinkOneToOneMapping;
import org.eclipse.jpt.eclipselink.core.resource.orm.XmlEntity;
import org.eclipse.jpt.eclipselink.core.resource.orm.XmlJoinFetchType;
import org.eclipse.jpt.eclipselink.core.resource.orm.XmlManyToOne;
import org.eclipse.jpt.eclipselink.core.tests.internal.context.orm.EclipseLinkOrmContextModelTestCase;
import org.eclipse.jpt.utility.internal.iterators.ArrayIterator;

public class EclipseLinkOrmManyToOneMappingTests
extends EclipseLinkOrmContextModelTestCase {
    public EclipseLinkOrmManyToOneMappingTests(String name) {
        super(name);
    }

    private void createTestDepartment() throws Exception {
        TestJavaProject.SourceWriter sourceWriter = new TestJavaProject.SourceWriter(){

            public void appendSourceTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("import ").append("javax.persistence.Entity").append(";");
                sb.append(CR);
                sb.append("import ").append("javax.persistence.Id").append(";");
                sb.append(CR);
                sb.append(CR);
                sb.append("import ").append("javax.persistence.ManyToOne").append(";");
                sb.append("@Entity");
                sb.append(CR);
                sb.append("public class ").append("Department").append(" ");
                sb.append("{").append(CR);
                sb.append(CR);
                sb.append("    @Id").append(CR);
                sb.append("    private int id;").append(CR);
                sb.append(CR);
                sb.append("    @ManyToOne").append(CR);
                sb.append("    private Employee employee;").append(CR);
                sb.append(CR);
                sb.append("}").append(CR);
            }
        };
        this.javaProject.createCompilationUnit("test", "Department.java", sourceWriter);
    }

    private void createTestEmployee() throws Exception {
        TestJavaProject.SourceWriter sourceWriter = new TestJavaProject.SourceWriter(){

            public void appendSourceTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("import ").append("javax.persistence.Entity").append(";");
                sb.append(CR);
                sb.append("import ").append("javax.persistence.Id").append(";");
                sb.append(CR);
                sb.append("@Entity");
                sb.append(CR);
                sb.append("public class ").append("Employee").append(" ");
                sb.append("{").append(CR);
                sb.append(CR);
                sb.append("    @Id").append(CR);
                sb.append("    private int empId;").append(CR);
                sb.append(CR);
                sb.append("}").append(CR);
            }
        };
        this.javaProject.createCompilationUnit("test", "Employee.java", sourceWriter);
    }

    private ICompilationUnit createTestEntityManyToOneMapping() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.ManyToOne", "javax.persistence.JoinColumn", "javax.persistence.FetchType", "javax.persistence.CascadeType", "org.eclipse.persistence.annotations.JoinFetch", "org.eclipse.persistence.annotations.JoinFetchType"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity");
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("    @ManyToOne(fetch=FetchType.LAZY, optional=false, targetEntity=Address.class, cascade={CascadeType.ALL, CascadeType.PERSIST, CascadeType.MERGE, CascadeType.REMOVE, CascadeType.REFRESH})");
                sb.append(CR);
                sb.append("    @JoinColumn(name=\"MY_COLUMN\", referencedColumnName=\"MY_REFERENCED_COLUMN\", unique=true, nullable=false, insertable=false, updatable=false, columnDefinition=\"COLUMN_DEFINITION\", table=\"MY_TABLE\")");
                sb.append(CR);
                sb.append("    @JoinFetch(JoinFetchType.INNER)");
                sb.append(CR);
                sb.append("    private Address address;").append(CR);
                sb.append(CR);
                sb.append("    @Id");
            }
        });
    }

    private void createTestTargetEntityAddress() throws Exception {
        TestJavaProject.SourceWriter sourceWriter = new TestJavaProject.SourceWriter(){

            public void appendSourceTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Entity");
                sb.append(";");
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Id");
                sb.append(";");
                sb.append(CR);
                sb.append(CR);
                sb.append("@Entity");
                sb.append(CR);
                sb.append("public class ").append("Address").append(" ");
                sb.append("{").append(CR);
                sb.append(CR);
                sb.append("    @Id").append(CR);
                sb.append("    private int id;").append(CR);
                sb.append(CR);
                sb.append("    private String city;").append(CR);
                sb.append(CR);
                sb.append("    private String state;").append(CR);
                sb.append(CR);
                sb.append("    private int zip;").append(CR);
                sb.append(CR);
                sb.append("}").append(CR);
            }
        };
        this.javaProject.createCompilationUnit("test", "Address.java", sourceWriter);
    }

    public void testUpdateJoinFetch() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("manyToOne", "manyToOne");
        EclipseLinkRelationshipMapping contextManyToOne = (EclipseLinkRelationshipMapping)ormPersistentAttribute.getMapping();
        XmlEntity resourceEntity = (XmlEntity)this.getXmlEntityMappings().getEntities().get(0);
        XmlManyToOne resourceManyToOne = (XmlManyToOne)resourceEntity.getAttributes().getManyToOnes().get(0);
        EclipseLinkOrmManyToOneMappingTests.assertNull((Object)resourceManyToOne.getJoinFetch());
        EclipseLinkOrmManyToOneMappingTests.assertNull((Object)contextManyToOne.getJoinFetch().getValue());
        resourceManyToOne.setJoinFetch(XmlJoinFetchType.INNER);
        EclipseLinkOrmManyToOneMappingTests.assertEquals((Object)XmlJoinFetchType.INNER, (Object)resourceManyToOne.getJoinFetch());
        EclipseLinkOrmManyToOneMappingTests.assertEquals((Object)EclipseLinkJoinFetchType.INNER, (Object)contextManyToOne.getJoinFetch().getValue());
        resourceManyToOne.setJoinFetch(XmlJoinFetchType.OUTER);
        EclipseLinkOrmManyToOneMappingTests.assertEquals((Object)XmlJoinFetchType.OUTER, (Object)resourceManyToOne.getJoinFetch());
        EclipseLinkOrmManyToOneMappingTests.assertEquals((Object)EclipseLinkJoinFetchType.OUTER, (Object)contextManyToOne.getJoinFetch().getValue());
        resourceManyToOne.setJoinFetch(null);
        EclipseLinkOrmManyToOneMappingTests.assertNull((Object)resourceManyToOne.getJoinFetch());
        EclipseLinkOrmManyToOneMappingTests.assertNull((Object)contextManyToOne.getJoinFetch().getValue());
    }

    public void testModifyJoinFetch() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("manyToOne", "manyToOne");
        EclipseLinkRelationshipMapping contextManyToOne = (EclipseLinkRelationshipMapping)ormPersistentAttribute.getMapping();
        XmlEntity resourceEntity = (XmlEntity)this.getXmlEntityMappings().getEntities().get(0);
        XmlManyToOne resourceManyToOne = (XmlManyToOne)resourceEntity.getAttributes().getManyToOnes().get(0);
        EclipseLinkOrmManyToOneMappingTests.assertNull((Object)resourceManyToOne.getJoinFetch());
        EclipseLinkOrmManyToOneMappingTests.assertNull((Object)contextManyToOne.getJoinFetch().getValue());
        contextManyToOne.getJoinFetch().setValue(EclipseLinkJoinFetchType.INNER);
        EclipseLinkOrmManyToOneMappingTests.assertEquals((Object)XmlJoinFetchType.INNER, (Object)resourceManyToOne.getJoinFetch());
        EclipseLinkOrmManyToOneMappingTests.assertEquals((Object)EclipseLinkJoinFetchType.INNER, (Object)contextManyToOne.getJoinFetch().getValue());
        contextManyToOne.getJoinFetch().setValue(EclipseLinkJoinFetchType.OUTER);
        EclipseLinkOrmManyToOneMappingTests.assertEquals((Object)XmlJoinFetchType.OUTER, (Object)resourceManyToOne.getJoinFetch());
        EclipseLinkOrmManyToOneMappingTests.assertEquals((Object)EclipseLinkJoinFetchType.OUTER, (Object)contextManyToOne.getJoinFetch().getValue());
        contextManyToOne.getJoinFetch().setValue(null);
        EclipseLinkOrmManyToOneMappingTests.assertNull((Object)resourceManyToOne.getJoinFetch());
        EclipseLinkOrmManyToOneMappingTests.assertNull((Object)contextManyToOne.getJoinFetch().getValue());
    }

    public void testJoinFetchDefaultFromJava() throws Exception {
        this.createTestEmployee();
        this.createTestDepartment();
        this.getEntityMappings().addPersistentType("entity", "test.Department");
        this.getEntityMappings().addPersistentType("entity", "test.Employee");
        OrmPersistentType departmentPersistentType = (OrmPersistentType)this.getEntityMappings().getPersistentTypes().iterator().next();
        OrmEclipseLinkManyToOneMapping manyToOne = (OrmEclipseLinkManyToOneMapping)departmentPersistentType.getAttributeNamed("employee").getMapping();
        EclipseLinkOrmManyToOneMappingTests.assertNull((Object)manyToOne.getJoinFetch().getValue());
        this.getEntityMappings().getPersistenceUnitMetadata().setXmlMappingMetadataComplete(true);
        OrmEclipseLinkOneToOneMapping oneToOne = (OrmEclipseLinkOneToOneMapping)departmentPersistentType.getAttributeNamed("employee").getMapping();
        EclipseLinkOrmManyToOneMappingTests.assertNull((Object)oneToOne.getJoinFetch().getValue());
        EclipseLinkRelationshipMapping javaRelationshipMapping = (EclipseLinkRelationshipMapping)departmentPersistentType.getJavaPersistentType().getAttributeNamed("employee").getMapping();
        javaRelationshipMapping.getJoinFetch().setValue(EclipseLinkJoinFetchType.OUTER);
        EclipseLinkOrmManyToOneMappingTests.assertNull((Object)manyToOne.getJoinFetch().getValue());
        this.getEntityMappings().getPersistenceUnitMetadata().setXmlMappingMetadataComplete(false);
        manyToOne = (OrmEclipseLinkManyToOneMapping)departmentPersistentType.getAttributeNamed("employee").getMapping();
        EclipseLinkOrmManyToOneMappingTests.assertEquals((Object)EclipseLinkJoinFetchType.OUTER, (Object)manyToOne.getJoinFetch().getValue());
    }

    public void testVirtualMappingMetadataCompleteFalse() throws Exception {
        this.createTestEntityManyToOneMapping();
        this.createTestTargetEntityAddress();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        this.getEntityMappings().addPersistentType("entity", "test.Address");
        EclipseLinkOrmManyToOneMappingTests.assertEquals((int)3, (int)ormPersistentType.virtualAttributesSize());
        OrmPersistentAttribute ormPersistentAttribute = (OrmPersistentAttribute)ormPersistentType.virtualAttributes().next();
        OrmEclipseLinkManyToOneMapping ormManyToOneMapping = (OrmEclipseLinkManyToOneMapping)ormPersistentAttribute.getMapping();
        EclipseLinkOrmManyToOneMappingTests.assertEquals((String)"address", (String)ormManyToOneMapping.getName());
        EclipseLinkOrmManyToOneMappingTests.assertEquals((Object)FetchType.LAZY, (Object)ormManyToOneMapping.getSpecifiedFetch());
        EclipseLinkOrmManyToOneMappingTests.assertEquals((Object)Boolean.FALSE, (Object)ormManyToOneMapping.getSpecifiedOptional());
        EclipseLinkOrmManyToOneMappingTests.assertEquals((String)"Address", (String)ormManyToOneMapping.getSpecifiedTargetEntity());
        OrmJoinColumn ormJoinColumn = (OrmJoinColumn)ormManyToOneMapping.getRelationshipReference().getJoinColumnJoiningStrategy().specifiedJoinColumns().next();
        EclipseLinkOrmManyToOneMappingTests.assertEquals((String)"MY_COLUMN", (String)ormJoinColumn.getSpecifiedName());
        EclipseLinkOrmManyToOneMappingTests.assertEquals((String)"MY_REFERENCED_COLUMN", (String)ormJoinColumn.getSpecifiedReferencedColumnName());
        EclipseLinkOrmManyToOneMappingTests.assertEquals((Object)Boolean.TRUE, (Object)ormJoinColumn.getSpecifiedUnique());
        EclipseLinkOrmManyToOneMappingTests.assertEquals((Object)Boolean.FALSE, (Object)ormJoinColumn.getSpecifiedNullable());
        EclipseLinkOrmManyToOneMappingTests.assertEquals((Object)Boolean.FALSE, (Object)ormJoinColumn.getSpecifiedInsertable());
        EclipseLinkOrmManyToOneMappingTests.assertEquals((Object)Boolean.FALSE, (Object)ormJoinColumn.getSpecifiedUpdatable());
        EclipseLinkOrmManyToOneMappingTests.assertEquals((String)"COLUMN_DEFINITION", (String)ormJoinColumn.getColumnDefinition());
        EclipseLinkOrmManyToOneMappingTests.assertEquals((String)"MY_TABLE", (String)ormJoinColumn.getSpecifiedTable());
        OrmCascade2_0 cascade = ormManyToOneMapping.getCascade();
        EclipseLinkOrmManyToOneMappingTests.assertTrue((boolean)cascade.isAll());
        EclipseLinkOrmManyToOneMappingTests.assertTrue((boolean)cascade.isMerge());
        EclipseLinkOrmManyToOneMappingTests.assertTrue((boolean)cascade.isPersist());
        EclipseLinkOrmManyToOneMappingTests.assertTrue((boolean)cascade.isRemove());
        EclipseLinkOrmManyToOneMappingTests.assertTrue((boolean)cascade.isRefresh());
        EclipseLinkOrmManyToOneMappingTests.assertEquals((Object)EclipseLinkJoinFetchType.INNER, (Object)ormManyToOneMapping.getJoinFetch().getValue());
    }

    public void testVirtualMappingMetadataCompleteTrue() throws Exception {
        this.createTestEntityManyToOneMapping();
        this.createTestTargetEntityAddress();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        this.getEntityMappings().addPersistentType("entity", "test.Address");
        ormPersistentType.getMapping().setSpecifiedMetadataComplete(Boolean.TRUE);
        EclipseLinkOrmManyToOneMappingTests.assertEquals((int)3, (int)ormPersistentType.virtualAttributesSize());
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.getAttributeNamed("address");
        EclipseLinkOrmManyToOneMappingTests.assertEquals((String)"oneToOne", (String)ormPersistentAttribute.getMappingKey());
        EclipseLinkOrmManyToOneMappingTests.assertTrue((boolean)ormPersistentAttribute.isVirtual());
        ormPersistentAttribute.makeSpecified("manyToOne");
        ormPersistentAttribute = (OrmPersistentAttribute)ormPersistentType.specifiedAttributes().next();
        OrmEclipseLinkManyToOneMapping ormManyToOneMapping = (OrmEclipseLinkManyToOneMapping)ormPersistentAttribute.getMapping();
        EclipseLinkOrmManyToOneMappingTests.assertEquals((String)"address", (String)ormManyToOneMapping.getName());
        EclipseLinkOrmManyToOneMappingTests.assertEquals((Object)FetchType.EAGER, (Object)ormManyToOneMapping.getDefaultFetch());
        EclipseLinkOrmManyToOneMappingTests.assertEquals((boolean)true, (boolean)ormManyToOneMapping.isDefaultOptional());
        EclipseLinkOrmManyToOneMappingTests.assertEquals((String)"test.Address", (String)ormManyToOneMapping.getDefaultTargetEntity());
        OrmCascade2_0 cascade = ormManyToOneMapping.getCascade();
        EclipseLinkOrmManyToOneMappingTests.assertFalse((boolean)cascade.isAll());
        EclipseLinkOrmManyToOneMappingTests.assertFalse((boolean)cascade.isMerge());
        EclipseLinkOrmManyToOneMappingTests.assertFalse((boolean)cascade.isPersist());
        EclipseLinkOrmManyToOneMappingTests.assertFalse((boolean)cascade.isRemove());
        EclipseLinkOrmManyToOneMappingTests.assertFalse((boolean)cascade.isRefresh());
        EclipseLinkOrmManyToOneMappingTests.assertEquals(null, (Object)ormManyToOneMapping.getJoinFetch().getValue());
    }
}

