/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.eclipselink.core.tests.internal.resource.java;

import java.util.Iterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentAttribute;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentType;
import org.eclipse.jpt.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.eclipselink.core.resource.java.EclipseLinkConvertAnnotation;
import org.eclipse.jpt.eclipselink.core.tests.internal.resource.java.EclipseLinkJavaResourceModelTestCase;
import org.eclipse.jpt.utility.internal.iterators.ArrayIterator;

public class ConvertAnnotationTests
extends EclipseLinkJavaResourceModelTestCase {
    public ConvertAnnotationTests(String name) {
        super(name);
    }

    private ICompilationUnit createTestConvert() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"org.eclipse.persistence.annotations.Convert"});
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@Convert");
            }
        });
    }

    private ICompilationUnit createTestConverterWithValue() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"org.eclipse.persistence.annotations.Convert"});
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@Convert(value=\"myConverter\")");
            }
        });
    }

    public void testConvertAnnotation() throws Exception {
        ICompilationUnit cu = this.createTestConvert();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        ConvertAnnotationTests.assertNotNull((Object)attributeResource.getAnnotation("org.eclipse.persistence.annotations.Convert"));
        attributeResource.removeAnnotation("org.eclipse.persistence.annotations.Convert");
        ConvertAnnotationTests.assertNull((Object)attributeResource.getAnnotation("org.eclipse.persistence.annotations.Convert"));
        attributeResource.addAnnotation("org.eclipse.persistence.annotations.Convert");
        ConvertAnnotationTests.assertNotNull((Object)attributeResource.getAnnotation("org.eclipse.persistence.annotations.Convert"));
    }

    public void testGetValue() throws Exception {
        ICompilationUnit cu = this.createTestConverterWithValue();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        EclipseLinkConvertAnnotation convert = (EclipseLinkConvertAnnotation)attributeResource.getAnnotation("org.eclipse.persistence.annotations.Convert");
        ConvertAnnotationTests.assertEquals((String)"myConverter", (String)convert.getValue());
    }

    public void testSetValue() throws Exception {
        ICompilationUnit cu = this.createTestConverterWithValue();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        EclipseLinkConvertAnnotation convert = (EclipseLinkConvertAnnotation)attributeResource.getAnnotation("org.eclipse.persistence.annotations.Convert");
        ConvertAnnotationTests.assertEquals((String)"myConverter", (String)convert.getValue());
        convert.setValue("Bar");
        ConvertAnnotationTests.assertEquals((String)"Bar", (String)convert.getValue());
        this.assertSourceContains("@Convert(value=\"Bar\")", cu);
    }

    public void testSetValueNull() throws Exception {
        ICompilationUnit cu = this.createTestConverterWithValue();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        EclipseLinkConvertAnnotation convert = (EclipseLinkConvertAnnotation)attributeResource.getAnnotation("org.eclipse.persistence.annotations.Convert");
        ConvertAnnotationTests.assertEquals((String)"myConverter", (String)convert.getValue());
        convert.setValue(null);
        ConvertAnnotationTests.assertNull((Object)convert.getValue());
        this.assertSourceContains("@Convert", cu);
        this.assertSourceDoesNotContain("value", cu);
    }
}

