/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.eclipselink2_0.core.tests.internal.context.java;

import java.util.Iterator;
import java.util.ListIterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.core.MappingKeys;
import org.eclipse.jpt.core.context.AttributeOverride;
import org.eclipse.jpt.core.context.AttributeOverrideContainer;
import org.eclipse.jpt.core.context.BasicMapping;
import org.eclipse.jpt.core.context.CollectionMapping;
import org.eclipse.jpt.core.context.Embeddable;
import org.eclipse.jpt.core.context.EmbeddedIdMapping;
import org.eclipse.jpt.core.context.EmbeddedMapping;
import org.eclipse.jpt.core.context.IdMapping;
import org.eclipse.jpt.core.context.ManyToManyMapping;
import org.eclipse.jpt.core.context.ManyToOneMapping;
import org.eclipse.jpt.core.context.OneToManyMapping;
import org.eclipse.jpt.core.context.PersistentAttribute;
import org.eclipse.jpt.core.context.TransientMapping;
import org.eclipse.jpt.core.context.VersionMapping;
import org.eclipse.jpt.core.context.java.JavaAttributeOverride;
import org.eclipse.jpt.core.context.java.JavaAttributeOverrideContainer;
import org.eclipse.jpt.core.context.java.JavaPersistentType;
import org.eclipse.jpt.core.context.java.JavaTypeMapping;
import org.eclipse.jpt.core.context.persistence.ClassRef;
import org.eclipse.jpt.core.jpa2.context.ElementCollectionMapping2_0;
import org.eclipse.jpt.core.jpa2.context.OrderColumn2_0;
import org.eclipse.jpt.core.jpa2.context.Orderable2_0;
import org.eclipse.jpt.core.jpa2.context.java.JavaElementCollectionMapping2_0;
import org.eclipse.jpt.core.jpa2.resource.java.ElementCollection2_0Annotation;
import org.eclipse.jpt.core.jpa2.resource.java.MapKeyClass2_0Annotation;
import org.eclipse.jpt.core.jpa2.resource.java.MapKeyColumn2_0Annotation;
import org.eclipse.jpt.core.resource.java.AttributeOverrideAnnotation;
import org.eclipse.jpt.core.resource.java.ColumnAnnotation;
import org.eclipse.jpt.core.resource.java.FetchType;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentAttribute;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentType;
import org.eclipse.jpt.core.resource.java.MapKeyAnnotation;
import org.eclipse.jpt.core.tests.internal.projects.TestJavaProject;
import org.eclipse.jpt.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.eclipselink2_0.core.tests.internal.context.EclipseLink2_0ContextModelTestCase;
import org.eclipse.jpt.utility.internal.iterators.ArrayIterator;

public class EclipseLink2_0JavaElementCollectionMappingTests
extends EclipseLink2_0ContextModelTestCase {
    public static final String EMBEDDABLE_TYPE_NAME = "Address";
    public static final String FULLY_QUALIFIED_EMBEDDABLE_TYPE_NAME = "test.Address";

    private ICompilationUnit createTestEntityWithElementCollectionMapping() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.ElementCollection"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@ElementCollection").append(CR);
            }
        });
    }

    private ICompilationUnit createTestEntityWithGenericEmbeddableElementCollectionMapping() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.ElementCollection", "javax.persistence.Id"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("    @ElementCollection").append(CR);
                sb.append("    private java.util.Collection<Address> addresses;").append(CR);
                sb.append(CR);
                sb.append("    @Id").append(CR);
            }
        });
    }

    private ICompilationUnit createTestEntityWithGenericBasicElementCollectionMapping() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.ElementCollection", "javax.persistence.Id"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("    @ElementCollection").append(CR);
                sb.append("    private java.util.Collection<String> addresses;").append(CR);
                sb.append(CR);
                sb.append("    @Id").append(CR);
            }
        });
    }

    private ICompilationUnit createTestEntityWithNonGenericElementCollectionMapping() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.ElementCollection", "javax.persistence.Id"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("    @ElementCollection").append(CR);
                sb.append("    private java.util.Collection addresses;").append(CR);
                sb.append(CR);
                sb.append("    @Id").append(CR);
            }
        });
    }

    private ICompilationUnit createTestEntityWithValidGenericMapElementCollectionMapping() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.ElementCollection", "javax.persistence.Id"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("    @ElementCollection").append(CR);
                sb.append("    private java.util.Map<Integer, Address> addresses;").append(CR);
                sb.append(CR);
                sb.append("    @Id").append(CR);
            }
        });
    }

    private ICompilationUnit createTestEntityWithValidNonGenericMapElementCollectionMapping() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.ElementCollection", "javax.persistence.Id"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("    @ElementCollection").append(CR);
                sb.append("    private java.util.Map addresses;").append(CR);
                sb.append(CR);
                sb.append("    @Id").append(CR);
            }
        });
    }

    private void createTestTargetEmbeddableAddress() throws Exception {
        TestJavaProject.SourceWriter sourceWriter = new TestJavaProject.SourceWriter(){

            public void appendSourceTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Embeddable");
                sb.append(";");
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Id");
                sb.append(";");
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Embedded");
                sb.append(";");
                sb.append(CR);
                sb.append("@Embeddable");
                sb.append(CR);
                sb.append("public class ").append(EclipseLink2_0JavaElementCollectionMappingTests.EMBEDDABLE_TYPE_NAME).append(" ");
                sb.append("{").append(CR);
                sb.append(CR);
                sb.append("    private String city;").append(CR);
                sb.append(CR);
                sb.append("    @Embedded").append(CR);
                sb.append("    private State state;").append(CR);
                sb.append(CR);
                sb.append("    private int zip;").append(CR);
                sb.append(CR);
                sb.append("}").append(CR);
            }
        };
        this.javaProject.createCompilationUnit("test", "Address.java", sourceWriter);
    }

    private void createTestEmbeddableState() throws Exception {
        TestJavaProject.SourceWriter sourceWriter = new TestJavaProject.SourceWriter(){

            public void appendSourceTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Embeddable");
                sb.append(";");
                sb.append(CR);
                sb.append("@Embeddable");
                sb.append(CR);
                sb.append("public class ").append("State").append(" ");
                sb.append("{").append(CR);
                sb.append(CR);
                sb.append("    private String name;").append(CR);
                sb.append(CR);
                sb.append("    private String abbr;").append(CR);
                sb.append(CR);
                sb.append("}").append(CR);
            }
        };
        this.javaProject.createCompilationUnit("test", "State.java", sourceWriter);
    }

    private ICompilationUnit createTestEntityWithEmbeddableKeyAndValueElementCollectionMapping() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.ElementCollection", "javax.persistence.Id"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("    @ElementCollection").append(CR);
                sb.append("    private java.util.Map<Address, PropertyInfo> parcels;").append(CR);
                sb.append(CR);
                sb.append("    @Id").append(CR);
            }
        });
    }

    private void createTestEmbeddablePropertyInfo() throws Exception {
        TestJavaProject.SourceWriter sourceWriter = new TestJavaProject.SourceWriter(){

            public void appendSourceTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Embeddable");
                sb.append(";");
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Id");
                sb.append(";");
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Embedded");
                sb.append(";");
                sb.append(CR);
                sb.append("@Embeddable");
                sb.append(CR);
                sb.append("public class ").append("PropertyInfo").append(" ");
                sb.append("{").append(CR);
                sb.append(CR);
                sb.append("    private Integer parcelNumber;").append(CR);
                sb.append(CR);
                sb.append("    private Integer size;").append(CR);
                sb.append(CR);
                sb.append("    private java.math.BigDecimal tax;").append(CR);
                sb.append(CR);
                sb.append("}").append(CR);
            }
        };
        this.javaProject.createCompilationUnit("test", "PropertyInfo.java", sourceWriter);
    }

    private void createSelfReferentialElementCollection() throws Exception {
        TestJavaProject.SourceWriter sourceWriter = new TestJavaProject.SourceWriter(){

            public void appendSourceTo(StringBuilder sb) {
                sb.append("import ");
                sb.append("javax.persistence.Embeddable");
                sb.append(";");
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.ElementCollection");
                sb.append(";");
                sb.append(CR).append(CR);
                sb.append("@Embeddable");
                sb.append(CR);
                sb.append("public class ").append("Foo").append(" ");
                sb.append("{").append(CR);
                sb.append(CR);
                sb.append("    @ElementCollection").append(CR);
                sb.append("    private java.util.List<Foo> elementCollection;").append(CR);
                sb.append(CR);
                sb.append("}").append(CR);
            }
        };
        this.javaProject.createCompilationUnit("test", "Foo.java", sourceWriter);
    }

    public EclipseLink2_0JavaElementCollectionMappingTests(String name) {
        super(name);
    }

    public void testMorphToBasicMapping() throws Exception {
        this.createTestEntityWithElementCollectionMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        ElementCollectionMapping2_0 elementCollectionMapping = (ElementCollectionMapping2_0)persistentAttribute.getMapping();
        EclipseLink2_0JavaElementCollectionMappingTests.assertFalse((boolean)elementCollectionMapping.isDefault());
        persistentAttribute.setSpecifiedMappingKey("basic");
        EclipseLink2_0JavaElementCollectionMappingTests.assertTrue((boolean)(persistentAttribute.getMapping() instanceof BasicMapping));
        EclipseLink2_0JavaElementCollectionMappingTests.assertFalse((boolean)persistentAttribute.getMapping().isDefault());
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        EclipseLink2_0JavaElementCollectionMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.ElementCollection"));
        EclipseLink2_0JavaElementCollectionMappingTests.assertNotNull((Object)attributeResource.getAnnotation("javax.persistence.Basic"));
    }

    public void testMorphToDefault() throws Exception {
        this.createTestEntityWithElementCollectionMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        ElementCollectionMapping2_0 elementCollectionMapping = (ElementCollectionMapping2_0)persistentAttribute.getMapping();
        EclipseLink2_0JavaElementCollectionMappingTests.assertFalse((boolean)elementCollectionMapping.isDefault());
        persistentAttribute.setSpecifiedMappingKey(MappingKeys.NULL_ATTRIBUTE_MAPPING_KEY);
        EclipseLink2_0JavaElementCollectionMappingTests.assertNull((Object)persistentAttribute.getSpecifiedMapping());
        EclipseLink2_0JavaElementCollectionMappingTests.assertTrue((boolean)persistentAttribute.getMapping().isDefault());
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        EclipseLink2_0JavaElementCollectionMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.ElementCollection"));
    }

    public void testMorphToVersionMapping() throws Exception {
        this.createTestEntityWithElementCollectionMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        ElementCollectionMapping2_0 elementCollectionMapping = (ElementCollectionMapping2_0)persistentAttribute.getMapping();
        EclipseLink2_0JavaElementCollectionMappingTests.assertFalse((boolean)elementCollectionMapping.isDefault());
        persistentAttribute.setSpecifiedMappingKey("version");
        EclipseLink2_0JavaElementCollectionMappingTests.assertTrue((boolean)(persistentAttribute.getMapping() instanceof VersionMapping));
        EclipseLink2_0JavaElementCollectionMappingTests.assertFalse((boolean)persistentAttribute.getMapping().isDefault());
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        EclipseLink2_0JavaElementCollectionMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.ElementCollection"));
        EclipseLink2_0JavaElementCollectionMappingTests.assertNotNull((Object)attributeResource.getAnnotation("javax.persistence.Version"));
    }

    public void testMorphToIdMapping() throws Exception {
        this.createTestEntityWithElementCollectionMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        ElementCollectionMapping2_0 elementCollectionMapping = (ElementCollectionMapping2_0)persistentAttribute.getMapping();
        EclipseLink2_0JavaElementCollectionMappingTests.assertFalse((boolean)elementCollectionMapping.isDefault());
        persistentAttribute.setSpecifiedMappingKey("id");
        EclipseLink2_0JavaElementCollectionMappingTests.assertTrue((boolean)(persistentAttribute.getMapping() instanceof IdMapping));
        EclipseLink2_0JavaElementCollectionMappingTests.assertFalse((boolean)persistentAttribute.getMapping().isDefault());
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        EclipseLink2_0JavaElementCollectionMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.ElementCollection"));
        EclipseLink2_0JavaElementCollectionMappingTests.assertNotNull((Object)attributeResource.getAnnotation("javax.persistence.Id"));
    }

    public void testMorphToEmbeddedMapping() throws Exception {
        this.createTestEntityWithElementCollectionMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        ElementCollectionMapping2_0 elementCollectionMapping = (ElementCollectionMapping2_0)persistentAttribute.getMapping();
        EclipseLink2_0JavaElementCollectionMappingTests.assertFalse((boolean)elementCollectionMapping.isDefault());
        persistentAttribute.setSpecifiedMappingKey("embedded");
        EclipseLink2_0JavaElementCollectionMappingTests.assertTrue((boolean)(persistentAttribute.getMapping() instanceof EmbeddedMapping));
        EclipseLink2_0JavaElementCollectionMappingTests.assertFalse((boolean)persistentAttribute.getMapping().isDefault());
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        EclipseLink2_0JavaElementCollectionMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.ElementCollection"));
        EclipseLink2_0JavaElementCollectionMappingTests.assertNotNull((Object)attributeResource.getAnnotation("javax.persistence.Embedded"));
    }

    public void testMorphToEmbeddedIdMapping() throws Exception {
        this.createTestEntityWithElementCollectionMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        ElementCollectionMapping2_0 elementCollectionMapping = (ElementCollectionMapping2_0)persistentAttribute.getMapping();
        EclipseLink2_0JavaElementCollectionMappingTests.assertFalse((boolean)elementCollectionMapping.isDefault());
        persistentAttribute.setSpecifiedMappingKey("embeddedId");
        EclipseLink2_0JavaElementCollectionMappingTests.assertTrue((boolean)(persistentAttribute.getMapping() instanceof EmbeddedIdMapping));
        EclipseLink2_0JavaElementCollectionMappingTests.assertFalse((boolean)persistentAttribute.getMapping().isDefault());
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        EclipseLink2_0JavaElementCollectionMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.ElementCollection"));
        EclipseLink2_0JavaElementCollectionMappingTests.assertNotNull((Object)attributeResource.getAnnotation("javax.persistence.EmbeddedId"));
    }

    public void testMorphToTransientMapping() throws Exception {
        this.createTestEntityWithElementCollectionMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        ElementCollectionMapping2_0 elementCollectionMapping = (ElementCollectionMapping2_0)persistentAttribute.getMapping();
        EclipseLink2_0JavaElementCollectionMappingTests.assertFalse((boolean)elementCollectionMapping.isDefault());
        persistentAttribute.setSpecifiedMappingKey("transient");
        EclipseLink2_0JavaElementCollectionMappingTests.assertTrue((boolean)(persistentAttribute.getMapping() instanceof TransientMapping));
        EclipseLink2_0JavaElementCollectionMappingTests.assertFalse((boolean)persistentAttribute.getMapping().isDefault());
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        EclipseLink2_0JavaElementCollectionMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.ElementCollection"));
        EclipseLink2_0JavaElementCollectionMappingTests.assertNotNull((Object)attributeResource.getAnnotation("javax.persistence.Transient"));
    }

    public void testMorphToManyToOneMapping() throws Exception {
        this.createTestEntityWithElementCollectionMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        ElementCollectionMapping2_0 elementCollectionMapping = (ElementCollectionMapping2_0)persistentAttribute.getMapping();
        EclipseLink2_0JavaElementCollectionMappingTests.assertFalse((boolean)elementCollectionMapping.isDefault());
        persistentAttribute.setSpecifiedMappingKey("manyToOne");
        EclipseLink2_0JavaElementCollectionMappingTests.assertTrue((boolean)(persistentAttribute.getMapping() instanceof ManyToOneMapping));
        EclipseLink2_0JavaElementCollectionMappingTests.assertFalse((boolean)persistentAttribute.getMapping().isDefault());
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        EclipseLink2_0JavaElementCollectionMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.ElementCollection"));
        EclipseLink2_0JavaElementCollectionMappingTests.assertNotNull((Object)attributeResource.getAnnotation("javax.persistence.ManyToOne"));
    }

    public void testMorphToOneToManyMapping() throws Exception {
        this.createTestEntityWithElementCollectionMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        ElementCollectionMapping2_0 elementCollectionMapping = (ElementCollectionMapping2_0)persistentAttribute.getMapping();
        EclipseLink2_0JavaElementCollectionMappingTests.assertFalse((boolean)elementCollectionMapping.isDefault());
        persistentAttribute.setSpecifiedMappingKey("oneToMany");
        EclipseLink2_0JavaElementCollectionMappingTests.assertTrue((boolean)(persistentAttribute.getMapping() instanceof OneToManyMapping));
        EclipseLink2_0JavaElementCollectionMappingTests.assertFalse((boolean)persistentAttribute.getMapping().isDefault());
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        EclipseLink2_0JavaElementCollectionMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.ElementCollection"));
        EclipseLink2_0JavaElementCollectionMappingTests.assertNotNull((Object)attributeResource.getAnnotation("javax.persistence.OneToMany"));
    }

    public void testMorphToManyToManyMapping() throws Exception {
        this.createTestEntityWithElementCollectionMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        ElementCollectionMapping2_0 elementCollectionMapping = (ElementCollectionMapping2_0)persistentAttribute.getMapping();
        EclipseLink2_0JavaElementCollectionMappingTests.assertFalse((boolean)elementCollectionMapping.isDefault());
        persistentAttribute.setSpecifiedMappingKey("manyToMany");
        EclipseLink2_0JavaElementCollectionMappingTests.assertTrue((boolean)(persistentAttribute.getMapping() instanceof ManyToManyMapping));
        EclipseLink2_0JavaElementCollectionMappingTests.assertFalse((boolean)persistentAttribute.getMapping().isDefault());
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        EclipseLink2_0JavaElementCollectionMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.ElementCollection"));
        EclipseLink2_0JavaElementCollectionMappingTests.assertNotNull((Object)attributeResource.getAnnotation("javax.persistence.ManyToMany"));
    }

    public void testUpdateSpecifiedTargetEntity() throws Exception {
        this.createTestEntityWithElementCollectionMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        ElementCollectionMapping2_0 elementCollectionMapping = (ElementCollectionMapping2_0)persistentAttribute.getMapping();
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        ElementCollection2_0Annotation elementCollection = (ElementCollection2_0Annotation)attributeResource.getAnnotation("javax.persistence.ElementCollection");
        EclipseLink2_0JavaElementCollectionMappingTests.assertNull((Object)elementCollectionMapping.getSpecifiedTargetClass());
        EclipseLink2_0JavaElementCollectionMappingTests.assertNull((Object)elementCollection.getTargetClass());
        elementCollection.setTargetClass("newTargetClass");
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"newTargetClass", (String)elementCollectionMapping.getSpecifiedTargetClass());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"newTargetClass", (String)elementCollection.getTargetClass());
        elementCollection.setTargetClass(null);
        EclipseLink2_0JavaElementCollectionMappingTests.assertNull((Object)elementCollectionMapping.getSpecifiedTargetClass());
        EclipseLink2_0JavaElementCollectionMappingTests.assertNull((Object)elementCollection.getTargetClass());
    }

    public void testModifySpecifiedTargetClass() throws Exception {
        this.createTestEntityWithElementCollectionMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        ElementCollectionMapping2_0 elementCollectionMapping = (ElementCollectionMapping2_0)persistentAttribute.getMapping();
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        ElementCollection2_0Annotation elementCollection = (ElementCollection2_0Annotation)attributeResource.getAnnotation("javax.persistence.ElementCollection");
        EclipseLink2_0JavaElementCollectionMappingTests.assertNull((Object)elementCollectionMapping.getSpecifiedTargetClass());
        EclipseLink2_0JavaElementCollectionMappingTests.assertNull((Object)elementCollection.getTargetClass());
        elementCollectionMapping.setSpecifiedTargetClass("newTargetClass");
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"newTargetClass", (String)elementCollectionMapping.getSpecifiedTargetClass());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"newTargetClass", (String)elementCollection.getTargetClass());
        elementCollectionMapping.setSpecifiedTargetClass(null);
        EclipseLink2_0JavaElementCollectionMappingTests.assertNull((Object)elementCollectionMapping.getSpecifiedTargetClass());
        EclipseLink2_0JavaElementCollectionMappingTests.assertNull((Object)elementCollection.getTargetClass());
    }

    public void testDefaultTargetClass() throws Exception {
        this.createTestEntityWithGenericEmbeddableElementCollectionMapping();
        this.createTestTargetEmbeddableAddress();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        ElementCollectionMapping2_0 elementCollectionMapping = (ElementCollectionMapping2_0)persistentAttribute.getMapping();
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)FULLY_QUALIFIED_EMBEDDABLE_TYPE_NAME, (String)elementCollectionMapping.getDefaultTargetClass());
        this.addXmlClassRef(FULLY_QUALIFIED_EMBEDDABLE_TYPE_NAME);
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)FULLY_QUALIFIED_EMBEDDABLE_TYPE_NAME, (String)elementCollectionMapping.getDefaultTargetClass());
        elementCollectionMapping.setSpecifiedTargetClass("foo");
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)FULLY_QUALIFIED_EMBEDDABLE_TYPE_NAME, (String)elementCollectionMapping.getDefaultTargetClass());
        ListIterator classRefs = this.getPersistenceUnit().specifiedClassRefs();
        classRefs.next();
        ClassRef addressClassRef = (ClassRef)classRefs.next();
        JavaPersistentType addressPersistentType = addressClassRef.getJavaPersistentType();
        addressPersistentType.setMappingKey(MappingKeys.NULL_TYPE_MAPPING_KEY);
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)FULLY_QUALIFIED_EMBEDDABLE_TYPE_NAME, (String)elementCollectionMapping.getDefaultTargetClass());
    }

    public void testDefaultTargetClassNonGenericCollection() throws Exception {
        this.createTestEntityWithNonGenericElementCollectionMapping();
        this.createTestTargetEmbeddableAddress();
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef(FULLY_QUALIFIED_EMBEDDABLE_TYPE_NAME);
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        ElementCollectionMapping2_0 elementCollectionMapping = (ElementCollectionMapping2_0)persistentAttribute.getMapping();
        EclipseLink2_0JavaElementCollectionMappingTests.assertNull((Object)elementCollectionMapping.getDefaultTargetClass());
    }

    public void testDefaultTargetClassGenericCollection() throws Exception {
        this.createTestEntityWithGenericEmbeddableElementCollectionMapping();
        this.createTestTargetEmbeddableAddress();
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef(FULLY_QUALIFIED_EMBEDDABLE_TYPE_NAME);
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        ElementCollectionMapping2_0 elementCollectionMapping = (ElementCollectionMapping2_0)persistentAttribute.getMapping();
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)FULLY_QUALIFIED_EMBEDDABLE_TYPE_NAME, (String)elementCollectionMapping.getDefaultTargetClass());
    }

    public void testDefaultTargetClassNonGenericMap() throws Exception {
        this.createTestEntityWithValidNonGenericMapElementCollectionMapping();
        this.createTestTargetEmbeddableAddress();
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef(FULLY_QUALIFIED_EMBEDDABLE_TYPE_NAME);
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        ElementCollectionMapping2_0 elementCollectionMapping = (ElementCollectionMapping2_0)persistentAttribute.getMapping();
        EclipseLink2_0JavaElementCollectionMappingTests.assertNull((Object)elementCollectionMapping.getDefaultTargetClass());
    }

    public void testDefaultTargetClassGenericMap() throws Exception {
        this.createTestEntityWithValidGenericMapElementCollectionMapping();
        this.createTestTargetEmbeddableAddress();
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef(FULLY_QUALIFIED_EMBEDDABLE_TYPE_NAME);
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        ElementCollectionMapping2_0 elementCollectionMapping = (ElementCollectionMapping2_0)persistentAttribute.getMapping();
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)FULLY_QUALIFIED_EMBEDDABLE_TYPE_NAME, (String)elementCollectionMapping.getDefaultTargetClass());
    }

    public void testTargetClass() throws Exception {
        this.createTestEntityWithGenericEmbeddableElementCollectionMapping();
        this.createTestTargetEmbeddableAddress();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        ElementCollectionMapping2_0 elementCollectionMapping = (ElementCollectionMapping2_0)persistentAttribute.getMapping();
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)FULLY_QUALIFIED_EMBEDDABLE_TYPE_NAME, (String)elementCollectionMapping.getTargetClass());
        elementCollectionMapping.setSpecifiedTargetClass("foo");
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"foo", (String)elementCollectionMapping.getTargetClass());
        elementCollectionMapping.setSpecifiedTargetClass(null);
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)FULLY_QUALIFIED_EMBEDDABLE_TYPE_NAME, (String)elementCollectionMapping.getTargetClass());
    }

    public void testResolvedTargetEmbeddable() throws Exception {
        this.createTestEntityWithGenericEmbeddableElementCollectionMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        ElementCollectionMapping2_0 elementCollectionMapping = (ElementCollectionMapping2_0)persistentAttribute.getMapping();
        EclipseLink2_0JavaElementCollectionMappingTests.assertNull((Object)elementCollectionMapping.getResolvedTargetEmbeddable());
        this.createTestTargetEmbeddableAddress();
        this.addXmlClassRef(FULLY_QUALIFIED_EMBEDDABLE_TYPE_NAME);
        ListIterator classRefs = this.getPersistenceUnit().specifiedClassRefs();
        classRefs.next();
        ClassRef addressClassRef = (ClassRef)classRefs.next();
        JavaTypeMapping addressTypeMapping = addressClassRef.getJavaPersistentType().getMapping();
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((Object)addressTypeMapping, (Object)elementCollectionMapping.getResolvedTargetEmbeddable());
        elementCollectionMapping.setSpecifiedTargetClass("foo");
        EclipseLink2_0JavaElementCollectionMappingTests.assertNull((Object)elementCollectionMapping.getResolvedTargetEmbeddable());
        elementCollectionMapping.setSpecifiedTargetClass(FULLY_QUALIFIED_EMBEDDABLE_TYPE_NAME);
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((Object)addressTypeMapping, (Object)elementCollectionMapping.getResolvedTargetEmbeddable());
        elementCollectionMapping.setSpecifiedTargetClass(null);
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((Object)addressTypeMapping, (Object)elementCollectionMapping.getResolvedTargetEmbeddable());
    }

    public void testResolvedTargetEmbeddableWithBasicType() throws Exception {
        this.createTestEntityWithGenericBasicElementCollectionMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        ElementCollectionMapping2_0 elementCollectionMapping = (ElementCollectionMapping2_0)persistentAttribute.getMapping();
        EclipseLink2_0JavaElementCollectionMappingTests.assertNull((Object)elementCollectionMapping.getResolvedTargetEmbeddable());
    }

    public void testUpdateSpecifiedFetch() throws Exception {
        this.createTestEntityWithElementCollectionMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        ElementCollectionMapping2_0 elementCollectionMapping = (ElementCollectionMapping2_0)persistentAttribute.getMapping();
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        ElementCollection2_0Annotation elementCollection = (ElementCollection2_0Annotation)attributeResource.getAnnotation("javax.persistence.ElementCollection");
        EclipseLink2_0JavaElementCollectionMappingTests.assertNull((Object)elementCollectionMapping.getSpecifiedFetch());
        EclipseLink2_0JavaElementCollectionMappingTests.assertNull((Object)elementCollection.getFetch());
        elementCollection.setFetch(FetchType.EAGER);
        this.getJpaProject().synchronizeContextModel();
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((Object)org.eclipse.jpt.core.context.FetchType.EAGER, (Object)elementCollectionMapping.getSpecifiedFetch());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((Object)FetchType.EAGER, (Object)elementCollection.getFetch());
        elementCollection.setFetch(FetchType.LAZY);
        this.getJpaProject().synchronizeContextModel();
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((Object)org.eclipse.jpt.core.context.FetchType.LAZY, (Object)elementCollectionMapping.getSpecifiedFetch());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((Object)FetchType.LAZY, (Object)elementCollection.getFetch());
        elementCollection.setFetch(null);
        this.getJpaProject().synchronizeContextModel();
        EclipseLink2_0JavaElementCollectionMappingTests.assertNull((Object)elementCollectionMapping.getSpecifiedFetch());
        EclipseLink2_0JavaElementCollectionMappingTests.assertNull((Object)elementCollection.getFetch());
    }

    public void testModifySpecifiedFetch() throws Exception {
        this.createTestEntityWithElementCollectionMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        ElementCollectionMapping2_0 elementCollectionMapping = (ElementCollectionMapping2_0)persistentAttribute.getMapping();
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        ElementCollection2_0Annotation elementCollection = (ElementCollection2_0Annotation)attributeResource.getAnnotation("javax.persistence.ElementCollection");
        EclipseLink2_0JavaElementCollectionMappingTests.assertNull((Object)elementCollectionMapping.getSpecifiedFetch());
        EclipseLink2_0JavaElementCollectionMappingTests.assertNull((Object)elementCollection.getFetch());
        elementCollectionMapping.setSpecifiedFetch(org.eclipse.jpt.core.context.FetchType.EAGER);
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((Object)org.eclipse.jpt.core.context.FetchType.EAGER, (Object)elementCollectionMapping.getSpecifiedFetch());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((Object)FetchType.EAGER, (Object)elementCollection.getFetch());
        elementCollectionMapping.setSpecifiedFetch(org.eclipse.jpt.core.context.FetchType.LAZY);
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((Object)org.eclipse.jpt.core.context.FetchType.LAZY, (Object)elementCollectionMapping.getSpecifiedFetch());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((Object)FetchType.LAZY, (Object)elementCollection.getFetch());
        elementCollectionMapping.setSpecifiedFetch(null);
        EclipseLink2_0JavaElementCollectionMappingTests.assertNull((Object)elementCollectionMapping.getSpecifiedFetch());
        EclipseLink2_0JavaElementCollectionMappingTests.assertNull((Object)elementCollection.getFetch());
    }

    public void testGetValueTypeEmbeddable() throws Exception {
        this.createTestEntityWithGenericEmbeddableElementCollectionMapping();
        this.createTestTargetEmbeddableAddress();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        ElementCollectionMapping2_0 elementCollectionMapping = (ElementCollectionMapping2_0)persistentAttribute.getMapping();
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((Object)CollectionMapping.Type.EMBEDDABLE_TYPE, (Object)elementCollectionMapping.getValueType());
    }

    public void testGetValueTypeNone() throws Exception {
        this.createTestEntityWithNonGenericElementCollectionMapping();
        this.createTestTargetEmbeddableAddress();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        ElementCollectionMapping2_0 elementCollectionMapping = (ElementCollectionMapping2_0)persistentAttribute.getMapping();
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((Object)CollectionMapping.Type.NO_TYPE, (Object)elementCollectionMapping.getValueType());
        elementCollectionMapping.setSpecifiedTargetClass(EMBEDDABLE_TYPE_NAME);
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((Object)CollectionMapping.Type.EMBEDDABLE_TYPE, (Object)elementCollectionMapping.getValueType());
    }

    public void testGetValueTypeBasic() throws Exception {
        this.createTestEntityWithGenericBasicElementCollectionMapping();
        this.createTestTargetEmbeddableAddress();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        ElementCollectionMapping2_0 elementCollectionMapping = (ElementCollectionMapping2_0)persistentAttribute.getMapping();
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((Object)CollectionMapping.Type.BASIC_TYPE, (Object)elementCollectionMapping.getValueType());
    }

    public void testUpdateMapKey() throws Exception {
        this.createTestEntityWithElementCollectionMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        ElementCollectionMapping2_0 elementCollectionMapping = (ElementCollectionMapping2_0)persistentAttribute.getMapping();
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        EclipseLink2_0JavaElementCollectionMappingTests.assertNull((Object)elementCollectionMapping.getSpecifiedMapKey());
        EclipseLink2_0JavaElementCollectionMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.MapKey"));
        attributeResource.addAnnotation("javax.persistence.MapKey");
        this.getJpaProject().synchronizeContextModel();
        EclipseLink2_0JavaElementCollectionMappingTests.assertNull((Object)elementCollectionMapping.getSpecifiedMapKey());
        MapKeyAnnotation mapKey = (MapKeyAnnotation)attributeResource.getAnnotation("javax.persistence.MapKey");
        EclipseLink2_0JavaElementCollectionMappingTests.assertNotNull((Object)mapKey);
        mapKey.setName("myMapKey");
        this.getJpaProject().synchronizeContextModel();
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"myMapKey", (String)elementCollectionMapping.getSpecifiedMapKey());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"myMapKey", (String)mapKey.getName());
        mapKey.setName(null);
        this.getJpaProject().synchronizeContextModel();
        EclipseLink2_0JavaElementCollectionMappingTests.assertNull((Object)elementCollectionMapping.getSpecifiedMapKey());
        EclipseLink2_0JavaElementCollectionMappingTests.assertNull((Object)mapKey.getName());
        mapKey.setName("myMapKey");
        attributeResource.removeAnnotation("javax.persistence.MapKey");
        EclipseLink2_0JavaElementCollectionMappingTests.assertNull((Object)elementCollectionMapping.getSpecifiedMapKey());
        EclipseLink2_0JavaElementCollectionMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.MapKey"));
    }

    public void testModifyMapKey() throws Exception {
        this.createTestEntityWithElementCollectionMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        ElementCollectionMapping2_0 elementCollectionMapping = (ElementCollectionMapping2_0)persistentAttribute.getMapping();
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        EclipseLink2_0JavaElementCollectionMappingTests.assertNull((Object)elementCollectionMapping.getSpecifiedMapKey());
        EclipseLink2_0JavaElementCollectionMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.MapKey"));
        elementCollectionMapping.setSpecifiedMapKey("myMapKey");
        MapKeyAnnotation mapKey = (MapKeyAnnotation)attributeResource.getAnnotation("javax.persistence.MapKey");
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"myMapKey", (String)elementCollectionMapping.getSpecifiedMapKey());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"myMapKey", (String)mapKey.getName());
        elementCollectionMapping.setSpecifiedMapKey(null);
        EclipseLink2_0JavaElementCollectionMappingTests.assertNull((Object)elementCollectionMapping.getSpecifiedMapKey());
        EclipseLink2_0JavaElementCollectionMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.MapKey"));
    }

    public void testCandidateMapKeyNames() throws Exception {
        this.createTestEntityWithValidGenericMapElementCollectionMapping();
        this.createTestTargetEmbeddableAddress();
        this.createTestEmbeddableState();
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef(FULLY_QUALIFIED_EMBEDDABLE_TYPE_NAME);
        this.addXmlClassRef("test.State");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        ElementCollectionMapping2_0 elementCollectionMapping2_0 = (ElementCollectionMapping2_0)persistentAttribute.getMapping();
        Iterator mapKeyNames = elementCollectionMapping2_0.candidateMapKeyNames();
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"city", (String)((String)mapKeyNames.next()));
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"state", (String)((String)mapKeyNames.next()));
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"state.name", (String)((String)mapKeyNames.next()));
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"state.abbr", (String)((String)mapKeyNames.next()));
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"zip", (String)((String)mapKeyNames.next()));
        EclipseLink2_0JavaElementCollectionMappingTests.assertFalse((boolean)mapKeyNames.hasNext());
    }

    public void testCandidateMapKeyNames2() throws Exception {
        this.createTestEntityWithValidNonGenericMapElementCollectionMapping();
        this.createTestTargetEmbeddableAddress();
        this.createTestEmbeddableState();
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef(FULLY_QUALIFIED_EMBEDDABLE_TYPE_NAME);
        this.addXmlClassRef("test.State");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        ElementCollectionMapping2_0 elementCollectionMapping2_0 = (ElementCollectionMapping2_0)persistentAttribute.getMapping();
        Iterator mapKeyNames = elementCollectionMapping2_0.candidateMapKeyNames();
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((boolean)false, (boolean)mapKeyNames.hasNext());
        elementCollectionMapping2_0.setSpecifiedTargetClass(EMBEDDABLE_TYPE_NAME);
        mapKeyNames = elementCollectionMapping2_0.candidateMapKeyNames();
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"city", (String)((String)mapKeyNames.next()));
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"state", (String)((String)mapKeyNames.next()));
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"state.name", (String)((String)mapKeyNames.next()));
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"state.abbr", (String)((String)mapKeyNames.next()));
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"zip", (String)((String)mapKeyNames.next()));
        EclipseLink2_0JavaElementCollectionMappingTests.assertFalse((boolean)mapKeyNames.hasNext());
        elementCollectionMapping2_0.setSpecifiedTargetClass("String");
        mapKeyNames = elementCollectionMapping2_0.candidateMapKeyNames();
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((boolean)false, (boolean)mapKeyNames.hasNext());
    }

    public void testUpdateMapKeyClass() throws Exception {
        this.createTestEntityWithElementCollectionMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        ElementCollectionMapping2_0 elementCollectionMapping = (ElementCollectionMapping2_0)persistentAttribute.getMapping();
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        EclipseLink2_0JavaElementCollectionMappingTests.assertNull((Object)elementCollectionMapping.getSpecifiedMapKeyClass());
        EclipseLink2_0JavaElementCollectionMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.MapKeyClass"));
        attributeResource.addAnnotation("javax.persistence.MapKeyClass");
        EclipseLink2_0JavaElementCollectionMappingTests.assertNull((Object)elementCollectionMapping.getSpecifiedMapKeyClass());
        MapKeyClass2_0Annotation mapKeyClass = (MapKeyClass2_0Annotation)attributeResource.getAnnotation("javax.persistence.MapKeyClass");
        EclipseLink2_0JavaElementCollectionMappingTests.assertNotNull((Object)mapKeyClass);
        mapKeyClass.setValue("myMapKeyClass");
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"myMapKeyClass", (String)elementCollectionMapping.getSpecifiedMapKeyClass());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"myMapKeyClass", (String)mapKeyClass.getValue());
        mapKeyClass.setValue(null);
        this.getJpaProject().synchronizeContextModel();
        EclipseLink2_0JavaElementCollectionMappingTests.assertNull((Object)elementCollectionMapping.getSpecifiedMapKeyClass());
        EclipseLink2_0JavaElementCollectionMappingTests.assertNull((Object)mapKeyClass.getValue());
        mapKeyClass.setValue("myMapKeyClass");
        attributeResource.removeAnnotation("javax.persistence.MapKeyClass");
        this.getJpaProject().synchronizeContextModel();
        EclipseLink2_0JavaElementCollectionMappingTests.assertNull((Object)elementCollectionMapping.getSpecifiedMapKeyClass());
        EclipseLink2_0JavaElementCollectionMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.MapKeyClass"));
    }

    public void testModifyMapKeyClass() throws Exception {
        this.createTestEntityWithElementCollectionMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        ElementCollectionMapping2_0 elementCollectionMapping = (ElementCollectionMapping2_0)persistentAttribute.getMapping();
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        EclipseLink2_0JavaElementCollectionMappingTests.assertNull((Object)elementCollectionMapping.getSpecifiedMapKeyClass());
        EclipseLink2_0JavaElementCollectionMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.MapKeyClass"));
        elementCollectionMapping.setSpecifiedMapKeyClass("String");
        MapKeyClass2_0Annotation mapKeyClass = (MapKeyClass2_0Annotation)attributeResource.getAnnotation("javax.persistence.MapKeyClass");
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"String", (String)elementCollectionMapping.getSpecifiedMapKeyClass());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"String", (String)mapKeyClass.getValue());
        elementCollectionMapping.setSpecifiedMapKeyClass(null);
        EclipseLink2_0JavaElementCollectionMappingTests.assertNull((Object)elementCollectionMapping.getSpecifiedMapKeyClass());
        EclipseLink2_0JavaElementCollectionMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.MapKeyClass"));
    }

    public void testDefaultMapKeyClass() throws Exception {
        this.createTestEntityWithValidGenericMapElementCollectionMapping();
        this.createTestTargetEmbeddableAddress();
        this.createTestEmbeddableState();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        ElementCollectionMapping2_0 elementCollectionMapping = (ElementCollectionMapping2_0)persistentAttribute.getMapping();
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"java.lang.Integer", (String)elementCollectionMapping.getDefaultMapKeyClass());
        elementCollectionMapping.setSpecifiedMapKeyClass("foo");
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"java.lang.Integer", (String)elementCollectionMapping.getDefaultMapKeyClass());
    }

    public void testDefaultMapKeyClassCollectionType() throws Exception {
        this.createTestEntityWithGenericBasicElementCollectionMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        ElementCollectionMapping2_0 elementCollectionMapping = (ElementCollectionMapping2_0)persistentAttribute.getMapping();
        EclipseLink2_0JavaElementCollectionMappingTests.assertNull((Object)elementCollectionMapping.getDefaultMapKeyClass());
    }

    public void testMapKeyClass() throws Exception {
        this.createTestEntityWithValidGenericMapElementCollectionMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        ElementCollectionMapping2_0 elementCollectionMapping = (ElementCollectionMapping2_0)persistentAttribute.getMapping();
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"java.lang.Integer", (String)elementCollectionMapping.getMapKeyClass());
        elementCollectionMapping.setSpecifiedMapKeyClass("foo");
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"foo", (String)elementCollectionMapping.getMapKeyClass());
        elementCollectionMapping.setSpecifiedMapKeyClass(null);
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"java.lang.Integer", (String)elementCollectionMapping.getMapKeyClass());
    }

    public void testOrderColumnDefaults() throws Exception {
        this.createTestEntityWithGenericEmbeddableElementCollectionMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        ElementCollectionMapping2_0 elementCollectionMapping = (ElementCollectionMapping2_0)persistentAttribute.getMapping();
        Orderable2_0 orderable = (Orderable2_0)elementCollectionMapping.getOrderable();
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((boolean)false, (boolean)orderable.isOrderColumnOrdering());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((boolean)true, (boolean)orderable.isNoOrdering());
        orderable.setOrderColumnOrdering(true);
        OrderColumn2_0 orderColumn = orderable.getOrderColumn();
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((boolean)true, (boolean)orderable.isOrderColumnOrdering());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals(null, (String)orderColumn.getSpecifiedName());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"addresses_ORDER", (String)orderColumn.getDefaultName());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"AnnotationTestType_addresses", (String)orderColumn.getTable());
        orderColumn.setSpecifiedName("FOO");
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"FOO", (String)orderColumn.getSpecifiedName());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"addresses_ORDER", (String)orderColumn.getDefaultName());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"AnnotationTestType_addresses", (String)orderColumn.getTable());
    }

    public void testGetValueColumn() throws Exception {
        this.createTestEntityWithElementCollectionMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        ElementCollectionMapping2_0 elementCollectionMapping = (ElementCollectionMapping2_0)persistentAttribute.getSpecifiedMapping();
        EclipseLink2_0JavaElementCollectionMappingTests.assertNull((Object)elementCollectionMapping.getValueColumn().getSpecifiedName());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"id", (String)elementCollectionMapping.getValueColumn().getName());
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        ColumnAnnotation column = (ColumnAnnotation)attributeResource.addAnnotation("javax.persistence.Column");
        column.setName("foo");
        this.getJpaProject().synchronizeContextModel();
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"foo", (String)elementCollectionMapping.getValueColumn().getSpecifiedName());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"foo", (String)elementCollectionMapping.getValueColumn().getName());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"id", (String)elementCollectionMapping.getValueColumn().getDefaultName());
    }

    public void testSpecifiedAttributeOverrides() throws Exception {
        this.createTestEntityWithGenericEmbeddableElementCollectionMapping();
        this.createTestTargetEmbeddableAddress();
        this.createTestEmbeddableState();
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef(FULLY_QUALIFIED_EMBEDDABLE_TYPE_NAME);
        this.addXmlClassRef("test.State");
        JavaElementCollectionMapping2_0 elementCollectionMapping = (JavaElementCollectionMapping2_0)this.getJavaPersistentType().getAttributeNamed("addresses").getMapping();
        JavaAttributeOverrideContainer attributeOverrideContainer = elementCollectionMapping.getValueAttributeOverrideContainer();
        ListIterator specifiedAttributeOverrides = attributeOverrideContainer.specifiedAttributeOverrides();
        EclipseLink2_0JavaElementCollectionMappingTests.assertFalse((boolean)specifiedAttributeOverrides.hasNext());
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        AttributeOverrideAnnotation attributeOverride = (AttributeOverrideAnnotation)attributeResource.addAnnotation(0, "javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides");
        attributeOverride.setName("FOO");
        this.getJpaProject().synchronizeContextModel();
        specifiedAttributeOverrides = attributeOverrideContainer.specifiedAttributeOverrides();
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"FOO", (String)((JavaAttributeOverride)specifiedAttributeOverrides.next()).getName());
        EclipseLink2_0JavaElementCollectionMappingTests.assertFalse((boolean)specifiedAttributeOverrides.hasNext());
        attributeOverride = (AttributeOverrideAnnotation)attributeResource.addAnnotation(1, "javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides");
        attributeOverride.setName("BAR");
        this.getJpaProject().synchronizeContextModel();
        specifiedAttributeOverrides = attributeOverrideContainer.specifiedAttributeOverrides();
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"FOO", (String)((JavaAttributeOverride)specifiedAttributeOverrides.next()).getName());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"BAR", (String)((JavaAttributeOverride)specifiedAttributeOverrides.next()).getName());
        EclipseLink2_0JavaElementCollectionMappingTests.assertFalse((boolean)specifiedAttributeOverrides.hasNext());
        attributeOverride = (AttributeOverrideAnnotation)attributeResource.addAnnotation(0, "javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides");
        attributeOverride.setName("BAZ");
        this.getJpaProject().synchronizeContextModel();
        specifiedAttributeOverrides = attributeOverrideContainer.specifiedAttributeOverrides();
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"BAZ", (String)((JavaAttributeOverride)specifiedAttributeOverrides.next()).getName());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"FOO", (String)((JavaAttributeOverride)specifiedAttributeOverrides.next()).getName());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"BAR", (String)((JavaAttributeOverride)specifiedAttributeOverrides.next()).getName());
        EclipseLink2_0JavaElementCollectionMappingTests.assertFalse((boolean)specifiedAttributeOverrides.hasNext());
        attributeResource.moveAnnotation(1, 0, "javax.persistence.AttributeOverrides");
        this.getJpaProject().synchronizeContextModel();
        specifiedAttributeOverrides = attributeOverrideContainer.specifiedAttributeOverrides();
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"FOO", (String)((JavaAttributeOverride)specifiedAttributeOverrides.next()).getName());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"BAZ", (String)((JavaAttributeOverride)specifiedAttributeOverrides.next()).getName());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"BAR", (String)((JavaAttributeOverride)specifiedAttributeOverrides.next()).getName());
        EclipseLink2_0JavaElementCollectionMappingTests.assertFalse((boolean)specifiedAttributeOverrides.hasNext());
        attributeResource.removeAnnotation(0, "javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides");
        this.getJpaProject().synchronizeContextModel();
        specifiedAttributeOverrides = attributeOverrideContainer.specifiedAttributeOverrides();
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"BAZ", (String)((JavaAttributeOverride)specifiedAttributeOverrides.next()).getName());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"BAR", (String)((JavaAttributeOverride)specifiedAttributeOverrides.next()).getName());
        EclipseLink2_0JavaElementCollectionMappingTests.assertFalse((boolean)specifiedAttributeOverrides.hasNext());
        attributeResource.removeAnnotation(0, "javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides");
        this.getJpaProject().synchronizeContextModel();
        specifiedAttributeOverrides = attributeOverrideContainer.specifiedAttributeOverrides();
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"BAR", (String)((JavaAttributeOverride)specifiedAttributeOverrides.next()).getName());
        EclipseLink2_0JavaElementCollectionMappingTests.assertFalse((boolean)specifiedAttributeOverrides.hasNext());
        attributeResource.removeAnnotation(0, "javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides");
        this.getJpaProject().synchronizeContextModel();
        specifiedAttributeOverrides = attributeOverrideContainer.specifiedAttributeOverrides();
        EclipseLink2_0JavaElementCollectionMappingTests.assertFalse((boolean)specifiedAttributeOverrides.hasNext());
    }

    public void testVirtualAttributeOverrides() throws Exception {
        this.createTestEntityWithGenericEmbeddableElementCollectionMapping();
        this.createTestTargetEmbeddableAddress();
        this.createTestEmbeddableState();
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef(FULLY_QUALIFIED_EMBEDDABLE_TYPE_NAME);
        this.addXmlClassRef("test.State");
        ElementCollectionMapping2_0 elementCollectionMapping = (ElementCollectionMapping2_0)this.getJavaPersistentType().getAttributeNamed("addresses").getMapping();
        AttributeOverrideContainer attributeOverrideContainer = elementCollectionMapping.getValueAttributeOverrideContainer();
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"addresses", (String)attributeResource.getName());
        EclipseLink2_0JavaElementCollectionMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.AttributeOverride"));
        EclipseLink2_0JavaElementCollectionMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.AttributeOverrides"));
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((int)4, (int)attributeOverrideContainer.virtualAttributeOverridesSize());
        AttributeOverride defaultAttributeOverride = (AttributeOverride)attributeOverrideContainer.virtualAttributeOverrides().next();
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"city", (String)defaultAttributeOverride.getName());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"city", (String)defaultAttributeOverride.getColumn().getName());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"AnnotationTestType_addresses", (String)defaultAttributeOverride.getColumn().getTable());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals(null, (String)defaultAttributeOverride.getColumn().getColumnDefinition());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((boolean)true, (boolean)defaultAttributeOverride.getColumn().isInsertable());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((boolean)true, (boolean)defaultAttributeOverride.getColumn().isUpdatable());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((boolean)false, (boolean)defaultAttributeOverride.getColumn().isUnique());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((boolean)true, (boolean)defaultAttributeOverride.getColumn().isNullable());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((int)255, (int)defaultAttributeOverride.getColumn().getLength());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((int)0, (int)defaultAttributeOverride.getColumn().getPrecision());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((int)0, (int)defaultAttributeOverride.getColumn().getScale());
        ListIterator classRefs = this.getPersistenceUnit().specifiedClassRefs();
        classRefs.next();
        Embeddable embeddable = (Embeddable)((ClassRef)classRefs.next()).getJavaPersistentType().getMapping();
        BasicMapping cityMapping = (BasicMapping)embeddable.getPersistentType().getAttributeNamed("city").getMapping();
        cityMapping.getColumn().setSpecifiedName("FOO");
        cityMapping.getColumn().setSpecifiedTable("BAR");
        cityMapping.getColumn().setColumnDefinition("COLUMN_DEF");
        cityMapping.getColumn().setSpecifiedInsertable(Boolean.FALSE);
        cityMapping.getColumn().setSpecifiedUpdatable(Boolean.FALSE);
        cityMapping.getColumn().setSpecifiedUnique(Boolean.TRUE);
        cityMapping.getColumn().setSpecifiedNullable(Boolean.FALSE);
        cityMapping.getColumn().setSpecifiedLength(Integer.valueOf(5));
        cityMapping.getColumn().setSpecifiedPrecision(Integer.valueOf(6));
        cityMapping.getColumn().setSpecifiedScale(Integer.valueOf(7));
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"addresses", (String)attributeResource.getName());
        EclipseLink2_0JavaElementCollectionMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.AttributeOverride"));
        EclipseLink2_0JavaElementCollectionMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.AttributeOverrides"));
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((int)4, (int)attributeOverrideContainer.virtualAttributeOverridesSize());
        defaultAttributeOverride = (AttributeOverride)attributeOverrideContainer.virtualAttributeOverrides().next();
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"city", (String)defaultAttributeOverride.getName());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"FOO", (String)defaultAttributeOverride.getColumn().getName());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"BAR", (String)defaultAttributeOverride.getColumn().getTable());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"COLUMN_DEF", (String)defaultAttributeOverride.getColumn().getColumnDefinition());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((boolean)false, (boolean)defaultAttributeOverride.getColumn().isInsertable());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((boolean)false, (boolean)defaultAttributeOverride.getColumn().isUpdatable());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((boolean)true, (boolean)defaultAttributeOverride.getColumn().isUnique());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((boolean)false, (boolean)defaultAttributeOverride.getColumn().isNullable());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((int)5, (int)defaultAttributeOverride.getColumn().getLength());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((int)6, (int)defaultAttributeOverride.getColumn().getPrecision());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((int)7, (int)defaultAttributeOverride.getColumn().getScale());
        cityMapping.getColumn().setSpecifiedName(null);
        cityMapping.getColumn().setSpecifiedTable(null);
        cityMapping.getColumn().setColumnDefinition(null);
        cityMapping.getColumn().setSpecifiedInsertable(null);
        cityMapping.getColumn().setSpecifiedUpdatable(null);
        cityMapping.getColumn().setSpecifiedUnique(null);
        cityMapping.getColumn().setSpecifiedNullable(null);
        cityMapping.getColumn().setSpecifiedLength(null);
        cityMapping.getColumn().setSpecifiedPrecision(null);
        cityMapping.getColumn().setSpecifiedScale(null);
        defaultAttributeOverride = (AttributeOverride)attributeOverrideContainer.virtualAttributeOverrides().next();
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"city", (String)defaultAttributeOverride.getName());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"city", (String)defaultAttributeOverride.getColumn().getName());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"AnnotationTestType_addresses", (String)defaultAttributeOverride.getColumn().getTable());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals(null, (String)defaultAttributeOverride.getColumn().getColumnDefinition());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((boolean)true, (boolean)defaultAttributeOverride.getColumn().isInsertable());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((boolean)true, (boolean)defaultAttributeOverride.getColumn().isUpdatable());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((boolean)false, (boolean)defaultAttributeOverride.getColumn().isUnique());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((boolean)true, (boolean)defaultAttributeOverride.getColumn().isNullable());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((int)255, (int)defaultAttributeOverride.getColumn().getLength());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((int)0, (int)defaultAttributeOverride.getColumn().getPrecision());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((int)0, (int)defaultAttributeOverride.getColumn().getScale());
        AttributeOverrideAnnotation annotation = (AttributeOverrideAnnotation)attributeResource.addAnnotation(0, "javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides");
        annotation.setName("city");
        this.getJpaProject().synchronizeContextModel();
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((int)3, (int)attributeOverrideContainer.virtualAttributeOverridesSize());
    }

    public void testSpecifiedAttributeOverridesSize() throws Exception {
        this.createTestEntityWithGenericEmbeddableElementCollectionMapping();
        this.createTestTargetEmbeddableAddress();
        this.createTestEmbeddableState();
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef(FULLY_QUALIFIED_EMBEDDABLE_TYPE_NAME);
        this.addXmlClassRef("test.State");
        ElementCollectionMapping2_0 elementCollectionMapping = (ElementCollectionMapping2_0)this.getJavaPersistentType().getAttributeNamed("addresses").getMapping();
        AttributeOverrideContainer attributeOverrideContainer = elementCollectionMapping.getValueAttributeOverrideContainer();
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((int)0, (int)attributeOverrideContainer.specifiedAttributeOverridesSize());
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        AttributeOverrideAnnotation attributeOverride = (AttributeOverrideAnnotation)attributeResource.addAnnotation(0, "javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides");
        attributeOverride.setName("FOO");
        attributeOverride = (AttributeOverrideAnnotation)attributeResource.addAnnotation(0, "javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides");
        attributeOverride.setName("BAR");
        this.getJpaProject().synchronizeContextModel();
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((int)2, (int)attributeOverrideContainer.specifiedAttributeOverridesSize());
    }

    public void testAttributeOverridesSize() throws Exception {
        this.createTestEntityWithGenericEmbeddableElementCollectionMapping();
        this.createTestTargetEmbeddableAddress();
        this.createTestEmbeddableState();
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef(FULLY_QUALIFIED_EMBEDDABLE_TYPE_NAME);
        this.addXmlClassRef("test.State");
        ElementCollectionMapping2_0 elementCollectionMapping = (ElementCollectionMapping2_0)this.getJavaPersistentType().getAttributeNamed("addresses").getMapping();
        AttributeOverrideContainer attributeOverrideContainer = elementCollectionMapping.getValueAttributeOverrideContainer();
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((int)4, (int)attributeOverrideContainer.attributeOverridesSize());
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        AttributeOverrideAnnotation attributeOverride = (AttributeOverrideAnnotation)attributeResource.addAnnotation(0, "javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides");
        attributeOverride.setName("FOO");
        attributeOverride = (AttributeOverrideAnnotation)attributeResource.addAnnotation(0, "javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides");
        attributeOverride.setName("BAR");
        this.getJpaProject().synchronizeContextModel();
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((int)6, (int)attributeOverrideContainer.attributeOverridesSize());
        attributeOverride = (AttributeOverrideAnnotation)attributeResource.addAnnotation(0, "javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides");
        attributeOverride.setName("city");
        this.getJpaProject().synchronizeContextModel();
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((int)6, (int)attributeOverrideContainer.attributeOverridesSize());
    }

    public void testVirtualAttributeOverridesSize() throws Exception {
        this.createTestEntityWithGenericEmbeddableElementCollectionMapping();
        this.createTestTargetEmbeddableAddress();
        this.createTestEmbeddableState();
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef(FULLY_QUALIFIED_EMBEDDABLE_TYPE_NAME);
        this.addXmlClassRef("test.State");
        ElementCollectionMapping2_0 elementCollectionMapping = (ElementCollectionMapping2_0)this.getJavaPersistentType().getAttributeNamed("addresses").getMapping();
        AttributeOverrideContainer attributeOverrideContainer = elementCollectionMapping.getValueAttributeOverrideContainer();
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((int)4, (int)attributeOverrideContainer.virtualAttributeOverridesSize());
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        AttributeOverrideAnnotation attributeOverride = (AttributeOverrideAnnotation)attributeResource.addAnnotation(0, "javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides");
        attributeOverride.setName("FOO");
        this.getJpaProject().synchronizeContextModel();
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((int)4, (int)attributeOverrideContainer.virtualAttributeOverridesSize());
        attributeOverride = (AttributeOverrideAnnotation)attributeResource.addAnnotation(0, "javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides");
        attributeOverride.setName("city");
        this.getJpaProject().synchronizeContextModel();
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((int)3, (int)attributeOverrideContainer.virtualAttributeOverridesSize());
        attributeOverride = (AttributeOverrideAnnotation)attributeResource.addAnnotation(0, "javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides");
        attributeOverride.setName("state.name");
        this.getJpaProject().synchronizeContextModel();
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((int)2, (int)attributeOverrideContainer.virtualAttributeOverridesSize());
    }

    public void testAttributeOverrideSetVirtual() throws Exception {
        this.createTestEntityWithGenericEmbeddableElementCollectionMapping();
        this.createTestTargetEmbeddableAddress();
        this.createTestEmbeddableState();
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef(FULLY_QUALIFIED_EMBEDDABLE_TYPE_NAME);
        this.addXmlClassRef("test.State");
        ElementCollectionMapping2_0 elementCollectionMapping = (ElementCollectionMapping2_0)this.getJavaPersistentType().getAttributeNamed("addresses").getMapping();
        AttributeOverrideContainer attributeOverrideContainer = elementCollectionMapping.getValueAttributeOverrideContainer();
        ((AttributeOverride)attributeOverrideContainer.virtualAttributeOverrides().next()).setVirtual(false);
        ((AttributeOverride)attributeOverrideContainer.virtualAttributeOverrides().next()).setVirtual(false);
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        Iterator attributeOverrides = attributeResource.annotations("javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides");
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"city", (String)((AttributeOverrideAnnotation)attributeOverrides.next()).getName());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"state.name", (String)((AttributeOverrideAnnotation)attributeOverrides.next()).getName());
        EclipseLink2_0JavaElementCollectionMappingTests.assertFalse((boolean)attributeOverrides.hasNext());
        ((AttributeOverride)attributeOverrideContainer.specifiedAttributeOverrides().next()).setVirtual(true);
        attributeOverrides = attributeResource.annotations("javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides");
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"state.name", (String)((AttributeOverrideAnnotation)attributeOverrides.next()).getName());
        EclipseLink2_0JavaElementCollectionMappingTests.assertFalse((boolean)attributeOverrides.hasNext());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"state.abbr", (String)((AttributeOverride)attributeOverrideContainer.virtualAttributeOverrides().next()).getName());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((int)3, (int)attributeOverrideContainer.virtualAttributeOverridesSize());
        ((AttributeOverride)attributeOverrideContainer.specifiedAttributeOverrides().next()).setVirtual(true);
        attributeOverrides = attributeResource.annotations("javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides");
        EclipseLink2_0JavaElementCollectionMappingTests.assertFalse((boolean)attributeOverrides.hasNext());
        ListIterator virtualAttributeOverrides = attributeOverrideContainer.virtualAttributeOverrides();
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"state.abbr", (String)((AttributeOverride)virtualAttributeOverrides.next()).getName());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"zip", (String)((AttributeOverride)virtualAttributeOverrides.next()).getName());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"city", (String)((AttributeOverride)virtualAttributeOverrides.next()).getName());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"state.name", (String)((AttributeOverride)virtualAttributeOverrides.next()).getName());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((int)4, (int)attributeOverrideContainer.virtualAttributeOverridesSize());
    }

    public void testAttributeOverrideSetVirtual2() throws Exception {
        this.createTestEntityWithGenericEmbeddableElementCollectionMapping();
        this.createTestTargetEmbeddableAddress();
        this.createTestEmbeddableState();
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef(FULLY_QUALIFIED_EMBEDDABLE_TYPE_NAME);
        this.addXmlClassRef("test.State");
        ElementCollectionMapping2_0 elementCollectionMapping = (ElementCollectionMapping2_0)this.getJavaPersistentType().getAttributeNamed("addresses").getMapping();
        AttributeOverrideContainer attributeOverrideContainer = elementCollectionMapping.getValueAttributeOverrideContainer();
        ListIterator virtualAttributeOverrides = attributeOverrideContainer.virtualAttributeOverrides();
        virtualAttributeOverrides.next();
        ((AttributeOverride)virtualAttributeOverrides.next()).setVirtual(false);
        ((AttributeOverride)attributeOverrideContainer.virtualAttributeOverrides().next()).setVirtual(false);
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        Iterator attributeOverrides = attributeResource.annotations("javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides");
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"state.name", (String)((AttributeOverrideAnnotation)attributeOverrides.next()).getName());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"city", (String)((AttributeOverrideAnnotation)attributeOverrides.next()).getName());
        EclipseLink2_0JavaElementCollectionMappingTests.assertFalse((boolean)attributeOverrides.hasNext());
    }

    public void testMoveSpecifiedAttributeOverride() throws Exception {
        this.createTestEntityWithGenericEmbeddableElementCollectionMapping();
        this.createTestTargetEmbeddableAddress();
        this.createTestEmbeddableState();
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef(FULLY_QUALIFIED_EMBEDDABLE_TYPE_NAME);
        this.addXmlClassRef("test.State");
        ElementCollectionMapping2_0 elementCollectionMapping = (ElementCollectionMapping2_0)this.getJavaPersistentType().getAttributeNamed("addresses").getMapping();
        AttributeOverrideContainer attributeOverrideContainer = elementCollectionMapping.getValueAttributeOverrideContainer();
        ((AttributeOverride)attributeOverrideContainer.virtualAttributeOverrides().next()).setVirtual(false);
        ((AttributeOverride)attributeOverrideContainer.virtualAttributeOverrides().next()).setVirtual(false);
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        attributeResource.moveAnnotation(1, 0, "javax.persistence.AttributeOverrides");
        Iterator attributeOverrides = attributeResource.annotations("javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides");
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"state.name", (String)((AttributeOverrideAnnotation)attributeOverrides.next()).getName());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"city", (String)((AttributeOverrideAnnotation)attributeOverrides.next()).getName());
        EclipseLink2_0JavaElementCollectionMappingTests.assertFalse((boolean)attributeOverrides.hasNext());
    }

    public void testNestedVirtualAttributeOverrides() throws Exception {
        this.createTestEntityWithGenericEmbeddableElementCollectionMapping();
        this.createTestTargetEmbeddableAddress();
        this.createTestEmbeddableState();
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef(FULLY_QUALIFIED_EMBEDDABLE_TYPE_NAME);
        this.addXmlClassRef("test.State");
        ListIterator specifiedClassRefs = this.getPersistenceUnit().specifiedClassRefs();
        JavaPersistentType persistentType = ((ClassRef)specifiedClassRefs.next()).getJavaPersistentType();
        ElementCollectionMapping2_0 elementCollectionMapping = (ElementCollectionMapping2_0)persistentType.getAttributeNamed("addresses").getMapping();
        AttributeOverrideContainer attributeOverrideContainer = elementCollectionMapping.getValueAttributeOverrideContainer();
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((int)4, (int)attributeOverrideContainer.virtualAttributeOverridesSize());
        ListIterator virtualAttributeOverrides = attributeOverrideContainer.virtualAttributeOverrides();
        AttributeOverride virtualAttributeOverride = (AttributeOverride)virtualAttributeOverrides.next();
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"city", (String)virtualAttributeOverride.getName());
        virtualAttributeOverride = (AttributeOverride)virtualAttributeOverrides.next();
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"state.name", (String)virtualAttributeOverride.getName());
        virtualAttributeOverride = (AttributeOverride)virtualAttributeOverrides.next();
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"state.abbr", (String)virtualAttributeOverride.getName());
        virtualAttributeOverride = (AttributeOverride)virtualAttributeOverrides.next();
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"zip", (String)virtualAttributeOverride.getName());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((boolean)false, (boolean)virtualAttributeOverrides.hasNext());
        JavaPersistentType addressPersistentType = ((ClassRef)specifiedClassRefs.next()).getJavaPersistentType();
        EmbeddedMapping nestedEmbeddedMapping = (EmbeddedMapping)addressPersistentType.getAttributeNamed("state").getMapping();
        AttributeOverrideContainer nestedAttributeOverrideContainer = nestedEmbeddedMapping.getAttributeOverrideContainer();
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((int)2, (int)nestedAttributeOverrideContainer.virtualAttributeOverridesSize());
        virtualAttributeOverrides = nestedAttributeOverrideContainer.virtualAttributeOverrides();
        virtualAttributeOverride = (AttributeOverride)virtualAttributeOverrides.next();
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"name", (String)virtualAttributeOverride.getName());
        virtualAttributeOverride = (AttributeOverride)virtualAttributeOverrides.next();
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"abbr", (String)virtualAttributeOverride.getName());
        JavaPersistentType statePersistentType = ((ClassRef)specifiedClassRefs.next()).getJavaPersistentType();
        BasicMapping abbrMapping = (BasicMapping)statePersistentType.getAttributeNamed("abbr").getMapping();
        abbrMapping.getColumn().setSpecifiedName("BLAH");
        abbrMapping.getColumn().setSpecifiedTable("BLAH_TABLE");
        abbrMapping.getColumn().setColumnDefinition("COLUMN_DEFINITION");
        abbrMapping.getColumn().setSpecifiedInsertable(Boolean.FALSE);
        abbrMapping.getColumn().setSpecifiedUpdatable(Boolean.FALSE);
        abbrMapping.getColumn().setSpecifiedUnique(Boolean.TRUE);
        abbrMapping.getColumn().setSpecifiedNullable(Boolean.FALSE);
        abbrMapping.getColumn().setSpecifiedLength(Integer.valueOf(5));
        abbrMapping.getColumn().setSpecifiedPrecision(Integer.valueOf(6));
        abbrMapping.getColumn().setSpecifiedScale(Integer.valueOf(7));
        virtualAttributeOverride = ((EmbeddedMapping)addressPersistentType.getAttributeNamed("state").getMapping()).getAttributeOverrideContainer().getAttributeOverrideNamed("abbr");
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"abbr", (String)virtualAttributeOverride.getName());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"BLAH", (String)virtualAttributeOverride.getColumn().getName());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"BLAH_TABLE", (String)virtualAttributeOverride.getColumn().getTable());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"COLUMN_DEFINITION", (String)virtualAttributeOverride.getColumn().getColumnDefinition());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((boolean)false, (boolean)virtualAttributeOverride.getColumn().isInsertable());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((boolean)false, (boolean)virtualAttributeOverride.getColumn().isUpdatable());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((boolean)true, (boolean)virtualAttributeOverride.getColumn().isUnique());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((boolean)false, (boolean)virtualAttributeOverride.getColumn().isNullable());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((int)5, (int)virtualAttributeOverride.getColumn().getLength());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((int)6, (int)virtualAttributeOverride.getColumn().getPrecision());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((int)7, (int)virtualAttributeOverride.getColumn().getScale());
    }

    public void testGetMapKeyColumn() throws Exception {
        this.createTestEntityWithValidGenericMapElementCollectionMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        ElementCollectionMapping2_0 elementCollectionMapping = (ElementCollectionMapping2_0)persistentAttribute.getSpecifiedMapping();
        EclipseLink2_0JavaElementCollectionMappingTests.assertNull((Object)elementCollectionMapping.getMapKeyColumn().getSpecifiedName());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"addresses_KEY", (String)elementCollectionMapping.getMapKeyColumn().getName());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"AnnotationTestType_addresses", (String)elementCollectionMapping.getMapKeyColumn().getTable());
        elementCollectionMapping.getCollectionTable().setSpecifiedName("MY_COLLECTION_TABLE");
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"MY_COLLECTION_TABLE", (String)elementCollectionMapping.getMapKeyColumn().getTable());
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        MapKeyColumn2_0Annotation column = (MapKeyColumn2_0Annotation)attributeResource.addAnnotation("javax.persistence.MapKeyColumn");
        column.setName("foo");
        this.getJpaProject().synchronizeContextModel();
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"foo", (String)elementCollectionMapping.getMapKeyColumn().getSpecifiedName());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"foo", (String)elementCollectionMapping.getMapKeyColumn().getName());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"addresses_KEY", (String)elementCollectionMapping.getMapKeyColumn().getDefaultName());
    }

    public void testMapKeyValueSpecifiedAttributeOverrides() throws Exception {
        this.createTestEntityWithEmbeddableKeyAndValueElementCollectionMapping();
        this.createTestTargetEmbeddableAddress();
        this.createTestEmbeddablePropertyInfo();
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef(FULLY_QUALIFIED_EMBEDDABLE_TYPE_NAME);
        this.addXmlClassRef("test.PropertyInfo");
        JavaElementCollectionMapping2_0 elementCollectionMapping = (JavaElementCollectionMapping2_0)this.getJavaPersistentType().getAttributeNamed("parcels").getMapping();
        JavaAttributeOverrideContainer attributeOverrideContainer = elementCollectionMapping.getValueAttributeOverrideContainer();
        JavaAttributeOverrideContainer mapKeyAttributeOverrideContainer = elementCollectionMapping.getMapKeyAttributeOverrideContainer();
        ListIterator specifiedAttributeOverrides = attributeOverrideContainer.specifiedAttributeOverrides();
        EclipseLink2_0JavaElementCollectionMappingTests.assertFalse((boolean)specifiedAttributeOverrides.hasNext());
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        AttributeOverrideAnnotation attributeOverride = (AttributeOverrideAnnotation)attributeResource.addAnnotation(0, "javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides");
        attributeOverride.setName("FOO");
        this.getJpaProject().synchronizeContextModel();
        specifiedAttributeOverrides = attributeOverrideContainer.specifiedAttributeOverrides();
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"FOO", (String)((JavaAttributeOverride)specifiedAttributeOverrides.next()).getName());
        EclipseLink2_0JavaElementCollectionMappingTests.assertFalse((boolean)specifiedAttributeOverrides.hasNext());
        attributeOverride = (AttributeOverrideAnnotation)attributeResource.addAnnotation(1, "javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides");
        attributeOverride.setName("value.BAR");
        this.getJpaProject().synchronizeContextModel();
        specifiedAttributeOverrides = attributeOverrideContainer.specifiedAttributeOverrides();
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"FOO", (String)((JavaAttributeOverride)specifiedAttributeOverrides.next()).getName());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"BAR", (String)((JavaAttributeOverride)specifiedAttributeOverrides.next()).getName());
        EclipseLink2_0JavaElementCollectionMappingTests.assertFalse((boolean)specifiedAttributeOverrides.hasNext());
        attributeOverride = (AttributeOverrideAnnotation)attributeResource.addAnnotation(0, "javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides");
        attributeOverride.setName("key.BAZ");
        this.getJpaProject().synchronizeContextModel();
        specifiedAttributeOverrides = attributeOverrideContainer.specifiedAttributeOverrides();
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"FOO", (String)((JavaAttributeOverride)specifiedAttributeOverrides.next()).getName());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"BAR", (String)((JavaAttributeOverride)specifiedAttributeOverrides.next()).getName());
        EclipseLink2_0JavaElementCollectionMappingTests.assertFalse((boolean)specifiedAttributeOverrides.hasNext());
        ListIterator specifiedMapKeyAttributeOverrides = mapKeyAttributeOverrideContainer.specifiedAttributeOverrides();
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"BAZ", (String)((JavaAttributeOverride)specifiedMapKeyAttributeOverrides.next()).getName());
        EclipseLink2_0JavaElementCollectionMappingTests.assertFalse((boolean)specifiedMapKeyAttributeOverrides.hasNext());
        attributeOverride = (AttributeOverrideAnnotation)attributeResource.addAnnotation(0, "javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides");
        attributeOverride.setName("key.BLAH");
        this.getJpaProject().synchronizeContextModel();
        specifiedAttributeOverrides = attributeOverrideContainer.specifiedAttributeOverrides();
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"FOO", (String)((JavaAttributeOverride)specifiedAttributeOverrides.next()).getName());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"BAR", (String)((JavaAttributeOverride)specifiedAttributeOverrides.next()).getName());
        EclipseLink2_0JavaElementCollectionMappingTests.assertFalse((boolean)specifiedAttributeOverrides.hasNext());
        specifiedMapKeyAttributeOverrides = mapKeyAttributeOverrideContainer.specifiedAttributeOverrides();
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"BLAH", (String)((JavaAttributeOverride)specifiedMapKeyAttributeOverrides.next()).getName());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"BAZ", (String)((JavaAttributeOverride)specifiedMapKeyAttributeOverrides.next()).getName());
        EclipseLink2_0JavaElementCollectionMappingTests.assertFalse((boolean)specifiedMapKeyAttributeOverrides.hasNext());
        attributeResource.moveAnnotation(1, 0, "javax.persistence.AttributeOverrides");
        this.getJpaProject().synchronizeContextModel();
        specifiedAttributeOverrides = attributeOverrideContainer.specifiedAttributeOverrides();
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"FOO", (String)((JavaAttributeOverride)specifiedAttributeOverrides.next()).getName());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"BAR", (String)((JavaAttributeOverride)specifiedAttributeOverrides.next()).getName());
        EclipseLink2_0JavaElementCollectionMappingTests.assertFalse((boolean)specifiedAttributeOverrides.hasNext());
        specifiedMapKeyAttributeOverrides = mapKeyAttributeOverrideContainer.specifiedAttributeOverrides();
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"BAZ", (String)((JavaAttributeOverride)specifiedMapKeyAttributeOverrides.next()).getName());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"BLAH", (String)((JavaAttributeOverride)specifiedMapKeyAttributeOverrides.next()).getName());
        EclipseLink2_0JavaElementCollectionMappingTests.assertFalse((boolean)specifiedMapKeyAttributeOverrides.hasNext());
        attributeResource.removeAnnotation(0, "javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides");
        this.getJpaProject().synchronizeContextModel();
        specifiedAttributeOverrides = attributeOverrideContainer.specifiedAttributeOverrides();
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"FOO", (String)((JavaAttributeOverride)specifiedAttributeOverrides.next()).getName());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"BAR", (String)((JavaAttributeOverride)specifiedAttributeOverrides.next()).getName());
        EclipseLink2_0JavaElementCollectionMappingTests.assertFalse((boolean)specifiedAttributeOverrides.hasNext());
        specifiedMapKeyAttributeOverrides = mapKeyAttributeOverrideContainer.specifiedAttributeOverrides();
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"BLAH", (String)((JavaAttributeOverride)specifiedMapKeyAttributeOverrides.next()).getName());
        EclipseLink2_0JavaElementCollectionMappingTests.assertFalse((boolean)specifiedMapKeyAttributeOverrides.hasNext());
        attributeResource.removeAnnotation(1, "javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides");
        this.getJpaProject().synchronizeContextModel();
        specifiedAttributeOverrides = attributeOverrideContainer.specifiedAttributeOverrides();
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"BAR", (String)((JavaAttributeOverride)specifiedAttributeOverrides.next()).getName());
        EclipseLink2_0JavaElementCollectionMappingTests.assertFalse((boolean)specifiedAttributeOverrides.hasNext());
        specifiedMapKeyAttributeOverrides = mapKeyAttributeOverrideContainer.specifiedAttributeOverrides();
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"BLAH", (String)((JavaAttributeOverride)specifiedMapKeyAttributeOverrides.next()).getName());
        EclipseLink2_0JavaElementCollectionMappingTests.assertFalse((boolean)specifiedMapKeyAttributeOverrides.hasNext());
        attributeResource.removeAnnotation(0, "javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides");
        this.getJpaProject().synchronizeContextModel();
        specifiedAttributeOverrides = attributeOverrideContainer.specifiedAttributeOverrides();
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"BAR", (String)((JavaAttributeOverride)specifiedAttributeOverrides.next()).getName());
        EclipseLink2_0JavaElementCollectionMappingTests.assertFalse((boolean)specifiedAttributeOverrides.hasNext());
        specifiedMapKeyAttributeOverrides = mapKeyAttributeOverrideContainer.specifiedAttributeOverrides();
        EclipseLink2_0JavaElementCollectionMappingTests.assertFalse((boolean)specifiedMapKeyAttributeOverrides.hasNext());
        attributeResource.removeAnnotation(0, "javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides");
        this.getJpaProject().synchronizeContextModel();
        specifiedAttributeOverrides = attributeOverrideContainer.specifiedAttributeOverrides();
        EclipseLink2_0JavaElementCollectionMappingTests.assertFalse((boolean)specifiedAttributeOverrides.hasNext());
        specifiedMapKeyAttributeOverrides = mapKeyAttributeOverrideContainer.specifiedAttributeOverrides();
        EclipseLink2_0JavaElementCollectionMappingTests.assertFalse((boolean)specifiedMapKeyAttributeOverrides.hasNext());
    }

    public void testMapKeyValueVirtualAttributeOverrides() throws Exception {
        this.createTestEntityWithEmbeddableKeyAndValueElementCollectionMapping();
        this.createTestTargetEmbeddableAddress();
        this.createTestEmbeddableState();
        this.createTestEmbeddablePropertyInfo();
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef(FULLY_QUALIFIED_EMBEDDABLE_TYPE_NAME);
        this.addXmlClassRef("test.PropertyInfo");
        this.addXmlClassRef("test.State");
        ElementCollectionMapping2_0 elementCollectionMapping = (ElementCollectionMapping2_0)this.getJavaPersistentType().getAttributeNamed("parcels").getMapping();
        AttributeOverrideContainer attributeOverrideContainer = elementCollectionMapping.getValueAttributeOverrideContainer();
        AttributeOverrideContainer mapKeyAttributeOverrideContainer = elementCollectionMapping.getMapKeyAttributeOverrideContainer();
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"parcels", (String)attributeResource.getName());
        EclipseLink2_0JavaElementCollectionMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.AttributeOverride"));
        EclipseLink2_0JavaElementCollectionMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.AttributeOverrides"));
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((int)4, (int)mapKeyAttributeOverrideContainer.virtualAttributeOverridesSize());
        AttributeOverride defaultAttributeOverride = (AttributeOverride)mapKeyAttributeOverrideContainer.virtualAttributeOverrides().next();
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"city", (String)defaultAttributeOverride.getName());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"city", (String)defaultAttributeOverride.getColumn().getName());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"AnnotationTestType_parcels", (String)defaultAttributeOverride.getColumn().getTable());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals(null, (String)defaultAttributeOverride.getColumn().getColumnDefinition());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((boolean)true, (boolean)defaultAttributeOverride.getColumn().isInsertable());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((boolean)true, (boolean)defaultAttributeOverride.getColumn().isUpdatable());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((boolean)false, (boolean)defaultAttributeOverride.getColumn().isUnique());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((boolean)true, (boolean)defaultAttributeOverride.getColumn().isNullable());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((int)255, (int)defaultAttributeOverride.getColumn().getLength());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((int)0, (int)defaultAttributeOverride.getColumn().getPrecision());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((int)0, (int)defaultAttributeOverride.getColumn().getScale());
        ListIterator classRefs = this.getPersistenceUnit().specifiedClassRefs();
        classRefs.next();
        Embeddable addressEmbeddable = (Embeddable)((ClassRef)classRefs.next()).getJavaPersistentType().getMapping();
        BasicMapping cityMapping = (BasicMapping)addressEmbeddable.getPersistentType().getAttributeNamed("city").getMapping();
        cityMapping.getColumn().setSpecifiedName("FOO");
        cityMapping.getColumn().setSpecifiedTable("BAR");
        cityMapping.getColumn().setColumnDefinition("COLUMN_DEF");
        cityMapping.getColumn().setSpecifiedInsertable(Boolean.FALSE);
        cityMapping.getColumn().setSpecifiedUpdatable(Boolean.FALSE);
        cityMapping.getColumn().setSpecifiedUnique(Boolean.TRUE);
        cityMapping.getColumn().setSpecifiedNullable(Boolean.FALSE);
        cityMapping.getColumn().setSpecifiedLength(Integer.valueOf(5));
        cityMapping.getColumn().setSpecifiedPrecision(Integer.valueOf(6));
        cityMapping.getColumn().setSpecifiedScale(Integer.valueOf(7));
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"parcels", (String)attributeResource.getName());
        EclipseLink2_0JavaElementCollectionMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.AttributeOverride"));
        EclipseLink2_0JavaElementCollectionMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.AttributeOverrides"));
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((int)4, (int)mapKeyAttributeOverrideContainer.virtualAttributeOverridesSize());
        defaultAttributeOverride = (AttributeOverride)mapKeyAttributeOverrideContainer.virtualAttributeOverrides().next();
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"city", (String)defaultAttributeOverride.getName());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"FOO", (String)defaultAttributeOverride.getColumn().getName());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"BAR", (String)defaultAttributeOverride.getColumn().getTable());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"COLUMN_DEF", (String)defaultAttributeOverride.getColumn().getColumnDefinition());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((boolean)false, (boolean)defaultAttributeOverride.getColumn().isInsertable());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((boolean)false, (boolean)defaultAttributeOverride.getColumn().isUpdatable());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((boolean)true, (boolean)defaultAttributeOverride.getColumn().isUnique());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((boolean)false, (boolean)defaultAttributeOverride.getColumn().isNullable());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((int)5, (int)defaultAttributeOverride.getColumn().getLength());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((int)6, (int)defaultAttributeOverride.getColumn().getPrecision());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((int)7, (int)defaultAttributeOverride.getColumn().getScale());
        cityMapping.getColumn().setSpecifiedName(null);
        cityMapping.getColumn().setSpecifiedTable(null);
        cityMapping.getColumn().setColumnDefinition(null);
        cityMapping.getColumn().setSpecifiedInsertable(null);
        cityMapping.getColumn().setSpecifiedUpdatable(null);
        cityMapping.getColumn().setSpecifiedUnique(null);
        cityMapping.getColumn().setSpecifiedNullable(null);
        cityMapping.getColumn().setSpecifiedLength(null);
        cityMapping.getColumn().setSpecifiedPrecision(null);
        cityMapping.getColumn().setSpecifiedScale(null);
        defaultAttributeOverride = (AttributeOverride)mapKeyAttributeOverrideContainer.virtualAttributeOverrides().next();
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"city", (String)defaultAttributeOverride.getName());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"city", (String)defaultAttributeOverride.getColumn().getName());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"AnnotationTestType_parcels", (String)defaultAttributeOverride.getColumn().getTable());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals(null, (String)defaultAttributeOverride.getColumn().getColumnDefinition());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((boolean)true, (boolean)defaultAttributeOverride.getColumn().isInsertable());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((boolean)true, (boolean)defaultAttributeOverride.getColumn().isUpdatable());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((boolean)false, (boolean)defaultAttributeOverride.getColumn().isUnique());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((boolean)true, (boolean)defaultAttributeOverride.getColumn().isNullable());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((int)255, (int)defaultAttributeOverride.getColumn().getLength());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((int)0, (int)defaultAttributeOverride.getColumn().getPrecision());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((int)0, (int)defaultAttributeOverride.getColumn().getScale());
        AttributeOverrideAnnotation annotation = (AttributeOverrideAnnotation)attributeResource.addAnnotation(0, "javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides");
        annotation.setName("key.city");
        this.getJpaProject().synchronizeContextModel();
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((int)3, (int)mapKeyAttributeOverrideContainer.virtualAttributeOverridesSize());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((int)3, (int)attributeOverrideContainer.virtualAttributeOverridesSize());
        defaultAttributeOverride = (AttributeOverride)attributeOverrideContainer.virtualAttributeOverrides().next();
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"parcelNumber", (String)defaultAttributeOverride.getName());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"parcelNumber", (String)defaultAttributeOverride.getColumn().getName());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"AnnotationTestType_parcels", (String)defaultAttributeOverride.getColumn().getTable());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals(null, (String)defaultAttributeOverride.getColumn().getColumnDefinition());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((boolean)true, (boolean)defaultAttributeOverride.getColumn().isInsertable());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((boolean)true, (boolean)defaultAttributeOverride.getColumn().isUpdatable());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((boolean)false, (boolean)defaultAttributeOverride.getColumn().isUnique());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((boolean)true, (boolean)defaultAttributeOverride.getColumn().isNullable());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((int)255, (int)defaultAttributeOverride.getColumn().getLength());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((int)0, (int)defaultAttributeOverride.getColumn().getPrecision());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((int)0, (int)defaultAttributeOverride.getColumn().getScale());
        classRefs = this.getPersistenceUnit().specifiedClassRefs();
        classRefs.next();
        classRefs.next();
        Embeddable propertyInfoEmbeddable = (Embeddable)((ClassRef)classRefs.next()).getJavaPersistentType().getMapping();
        BasicMapping parcelNumberMapping = (BasicMapping)propertyInfoEmbeddable.getPersistentType().getAttributeNamed("parcelNumber").getMapping();
        parcelNumberMapping.getColumn().setSpecifiedName("FOO1");
        parcelNumberMapping.getColumn().setSpecifiedTable("BAR1");
        parcelNumberMapping.getColumn().setColumnDefinition("COLUMN_DEF1");
        parcelNumberMapping.getColumn().setSpecifiedInsertable(Boolean.FALSE);
        parcelNumberMapping.getColumn().setSpecifiedUpdatable(Boolean.FALSE);
        parcelNumberMapping.getColumn().setSpecifiedUnique(Boolean.TRUE);
        parcelNumberMapping.getColumn().setSpecifiedNullable(Boolean.FALSE);
        parcelNumberMapping.getColumn().setSpecifiedLength(Integer.valueOf(5));
        parcelNumberMapping.getColumn().setSpecifiedPrecision(Integer.valueOf(6));
        parcelNumberMapping.getColumn().setSpecifiedScale(Integer.valueOf(7));
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"parcels", (String)attributeResource.getName());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((int)3, (int)attributeOverrideContainer.virtualAttributeOverridesSize());
        defaultAttributeOverride = (AttributeOverride)attributeOverrideContainer.virtualAttributeOverrides().next();
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"parcelNumber", (String)defaultAttributeOverride.getName());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"FOO1", (String)defaultAttributeOverride.getColumn().getName());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"BAR1", (String)defaultAttributeOverride.getColumn().getTable());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"COLUMN_DEF1", (String)defaultAttributeOverride.getColumn().getColumnDefinition());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((boolean)false, (boolean)defaultAttributeOverride.getColumn().isInsertable());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((boolean)false, (boolean)defaultAttributeOverride.getColumn().isUpdatable());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((boolean)true, (boolean)defaultAttributeOverride.getColumn().isUnique());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((boolean)false, (boolean)defaultAttributeOverride.getColumn().isNullable());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((int)5, (int)defaultAttributeOverride.getColumn().getLength());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((int)6, (int)defaultAttributeOverride.getColumn().getPrecision());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((int)7, (int)defaultAttributeOverride.getColumn().getScale());
        parcelNumberMapping.getColumn().setSpecifiedName(null);
        parcelNumberMapping.getColumn().setSpecifiedTable(null);
        parcelNumberMapping.getColumn().setColumnDefinition(null);
        parcelNumberMapping.getColumn().setSpecifiedInsertable(null);
        parcelNumberMapping.getColumn().setSpecifiedUpdatable(null);
        parcelNumberMapping.getColumn().setSpecifiedUnique(null);
        parcelNumberMapping.getColumn().setSpecifiedNullable(null);
        parcelNumberMapping.getColumn().setSpecifiedLength(null);
        parcelNumberMapping.getColumn().setSpecifiedPrecision(null);
        parcelNumberMapping.getColumn().setSpecifiedScale(null);
        defaultAttributeOverride = (AttributeOverride)attributeOverrideContainer.virtualAttributeOverrides().next();
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"parcelNumber", (String)defaultAttributeOverride.getName());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"parcelNumber", (String)defaultAttributeOverride.getColumn().getName());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"AnnotationTestType_parcels", (String)defaultAttributeOverride.getColumn().getTable());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals(null, (String)defaultAttributeOverride.getColumn().getColumnDefinition());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((boolean)true, (boolean)defaultAttributeOverride.getColumn().isInsertable());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((boolean)true, (boolean)defaultAttributeOverride.getColumn().isUpdatable());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((boolean)false, (boolean)defaultAttributeOverride.getColumn().isUnique());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((boolean)true, (boolean)defaultAttributeOverride.getColumn().isNullable());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((int)255, (int)defaultAttributeOverride.getColumn().getLength());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((int)0, (int)defaultAttributeOverride.getColumn().getPrecision());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((int)0, (int)defaultAttributeOverride.getColumn().getScale());
        annotation = (AttributeOverrideAnnotation)attributeResource.addAnnotation(0, "javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides");
        annotation.setName("value.parcelNumber");
        this.getJpaProject().synchronizeContextModel();
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((int)2, (int)attributeOverrideContainer.virtualAttributeOverridesSize());
    }

    public void testMapKeyValueSpecifiedAttributeOverridesSize() throws Exception {
        this.createTestEntityWithEmbeddableKeyAndValueElementCollectionMapping();
        this.createTestTargetEmbeddableAddress();
        this.createTestEmbeddableState();
        this.createTestEmbeddablePropertyInfo();
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef(FULLY_QUALIFIED_EMBEDDABLE_TYPE_NAME);
        this.addXmlClassRef("test.PropertyInfo");
        this.addXmlClassRef("test.State");
        ElementCollectionMapping2_0 elementCollectionMapping = (ElementCollectionMapping2_0)this.getJavaPersistentType().getAttributeNamed("parcels").getMapping();
        AttributeOverrideContainer valueAttributeOverrideContainer = elementCollectionMapping.getValueAttributeOverrideContainer();
        AttributeOverrideContainer mapKeyAttributeOverrideContainer = elementCollectionMapping.getMapKeyAttributeOverrideContainer();
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((int)0, (int)valueAttributeOverrideContainer.specifiedAttributeOverridesSize());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((int)0, (int)mapKeyAttributeOverrideContainer.specifiedAttributeOverridesSize());
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        AttributeOverrideAnnotation attributeOverride = (AttributeOverrideAnnotation)attributeResource.addAnnotation(0, "javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides");
        attributeOverride.setName("FOO");
        attributeOverride = (AttributeOverrideAnnotation)attributeResource.addAnnotation(0, "javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides");
        attributeOverride.setName("key.BAR");
        attributeOverride = (AttributeOverrideAnnotation)attributeResource.addAnnotation(0, "javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides");
        attributeOverride.setName("value.FOO2");
        this.getJpaProject().synchronizeContextModel();
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((int)2, (int)valueAttributeOverrideContainer.specifiedAttributeOverridesSize());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((int)1, (int)mapKeyAttributeOverrideContainer.specifiedAttributeOverridesSize());
    }

    public void testMapKeyValueAttributeOverridesSize() throws Exception {
        this.createTestEntityWithEmbeddableKeyAndValueElementCollectionMapping();
        this.createTestTargetEmbeddableAddress();
        this.createTestEmbeddableState();
        this.createTestEmbeddablePropertyInfo();
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef(FULLY_QUALIFIED_EMBEDDABLE_TYPE_NAME);
        this.addXmlClassRef("test.PropertyInfo");
        this.addXmlClassRef("test.State");
        ElementCollectionMapping2_0 elementCollectionMapping = (ElementCollectionMapping2_0)this.getJavaPersistentType().getAttributeNamed("parcels").getMapping();
        AttributeOverrideContainer valueAttributeOverrideContainer = elementCollectionMapping.getValueAttributeOverrideContainer();
        AttributeOverrideContainer mapKeyAttributeOverrideContainer = elementCollectionMapping.getMapKeyAttributeOverrideContainer();
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((int)4, (int)mapKeyAttributeOverrideContainer.attributeOverridesSize());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((int)3, (int)valueAttributeOverrideContainer.attributeOverridesSize());
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        AttributeOverrideAnnotation attributeOverride = (AttributeOverrideAnnotation)attributeResource.addAnnotation(0, "javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides");
        attributeOverride.setName("FOO");
        attributeOverride = (AttributeOverrideAnnotation)attributeResource.addAnnotation(0, "javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides");
        attributeOverride.setName("key.BAR");
        attributeOverride = (AttributeOverrideAnnotation)attributeResource.addAnnotation(0, "javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides");
        attributeOverride.setName("value.FOO2");
        this.getJpaProject().synchronizeContextModel();
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((int)5, (int)mapKeyAttributeOverrideContainer.attributeOverridesSize());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((int)5, (int)valueAttributeOverrideContainer.attributeOverridesSize());
        attributeOverride = (AttributeOverrideAnnotation)attributeResource.addAnnotation(0, "javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides");
        attributeOverride.setName("city");
        this.getJpaProject().synchronizeContextModel();
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((int)5, (int)mapKeyAttributeOverrideContainer.attributeOverridesSize());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((int)6, (int)valueAttributeOverrideContainer.attributeOverridesSize());
    }

    public void testMapKeyValueVirtualAttributeOverridesSize() throws Exception {
        this.createTestEntityWithEmbeddableKeyAndValueElementCollectionMapping();
        this.createTestTargetEmbeddableAddress();
        this.createTestEmbeddableState();
        this.createTestEmbeddablePropertyInfo();
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef(FULLY_QUALIFIED_EMBEDDABLE_TYPE_NAME);
        this.addXmlClassRef("test.PropertyInfo");
        this.addXmlClassRef("test.State");
        ElementCollectionMapping2_0 elementCollectionMapping = (ElementCollectionMapping2_0)this.getJavaPersistentType().getAttributeNamed("parcels").getMapping();
        AttributeOverrideContainer valueAttributeOverrideContainer = elementCollectionMapping.getValueAttributeOverrideContainer();
        AttributeOverrideContainer mapKeyAttributeOverrideContainer = elementCollectionMapping.getMapKeyAttributeOverrideContainer();
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((int)4, (int)mapKeyAttributeOverrideContainer.virtualAttributeOverridesSize());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((int)3, (int)valueAttributeOverrideContainer.virtualAttributeOverridesSize());
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        AttributeOverrideAnnotation attributeOverride = (AttributeOverrideAnnotation)attributeResource.addAnnotation(0, "javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides");
        attributeOverride.setName("FOO");
        attributeOverride = (AttributeOverrideAnnotation)attributeResource.addAnnotation(0, "javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides");
        attributeOverride.setName("key.BAR");
        this.getJpaProject().synchronizeContextModel();
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((int)4, (int)mapKeyAttributeOverrideContainer.virtualAttributeOverridesSize());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((int)3, (int)valueAttributeOverrideContainer.virtualAttributeOverridesSize());
        attributeOverride = (AttributeOverrideAnnotation)attributeResource.addAnnotation(0, "javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides");
        attributeOverride.setName("key.city");
        attributeOverride = (AttributeOverrideAnnotation)attributeResource.addAnnotation(0, "javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides");
        attributeOverride.setName("value.parcelNumber");
        this.getJpaProject().synchronizeContextModel();
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((int)3, (int)mapKeyAttributeOverrideContainer.virtualAttributeOverridesSize());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((int)2, (int)valueAttributeOverrideContainer.virtualAttributeOverridesSize());
        attributeOverride = (AttributeOverrideAnnotation)attributeResource.addAnnotation(0, "javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides");
        attributeOverride.setName("key.state.name");
        attributeOverride = (AttributeOverrideAnnotation)attributeResource.addAnnotation(0, "javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides");
        attributeOverride.setName("size");
        this.getJpaProject().synchronizeContextModel();
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((int)2, (int)mapKeyAttributeOverrideContainer.virtualAttributeOverridesSize());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((int)1, (int)valueAttributeOverrideContainer.virtualAttributeOverridesSize());
    }

    public void testMapKeyValueAttributeOverrideSetVirtual() throws Exception {
        this.createTestEntityWithEmbeddableKeyAndValueElementCollectionMapping();
        this.createTestTargetEmbeddableAddress();
        this.createTestEmbeddableState();
        this.createTestEmbeddablePropertyInfo();
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef(FULLY_QUALIFIED_EMBEDDABLE_TYPE_NAME);
        this.addXmlClassRef("test.PropertyInfo");
        this.addXmlClassRef("test.State");
        ElementCollectionMapping2_0 elementCollectionMapping = (ElementCollectionMapping2_0)this.getJavaPersistentType().getAttributeNamed("parcels").getMapping();
        AttributeOverrideContainer valueAttributeOverrideContainer = elementCollectionMapping.getValueAttributeOverrideContainer();
        AttributeOverrideContainer mapKeyAttributeOverrideContainer = elementCollectionMapping.getMapKeyAttributeOverrideContainer();
        ((AttributeOverride)valueAttributeOverrideContainer.virtualAttributeOverrides().next()).setVirtual(false);
        ((AttributeOverride)mapKeyAttributeOverrideContainer.virtualAttributeOverrides().next()).setVirtual(false);
        ((AttributeOverride)valueAttributeOverrideContainer.virtualAttributeOverrides().next()).setVirtual(false);
        ((AttributeOverride)mapKeyAttributeOverrideContainer.virtualAttributeOverrides().next()).setVirtual(false);
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        Iterator attributeOverrides = attributeResource.annotations("javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides");
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"key.city", (String)((AttributeOverrideAnnotation)attributeOverrides.next()).getName());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"key.state.name", (String)((AttributeOverrideAnnotation)attributeOverrides.next()).getName());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"value.parcelNumber", (String)((AttributeOverrideAnnotation)attributeOverrides.next()).getName());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"value.size", (String)((AttributeOverrideAnnotation)attributeOverrides.next()).getName());
        EclipseLink2_0JavaElementCollectionMappingTests.assertFalse((boolean)attributeOverrides.hasNext());
        ((AttributeOverride)valueAttributeOverrideContainer.specifiedAttributeOverrides().next()).setVirtual(true);
        ((AttributeOverride)mapKeyAttributeOverrideContainer.specifiedAttributeOverrides().next()).setVirtual(true);
        attributeOverrides = attributeResource.annotations("javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides");
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"key.state.name", (String)((AttributeOverrideAnnotation)attributeOverrides.next()).getName());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"value.size", (String)((AttributeOverrideAnnotation)attributeOverrides.next()).getName());
        EclipseLink2_0JavaElementCollectionMappingTests.assertFalse((boolean)attributeOverrides.hasNext());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"tax", (String)((AttributeOverride)valueAttributeOverrideContainer.virtualAttributeOverrides().next()).getName());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((int)2, (int)valueAttributeOverrideContainer.virtualAttributeOverridesSize());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"state.abbr", (String)((AttributeOverride)mapKeyAttributeOverrideContainer.virtualAttributeOverrides().next()).getName());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((int)3, (int)mapKeyAttributeOverrideContainer.virtualAttributeOverridesSize());
        ((AttributeOverride)valueAttributeOverrideContainer.specifiedAttributeOverrides().next()).setVirtual(true);
        ((AttributeOverride)mapKeyAttributeOverrideContainer.specifiedAttributeOverrides().next()).setVirtual(true);
        attributeOverrides = attributeResource.annotations("javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides");
        EclipseLink2_0JavaElementCollectionMappingTests.assertFalse((boolean)attributeOverrides.hasNext());
        ListIterator virtualAttributeOverrides = valueAttributeOverrideContainer.virtualAttributeOverrides();
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"tax", (String)((AttributeOverride)virtualAttributeOverrides.next()).getName());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"parcelNumber", (String)((AttributeOverride)virtualAttributeOverrides.next()).getName());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"size", (String)((AttributeOverride)virtualAttributeOverrides.next()).getName());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((int)3, (int)valueAttributeOverrideContainer.virtualAttributeOverridesSize());
        virtualAttributeOverrides = mapKeyAttributeOverrideContainer.virtualAttributeOverrides();
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"state.abbr", (String)((AttributeOverride)virtualAttributeOverrides.next()).getName());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"zip", (String)((AttributeOverride)virtualAttributeOverrides.next()).getName());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"city", (String)((AttributeOverride)virtualAttributeOverrides.next()).getName());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"state.name", (String)((AttributeOverride)virtualAttributeOverrides.next()).getName());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((int)4, (int)mapKeyAttributeOverrideContainer.virtualAttributeOverridesSize());
    }

    public void testMapKeyValueMoveSpecifiedAttributeOverride() throws Exception {
        this.createTestEntityWithEmbeddableKeyAndValueElementCollectionMapping();
        this.createTestTargetEmbeddableAddress();
        this.createTestEmbeddableState();
        this.createTestEmbeddablePropertyInfo();
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef(FULLY_QUALIFIED_EMBEDDABLE_TYPE_NAME);
        this.addXmlClassRef("test.PropertyInfo");
        this.addXmlClassRef("test.State");
        ElementCollectionMapping2_0 elementCollectionMapping = (ElementCollectionMapping2_0)this.getJavaPersistentType().getAttributeNamed("parcels").getMapping();
        AttributeOverrideContainer valueAttributeOverrideContainer = elementCollectionMapping.getValueAttributeOverrideContainer();
        AttributeOverrideContainer mapKeyAttributeOverrideContainer = elementCollectionMapping.getMapKeyAttributeOverrideContainer();
        ((AttributeOverride)valueAttributeOverrideContainer.virtualAttributeOverrides().next()).setVirtual(false);
        ((AttributeOverride)valueAttributeOverrideContainer.virtualAttributeOverrides().next()).setVirtual(false);
        ((AttributeOverride)mapKeyAttributeOverrideContainer.virtualAttributeOverrides().next()).setVirtual(false);
        ((AttributeOverride)mapKeyAttributeOverrideContainer.virtualAttributeOverrides().next()).setVirtual(false);
        ListIterator specifiedOverrides = valueAttributeOverrideContainer.specifiedAttributeOverrides();
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"parcelNumber", (String)((AttributeOverride)specifiedOverrides.next()).getName());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"size", (String)((AttributeOverride)specifiedOverrides.next()).getName());
        EclipseLink2_0JavaElementCollectionMappingTests.assertFalse((boolean)specifiedOverrides.hasNext());
        specifiedOverrides = mapKeyAttributeOverrideContainer.specifiedAttributeOverrides();
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"city", (String)((AttributeOverride)specifiedOverrides.next()).getName());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"state.name", (String)((AttributeOverride)specifiedOverrides.next()).getName());
        EclipseLink2_0JavaElementCollectionMappingTests.assertFalse((boolean)specifiedOverrides.hasNext());
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        attributeResource.moveAnnotation(1, 0, "javax.persistence.AttributeOverrides");
        Iterator attributeOverrides = attributeResource.annotations("javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides");
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"key.state.name", (String)((AttributeOverrideAnnotation)attributeOverrides.next()).getName());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"key.city", (String)((AttributeOverrideAnnotation)attributeOverrides.next()).getName());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"value.parcelNumber", (String)((AttributeOverrideAnnotation)attributeOverrides.next()).getName());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"value.size", (String)((AttributeOverrideAnnotation)attributeOverrides.next()).getName());
        EclipseLink2_0JavaElementCollectionMappingTests.assertFalse((boolean)attributeOverrides.hasNext());
        specifiedOverrides = valueAttributeOverrideContainer.specifiedAttributeOverrides();
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"parcelNumber", (String)((AttributeOverride)specifiedOverrides.next()).getName());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"size", (String)((AttributeOverride)specifiedOverrides.next()).getName());
        EclipseLink2_0JavaElementCollectionMappingTests.assertFalse((boolean)specifiedOverrides.hasNext());
        specifiedOverrides = mapKeyAttributeOverrideContainer.specifiedAttributeOverrides();
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"state.name", (String)((AttributeOverride)specifiedOverrides.next()).getName());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"city", (String)((AttributeOverride)specifiedOverrides.next()).getName());
        EclipseLink2_0JavaElementCollectionMappingTests.assertFalse((boolean)specifiedOverrides.hasNext());
        attributeResource.moveAnnotation(3, 2, "javax.persistence.AttributeOverrides");
        attributeOverrides = attributeResource.annotations("javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides");
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"key.state.name", (String)((AttributeOverrideAnnotation)attributeOverrides.next()).getName());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"key.city", (String)((AttributeOverrideAnnotation)attributeOverrides.next()).getName());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"value.size", (String)((AttributeOverrideAnnotation)attributeOverrides.next()).getName());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"value.parcelNumber", (String)((AttributeOverrideAnnotation)attributeOverrides.next()).getName());
        EclipseLink2_0JavaElementCollectionMappingTests.assertFalse((boolean)attributeOverrides.hasNext());
        specifiedOverrides = valueAttributeOverrideContainer.specifiedAttributeOverrides();
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"size", (String)((AttributeOverride)specifiedOverrides.next()).getName());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"parcelNumber", (String)((AttributeOverride)specifiedOverrides.next()).getName());
        EclipseLink2_0JavaElementCollectionMappingTests.assertFalse((boolean)specifiedOverrides.hasNext());
        specifiedOverrides = mapKeyAttributeOverrideContainer.specifiedAttributeOverrides();
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"state.name", (String)((AttributeOverride)specifiedOverrides.next()).getName());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"city", (String)((AttributeOverride)specifiedOverrides.next()).getName());
        EclipseLink2_0JavaElementCollectionMappingTests.assertFalse((boolean)specifiedOverrides.hasNext());
    }

    public void testSelfReferentialElementCollection() throws Exception {
        this.createSelfReferentialElementCollection();
        this.addXmlClassRef("test.Foo");
        JavaElementCollectionMapping2_0 elementCollectionMapping = (JavaElementCollectionMapping2_0)this.getJavaPersistentType().getAttributeNamed("elementCollection").getMapping();
        EclipseLink2_0JavaElementCollectionMappingTests.assertFalse((boolean)elementCollectionMapping.allOverrideableAttributeMappingNames().hasNext());
    }
}

