/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.tests.internal.context.java;

import java.util.Iterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.core.context.AttributeOverride;
import org.eclipse.jpt.core.context.AttributeOverrideContainer;
import org.eclipse.jpt.core.context.BasicMapping;
import org.eclipse.jpt.core.context.Column;
import org.eclipse.jpt.core.context.java.JavaAttributeOverrideContainer;
import org.eclipse.jpt.core.context.java.JavaEntity;
import org.eclipse.jpt.core.context.java.JavaPersistentType;
import org.eclipse.jpt.core.context.persistence.ClassRef;
import org.eclipse.jpt.core.resource.java.AttributeOverrideAnnotation;
import org.eclipse.jpt.core.resource.java.ColumnAnnotation;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentType;
import org.eclipse.jpt.core.tests.internal.context.ContextModelTestCase;
import org.eclipse.jpt.core.tests.internal.projects.TestJavaProject;
import org.eclipse.jpt.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.jpt.utility.internal.iterators.ArrayIterator;

public class JavaAttributeOverrideTests
extends ContextModelTestCase {
    private static final String ATTRIBUTE_OVERRIDE_NAME = "MY_ATTRIBUTE_OVERRIDE_NAME";
    private static final String ATTRIBUTE_OVERRIDE_COLUMN_NAME = "MY_ATTRIBUTE_OVERRIDE_COLUMN_NAME";

    private ICompilationUnit createTestMappedSuperclass() throws Exception {
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.MappedSuperclass"});
            }

            @Override
            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@MappedSuperclass");
            }
        });
    }

    private ICompilationUnit createTestEntityWithAttributeOverride() throws Exception {
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.AttributeOverride", "javax.persistence.Column"});
            }

            @Override
            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
                sb.append("@AttributeOverride(name=\"MY_ATTRIBUTE_OVERRIDE_NAME\", column=@Column(name=\"MY_ATTRIBUTE_OVERRIDE_COLUMN_NAME\"))");
            }
        });
    }

    private void createTestSubType() throws Exception {
        TestJavaProject.SourceWriter sourceWriter = new TestJavaProject.SourceWriter(){

            public void appendSourceTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Entity");
                sb.append(";");
                sb.append(CR);
                sb.append("@Entity");
                sb.append(CR);
                sb.append("public class ").append("AnnotationTestTypeChild").append(" ");
                sb.append("extends AnnotationTestType ");
                sb.append("{}").append(CR);
            }
        };
        this.javaProject.createCompilationUnit("test", "AnnotationTestTypeChild.java", sourceWriter);
    }

    public JavaAttributeOverrideTests(String name) {
        super(name);
    }

    public void testGetName() throws Exception {
        this.createTestEntityWithAttributeOverride();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaAttributeOverrideContainer overrideContainer = this.getJavaEntity().getAttributeOverrideContainer();
        AttributeOverride specifiedAttributeOverride = (AttributeOverride)overrideContainer.specifiedAttributeOverrides().next();
        JavaAttributeOverrideTests.assertEquals((String)ATTRIBUTE_OVERRIDE_NAME, (String)specifiedAttributeOverride.getName());
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        AttributeOverrideAnnotation attributeOverrideResource = (AttributeOverrideAnnotation)typeResource.getAnnotation("javax.persistence.AttributeOverride");
        attributeOverrideResource.setName("FOO");
        this.getJpaProject().synchronizeContextModel();
        specifiedAttributeOverride = (AttributeOverride)overrideContainer.specifiedAttributeOverrides().next();
        JavaAttributeOverrideTests.assertEquals((String)"FOO", (String)specifiedAttributeOverride.getName());
    }

    public void testSetName() throws Exception {
        this.createTestEntityWithAttributeOverride();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaAttributeOverrideContainer overrideContainer = this.getJavaEntity().getAttributeOverrideContainer();
        AttributeOverride specifiedAttributeOverride = (AttributeOverride)overrideContainer.specifiedAttributeOverrides().next();
        JavaAttributeOverrideTests.assertEquals((String)ATTRIBUTE_OVERRIDE_NAME, (String)specifiedAttributeOverride.getName());
        specifiedAttributeOverride.setName("FOO");
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        AttributeOverrideAnnotation attributeOverrideResource = (AttributeOverrideAnnotation)typeResource.getAnnotation("javax.persistence.AttributeOverride");
        JavaAttributeOverrideTests.assertEquals((String)"FOO", (String)attributeOverrideResource.getName());
    }

    public void testColumnGetName() throws Exception {
        this.createTestEntityWithAttributeOverride();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaAttributeOverrideContainer overrideContainer = this.getJavaEntity().getAttributeOverrideContainer();
        AttributeOverride specifiedAttributeOverride = (AttributeOverride)overrideContainer.specifiedAttributeOverrides().next();
        Column column = specifiedAttributeOverride.getColumn();
        JavaAttributeOverrideTests.assertEquals((String)ATTRIBUTE_OVERRIDE_COLUMN_NAME, (String)column.getName());
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        AttributeOverrideAnnotation attributeOverrideResource = (AttributeOverrideAnnotation)typeResource.getAnnotation("javax.persistence.AttributeOverride");
        ColumnAnnotation columnResource = attributeOverrideResource.getColumn();
        columnResource.setName("FOO");
        this.getJpaProject().synchronizeContextModel();
        column = ((AttributeOverride)overrideContainer.specifiedAttributeOverrides().next()).getColumn();
        JavaAttributeOverrideTests.assertEquals((String)"FOO", (String)column.getName());
    }

    public void testColumnSetName() throws Exception {
        this.createTestEntityWithAttributeOverride();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaAttributeOverrideContainer overrideContainer = this.getJavaEntity().getAttributeOverrideContainer();
        AttributeOverride specifiedAttributeOverride = (AttributeOverride)overrideContainer.specifiedAttributeOverrides().next();
        Column column = specifiedAttributeOverride.getColumn();
        JavaAttributeOverrideTests.assertEquals((String)ATTRIBUTE_OVERRIDE_COLUMN_NAME, (String)column.getName());
        column.setSpecifiedName("FOO");
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        AttributeOverrideAnnotation attributeOverrideResource = (AttributeOverrideAnnotation)typeResource.getAnnotation("javax.persistence.AttributeOverride");
        ColumnAnnotation columnResource = attributeOverrideResource.getColumn();
        JavaAttributeOverrideTests.assertEquals((String)"FOO", (String)columnResource.getName());
        column.setSpecifiedName(null);
        attributeOverrideResource = (AttributeOverrideAnnotation)typeResource.getAnnotation("javax.persistence.AttributeOverride");
        JavaAttributeOverrideTests.assertNull((Object)attributeOverrideResource.getColumn());
        JavaAttributeOverrideTests.assertNotNull((Object)specifiedAttributeOverride.getColumn());
    }

    public void testColumnDefaultName() throws Exception {
        this.createTestMappedSuperclass();
        this.createTestSubType();
        this.addXmlClassRef("test.AnnotationTestTypeChild");
        this.addXmlClassRef("test.AnnotationTestType");
        JavaEntity entity = this.getJavaEntity();
        AttributeOverrideContainer overrideContainer = entity.getAttributeOverrideContainer();
        JavaAttributeOverrideTests.assertEquals((String)"AnnotationTestTypeChild", (String)entity.getName());
        JavaAttributeOverrideTests.assertEquals((int)2, (int)overrideContainer.virtualAttributeOverridesSize());
        AttributeOverride attributeOverride = (AttributeOverride)overrideContainer.virtualAttributeOverrides().next();
        JavaAttributeOverrideTests.assertEquals((String)"id", (String)attributeOverride.getColumn().getDefaultName());
        JavaPersistentType mappedSuperclass = ((ClassRef)CollectionTools.list((Iterator)this.getPersistenceUnit().specifiedClassRefs()).get(1)).getJavaPersistentType();
        BasicMapping basicMapping = (BasicMapping)mappedSuperclass.getAttributeNamed("id").getMapping();
        basicMapping.getColumn().setSpecifiedName("FOO");
        attributeOverride = (AttributeOverride)overrideContainer.virtualAttributeOverrides().next();
        JavaAttributeOverrideTests.assertEquals((String)"FOO", (String)attributeOverride.getColumn().getDefaultName());
    }

    public void testColumnDefaultTableName() throws Exception {
        this.createTestMappedSuperclass();
        this.createTestSubType();
        this.addXmlClassRef("test.AnnotationTestTypeChild");
        this.addXmlClassRef("test.AnnotationTestType");
        JavaEntity entity = this.getJavaEntity();
        AttributeOverrideContainer overrideContainer = entity.getAttributeOverrideContainer();
        JavaAttributeOverrideTests.assertEquals((String)"AnnotationTestTypeChild", (String)entity.getName());
        JavaAttributeOverrideTests.assertEquals((int)2, (int)overrideContainer.virtualAttributeOverridesSize());
        AttributeOverride attributeOverride = (AttributeOverride)overrideContainer.virtualAttributeOverrides().next();
        JavaAttributeOverrideTests.assertEquals((String)"AnnotationTestTypeChild", (String)attributeOverride.getColumn().getDefaultTable());
        JavaPersistentType mappedSuperclass = ((ClassRef)CollectionTools.list((Iterator)this.getPersistenceUnit().specifiedClassRefs()).get(1)).getJavaPersistentType();
        BasicMapping basicMapping = (BasicMapping)mappedSuperclass.getAttributeNamed("id").getMapping();
        basicMapping.getColumn().setSpecifiedTable("BAR");
        attributeOverride = (AttributeOverride)overrideContainer.virtualAttributeOverrides().next();
        JavaAttributeOverrideTests.assertEquals((String)"BAR", (String)attributeOverride.getColumn().getDefaultTable());
    }

    public void testDefaultName() throws Exception {
        this.createTestMappedSuperclass();
        this.createTestSubType();
        this.addXmlClassRef("test.AnnotationTestTypeChild");
        this.addXmlClassRef("test.AnnotationTestType");
        JavaEntity entity = this.getJavaEntity();
        AttributeOverrideContainer overrideContainer = entity.getAttributeOverrideContainer();
        JavaAttributeOverrideTests.assertEquals((String)"AnnotationTestTypeChild", (String)entity.getName());
        JavaAttributeOverrideTests.assertEquals((int)2, (int)overrideContainer.virtualAttributeOverridesSize());
        AttributeOverride attributeOverride = (AttributeOverride)overrideContainer.virtualAttributeOverrides().next();
        JavaAttributeOverrideTests.assertEquals((String)"id", (String)attributeOverride.getName());
    }

    public void testIsVirtual() throws Exception {
        this.createTestMappedSuperclass();
        this.createTestSubType();
        this.addXmlClassRef("test.AnnotationTestTypeChild");
        this.addXmlClassRef("test.AnnotationTestType");
        JavaEntity entity = this.getJavaEntity();
        AttributeOverrideContainer overrideContainer = entity.getAttributeOverrideContainer();
        JavaAttributeOverrideTests.assertEquals((String)"AnnotationTestTypeChild", (String)entity.getName());
        JavaAttributeOverrideTests.assertEquals((int)2, (int)overrideContainer.virtualAttributeOverridesSize());
        AttributeOverride attributeOverride = (AttributeOverride)overrideContainer.virtualAttributeOverrides().next();
        JavaAttributeOverrideTests.assertTrue((boolean)attributeOverride.isVirtual());
    }

    public void testSetColumn() throws Exception {
        this.createTestMappedSuperclass();
        this.createTestSubType();
        this.addXmlClassRef("test.AnnotationTestTypeChild");
        this.addXmlClassRef("test.AnnotationTestType");
        JavaAttributeOverrideContainer overrideContainer = this.getJavaEntity().getAttributeOverrideContainer();
        AttributeOverride attributeOverride = (AttributeOverride)overrideContainer.virtualAttributeOverrides().next();
        attributeOverride = attributeOverride.setVirtual(false);
        attributeOverride.getColumn().setSpecifiedName("FOO");
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestTypeChild");
        AttributeOverrideAnnotation attributeOverrideResource = (AttributeOverrideAnnotation)typeResource.getAnnotation("javax.persistence.AttributeOverride");
        JavaAttributeOverrideTests.assertEquals((String)"FOO", (String)attributeOverrideResource.getColumn().getName());
        JavaAttributeOverrideTests.assertEquals((String)"FOO", (String)((AttributeOverride)overrideContainer.specifiedAttributeOverrides().next()).getColumn().getSpecifiedName());
    }
}

