/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.tests.internal.context.java;

import java.util.Iterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.core.MappingKeys;
import org.eclipse.jpt.core.context.Embeddable;
import org.eclipse.jpt.core.context.Entity;
import org.eclipse.jpt.core.context.IdClassReference;
import org.eclipse.jpt.core.context.MappedSuperclass;
import org.eclipse.jpt.core.internal.context.java.JavaNullTypeMapping;
import org.eclipse.jpt.core.resource.java.IdClassAnnotation;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentType;
import org.eclipse.jpt.core.tests.internal.context.ContextModelTestCase;
import org.eclipse.jpt.core.tests.internal.projects.TestJavaProject;
import org.eclipse.jpt.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.utility.internal.iterators.ArrayIterator;

public class JavaMappedSuperclassTests
extends ContextModelTestCase {
    public JavaMappedSuperclassTests(String name) {
        super(name);
    }

    private ICompilationUnit createTestMappedSuperclass() throws Exception {
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.MappedSuperclass"});
            }

            @Override
            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@MappedSuperclass");
            }
        });
    }

    private void createTestIdClass() throws Exception {
        TestJavaProject.SourceWriter sourceWriter = new TestJavaProject.SourceWriter(){

            public void appendSourceTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("public class ").append("TestTypeId").append(" ");
                sb.append("{}").append(CR);
            }
        };
        this.javaProject.createCompilationUnit("test", "TestTypeId.java", sourceWriter);
    }

    public void testMorphToEntity() throws Exception {
        this.createTestMappedSuperclass();
        this.addXmlClassRef("test.AnnotationTestType");
        MappedSuperclass mappedSuperclass = (MappedSuperclass)this.getJavaPersistentType().getMapping();
        mappedSuperclass.getIdClassReference().setSpecifiedIdClassName("myIdClass");
        this.getJavaPersistentType().setMappingKey("entity");
        JavaMappedSuperclassTests.assertTrue((boolean)(this.getJavaPersistentType().getMapping() instanceof Entity));
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaMappedSuperclassTests.assertNull((Object)typeResource.getAnnotation("javax.persistence.MappedSuperclass"));
        JavaMappedSuperclassTests.assertNotNull((Object)typeResource.getAnnotation("javax.persistence.IdClass"));
    }

    public void testMorphToEmbeddable() throws Exception {
        this.createTestMappedSuperclass();
        this.addXmlClassRef("test.AnnotationTestType");
        MappedSuperclass mappedSuperclass = (MappedSuperclass)this.getJavaPersistentType().getMapping();
        mappedSuperclass.getIdClassReference().setSpecifiedIdClassName("myIdClass");
        this.getJavaPersistentType().setMappingKey("embeddable");
        JavaMappedSuperclassTests.assertTrue((boolean)(this.getJavaPersistentType().getMapping() instanceof Embeddable));
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaMappedSuperclassTests.assertNull((Object)typeResource.getAnnotation("javax.persistence.MappedSuperclass"));
        JavaMappedSuperclassTests.assertNull((Object)typeResource.getAnnotation("javax.persistence.IdClass"));
    }

    public void testMorphToNull() throws Exception {
        this.createTestMappedSuperclass();
        this.addXmlClassRef("test.AnnotationTestType");
        MappedSuperclass mappedSuperclass = (MappedSuperclass)this.getJavaPersistentType().getMapping();
        mappedSuperclass.getIdClassReference().setSpecifiedIdClassName("myIdClass");
        this.getJavaPersistentType().setMappingKey(MappingKeys.NULL_TYPE_MAPPING_KEY);
        JavaMappedSuperclassTests.assertTrue((boolean)(this.getJavaPersistentType().getMapping() instanceof JavaNullTypeMapping));
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaMappedSuperclassTests.assertNull((Object)typeResource.getAnnotation("javax.persistence.MappedSuperclass"));
        JavaMappedSuperclassTests.assertNull((Object)typeResource.getAnnotation("javax.persistence.IdClass"));
    }

    public void testMappedSuperclass() throws Exception {
        this.createTestMappedSuperclass();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaMappedSuperclassTests.assertTrue((boolean)(this.getJavaPersistentType().getMapping() instanceof MappedSuperclass));
    }

    public void testOverridableAttributeNames() throws Exception {
        this.createTestMappedSuperclass();
        this.addXmlClassRef("test.AnnotationTestType");
        MappedSuperclass mappedSuperclass = (MappedSuperclass)this.getJavaPersistentType().getMapping();
        Iterator overridableAttributeNames = mappedSuperclass.overridableAttributeNames();
        JavaMappedSuperclassTests.assertEquals((String)"id", (String)((String)overridableAttributeNames.next()));
        JavaMappedSuperclassTests.assertEquals((String)"name", (String)((String)overridableAttributeNames.next()));
        JavaMappedSuperclassTests.assertFalse((boolean)overridableAttributeNames.hasNext());
    }

    public void testOverridableAssociationNames() throws Exception {
        this.createTestMappedSuperclass();
        this.addXmlClassRef("test.AnnotationTestType");
        MappedSuperclass mappedSuperclass = (MappedSuperclass)this.getJavaPersistentType().getMapping();
        Iterator overridableAssociationNames = mappedSuperclass.overridableAssociationNames();
        JavaMappedSuperclassTests.assertFalse((boolean)overridableAssociationNames.hasNext());
    }

    public void testTableNameIsInvalid() throws Exception {
        this.createTestMappedSuperclass();
        this.addXmlClassRef("test.AnnotationTestType");
        MappedSuperclass mappedSuperclass = (MappedSuperclass)this.getJavaPersistentType().getMapping();
        JavaMappedSuperclassTests.assertFalse((boolean)mappedSuperclass.tableNameIsInvalid("test.AnnotationTestType"));
        JavaMappedSuperclassTests.assertFalse((boolean)mappedSuperclass.tableNameIsInvalid("FOO"));
    }

    public void testAssociatedTables() throws Exception {
        this.createTestMappedSuperclass();
        this.addXmlClassRef("test.AnnotationTestType");
        MappedSuperclass mappedSuperclass = (MappedSuperclass)this.getJavaPersistentType().getMapping();
        JavaMappedSuperclassTests.assertFalse((boolean)mappedSuperclass.associatedTables().hasNext());
    }

    public void testAssociatedTablesIncludingInherited() throws Exception {
        this.createTestMappedSuperclass();
        this.addXmlClassRef("test.AnnotationTestType");
        MappedSuperclass mappedSuperclass = (MappedSuperclass)this.getJavaPersistentType().getMapping();
        JavaMappedSuperclassTests.assertFalse((boolean)mappedSuperclass.associatedTablesIncludingInherited().hasNext());
    }

    public void testAssociatedTableNamesIncludingInherited() throws Exception {
        this.createTestMappedSuperclass();
        this.addXmlClassRef("test.AnnotationTestType");
        MappedSuperclass mappedSuperclass = (MappedSuperclass)this.getJavaPersistentType().getMapping();
        JavaMappedSuperclassTests.assertFalse((boolean)mappedSuperclass.associatedTableNamesIncludingInherited().hasNext());
    }

    public void testAllOverridableAttributeNames() throws Exception {
        this.createTestMappedSuperclass();
        this.addXmlClassRef("test.AnnotationTestType");
        MappedSuperclass mappedSuperclass = (MappedSuperclass)this.getJavaPersistentType().getMapping();
        Iterator overridableAttributeNames = mappedSuperclass.overridableAttributeNames();
        JavaMappedSuperclassTests.assertEquals((String)"id", (String)((String)overridableAttributeNames.next()));
        JavaMappedSuperclassTests.assertEquals((String)"name", (String)((String)overridableAttributeNames.next()));
        JavaMappedSuperclassTests.assertFalse((boolean)overridableAttributeNames.hasNext());
    }

    public void testAllOverridableAssociationNames() throws Exception {
        this.createTestMappedSuperclass();
        this.addXmlClassRef("test.AnnotationTestType");
        MappedSuperclass mappedSuperclass = (MappedSuperclass)this.getJavaPersistentType().getMapping();
        Iterator overridableAssociationNames = mappedSuperclass.overridableAssociationNames();
        JavaMappedSuperclassTests.assertFalse((boolean)overridableAssociationNames.hasNext());
    }

    public void testAttributeMappingKeyAllowed() throws Exception {
        this.createTestMappedSuperclass();
        this.addXmlClassRef("test.AnnotationTestType");
        MappedSuperclass mappedSuperclass = (MappedSuperclass)this.getJavaPersistentType().getMapping();
        JavaMappedSuperclassTests.assertTrue((boolean)mappedSuperclass.attributeMappingKeyAllowed("basic"));
        JavaMappedSuperclassTests.assertTrue((boolean)mappedSuperclass.attributeMappingKeyAllowed("id"));
        JavaMappedSuperclassTests.assertTrue((boolean)mappedSuperclass.attributeMappingKeyAllowed("embedded"));
        JavaMappedSuperclassTests.assertTrue((boolean)mappedSuperclass.attributeMappingKeyAllowed("embeddedId"));
        JavaMappedSuperclassTests.assertTrue((boolean)mappedSuperclass.attributeMappingKeyAllowed("version"));
        JavaMappedSuperclassTests.assertTrue((boolean)mappedSuperclass.attributeMappingKeyAllowed("transient"));
        JavaMappedSuperclassTests.assertTrue((boolean)mappedSuperclass.attributeMappingKeyAllowed("oneToOne"));
        JavaMappedSuperclassTests.assertTrue((boolean)mappedSuperclass.attributeMappingKeyAllowed("manyToOne"));
        JavaMappedSuperclassTests.assertTrue((boolean)mappedSuperclass.attributeMappingKeyAllowed("oneToMany"));
        JavaMappedSuperclassTests.assertTrue((boolean)mappedSuperclass.attributeMappingKeyAllowed("manyToMany"));
    }

    public void testUpdateIdClass() throws Exception {
        this.createTestMappedSuperclass();
        this.createTestIdClass();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        MappedSuperclass mappedSuperclass = (MappedSuperclass)this.getJavaPersistentType().getMapping();
        IdClassReference idClassRef = mappedSuperclass.getIdClassReference();
        JavaMappedSuperclassTests.assertNull((Object)typeResource.getAnnotation("javax.persistence.IdClass"));
        JavaMappedSuperclassTests.assertNull((Object)idClassRef.getSpecifiedIdClassName());
        JavaMappedSuperclassTests.assertNull((Object)idClassRef.getIdClass());
        IdClassAnnotation idClass = (IdClassAnnotation)typeResource.addAnnotation("javax.persistence.IdClass");
        JavaMappedSuperclassTests.assertNotNull((Object)typeResource.getAnnotation("javax.persistence.IdClass"));
        JavaMappedSuperclassTests.assertNull((Object)idClassRef.getSpecifiedIdClassName());
        JavaMappedSuperclassTests.assertNull((Object)idClassRef.getIdClass());
        String nonExistentIdClassName = "test.Foo";
        idClass.setValue(nonExistentIdClassName);
        JavaMappedSuperclassTests.assertEquals((String)nonExistentIdClassName, (String)((IdClassAnnotation)typeResource.getAnnotation("javax.persistence.IdClass")).getValue());
        JavaMappedSuperclassTests.assertEquals((String)nonExistentIdClassName, (String)idClassRef.getSpecifiedIdClassName());
        JavaMappedSuperclassTests.assertNull((Object)idClassRef.getIdClass());
        String existentIdClassName = "test.TestTypeId";
        idClass.setValue(existentIdClassName);
        JavaMappedSuperclassTests.assertEquals((String)existentIdClassName, (String)((IdClassAnnotation)typeResource.getAnnotation("javax.persistence.IdClass")).getValue());
        JavaMappedSuperclassTests.assertEquals((String)existentIdClassName, (String)idClassRef.getSpecifiedIdClassName());
        JavaMappedSuperclassTests.assertNotNull((Object)idClassRef.getIdClass());
        idClass.setValue(null);
        JavaMappedSuperclassTests.assertNull((Object)typeResource.getAnnotation("javax.persistence.IdClass"));
        JavaMappedSuperclassTests.assertNull((Object)idClassRef.getSpecifiedIdClassName());
        JavaMappedSuperclassTests.assertNull((Object)idClassRef.getIdClass());
        idClass = (IdClassAnnotation)typeResource.addAnnotation("javax.persistence.IdClass");
        idClass.setValue(existentIdClassName);
        typeResource.removeAnnotation("javax.persistence.IdClass");
        this.getJpaProject().synchronizeContextModel();
        JavaMappedSuperclassTests.assertNull((Object)typeResource.getAnnotation("javax.persistence.IdClass"));
        JavaMappedSuperclassTests.assertNull((Object)idClassRef.getSpecifiedIdClassName());
        JavaMappedSuperclassTests.assertNull((Object)idClassRef.getIdClass());
    }

    public void testModifyIdClass() throws Exception {
        this.createTestMappedSuperclass();
        this.createTestIdClass();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        MappedSuperclass mappedSuperclass = (MappedSuperclass)this.getJavaPersistentType().getMapping();
        IdClassReference idClassRef = mappedSuperclass.getIdClassReference();
        JavaMappedSuperclassTests.assertNull((Object)typeResource.getAnnotation("javax.persistence.IdClass"));
        JavaMappedSuperclassTests.assertNull((Object)idClassRef.getSpecifiedIdClassName());
        JavaMappedSuperclassTests.assertNull((Object)idClassRef.getIdClass());
        String nonExistentIdClassName = "test.Foo";
        idClassRef.setSpecifiedIdClassName(nonExistentIdClassName);
        JavaMappedSuperclassTests.assertEquals((String)nonExistentIdClassName, (String)((IdClassAnnotation)typeResource.getAnnotation("javax.persistence.IdClass")).getValue());
        JavaMappedSuperclassTests.assertEquals((String)nonExistentIdClassName, (String)idClassRef.getSpecifiedIdClassName());
        JavaMappedSuperclassTests.assertNull((Object)idClassRef.getIdClass());
        String existentIdClassName = "test.TestTypeId";
        idClassRef.setSpecifiedIdClassName(existentIdClassName);
        JavaMappedSuperclassTests.assertEquals((String)existentIdClassName, (String)((IdClassAnnotation)typeResource.getAnnotation("javax.persistence.IdClass")).getValue());
        JavaMappedSuperclassTests.assertEquals((String)existentIdClassName, (String)idClassRef.getSpecifiedIdClassName());
        JavaMappedSuperclassTests.assertNotNull((Object)idClassRef.getIdClass());
        idClassRef.setSpecifiedIdClassName(null);
        JavaMappedSuperclassTests.assertNull((Object)typeResource.getAnnotation("javax.persistence.IdClass"));
        JavaMappedSuperclassTests.assertNull((Object)idClassRef.getSpecifiedIdClassName());
        JavaMappedSuperclassTests.assertNull((Object)idClassRef.getIdClass());
    }
}

