/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.tests.internal.context.java;

import java.util.Iterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.core.context.IdMapping;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentAttribute;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentType;
import org.eclipse.jpt.core.resource.java.SequenceGeneratorAnnotation;
import org.eclipse.jpt.core.tests.internal.context.ContextModelTestCase;
import org.eclipse.jpt.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.utility.internal.iterators.ArrayIterator;

public class JavaSequenceGeneratorTests
extends ContextModelTestCase {
    private static final String SEQUENCE_GENERATOR_NAME = "MY_SEQUENCE_GENERATOR";

    protected ICompilationUnit createTestEntityWithSequenceGenerator() throws Exception {
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.SequenceGenerator", "javax.persistence.Id"});
            }

            @Override
            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity");
            }

            @Override
            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@Id").append(CR);
                sb.append("@SequenceGenerator(name=\"MY_SEQUENCE_GENERATOR\")");
            }
        });
    }

    public JavaSequenceGeneratorTests(String name) {
        super(name);
    }

    public void testGetName() throws Exception {
        this.createTestEntityWithSequenceGenerator();
        this.addXmlClassRef("test.AnnotationTestType");
        IdMapping idMapping = (IdMapping)this.getJavaPersistentType().getAttributeNamed("id").getMapping();
        JavaSequenceGeneratorTests.assertEquals((String)SEQUENCE_GENERATOR_NAME, (String)idMapping.getGeneratorContainer().getSequenceGenerator().getName());
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        SequenceGeneratorAnnotation sequenceGenerator = (SequenceGeneratorAnnotation)attributeResource.getAnnotation("javax.persistence.SequenceGenerator");
        sequenceGenerator.setName("foo");
        this.getJpaProject().synchronizeContextModel();
        JavaSequenceGeneratorTests.assertEquals((String)"foo", (String)idMapping.getGeneratorContainer().getSequenceGenerator().getName());
    }

    public void testSetName() throws Exception {
        this.createTestEntityWithSequenceGenerator();
        this.addXmlClassRef("test.AnnotationTestType");
        IdMapping idMapping = (IdMapping)this.getJavaPersistentType().getAttributeNamed("id").getMapping();
        JavaSequenceGeneratorTests.assertEquals((String)SEQUENCE_GENERATOR_NAME, (String)idMapping.getGeneratorContainer().getSequenceGenerator().getName());
        idMapping.getGeneratorContainer().getSequenceGenerator().setName("foo");
        JavaSequenceGeneratorTests.assertEquals((String)"foo", (String)idMapping.getGeneratorContainer().getSequenceGenerator().getName());
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        SequenceGeneratorAnnotation sequenceGenerator = (SequenceGeneratorAnnotation)attributeResource.getAnnotation("javax.persistence.SequenceGenerator");
        JavaSequenceGeneratorTests.assertEquals((String)"foo", (String)sequenceGenerator.getName());
    }

    public void testSetSpecifiedNameNull() throws Exception {
        this.createTestEntityWithSequenceGenerator();
        this.addXmlClassRef("test.AnnotationTestType");
        IdMapping idMapping = (IdMapping)this.getJavaPersistentType().getAttributeNamed("id").getMapping();
        JavaSequenceGeneratorTests.assertEquals((String)SEQUENCE_GENERATOR_NAME, (String)idMapping.getGeneratorContainer().getSequenceGenerator().getName());
        idMapping.getGeneratorContainer().getSequenceGenerator().setName(null);
        JavaSequenceGeneratorTests.assertNull((Object)idMapping.getGeneratorContainer().getSequenceGenerator());
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        SequenceGeneratorAnnotation sequenceGenerator = (SequenceGeneratorAnnotation)attributeResource.getAnnotation("javax.persistence.SequenceGenerator");
        JavaSequenceGeneratorTests.assertNull((Object)sequenceGenerator);
    }

    public void testGetInitialValue() throws Exception {
        this.createTestEntityWithSequenceGenerator();
        this.addXmlClassRef("test.AnnotationTestType");
        IdMapping idMapping = (IdMapping)this.getJavaPersistentType().getAttributeNamed("id").getMapping();
        JavaSequenceGeneratorTests.assertEquals((int)1, (int)idMapping.getGeneratorContainer().getSequenceGenerator().getInitialValue());
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        SequenceGeneratorAnnotation sequenceGenerator = (SequenceGeneratorAnnotation)attributeResource.getAnnotation("javax.persistence.SequenceGenerator");
        sequenceGenerator.setInitialValue(Integer.valueOf(82));
        this.getJpaProject().synchronizeContextModel();
        JavaSequenceGeneratorTests.assertEquals((int)82, (int)idMapping.getGeneratorContainer().getSequenceGenerator().getInitialValue());
        JavaSequenceGeneratorTests.assertEquals((Object)82, (Object)idMapping.getGeneratorContainer().getSequenceGenerator().getSpecifiedInitialValue());
    }

    public void testGetDefaultInitialValue() throws Exception {
        this.createTestEntityWithSequenceGenerator();
        this.addXmlClassRef("test.AnnotationTestType");
        IdMapping idMapping = (IdMapping)this.getJavaPersistentType().getAttributeNamed("id").getMapping();
        JavaSequenceGeneratorTests.assertEquals((int)1, (int)idMapping.getGeneratorContainer().getSequenceGenerator().getDefaultInitialValue());
        idMapping.getGeneratorContainer().getSequenceGenerator().setSpecifiedInitialValue(Integer.valueOf(82));
        JavaSequenceGeneratorTests.assertEquals((int)1, (int)idMapping.getGeneratorContainer().getSequenceGenerator().getDefaultInitialValue());
        JavaSequenceGeneratorTests.assertEquals((Object)82, (Object)idMapping.getGeneratorContainer().getSequenceGenerator().getSpecifiedInitialValue());
    }

    public void testSetSpecifiedInitialValue() throws Exception {
        this.createTestEntityWithSequenceGenerator();
        this.addXmlClassRef("test.AnnotationTestType");
        IdMapping idMapping = (IdMapping)this.getJavaPersistentType().getAttributeNamed("id").getMapping();
        idMapping.getGeneratorContainer().getSequenceGenerator().setSpecifiedInitialValue(Integer.valueOf(20));
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        SequenceGeneratorAnnotation sequenceGenerator = (SequenceGeneratorAnnotation)attributeResource.getAnnotation("javax.persistence.SequenceGenerator");
        JavaSequenceGeneratorTests.assertEquals((Object)20, (Object)sequenceGenerator.getInitialValue());
        idMapping.getGeneratorContainer().getSequenceGenerator().setName(null);
        idMapping.getGeneratorContainer().getSequenceGenerator().setSpecifiedInitialValue(null);
        JavaSequenceGeneratorTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.SequenceGenerator"));
    }

    public void testGetAllocationSize() throws Exception {
        this.createTestEntityWithSequenceGenerator();
        this.addXmlClassRef("test.AnnotationTestType");
        IdMapping idMapping = (IdMapping)this.getJavaPersistentType().getAttributeNamed("id").getMapping();
        JavaSequenceGeneratorTests.assertEquals((int)50, (int)idMapping.getGeneratorContainer().getSequenceGenerator().getAllocationSize());
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        SequenceGeneratorAnnotation sequenceGenerator = (SequenceGeneratorAnnotation)attributeResource.getAnnotation("javax.persistence.SequenceGenerator");
        sequenceGenerator.setAllocationSize(Integer.valueOf(20));
        this.getJpaProject().synchronizeContextModel();
        JavaSequenceGeneratorTests.assertEquals((int)20, (int)idMapping.getGeneratorContainer().getSequenceGenerator().getAllocationSize());
        JavaSequenceGeneratorTests.assertEquals((Object)20, (Object)idMapping.getGeneratorContainer().getSequenceGenerator().getSpecifiedAllocationSize());
    }

    public void testGetDefaultAllocationSize() throws Exception {
        this.createTestEntityWithSequenceGenerator();
        this.addXmlClassRef("test.AnnotationTestType");
        IdMapping idMapping = (IdMapping)this.getJavaPersistentType().getAttributeNamed("id").getMapping();
        JavaSequenceGeneratorTests.assertEquals((int)50, (int)idMapping.getGeneratorContainer().getSequenceGenerator().getDefaultAllocationSize());
        idMapping.getGeneratorContainer().getSequenceGenerator().setSpecifiedAllocationSize(Integer.valueOf(20));
        JavaSequenceGeneratorTests.assertEquals((int)50, (int)idMapping.getGeneratorContainer().getSequenceGenerator().getDefaultAllocationSize());
        JavaSequenceGeneratorTests.assertEquals((Object)20, (Object)idMapping.getGeneratorContainer().getSequenceGenerator().getSpecifiedAllocationSize());
    }

    public void testSetSpecifiedAllocationSize() throws Exception {
        this.createTestEntityWithSequenceGenerator();
        this.addXmlClassRef("test.AnnotationTestType");
        IdMapping idMapping = (IdMapping)this.getJavaPersistentType().getAttributeNamed("id").getMapping();
        idMapping.getGeneratorContainer().getSequenceGenerator().setSpecifiedAllocationSize(Integer.valueOf(25));
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        SequenceGeneratorAnnotation sequenceGenerator = (SequenceGeneratorAnnotation)attributeResource.getAnnotation("javax.persistence.SequenceGenerator");
        JavaSequenceGeneratorTests.assertEquals((Object)25, (Object)sequenceGenerator.getAllocationSize());
        idMapping.getGeneratorContainer().getSequenceGenerator().setName(null);
        idMapping.getGeneratorContainer().getSequenceGenerator().setSpecifiedAllocationSize(null);
        JavaSequenceGeneratorTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.SequenceGenerator"));
    }

    public void testGetSequenceName() throws Exception {
        this.createTestEntityWithSequenceGenerator();
        this.addXmlClassRef("test.AnnotationTestType");
        IdMapping idMapping = (IdMapping)this.getJavaPersistentType().getAttributeNamed("id").getMapping();
        JavaSequenceGeneratorTests.assertNull((Object)idMapping.getGeneratorContainer().getSequenceGenerator().getSequenceName());
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        SequenceGeneratorAnnotation sequenceGenerator = (SequenceGeneratorAnnotation)attributeResource.getAnnotation("javax.persistence.SequenceGenerator");
        sequenceGenerator.setSequenceName("mySequenceName");
        this.getJpaProject().synchronizeContextModel();
        JavaSequenceGeneratorTests.assertEquals((String)"mySequenceName", (String)idMapping.getGeneratorContainer().getSequenceGenerator().getSequenceName());
        JavaSequenceGeneratorTests.assertEquals((String)"mySequenceName", (String)idMapping.getGeneratorContainer().getSequenceGenerator().getSpecifiedSequenceName());
    }

    public void testGetDefaultSequenceName() throws Exception {
        this.createTestEntityWithSequenceGenerator();
        this.addXmlClassRef("test.AnnotationTestType");
        IdMapping idMapping = (IdMapping)this.getJavaPersistentType().getAttributeNamed("id").getMapping();
        JavaSequenceGeneratorTests.assertNull((Object)idMapping.getGeneratorContainer().getSequenceGenerator().getDefaultSequenceName());
        idMapping.getGeneratorContainer().getSequenceGenerator().setSpecifiedSequenceName("mySequenceName");
        JavaSequenceGeneratorTests.assertNull((Object)idMapping.getGeneratorContainer().getSequenceGenerator().getDefaultSequenceName());
        JavaSequenceGeneratorTests.assertEquals((String)"mySequenceName", (String)idMapping.getGeneratorContainer().getSequenceGenerator().getSpecifiedSequenceName());
    }

    public void testSetSpecifiedSequenceName() throws Exception {
        this.createTestEntityWithSequenceGenerator();
        this.addXmlClassRef("test.AnnotationTestType");
        IdMapping idMapping = (IdMapping)this.getJavaPersistentType().getAttributeNamed("id").getMapping();
        idMapping.getGeneratorContainer().getSequenceGenerator().setSpecifiedSequenceName("mySequenceName");
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        SequenceGeneratorAnnotation sequenceGenerator = (SequenceGeneratorAnnotation)attributeResource.getAnnotation("javax.persistence.SequenceGenerator");
        JavaSequenceGeneratorTests.assertEquals((String)"mySequenceName", (String)sequenceGenerator.getSequenceName());
        idMapping.getGeneratorContainer().getSequenceGenerator().setName(null);
        idMapping.getGeneratorContainer().getSequenceGenerator().setSpecifiedSequenceName(null);
        JavaSequenceGeneratorTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.SequenceGenerator"));
    }
}

