/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.tests.internal.context.java;

import java.util.Iterator;
import java.util.ListIterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.core.context.IdMapping;
import org.eclipse.jpt.core.context.TableGenerator;
import org.eclipse.jpt.core.context.UniqueConstraint;
import org.eclipse.jpt.core.context.java.JavaUniqueConstraint;
import org.eclipse.jpt.core.context.orm.OrmEntity;
import org.eclipse.jpt.core.context.orm.OrmPersistentType;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentAttribute;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentType;
import org.eclipse.jpt.core.resource.java.TableGeneratorAnnotation;
import org.eclipse.jpt.core.resource.java.UniqueConstraintAnnotation;
import org.eclipse.jpt.core.resource.persistence.PersistenceFactory;
import org.eclipse.jpt.core.resource.persistence.XmlMappingFileRef;
import org.eclipse.jpt.core.tests.internal.context.ContextModelTestCase;
import org.eclipse.jpt.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.utility.internal.iterators.ArrayIterator;

public class JavaTableGeneratorTests
extends ContextModelTestCase {
    private static final String TABLE_GENERATOR_NAME = "MY_TABLE_GENERATOR";

    private ICompilationUnit createTestEntityWithTableGenerator() throws Exception {
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.TableGenerator", "javax.persistence.Id"});
            }

            @Override
            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity");
            }

            @Override
            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@Id").append(CR);
                sb.append("@TableGenerator(name=\"MY_TABLE_GENERATOR\")");
            }
        });
    }

    public JavaTableGeneratorTests(String name) {
        super(name);
    }

    public void testGetName() throws Exception {
        this.createTestEntityWithTableGenerator();
        this.addXmlClassRef("test.AnnotationTestType");
        IdMapping idMapping = (IdMapping)this.getJavaPersistentType().getAttributeNamed("id").getMapping();
        JavaTableGeneratorTests.assertEquals((String)TABLE_GENERATOR_NAME, (String)idMapping.getGeneratorContainer().getTableGenerator().getName());
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        TableGeneratorAnnotation tableGenerator = (TableGeneratorAnnotation)attributeResource.getAnnotation("javax.persistence.TableGenerator");
        tableGenerator.setName("foo");
        this.getJpaProject().synchronizeContextModel();
        JavaTableGeneratorTests.assertEquals((String)"foo", (String)idMapping.getGeneratorContainer().getTableGenerator().getName());
    }

    public void testSetName() throws Exception {
        this.createTestEntityWithTableGenerator();
        this.addXmlClassRef("test.AnnotationTestType");
        IdMapping idMapping = (IdMapping)this.getJavaPersistentType().getAttributeNamed("id").getMapping();
        JavaTableGeneratorTests.assertEquals((String)TABLE_GENERATOR_NAME, (String)idMapping.getGeneratorContainer().getTableGenerator().getName());
        idMapping.getGeneratorContainer().getTableGenerator().setName("foo");
        JavaTableGeneratorTests.assertEquals((String)"foo", (String)idMapping.getGeneratorContainer().getTableGenerator().getName());
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        TableGeneratorAnnotation tableGenerator = (TableGeneratorAnnotation)attributeResource.getAnnotation("javax.persistence.TableGenerator");
        JavaTableGeneratorTests.assertEquals((String)"foo", (String)tableGenerator.getName());
    }

    public void testSetSpecifiedNameNull() throws Exception {
        this.createTestEntityWithTableGenerator();
        this.addXmlClassRef("test.AnnotationTestType");
        IdMapping idMapping = (IdMapping)this.getJavaPersistentType().getAttributeNamed("id").getMapping();
        JavaTableGeneratorTests.assertEquals((String)TABLE_GENERATOR_NAME, (String)idMapping.getGeneratorContainer().getTableGenerator().getName());
        idMapping.getGeneratorContainer().getTableGenerator().setName(null);
        JavaTableGeneratorTests.assertNull((Object)idMapping.getGeneratorContainer().getTableGenerator());
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        TableGeneratorAnnotation tableGenerator = (TableGeneratorAnnotation)attributeResource.getAnnotation("javax.persistence.TableGenerator");
        JavaTableGeneratorTests.assertNull((Object)tableGenerator);
    }

    public void testGetCatalog() throws Exception {
        this.createTestEntityWithTableGenerator();
        this.addXmlClassRef("test.AnnotationTestType");
        IdMapping idMapping = (IdMapping)this.getJavaPersistentType().getAttributeNamed("id").getMapping();
        JavaTableGeneratorTests.assertNull((Object)idMapping.getGeneratorContainer().getTableGenerator().getCatalog());
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        TableGeneratorAnnotation tableGenerator = (TableGeneratorAnnotation)attributeResource.getAnnotation("javax.persistence.TableGenerator");
        tableGenerator.setCatalog("myCatalog");
        this.getJpaProject().synchronizeContextModel();
        JavaTableGeneratorTests.assertEquals((String)"myCatalog", (String)idMapping.getGeneratorContainer().getTableGenerator().getCatalog());
        JavaTableGeneratorTests.assertEquals((String)"myCatalog", (String)idMapping.getGeneratorContainer().getTableGenerator().getSpecifiedCatalog());
    }

    public void testGetDefaultCatalog() throws Exception {
        this.createTestEntityWithTableGenerator();
        this.addXmlClassRef("test.AnnotationTestType");
        IdMapping idMapping = (IdMapping)this.getJavaPersistentType().getAttributeNamed("id").getMapping();
        JavaTableGeneratorTests.assertNull((Object)idMapping.getGeneratorContainer().getTableGenerator().getDefaultCatalog());
        idMapping.getGeneratorContainer().getTableGenerator().setSpecifiedCatalog("myCatalog");
        JavaTableGeneratorTests.assertNull((Object)idMapping.getGeneratorContainer().getTableGenerator().getDefaultCatalog());
        JavaTableGeneratorTests.assertEquals((String)"myCatalog", (String)idMapping.getGeneratorContainer().getTableGenerator().getSpecifiedCatalog());
    }

    public void testSetSpecifiedCatalog() throws Exception {
        this.createTestEntityWithTableGenerator();
        this.addXmlClassRef("test.AnnotationTestType");
        IdMapping idMapping = (IdMapping)this.getJavaPersistentType().getAttributeNamed("id").getMapping();
        idMapping.getGeneratorContainer().getTableGenerator().setSpecifiedCatalog("myCatalog");
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        TableGeneratorAnnotation tableGenerator = (TableGeneratorAnnotation)attributeResource.getAnnotation("javax.persistence.TableGenerator");
        JavaTableGeneratorTests.assertEquals((String)"myCatalog", (String)tableGenerator.getCatalog());
        idMapping.getGeneratorContainer().getTableGenerator().setName(null);
        idMapping.getGeneratorContainer().getTableGenerator().setSpecifiedCatalog(null);
        JavaTableGeneratorTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.TableGenerator"));
    }

    public void testGetSchema() throws Exception {
        this.createTestEntityWithTableGenerator();
        this.addXmlClassRef("test.AnnotationTestType");
        IdMapping idMapping = (IdMapping)this.getJavaPersistentType().getAttributeNamed("id").getMapping();
        JavaTableGeneratorTests.assertNull((Object)idMapping.getGeneratorContainer().getTableGenerator().getSchema());
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        TableGeneratorAnnotation tableGenerator = (TableGeneratorAnnotation)attributeResource.getAnnotation("javax.persistence.TableGenerator");
        tableGenerator.setSchema("mySchema");
        this.getJpaProject().synchronizeContextModel();
        JavaTableGeneratorTests.assertEquals((String)"mySchema", (String)idMapping.getGeneratorContainer().getTableGenerator().getSchema());
        JavaTableGeneratorTests.assertEquals((String)"mySchema", (String)idMapping.getGeneratorContainer().getTableGenerator().getSpecifiedSchema());
    }

    public void testGetDefaultSchema() throws Exception {
        this.createTestEntityWithTableGenerator();
        this.addXmlClassRef("test.AnnotationTestType");
        IdMapping idMapping = (IdMapping)this.getJavaPersistentType().getAttributeNamed("id").getMapping();
        JavaTableGeneratorTests.assertNull((Object)idMapping.getGeneratorContainer().getTableGenerator().getDefaultSchema());
        idMapping.getGeneratorContainer().getTableGenerator().setSpecifiedSchema("mySchema");
        JavaTableGeneratorTests.assertNull((Object)idMapping.getGeneratorContainer().getTableGenerator().getDefaultSchema());
        JavaTableGeneratorTests.assertEquals((String)"mySchema", (String)idMapping.getGeneratorContainer().getTableGenerator().getSpecifiedSchema());
    }

    public void testUpdateDefaultSchemaFromPersistenceUnitDefaults() throws Exception {
        XmlMappingFileRef mappingFileRef = PersistenceFactory.eINSTANCE.createXmlMappingFileRef();
        mappingFileRef.setFileName("META-INF/orm.xml");
        this.getXmlPersistenceUnit().getMappingFiles().add((Object)mappingFileRef);
        this.createTestEntityWithTableGenerator();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmEntity ormEntity = (OrmEntity)ormPersistentType.getMapping();
        IdMapping idMapping = (IdMapping)ormPersistentType.getJavaPersistentType().getAttributeNamed("id").getMapping();
        JavaTableGeneratorTests.assertNull((Object)idMapping.getGeneratorContainer().getTableGenerator().getDefaultSchema());
        this.getEntityMappings().getPersistenceUnitDefaults().setSpecifiedSchema("FOO");
        JavaTableGeneratorTests.assertEquals((String)"FOO", (String)idMapping.getGeneratorContainer().getTableGenerator().getDefaultSchema());
        this.getEntityMappings().setSpecifiedSchema("BAR");
        JavaTableGeneratorTests.assertEquals((String)"BAR", (String)idMapping.getGeneratorContainer().getTableGenerator().getDefaultSchema());
        ormEntity.getTable().setSpecifiedSchema("XML_SCHEMA");
        JavaTableGeneratorTests.assertEquals((String)"BAR", (String)idMapping.getGeneratorContainer().getTableGenerator().getDefaultSchema());
        this.getEntityMappings().removePersistentType(0);
        this.addXmlClassRef("test.AnnotationTestType");
        JavaTableGeneratorTests.assertEquals((String)"FOO", (String)((IdMapping)this.getJavaPersistentType().getAttributeNamed("id").getMapping()).getGeneratorContainer().getTableGenerator().getDefaultSchema());
    }

    public void testSetSpecifiedSchema() throws Exception {
        this.createTestEntityWithTableGenerator();
        this.addXmlClassRef("test.AnnotationTestType");
        IdMapping idMapping = (IdMapping)this.getJavaPersistentType().getAttributeNamed("id").getMapping();
        idMapping.getGeneratorContainer().getTableGenerator().setSpecifiedSchema("mySchema");
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        TableGeneratorAnnotation tableGenerator = (TableGeneratorAnnotation)attributeResource.getAnnotation("javax.persistence.TableGenerator");
        JavaTableGeneratorTests.assertEquals((String)"mySchema", (String)tableGenerator.getSchema());
        idMapping.getGeneratorContainer().getTableGenerator().setName(null);
        idMapping.getGeneratorContainer().getTableGenerator().setSpecifiedSchema(null);
        JavaTableGeneratorTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.TableGenerator"));
    }

    public void testGetPkColumnName() throws Exception {
        this.createTestEntityWithTableGenerator();
        this.addXmlClassRef("test.AnnotationTestType");
        IdMapping idMapping = (IdMapping)this.getJavaPersistentType().getAttributeNamed("id").getMapping();
        JavaTableGeneratorTests.assertNull((Object)idMapping.getGeneratorContainer().getTableGenerator().getPkColumnName());
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        TableGeneratorAnnotation tableGenerator = (TableGeneratorAnnotation)attributeResource.getAnnotation("javax.persistence.TableGenerator");
        tableGenerator.setPkColumnName("myPkColumnName");
        this.getJpaProject().synchronizeContextModel();
        JavaTableGeneratorTests.assertEquals((String)"myPkColumnName", (String)idMapping.getGeneratorContainer().getTableGenerator().getPkColumnName());
        JavaTableGeneratorTests.assertEquals((String)"myPkColumnName", (String)idMapping.getGeneratorContainer().getTableGenerator().getSpecifiedPkColumnName());
    }

    public void testGetDefaultPkColumnName() throws Exception {
        this.createTestEntityWithTableGenerator();
        this.addXmlClassRef("test.AnnotationTestType");
        IdMapping idMapping = (IdMapping)this.getJavaPersistentType().getAttributeNamed("id").getMapping();
        JavaTableGeneratorTests.assertNull((Object)idMapping.getGeneratorContainer().getTableGenerator().getDefaultPkColumnName());
        idMapping.getGeneratorContainer().getTableGenerator().setSpecifiedPkColumnName("myPkColumnName");
        JavaTableGeneratorTests.assertNull((Object)idMapping.getGeneratorContainer().getTableGenerator().getDefaultPkColumnName());
        JavaTableGeneratorTests.assertEquals((String)"myPkColumnName", (String)idMapping.getGeneratorContainer().getTableGenerator().getSpecifiedPkColumnName());
    }

    public void testSetSpecifiedPkColumnName() throws Exception {
        this.createTestEntityWithTableGenerator();
        this.addXmlClassRef("test.AnnotationTestType");
        IdMapping idMapping = (IdMapping)this.getJavaPersistentType().getAttributeNamed("id").getMapping();
        idMapping.getGeneratorContainer().getTableGenerator().setSpecifiedPkColumnName("myPkColumnName");
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        TableGeneratorAnnotation tableGenerator = (TableGeneratorAnnotation)attributeResource.getAnnotation("javax.persistence.TableGenerator");
        JavaTableGeneratorTests.assertEquals((String)"myPkColumnName", (String)tableGenerator.getPkColumnName());
        idMapping.getGeneratorContainer().getTableGenerator().setName(null);
        idMapping.getGeneratorContainer().getTableGenerator().setSpecifiedPkColumnName(null);
        JavaTableGeneratorTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.TableGenerator"));
    }

    public void testGetValueColumnName() throws Exception {
        this.createTestEntityWithTableGenerator();
        this.addXmlClassRef("test.AnnotationTestType");
        IdMapping idMapping = (IdMapping)this.getJavaPersistentType().getAttributeNamed("id").getMapping();
        JavaTableGeneratorTests.assertNull((Object)idMapping.getGeneratorContainer().getTableGenerator().getValueColumnName());
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        TableGeneratorAnnotation tableGenerator = (TableGeneratorAnnotation)attributeResource.getAnnotation("javax.persistence.TableGenerator");
        tableGenerator.setValueColumnName("myValueColumnName");
        this.getJpaProject().synchronizeContextModel();
        JavaTableGeneratorTests.assertEquals((String)"myValueColumnName", (String)idMapping.getGeneratorContainer().getTableGenerator().getValueColumnName());
        JavaTableGeneratorTests.assertEquals((String)"myValueColumnName", (String)idMapping.getGeneratorContainer().getTableGenerator().getSpecifiedValueColumnName());
    }

    public void testGetDefaultValueColumnName() throws Exception {
        this.createTestEntityWithTableGenerator();
        this.addXmlClassRef("test.AnnotationTestType");
        IdMapping idMapping = (IdMapping)this.getJavaPersistentType().getAttributeNamed("id").getMapping();
        JavaTableGeneratorTests.assertNull((Object)idMapping.getGeneratorContainer().getTableGenerator().getDefaultValueColumnName());
        idMapping.getGeneratorContainer().getTableGenerator().setSpecifiedValueColumnName("myValueColumnName");
        JavaTableGeneratorTests.assertNull((Object)idMapping.getGeneratorContainer().getTableGenerator().getDefaultValueColumnName());
        JavaTableGeneratorTests.assertEquals((String)"myValueColumnName", (String)idMapping.getGeneratorContainer().getTableGenerator().getSpecifiedValueColumnName());
    }

    public void testSetSpecifiedValueColumnName() throws Exception {
        this.createTestEntityWithTableGenerator();
        this.addXmlClassRef("test.AnnotationTestType");
        IdMapping idMapping = (IdMapping)this.getJavaPersistentType().getAttributeNamed("id").getMapping();
        idMapping.getGeneratorContainer().getTableGenerator().setSpecifiedValueColumnName("myValueColumnName");
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        TableGeneratorAnnotation tableGenerator = (TableGeneratorAnnotation)attributeResource.getAnnotation("javax.persistence.TableGenerator");
        JavaTableGeneratorTests.assertEquals((String)"myValueColumnName", (String)tableGenerator.getValueColumnName());
        idMapping.getGeneratorContainer().getTableGenerator().setName(null);
        idMapping.getGeneratorContainer().getTableGenerator().setSpecifiedValueColumnName(null);
        JavaTableGeneratorTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.TableGenerator"));
    }

    public void testGetPkColumnValue() throws Exception {
        this.createTestEntityWithTableGenerator();
        this.addXmlClassRef("test.AnnotationTestType");
        IdMapping idMapping = (IdMapping)this.getJavaPersistentType().getAttributeNamed("id").getMapping();
        JavaTableGeneratorTests.assertNull((Object)idMapping.getGeneratorContainer().getTableGenerator().getPkColumnValue());
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        TableGeneratorAnnotation tableGenerator = (TableGeneratorAnnotation)attributeResource.getAnnotation("javax.persistence.TableGenerator");
        tableGenerator.setPkColumnValue("myPkColumnValue");
        this.getJpaProject().synchronizeContextModel();
        JavaTableGeneratorTests.assertEquals((String)"myPkColumnValue", (String)idMapping.getGeneratorContainer().getTableGenerator().getPkColumnValue());
        JavaTableGeneratorTests.assertEquals((String)"myPkColumnValue", (String)idMapping.getGeneratorContainer().getTableGenerator().getSpecifiedPkColumnValue());
    }

    public void testGetDefaultPkColumnValue() throws Exception {
        this.createTestEntityWithTableGenerator();
        this.addXmlClassRef("test.AnnotationTestType");
        IdMapping idMapping = (IdMapping)this.getJavaPersistentType().getAttributeNamed("id").getMapping();
        JavaTableGeneratorTests.assertNull((Object)idMapping.getGeneratorContainer().getTableGenerator().getDefaultPkColumnValue());
        idMapping.getGeneratorContainer().getTableGenerator().setSpecifiedPkColumnValue("myPkColumnValue");
        JavaTableGeneratorTests.assertNull((Object)idMapping.getGeneratorContainer().getTableGenerator().getDefaultPkColumnValue());
        JavaTableGeneratorTests.assertEquals((String)"myPkColumnValue", (String)idMapping.getGeneratorContainer().getTableGenerator().getSpecifiedPkColumnValue());
    }

    public void testSetSpecifiedPkColumnValue() throws Exception {
        this.createTestEntityWithTableGenerator();
        this.addXmlClassRef("test.AnnotationTestType");
        IdMapping idMapping = (IdMapping)this.getJavaPersistentType().getAttributeNamed("id").getMapping();
        idMapping.getGeneratorContainer().getTableGenerator().setSpecifiedPkColumnValue("myPkColumnValue");
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        TableGeneratorAnnotation tableGenerator = (TableGeneratorAnnotation)attributeResource.getAnnotation("javax.persistence.TableGenerator");
        JavaTableGeneratorTests.assertEquals((String)"myPkColumnValue", (String)tableGenerator.getPkColumnValue());
        idMapping.getGeneratorContainer().getTableGenerator().setName(null);
        idMapping.getGeneratorContainer().getTableGenerator().setSpecifiedPkColumnValue(null);
        JavaTableGeneratorTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.TableGenerator"));
    }

    public void testGetInitialValue() throws Exception {
        this.createTestEntityWithTableGenerator();
        this.addXmlClassRef("test.AnnotationTestType");
        IdMapping idMapping = (IdMapping)this.getJavaPersistentType().getAttributeNamed("id").getMapping();
        JavaTableGeneratorTests.assertEquals((int)0, (int)idMapping.getGeneratorContainer().getTableGenerator().getInitialValue());
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        TableGeneratorAnnotation tableGenerator = (TableGeneratorAnnotation)attributeResource.getAnnotation("javax.persistence.TableGenerator");
        tableGenerator.setInitialValue(Integer.valueOf(82));
        this.getJpaProject().synchronizeContextModel();
        JavaTableGeneratorTests.assertEquals((int)82, (int)idMapping.getGeneratorContainer().getTableGenerator().getInitialValue());
        JavaTableGeneratorTests.assertEquals((Object)82, (Object)idMapping.getGeneratorContainer().getTableGenerator().getSpecifiedInitialValue());
    }

    public void testGetDefaultInitialValue() throws Exception {
        this.createTestEntityWithTableGenerator();
        this.addXmlClassRef("test.AnnotationTestType");
        IdMapping idMapping = (IdMapping)this.getJavaPersistentType().getAttributeNamed("id").getMapping();
        JavaTableGeneratorTests.assertEquals((int)0, (int)idMapping.getGeneratorContainer().getTableGenerator().getDefaultInitialValue());
        idMapping.getGeneratorContainer().getTableGenerator().setSpecifiedInitialValue(Integer.valueOf(82));
        JavaTableGeneratorTests.assertEquals((int)0, (int)idMapping.getGeneratorContainer().getTableGenerator().getDefaultInitialValue());
        JavaTableGeneratorTests.assertEquals((Object)82, (Object)idMapping.getGeneratorContainer().getTableGenerator().getSpecifiedInitialValue());
    }

    public void testSetSpecifiedInitialValue() throws Exception {
        this.createTestEntityWithTableGenerator();
        this.addXmlClassRef("test.AnnotationTestType");
        IdMapping idMapping = (IdMapping)this.getJavaPersistentType().getAttributeNamed("id").getMapping();
        idMapping.getGeneratorContainer().getTableGenerator().setSpecifiedInitialValue(Integer.valueOf(20));
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        TableGeneratorAnnotation tableGenerator = (TableGeneratorAnnotation)attributeResource.getAnnotation("javax.persistence.TableGenerator");
        JavaTableGeneratorTests.assertEquals((Object)20, (Object)tableGenerator.getInitialValue());
        idMapping.getGeneratorContainer().getTableGenerator().setName(null);
        idMapping.getGeneratorContainer().getTableGenerator().setSpecifiedInitialValue(null);
        JavaTableGeneratorTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.TableGenerator"));
    }

    public void testGetAllocationSize() throws Exception {
        this.createTestEntityWithTableGenerator();
        this.addXmlClassRef("test.AnnotationTestType");
        IdMapping idMapping = (IdMapping)this.getJavaPersistentType().getAttributeNamed("id").getMapping();
        JavaTableGeneratorTests.assertEquals((int)50, (int)idMapping.getGeneratorContainer().getTableGenerator().getAllocationSize());
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        TableGeneratorAnnotation tableGenerator = (TableGeneratorAnnotation)attributeResource.getAnnotation("javax.persistence.TableGenerator");
        tableGenerator.setAllocationSize(Integer.valueOf(20));
        this.getJpaProject().synchronizeContextModel();
        JavaTableGeneratorTests.assertEquals((int)20, (int)idMapping.getGeneratorContainer().getTableGenerator().getAllocationSize());
        JavaTableGeneratorTests.assertEquals((Object)20, (Object)idMapping.getGeneratorContainer().getTableGenerator().getSpecifiedAllocationSize());
    }

    public void testGetDefaultAllocationSize() throws Exception {
        this.createTestEntityWithTableGenerator();
        this.addXmlClassRef("test.AnnotationTestType");
        IdMapping idMapping = (IdMapping)this.getJavaPersistentType().getAttributeNamed("id").getMapping();
        JavaTableGeneratorTests.assertEquals((int)50, (int)idMapping.getGeneratorContainer().getTableGenerator().getDefaultAllocationSize());
        idMapping.getGeneratorContainer().getTableGenerator().setSpecifiedAllocationSize(Integer.valueOf(20));
        JavaTableGeneratorTests.assertEquals((int)50, (int)idMapping.getGeneratorContainer().getTableGenerator().getDefaultAllocationSize());
        JavaTableGeneratorTests.assertEquals((Object)20, (Object)idMapping.getGeneratorContainer().getTableGenerator().getSpecifiedAllocationSize());
    }

    public void testSetSpecifiedAllocationSize() throws Exception {
        this.createTestEntityWithTableGenerator();
        this.addXmlClassRef("test.AnnotationTestType");
        IdMapping idMapping = (IdMapping)this.getJavaPersistentType().getAttributeNamed("id").getMapping();
        idMapping.getGeneratorContainer().getTableGenerator().setSpecifiedAllocationSize(Integer.valueOf(25));
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        TableGeneratorAnnotation tableGenerator = (TableGeneratorAnnotation)attributeResource.getAnnotation("javax.persistence.TableGenerator");
        JavaTableGeneratorTests.assertEquals((Object)25, (Object)tableGenerator.getAllocationSize());
        idMapping.getGeneratorContainer().getTableGenerator().setName(null);
        idMapping.getGeneratorContainer().getTableGenerator().setSpecifiedAllocationSize(null);
        JavaTableGeneratorTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.TableGenerator"));
    }

    public void testUniqueConstraints() throws Exception {
        this.createTestEntityWithTableGenerator();
        this.addXmlClassRef("test.AnnotationTestType");
        TableGenerator tableGenerator = ((IdMapping)this.getJavaPersistentType().getAttributeNamed("id").getMapping()).getGeneratorContainer().getTableGenerator();
        ListIterator uniqueConstraints = tableGenerator.uniqueConstraints();
        JavaTableGeneratorTests.assertFalse((boolean)uniqueConstraints.hasNext());
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        TableGeneratorAnnotation tableGeneratorAnnotation = (TableGeneratorAnnotation)attributeResource.getAnnotation("javax.persistence.TableGenerator");
        tableGeneratorAnnotation.addUniqueConstraint(0).addColumnName(0, "foo");
        tableGeneratorAnnotation.addUniqueConstraint(0).addColumnName(0, "bar");
        this.getJpaProject().synchronizeContextModel();
        uniqueConstraints = tableGenerator.uniqueConstraints();
        JavaTableGeneratorTests.assertTrue((boolean)uniqueConstraints.hasNext());
        JavaTableGeneratorTests.assertEquals((String)"bar", (String)((String)((JavaUniqueConstraint)uniqueConstraints.next()).columnNames().next()));
        JavaTableGeneratorTests.assertEquals((String)"foo", (String)((String)((JavaUniqueConstraint)uniqueConstraints.next()).columnNames().next()));
        JavaTableGeneratorTests.assertFalse((boolean)uniqueConstraints.hasNext());
    }

    public void testUniqueConstraintsSize() throws Exception {
        this.createTestEntityWithTableGenerator();
        this.addXmlClassRef("test.AnnotationTestType");
        TableGenerator tableGenerator = ((IdMapping)this.getJavaPersistentType().getAttributeNamed("id").getMapping()).getGeneratorContainer().getTableGenerator();
        JavaTableGeneratorTests.assertEquals((int)0, (int)tableGenerator.uniqueConstraintsSize());
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        TableGeneratorAnnotation tableGeneratorAnnotation = (TableGeneratorAnnotation)attributeResource.getAnnotation("javax.persistence.TableGenerator");
        tableGeneratorAnnotation.addUniqueConstraint(0).addColumnName(0, "foo");
        tableGeneratorAnnotation.addUniqueConstraint(1).addColumnName(0, "bar");
        this.getJpaProject().synchronizeContextModel();
        JavaTableGeneratorTests.assertEquals((int)2, (int)tableGenerator.uniqueConstraintsSize());
    }

    public void testAddUniqueConstraint() throws Exception {
        this.createTestEntityWithTableGenerator();
        this.addXmlClassRef("test.AnnotationTestType");
        TableGenerator tableGenerator = ((IdMapping)this.getJavaPersistentType().getAttributeNamed("id").getMapping()).getGeneratorContainer().getTableGenerator();
        tableGenerator.addUniqueConstraint(0).addColumnName(0, "FOO");
        tableGenerator.addUniqueConstraint(0).addColumnName(0, "BAR");
        tableGenerator.addUniqueConstraint(0).addColumnName(0, "BAZ");
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        TableGeneratorAnnotation tableGeneratorAnnotation = (TableGeneratorAnnotation)attributeResource.getAnnotation("javax.persistence.TableGenerator");
        ListIterator uniqueConstraints = tableGeneratorAnnotation.uniqueConstraints();
        JavaTableGeneratorTests.assertEquals((String)"BAZ", (String)((String)((UniqueConstraintAnnotation)uniqueConstraints.next()).columnNames().next()));
        JavaTableGeneratorTests.assertEquals((String)"BAR", (String)((String)((UniqueConstraintAnnotation)uniqueConstraints.next()).columnNames().next()));
        JavaTableGeneratorTests.assertEquals((String)"FOO", (String)((String)((UniqueConstraintAnnotation)uniqueConstraints.next()).columnNames().next()));
        JavaTableGeneratorTests.assertFalse((boolean)uniqueConstraints.hasNext());
    }

    public void testAddUniqueConstraint2() throws Exception {
        this.createTestEntityWithTableGenerator();
        this.addXmlClassRef("test.AnnotationTestType");
        TableGenerator tableGenerator = ((IdMapping)this.getJavaPersistentType().getAttributeNamed("id").getMapping()).getGeneratorContainer().getTableGenerator();
        tableGenerator.addUniqueConstraint(0).addColumnName(0, "FOO");
        tableGenerator.addUniqueConstraint(1).addColumnName(0, "BAR");
        tableGenerator.addUniqueConstraint(0).addColumnName(0, "BAZ");
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        TableGeneratorAnnotation tableGeneratorAnnotation = (TableGeneratorAnnotation)attributeResource.getAnnotation("javax.persistence.TableGenerator");
        ListIterator uniqueConstraints = tableGeneratorAnnotation.uniqueConstraints();
        JavaTableGeneratorTests.assertEquals((String)"BAZ", (String)((String)((UniqueConstraintAnnotation)uniqueConstraints.next()).columnNames().next()));
        JavaTableGeneratorTests.assertEquals((String)"FOO", (String)((String)((UniqueConstraintAnnotation)uniqueConstraints.next()).columnNames().next()));
        JavaTableGeneratorTests.assertEquals((String)"BAR", (String)((String)((UniqueConstraintAnnotation)uniqueConstraints.next()).columnNames().next()));
        JavaTableGeneratorTests.assertFalse((boolean)uniqueConstraints.hasNext());
    }

    public void testRemoveUniqueConstraint() throws Exception {
        this.createTestEntityWithTableGenerator();
        this.addXmlClassRef("test.AnnotationTestType");
        TableGenerator tableGenerator = ((IdMapping)this.getJavaPersistentType().getAttributeNamed("id").getMapping()).getGeneratorContainer().getTableGenerator();
        tableGenerator.addUniqueConstraint(0).addColumnName(0, "FOO");
        tableGenerator.addUniqueConstraint(1).addColumnName(0, "BAR");
        tableGenerator.addUniqueConstraint(2).addColumnName(0, "BAZ");
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        TableGeneratorAnnotation tableGeneratorAnnotation = (TableGeneratorAnnotation)attributeResource.getAnnotation("javax.persistence.TableGenerator");
        JavaTableGeneratorTests.assertEquals((int)3, (int)tableGeneratorAnnotation.uniqueConstraintsSize());
        tableGenerator.removeUniqueConstraint(1);
        ListIterator uniqueConstraintAnnotations = tableGeneratorAnnotation.uniqueConstraints();
        JavaTableGeneratorTests.assertEquals((String)"FOO", (String)((String)((UniqueConstraintAnnotation)uniqueConstraintAnnotations.next()).columnNames().next()));
        JavaTableGeneratorTests.assertEquals((String)"BAZ", (String)((String)((UniqueConstraintAnnotation)uniqueConstraintAnnotations.next()).columnNames().next()));
        JavaTableGeneratorTests.assertFalse((boolean)uniqueConstraintAnnotations.hasNext());
        ListIterator uniqueConstraints = tableGenerator.uniqueConstraints();
        JavaTableGeneratorTests.assertEquals((String)"FOO", (String)((String)((UniqueConstraint)uniqueConstraints.next()).columnNames().next()));
        JavaTableGeneratorTests.assertEquals((String)"BAZ", (String)((String)((UniqueConstraint)uniqueConstraints.next()).columnNames().next()));
        JavaTableGeneratorTests.assertFalse((boolean)uniqueConstraints.hasNext());
        tableGenerator.removeUniqueConstraint(1);
        uniqueConstraintAnnotations = tableGeneratorAnnotation.uniqueConstraints();
        JavaTableGeneratorTests.assertEquals((String)"FOO", (String)((String)((UniqueConstraintAnnotation)uniqueConstraintAnnotations.next()).columnNames().next()));
        JavaTableGeneratorTests.assertFalse((boolean)uniqueConstraintAnnotations.hasNext());
        uniqueConstraints = tableGenerator.uniqueConstraints();
        JavaTableGeneratorTests.assertEquals((String)"FOO", (String)((String)((UniqueConstraint)uniqueConstraints.next()).columnNames().next()));
        JavaTableGeneratorTests.assertFalse((boolean)uniqueConstraints.hasNext());
        tableGenerator.removeUniqueConstraint(0);
        uniqueConstraintAnnotations = tableGeneratorAnnotation.uniqueConstraints();
        JavaTableGeneratorTests.assertFalse((boolean)uniqueConstraintAnnotations.hasNext());
        uniqueConstraints = tableGenerator.uniqueConstraints();
        JavaTableGeneratorTests.assertFalse((boolean)uniqueConstraints.hasNext());
    }

    public void testMoveUniqueConstraint() throws Exception {
        this.createTestEntityWithTableGenerator();
        this.addXmlClassRef("test.AnnotationTestType");
        TableGenerator tableGenerator = ((IdMapping)this.getJavaPersistentType().getAttributeNamed("id").getMapping()).getGeneratorContainer().getTableGenerator();
        tableGenerator.addUniqueConstraint(0).addColumnName(0, "FOO");
        tableGenerator.addUniqueConstraint(1).addColumnName(0, "BAR");
        tableGenerator.addUniqueConstraint(2).addColumnName(0, "BAZ");
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        TableGeneratorAnnotation tableGeneratorAnnotation = (TableGeneratorAnnotation)attributeResource.getAnnotation("javax.persistence.TableGenerator");
        JavaTableGeneratorTests.assertEquals((int)3, (int)tableGeneratorAnnotation.uniqueConstraintsSize());
        tableGenerator.moveUniqueConstraint(2, 0);
        ListIterator uniqueConstraints = tableGenerator.uniqueConstraints();
        JavaTableGeneratorTests.assertEquals((String)"BAR", (String)((String)((UniqueConstraint)uniqueConstraints.next()).columnNames().next()));
        JavaTableGeneratorTests.assertEquals((String)"BAZ", (String)((String)((UniqueConstraint)uniqueConstraints.next()).columnNames().next()));
        JavaTableGeneratorTests.assertEquals((String)"FOO", (String)((String)((UniqueConstraint)uniqueConstraints.next()).columnNames().next()));
        ListIterator uniqueConstraintAnnotations = tableGeneratorAnnotation.uniqueConstraints();
        JavaTableGeneratorTests.assertEquals((String)"BAR", (String)((String)((UniqueConstraintAnnotation)uniqueConstraintAnnotations.next()).columnNames().next()));
        JavaTableGeneratorTests.assertEquals((String)"BAZ", (String)((String)((UniqueConstraintAnnotation)uniqueConstraintAnnotations.next()).columnNames().next()));
        JavaTableGeneratorTests.assertEquals((String)"FOO", (String)((String)((UniqueConstraintAnnotation)uniqueConstraintAnnotations.next()).columnNames().next()));
        tableGenerator.moveUniqueConstraint(0, 1);
        uniqueConstraints = tableGenerator.uniqueConstraints();
        JavaTableGeneratorTests.assertEquals((String)"BAZ", (String)((String)((UniqueConstraint)uniqueConstraints.next()).columnNames().next()));
        JavaTableGeneratorTests.assertEquals((String)"BAR", (String)((String)((UniqueConstraint)uniqueConstraints.next()).columnNames().next()));
        JavaTableGeneratorTests.assertEquals((String)"FOO", (String)((String)((UniqueConstraint)uniqueConstraints.next()).columnNames().next()));
        uniqueConstraintAnnotations = tableGeneratorAnnotation.uniqueConstraints();
        JavaTableGeneratorTests.assertEquals((String)"BAZ", (String)((String)((UniqueConstraintAnnotation)uniqueConstraintAnnotations.next()).columnNames().next()));
        JavaTableGeneratorTests.assertEquals((String)"BAR", (String)((String)((UniqueConstraintAnnotation)uniqueConstraintAnnotations.next()).columnNames().next()));
        JavaTableGeneratorTests.assertEquals((String)"FOO", (String)((String)((UniqueConstraintAnnotation)uniqueConstraintAnnotations.next()).columnNames().next()));
    }

    public void testUpdateUniqueConstraints() throws Exception {
        this.createTestEntityWithTableGenerator();
        this.addXmlClassRef("test.AnnotationTestType");
        TableGenerator tableGenerator = ((IdMapping)this.getJavaPersistentType().getAttributeNamed("id").getMapping()).getGeneratorContainer().getTableGenerator();
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        TableGeneratorAnnotation tableGeneratorAnnotation = (TableGeneratorAnnotation)attributeResource.getAnnotation("javax.persistence.TableGenerator");
        tableGeneratorAnnotation.addUniqueConstraint(0).addColumnName("FOO");
        tableGeneratorAnnotation.addUniqueConstraint(1).addColumnName("BAR");
        tableGeneratorAnnotation.addUniqueConstraint(2).addColumnName("BAZ");
        this.getJpaProject().synchronizeContextModel();
        ListIterator uniqueConstraints = tableGenerator.uniqueConstraints();
        JavaTableGeneratorTests.assertEquals((String)"FOO", (String)((String)((UniqueConstraint)uniqueConstraints.next()).columnNames().next()));
        JavaTableGeneratorTests.assertEquals((String)"BAR", (String)((String)((UniqueConstraint)uniqueConstraints.next()).columnNames().next()));
        JavaTableGeneratorTests.assertEquals((String)"BAZ", (String)((String)((UniqueConstraint)uniqueConstraints.next()).columnNames().next()));
        JavaTableGeneratorTests.assertFalse((boolean)uniqueConstraints.hasNext());
        tableGeneratorAnnotation.moveUniqueConstraint(2, 0);
        this.getJpaProject().synchronizeContextModel();
        uniqueConstraints = tableGenerator.uniqueConstraints();
        JavaTableGeneratorTests.assertEquals((String)"BAR", (String)((String)((UniqueConstraint)uniqueConstraints.next()).columnNames().next()));
        JavaTableGeneratorTests.assertEquals((String)"BAZ", (String)((String)((UniqueConstraint)uniqueConstraints.next()).columnNames().next()));
        JavaTableGeneratorTests.assertEquals((String)"FOO", (String)((String)((UniqueConstraint)uniqueConstraints.next()).columnNames().next()));
        JavaTableGeneratorTests.assertFalse((boolean)uniqueConstraints.hasNext());
        tableGeneratorAnnotation.moveUniqueConstraint(0, 1);
        this.getJpaProject().synchronizeContextModel();
        uniqueConstraints = tableGenerator.uniqueConstraints();
        JavaTableGeneratorTests.assertEquals((String)"BAZ", (String)((String)((UniqueConstraint)uniqueConstraints.next()).columnNames().next()));
        JavaTableGeneratorTests.assertEquals((String)"BAR", (String)((String)((UniqueConstraint)uniqueConstraints.next()).columnNames().next()));
        JavaTableGeneratorTests.assertEquals((String)"FOO", (String)((String)((UniqueConstraint)uniqueConstraints.next()).columnNames().next()));
        JavaTableGeneratorTests.assertFalse((boolean)uniqueConstraints.hasNext());
        tableGeneratorAnnotation.removeUniqueConstraint(1);
        this.getJpaProject().synchronizeContextModel();
        uniqueConstraints = tableGenerator.uniqueConstraints();
        JavaTableGeneratorTests.assertEquals((String)"BAZ", (String)((String)((UniqueConstraint)uniqueConstraints.next()).columnNames().next()));
        JavaTableGeneratorTests.assertEquals((String)"FOO", (String)((String)((UniqueConstraint)uniqueConstraints.next()).columnNames().next()));
        JavaTableGeneratorTests.assertFalse((boolean)uniqueConstraints.hasNext());
        tableGeneratorAnnotation.removeUniqueConstraint(1);
        this.getJpaProject().synchronizeContextModel();
        uniqueConstraints = tableGenerator.uniqueConstraints();
        JavaTableGeneratorTests.assertEquals((String)"BAZ", (String)((String)((UniqueConstraint)uniqueConstraints.next()).columnNames().next()));
        JavaTableGeneratorTests.assertFalse((boolean)uniqueConstraints.hasNext());
        tableGeneratorAnnotation.removeUniqueConstraint(0);
        this.getJpaProject().synchronizeContextModel();
        uniqueConstraints = tableGenerator.uniqueConstraints();
        JavaTableGeneratorTests.assertFalse((boolean)uniqueConstraints.hasNext());
    }
}

