/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.tests.internal.context.orm;

import java.util.Iterator;
import java.util.ListIterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.core.MappingKeys;
import org.eclipse.jpt.core.context.AccessType;
import org.eclipse.jpt.core.context.BasicMapping;
import org.eclipse.jpt.core.context.IdMapping;
import org.eclipse.jpt.core.context.java.JavaPersistentAttribute;
import org.eclipse.jpt.core.context.java.JavaPersistentType;
import org.eclipse.jpt.core.context.orm.OrmPersistentAttribute;
import org.eclipse.jpt.core.context.orm.OrmPersistentType;
import org.eclipse.jpt.core.internal.jpa1.context.orm.GenericOrmIdMapping;
import org.eclipse.jpt.core.internal.jpa1.context.orm.GenericOrmNullAttributeMapping;
import org.eclipse.jpt.core.internal.jpa1.context.orm.GenericOrmOneToOneMapping;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentAttribute;
import org.eclipse.jpt.core.resource.persistence.PersistenceFactory;
import org.eclipse.jpt.core.resource.persistence.XmlMappingFileRef;
import org.eclipse.jpt.core.tests.internal.context.ContextModelTestCase;
import org.eclipse.jpt.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.utility.internal.iterators.ArrayIterator;

public class GenericOrmPersistentAttributeTests
extends ContextModelTestCase {
    public GenericOrmPersistentAttributeTests(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        XmlMappingFileRef mappingFileRef = PersistenceFactory.eINSTANCE.createXmlMappingFileRef();
        mappingFileRef.setFileName("META-INF/orm.xml");
        this.getXmlPersistenceUnit().getMappingFiles().add((Object)mappingFileRef);
        this.getPersistenceXmlResource().save(null);
    }

    private ICompilationUnit createTestTypeNullAttributeMapping() throws Exception {
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("    private Address address;").append(CR);
                sb.append(CR);
            }
        });
    }

    private ICompilationUnit createTestEntityIdMapping() throws Exception {
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.Id", "javax.persistence.Column"});
            }

            @Override
            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity");
            }

            @Override
            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@Id");
                sb.append("@Column(name=\"FOO\")");
            }
        });
    }

    private ICompilationUnit createTestEntityOneToOneMapping() throws Exception {
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.OneToOne"});
            }

            @Override
            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity");
            }

            @Override
            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@OneToOne");
                sb.append("    private Address address;");
            }
        });
    }

    public void testMakeSpecified() throws Exception {
        this.createTestType();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        GenericOrmPersistentAttributeTests.assertEquals((int)2, (int)ormPersistentType.virtualAttributesSize());
        OrmPersistentAttribute ormPersistentAttribute = (OrmPersistentAttribute)ormPersistentType.virtualAttributes().next();
        GenericOrmPersistentAttributeTests.assertEquals((String)"id", (String)ormPersistentAttribute.getName());
        GenericOrmPersistentAttributeTests.assertTrue((boolean)ormPersistentAttribute.isVirtual());
        ormPersistentAttribute.makeSpecified();
        GenericOrmPersistentAttributeTests.assertEquals((int)1, (int)ormPersistentType.virtualAttributesSize());
        GenericOrmPersistentAttributeTests.assertEquals((int)1, (int)ormPersistentType.specifiedAttributesSize());
        OrmPersistentAttribute specifiedOrmPersistentAttribute = (OrmPersistentAttribute)ormPersistentType.specifiedAttributes().next();
        GenericOrmPersistentAttributeTests.assertEquals((String)"id", (String)specifiedOrmPersistentAttribute.getName());
        GenericOrmPersistentAttributeTests.assertFalse((boolean)specifiedOrmPersistentAttribute.isVirtual());
        ormPersistentAttribute = (OrmPersistentAttribute)ormPersistentType.virtualAttributes().next();
        ormPersistentAttribute.makeSpecified();
        GenericOrmPersistentAttributeTests.assertEquals((int)0, (int)ormPersistentType.virtualAttributesSize());
        GenericOrmPersistentAttributeTests.assertEquals((int)2, (int)ormPersistentType.specifiedAttributesSize());
        ListIterator specifiedAttributes = ormPersistentType.specifiedAttributes();
        specifiedOrmPersistentAttribute = (OrmPersistentAttribute)specifiedAttributes.next();
        GenericOrmPersistentAttributeTests.assertEquals((String)"id", (String)specifiedOrmPersistentAttribute.getName());
        GenericOrmPersistentAttributeTests.assertFalse((boolean)specifiedOrmPersistentAttribute.isVirtual());
        specifiedOrmPersistentAttribute = (OrmPersistentAttribute)specifiedAttributes.next();
        GenericOrmPersistentAttributeTests.assertEquals((String)"name", (String)specifiedOrmPersistentAttribute.getName());
        GenericOrmPersistentAttributeTests.assertFalse((boolean)specifiedOrmPersistentAttribute.isVirtual());
    }

    public void testMakeSpecifiedMappingKey() throws Exception {
        this.createTestTypeNullAttributeMapping();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        GenericOrmPersistentAttributeTests.assertEquals((int)3, (int)ormPersistentType.virtualAttributesSize());
        OrmPersistentAttribute ormPersistentAttribute = (OrmPersistentAttribute)ormPersistentType.virtualAttributes().next();
        GenericOrmPersistentAttributeTests.assertEquals((String)"address", (String)ormPersistentAttribute.getName());
        GenericOrmPersistentAttributeTests.assertTrue((boolean)ormPersistentAttribute.isVirtual());
        GenericOrmPersistentAttributeTests.assertTrue((boolean)(ormPersistentAttribute.getMapping() instanceof GenericOrmNullAttributeMapping));
        ormPersistentAttribute.makeSpecified("oneToOne");
        GenericOrmPersistentAttributeTests.assertEquals((int)2, (int)ormPersistentType.virtualAttributesSize());
        GenericOrmPersistentAttributeTests.assertEquals((int)1, (int)ormPersistentType.specifiedAttributesSize());
        OrmPersistentAttribute specifiedOrmPersistentAttribute = (OrmPersistentAttribute)ormPersistentType.specifiedAttributes().next();
        GenericOrmPersistentAttributeTests.assertEquals((String)"address", (String)specifiedOrmPersistentAttribute.getName());
        GenericOrmPersistentAttributeTests.assertFalse((boolean)specifiedOrmPersistentAttribute.isVirtual());
        GenericOrmPersistentAttributeTests.assertTrue((boolean)(specifiedOrmPersistentAttribute.getMapping() instanceof GenericOrmOneToOneMapping));
        ormPersistentAttribute = (OrmPersistentAttribute)ormPersistentType.virtualAttributes().next();
        ormPersistentAttribute.makeSpecified("id");
        GenericOrmPersistentAttributeTests.assertEquals((int)1, (int)ormPersistentType.virtualAttributesSize());
        GenericOrmPersistentAttributeTests.assertEquals((int)2, (int)ormPersistentType.specifiedAttributesSize());
        ListIterator specifiedAttributes = ormPersistentType.specifiedAttributes();
        specifiedOrmPersistentAttribute = (OrmPersistentAttribute)specifiedAttributes.next();
        GenericOrmPersistentAttributeTests.assertEquals((String)"id", (String)specifiedOrmPersistentAttribute.getName());
        GenericOrmPersistentAttributeTests.assertFalse((boolean)specifiedOrmPersistentAttribute.isVirtual());
        GenericOrmPersistentAttributeTests.assertTrue((boolean)(specifiedOrmPersistentAttribute.getMapping() instanceof GenericOrmIdMapping));
        specifiedOrmPersistentAttribute = (OrmPersistentAttribute)specifiedAttributes.next();
        GenericOrmPersistentAttributeTests.assertEquals((String)"address", (String)specifiedOrmPersistentAttribute.getName());
        GenericOrmPersistentAttributeTests.assertFalse((boolean)specifiedOrmPersistentAttribute.isVirtual());
    }

    public void testMakeVirtual() throws Exception {
        this.createTestType();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        GenericOrmPersistentAttributeTests.assertEquals((int)2, (int)ormPersistentType.virtualAttributesSize());
        ((OrmPersistentAttribute)ormPersistentType.virtualAttributes().next()).makeSpecified();
        ((OrmPersistentAttribute)ormPersistentType.virtualAttributes().next()).makeSpecified();
        GenericOrmPersistentAttributeTests.assertEquals((int)0, (int)ormPersistentType.virtualAttributesSize());
        GenericOrmPersistentAttributeTests.assertEquals((int)2, (int)ormPersistentType.specifiedAttributesSize());
        OrmPersistentAttribute specifiedOrmPersistentAttribute = (OrmPersistentAttribute)ormPersistentType.specifiedAttributes().next();
        GenericOrmPersistentAttributeTests.assertEquals((String)"id", (String)specifiedOrmPersistentAttribute.getName());
        GenericOrmPersistentAttributeTests.assertFalse((boolean)specifiedOrmPersistentAttribute.isVirtual());
        specifiedOrmPersistentAttribute.makeVirtual();
        GenericOrmPersistentAttributeTests.assertEquals((int)1, (int)ormPersistentType.virtualAttributesSize());
        GenericOrmPersistentAttributeTests.assertEquals((int)1, (int)ormPersistentType.specifiedAttributesSize());
        specifiedOrmPersistentAttribute = (OrmPersistentAttribute)ormPersistentType.specifiedAttributes().next();
        specifiedOrmPersistentAttribute.makeVirtual();
        GenericOrmPersistentAttributeTests.assertEquals((int)2, (int)ormPersistentType.virtualAttributesSize());
        GenericOrmPersistentAttributeTests.assertEquals((int)0, (int)ormPersistentType.specifiedAttributesSize());
        ListIterator virtualAttributes = ormPersistentType.virtualAttributes();
        OrmPersistentAttribute virtualAttribute = (OrmPersistentAttribute)virtualAttributes.next();
        GenericOrmPersistentAttributeTests.assertEquals((String)"id", (String)virtualAttribute.getName());
        virtualAttribute = (OrmPersistentAttribute)virtualAttributes.next();
        GenericOrmPersistentAttributeTests.assertEquals((String)"name", (String)virtualAttribute.getName());
    }

    public void testMakeVirtualNoUnderlyingJavaAttribute() throws Exception {
        this.createTestType();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        GenericOrmPersistentAttributeTests.assertEquals((int)2, (int)ormPersistentType.virtualAttributesSize());
        ((OrmPersistentAttribute)ormPersistentType.virtualAttributes().next()).makeSpecified();
        ((OrmPersistentAttribute)ormPersistentType.virtualAttributes().next()).makeSpecified();
        ((OrmPersistentAttribute)ormPersistentType.specifiedAttributes().next()).getMapping().setName("noJavaAttribute");
        GenericOrmPersistentAttributeTests.assertEquals((int)1, (int)ormPersistentType.virtualAttributesSize());
        GenericOrmPersistentAttributeTests.assertEquals((int)2, (int)ormPersistentType.specifiedAttributesSize());
        OrmPersistentAttribute specifiedOrmPersistentAttribute = (OrmPersistentAttribute)ormPersistentType.specifiedAttributes().next();
        specifiedOrmPersistentAttribute.makeVirtual();
        GenericOrmPersistentAttributeTests.assertEquals((int)1, (int)ormPersistentType.virtualAttributesSize());
        GenericOrmPersistentAttributeTests.assertEquals((int)1, (int)ormPersistentType.specifiedAttributesSize());
        GenericOrmPersistentAttributeTests.assertEquals((String)"id", (String)((OrmPersistentAttribute)ormPersistentType.virtualAttributes().next()).getName());
        GenericOrmPersistentAttributeTests.assertEquals((String)"name", (String)((OrmPersistentAttribute)ormPersistentType.specifiedAttributes().next()).getName());
    }

    public void testVirtualMappingTypeWhenMetadataComplete() throws Exception {
        this.createTestEntityIdMapping();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentAttribute ormPersistentAttribute = (OrmPersistentAttribute)ormPersistentType.virtualAttributes().next();
        GenericOrmPersistentAttributeTests.assertEquals((String)"id", (String)ormPersistentAttribute.getName());
        GenericOrmPersistentAttributeTests.assertEquals((String)"id", (String)ormPersistentAttribute.getMappingKey());
        GenericOrmPersistentAttributeTests.assertEquals((String)"FOO", (String)((IdMapping)ormPersistentAttribute.getMapping()).getColumn().getName());
        ormPersistentType.getMapping().setSpecifiedMetadataComplete(Boolean.TRUE);
        ormPersistentAttribute = ormPersistentType.getAttributeNamed("id");
        GenericOrmPersistentAttributeTests.assertEquals((String)"id", (String)ormPersistentAttribute.getName());
        GenericOrmPersistentAttributeTests.assertEquals((String)"basic", (String)ormPersistentAttribute.getMappingKey());
        GenericOrmPersistentAttributeTests.assertEquals((String)"id", (String)((BasicMapping)ormPersistentAttribute.getMapping()).getColumn().getName());
    }

    public void testVirtualMappingTypeWhenMetadataComplete2() throws Exception {
        this.createTestEntityOneToOneMapping();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentAttribute ormPersistentAttribute = (OrmPersistentAttribute)ormPersistentType.virtualAttributes().next();
        GenericOrmPersistentAttributeTests.assertEquals((String)"address", (String)ormPersistentAttribute.getName());
        GenericOrmPersistentAttributeTests.assertEquals((String)"oneToOne", (String)ormPersistentAttribute.getMappingKey());
        ormPersistentType.getMapping().setSpecifiedMetadataComplete(Boolean.TRUE);
        ormPersistentAttribute = ormPersistentType.getAttributeNamed("address");
        GenericOrmPersistentAttributeTests.assertEquals((String)"address", (String)ormPersistentAttribute.getName());
        GenericOrmPersistentAttributeTests.assertEquals((String)MappingKeys.NULL_ATTRIBUTE_MAPPING_KEY, (String)ormPersistentAttribute.getMappingKey());
    }

    public void testGetJavaPersistentAttribute() throws Exception {
        this.createTestEntityIdMapping();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        JavaPersistentType javaPersistentType = ormPersistentType.getJavaPersistentType();
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.getAttributeNamed("id");
        JavaPersistentAttribute javaPersistentAttribute = javaPersistentType.getAttributeNamed("id");
        GenericOrmPersistentAttributeTests.assertTrue((boolean)ormPersistentAttribute.isVirtual());
        GenericOrmPersistentAttributeTests.assertNotSame((Object)javaPersistentAttribute, (Object)ormPersistentAttribute.getJavaPersistentAttribute());
        GenericOrmPersistentAttributeTests.assertEquals((Object)AccessType.FIELD, (Object)javaPersistentAttribute.getAccess());
        JavaResourcePersistentAttribute javaResourcePersistentAttribute = ormPersistentAttribute.getJavaPersistentAttribute().getResourcePersistentAttribute();
        GenericOrmPersistentAttributeTests.assertTrue((boolean)javaResourcePersistentAttribute.isField());
        GenericOrmPersistentAttributeTests.assertEquals((String)"id", (String)javaResourcePersistentAttribute.getName());
        GenericOrmPersistentAttributeTests.assertEquals(javaPersistentType.getResourcePersistentType().persistableFields().next(), (Object)javaResourcePersistentAttribute);
        ormPersistentAttribute.makeSpecified();
        ormPersistentAttribute = ormPersistentType.getAttributeNamed("id");
        GenericOrmPersistentAttributeTests.assertFalse((boolean)ormPersistentAttribute.isVirtual());
        GenericOrmPersistentAttributeTests.assertEquals((Object)javaPersistentAttribute, (Object)ormPersistentAttribute.getJavaPersistentAttribute());
        ormPersistentAttribute.makeVirtual();
        ormPersistentAttribute = ormPersistentType.getAttributeNamed("id");
        ormPersistentType.setSpecifiedAccess(AccessType.PROPERTY);
        GenericOrmPersistentAttributeTests.assertNotSame((Object)ormPersistentAttribute, (Object)ormPersistentType.getAttributeNamed("id"));
        ormPersistentAttribute = ormPersistentType.getAttributeNamed("id");
        GenericOrmPersistentAttributeTests.assertNotSame((Object)javaPersistentAttribute, (Object)ormPersistentAttribute.getJavaPersistentAttribute());
        GenericOrmPersistentAttributeTests.assertEquals((Object)AccessType.FIELD, (Object)javaPersistentAttribute.getAccess());
        GenericOrmPersistentAttributeTests.assertEquals((Object)AccessType.PROPERTY, (Object)ormPersistentAttribute.getJavaPersistentAttribute().getAccess());
        javaResourcePersistentAttribute = ormPersistentAttribute.getJavaPersistentAttribute().getResourcePersistentAttribute();
        GenericOrmPersistentAttributeTests.assertTrue((boolean)javaResourcePersistentAttribute.isProperty());
        GenericOrmPersistentAttributeTests.assertEquals((String)"id", (String)javaResourcePersistentAttribute.getName());
        GenericOrmPersistentAttributeTests.assertEquals(javaPersistentType.getResourcePersistentType().persistableProperties().next(), (Object)javaResourcePersistentAttribute);
        ormPersistentType.setSpecifiedAccess(null);
        ormPersistentAttribute = ormPersistentType.getAttributeNamed("id");
        ormPersistentAttribute.makeSpecified();
        ormPersistentAttribute = ormPersistentType.getAttributeNamed("id");
        ormPersistentAttribute.getMapping().setName("id2");
        GenericOrmPersistentAttributeTests.assertEquals(null, (Object)ormPersistentAttribute.getJavaPersistentAttribute());
        ormPersistentAttribute.getMapping().setName(null);
        GenericOrmPersistentAttributeTests.assertEquals(null, (Object)ormPersistentAttribute.getJavaPersistentAttribute());
        ormPersistentAttribute.getMapping().setName("id");
        GenericOrmPersistentAttributeTests.assertEquals((Object)javaPersistentAttribute, (Object)ormPersistentAttribute.getJavaPersistentAttribute());
        ormPersistentType.getMapping().setSpecifiedMetadataComplete(Boolean.TRUE);
        GenericOrmPersistentAttributeTests.assertEquals((Object)javaPersistentAttribute, (Object)ormPersistentAttribute.getJavaPersistentAttribute());
    }
}

