/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.tests.internal.context.orm;

import java.util.ListIterator;
import org.eclipse.jpt.core.context.AccessType;
import org.eclipse.jpt.core.context.orm.OrmEmbeddable;
import org.eclipse.jpt.core.context.orm.OrmEntity;
import org.eclipse.jpt.core.context.orm.OrmMappedSuperclass;
import org.eclipse.jpt.core.context.orm.OrmPersistentType;
import org.eclipse.jpt.core.resource.orm.OrmFactory;
import org.eclipse.jpt.core.resource.orm.XmlEmbeddable;
import org.eclipse.jpt.core.resource.orm.XmlEntity;
import org.eclipse.jpt.core.resource.orm.XmlMappedSuperclass;
import org.eclipse.jpt.core.resource.persistence.PersistenceFactory;
import org.eclipse.jpt.core.resource.persistence.XmlMappingFileRef;
import org.eclipse.jpt.core.tests.internal.context.ContextModelTestCase;

public class OrmEmbeddableTests
extends ContextModelTestCase {
    public OrmEmbeddableTests(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        XmlMappingFileRef mappingFileRef = PersistenceFactory.eINSTANCE.createXmlMappingFileRef();
        mappingFileRef.setFileName("META-INF/orm.xml");
        this.getXmlPersistenceUnit().getMappingFiles().add((Object)mappingFileRef);
        this.getPersistenceXmlResource().save(null);
    }

    public void testUpdateClass() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("embeddable", "model.Foo");
        OrmEmbeddable ormEmbeddable = (OrmEmbeddable)ormPersistentType.getMapping();
        XmlEmbeddable embeddableResource = (XmlEmbeddable)this.getXmlEntityMappings().getEmbeddables().get(0);
        OrmEmbeddableTests.assertEquals((String)"model.Foo", (String)ormEmbeddable.getClass_());
        OrmEmbeddableTests.assertEquals((String)"model.Foo", (String)embeddableResource.getClassName());
        embeddableResource.setClassName("com.Bar");
        OrmEmbeddableTests.assertEquals((String)"com.Bar", (String)ormEmbeddable.getClass_());
        OrmEmbeddableTests.assertEquals((String)"com.Bar", (String)embeddableResource.getClassName());
        embeddableResource.setClassName(null);
        OrmEmbeddableTests.assertNull((Object)ormEmbeddable.getClass_());
        OrmEmbeddableTests.assertNull((Object)embeddableResource.getClassName());
    }

    public void testModifyClass() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("embeddable", "model.Foo");
        OrmEmbeddable ormEmbeddable = (OrmEmbeddable)ormPersistentType.getMapping();
        XmlEmbeddable embeddableResource = (XmlEmbeddable)this.getXmlEntityMappings().getEmbeddables().get(0);
        OrmEmbeddableTests.assertEquals((String)"model.Foo", (String)ormEmbeddable.getClass_());
        OrmEmbeddableTests.assertEquals((String)"model.Foo", (String)embeddableResource.getClassName());
        ormEmbeddable.setClass("com.Bar");
        OrmEmbeddableTests.assertEquals((String)"com.Bar", (String)ormEmbeddable.getClass_());
        OrmEmbeddableTests.assertEquals((String)"com.Bar", (String)embeddableResource.getClassName());
        ormEmbeddable.setClass(null);
        OrmEmbeddableTests.assertNull((Object)ormEmbeddable.getClass_());
        OrmEmbeddableTests.assertNull((Object)embeddableResource.getClassName());
    }

    public void testUpdateSpecifiedAccess() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("embeddable", "model.Foo");
        XmlEmbeddable embeddableResource = (XmlEmbeddable)this.getXmlEntityMappings().getEmbeddables().get(0);
        OrmEmbeddableTests.assertNull((Object)ormPersistentType.getSpecifiedAccess());
        OrmEmbeddableTests.assertNull((Object)embeddableResource.getAccess());
        embeddableResource.setAccess(org.eclipse.jpt.core.resource.orm.AccessType.FIELD);
        OrmEmbeddableTests.assertEquals((Object)AccessType.FIELD, (Object)ormPersistentType.getSpecifiedAccess());
        OrmEmbeddableTests.assertEquals((Object)org.eclipse.jpt.core.resource.orm.AccessType.FIELD, (Object)embeddableResource.getAccess());
        embeddableResource.setAccess(null);
        OrmEmbeddableTests.assertNull((Object)ormPersistentType.getSpecifiedAccess());
        OrmEmbeddableTests.assertNull((Object)embeddableResource.getAccess());
    }

    public void testModifySpecifiedAccess() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("embeddable", "model.Foo");
        XmlEmbeddable embeddableResource = (XmlEmbeddable)this.getXmlEntityMappings().getEmbeddables().get(0);
        OrmEmbeddableTests.assertNull((Object)ormPersistentType.getSpecifiedAccess());
        OrmEmbeddableTests.assertNull((Object)embeddableResource.getAccess());
        ormPersistentType.setSpecifiedAccess(AccessType.PROPERTY);
        OrmEmbeddableTests.assertEquals((Object)AccessType.PROPERTY, (Object)ormPersistentType.getSpecifiedAccess());
        OrmEmbeddableTests.assertEquals((Object)org.eclipse.jpt.core.resource.orm.AccessType.PROPERTY, (Object)embeddableResource.getAccess());
        ormPersistentType.setSpecifiedAccess(null);
        OrmEmbeddableTests.assertNull((Object)ormPersistentType.getSpecifiedAccess());
        OrmEmbeddableTests.assertNull((Object)embeddableResource.getAccess());
    }

    public void testUpdateSpecifiedMetadataComplete() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("embeddable", "model.Foo");
        OrmEmbeddable ormEmbeddable = (OrmEmbeddable)ormPersistentType.getMapping();
        XmlEmbeddable embeddableResource = (XmlEmbeddable)this.getXmlEntityMappings().getEmbeddables().get(0);
        OrmEmbeddableTests.assertNull((Object)embeddableResource.getMetadataComplete());
        embeddableResource.setMetadataComplete(Boolean.TRUE);
        OrmEmbeddableTests.assertEquals((Object)Boolean.TRUE, (Object)ormEmbeddable.getSpecifiedMetadataComplete());
        OrmEmbeddableTests.assertEquals((Object)Boolean.TRUE, (Object)embeddableResource.getMetadataComplete());
        embeddableResource.setMetadataComplete(Boolean.FALSE);
        OrmEmbeddableTests.assertEquals((Object)Boolean.FALSE, (Object)ormEmbeddable.getSpecifiedMetadataComplete());
        OrmEmbeddableTests.assertEquals((Object)Boolean.FALSE, (Object)embeddableResource.getMetadataComplete());
        embeddableResource.setMetadataComplete(null);
        OrmEmbeddableTests.assertNull((Object)ormEmbeddable.getSpecifiedMetadataComplete());
        OrmEmbeddableTests.assertNull((Object)embeddableResource.getMetadataComplete());
    }

    public void testModifySpecifiedMetadataComplete() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("embeddable", "model.Foo");
        OrmEmbeddable ormEmbeddable = (OrmEmbeddable)ormPersistentType.getMapping();
        XmlEmbeddable embeddableResource = (XmlEmbeddable)this.getXmlEntityMappings().getEmbeddables().get(0);
        OrmEmbeddableTests.assertNull((Object)embeddableResource.getMetadataComplete());
        ormEmbeddable.setSpecifiedMetadataComplete(Boolean.TRUE);
        OrmEmbeddableTests.assertEquals((Object)Boolean.TRUE, (Object)ormEmbeddable.getSpecifiedMetadataComplete());
        OrmEmbeddableTests.assertEquals((Object)Boolean.TRUE, (Object)embeddableResource.getMetadataComplete());
        ormEmbeddable.setSpecifiedMetadataComplete(Boolean.FALSE);
        OrmEmbeddableTests.assertEquals((Object)Boolean.FALSE, (Object)ormEmbeddable.getSpecifiedMetadataComplete());
        OrmEmbeddableTests.assertEquals((Object)Boolean.FALSE, (Object)embeddableResource.getMetadataComplete());
        ormEmbeddable.setSpecifiedMetadataComplete(null);
        OrmEmbeddableTests.assertNull((Object)ormEmbeddable.getSpecifiedMetadataComplete());
        OrmEmbeddableTests.assertNull((Object)embeddableResource.getMetadataComplete());
    }

    public void testUpdateDefaultMetadataComplete() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("embeddable", "model.Foo");
        OrmEmbeddable ormEmbeddable = (OrmEmbeddable)ormPersistentType.getMapping();
        XmlEmbeddable embeddableResource = (XmlEmbeddable)this.getXmlEntityMappings().getEmbeddables().get(0);
        OrmEmbeddableTests.assertNull((Object)ormEmbeddable.getSpecifiedMetadataComplete());
        OrmEmbeddableTests.assertFalse((boolean)ormEmbeddable.isDefaultMetadataComplete());
        OrmEmbeddableTests.assertNull((Object)embeddableResource.getMetadataComplete());
        this.getXmlEntityMappings().setPersistenceUnitMetadata(OrmFactory.eINSTANCE.createXmlPersistenceUnitMetadata());
        this.getXmlEntityMappings().getPersistenceUnitMetadata().setXmlMappingMetadataComplete(true);
        OrmEmbeddableTests.assertTrue((boolean)ormEmbeddable.isDefaultMetadataComplete());
        OrmEmbeddableTests.assertNull((Object)ormEmbeddable.getSpecifiedMetadataComplete());
        OrmEmbeddableTests.assertNull((Object)embeddableResource.getMetadataComplete());
        this.getXmlEntityMappings().getPersistenceUnitMetadata().setXmlMappingMetadataComplete(false);
        OrmEmbeddableTests.assertNull((Object)ormEmbeddable.getSpecifiedMetadataComplete());
        OrmEmbeddableTests.assertFalse((boolean)ormEmbeddable.isDefaultMetadataComplete());
        OrmEmbeddableTests.assertNull((Object)embeddableResource.getMetadataComplete());
    }

    public void testUpdateMetadataComplete() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("embeddable", "model.Foo");
        OrmEmbeddable ormEmbeddable = (OrmEmbeddable)ormPersistentType.getMapping();
        XmlEmbeddable embeddableResource = (XmlEmbeddable)this.getXmlEntityMappings().getEmbeddables().get(0);
        OrmEmbeddableTests.assertNull((Object)ormEmbeddable.getSpecifiedMetadataComplete());
        OrmEmbeddableTests.assertFalse((boolean)ormEmbeddable.isMetadataComplete());
        OrmEmbeddableTests.assertNull((Object)embeddableResource.getMetadataComplete());
        this.getXmlEntityMappings().setPersistenceUnitMetadata(OrmFactory.eINSTANCE.createXmlPersistenceUnitMetadata());
        this.getXmlEntityMappings().getPersistenceUnitMetadata().setXmlMappingMetadataComplete(true);
        OrmEmbeddableTests.assertTrue((boolean)ormEmbeddable.isMetadataComplete());
        OrmEmbeddableTests.assertNull((Object)ormEmbeddable.getSpecifiedMetadataComplete());
        OrmEmbeddableTests.assertNull((Object)embeddableResource.getMetadataComplete());
        this.getXmlEntityMappings().getPersistenceUnitMetadata().setXmlMappingMetadataComplete(false);
        OrmEmbeddableTests.assertFalse((boolean)ormEmbeddable.isMetadataComplete());
        OrmEmbeddableTests.assertNull((Object)ormEmbeddable.getSpecifiedMetadataComplete());
        OrmEmbeddableTests.assertNull((Object)embeddableResource.getMetadataComplete());
    }

    public void testMakeEmbeddableEntity() throws Exception {
        OrmPersistentType embeddablePersistentType = this.getEntityMappings().addPersistentType("embeddable", "model.Foo");
        OrmEmbeddable embeddable = (OrmEmbeddable)embeddablePersistentType.getMapping();
        embeddablePersistentType.setSpecifiedAccess(AccessType.PROPERTY);
        embeddable.setSpecifiedMetadataComplete(Boolean.TRUE);
        embeddablePersistentType.setMappingKey("entity");
        XmlEntity entity = (XmlEntity)this.getXmlEntityMappings().getEntities().get(0);
        OrmEmbeddableTests.assertEquals((String)"model.Foo", (String)entity.getClassName());
        OrmEmbeddableTests.assertEquals((Object)Boolean.TRUE, (Object)entity.getMetadataComplete());
        OrmEmbeddableTests.assertEquals((Object)org.eclipse.jpt.core.resource.orm.AccessType.PROPERTY, (Object)entity.getAccess());
        OrmEmbeddableTests.assertNull((Object)entity.getDiscriminatorValue());
        OrmEmbeddableTests.assertNull((Object)entity.getName());
        OrmEntity ormEntity = (OrmEntity)embeddablePersistentType.getMapping();
        OrmEmbeddableTests.assertEquals((String)"model.Foo", (String)ormEntity.getClass_());
        OrmEmbeddableTests.assertEquals((Object)Boolean.TRUE, (Object)ormEntity.getSpecifiedMetadataComplete());
        OrmEmbeddableTests.assertEquals((Object)AccessType.PROPERTY, (Object)embeddablePersistentType.getSpecifiedAccess());
    }

    public void testMakeEmbeddableEntity2() throws Exception {
        this.getEntityMappings().addPersistentType("embeddable", "model.Foo2");
        OrmPersistentType embeddablePersistentType = this.getEntityMappings().addPersistentType("embeddable", "model.Foo");
        OrmEmbeddable embeddable = (OrmEmbeddable)embeddablePersistentType.getMapping();
        embeddablePersistentType.setSpecifiedAccess(AccessType.PROPERTY);
        embeddable.setSpecifiedMetadataComplete(Boolean.TRUE);
        embeddablePersistentType.setMappingKey("entity");
        XmlEntity entity = (XmlEntity)this.getXmlEntityMappings().getEntities().get(0);
        OrmEmbeddableTests.assertEquals((String)"model.Foo", (String)entity.getClassName());
        OrmEmbeddableTests.assertEquals((Object)Boolean.TRUE, (Object)entity.getMetadataComplete());
        OrmEmbeddableTests.assertEquals((Object)org.eclipse.jpt.core.resource.orm.AccessType.PROPERTY, (Object)entity.getAccess());
        OrmEmbeddableTests.assertNull((Object)entity.getDiscriminatorValue());
        OrmEmbeddableTests.assertNull((Object)entity.getName());
        OrmEntity ormEntity = (OrmEntity)embeddablePersistentType.getMapping();
        OrmEmbeddableTests.assertEquals((String)"model.Foo", (String)ormEntity.getClass_());
        OrmEmbeddableTests.assertEquals((Object)Boolean.TRUE, (Object)ormEntity.getSpecifiedMetadataComplete());
        OrmEmbeddableTests.assertEquals((Object)AccessType.PROPERTY, (Object)embeddablePersistentType.getSpecifiedAccess());
        ListIterator persistentTypes = this.getEntityMappings().getPersistentTypes().iterator();
        OrmEmbeddableTests.assertEquals((String)"entity", (String)((OrmPersistentType)persistentTypes.next()).getMappingKey());
        OrmEmbeddableTests.assertEquals((String)"embeddable", (String)((OrmPersistentType)persistentTypes.next()).getMappingKey());
    }

    public void testMakeEmbeddableMappedSuperclass() throws Exception {
        OrmPersistentType embeddablePersistentType = this.getEntityMappings().addPersistentType("embeddable", "model.Foo");
        OrmEmbeddable embeddable = (OrmEmbeddable)embeddablePersistentType.getMapping();
        embeddablePersistentType.setSpecifiedAccess(AccessType.PROPERTY);
        embeddable.setSpecifiedMetadataComplete(Boolean.TRUE);
        embeddablePersistentType.setMappingKey("mappedSuperclass");
        XmlMappedSuperclass mappedSuperclass = (XmlMappedSuperclass)this.getXmlEntityMappings().getMappedSuperclasses().get(0);
        OrmEmbeddableTests.assertEquals((String)"model.Foo", (String)mappedSuperclass.getClassName());
        OrmEmbeddableTests.assertEquals((Object)Boolean.TRUE, (Object)mappedSuperclass.getMetadataComplete());
        OrmEmbeddableTests.assertEquals((Object)org.eclipse.jpt.core.resource.orm.AccessType.PROPERTY, (Object)mappedSuperclass.getAccess());
        OrmMappedSuperclass ormMappedSuperclass = (OrmMappedSuperclass)embeddablePersistentType.getMapping();
        OrmEmbeddableTests.assertEquals((String)"model.Foo", (String)ormMappedSuperclass.getClass_());
        OrmEmbeddableTests.assertEquals((Object)Boolean.TRUE, (Object)ormMappedSuperclass.getSpecifiedMetadataComplete());
        OrmEmbeddableTests.assertEquals((Object)AccessType.PROPERTY, (Object)embeddablePersistentType.getSpecifiedAccess());
    }

    public void testMakeEmbeddableMappedSuperclass2() throws Exception {
        this.getEntityMappings().addPersistentType("embeddable", "model.Foo2");
        OrmPersistentType embeddablePersistentType = this.getEntityMappings().addPersistentType("embeddable", "model.Foo");
        OrmEmbeddable embeddable = (OrmEmbeddable)embeddablePersistentType.getMapping();
        embeddablePersistentType.setSpecifiedAccess(AccessType.PROPERTY);
        embeddable.setSpecifiedMetadataComplete(Boolean.TRUE);
        embeddablePersistentType.setMappingKey("mappedSuperclass");
        XmlMappedSuperclass mappedSuperclass = (XmlMappedSuperclass)this.getXmlEntityMappings().getMappedSuperclasses().get(0);
        OrmEmbeddableTests.assertEquals((String)"model.Foo", (String)mappedSuperclass.getClassName());
        OrmEmbeddableTests.assertEquals((Object)Boolean.TRUE, (Object)mappedSuperclass.getMetadataComplete());
        OrmEmbeddableTests.assertEquals((Object)org.eclipse.jpt.core.resource.orm.AccessType.PROPERTY, (Object)mappedSuperclass.getAccess());
        OrmMappedSuperclass ormMappedSuperclass = (OrmMappedSuperclass)embeddablePersistentType.getMapping();
        OrmEmbeddableTests.assertEquals((String)"model.Foo", (String)ormMappedSuperclass.getClass_());
        OrmEmbeddableTests.assertEquals((Object)Boolean.TRUE, (Object)ormMappedSuperclass.getSpecifiedMetadataComplete());
        OrmEmbeddableTests.assertEquals((Object)AccessType.PROPERTY, (Object)embeddablePersistentType.getSpecifiedAccess());
        ListIterator persistentTypes = this.getEntityMappings().getPersistentTypes().iterator();
        OrmEmbeddableTests.assertEquals((String)"mappedSuperclass", (String)((OrmPersistentType)persistentTypes.next()).getMappingKey());
        OrmEmbeddableTests.assertEquals((String)"embeddable", (String)((OrmPersistentType)persistentTypes.next()).getMappingKey());
    }
}

