/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.tests.internal.context.orm;

import java.util.Iterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.core.MappingKeys;
import org.eclipse.jpt.core.context.AttributeMapping;
import org.eclipse.jpt.core.context.BasicMapping;
import org.eclipse.jpt.core.context.EmbeddedIdMapping;
import org.eclipse.jpt.core.context.EmbeddedMapping;
import org.eclipse.jpt.core.context.FetchType;
import org.eclipse.jpt.core.context.IdMapping;
import org.eclipse.jpt.core.context.JoinColumn;
import org.eclipse.jpt.core.context.JoinTable;
import org.eclipse.jpt.core.context.ManyToManyMapping;
import org.eclipse.jpt.core.context.ManyToOneMapping;
import org.eclipse.jpt.core.context.OneToManyMapping;
import org.eclipse.jpt.core.context.OneToOneMapping;
import org.eclipse.jpt.core.context.PersistentAttribute;
import org.eclipse.jpt.core.context.TransientMapping;
import org.eclipse.jpt.core.context.VersionMapping;
import org.eclipse.jpt.core.context.java.JavaOneToManyMapping;
import org.eclipse.jpt.core.context.orm.OrmMappedByJoiningStrategy;
import org.eclipse.jpt.core.context.orm.OrmOneToManyMapping;
import org.eclipse.jpt.core.context.orm.OrmOneToManyRelationshipReference;
import org.eclipse.jpt.core.context.orm.OrmPersistentAttribute;
import org.eclipse.jpt.core.context.orm.OrmPersistentType;
import org.eclipse.jpt.core.jpa2.context.orm.OrmCascade2_0;
import org.eclipse.jpt.core.resource.orm.OrmFactory;
import org.eclipse.jpt.core.resource.orm.XmlEntity;
import org.eclipse.jpt.core.resource.orm.XmlOneToMany;
import org.eclipse.jpt.core.resource.persistence.PersistenceFactory;
import org.eclipse.jpt.core.resource.persistence.XmlMappingFileRef;
import org.eclipse.jpt.core.tests.internal.context.ContextModelTestCase;
import org.eclipse.jpt.core.tests.internal.projects.TestJavaProject;
import org.eclipse.jpt.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.jpt.utility.internal.iterators.ArrayIterator;

public class OrmOneToManyMappingTests
extends ContextModelTestCase {
    public OrmOneToManyMappingTests(String name) {
        super(name);
    }

    private void createTestTargetEntityAddress() throws Exception {
        TestJavaProject.SourceWriter sourceWriter = new TestJavaProject.SourceWriter(){

            public void appendSourceTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Entity");
                sb.append(";");
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Id");
                sb.append(";");
                sb.append(CR);
                sb.append(CR);
                sb.append("@Entity");
                sb.append(CR);
                sb.append("public class ").append("Address").append(" ");
                sb.append("{").append(CR);
                sb.append(CR);
                sb.append("    @Id").append(CR);
                sb.append("    private int id;").append(CR);
                sb.append(CR);
                sb.append("    private String city;").append(CR);
                sb.append(CR);
                sb.append("    private State state;").append(CR);
                sb.append(CR);
                sb.append("    private int zip;").append(CR);
                sb.append(CR);
                sb.append("}").append(CR);
            }
        };
        this.javaProject.createCompilationUnit("test", "Address.java", sourceWriter);
    }

    private void createTestEntityWithOneToManyMapping() throws Exception {
        this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.OneToMany"});
            }

            @Override
            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }

            @Override
            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@OneToMany").append(CR);
            }
        });
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        for (OrmPersistentAttribute each : CollectionTools.iterable((Iterator)ormPersistentType.attributes())) {
            each.makeSpecified();
        }
    }

    private ICompilationUnit createTestEntityWithValidOneToManyMapping() throws Exception {
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.OneToMany", "javax.persistence.Id"});
            }

            @Override
            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }

            @Override
            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("    @OneToMany").append(CR);
                sb.append("    private java.util.Collection<Address> addresses;").append(CR);
                sb.append(CR);
                sb.append("    @Id").append(CR);
            }
        });
    }

    private ICompilationUnit createTestEntityWithValidMapOneToManyMapping() throws Exception {
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.OneToMany", "javax.persistence.Id"});
            }

            @Override
            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }

            @Override
            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("    @OneToMany").append(CR);
                sb.append("    private java.util.Map<String, Address> addresses;").append(CR);
                sb.append(CR);
                sb.append("    @Id").append(CR);
            }
        });
    }

    private ICompilationUnit createTestEntityWithValidNonGenericMapOneToManyMapping() throws Exception {
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.OneToMany", "javax.persistence.Id"});
            }

            @Override
            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }

            @Override
            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("    @OneToMany").append(CR);
                sb.append("    private java.util.Map addresses;").append(CR);
                sb.append(CR);
                sb.append("    @Id").append(CR);
            }
        });
    }

    private void createTestEmbeddableState() throws Exception {
        TestJavaProject.SourceWriter sourceWriter = new TestJavaProject.SourceWriter(){

            public void appendSourceTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Embeddable");
                sb.append(";");
                sb.append(CR);
                sb.append("@Embeddable");
                sb.append(CR);
                sb.append("public class ").append("State").append(" ");
                sb.append("{").append(CR);
                sb.append(CR);
                sb.append("    private String name;").append(CR);
                sb.append(CR);
                sb.append("    private String abbr;").append(CR);
                sb.append(CR);
                sb.append("}").append(CR);
            }
        };
        this.javaProject.createCompilationUnit("test", "State.java", sourceWriter);
    }

    private ICompilationUnit createTestEntityOneToManyMapping() throws Exception {
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.OneToMany", "javax.persistence.FetchType", "javax.persistence.CascadeType", "javax.persistence.OrderBy"});
            }

            @Override
            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity");
            }

            @Override
            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("    @OneToMany(fetch=FetchType.EAGER, targetEntity=Address.class, cascade={CascadeType.ALL, CascadeType.PERSIST, CascadeType.MERGE, CascadeType.REMOVE, CascadeType.REFRESH})");
                sb.append(CR);
                sb.append("    @OrderBy(\"city\"");
                sb.append(CR);
                sb.append("    private java.util.Collection<Address> address;").append(CR);
                sb.append(CR);
                sb.append("    @Id");
            }
        });
    }

    protected void setUp() throws Exception {
        super.setUp();
        XmlMappingFileRef mappingFileRef = PersistenceFactory.eINSTANCE.createXmlMappingFileRef();
        mappingFileRef.setFileName("META-INF/orm.xml");
        this.getXmlPersistenceUnit().getMappingFiles().add((Object)mappingFileRef);
        this.getPersistenceXmlResource().save(null);
    }

    public void testUpdateName() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "model.Foo");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("oneToMany", "oneToManyMapping");
        OrmOneToManyMapping ormOneToManyMapping = (OrmOneToManyMapping)ormPersistentAttribute.getMapping();
        XmlOneToMany oneToMany = (XmlOneToMany)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getOneToManys().get(0);
        OrmOneToManyMappingTests.assertEquals((String)"oneToManyMapping", (String)ormOneToManyMapping.getName());
        OrmOneToManyMappingTests.assertEquals((String)"oneToManyMapping", (String)oneToMany.getName());
        oneToMany.setName("newName");
        OrmOneToManyMappingTests.assertEquals((String)"newName", (String)ormOneToManyMapping.getName());
        OrmOneToManyMappingTests.assertEquals((String)"newName", (String)oneToMany.getName());
        oneToMany.setName(null);
        OrmOneToManyMappingTests.assertNull((Object)ormOneToManyMapping.getName());
        OrmOneToManyMappingTests.assertNull((Object)oneToMany.getName());
    }

    public void testModifyName() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "model.Foo");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("oneToMany", "oneToManyMapping");
        OrmOneToManyMapping ormOneToManyMapping = (OrmOneToManyMapping)ormPersistentAttribute.getMapping();
        XmlOneToMany oneToMany = (XmlOneToMany)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getOneToManys().get(0);
        OrmOneToManyMappingTests.assertEquals((String)"oneToManyMapping", (String)ormOneToManyMapping.getName());
        OrmOneToManyMappingTests.assertEquals((String)"oneToManyMapping", (String)oneToMany.getName());
        ormOneToManyMapping.setName("newName");
        OrmOneToManyMappingTests.assertEquals((String)"newName", (String)ormOneToManyMapping.getName());
        OrmOneToManyMappingTests.assertEquals((String)"newName", (String)oneToMany.getName());
        ormOneToManyMapping.setName(null);
        OrmOneToManyMappingTests.assertNull((Object)ormOneToManyMapping.getName());
        OrmOneToManyMappingTests.assertNull((Object)oneToMany.getName());
    }

    public void testUpdateTargetEntity() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "model.Foo");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("oneToMany", "oneToManyMapping");
        OrmOneToManyMapping ormOneToManyMapping = (OrmOneToManyMapping)ormPersistentAttribute.getMapping();
        XmlOneToMany oneToMany = (XmlOneToMany)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getOneToManys().get(0);
        OrmOneToManyMappingTests.assertNull((Object)ormOneToManyMapping.getSpecifiedTargetEntity());
        OrmOneToManyMappingTests.assertNull((Object)oneToMany.getTargetEntity());
        oneToMany.setTargetEntity("newTargetEntity");
        OrmOneToManyMappingTests.assertEquals((String)"newTargetEntity", (String)ormOneToManyMapping.getSpecifiedTargetEntity());
        OrmOneToManyMappingTests.assertEquals((String)"newTargetEntity", (String)oneToMany.getTargetEntity());
        oneToMany.setTargetEntity(null);
        OrmOneToManyMappingTests.assertNull((Object)ormOneToManyMapping.getSpecifiedTargetEntity());
        OrmOneToManyMappingTests.assertNull((Object)oneToMany.getTargetEntity());
    }

    public void testModifyTargetEntity() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "model.Foo");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("oneToMany", "oneToManyMapping");
        OrmOneToManyMapping ormOneToManyMapping = (OrmOneToManyMapping)ormPersistentAttribute.getMapping();
        XmlOneToMany oneToMany = (XmlOneToMany)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getOneToManys().get(0);
        OrmOneToManyMappingTests.assertNull((Object)ormOneToManyMapping.getSpecifiedTargetEntity());
        OrmOneToManyMappingTests.assertNull((Object)oneToMany.getTargetEntity());
        ormOneToManyMapping.setSpecifiedTargetEntity("newTargetEntity");
        OrmOneToManyMappingTests.assertEquals((String)"newTargetEntity", (String)ormOneToManyMapping.getSpecifiedTargetEntity());
        OrmOneToManyMappingTests.assertEquals((String)"newTargetEntity", (String)oneToMany.getTargetEntity());
        ormOneToManyMapping.setSpecifiedTargetEntity(null);
        OrmOneToManyMappingTests.assertNull((Object)ormOneToManyMapping.getSpecifiedTargetEntity());
        OrmOneToManyMappingTests.assertNull((Object)oneToMany.getTargetEntity());
    }

    public void testUpdateSpecifiedFetch() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "model.Foo");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("oneToMany", "oneToManyMapping");
        OrmOneToManyMapping ormOneToManyMapping = (OrmOneToManyMapping)ormPersistentAttribute.getMapping();
        XmlOneToMany oneToManyResource = (XmlOneToMany)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getOneToManys().get(0);
        OrmOneToManyMappingTests.assertNull((Object)ormOneToManyMapping.getSpecifiedFetch());
        OrmOneToManyMappingTests.assertNull((Object)oneToManyResource.getFetch());
        oneToManyResource.setFetch(org.eclipse.jpt.core.resource.orm.FetchType.EAGER);
        OrmOneToManyMappingTests.assertEquals((Object)FetchType.EAGER, (Object)ormOneToManyMapping.getSpecifiedFetch());
        OrmOneToManyMappingTests.assertEquals((Object)org.eclipse.jpt.core.resource.orm.FetchType.EAGER, (Object)oneToManyResource.getFetch());
        oneToManyResource.setFetch(org.eclipse.jpt.core.resource.orm.FetchType.LAZY);
        OrmOneToManyMappingTests.assertEquals((Object)FetchType.LAZY, (Object)ormOneToManyMapping.getSpecifiedFetch());
        OrmOneToManyMappingTests.assertEquals((Object)org.eclipse.jpt.core.resource.orm.FetchType.LAZY, (Object)oneToManyResource.getFetch());
        oneToManyResource.setFetch(null);
        OrmOneToManyMappingTests.assertNull((Object)ormOneToManyMapping.getSpecifiedFetch());
        OrmOneToManyMappingTests.assertNull((Object)oneToManyResource.getFetch());
    }

    public void testModifySpecifiedFetch() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "model.Foo");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("oneToMany", "oneToManyMapping");
        OrmOneToManyMapping ormOneToManyMapping = (OrmOneToManyMapping)ormPersistentAttribute.getMapping();
        XmlOneToMany oneToManyResource = (XmlOneToMany)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getOneToManys().get(0);
        OrmOneToManyMappingTests.assertNull((Object)ormOneToManyMapping.getSpecifiedFetch());
        OrmOneToManyMappingTests.assertNull((Object)oneToManyResource.getFetch());
        ormOneToManyMapping.setSpecifiedFetch(FetchType.EAGER);
        OrmOneToManyMappingTests.assertEquals((Object)org.eclipse.jpt.core.resource.orm.FetchType.EAGER, (Object)oneToManyResource.getFetch());
        OrmOneToManyMappingTests.assertEquals((Object)FetchType.EAGER, (Object)ormOneToManyMapping.getSpecifiedFetch());
        ormOneToManyMapping.setSpecifiedFetch(FetchType.LAZY);
        OrmOneToManyMappingTests.assertEquals((Object)org.eclipse.jpt.core.resource.orm.FetchType.LAZY, (Object)oneToManyResource.getFetch());
        OrmOneToManyMappingTests.assertEquals((Object)FetchType.LAZY, (Object)ormOneToManyMapping.getSpecifiedFetch());
        ormOneToManyMapping.setSpecifiedFetch(null);
        OrmOneToManyMappingTests.assertNull((Object)oneToManyResource.getFetch());
        OrmOneToManyMappingTests.assertNull((Object)ormOneToManyMapping.getSpecifiedFetch());
    }

    public void testUpdateMappedBy() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "model.Foo");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("oneToMany", "oneToManyMapping");
        OrmOneToManyMapping ormOneToManyMapping = (OrmOneToManyMapping)ormPersistentAttribute.getMapping();
        OrmMappedByJoiningStrategy strategy = ormOneToManyMapping.getRelationshipReference().getMappedByJoiningStrategy();
        XmlOneToMany oneToMany = (XmlOneToMany)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getOneToManys().get(0);
        OrmOneToManyMappingTests.assertNull((Object)strategy.getMappedByAttribute());
        OrmOneToManyMappingTests.assertNull((Object)oneToMany.getMappedBy());
        oneToMany.setMappedBy("newMappedBy");
        OrmOneToManyMappingTests.assertEquals((String)"newMappedBy", (String)strategy.getMappedByAttribute());
        OrmOneToManyMappingTests.assertEquals((String)"newMappedBy", (String)oneToMany.getMappedBy());
        oneToMany.setMappedBy(null);
        OrmOneToManyMappingTests.assertNull((Object)strategy.getMappedByAttribute());
        OrmOneToManyMappingTests.assertNull((Object)oneToMany.getMappedBy());
    }

    public void testModifyMappedBy() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "model.Foo");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("oneToMany", "oneToManyMapping");
        OrmOneToManyMapping ormOneToManyMapping = (OrmOneToManyMapping)ormPersistentAttribute.getMapping();
        OrmMappedByJoiningStrategy strategy = ormOneToManyMapping.getRelationshipReference().getMappedByJoiningStrategy();
        XmlOneToMany oneToMany = (XmlOneToMany)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getOneToManys().get(0);
        OrmOneToManyMappingTests.assertNull((Object)strategy.getMappedByAttribute());
        OrmOneToManyMappingTests.assertNull((Object)oneToMany.getMappedBy());
        strategy.setMappedByAttribute("newMappedBy");
        OrmOneToManyMappingTests.assertEquals((String)"newMappedBy", (String)strategy.getMappedByAttribute());
        OrmOneToManyMappingTests.assertEquals((String)"newMappedBy", (String)oneToMany.getMappedBy());
        strategy.setMappedByAttribute(null);
        OrmOneToManyMappingTests.assertNull((Object)strategy.getMappedByAttribute());
        OrmOneToManyMappingTests.assertNull((Object)oneToMany.getMappedBy());
    }

    public void testModifyPredominantJoiningStrategy() throws Exception {
        this.createTestEntityWithOneToManyMapping();
        OrmPersistentType contextType = this.getEntityMappings().getPersistentType("test.AnnotationTestType");
        OrmPersistentAttribute contextAttribute = contextType.getAttributeNamed("id");
        OrmOneToManyMapping contextMapping = (OrmOneToManyMapping)contextAttribute.getMapping();
        OrmOneToManyRelationshipReference relationshipReference = contextMapping.getRelationshipReference();
        XmlEntity resourceEntity = (XmlEntity)contextType.getMapping().getResourceTypeMapping();
        XmlOneToMany resourceMapping = (XmlOneToMany)resourceEntity.getAttributes().getOneToManys().get(0);
        OrmOneToManyMappingTests.assertNull((Object)resourceMapping.getJoinTable());
        OrmOneToManyMappingTests.assertNull((Object)resourceMapping.getMappedBy());
        OrmOneToManyMappingTests.assertTrue((boolean)relationshipReference.usesJoinTableJoiningStrategy());
        OrmOneToManyMappingTests.assertFalse((boolean)relationshipReference.usesMappedByJoiningStrategy());
        relationshipReference.setMappedByJoiningStrategy();
        OrmOneToManyMappingTests.assertNull((Object)resourceMapping.getJoinTable());
        OrmOneToManyMappingTests.assertNotNull((Object)resourceMapping.getMappedBy());
        OrmOneToManyMappingTests.assertFalse((boolean)relationshipReference.usesJoinTableJoiningStrategy());
        OrmOneToManyMappingTests.assertTrue((boolean)relationshipReference.usesMappedByJoiningStrategy());
        relationshipReference.setJoinTableJoiningStrategy();
        OrmOneToManyMappingTests.assertNull((Object)resourceMapping.getJoinTable());
        OrmOneToManyMappingTests.assertNull((Object)resourceMapping.getMappedBy());
        OrmOneToManyMappingTests.assertTrue((boolean)relationshipReference.usesJoinTableJoiningStrategy());
        OrmOneToManyMappingTests.assertFalse((boolean)relationshipReference.usesMappedByJoiningStrategy());
    }

    public void testUpdatePredominantJoiningStrategy() throws Exception {
        this.createTestEntityWithOneToManyMapping();
        OrmPersistentType contextType = this.getEntityMappings().getPersistentType("test.AnnotationTestType");
        OrmPersistentAttribute contextAttribute = contextType.getAttributeNamed("id");
        OrmOneToManyMapping contextMapping = (OrmOneToManyMapping)contextAttribute.getMapping();
        OrmOneToManyRelationshipReference relationshipReference = contextMapping.getRelationshipReference();
        XmlEntity resourceEntity = (XmlEntity)contextType.getMapping().getResourceTypeMapping();
        XmlOneToMany resourceMapping = (XmlOneToMany)resourceEntity.getAttributes().getOneToManys().get(0);
        OrmOneToManyMappingTests.assertNull((Object)resourceMapping.getJoinTable());
        OrmOneToManyMappingTests.assertNull((Object)resourceMapping.getMappedBy());
        OrmOneToManyMappingTests.assertTrue((boolean)relationshipReference.usesJoinTableJoiningStrategy());
        OrmOneToManyMappingTests.assertFalse((boolean)relationshipReference.usesMappedByJoiningStrategy());
        resourceMapping.setMappedBy("foo");
        this.getJpaProject().synchronizeContextModel();
        OrmOneToManyMappingTests.assertNull((Object)resourceMapping.getJoinTable());
        OrmOneToManyMappingTests.assertNotNull((Object)resourceMapping.getMappedBy());
        OrmOneToManyMappingTests.assertFalse((boolean)relationshipReference.usesJoinTableJoiningStrategy());
        OrmOneToManyMappingTests.assertTrue((boolean)relationshipReference.usesMappedByJoiningStrategy());
        resourceMapping.setJoinTable(OrmFactory.eINSTANCE.createXmlJoinTable());
        this.getJpaProject().synchronizeContextModel();
        OrmOneToManyMappingTests.assertNotNull((Object)resourceMapping.getJoinTable());
        OrmOneToManyMappingTests.assertNotNull((Object)resourceMapping.getMappedBy());
        OrmOneToManyMappingTests.assertFalse((boolean)relationshipReference.usesJoinTableJoiningStrategy());
        OrmOneToManyMappingTests.assertTrue((boolean)relationshipReference.usesMappedByJoiningStrategy());
        resourceMapping.setMappedBy(null);
        this.getJpaProject().synchronizeContextModel();
        OrmOneToManyMappingTests.assertNotNull((Object)resourceMapping.getJoinTable());
        OrmOneToManyMappingTests.assertNull((Object)resourceMapping.getMappedBy());
        OrmOneToManyMappingTests.assertTrue((boolean)relationshipReference.usesJoinTableJoiningStrategy());
        OrmOneToManyMappingTests.assertFalse((boolean)relationshipReference.usesMappedByJoiningStrategy());
        resourceMapping.setJoinTable(null);
        this.getJpaProject().synchronizeContextModel();
        OrmOneToManyMappingTests.assertNull((Object)resourceMapping.getJoinTable());
        OrmOneToManyMappingTests.assertNull((Object)resourceMapping.getMappedBy());
        OrmOneToManyMappingTests.assertTrue((boolean)relationshipReference.usesJoinTableJoiningStrategy());
        OrmOneToManyMappingTests.assertFalse((boolean)relationshipReference.usesMappedByJoiningStrategy());
    }

    public void testUpdateMapKey() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "model.Foo");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("oneToMany", "oneToManyMapping");
        OrmOneToManyMapping ormOneToManyMapping = (OrmOneToManyMapping)ormPersistentAttribute.getMapping();
        XmlOneToMany oneToMany = (XmlOneToMany)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getOneToManys().get(0);
        OrmOneToManyMappingTests.assertNull((Object)ormOneToManyMapping.getSpecifiedMapKey());
        OrmOneToManyMappingTests.assertNull((Object)oneToMany.getMapKey());
        oneToMany.setMapKey(OrmFactory.eINSTANCE.createMapKey());
        OrmOneToManyMappingTests.assertNull((Object)ormOneToManyMapping.getSpecifiedMapKey());
        OrmOneToManyMappingTests.assertNotNull((Object)oneToMany.getMapKey());
        oneToMany.getMapKey().setName("myMapKey");
        OrmOneToManyMappingTests.assertEquals((String)"myMapKey", (String)ormOneToManyMapping.getSpecifiedMapKey());
        OrmOneToManyMappingTests.assertEquals((String)"myMapKey", (String)oneToMany.getMapKey().getName());
        oneToMany.getMapKey().setName(null);
        OrmOneToManyMappingTests.assertNull((Object)ormOneToManyMapping.getSpecifiedMapKey());
        OrmOneToManyMappingTests.assertNull((Object)oneToMany.getMapKey().getName());
        oneToMany.getMapKey().setName("myMapKey");
        oneToMany.setMapKey(null);
        OrmOneToManyMappingTests.assertNull((Object)ormOneToManyMapping.getSpecifiedMapKey());
        OrmOneToManyMappingTests.assertNull((Object)oneToMany.getMapKey());
    }

    public void testUpdateVirtualMapKey() throws Exception {
        this.createTestEntityWithValidMapOneToManyMapping();
        this.createTestTargetEntityAddress();
        this.createTestEmbeddableState();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        this.getEntityMappings().addPersistentType("entity", "test.Address");
        this.getEntityMappings().addPersistentType("embeddable", "test.State");
        OrmOneToManyMapping ormOneToManyMapping = (OrmOneToManyMapping)ormPersistentType.getAttributeNamed("addresses").getMapping();
        JavaOneToManyMapping javaOneToManyMapping = (JavaOneToManyMapping)ormPersistentType.getJavaPersistentType().getAttributeNamed("addresses").getMapping();
        OrmOneToManyMappingTests.assertNull((Object)ormOneToManyMapping.getSpecifiedMapKey());
        OrmOneToManyMappingTests.assertNull((Object)ormOneToManyMapping.getMapKey());
        OrmOneToManyMappingTests.assertFalse((boolean)ormOneToManyMapping.isPkMapKey());
        OrmOneToManyMappingTests.assertFalse((boolean)ormOneToManyMapping.isCustomMapKey());
        OrmOneToManyMappingTests.assertTrue((boolean)ormOneToManyMapping.isNoMapKey());
        javaOneToManyMapping.setPkMapKey(true);
        OrmOneToManyMappingTests.assertEquals((String)"id", (String)ormOneToManyMapping.getMapKey());
        OrmOneToManyMappingTests.assertTrue((boolean)ormOneToManyMapping.isPkMapKey());
        OrmOneToManyMappingTests.assertFalse((boolean)ormOneToManyMapping.isCustomMapKey());
        OrmOneToManyMappingTests.assertFalse((boolean)ormOneToManyMapping.isNoMapKey());
        javaOneToManyMapping.setCustomMapKey(true);
        javaOneToManyMapping.setSpecifiedMapKey("city");
        OrmOneToManyMappingTests.assertEquals((String)"city", (String)ormOneToManyMapping.getSpecifiedMapKey());
        OrmOneToManyMappingTests.assertEquals((String)"city", (String)ormOneToManyMapping.getMapKey());
        OrmOneToManyMappingTests.assertFalse((boolean)ormOneToManyMapping.isPkMapKey());
        OrmOneToManyMappingTests.assertTrue((boolean)ormOneToManyMapping.isCustomMapKey());
        OrmOneToManyMappingTests.assertFalse((boolean)ormOneToManyMapping.isNoMapKey());
    }

    public void testModifyMapKey() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "model.Foo");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("oneToMany", "oneToManyMapping");
        OrmOneToManyMapping ormOneToManyMapping = (OrmOneToManyMapping)ormPersistentAttribute.getMapping();
        XmlOneToMany oneToMany = (XmlOneToMany)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getOneToManys().get(0);
        OrmOneToManyMappingTests.assertNull((Object)ormOneToManyMapping.getSpecifiedMapKey());
        OrmOneToManyMappingTests.assertNull((Object)oneToMany.getMapKey());
        ormOneToManyMapping.setSpecifiedMapKey("myMapKey");
        OrmOneToManyMappingTests.assertEquals((String)"myMapKey", (String)ormOneToManyMapping.getSpecifiedMapKey());
        OrmOneToManyMappingTests.assertEquals((String)"myMapKey", (String)oneToMany.getMapKey().getName());
        ormOneToManyMapping.setSpecifiedMapKey(null);
        OrmOneToManyMappingTests.assertNull((Object)ormOneToManyMapping.getSpecifiedMapKey());
        OrmOneToManyMappingTests.assertNull((Object)oneToMany.getMapKey());
    }

    public void testUpdateOrderBy() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "model.Foo");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("oneToMany", "oneToManyMapping");
        OrmOneToManyMapping ormOneToManyMapping = (OrmOneToManyMapping)ormPersistentAttribute.getMapping();
        XmlOneToMany oneToMany = (XmlOneToMany)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getOneToManys().get(0);
        OrmOneToManyMappingTests.assertNull((Object)ormOneToManyMapping.getOrderable().getSpecifiedOrderBy());
        OrmOneToManyMappingTests.assertNull((Object)oneToMany.getOrderBy());
        oneToMany.setOrderBy("newOrderBy");
        OrmOneToManyMappingTests.assertEquals((String)"newOrderBy", (String)ormOneToManyMapping.getOrderable().getSpecifiedOrderBy());
        OrmOneToManyMappingTests.assertEquals((String)"newOrderBy", (String)oneToMany.getOrderBy());
        oneToMany.setOrderBy(null);
        OrmOneToManyMappingTests.assertNull((Object)ormOneToManyMapping.getOrderable().getSpecifiedOrderBy());
        OrmOneToManyMappingTests.assertNull((Object)oneToMany.getOrderBy());
    }

    public void testModifyOrderBy() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "model.Foo");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("oneToMany", "oneToManyMapping");
        OrmOneToManyMapping ormOneToManyMapping = (OrmOneToManyMapping)ormPersistentAttribute.getMapping();
        XmlOneToMany oneToMany = (XmlOneToMany)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getOneToManys().get(0);
        OrmOneToManyMappingTests.assertNull((Object)ormOneToManyMapping.getOrderable().getSpecifiedOrderBy());
        OrmOneToManyMappingTests.assertNull((Object)oneToMany.getOrderBy());
        ormOneToManyMapping.getOrderable().setSpecifiedOrderBy("newOrderBy");
        OrmOneToManyMappingTests.assertEquals((String)"newOrderBy", (String)ormOneToManyMapping.getOrderable().getSpecifiedOrderBy());
        OrmOneToManyMappingTests.assertEquals((String)"newOrderBy", (String)oneToMany.getOrderBy());
        ormOneToManyMapping.getOrderable().setSpecifiedOrderBy(null);
        OrmOneToManyMappingTests.assertNull((Object)ormOneToManyMapping.getOrderable().getSpecifiedOrderBy());
        OrmOneToManyMappingTests.assertNull((Object)oneToMany.getOrderBy());
    }

    public void testIsNoOrdering() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "model.Foo");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("oneToMany", "oneToManyMapping");
        OrmOneToManyMapping ormOneToManyMapping = (OrmOneToManyMapping)ormPersistentAttribute.getMapping();
        OrmOneToManyMappingTests.assertTrue((boolean)ormOneToManyMapping.getOrderable().isNoOrdering());
        ormOneToManyMapping.getOrderable().setSpecifiedOrderBy("foo");
        OrmOneToManyMappingTests.assertFalse((boolean)ormOneToManyMapping.getOrderable().isNoOrdering());
        ormOneToManyMapping.getOrderable().setSpecifiedOrderBy(null);
        OrmOneToManyMappingTests.assertTrue((boolean)ormOneToManyMapping.getOrderable().isNoOrdering());
    }

    public void testSetNoOrdering() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "model.Foo");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("oneToMany", "oneToManyMapping");
        OrmOneToManyMapping ormOneToManyMapping = (OrmOneToManyMapping)ormPersistentAttribute.getMapping();
        OrmOneToManyMappingTests.assertTrue((boolean)ormOneToManyMapping.getOrderable().isNoOrdering());
        ormOneToManyMapping.getOrderable().setSpecifiedOrderBy("foo");
        OrmOneToManyMappingTests.assertFalse((boolean)ormOneToManyMapping.getOrderable().isNoOrdering());
        ormOneToManyMapping.getOrderable().setNoOrdering(true);
        OrmOneToManyMappingTests.assertTrue((boolean)ormOneToManyMapping.getOrderable().isNoOrdering());
        OrmOneToManyMappingTests.assertNull((Object)ormOneToManyMapping.getOrderable().getSpecifiedOrderBy());
    }

    public void testIsCustomOrdering() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "model.Foo");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("oneToMany", "oneToManyMapping");
        OrmOneToManyMapping ormOneToManyMapping = (OrmOneToManyMapping)ormPersistentAttribute.getMapping();
        OrmOneToManyMappingTests.assertFalse((boolean)ormOneToManyMapping.getOrderable().isCustomOrdering());
        ormOneToManyMapping.getOrderable().setSpecifiedOrderBy("foo");
        OrmOneToManyMappingTests.assertTrue((boolean)ormOneToManyMapping.getOrderable().isCustomOrdering());
        ormOneToManyMapping.getOrderable().setSpecifiedOrderBy(null);
        OrmOneToManyMappingTests.assertFalse((boolean)ormOneToManyMapping.getOrderable().isCustomOrdering());
    }

    public void testOneToManyMorphToIdMapping() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("oneToMany", "oneToMany");
        OneToManyMapping oneToManyMapping = (OneToManyMapping)ormPersistentAttribute.getMapping();
        OrmOneToManyMappingTests.assertFalse((boolean)oneToManyMapping.isDefault());
        oneToManyMapping.setSpecifiedFetch(FetchType.EAGER);
        oneToManyMapping.setSpecifiedTargetEntity("TargetEntity");
        oneToManyMapping.getOrderable().setSpecifiedOrderBy("customOrder");
        oneToManyMapping.setSpecifiedMapKey("mapKey");
        oneToManyMapping.getRelationshipReference().getMappedByJoiningStrategy().setMappedByAttribute("mappedBy");
        OrmOneToManyMappingTests.assertFalse((boolean)oneToManyMapping.isDefault());
        ormPersistentAttribute.setSpecifiedMappingKey("id");
        OrmOneToManyMappingTests.assertEquals((int)1, (int)ormPersistentType.specifiedAttributesSize());
        OrmOneToManyMappingTests.assertEquals((Object)ormPersistentAttribute, ormPersistentType.specifiedAttributes().next());
        OrmOneToManyMappingTests.assertTrue((boolean)(ormPersistentAttribute.getMapping() instanceof IdMapping));
        OrmOneToManyMappingTests.assertEquals((String)"oneToMany", (String)ormPersistentAttribute.getMapping().getName());
    }

    public void testOneToManyMorphToVersionMapping() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("oneToMany", "oneToMany");
        OneToManyMapping oneToManyMapping = (OneToManyMapping)ormPersistentAttribute.getMapping();
        OrmOneToManyMappingTests.assertFalse((boolean)oneToManyMapping.isDefault());
        oneToManyMapping.setSpecifiedFetch(FetchType.EAGER);
        oneToManyMapping.setSpecifiedTargetEntity("TargetEntity");
        oneToManyMapping.getOrderable().setSpecifiedOrderBy("customOrder");
        oneToManyMapping.setSpecifiedMapKey("mapKey");
        oneToManyMapping.getRelationshipReference().getJoinTableJoiningStrategy().getJoinTable().setSpecifiedName("MY_JOIN_TABLE");
        JoinColumn joinColumn = oneToManyMapping.getRelationshipReference().getJoinTableJoiningStrategy().getJoinTable().addSpecifiedJoinColumn(0);
        joinColumn.setSpecifiedName("name");
        joinColumn.setSpecifiedReferencedColumnName("referenceName");
        JoinColumn inverseJoinColumn = oneToManyMapping.getRelationshipReference().getJoinTableJoiningStrategy().getJoinTable().addSpecifiedInverseJoinColumn(0);
        inverseJoinColumn.setSpecifiedName("inverseName");
        inverseJoinColumn.setSpecifiedReferencedColumnName("inverseReferenceName");
        OrmOneToManyMappingTests.assertFalse((boolean)oneToManyMapping.isDefault());
        ormPersistentAttribute.setSpecifiedMappingKey("version");
        OrmOneToManyMappingTests.assertEquals((int)1, (int)ormPersistentType.specifiedAttributesSize());
        OrmOneToManyMappingTests.assertEquals((Object)ormPersistentAttribute, ormPersistentType.specifiedAttributes().next());
        OrmOneToManyMappingTests.assertTrue((boolean)(ormPersistentAttribute.getMapping() instanceof VersionMapping));
        OrmOneToManyMappingTests.assertEquals((String)"oneToMany", (String)ormPersistentAttribute.getMapping().getName());
    }

    public void testOneToManyMorphToTransientMapping() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("oneToMany", "oneToMany");
        OneToManyMapping oneToManyMapping = (OneToManyMapping)ormPersistentAttribute.getMapping();
        OrmOneToManyMappingTests.assertFalse((boolean)oneToManyMapping.isDefault());
        oneToManyMapping.setSpecifiedFetch(FetchType.EAGER);
        oneToManyMapping.setSpecifiedTargetEntity("TargetEntity");
        oneToManyMapping.getOrderable().setSpecifiedOrderBy("customOrder");
        oneToManyMapping.setSpecifiedMapKey("mapKey");
        oneToManyMapping.getRelationshipReference().getMappedByJoiningStrategy().setMappedByAttribute("mappedBy");
        OrmOneToManyMappingTests.assertFalse((boolean)oneToManyMapping.isDefault());
        ormPersistentAttribute.setSpecifiedMappingKey("transient");
        OrmOneToManyMappingTests.assertEquals((int)1, (int)ormPersistentType.specifiedAttributesSize());
        OrmOneToManyMappingTests.assertEquals((Object)ormPersistentAttribute, ormPersistentType.specifiedAttributes().next());
        OrmOneToManyMappingTests.assertTrue((boolean)(ormPersistentAttribute.getMapping() instanceof TransientMapping));
        OrmOneToManyMappingTests.assertEquals((String)"oneToMany", (String)ormPersistentAttribute.getMapping().getName());
    }

    public void testOneToManyMorphToEmbeddedMapping() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("oneToMany", "oneToMany");
        OneToManyMapping oneToManyMapping = (OneToManyMapping)ormPersistentAttribute.getMapping();
        OrmOneToManyMappingTests.assertFalse((boolean)oneToManyMapping.isDefault());
        oneToManyMapping.setSpecifiedFetch(FetchType.EAGER);
        oneToManyMapping.setSpecifiedTargetEntity("TargetEntity");
        oneToManyMapping.getOrderable().setSpecifiedOrderBy("customOrder");
        oneToManyMapping.setSpecifiedMapKey("mapKey");
        oneToManyMapping.getRelationshipReference().getJoinTableJoiningStrategy().getJoinTable().setSpecifiedName("MY_JOIN_TABLE");
        JoinColumn joinColumn = oneToManyMapping.getRelationshipReference().getJoinTableJoiningStrategy().getJoinTable().addSpecifiedJoinColumn(0);
        joinColumn.setSpecifiedName("name");
        joinColumn.setSpecifiedReferencedColumnName("referenceName");
        JoinColumn inverseJoinColumn = oneToManyMapping.getRelationshipReference().getJoinTableJoiningStrategy().getJoinTable().addSpecifiedInverseJoinColumn(0);
        inverseJoinColumn.setSpecifiedName("inverseName");
        inverseJoinColumn.setSpecifiedReferencedColumnName("inverseReferenceName");
        OrmOneToManyMappingTests.assertFalse((boolean)oneToManyMapping.isDefault());
        ormPersistentAttribute.setSpecifiedMappingKey("embedded");
        OrmOneToManyMappingTests.assertEquals((int)1, (int)ormPersistentType.specifiedAttributesSize());
        OrmOneToManyMappingTests.assertEquals((Object)ormPersistentAttribute, ormPersistentType.specifiedAttributes().next());
        OrmOneToManyMappingTests.assertTrue((boolean)(ormPersistentAttribute.getMapping() instanceof EmbeddedMapping));
        OrmOneToManyMappingTests.assertEquals((String)"oneToMany", (String)ormPersistentAttribute.getMapping().getName());
    }

    public void testOneToManyMorphToEmbeddedIdMapping() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("oneToMany", "oneToMany");
        OneToManyMapping oneToManyMapping = (OneToManyMapping)ormPersistentAttribute.getMapping();
        OrmOneToManyMappingTests.assertFalse((boolean)oneToManyMapping.isDefault());
        oneToManyMapping.setSpecifiedFetch(FetchType.EAGER);
        oneToManyMapping.setSpecifiedTargetEntity("TargetEntity");
        oneToManyMapping.getOrderable().setSpecifiedOrderBy("customOrder");
        oneToManyMapping.setSpecifiedMapKey("mapKey");
        oneToManyMapping.getRelationshipReference().getMappedByJoiningStrategy().setMappedByAttribute("mappedBy");
        OrmOneToManyMappingTests.assertFalse((boolean)oneToManyMapping.isDefault());
        ormPersistentAttribute.setSpecifiedMappingKey("embeddedId");
        OrmOneToManyMappingTests.assertEquals((int)1, (int)ormPersistentType.specifiedAttributesSize());
        OrmOneToManyMappingTests.assertEquals((Object)ormPersistentAttribute, ormPersistentType.specifiedAttributes().next());
        OrmOneToManyMappingTests.assertTrue((boolean)(ormPersistentAttribute.getMapping() instanceof EmbeddedIdMapping));
        OrmOneToManyMappingTests.assertEquals((String)"oneToMany", (String)ormPersistentAttribute.getMapping().getName());
    }

    public void testOneToManyMorphToOneToOneMapping() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("oneToMany", "oneToMany");
        OneToManyMapping oneToManyMapping = (OneToManyMapping)ormPersistentAttribute.getMapping();
        OrmOneToManyMappingTests.assertFalse((boolean)oneToManyMapping.isDefault());
        oneToManyMapping.setSpecifiedFetch(FetchType.EAGER);
        oneToManyMapping.setSpecifiedTargetEntity("TargetEntity");
        oneToManyMapping.getOrderable().setSpecifiedOrderBy("customOrder");
        oneToManyMapping.setSpecifiedMapKey("mapKey");
        oneToManyMapping.getRelationshipReference().getMappedByJoiningStrategy().setMappedByAttribute("mappedBy");
        oneToManyMapping.getCascade().setAll(true);
        oneToManyMapping.getCascade().setMerge(true);
        oneToManyMapping.getCascade().setPersist(true);
        oneToManyMapping.getCascade().setRefresh(true);
        oneToManyMapping.getCascade().setRemove(true);
        OrmOneToManyMappingTests.assertFalse((boolean)oneToManyMapping.isDefault());
        ormPersistentAttribute.setSpecifiedMappingKey("oneToOne");
        OrmOneToManyMappingTests.assertEquals((int)1, (int)ormPersistentType.specifiedAttributesSize());
        OrmOneToManyMappingTests.assertEquals((Object)ormPersistentAttribute, ormPersistentType.specifiedAttributes().next());
        OrmOneToManyMappingTests.assertTrue((boolean)(ormPersistentAttribute.getMapping() instanceof OneToOneMapping));
        OrmOneToManyMappingTests.assertEquals((String)"oneToMany", (String)ormPersistentAttribute.getMapping().getName());
        OrmOneToManyMappingTests.assertEquals((Object)FetchType.EAGER, (Object)((OneToOneMapping)ormPersistentAttribute.getMapping()).getSpecifiedFetch());
        OrmOneToManyMappingTests.assertEquals((String)"TargetEntity", (String)((OneToOneMapping)ormPersistentAttribute.getMapping()).getSpecifiedTargetEntity());
        OrmOneToManyMappingTests.assertEquals((String)"mappedBy", (String)((OneToOneMapping)ormPersistentAttribute.getMapping()).getRelationshipReference().getMappedByJoiningStrategy().getMappedByAttribute());
        OrmOneToManyMappingTests.assertTrue((boolean)((OneToOneMapping)ormPersistentAttribute.getMapping()).getCascade().isAll());
        OrmOneToManyMappingTests.assertTrue((boolean)((OneToOneMapping)ormPersistentAttribute.getMapping()).getCascade().isMerge());
        OrmOneToManyMappingTests.assertTrue((boolean)((OneToOneMapping)ormPersistentAttribute.getMapping()).getCascade().isPersist());
        OrmOneToManyMappingTests.assertTrue((boolean)((OneToOneMapping)ormPersistentAttribute.getMapping()).getCascade().isRefresh());
        OrmOneToManyMappingTests.assertTrue((boolean)((OneToOneMapping)ormPersistentAttribute.getMapping()).getCascade().isRemove());
    }

    public void testOneToManyMorphToManyToManyMapping() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("oneToMany", "oneToMany");
        OneToManyMapping oneToManyMapping = (OneToManyMapping)ormPersistentAttribute.getMapping();
        OrmOneToManyMappingTests.assertFalse((boolean)oneToManyMapping.isDefault());
        oneToManyMapping.setSpecifiedFetch(FetchType.EAGER);
        oneToManyMapping.setSpecifiedTargetEntity("TargetEntity");
        oneToManyMapping.getOrderable().setSpecifiedOrderBy("customOrder");
        oneToManyMapping.setSpecifiedMapKey("mapKey");
        oneToManyMapping.getCascade().setAll(true);
        oneToManyMapping.getCascade().setMerge(true);
        oneToManyMapping.getCascade().setPersist(true);
        oneToManyMapping.getCascade().setRefresh(true);
        oneToManyMapping.getCascade().setRemove(true);
        oneToManyMapping.getRelationshipReference().getJoinTableJoiningStrategy().getJoinTable().setSpecifiedName("MY_JOIN_TABLE");
        JoinColumn joinColumn = oneToManyMapping.getRelationshipReference().getJoinTableJoiningStrategy().getJoinTable().addSpecifiedJoinColumn(0);
        joinColumn.setSpecifiedName("name");
        joinColumn.setSpecifiedReferencedColumnName("referenceName");
        JoinColumn inverseJoinColumn = oneToManyMapping.getRelationshipReference().getJoinTableJoiningStrategy().getJoinTable().addSpecifiedInverseJoinColumn(0);
        inverseJoinColumn.setSpecifiedName("inverseName");
        inverseJoinColumn.setSpecifiedReferencedColumnName("inverseReferenceName");
        OrmOneToManyMappingTests.assertFalse((boolean)oneToManyMapping.isDefault());
        ormPersistentAttribute.setSpecifiedMappingKey("manyToMany");
        OrmOneToManyMappingTests.assertEquals((int)1, (int)ormPersistentType.specifiedAttributesSize());
        OrmOneToManyMappingTests.assertEquals((Object)ormPersistentAttribute, ormPersistentType.specifiedAttributes().next());
        OrmOneToManyMappingTests.assertTrue((boolean)(ormPersistentAttribute.getMapping() instanceof ManyToManyMapping));
        OrmOneToManyMappingTests.assertEquals((String)"oneToMany", (String)ormPersistentAttribute.getMapping().getName());
        OrmOneToManyMappingTests.assertEquals((Object)FetchType.EAGER, (Object)((ManyToManyMapping)ormPersistentAttribute.getMapping()).getSpecifiedFetch());
        OrmOneToManyMappingTests.assertEquals((String)"TargetEntity", (String)((ManyToManyMapping)ormPersistentAttribute.getMapping()).getSpecifiedTargetEntity());
        OrmOneToManyMappingTests.assertTrue((boolean)((ManyToManyMapping)ormPersistentAttribute.getMapping()).getCascade().isAll());
        OrmOneToManyMappingTests.assertTrue((boolean)((ManyToManyMapping)ormPersistentAttribute.getMapping()).getCascade().isMerge());
        OrmOneToManyMappingTests.assertTrue((boolean)((ManyToManyMapping)ormPersistentAttribute.getMapping()).getCascade().isPersist());
        OrmOneToManyMappingTests.assertTrue((boolean)((ManyToManyMapping)ormPersistentAttribute.getMapping()).getCascade().isRefresh());
        OrmOneToManyMappingTests.assertTrue((boolean)((ManyToManyMapping)ormPersistentAttribute.getMapping()).getCascade().isRemove());
        JoinTable joinTable = ((ManyToManyMapping)ormPersistentAttribute.getMapping()).getRelationshipReference().getJoinTableJoiningStrategy().getJoinTable();
        OrmOneToManyMappingTests.assertEquals((String)"MY_JOIN_TABLE", (String)joinTable.getName());
        OrmOneToManyMappingTests.assertEquals((String)"name", (String)((JoinColumn)joinTable.joinColumns().next()).getSpecifiedName());
        OrmOneToManyMappingTests.assertEquals((String)"referenceName", (String)((JoinColumn)joinTable.joinColumns().next()).getSpecifiedReferencedColumnName());
        OrmOneToManyMappingTests.assertEquals((String)"inverseName", (String)((JoinColumn)joinTable.inverseJoinColumns().next()).getSpecifiedName());
        OrmOneToManyMappingTests.assertEquals((String)"inverseReferenceName", (String)((JoinColumn)joinTable.inverseJoinColumns().next()).getSpecifiedReferencedColumnName());
    }

    public void testOneToManyMorphToManyToOneMapping() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("oneToMany", "oneToMany");
        OneToManyMapping oneToManyMapping = (OneToManyMapping)ormPersistentAttribute.getMapping();
        OrmOneToManyMappingTests.assertFalse((boolean)oneToManyMapping.isDefault());
        oneToManyMapping.setSpecifiedFetch(FetchType.EAGER);
        oneToManyMapping.setSpecifiedTargetEntity("TargetEntity");
        oneToManyMapping.getOrderable().setSpecifiedOrderBy("customOrder");
        oneToManyMapping.setSpecifiedMapKey("mapKey");
        oneToManyMapping.getRelationshipReference().getMappedByJoiningStrategy().setMappedByAttribute("mappedBy");
        oneToManyMapping.getCascade().setAll(true);
        oneToManyMapping.getCascade().setMerge(true);
        oneToManyMapping.getCascade().setPersist(true);
        oneToManyMapping.getCascade().setRefresh(true);
        oneToManyMapping.getCascade().setRemove(true);
        OrmOneToManyMappingTests.assertFalse((boolean)oneToManyMapping.isDefault());
        ormPersistentAttribute.setSpecifiedMappingKey("manyToOne");
        OrmOneToManyMappingTests.assertEquals((int)1, (int)ormPersistentType.specifiedAttributesSize());
        OrmOneToManyMappingTests.assertEquals((Object)ormPersistentAttribute, ormPersistentType.specifiedAttributes().next());
        OrmOneToManyMappingTests.assertTrue((boolean)(ormPersistentAttribute.getMapping() instanceof ManyToOneMapping));
        OrmOneToManyMappingTests.assertEquals((String)"oneToMany", (String)ormPersistentAttribute.getMapping().getName());
        OrmOneToManyMappingTests.assertEquals((Object)FetchType.EAGER, (Object)((ManyToOneMapping)ormPersistentAttribute.getMapping()).getSpecifiedFetch());
        OrmOneToManyMappingTests.assertEquals((String)"TargetEntity", (String)((ManyToOneMapping)ormPersistentAttribute.getMapping()).getSpecifiedTargetEntity());
        OrmOneToManyMappingTests.assertTrue((boolean)((ManyToOneMapping)ormPersistentAttribute.getMapping()).getCascade().isAll());
        OrmOneToManyMappingTests.assertTrue((boolean)((ManyToOneMapping)ormPersistentAttribute.getMapping()).getCascade().isMerge());
        OrmOneToManyMappingTests.assertTrue((boolean)((ManyToOneMapping)ormPersistentAttribute.getMapping()).getCascade().isPersist());
        OrmOneToManyMappingTests.assertTrue((boolean)((ManyToOneMapping)ormPersistentAttribute.getMapping()).getCascade().isRefresh());
        OrmOneToManyMappingTests.assertTrue((boolean)((ManyToOneMapping)ormPersistentAttribute.getMapping()).getCascade().isRemove());
    }

    public void testOneToManyMorphToBasicMapping() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("oneToMany", "oneToMany");
        OneToManyMapping oneToManyMapping = (OneToManyMapping)ormPersistentAttribute.getMapping();
        OrmOneToManyMappingTests.assertFalse((boolean)oneToManyMapping.isDefault());
        oneToManyMapping.setSpecifiedFetch(FetchType.EAGER);
        oneToManyMapping.setSpecifiedTargetEntity("TargetEntity");
        oneToManyMapping.getOrderable().setSpecifiedOrderBy("customOrder");
        oneToManyMapping.setSpecifiedMapKey("mapKey");
        oneToManyMapping.getRelationshipReference().getMappedByJoiningStrategy().setMappedByAttribute("mappedBy");
        oneToManyMapping.getCascade().setAll(true);
        oneToManyMapping.getCascade().setMerge(true);
        oneToManyMapping.getCascade().setPersist(true);
        oneToManyMapping.getCascade().setRefresh(true);
        oneToManyMapping.getCascade().setRemove(true);
        OrmOneToManyMappingTests.assertFalse((boolean)oneToManyMapping.isDefault());
        ormPersistentAttribute.setSpecifiedMappingKey("basic");
        OrmOneToManyMappingTests.assertEquals((int)1, (int)ormPersistentType.specifiedAttributesSize());
        OrmOneToManyMappingTests.assertEquals((Object)ormPersistentAttribute, ormPersistentType.specifiedAttributes().next());
        OrmOneToManyMappingTests.assertTrue((boolean)(ormPersistentAttribute.getMapping() instanceof BasicMapping));
        OrmOneToManyMappingTests.assertEquals((String)"oneToMany", (String)ormPersistentAttribute.getMapping().getName());
    }

    public void testCandidateMappedByAttributeNames() throws Exception {
        this.createTestEntityWithValidOneToManyMapping();
        this.createTestTargetEntityAddress();
        this.createTestEmbeddableState();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        this.getEntityMappings().addPersistentType("entity", "test.Address");
        this.getEntityMappings().addPersistentType("embeddable", "test.State");
        ormPersistentType.addSpecifiedAttribute("oneToMany", "addresses");
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef("test.Address");
        this.addXmlClassRef("test.State");
        PersistentAttribute persistentAttribute = (PersistentAttribute)ormPersistentType.attributes().next();
        OneToManyMapping oneToManyMapping = (OneToManyMapping)persistentAttribute.getMapping();
        Iterator attributeNames = oneToManyMapping.getRelationshipReference().getMappedByJoiningStrategy().candidateMappedByAttributeNames();
        OrmOneToManyMappingTests.assertEquals((String)"id", (String)((String)attributeNames.next()));
        OrmOneToManyMappingTests.assertEquals((String)"city", (String)((String)attributeNames.next()));
        OrmOneToManyMappingTests.assertEquals((String)"state", (String)((String)attributeNames.next()));
        OrmOneToManyMappingTests.assertEquals((String)"zip", (String)((String)attributeNames.next()));
        OrmOneToManyMappingTests.assertFalse((boolean)attributeNames.hasNext());
        oneToManyMapping.setSpecifiedTargetEntity("foo");
        attributeNames = oneToManyMapping.getRelationshipReference().getMappedByJoiningStrategy().candidateMappedByAttributeNames();
        OrmOneToManyMappingTests.assertFalse((boolean)attributeNames.hasNext());
        oneToManyMapping.setSpecifiedTargetEntity(null);
        attributeNames = oneToManyMapping.getRelationshipReference().getMappedByJoiningStrategy().candidateMappedByAttributeNames();
        OrmOneToManyMappingTests.assertEquals((String)"id", (String)((String)attributeNames.next()));
        OrmOneToManyMappingTests.assertEquals((String)"city", (String)((String)attributeNames.next()));
        OrmOneToManyMappingTests.assertEquals((String)"state", (String)((String)attributeNames.next()));
        OrmOneToManyMappingTests.assertEquals((String)"zip", (String)((String)attributeNames.next()));
        OrmOneToManyMappingTests.assertFalse((boolean)attributeNames.hasNext());
        AttributeMapping stateFooMapping = oneToManyMapping.getResolvedTargetEntity().resolveAttributeMapping("state.foo");
        OrmOneToManyMappingTests.assertNull((Object)stateFooMapping);
    }

    public void testCandidateMapKeyNames() throws Exception {
        this.createTestEntityWithValidMapOneToManyMapping();
        this.createTestTargetEntityAddress();
        this.createTestEmbeddableState();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        this.getEntityMappings().addPersistentType("entity", "test.Address");
        this.getEntityMappings().addPersistentType("embeddable", "test.State");
        OrmOneToManyMapping ormOneToManyMapping = (OrmOneToManyMapping)ormPersistentType.getAttributeNamed("addresses").getMapping();
        Iterator mapKeyNames = ormOneToManyMapping.candidateMapKeyNames();
        OrmOneToManyMappingTests.assertEquals((String)"id", (String)((String)mapKeyNames.next()));
        OrmOneToManyMappingTests.assertEquals((String)"city", (String)((String)mapKeyNames.next()));
        OrmOneToManyMappingTests.assertEquals((String)"state", (String)((String)mapKeyNames.next()));
        OrmOneToManyMappingTests.assertEquals((String)"zip", (String)((String)mapKeyNames.next()));
        OrmOneToManyMappingTests.assertFalse((boolean)mapKeyNames.hasNext());
    }

    public void testCandidateMapKeyNames2() throws Exception {
        this.createTestEntityWithValidNonGenericMapOneToManyMapping();
        this.createTestTargetEntityAddress();
        this.createTestEmbeddableState();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        this.getEntityMappings().addPersistentType("entity", "test.Address");
        this.getEntityMappings().addPersistentType("embeddable", "test.State");
        OrmOneToManyMapping ormOneToManyMapping = (OrmOneToManyMapping)ormPersistentType.getAttributeNamed("addresses").getMapping();
        JavaOneToManyMapping javaOneToManyMapping = (JavaOneToManyMapping)ormPersistentType.getJavaPersistentType().getAttributeNamed("addresses").getMapping();
        Iterator mapKeyNames = ormOneToManyMapping.candidateMapKeyNames();
        OrmOneToManyMappingTests.assertEquals((boolean)false, (boolean)mapKeyNames.hasNext());
        javaOneToManyMapping.setSpecifiedTargetEntity("test.Address");
        mapKeyNames = ormOneToManyMapping.candidateMapKeyNames();
        OrmOneToManyMappingTests.assertEquals((String)"id", (String)((String)mapKeyNames.next()));
        OrmOneToManyMappingTests.assertEquals((String)"city", (String)((String)mapKeyNames.next()));
        OrmOneToManyMappingTests.assertEquals((String)"state", (String)((String)mapKeyNames.next()));
        OrmOneToManyMappingTests.assertEquals((String)"zip", (String)((String)mapKeyNames.next()));
        OrmOneToManyMappingTests.assertFalse((boolean)mapKeyNames.hasNext());
        ormOneToManyMapping.getPersistentAttribute().makeSpecified();
        ormOneToManyMapping = (OrmOneToManyMapping)ormPersistentType.getAttributeNamed("addresses").getMapping();
        mapKeyNames = ormOneToManyMapping.candidateMapKeyNames();
        OrmOneToManyMappingTests.assertEquals((boolean)false, (boolean)mapKeyNames.hasNext());
        ormOneToManyMapping.setSpecifiedTargetEntity("test.Address");
        mapKeyNames = ormOneToManyMapping.candidateMapKeyNames();
        OrmOneToManyMappingTests.assertEquals((String)"id", (String)((String)mapKeyNames.next()));
        OrmOneToManyMappingTests.assertEquals((String)"city", (String)((String)mapKeyNames.next()));
        OrmOneToManyMappingTests.assertEquals((String)"state", (String)((String)mapKeyNames.next()));
        OrmOneToManyMappingTests.assertEquals((String)"zip", (String)((String)mapKeyNames.next()));
        OrmOneToManyMappingTests.assertFalse((boolean)mapKeyNames.hasNext());
        ormOneToManyMapping.setSpecifiedTargetEntity("String");
        mapKeyNames = ormOneToManyMapping.candidateMapKeyNames();
        OrmOneToManyMappingTests.assertEquals((boolean)false, (boolean)mapKeyNames.hasNext());
    }

    public void testVirtualMappingMetadataCompleteFalse() throws Exception {
        this.createTestEntityOneToManyMapping();
        this.createTestTargetEntityAddress();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        this.getEntityMappings().addPersistentType("entity", "test.Address");
        OrmOneToManyMappingTests.assertEquals((int)3, (int)ormPersistentType.virtualAttributesSize());
        OrmPersistentAttribute ormPersistentAttribute = (OrmPersistentAttribute)ormPersistentType.virtualAttributes().next();
        OrmOneToManyMapping ormOneToManyMapping = (OrmOneToManyMapping)ormPersistentAttribute.getMapping();
        OrmOneToManyMappingTests.assertEquals((String)"address", (String)ormOneToManyMapping.getName());
        OrmOneToManyMappingTests.assertEquals((Object)FetchType.EAGER, (Object)ormOneToManyMapping.getSpecifiedFetch());
        OrmOneToManyMappingTests.assertEquals((String)"Address", (String)ormOneToManyMapping.getSpecifiedTargetEntity());
        OrmOneToManyMappingTests.assertNull((Object)ormOneToManyMapping.getRelationshipReference().getMappedByJoiningStrategy().getMappedByAttribute());
        OrmCascade2_0 cascade = ormOneToManyMapping.getCascade();
        OrmOneToManyMappingTests.assertTrue((boolean)cascade.isAll());
        OrmOneToManyMappingTests.assertTrue((boolean)cascade.isMerge());
        OrmOneToManyMappingTests.assertTrue((boolean)cascade.isPersist());
        OrmOneToManyMappingTests.assertTrue((boolean)cascade.isRemove());
        OrmOneToManyMappingTests.assertTrue((boolean)cascade.isRefresh());
        OrmOneToManyMappingTests.assertTrue((boolean)ormOneToManyMapping.getOrderable().isCustomOrdering());
        OrmOneToManyMappingTests.assertEquals((String)"city", (String)ormOneToManyMapping.getOrderable().getSpecifiedOrderBy());
    }

    public void testVirtualMappingMetadataCompleteTrue() throws Exception {
        this.createTestEntityOneToManyMapping();
        this.createTestTargetEntityAddress();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        this.getEntityMappings().addPersistentType("entity", "test.Address");
        ormPersistentType.getMapping().setSpecifiedMetadataComplete(Boolean.TRUE);
        OrmOneToManyMappingTests.assertEquals((int)3, (int)ormPersistentType.virtualAttributesSize());
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.getAttributeNamed("address");
        OrmOneToManyMappingTests.assertEquals((String)MappingKeys.NULL_ATTRIBUTE_MAPPING_KEY, (String)ormPersistentAttribute.getMappingKey());
        OrmOneToManyMappingTests.assertTrue((boolean)ormPersistentAttribute.isVirtual());
        ormPersistentAttribute.makeSpecified("oneToMany");
        ormPersistentAttribute = (OrmPersistentAttribute)ormPersistentType.specifiedAttributes().next();
        OrmOneToManyMapping ormOneToManyMapping = (OrmOneToManyMapping)ormPersistentAttribute.getMapping();
        OrmOneToManyMappingTests.assertEquals((String)"address", (String)ormOneToManyMapping.getName());
        OrmOneToManyMappingTests.assertEquals((Object)FetchType.LAZY, (Object)ormOneToManyMapping.getFetch());
        OrmOneToManyMappingTests.assertEquals((String)"test.Address", (String)ormOneToManyMapping.getTargetEntity());
        OrmOneToManyMappingTests.assertNull((Object)ormOneToManyMapping.getRelationshipReference().getMappedByJoiningStrategy().getMappedByAttribute());
        OrmCascade2_0 cascade = ormOneToManyMapping.getCascade();
        OrmOneToManyMappingTests.assertFalse((boolean)cascade.isAll());
        OrmOneToManyMappingTests.assertFalse((boolean)cascade.isMerge());
        OrmOneToManyMappingTests.assertFalse((boolean)cascade.isPersist());
        OrmOneToManyMappingTests.assertFalse((boolean)cascade.isRemove());
        OrmOneToManyMappingTests.assertFalse((boolean)cascade.isRefresh());
        OrmOneToManyMappingTests.assertTrue((boolean)ormOneToManyMapping.getOrderable().isNoOrdering());
        OrmOneToManyMappingTests.assertEquals(null, (String)ormOneToManyMapping.getOrderable().getSpecifiedOrderBy());
    }
}

