/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.tests.internal.jpa2.context.java;

import java.util.Iterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.core.context.PersistentAttribute;
import org.eclipse.jpt.core.jpa2.context.java.JavaCascade2_0;
import org.eclipse.jpt.core.jpa2.context.java.JavaOneToOneMapping2_0;
import org.eclipse.jpt.core.jpa2.resource.java.OneToOne2_0Annotation;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentAttribute;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentType;
import org.eclipse.jpt.core.tests.internal.jpa2.context.Generic2_0ContextModelTestCase;
import org.eclipse.jpt.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.utility.internal.iterators.ArrayIterator;

public class GenericJavaCascade2_0Tests
extends Generic2_0ContextModelTestCase {
    private ICompilationUnit createTestEntityWithOneToOneMapping() throws Exception {
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.OneToOne"});
            }

            @Override
            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }

            @Override
            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@OneToOne").append(CR);
            }
        });
    }

    public GenericJavaCascade2_0Tests(String name) {
        super(name);
    }

    public void testUpdateCascadeDetach() throws Exception {
        this.createTestEntityWithOneToOneMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        OneToOne2_0Annotation annotation = (OneToOne2_0Annotation)attributeResource.getAnnotation("javax.persistence.OneToOne");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        JavaOneToOneMapping2_0 mapping = (JavaOneToOneMapping2_0)persistentAttribute.getMapping();
        JavaCascade2_0 cascade = mapping.getCascade();
        GenericJavaCascade2_0Tests.assertFalse((boolean)cascade.isDetach());
        GenericJavaCascade2_0Tests.assertFalse((boolean)annotation.isCascadeDetach());
        annotation.setCascadeDetach(true);
        this.getJpaProject().update();
        GenericJavaCascade2_0Tests.assertTrue((boolean)annotation.isCascadeDetach());
        GenericJavaCascade2_0Tests.assertTrue((boolean)cascade.isDetach());
        annotation.setCascadeDetach(false);
        this.getJpaProject().update();
        GenericJavaCascade2_0Tests.assertFalse((boolean)annotation.isCascadeDetach());
        GenericJavaCascade2_0Tests.assertFalse((boolean)cascade.isDetach());
    }

    public void testModifyCascadeDetach() throws Exception {
        this.createTestEntityWithOneToOneMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        OneToOne2_0Annotation annotation = (OneToOne2_0Annotation)attributeResource.getAnnotation("javax.persistence.OneToOne");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        JavaOneToOneMapping2_0 mapping = (JavaOneToOneMapping2_0)persistentAttribute.getMapping();
        JavaCascade2_0 cascade = mapping.getCascade();
        GenericJavaCascade2_0Tests.assertFalse((boolean)cascade.isDetach());
        GenericJavaCascade2_0Tests.assertFalse((boolean)annotation.isCascadeDetach());
        cascade.setDetach(true);
        GenericJavaCascade2_0Tests.assertTrue((boolean)annotation.isCascadeDetach());
        GenericJavaCascade2_0Tests.assertTrue((boolean)cascade.isDetach());
        cascade.setDetach(false);
        GenericJavaCascade2_0Tests.assertFalse((boolean)annotation.isCascadeDetach());
        GenericJavaCascade2_0Tests.assertFalse((boolean)cascade.isDetach());
    }
}

