/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.tests.internal.jpa2.context.orm;

import org.eclipse.jpt.core.context.orm.OrmOneToOneMapping;
import org.eclipse.jpt.core.context.orm.OrmPersistentAttribute;
import org.eclipse.jpt.core.context.orm.OrmPersistentType;
import org.eclipse.jpt.core.jpa2.context.orm.OrmCascade2_0;
import org.eclipse.jpt.core.resource.orm.OrmFactory;
import org.eclipse.jpt.core.resource.orm.XmlEntity;
import org.eclipse.jpt.core.resource.orm.XmlOneToOne;
import org.eclipse.jpt.core.resource.persistence.PersistenceFactory;
import org.eclipse.jpt.core.resource.persistence.XmlMappingFileRef;
import org.eclipse.jpt.core.tests.internal.jpa2.context.Generic2_0ContextModelTestCase;

public class GenericOrmCascade2_0Tests
extends Generic2_0ContextModelTestCase {
    public GenericOrmCascade2_0Tests(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        XmlMappingFileRef mappingFileRef = PersistenceFactory.eINSTANCE.createXmlMappingFileRef();
        mappingFileRef.setFileName("META-INF/orm.xml");
        this.getXmlPersistenceUnit().getMappingFiles().add((Object)mappingFileRef);
        this.getPersistenceXmlResource().save(null);
    }

    public void testUpdateCascadeDetach() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "model.Foo");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("oneToOne", "oneToOneMapping");
        OrmOneToOneMapping ormOneToOneMapping = (OrmOneToOneMapping)ormPersistentAttribute.getMapping();
        XmlOneToOne oneToOne = (XmlOneToOne)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getOneToOnes().get(0);
        OrmCascade2_0 cascade = ormOneToOneMapping.getCascade();
        GenericOrmCascade2_0Tests.assertEquals((boolean)false, (boolean)cascade.isDetach());
        GenericOrmCascade2_0Tests.assertNull((Object)oneToOne.getCascade());
        oneToOne.setCascade(OrmFactory.eINSTANCE.createCascadeType());
        GenericOrmCascade2_0Tests.assertEquals((boolean)false, (boolean)cascade.isDetach());
        GenericOrmCascade2_0Tests.assertNotNull((Object)oneToOne.getCascade());
        oneToOne.getCascade().setCascadeDetach(true);
        GenericOrmCascade2_0Tests.assertEquals((boolean)true, (boolean)cascade.isDetach());
        GenericOrmCascade2_0Tests.assertEquals((boolean)true, (boolean)oneToOne.getCascade().isCascadeDetach());
        oneToOne.getCascade().setCascadeDetach(false);
        GenericOrmCascade2_0Tests.assertEquals((boolean)false, (boolean)cascade.isDetach());
        GenericOrmCascade2_0Tests.assertEquals((boolean)false, (boolean)oneToOne.getCascade().isCascadeDetach());
    }

    public void testModifyCascadeDetach() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "model.Foo");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("oneToOne", "oneToOneMapping");
        OrmOneToOneMapping ormOneToOneMapping = (OrmOneToOneMapping)ormPersistentAttribute.getMapping();
        XmlOneToOne oneToOne = (XmlOneToOne)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getOneToOnes().get(0);
        OrmCascade2_0 cascade = ormOneToOneMapping.getCascade();
        GenericOrmCascade2_0Tests.assertEquals((boolean)false, (boolean)cascade.isDetach());
        GenericOrmCascade2_0Tests.assertNull((Object)oneToOne.getCascade());
        cascade.setDetach(true);
        GenericOrmCascade2_0Tests.assertEquals((boolean)true, (boolean)cascade.isDetach());
        GenericOrmCascade2_0Tests.assertEquals((boolean)true, (boolean)oneToOne.getCascade().isCascadeDetach());
        cascade.setDetach(false);
        GenericOrmCascade2_0Tests.assertEquals((boolean)false, (boolean)cascade.isDetach());
        GenericOrmCascade2_0Tests.assertNull((Object)oneToOne.getCascade());
    }
}

