/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.tests.internal.jpa2.context.orm;

import java.util.Iterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.core.MappingKeys;
import org.eclipse.jpt.core.context.FetchType;
import org.eclipse.jpt.core.context.java.JavaEntity;
import org.eclipse.jpt.core.context.java.JavaJoinColumn;
import org.eclipse.jpt.core.context.java.JavaJoinTable;
import org.eclipse.jpt.core.context.orm.OrmEntity;
import org.eclipse.jpt.core.context.orm.OrmJoinColumn;
import org.eclipse.jpt.core.context.orm.OrmJoinTable;
import org.eclipse.jpt.core.context.orm.OrmManyToOneMapping;
import org.eclipse.jpt.core.context.orm.OrmPersistentAttribute;
import org.eclipse.jpt.core.context.orm.OrmPersistentType;
import org.eclipse.jpt.core.jpa2.context.java.JavaManyToOneMapping2_0;
import org.eclipse.jpt.core.jpa2.context.orm.OrmCascade2_0;
import org.eclipse.jpt.core.jpa2.context.orm.OrmDerivedIdentity2_0;
import org.eclipse.jpt.core.jpa2.context.orm.OrmManyToOneMapping2_0;
import org.eclipse.jpt.core.jpa2.context.orm.OrmManyToOneRelationshipReference2_0;
import org.eclipse.jpt.core.jpa2.context.orm.OrmOneToOneMapping2_0;
import org.eclipse.jpt.core.resource.orm.OrmFactory;
import org.eclipse.jpt.core.resource.orm.XmlEntity;
import org.eclipse.jpt.core.resource.orm.XmlManyToOne;
import org.eclipse.jpt.core.resource.orm.XmlOneToOne;
import org.eclipse.jpt.core.resource.orm.v2_0.XmlDerivedId_2_0;
import org.eclipse.jpt.core.resource.orm.v2_0.XmlMapsId_2_0;
import org.eclipse.jpt.core.tests.internal.jpa2.context.Generic2_0ContextModelTestCase;
import org.eclipse.jpt.core.tests.internal.projects.TestJavaProject;
import org.eclipse.jpt.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.jpt.utility.internal.iterators.ArrayIterator;

public class GenericOrmManyToOneMapping2_0Tests
extends Generic2_0ContextModelTestCase {
    public GenericOrmManyToOneMapping2_0Tests(String name) {
        super(name);
    }

    private void createTestEntityWithIdDerivedIdentity() throws Exception {
        this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.ManyToOne", "javax.persistence.Id"});
            }

            @Override
            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }

            @Override
            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("    @ManyToOne @Id").append(CR);
                sb.append("    private AnnotationTestType manyToOne;").append(CR);
                sb.append(CR);
            }
        });
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        for (OrmPersistentAttribute each : CollectionTools.iterable((Iterator)ormPersistentType.attributes())) {
            each.makeSpecified();
        }
    }

    private void createTestEntityWithMapsIdDerivedIdentity() throws Exception {
        this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.ManyToOne", "javax.persistence.MapsId"});
            }

            @Override
            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }

            @Override
            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("    @ManyToOne @MapsId").append(CR);
                sb.append("    private AnnotationTestType manyToOne;").append(CR);
                sb.append(CR);
            }
        });
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        for (OrmPersistentAttribute each : CollectionTools.iterable((Iterator)ormPersistentType.attributes())) {
            each.makeSpecified();
        }
    }

    private ICompilationUnit createTestEntityWithValidManyToOneMapping() throws Exception {
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.ManyToOne", "javax.persistence.Id"});
            }

            @Override
            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }

            @Override
            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("    @ManyToOne").append(CR);
                sb.append("    private Address address;").append(CR);
                sb.append(CR);
                sb.append("    @Id").append(CR);
            }
        });
    }

    private void createTestEntityWithManyToOneMapping() throws Exception {
        this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.ManyToOne"});
            }

            @Override
            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }

            @Override
            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@ManyToOne").append(CR);
            }
        });
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        for (OrmPersistentAttribute each : CollectionTools.iterable((Iterator)ormPersistentType.attributes())) {
            each.makeSpecified();
        }
    }

    private void createTestTargetEntityAddress() throws Exception {
        TestJavaProject.SourceWriter sourceWriter = new TestJavaProject.SourceWriter(){

            public void appendSourceTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Entity");
                sb.append(";");
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Id");
                sb.append(";");
                sb.append(CR);
                sb.append(CR);
                sb.append("@Entity");
                sb.append(CR);
                sb.append("public class ").append("Address").append(" ");
                sb.append("{").append(CR);
                sb.append(CR);
                sb.append("    @Id").append(CR);
                sb.append("    private int id;").append(CR);
                sb.append(CR);
                sb.append("    private String city;").append(CR);
                sb.append(CR);
                sb.append("    private State state;").append(CR);
                sb.append(CR);
                sb.append("    private int zip;").append(CR);
                sb.append(CR);
                sb.append("}").append(CR);
            }
        };
        this.javaProject.createCompilationUnit("test", "Address.java", sourceWriter);
    }

    private ICompilationUnit createTestEntityManyToOneMapping() throws Exception {
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.ManyToOne", "javax.persistence.JoinColumn", "javax.persistence.FetchType", "javax.persistence.CascadeType"});
            }

            @Override
            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity");
            }

            @Override
            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("    @ManyToOne(fetch=FetchType.LAZY, optional=false, targetEntity=Address.class, cascade={CascadeType.ALL, CascadeType.PERSIST, CascadeType.MERGE, CascadeType.REMOVE, CascadeType.REFRESH, CascadeType.DETACH})");
                sb.append(CR);
                sb.append("    @JoinColumn(name=\"MY_COLUMN\", referencedColumnName=\"MY_REFERENCED_COLUMN\", unique=true, nullable=false, insertable=false, updatable=false, columnDefinition=\"COLUMN_DEFINITION\", table=\"MY_TABLE\")");
                sb.append(CR);
                sb.append("    private Address address;").append(CR);
                sb.append(CR);
                sb.append("    @Id");
            }
        });
    }

    public void testUpdateId() throws Exception {
        this.createTestEntityWithIdDerivedIdentity();
        OrmPersistentType contextType = this.getEntityMappings().getPersistentType("test.AnnotationTestType");
        OrmPersistentAttribute contextAttribute = contextType.getAttributeNamed("manyToOne");
        OrmManyToOneMapping2_0 contextMapping = (OrmManyToOneMapping2_0)contextAttribute.getMapping();
        XmlEntity resourceEntity = (XmlEntity)contextType.getMapping().getResourceTypeMapping();
        XmlDerivedId_2_0 resourceMapping = (XmlDerivedId_2_0)resourceEntity.getAttributes().getManyToOnes().get(0);
        GenericOrmManyToOneMapping2_0Tests.assertNull((Object)resourceMapping.getId());
        GenericOrmManyToOneMapping2_0Tests.assertFalse((boolean)contextMapping.getDerivedIdentity().getIdDerivedIdentityStrategy().getValue());
        resourceMapping.setId(Boolean.TRUE);
        GenericOrmManyToOneMapping2_0Tests.assertEquals((Object)Boolean.TRUE, (Object)resourceMapping.getId());
        GenericOrmManyToOneMapping2_0Tests.assertTrue((boolean)contextMapping.getDerivedIdentity().getIdDerivedIdentityStrategy().getValue());
        resourceMapping.setId(Boolean.FALSE);
        GenericOrmManyToOneMapping2_0Tests.assertEquals((Object)Boolean.FALSE, (Object)resourceMapping.getId());
        GenericOrmManyToOneMapping2_0Tests.assertFalse((boolean)contextMapping.getDerivedIdentity().getIdDerivedIdentityStrategy().getValue());
        resourceMapping.setId(null);
        GenericOrmManyToOneMapping2_0Tests.assertNull((Object)resourceMapping.getId());
        GenericOrmManyToOneMapping2_0Tests.assertFalse((boolean)contextMapping.getDerivedIdentity().getIdDerivedIdentityStrategy().getValue());
    }

    public void testSetDerivedId() throws Exception {
        this.createTestEntityWithIdDerivedIdentity();
        OrmPersistentType contextType = this.getEntityMappings().getPersistentType("test.AnnotationTestType");
        OrmPersistentAttribute contextAttribute = contextType.getAttributeNamed("manyToOne");
        OrmManyToOneMapping2_0 contextMapping = (OrmManyToOneMapping2_0)contextAttribute.getMapping();
        XmlEntity resourceEntity = (XmlEntity)contextType.getMapping().getResourceTypeMapping();
        XmlDerivedId_2_0 resourceMapping = (XmlDerivedId_2_0)resourceEntity.getAttributes().getManyToOnes().get(0);
        GenericOrmManyToOneMapping2_0Tests.assertNull((Object)resourceMapping.getId());
        GenericOrmManyToOneMapping2_0Tests.assertFalse((boolean)contextMapping.getDerivedIdentity().getIdDerivedIdentityStrategy().getValue());
        contextMapping.getDerivedIdentity().getIdDerivedIdentityStrategy().setValue(true);
        GenericOrmManyToOneMapping2_0Tests.assertEquals((Object)Boolean.TRUE, (Object)resourceMapping.getId());
        GenericOrmManyToOneMapping2_0Tests.assertTrue((boolean)contextMapping.getDerivedIdentity().getIdDerivedIdentityStrategy().getValue());
        contextMapping.getDerivedIdentity().getIdDerivedIdentityStrategy().setValue(false);
        GenericOrmManyToOneMapping2_0Tests.assertNull((Object)resourceMapping.getId());
        GenericOrmManyToOneMapping2_0Tests.assertFalse((boolean)contextMapping.getDerivedIdentity().getIdDerivedIdentityStrategy().getValue());
    }

    public void testUpdateMapsId() throws Exception {
        this.createTestEntityWithMapsIdDerivedIdentity();
        OrmPersistentType contextType = this.getEntityMappings().getPersistentType("test.AnnotationTestType");
        OrmPersistentAttribute contextAttribute = contextType.getAttributeNamed("manyToOne");
        OrmManyToOneMapping2_0 contextMapping = (OrmManyToOneMapping2_0)contextAttribute.getMapping();
        XmlEntity resourceEntity = (XmlEntity)contextType.getMapping().getResourceTypeMapping();
        XmlMapsId_2_0 resourceMapping = (XmlMapsId_2_0)resourceEntity.getAttributes().getManyToOnes().get(0);
        GenericOrmManyToOneMapping2_0Tests.assertNull((Object)resourceMapping.getMapsId());
        GenericOrmManyToOneMapping2_0Tests.assertNull((Object)contextMapping.getDerivedIdentity().getMapsIdDerivedIdentityStrategy().getSpecifiedValue());
        resourceMapping.setMapsId("foo");
        GenericOrmManyToOneMapping2_0Tests.assertEquals((String)"foo", (String)resourceMapping.getMapsId());
        GenericOrmManyToOneMapping2_0Tests.assertEquals((String)"foo", (String)contextMapping.getDerivedIdentity().getMapsIdDerivedIdentityStrategy().getSpecifiedValue());
        resourceMapping.setMapsId("bar");
        GenericOrmManyToOneMapping2_0Tests.assertEquals((String)"bar", (String)resourceMapping.getMapsId());
        GenericOrmManyToOneMapping2_0Tests.assertEquals((String)"bar", (String)contextMapping.getDerivedIdentity().getMapsIdDerivedIdentityStrategy().getSpecifiedValue());
        resourceMapping.setMapsId("");
        GenericOrmManyToOneMapping2_0Tests.assertEquals((String)"", (String)resourceMapping.getMapsId());
        GenericOrmManyToOneMapping2_0Tests.assertEquals((String)"", (String)contextMapping.getDerivedIdentity().getMapsIdDerivedIdentityStrategy().getSpecifiedValue());
        resourceMapping.setMapsId(null);
        GenericOrmManyToOneMapping2_0Tests.assertNull((Object)resourceMapping.getMapsId());
        GenericOrmManyToOneMapping2_0Tests.assertNull((Object)contextMapping.getDerivedIdentity().getMapsIdDerivedIdentityStrategy().getSpecifiedValue());
    }

    public void testSetMapsId() throws Exception {
        this.createTestEntityWithMapsIdDerivedIdentity();
        OrmPersistentType contextType = this.getEntityMappings().getPersistentType("test.AnnotationTestType");
        OrmPersistentAttribute contextAttribute = contextType.getAttributeNamed("manyToOne");
        OrmManyToOneMapping2_0 contextMapping = (OrmManyToOneMapping2_0)contextAttribute.getMapping();
        XmlEntity resourceEntity = (XmlEntity)contextType.getMapping().getResourceTypeMapping();
        XmlMapsId_2_0 resourceMapping = (XmlMapsId_2_0)resourceEntity.getAttributes().getManyToOnes().get(0);
        GenericOrmManyToOneMapping2_0Tests.assertNull((Object)resourceMapping.getMapsId());
        GenericOrmManyToOneMapping2_0Tests.assertNull((Object)contextMapping.getDerivedIdentity().getMapsIdDerivedIdentityStrategy().getSpecifiedValue());
        contextMapping.getDerivedIdentity().getMapsIdDerivedIdentityStrategy().setSpecifiedValue("foo");
        GenericOrmManyToOneMapping2_0Tests.assertEquals((String)"foo", (String)resourceMapping.getMapsId());
        GenericOrmManyToOneMapping2_0Tests.assertEquals((String)"foo", (String)contextMapping.getDerivedIdentity().getMapsIdDerivedIdentityStrategy().getSpecifiedValue());
        contextMapping.getDerivedIdentity().getMapsIdDerivedIdentityStrategy().setSpecifiedValue("bar");
        GenericOrmManyToOneMapping2_0Tests.assertEquals((String)"bar", (String)resourceMapping.getMapsId());
        GenericOrmManyToOneMapping2_0Tests.assertEquals((String)"bar", (String)contextMapping.getDerivedIdentity().getMapsIdDerivedIdentityStrategy().getSpecifiedValue());
        contextMapping.getDerivedIdentity().getMapsIdDerivedIdentityStrategy().setSpecifiedValue("");
        GenericOrmManyToOneMapping2_0Tests.assertEquals((String)"", (String)resourceMapping.getMapsId());
        GenericOrmManyToOneMapping2_0Tests.assertEquals((String)"", (String)contextMapping.getDerivedIdentity().getMapsIdDerivedIdentityStrategy().getSpecifiedValue());
        contextMapping.getDerivedIdentity().getMapsIdDerivedIdentityStrategy().setSpecifiedValue(null);
        GenericOrmManyToOneMapping2_0Tests.assertNull((Object)resourceMapping.getMapsId());
        GenericOrmManyToOneMapping2_0Tests.assertNull((Object)contextMapping.getDerivedIdentity().getMapsIdDerivedIdentityStrategy().getSpecifiedValue());
    }

    public void testUpdatePredominantDerivedIdentityStrategy() throws Exception {
        this.createTestEntityWithMapsIdDerivedIdentity();
        OrmPersistentType contextType = this.getEntityMappings().getPersistentType("test.AnnotationTestType");
        OrmPersistentAttribute contextAttribute = contextType.getAttributeNamed("manyToOne");
        OrmManyToOneMapping2_0 contextMapping = (OrmManyToOneMapping2_0)contextAttribute.getMapping();
        OrmDerivedIdentity2_0 derivedIdentity = contextMapping.getDerivedIdentity();
        XmlEntity resourceEntity = (XmlEntity)contextType.getMapping().getResourceTypeMapping();
        XmlManyToOne resourceMapping = (XmlManyToOne)resourceEntity.getAttributes().getManyToOnes().get(0);
        GenericOrmManyToOneMapping2_0Tests.assertNull((Object)resourceMapping.getMapsId());
        GenericOrmManyToOneMapping2_0Tests.assertNull((Object)resourceMapping.getId());
        GenericOrmManyToOneMapping2_0Tests.assertFalse((boolean)derivedIdentity.usesMapsIdDerivedIdentityStrategy());
        GenericOrmManyToOneMapping2_0Tests.assertFalse((boolean)derivedIdentity.usesIdDerivedIdentityStrategy());
        GenericOrmManyToOneMapping2_0Tests.assertTrue((boolean)derivedIdentity.usesNullDerivedIdentityStrategy());
        resourceMapping.setMapsId("foo");
        GenericOrmManyToOneMapping2_0Tests.assertNotNull((Object)resourceMapping.getMapsId());
        GenericOrmManyToOneMapping2_0Tests.assertNull((Object)resourceMapping.getId());
        GenericOrmManyToOneMapping2_0Tests.assertTrue((boolean)derivedIdentity.usesMapsIdDerivedIdentityStrategy());
        GenericOrmManyToOneMapping2_0Tests.assertFalse((boolean)derivedIdentity.usesIdDerivedIdentityStrategy());
        GenericOrmManyToOneMapping2_0Tests.assertFalse((boolean)derivedIdentity.usesNullDerivedIdentityStrategy());
        resourceMapping.setId(Boolean.TRUE);
        GenericOrmManyToOneMapping2_0Tests.assertNotNull((Object)resourceMapping.getMapsId());
        GenericOrmManyToOneMapping2_0Tests.assertNotNull((Object)resourceMapping.getId());
        GenericOrmManyToOneMapping2_0Tests.assertTrue((boolean)derivedIdentity.usesMapsIdDerivedIdentityStrategy());
        GenericOrmManyToOneMapping2_0Tests.assertFalse((boolean)derivedIdentity.usesIdDerivedIdentityStrategy());
        GenericOrmManyToOneMapping2_0Tests.assertFalse((boolean)derivedIdentity.usesNullDerivedIdentityStrategy());
        resourceMapping.setMapsId(null);
        GenericOrmManyToOneMapping2_0Tests.assertNull((Object)resourceMapping.getMapsId());
        GenericOrmManyToOneMapping2_0Tests.assertNotNull((Object)resourceMapping.getId());
        GenericOrmManyToOneMapping2_0Tests.assertFalse((boolean)derivedIdentity.usesMapsIdDerivedIdentityStrategy());
        GenericOrmManyToOneMapping2_0Tests.assertTrue((boolean)derivedIdentity.usesIdDerivedIdentityStrategy());
        GenericOrmManyToOneMapping2_0Tests.assertFalse((boolean)derivedIdentity.usesNullDerivedIdentityStrategy());
        resourceMapping.setId(null);
        GenericOrmManyToOneMapping2_0Tests.assertNull((Object)resourceMapping.getMapsId());
        GenericOrmManyToOneMapping2_0Tests.assertNull((Object)resourceMapping.getId());
        GenericOrmManyToOneMapping2_0Tests.assertFalse((boolean)derivedIdentity.usesMapsIdDerivedIdentityStrategy());
        GenericOrmManyToOneMapping2_0Tests.assertFalse((boolean)derivedIdentity.usesIdDerivedIdentityStrategy());
        GenericOrmManyToOneMapping2_0Tests.assertTrue((boolean)derivedIdentity.usesNullDerivedIdentityStrategy());
    }

    public void testSetPredominantDerivedIdentityStrategy() throws Exception {
        this.createTestEntityWithMapsIdDerivedIdentity();
        OrmPersistentType contextType = this.getEntityMappings().getPersistentType("test.AnnotationTestType");
        OrmPersistentAttribute contextAttribute = contextType.getAttributeNamed("manyToOne");
        OrmManyToOneMapping2_0 contextMapping = (OrmManyToOneMapping2_0)contextAttribute.getMapping();
        OrmDerivedIdentity2_0 derivedIdentity = contextMapping.getDerivedIdentity();
        XmlEntity resourceEntity = (XmlEntity)contextType.getMapping().getResourceTypeMapping();
        XmlManyToOne resourceMapping = (XmlManyToOne)resourceEntity.getAttributes().getManyToOnes().get(0);
        GenericOrmManyToOneMapping2_0Tests.assertNull((Object)resourceMapping.getMapsId());
        GenericOrmManyToOneMapping2_0Tests.assertNull((Object)resourceMapping.getId());
        GenericOrmManyToOneMapping2_0Tests.assertFalse((boolean)derivedIdentity.usesMapsIdDerivedIdentityStrategy());
        GenericOrmManyToOneMapping2_0Tests.assertFalse((boolean)derivedIdentity.usesIdDerivedIdentityStrategy());
        GenericOrmManyToOneMapping2_0Tests.assertTrue((boolean)derivedIdentity.usesNullDerivedIdentityStrategy());
        derivedIdentity.setMapsIdDerivedIdentityStrategy();
        GenericOrmManyToOneMapping2_0Tests.assertNotNull((Object)resourceMapping.getMapsId());
        GenericOrmManyToOneMapping2_0Tests.assertNull((Object)resourceMapping.getId());
        GenericOrmManyToOneMapping2_0Tests.assertTrue((boolean)derivedIdentity.usesMapsIdDerivedIdentityStrategy());
        GenericOrmManyToOneMapping2_0Tests.assertFalse((boolean)derivedIdentity.usesIdDerivedIdentityStrategy());
        GenericOrmManyToOneMapping2_0Tests.assertFalse((boolean)derivedIdentity.usesNullDerivedIdentityStrategy());
        derivedIdentity.setIdDerivedIdentityStrategy();
        GenericOrmManyToOneMapping2_0Tests.assertNull((Object)resourceMapping.getMapsId());
        GenericOrmManyToOneMapping2_0Tests.assertNotNull((Object)resourceMapping.getId());
        GenericOrmManyToOneMapping2_0Tests.assertFalse((boolean)derivedIdentity.usesMapsIdDerivedIdentityStrategy());
        GenericOrmManyToOneMapping2_0Tests.assertTrue((boolean)derivedIdentity.usesIdDerivedIdentityStrategy());
        GenericOrmManyToOneMapping2_0Tests.assertFalse((boolean)derivedIdentity.usesNullDerivedIdentityStrategy());
        derivedIdentity.setNullDerivedIdentityStrategy();
        GenericOrmManyToOneMapping2_0Tests.assertNull((Object)resourceMapping.getMapsId());
        GenericOrmManyToOneMapping2_0Tests.assertNull((Object)resourceMapping.getId());
        GenericOrmManyToOneMapping2_0Tests.assertFalse((boolean)derivedIdentity.usesMapsIdDerivedIdentityStrategy());
        GenericOrmManyToOneMapping2_0Tests.assertFalse((boolean)derivedIdentity.usesIdDerivedIdentityStrategy());
        GenericOrmManyToOneMapping2_0Tests.assertTrue((boolean)derivedIdentity.usesNullDerivedIdentityStrategy());
    }

    public void testMorphMapping() throws Exception {
        this.createTestEntityWithMapsIdDerivedIdentity();
        OrmPersistentType contextType = this.getEntityMappings().getPersistentType("test.AnnotationTestType");
        OrmPersistentAttribute contextAttribute = contextType.getAttributeNamed("manyToOne");
        XmlEntity resourceEntity = (XmlEntity)contextType.getMapping().getResourceTypeMapping();
        XmlManyToOne resourceManyToOne = (XmlManyToOne)resourceEntity.getAttributes().getManyToOnes().get(0);
        resourceManyToOne.setMapsId("foo");
        GenericOrmManyToOneMapping2_0Tests.assertNull((Object)resourceManyToOne.getId());
        GenericOrmManyToOneMapping2_0Tests.assertFalse((boolean)((OrmManyToOneMapping2_0)contextAttribute.getMapping()).getDerivedIdentity().getIdDerivedIdentityStrategy().getValue());
        GenericOrmManyToOneMapping2_0Tests.assertEquals((String)"foo", (String)resourceManyToOne.getMapsId());
        GenericOrmManyToOneMapping2_0Tests.assertEquals((String)"foo", (String)((OrmManyToOneMapping2_0)contextAttribute.getMapping()).getDerivedIdentity().getMapsIdDerivedIdentityStrategy().getSpecifiedValue());
        contextAttribute.setSpecifiedMappingKey("oneToOne");
        XmlOneToOne resourceOneToOne = (XmlOneToOne)resourceEntity.getAttributes().getOneToOnes().get(0);
        GenericOrmManyToOneMapping2_0Tests.assertNull((Object)resourceOneToOne.getId());
        GenericOrmManyToOneMapping2_0Tests.assertFalse((boolean)((OrmOneToOneMapping2_0)contextAttribute.getMapping()).getDerivedIdentity().getIdDerivedIdentityStrategy().getValue());
        GenericOrmManyToOneMapping2_0Tests.assertEquals((String)"foo", (String)resourceOneToOne.getMapsId());
        GenericOrmManyToOneMapping2_0Tests.assertEquals((String)"foo", (String)((OrmOneToOneMapping2_0)contextAttribute.getMapping()).getDerivedIdentity().getMapsIdDerivedIdentityStrategy().getSpecifiedValue());
        contextAttribute.setSpecifiedMappingKey("manyToOne");
        resourceManyToOne = (XmlManyToOne)resourceEntity.getAttributes().getManyToOnes().get(0);
        GenericOrmManyToOneMapping2_0Tests.assertNull((Object)resourceManyToOne.getId());
        GenericOrmManyToOneMapping2_0Tests.assertFalse((boolean)((OrmManyToOneMapping2_0)contextAttribute.getMapping()).getDerivedIdentity().getIdDerivedIdentityStrategy().getValue());
        GenericOrmManyToOneMapping2_0Tests.assertEquals((String)"foo", (String)resourceManyToOne.getMapsId());
        GenericOrmManyToOneMapping2_0Tests.assertEquals((String)"foo", (String)((OrmManyToOneMapping2_0)contextAttribute.getMapping()).getDerivedIdentity().getMapsIdDerivedIdentityStrategy().getSpecifiedValue());
    }

    public void testVirtualJoinTable() throws Exception {
        this.createTestEntityWithValidManyToOneMapping();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.getAttributeNamed("address");
        JavaManyToOneMapping2_0 javaManyToOneMapping = (JavaManyToOneMapping2_0)ormPersistentAttribute.getJavaPersistentAttribute().getMapping();
        OrmManyToOneMapping2_0 ormManyToOneMapping = (OrmManyToOneMapping2_0)ormPersistentAttribute.getMapping();
        javaManyToOneMapping.getRelationshipReference().setJoinTableJoiningStrategy();
        OrmJoinTable ormJoinTable = ormManyToOneMapping.getRelationshipReference().getJoinTableJoiningStrategy().getJoinTable();
        GenericOrmManyToOneMapping2_0Tests.assertTrue((boolean)ormPersistentAttribute.isVirtual());
        GenericOrmManyToOneMapping2_0Tests.assertEquals(null, (String)ormJoinTable.getSpecifiedName());
        this.createTestTargetEntityAddress();
        this.getEntityMappings().addPersistentType("entity", "test.Address");
        GenericOrmManyToOneMapping2_0Tests.assertEquals((String)"AnnotationTestType_Address", (String)ormJoinTable.getSpecifiedName());
        GenericOrmManyToOneMapping2_0Tests.assertNull((Object)ormJoinTable.getSpecifiedCatalog());
        GenericOrmManyToOneMapping2_0Tests.assertNull((Object)ormJoinTable.getSpecifiedSchema());
        GenericOrmManyToOneMapping2_0Tests.assertEquals((int)0, (int)ormJoinTable.specifiedJoinColumnsSize());
        GenericOrmManyToOneMapping2_0Tests.assertEquals((int)0, (int)ormJoinTable.specifiedInverseJoinColumnsSize());
        OrmJoinColumn ormJoinColumn = ormJoinTable.getDefaultJoinColumn();
        GenericOrmManyToOneMapping2_0Tests.assertEquals((String)"AnnotationTestType_Address", (String)ormJoinColumn.getDefaultTable());
        GenericOrmManyToOneMapping2_0Tests.assertEquals((String)"AnnotationTestType_id", (String)ormJoinColumn.getDefaultName());
        GenericOrmManyToOneMapping2_0Tests.assertEquals((String)"id", (String)ormJoinColumn.getDefaultReferencedColumnName());
        OrmJoinColumn inverseOrmJoinColumn = ormJoinTable.getDefaultInverseJoinColumn();
        GenericOrmManyToOneMapping2_0Tests.assertEquals((String)"AnnotationTestType_Address", (String)inverseOrmJoinColumn.getDefaultTable());
        GenericOrmManyToOneMapping2_0Tests.assertEquals((String)"address_id", (String)inverseOrmJoinColumn.getDefaultName());
        GenericOrmManyToOneMapping2_0Tests.assertEquals((String)"id", (String)inverseOrmJoinColumn.getDefaultReferencedColumnName());
        JavaJoinTable javaJoinTable = javaManyToOneMapping.getRelationshipReference().getJoinTableJoiningStrategy().getJoinTable();
        javaJoinTable.setSpecifiedName("FOO");
        javaJoinTable.setSpecifiedCatalog("CATALOG");
        javaJoinTable.setSpecifiedSchema("SCHEMA");
        JavaJoinColumn javaJoinColumn = javaJoinTable.addSpecifiedJoinColumn(0);
        javaJoinColumn.setSpecifiedName("NAME");
        javaJoinColumn.setSpecifiedReferencedColumnName("REFERENCED_NAME");
        JavaJoinColumn inverseJavaJoinColumn = javaJoinTable.addSpecifiedInverseJoinColumn(0);
        inverseJavaJoinColumn.setSpecifiedName("INVERSE_NAME");
        inverseJavaJoinColumn.setSpecifiedReferencedColumnName("INVERSE_REFERENCED_NAME");
        GenericOrmManyToOneMapping2_0Tests.assertEquals((String)"FOO", (String)ormJoinTable.getSpecifiedName());
        GenericOrmManyToOneMapping2_0Tests.assertEquals((String)"CATALOG", (String)ormJoinTable.getSpecifiedCatalog());
        GenericOrmManyToOneMapping2_0Tests.assertEquals((String)"SCHEMA", (String)ormJoinTable.getSpecifiedSchema());
        GenericOrmManyToOneMapping2_0Tests.assertEquals((int)1, (int)ormJoinTable.specifiedJoinColumnsSize());
        GenericOrmManyToOneMapping2_0Tests.assertEquals((int)1, (int)ormJoinTable.specifiedInverseJoinColumnsSize());
        ormJoinColumn = (OrmJoinColumn)ormJoinTable.specifiedJoinColumns().next();
        GenericOrmManyToOneMapping2_0Tests.assertEquals((String)"NAME", (String)ormJoinColumn.getSpecifiedName());
        GenericOrmManyToOneMapping2_0Tests.assertEquals((String)"REFERENCED_NAME", (String)ormJoinColumn.getSpecifiedReferencedColumnName());
        inverseOrmJoinColumn = (OrmJoinColumn)ormJoinTable.specifiedInverseJoinColumns().next();
        GenericOrmManyToOneMapping2_0Tests.assertEquals((String)"INVERSE_NAME", (String)inverseOrmJoinColumn.getSpecifiedName());
        GenericOrmManyToOneMapping2_0Tests.assertEquals((String)"INVERSE_REFERENCED_NAME", (String)inverseOrmJoinColumn.getSpecifiedReferencedColumnName());
    }

    public void testUpdateDefaultNameFromJavaTable() throws Exception {
        this.createTestEntityWithValidManyToOneMapping();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("manyToOne", "address");
        OrmManyToOneMapping2_0 ormManyToOneMapping = (OrmManyToOneMapping2_0)ormPersistentAttribute.getMapping();
        ormManyToOneMapping.getRelationshipReference().setJoinTableJoiningStrategy();
        OrmJoinTable ormJoinTable = ormManyToOneMapping.getRelationshipReference().getJoinTableJoiningStrategy().getJoinTable();
        GenericOrmManyToOneMapping2_0Tests.assertEquals(null, (String)ormJoinTable.getDefaultName());
        this.createTestTargetEntityAddress();
        OrmPersistentType targetPersistentType = this.getEntityMappings().addPersistentType("entity", "test.Address");
        GenericOrmManyToOneMapping2_0Tests.assertEquals((String)"AnnotationTestType_Address", (String)ormJoinTable.getDefaultName());
        ((JavaEntity)targetPersistentType.getJavaPersistentType().getMapping()).getTable().setSpecifiedName("FOO");
        GenericOrmManyToOneMapping2_0Tests.assertEquals((String)"AnnotationTestType_FOO", (String)ormJoinTable.getDefaultName());
        ((JavaEntity)ormPersistentType.getJavaPersistentType().getMapping()).getTable().setSpecifiedName("BAR");
        GenericOrmManyToOneMapping2_0Tests.assertEquals((String)"BAR_FOO", (String)ormJoinTable.getDefaultName());
        JavaManyToOneMapping2_0 javaManyToOneMapping = (JavaManyToOneMapping2_0)ormPersistentType.getJavaPersistentType().getAttributeNamed("address").getMapping();
        javaManyToOneMapping.getRelationshipReference().setJoinTableJoiningStrategy();
        javaManyToOneMapping.getRelationshipReference().getJoinTableJoiningStrategy().getJoinTable().setSpecifiedName("JAVA_JOIN_TABLE");
        GenericOrmManyToOneMapping2_0Tests.assertEquals((String)"BAR_FOO", (String)ormJoinTable.getDefaultName());
        this.getEntityMappings().getPersistenceUnitMetadata().setXmlMappingMetadataComplete(true);
        GenericOrmManyToOneMapping2_0Tests.assertEquals((String)"AnnotationTestType_Address", (String)ormJoinTable.getDefaultName());
        this.getEntityMappings().getPersistenceUnitMetadata().setXmlMappingMetadataComplete(false);
        ormPersistentAttribute.makeVirtual();
        ormPersistentAttribute = ormPersistentType.getAttributeNamed("address");
        ormManyToOneMapping = (OrmManyToOneMapping2_0)ormPersistentAttribute.getMapping();
        ormJoinTable = ormManyToOneMapping.getRelationshipReference().getJoinTableJoiningStrategy().getJoinTable();
        GenericOrmManyToOneMapping2_0Tests.assertTrue((boolean)ormPersistentAttribute.isVirtual());
        GenericOrmManyToOneMapping2_0Tests.assertEquals((String)"JAVA_JOIN_TABLE", (String)ormJoinTable.getSpecifiedName());
        javaManyToOneMapping.getRelationshipReference().getJoinTableJoiningStrategy().getJoinTable().setSpecifiedName(null);
        ormJoinTable = ormManyToOneMapping.getRelationshipReference().getJoinTableJoiningStrategy().getJoinTable();
        GenericOrmManyToOneMapping2_0Tests.assertNull((Object)ormJoinTable);
        javaManyToOneMapping.getRelationshipReference().setJoinTableJoiningStrategy();
        ormJoinTable = ormManyToOneMapping.getRelationshipReference().getJoinTableJoiningStrategy().getJoinTable();
        GenericOrmManyToOneMapping2_0Tests.assertEquals((String)"BAR_FOO", (String)ormJoinTable.getSpecifiedName());
        GenericOrmManyToOneMapping2_0Tests.assertEquals((String)"BAR_FOO", (String)ormJoinTable.getDefaultName());
        ((OrmEntity)ormPersistentType.getMapping()).getTable().setSpecifiedName("ORM_TABLE_NAME");
        GenericOrmManyToOneMapping2_0Tests.assertEquals((String)"ORM_TABLE_NAME_FOO", (String)ormJoinTable.getDefaultName());
        ((OrmEntity)targetPersistentType.getMapping()).getTable().setSpecifiedName("ORM_TARGET");
        GenericOrmManyToOneMapping2_0Tests.assertEquals((String)"ORM_TABLE_NAME_ORM_TARGET", (String)ormJoinTable.getDefaultName());
    }

    public void testModifyPredominantJoiningStrategy() throws Exception {
        this.createTestEntityWithManyToOneMapping();
        OrmPersistentType contextType = this.getEntityMappings().getPersistentType("test.AnnotationTestType");
        OrmPersistentAttribute contextAttribute = contextType.getAttributeNamed("id");
        OrmManyToOneMapping2_0 contextMapping = (OrmManyToOneMapping2_0)contextAttribute.getMapping();
        OrmManyToOneRelationshipReference2_0 relationshipReference = contextMapping.getRelationshipReference();
        XmlEntity resourceEntity = (XmlEntity)contextType.getMapping().getResourceTypeMapping();
        XmlManyToOne resourceMapping = (XmlManyToOne)resourceEntity.getAttributes().getManyToOnes().get(0);
        GenericOrmManyToOneMapping2_0Tests.assertTrue((boolean)resourceMapping.getJoinColumns().isEmpty());
        GenericOrmManyToOneMapping2_0Tests.assertNull((Object)resourceMapping.getJoinTable());
        GenericOrmManyToOneMapping2_0Tests.assertTrue((boolean)relationshipReference.usesJoinColumnJoiningStrategy());
        GenericOrmManyToOneMapping2_0Tests.assertFalse((boolean)relationshipReference.usesJoinTableJoiningStrategy());
        relationshipReference.setJoinColumnJoiningStrategy();
        GenericOrmManyToOneMapping2_0Tests.assertTrue((boolean)resourceMapping.getJoinColumns().isEmpty());
        GenericOrmManyToOneMapping2_0Tests.assertNull((Object)resourceMapping.getJoinTable());
        GenericOrmManyToOneMapping2_0Tests.assertTrue((boolean)relationshipReference.usesJoinColumnJoiningStrategy());
        GenericOrmManyToOneMapping2_0Tests.assertFalse((boolean)relationshipReference.usesJoinTableJoiningStrategy());
        relationshipReference.setJoinTableJoiningStrategy();
        GenericOrmManyToOneMapping2_0Tests.assertTrue((boolean)resourceMapping.getJoinColumns().isEmpty());
        GenericOrmManyToOneMapping2_0Tests.assertNotNull((Object)resourceMapping.getJoinTable());
        GenericOrmManyToOneMapping2_0Tests.assertFalse((boolean)relationshipReference.usesJoinColumnJoiningStrategy());
        GenericOrmManyToOneMapping2_0Tests.assertTrue((boolean)relationshipReference.usesJoinTableJoiningStrategy());
        relationshipReference.setJoinColumnJoiningStrategy();
        GenericOrmManyToOneMapping2_0Tests.assertTrue((boolean)resourceMapping.getJoinColumns().isEmpty());
        GenericOrmManyToOneMapping2_0Tests.assertNull((Object)resourceMapping.getJoinTable());
        GenericOrmManyToOneMapping2_0Tests.assertTrue((boolean)relationshipReference.usesJoinColumnJoiningStrategy());
        GenericOrmManyToOneMapping2_0Tests.assertFalse((boolean)relationshipReference.usesJoinTableJoiningStrategy());
    }

    public void testUpdatePredominantJoiningStrategy() throws Exception {
        this.createTestEntityWithManyToOneMapping();
        OrmPersistentType contextType = this.getEntityMappings().getPersistentType("test.AnnotationTestType");
        OrmPersistentAttribute contextAttribute = contextType.getAttributeNamed("id");
        OrmManyToOneMapping2_0 contextMapping = (OrmManyToOneMapping2_0)contextAttribute.getMapping();
        OrmManyToOneRelationshipReference2_0 relationshipReference = contextMapping.getRelationshipReference();
        XmlEntity resourceEntity = (XmlEntity)contextType.getMapping().getResourceTypeMapping();
        XmlManyToOne resourceMapping = (XmlManyToOne)resourceEntity.getAttributes().getManyToOnes().get(0);
        GenericOrmManyToOneMapping2_0Tests.assertTrue((boolean)resourceMapping.getJoinColumns().isEmpty());
        GenericOrmManyToOneMapping2_0Tests.assertNull((Object)resourceMapping.getJoinTable());
        GenericOrmManyToOneMapping2_0Tests.assertTrue((boolean)relationshipReference.usesJoinColumnJoiningStrategy());
        GenericOrmManyToOneMapping2_0Tests.assertFalse((boolean)relationshipReference.usesJoinTableJoiningStrategy());
        resourceMapping.getJoinColumns().add((Object)OrmFactory.eINSTANCE.createXmlJoinColumn());
        this.getJpaProject().synchronizeContextModel();
        GenericOrmManyToOneMapping2_0Tests.assertFalse((boolean)resourceMapping.getJoinColumns().isEmpty());
        GenericOrmManyToOneMapping2_0Tests.assertNull((Object)resourceMapping.getJoinTable());
        GenericOrmManyToOneMapping2_0Tests.assertTrue((boolean)relationshipReference.usesJoinColumnJoiningStrategy());
        GenericOrmManyToOneMapping2_0Tests.assertFalse((boolean)relationshipReference.usesJoinTableJoiningStrategy());
        resourceMapping.getJoinColumns().clear();
        this.getJpaProject().synchronizeContextModel();
        GenericOrmManyToOneMapping2_0Tests.assertTrue((boolean)resourceMapping.getJoinColumns().isEmpty());
        GenericOrmManyToOneMapping2_0Tests.assertNull((Object)resourceMapping.getJoinTable());
        GenericOrmManyToOneMapping2_0Tests.assertTrue((boolean)relationshipReference.usesJoinColumnJoiningStrategy());
        GenericOrmManyToOneMapping2_0Tests.assertFalse((boolean)relationshipReference.usesJoinTableJoiningStrategy());
        resourceMapping.setJoinTable(OrmFactory.eINSTANCE.createXmlJoinTable());
        this.getJpaProject().synchronizeContextModel();
        GenericOrmManyToOneMapping2_0Tests.assertTrue((boolean)resourceMapping.getJoinColumns().isEmpty());
        GenericOrmManyToOneMapping2_0Tests.assertNotNull((Object)resourceMapping.getJoinTable());
        GenericOrmManyToOneMapping2_0Tests.assertFalse((boolean)relationshipReference.usesJoinColumnJoiningStrategy());
        GenericOrmManyToOneMapping2_0Tests.assertTrue((boolean)relationshipReference.usesJoinTableJoiningStrategy());
    }

    public void testVirtualMappingMetadataCompleteFalse() throws Exception {
        this.createTestEntityManyToOneMapping();
        this.createTestTargetEntityAddress();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        this.getEntityMappings().addPersistentType("entity", "test.Address");
        GenericOrmManyToOneMapping2_0Tests.assertEquals((int)3, (int)ormPersistentType.virtualAttributesSize());
        OrmPersistentAttribute ormPersistentAttribute = (OrmPersistentAttribute)ormPersistentType.virtualAttributes().next();
        OrmManyToOneMapping ormManyToOneMapping = (OrmManyToOneMapping)ormPersistentAttribute.getMapping();
        GenericOrmManyToOneMapping2_0Tests.assertEquals((String)"address", (String)ormManyToOneMapping.getName());
        GenericOrmManyToOneMapping2_0Tests.assertEquals((Object)FetchType.LAZY, (Object)ormManyToOneMapping.getSpecifiedFetch());
        GenericOrmManyToOneMapping2_0Tests.assertEquals((Object)Boolean.FALSE, (Object)ormManyToOneMapping.getSpecifiedOptional());
        GenericOrmManyToOneMapping2_0Tests.assertEquals((String)"Address", (String)ormManyToOneMapping.getSpecifiedTargetEntity());
        OrmJoinColumn ormJoinColumn = (OrmJoinColumn)ormManyToOneMapping.getRelationshipReference().getJoinColumnJoiningStrategy().specifiedJoinColumns().next();
        GenericOrmManyToOneMapping2_0Tests.assertEquals((String)"MY_COLUMN", (String)ormJoinColumn.getSpecifiedName());
        GenericOrmManyToOneMapping2_0Tests.assertEquals((String)"MY_REFERENCED_COLUMN", (String)ormJoinColumn.getSpecifiedReferencedColumnName());
        GenericOrmManyToOneMapping2_0Tests.assertEquals((Object)Boolean.TRUE, (Object)ormJoinColumn.getSpecifiedUnique());
        GenericOrmManyToOneMapping2_0Tests.assertEquals((Object)Boolean.FALSE, (Object)ormJoinColumn.getSpecifiedNullable());
        GenericOrmManyToOneMapping2_0Tests.assertEquals((Object)Boolean.FALSE, (Object)ormJoinColumn.getSpecifiedInsertable());
        GenericOrmManyToOneMapping2_0Tests.assertEquals((Object)Boolean.FALSE, (Object)ormJoinColumn.getSpecifiedUpdatable());
        GenericOrmManyToOneMapping2_0Tests.assertEquals((String)"COLUMN_DEFINITION", (String)ormJoinColumn.getColumnDefinition());
        GenericOrmManyToOneMapping2_0Tests.assertEquals((String)"MY_TABLE", (String)ormJoinColumn.getSpecifiedTable());
        OrmCascade2_0 cascade = ormManyToOneMapping.getCascade();
        GenericOrmManyToOneMapping2_0Tests.assertTrue((boolean)cascade.isAll());
        GenericOrmManyToOneMapping2_0Tests.assertTrue((boolean)cascade.isMerge());
        GenericOrmManyToOneMapping2_0Tests.assertTrue((boolean)cascade.isPersist());
        GenericOrmManyToOneMapping2_0Tests.assertTrue((boolean)cascade.isRemove());
        GenericOrmManyToOneMapping2_0Tests.assertTrue((boolean)cascade.isRefresh());
        GenericOrmManyToOneMapping2_0Tests.assertTrue((boolean)cascade.isDetach());
    }

    public void testVirtualMappingMetadataCompleteTrue() throws Exception {
        this.createTestEntityManyToOneMapping();
        this.createTestTargetEntityAddress();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        this.getEntityMappings().addPersistentType("entity", "test.Address");
        ormPersistentType.getMapping().setSpecifiedMetadataComplete(Boolean.TRUE);
        GenericOrmManyToOneMapping2_0Tests.assertEquals((int)3, (int)ormPersistentType.virtualAttributesSize());
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.getAttributeNamed("address");
        GenericOrmManyToOneMapping2_0Tests.assertEquals((String)MappingKeys.NULL_ATTRIBUTE_MAPPING_KEY, (String)ormPersistentAttribute.getMappingKey());
        GenericOrmManyToOneMapping2_0Tests.assertTrue((boolean)ormPersistentAttribute.isVirtual());
        ormPersistentAttribute.makeSpecified("manyToOne");
        ormPersistentAttribute = (OrmPersistentAttribute)ormPersistentType.specifiedAttributes().next();
        OrmManyToOneMapping ormManyToOneMapping = (OrmManyToOneMapping)ormPersistentAttribute.getMapping();
        GenericOrmManyToOneMapping2_0Tests.assertEquals((String)"address", (String)ormManyToOneMapping.getName());
        GenericOrmManyToOneMapping2_0Tests.assertEquals((Object)FetchType.EAGER, (Object)ormManyToOneMapping.getDefaultFetch());
        GenericOrmManyToOneMapping2_0Tests.assertEquals((boolean)true, (boolean)ormManyToOneMapping.isDefaultOptional());
        GenericOrmManyToOneMapping2_0Tests.assertEquals((String)"test.Address", (String)ormManyToOneMapping.getDefaultTargetEntity());
        OrmCascade2_0 cascade = ormManyToOneMapping.getCascade();
        GenericOrmManyToOneMapping2_0Tests.assertFalse((boolean)cascade.isAll());
        GenericOrmManyToOneMapping2_0Tests.assertFalse((boolean)cascade.isMerge());
        GenericOrmManyToOneMapping2_0Tests.assertFalse((boolean)cascade.isPersist());
        GenericOrmManyToOneMapping2_0Tests.assertFalse((boolean)cascade.isRemove());
        GenericOrmManyToOneMapping2_0Tests.assertFalse((boolean)cascade.isRefresh());
        GenericOrmManyToOneMapping2_0Tests.assertFalse((boolean)cascade.isDetach());
    }
}

