/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.tests.internal.jpa2.context.orm;

import java.util.Iterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.core.MappingKeys;
import org.eclipse.jpt.core.context.AttributeMapping;
import org.eclipse.jpt.core.context.FetchType;
import org.eclipse.jpt.core.context.OneToOneMapping;
import org.eclipse.jpt.core.context.PersistentAttribute;
import org.eclipse.jpt.core.context.java.JavaEntity;
import org.eclipse.jpt.core.context.java.JavaJoinColumn;
import org.eclipse.jpt.core.context.java.JavaJoinTable;
import org.eclipse.jpt.core.context.orm.OrmEntity;
import org.eclipse.jpt.core.context.orm.OrmJoinColumn;
import org.eclipse.jpt.core.context.orm.OrmJoinTable;
import org.eclipse.jpt.core.context.orm.OrmPersistentAttribute;
import org.eclipse.jpt.core.context.orm.OrmPersistentType;
import org.eclipse.jpt.core.jpa2.context.OneToOneMapping2_0;
import org.eclipse.jpt.core.jpa2.context.java.JavaOneToOneMapping2_0;
import org.eclipse.jpt.core.jpa2.context.orm.OrmCascade2_0;
import org.eclipse.jpt.core.jpa2.context.orm.OrmDerivedIdentity2_0;
import org.eclipse.jpt.core.jpa2.context.orm.OrmManyToOneMapping2_0;
import org.eclipse.jpt.core.jpa2.context.orm.OrmOneToOneMapping2_0;
import org.eclipse.jpt.core.jpa2.context.orm.OrmOneToOneRelationshipReference2_0;
import org.eclipse.jpt.core.jpa2.context.orm.OrmOrphanRemovable2_0;
import org.eclipse.jpt.core.jpa2.context.orm.OrmOrphanRemovalHolder2_0;
import org.eclipse.jpt.core.resource.orm.OrmFactory;
import org.eclipse.jpt.core.resource.orm.XmlEntity;
import org.eclipse.jpt.core.resource.orm.XmlManyToOne;
import org.eclipse.jpt.core.resource.orm.XmlOneToOne;
import org.eclipse.jpt.core.resource.orm.v2_0.XmlDerivedId_2_0;
import org.eclipse.jpt.core.resource.orm.v2_0.XmlMapsId_2_0;
import org.eclipse.jpt.core.tests.internal.jpa2.context.Generic2_0ContextModelTestCase;
import org.eclipse.jpt.core.tests.internal.projects.TestJavaProject;
import org.eclipse.jpt.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.jpt.utility.internal.iterators.ArrayIterator;

public class GenericOrmOneToOneMapping2_0Tests
extends Generic2_0ContextModelTestCase {
    public GenericOrmOneToOneMapping2_0Tests(String name) {
        super(name);
    }

    private void createTestEntityWithIdDerivedIdentity() throws Exception {
        this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.OneToOne", "javax.persistence.Id"});
            }

            @Override
            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }

            @Override
            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("    @OneToOne @Id").append(CR);
                sb.append("    private AnnotationTestType oneToOne;").append(CR);
                sb.append(CR);
            }
        });
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        for (OrmPersistentAttribute each : CollectionTools.iterable((Iterator)ormPersistentType.attributes())) {
            each.makeSpecified();
        }
    }

    private void createTestEntityWithMapsIdDerivedIdentity() throws Exception {
        this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.OneToOne", "javax.persistence.MapsId"});
            }

            @Override
            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }

            @Override
            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("    @OneToOne @MapsId").append(CR);
                sb.append("    private AnnotationTestType oneToOne;").append(CR);
                sb.append(CR);
            }
        });
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        for (OrmPersistentAttribute each : CollectionTools.iterable((Iterator)ormPersistentType.attributes())) {
            each.makeSpecified();
        }
    }

    private void createTestTargetEntityAddress() throws Exception {
        TestJavaProject.SourceWriter sourceWriter = new TestJavaProject.SourceWriter(){

            public void appendSourceTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Entity");
                sb.append(";");
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Id");
                sb.append(";");
                sb.append(CR);
                sb.append(CR);
                sb.append("@Entity");
                sb.append(CR);
                sb.append("public class ").append("Address").append(" ");
                sb.append("{").append(CR);
                sb.append(CR);
                sb.append("    @Id").append(CR);
                sb.append("    private int id;").append(CR);
                sb.append(CR);
                sb.append("    private String city;").append(CR);
                sb.append(CR);
                sb.append("    private State state;").append(CR);
                sb.append(CR);
                sb.append("    private int zip;").append(CR);
                sb.append(CR);
                sb.append("}").append(CR);
            }
        };
        this.javaProject.createCompilationUnit("test", "Address.java", sourceWriter);
    }

    private void createTestTargetEntityAddressWithElementCollection() throws Exception {
        TestJavaProject.SourceWriter sourceWriter = new TestJavaProject.SourceWriter(){

            public void appendSourceTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Entity");
                sb.append(";");
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Id");
                sb.append(";");
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.ElementCollection");
                sb.append(";");
                sb.append(CR);
                sb.append("@Entity");
                sb.append(CR);
                sb.append("public class ").append("Address").append(" ");
                sb.append("{").append(CR);
                sb.append(CR);
                sb.append("    @Id").append(CR);
                sb.append("    private int id;").append(CR);
                sb.append(CR);
                sb.append("    private String city;").append(CR);
                sb.append(CR);
                sb.append("    @ElementCollection").append(CR);
                sb.append("    private java.util.Collection<State> state;").append(CR);
                sb.append(CR);
                sb.append("    private int zip;").append(CR);
                sb.append(CR);
                sb.append("}").append(CR);
            }
        };
        this.javaProject.createCompilationUnit("test", "Address.java", sourceWriter);
    }

    private ICompilationUnit createTestEntityWithValidOneToOneMapping() throws Exception {
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.OneToOne", "javax.persistence.Id"});
            }

            @Override
            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }

            @Override
            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("    @OneToOne").append(CR);
                sb.append("    private Address address;").append(CR);
                sb.append(CR);
                sb.append("    @Id").append(CR);
            }
        });
    }

    private void createTestEmbeddableState() throws Exception {
        TestJavaProject.SourceWriter sourceWriter = new TestJavaProject.SourceWriter(){

            public void appendSourceTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Embeddable");
                sb.append(";");
                sb.append(CR);
                sb.append("@Embeddable");
                sb.append(CR);
                sb.append("public class ").append("State").append(" ");
                sb.append("{").append(CR);
                sb.append(CR);
                sb.append("    private String foo;").append(CR);
                sb.append(CR);
                sb.append("    private Address address;").append(CR);
                sb.append(CR);
                sb.append("}").append(CR);
            }
        };
        this.javaProject.createCompilationUnit("test", "State.java", sourceWriter);
    }

    private void createTestEntityWithOneToOneMapping() throws Exception {
        this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.OneToOne"});
            }

            @Override
            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }

            @Override
            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@OneToOne").append(CR);
            }
        });
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        for (OrmPersistentAttribute each : CollectionTools.iterable((Iterator)ormPersistentType.attributes())) {
            each.makeSpecified();
        }
    }

    private ICompilationUnit createTestEntityOneToOneMapping() throws Exception {
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.OneToOne", "javax.persistence.JoinColumn", "javax.persistence.FetchType", "javax.persistence.CascadeType"});
            }

            @Override
            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity");
            }

            @Override
            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("    @OneToOne(fetch=FetchType.LAZY, optional=false, targetEntity=Address.class, orphanRemoval = true, cascade={CascadeType.ALL, CascadeType.PERSIST, CascadeType.MERGE, CascadeType.REMOVE, CascadeType.REFRESH, CascadeType.DETACH})");
                sb.append(CR);
                sb.append("    @JoinColumn(name=\"MY_COLUMN\", referencedColumnName=\"MY_REFERENCED_COLUMN\", unique=true, nullable=false, insertable=false, updatable=false, columnDefinition=\"COLUMN_DEFINITION\", table=\"MY_TABLE\")");
                sb.append(CR);
                sb.append("    private Address address;").append(CR);
                sb.append(CR);
                sb.append("    @Id");
            }
        });
    }

    public void testUpdateId() throws Exception {
        this.createTestEntityWithIdDerivedIdentity();
        OrmPersistentType contextType = this.getEntityMappings().getPersistentType("test.AnnotationTestType");
        OrmPersistentAttribute contextAttribute = contextType.getAttributeNamed("oneToOne");
        OrmOneToOneMapping2_0 contextMapping = (OrmOneToOneMapping2_0)contextAttribute.getMapping();
        XmlEntity resourceEntity = (XmlEntity)contextType.getMapping().getResourceTypeMapping();
        XmlDerivedId_2_0 resourceMapping = (XmlDerivedId_2_0)resourceEntity.getAttributes().getOneToOnes().get(0);
        GenericOrmOneToOneMapping2_0Tests.assertNull((Object)resourceMapping.getId());
        GenericOrmOneToOneMapping2_0Tests.assertFalse((boolean)contextMapping.getDerivedIdentity().getIdDerivedIdentityStrategy().getValue());
        resourceMapping.setId(Boolean.TRUE);
        GenericOrmOneToOneMapping2_0Tests.assertEquals((Object)Boolean.TRUE, (Object)resourceMapping.getId());
        GenericOrmOneToOneMapping2_0Tests.assertTrue((boolean)contextMapping.getDerivedIdentity().getIdDerivedIdentityStrategy().getValue());
        resourceMapping.setId(Boolean.FALSE);
        GenericOrmOneToOneMapping2_0Tests.assertEquals((Object)Boolean.FALSE, (Object)resourceMapping.getId());
        GenericOrmOneToOneMapping2_0Tests.assertFalse((boolean)contextMapping.getDerivedIdentity().getIdDerivedIdentityStrategy().getValue());
        resourceMapping.setId(null);
        GenericOrmOneToOneMapping2_0Tests.assertNull((Object)resourceMapping.getId());
        GenericOrmOneToOneMapping2_0Tests.assertFalse((boolean)contextMapping.getDerivedIdentity().getIdDerivedIdentityStrategy().getValue());
    }

    public void testSetId() throws Exception {
        this.createTestEntityWithIdDerivedIdentity();
        OrmPersistentType contextType = this.getEntityMappings().getPersistentType("test.AnnotationTestType");
        OrmPersistentAttribute contextAttribute = contextType.getAttributeNamed("oneToOne");
        OrmOneToOneMapping2_0 contextMapping = (OrmOneToOneMapping2_0)contextAttribute.getMapping();
        XmlEntity resourceEntity = (XmlEntity)contextType.getMapping().getResourceTypeMapping();
        XmlDerivedId_2_0 resourceMapping = (XmlDerivedId_2_0)resourceEntity.getAttributes().getOneToOnes().get(0);
        GenericOrmOneToOneMapping2_0Tests.assertNull((Object)resourceMapping.getId());
        GenericOrmOneToOneMapping2_0Tests.assertFalse((boolean)contextMapping.getDerivedIdentity().getIdDerivedIdentityStrategy().getValue());
        contextMapping.getDerivedIdentity().getIdDerivedIdentityStrategy().setValue(true);
        GenericOrmOneToOneMapping2_0Tests.assertEquals((Object)Boolean.TRUE, (Object)resourceMapping.getId());
        GenericOrmOneToOneMapping2_0Tests.assertTrue((boolean)contextMapping.getDerivedIdentity().getIdDerivedIdentityStrategy().getValue());
        contextMapping.getDerivedIdentity().getIdDerivedIdentityStrategy().setValue(false);
        GenericOrmOneToOneMapping2_0Tests.assertNull((Object)resourceMapping.getId());
        GenericOrmOneToOneMapping2_0Tests.assertFalse((boolean)contextMapping.getDerivedIdentity().getIdDerivedIdentityStrategy().getValue());
    }

    public void testUpdateMapsId() throws Exception {
        this.createTestEntityWithMapsIdDerivedIdentity();
        OrmPersistentType contextType = this.getEntityMappings().getPersistentType("test.AnnotationTestType");
        OrmPersistentAttribute contextAttribute = contextType.getAttributeNamed("oneToOne");
        OrmOneToOneMapping2_0 contextMapping = (OrmOneToOneMapping2_0)contextAttribute.getMapping();
        XmlEntity resourceEntity = (XmlEntity)contextType.getMapping().getResourceTypeMapping();
        XmlMapsId_2_0 resourceMapping = (XmlMapsId_2_0)resourceEntity.getAttributes().getOneToOnes().get(0);
        GenericOrmOneToOneMapping2_0Tests.assertNull((Object)resourceMapping.getMapsId());
        GenericOrmOneToOneMapping2_0Tests.assertNull((Object)contextMapping.getDerivedIdentity().getMapsIdDerivedIdentityStrategy().getSpecifiedValue());
        resourceMapping.setMapsId("foo");
        GenericOrmOneToOneMapping2_0Tests.assertEquals((String)"foo", (String)resourceMapping.getMapsId());
        GenericOrmOneToOneMapping2_0Tests.assertEquals((String)"foo", (String)contextMapping.getDerivedIdentity().getMapsIdDerivedIdentityStrategy().getSpecifiedValue());
        resourceMapping.setMapsId("bar");
        GenericOrmOneToOneMapping2_0Tests.assertEquals((String)"bar", (String)resourceMapping.getMapsId());
        GenericOrmOneToOneMapping2_0Tests.assertEquals((String)"bar", (String)contextMapping.getDerivedIdentity().getMapsIdDerivedIdentityStrategy().getSpecifiedValue());
        resourceMapping.setMapsId("");
        GenericOrmOneToOneMapping2_0Tests.assertEquals((String)"", (String)resourceMapping.getMapsId());
        GenericOrmOneToOneMapping2_0Tests.assertEquals((String)"", (String)contextMapping.getDerivedIdentity().getMapsIdDerivedIdentityStrategy().getSpecifiedValue());
        resourceMapping.setMapsId(null);
        GenericOrmOneToOneMapping2_0Tests.assertNull((Object)resourceMapping.getMapsId());
        GenericOrmOneToOneMapping2_0Tests.assertNull((Object)contextMapping.getDerivedIdentity().getMapsIdDerivedIdentityStrategy().getSpecifiedValue());
    }

    public void testSetMapsId() throws Exception {
        this.createTestEntityWithMapsIdDerivedIdentity();
        OrmPersistentType contextType = this.getEntityMappings().getPersistentType("test.AnnotationTestType");
        OrmPersistentAttribute contextAttribute = contextType.getAttributeNamed("oneToOne");
        OrmOneToOneMapping2_0 contextMapping = (OrmOneToOneMapping2_0)contextAttribute.getMapping();
        XmlEntity resourceEntity = (XmlEntity)contextType.getMapping().getResourceTypeMapping();
        XmlMapsId_2_0 resourceMapping = (XmlMapsId_2_0)resourceEntity.getAttributes().getOneToOnes().get(0);
        GenericOrmOneToOneMapping2_0Tests.assertNull((Object)resourceMapping.getMapsId());
        GenericOrmOneToOneMapping2_0Tests.assertNull((Object)contextMapping.getDerivedIdentity().getMapsIdDerivedIdentityStrategy().getSpecifiedValue());
        contextMapping.getDerivedIdentity().getMapsIdDerivedIdentityStrategy().setSpecifiedValue("foo");
        GenericOrmOneToOneMapping2_0Tests.assertEquals((String)"foo", (String)resourceMapping.getMapsId());
        GenericOrmOneToOneMapping2_0Tests.assertEquals((String)"foo", (String)contextMapping.getDerivedIdentity().getMapsIdDerivedIdentityStrategy().getSpecifiedValue());
        contextMapping.getDerivedIdentity().getMapsIdDerivedIdentityStrategy().setSpecifiedValue("bar");
        GenericOrmOneToOneMapping2_0Tests.assertEquals((String)"bar", (String)resourceMapping.getMapsId());
        GenericOrmOneToOneMapping2_0Tests.assertEquals((String)"bar", (String)contextMapping.getDerivedIdentity().getMapsIdDerivedIdentityStrategy().getSpecifiedValue());
        contextMapping.getDerivedIdentity().getMapsIdDerivedIdentityStrategy().setSpecifiedValue("");
        GenericOrmOneToOneMapping2_0Tests.assertEquals((String)"", (String)resourceMapping.getMapsId());
        GenericOrmOneToOneMapping2_0Tests.assertEquals((String)"", (String)contextMapping.getDerivedIdentity().getMapsIdDerivedIdentityStrategy().getSpecifiedValue());
        contextMapping.getDerivedIdentity().getMapsIdDerivedIdentityStrategy().setSpecifiedValue(null);
        GenericOrmOneToOneMapping2_0Tests.assertNull((Object)resourceMapping.getMapsId());
        GenericOrmOneToOneMapping2_0Tests.assertNull((Object)contextMapping.getDerivedIdentity().getMapsIdDerivedIdentityStrategy().getSpecifiedValue());
    }

    public void testUpdatePredominantDerivedIdentityStrategy() throws Exception {
        this.createTestEntityWithIdDerivedIdentity();
        OrmPersistentType contextType = this.getEntityMappings().getPersistentType("test.AnnotationTestType");
        OrmPersistentAttribute contextAttribute = contextType.getAttributeNamed("oneToOne");
        OrmOneToOneMapping2_0 contextMapping = (OrmOneToOneMapping2_0)contextAttribute.getMapping();
        OrmDerivedIdentity2_0 derivedIdentity = contextMapping.getDerivedIdentity();
        XmlEntity resourceEntity = (XmlEntity)contextType.getMapping().getResourceTypeMapping();
        XmlOneToOne resourceMapping = (XmlOneToOne)resourceEntity.getAttributes().getOneToOnes().get(0);
        GenericOrmOneToOneMapping2_0Tests.assertNull((Object)resourceMapping.getMapsId());
        GenericOrmOneToOneMapping2_0Tests.assertNull((Object)resourceMapping.getId());
        GenericOrmOneToOneMapping2_0Tests.assertFalse((boolean)derivedIdentity.usesMapsIdDerivedIdentityStrategy());
        GenericOrmOneToOneMapping2_0Tests.assertFalse((boolean)derivedIdentity.usesIdDerivedIdentityStrategy());
        GenericOrmOneToOneMapping2_0Tests.assertTrue((boolean)derivedIdentity.usesNullDerivedIdentityStrategy());
        resourceMapping.setId(Boolean.TRUE);
        GenericOrmOneToOneMapping2_0Tests.assertNull((Object)resourceMapping.getMapsId());
        GenericOrmOneToOneMapping2_0Tests.assertNotNull((Object)resourceMapping.getId());
        GenericOrmOneToOneMapping2_0Tests.assertFalse((boolean)derivedIdentity.usesMapsIdDerivedIdentityStrategy());
        GenericOrmOneToOneMapping2_0Tests.assertTrue((boolean)derivedIdentity.usesIdDerivedIdentityStrategy());
        GenericOrmOneToOneMapping2_0Tests.assertFalse((boolean)derivedIdentity.usesNullDerivedIdentityStrategy());
        resourceMapping.setMapsId("foo");
        GenericOrmOneToOneMapping2_0Tests.assertNotNull((Object)resourceMapping.getMapsId());
        GenericOrmOneToOneMapping2_0Tests.assertNotNull((Object)resourceMapping.getId());
        GenericOrmOneToOneMapping2_0Tests.assertTrue((boolean)derivedIdentity.usesMapsIdDerivedIdentityStrategy());
        GenericOrmOneToOneMapping2_0Tests.assertFalse((boolean)derivedIdentity.usesIdDerivedIdentityStrategy());
        GenericOrmOneToOneMapping2_0Tests.assertFalse((boolean)derivedIdentity.usesNullDerivedIdentityStrategy());
        resourceMapping.setId(null);
        GenericOrmOneToOneMapping2_0Tests.assertNotNull((Object)resourceMapping.getMapsId());
        GenericOrmOneToOneMapping2_0Tests.assertNull((Object)resourceMapping.getId());
        GenericOrmOneToOneMapping2_0Tests.assertTrue((boolean)derivedIdentity.usesMapsIdDerivedIdentityStrategy());
        GenericOrmOneToOneMapping2_0Tests.assertFalse((boolean)derivedIdentity.usesIdDerivedIdentityStrategy());
        GenericOrmOneToOneMapping2_0Tests.assertFalse((boolean)derivedIdentity.usesNullDerivedIdentityStrategy());
        resourceMapping.setMapsId(null);
        GenericOrmOneToOneMapping2_0Tests.assertNull((Object)resourceMapping.getMapsId());
        GenericOrmOneToOneMapping2_0Tests.assertNull((Object)resourceMapping.getId());
        GenericOrmOneToOneMapping2_0Tests.assertFalse((boolean)derivedIdentity.usesMapsIdDerivedIdentityStrategy());
        GenericOrmOneToOneMapping2_0Tests.assertFalse((boolean)derivedIdentity.usesIdDerivedIdentityStrategy());
        GenericOrmOneToOneMapping2_0Tests.assertTrue((boolean)derivedIdentity.usesNullDerivedIdentityStrategy());
    }

    public void testSetPredominantDerivedIdentityStrategy() throws Exception {
        this.createTestEntityWithIdDerivedIdentity();
        OrmPersistentType contextType = this.getEntityMappings().getPersistentType("test.AnnotationTestType");
        OrmPersistentAttribute contextAttribute = contextType.getAttributeNamed("oneToOne");
        OrmOneToOneMapping2_0 contextMapping = (OrmOneToOneMapping2_0)contextAttribute.getMapping();
        OrmDerivedIdentity2_0 derivedIdentity = contextMapping.getDerivedIdentity();
        XmlEntity resourceEntity = (XmlEntity)contextType.getMapping().getResourceTypeMapping();
        XmlOneToOne resourceMapping = (XmlOneToOne)resourceEntity.getAttributes().getOneToOnes().get(0);
        GenericOrmOneToOneMapping2_0Tests.assertNull((Object)resourceMapping.getMapsId());
        GenericOrmOneToOneMapping2_0Tests.assertNull((Object)resourceMapping.getId());
        GenericOrmOneToOneMapping2_0Tests.assertFalse((boolean)derivedIdentity.usesMapsIdDerivedIdentityStrategy());
        GenericOrmOneToOneMapping2_0Tests.assertFalse((boolean)derivedIdentity.usesIdDerivedIdentityStrategy());
        GenericOrmOneToOneMapping2_0Tests.assertTrue((boolean)derivedIdentity.usesNullDerivedIdentityStrategy());
        derivedIdentity.setIdDerivedIdentityStrategy();
        GenericOrmOneToOneMapping2_0Tests.assertNull((Object)resourceMapping.getMapsId());
        GenericOrmOneToOneMapping2_0Tests.assertNotNull((Object)resourceMapping.getId());
        GenericOrmOneToOneMapping2_0Tests.assertFalse((boolean)derivedIdentity.usesMapsIdDerivedIdentityStrategy());
        GenericOrmOneToOneMapping2_0Tests.assertTrue((boolean)derivedIdentity.usesIdDerivedIdentityStrategy());
        GenericOrmOneToOneMapping2_0Tests.assertFalse((boolean)derivedIdentity.usesNullDerivedIdentityStrategy());
        derivedIdentity.setMapsIdDerivedIdentityStrategy();
        GenericOrmOneToOneMapping2_0Tests.assertNotNull((Object)resourceMapping.getMapsId());
        GenericOrmOneToOneMapping2_0Tests.assertNull((Object)resourceMapping.getId());
        GenericOrmOneToOneMapping2_0Tests.assertTrue((boolean)derivedIdentity.usesMapsIdDerivedIdentityStrategy());
        GenericOrmOneToOneMapping2_0Tests.assertFalse((boolean)derivedIdentity.usesIdDerivedIdentityStrategy());
        GenericOrmOneToOneMapping2_0Tests.assertFalse((boolean)derivedIdentity.usesNullDerivedIdentityStrategy());
        derivedIdentity.setNullDerivedIdentityStrategy();
        GenericOrmOneToOneMapping2_0Tests.assertNull((Object)resourceMapping.getMapsId());
        GenericOrmOneToOneMapping2_0Tests.assertNull((Object)resourceMapping.getId());
        GenericOrmOneToOneMapping2_0Tests.assertFalse((boolean)derivedIdentity.usesMapsIdDerivedIdentityStrategy());
        GenericOrmOneToOneMapping2_0Tests.assertFalse((boolean)derivedIdentity.usesIdDerivedIdentityStrategy());
        GenericOrmOneToOneMapping2_0Tests.assertTrue((boolean)derivedIdentity.usesNullDerivedIdentityStrategy());
    }

    public void testMorphMapping() throws Exception {
        this.createTestEntityWithIdDerivedIdentity();
        OrmPersistentType contextType = this.getEntityMappings().getPersistentType("test.AnnotationTestType");
        OrmPersistentAttribute contextAttribute = contextType.getAttributeNamed("oneToOne");
        XmlEntity resourceEntity = (XmlEntity)contextType.getMapping().getResourceTypeMapping();
        XmlOneToOne resourceOneToOne = (XmlOneToOne)resourceEntity.getAttributes().getOneToOnes().get(0);
        resourceOneToOne.setId(Boolean.TRUE);
        GenericOrmOneToOneMapping2_0Tests.assertEquals((Object)Boolean.TRUE, (Object)resourceOneToOne.getId());
        GenericOrmOneToOneMapping2_0Tests.assertTrue((boolean)((OrmOneToOneMapping2_0)contextAttribute.getMapping()).getDerivedIdentity().getIdDerivedIdentityStrategy().getValue());
        GenericOrmOneToOneMapping2_0Tests.assertNull((Object)resourceOneToOne.getMapsId());
        GenericOrmOneToOneMapping2_0Tests.assertNull((Object)((OrmOneToOneMapping2_0)contextAttribute.getMapping()).getDerivedIdentity().getMapsIdDerivedIdentityStrategy().getSpecifiedValue());
        contextAttribute.setSpecifiedMappingKey("manyToOne");
        XmlManyToOne resourceManyToOne = (XmlManyToOne)resourceEntity.getAttributes().getManyToOnes().get(0);
        GenericOrmOneToOneMapping2_0Tests.assertEquals((Object)Boolean.TRUE, (Object)resourceManyToOne.getId());
        GenericOrmOneToOneMapping2_0Tests.assertTrue((boolean)((OrmManyToOneMapping2_0)contextAttribute.getMapping()).getDerivedIdentity().getIdDerivedIdentityStrategy().getValue());
        GenericOrmOneToOneMapping2_0Tests.assertNull((Object)resourceManyToOne.getMapsId());
        GenericOrmOneToOneMapping2_0Tests.assertNull((Object)((OrmManyToOneMapping2_0)contextAttribute.getMapping()).getDerivedIdentity().getMapsIdDerivedIdentityStrategy().getSpecifiedValue());
        contextAttribute.setSpecifiedMappingKey("oneToOne");
        resourceOneToOne = (XmlOneToOne)resourceEntity.getAttributes().getOneToOnes().get(0);
        GenericOrmOneToOneMapping2_0Tests.assertEquals((Object)Boolean.TRUE, (Object)resourceOneToOne.getId());
        GenericOrmOneToOneMapping2_0Tests.assertTrue((boolean)((OrmOneToOneMapping2_0)contextAttribute.getMapping()).getDerivedIdentity().getIdDerivedIdentityStrategy().getValue());
        GenericOrmOneToOneMapping2_0Tests.assertNull((Object)resourceOneToOne.getMapsId());
        GenericOrmOneToOneMapping2_0Tests.assertNull((Object)((OrmOneToOneMapping2_0)contextAttribute.getMapping()).getDerivedIdentity().getMapsIdDerivedIdentityStrategy().getSpecifiedValue());
    }

    public void testCandidateMappedByAttributeNames() throws Exception {
        this.createTestEntityWithValidOneToOneMapping();
        this.createTestTargetEntityAddress();
        this.createTestEmbeddableState();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        this.getEntityMappings().addPersistentType("entity", "test.Address");
        this.getEntityMappings().addPersistentType("embeddable", "test.State");
        ormPersistentType.addSpecifiedAttribute("oneToOne", "address");
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef("test.Address");
        this.addXmlClassRef("test.State");
        PersistentAttribute persistentAttribute = (PersistentAttribute)ormPersistentType.attributes().next();
        OneToOneMapping oneToOneMapping = (OneToOneMapping)persistentAttribute.getMapping();
        Iterator attributeNames = oneToOneMapping.getRelationshipReference().getMappedByJoiningStrategy().candidateMappedByAttributeNames();
        GenericOrmOneToOneMapping2_0Tests.assertEquals((String)"id", (String)((String)attributeNames.next()));
        GenericOrmOneToOneMapping2_0Tests.assertEquals((String)"city", (String)((String)attributeNames.next()));
        GenericOrmOneToOneMapping2_0Tests.assertEquals((String)"state", (String)((String)attributeNames.next()));
        GenericOrmOneToOneMapping2_0Tests.assertEquals((String)"state.foo", (String)((String)attributeNames.next()));
        GenericOrmOneToOneMapping2_0Tests.assertEquals((String)"state.address", (String)((String)attributeNames.next()));
        GenericOrmOneToOneMapping2_0Tests.assertEquals((String)"zip", (String)((String)attributeNames.next()));
        GenericOrmOneToOneMapping2_0Tests.assertFalse((boolean)attributeNames.hasNext());
        oneToOneMapping.setSpecifiedTargetEntity("foo");
        attributeNames = oneToOneMapping.getRelationshipReference().getMappedByJoiningStrategy().candidateMappedByAttributeNames();
        GenericOrmOneToOneMapping2_0Tests.assertFalse((boolean)attributeNames.hasNext());
        oneToOneMapping.setSpecifiedTargetEntity(null);
        attributeNames = oneToOneMapping.getRelationshipReference().getMappedByJoiningStrategy().candidateMappedByAttributeNames();
        GenericOrmOneToOneMapping2_0Tests.assertEquals((String)"id", (String)((String)attributeNames.next()));
        GenericOrmOneToOneMapping2_0Tests.assertEquals((String)"city", (String)((String)attributeNames.next()));
        GenericOrmOneToOneMapping2_0Tests.assertEquals((String)"state", (String)((String)attributeNames.next()));
        GenericOrmOneToOneMapping2_0Tests.assertEquals((String)"state.foo", (String)((String)attributeNames.next()));
        GenericOrmOneToOneMapping2_0Tests.assertEquals((String)"state.address", (String)((String)attributeNames.next()));
        GenericOrmOneToOneMapping2_0Tests.assertEquals((String)"zip", (String)((String)attributeNames.next()));
        GenericOrmOneToOneMapping2_0Tests.assertFalse((boolean)attributeNames.hasNext());
        AttributeMapping stateFooMapping = oneToOneMapping.getResolvedTargetEntity().resolveAttributeMapping("state.foo");
        GenericOrmOneToOneMapping2_0Tests.assertEquals((String)"foo", (String)stateFooMapping.getName());
    }

    public void testCandidateMappedByAttributeNamesElementCollection() throws Exception {
        this.createTestEntityWithValidOneToOneMapping();
        this.createTestTargetEntityAddressWithElementCollection();
        this.createTestEmbeddableState();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        this.getEntityMappings().addPersistentType("entity", "test.Address");
        this.getEntityMappings().addPersistentType("embeddable", "test.State");
        ormPersistentType.addSpecifiedAttribute("oneToOne", "address");
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef("test.Address");
        this.addXmlClassRef("test.State");
        PersistentAttribute persistentAttribute = (PersistentAttribute)ormPersistentType.attributes().next();
        OneToOneMapping oneToOneMapping = (OneToOneMapping)persistentAttribute.getMapping();
        Iterator attributeNames = oneToOneMapping.getRelationshipReference().getMappedByJoiningStrategy().candidateMappedByAttributeNames();
        GenericOrmOneToOneMapping2_0Tests.assertEquals((String)"id", (String)((String)attributeNames.next()));
        GenericOrmOneToOneMapping2_0Tests.assertEquals((String)"city", (String)((String)attributeNames.next()));
        GenericOrmOneToOneMapping2_0Tests.assertEquals((String)"state", (String)((String)attributeNames.next()));
        GenericOrmOneToOneMapping2_0Tests.assertEquals((String)"state.foo", (String)((String)attributeNames.next()));
        GenericOrmOneToOneMapping2_0Tests.assertEquals((String)"state.address", (String)((String)attributeNames.next()));
        GenericOrmOneToOneMapping2_0Tests.assertEquals((String)"zip", (String)((String)attributeNames.next()));
        GenericOrmOneToOneMapping2_0Tests.assertFalse((boolean)attributeNames.hasNext());
        oneToOneMapping.setSpecifiedTargetEntity("foo");
        attributeNames = oneToOneMapping.getRelationshipReference().getMappedByJoiningStrategy().candidateMappedByAttributeNames();
        GenericOrmOneToOneMapping2_0Tests.assertFalse((boolean)attributeNames.hasNext());
        oneToOneMapping.setSpecifiedTargetEntity(null);
        attributeNames = oneToOneMapping.getRelationshipReference().getMappedByJoiningStrategy().candidateMappedByAttributeNames();
        GenericOrmOneToOneMapping2_0Tests.assertEquals((String)"id", (String)((String)attributeNames.next()));
        GenericOrmOneToOneMapping2_0Tests.assertEquals((String)"city", (String)((String)attributeNames.next()));
        GenericOrmOneToOneMapping2_0Tests.assertEquals((String)"state", (String)((String)attributeNames.next()));
        GenericOrmOneToOneMapping2_0Tests.assertEquals((String)"state.foo", (String)((String)attributeNames.next()));
        GenericOrmOneToOneMapping2_0Tests.assertEquals((String)"state.address", (String)((String)attributeNames.next()));
        GenericOrmOneToOneMapping2_0Tests.assertEquals((String)"zip", (String)((String)attributeNames.next()));
        GenericOrmOneToOneMapping2_0Tests.assertFalse((boolean)attributeNames.hasNext());
        AttributeMapping stateFooMapping = oneToOneMapping.getResolvedTargetEntity().resolveAttributeMapping("state.foo");
        GenericOrmOneToOneMapping2_0Tests.assertEquals((String)"foo", (String)stateFooMapping.getName());
    }

    private OrmOrphanRemovable2_0 getOrphanRemovalOf(OneToOneMapping2_0 oneToOneMapping) {
        return ((OrmOrphanRemovalHolder2_0)oneToOneMapping).getOrphanRemoval();
    }

    public void testUpdateSpecifiedOrphanRemoval() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "model.Foo");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("oneToOne", "oneToOneMapping");
        OrmOneToOneMapping2_0 ormOneToOneMapping = (OrmOneToOneMapping2_0)ormPersistentAttribute.getMapping();
        OrmOrphanRemovable2_0 mappingsOrphanRemoval = this.getOrphanRemovalOf((OneToOneMapping2_0)ormOneToOneMapping);
        XmlOneToOne oneToOneResource = (XmlOneToOne)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getOneToOnes().get(0);
        GenericOrmOneToOneMapping2_0Tests.assertEquals(null, (Object)mappingsOrphanRemoval.getSpecifiedOrphanRemoval());
        GenericOrmOneToOneMapping2_0Tests.assertEquals(null, (Object)oneToOneResource.getOrphanRemoval());
        oneToOneResource.setOrphanRemoval(Boolean.TRUE);
        GenericOrmOneToOneMapping2_0Tests.assertEquals((Object)Boolean.TRUE, (Object)mappingsOrphanRemoval.getSpecifiedOrphanRemoval());
        GenericOrmOneToOneMapping2_0Tests.assertEquals((Object)Boolean.TRUE, (Object)oneToOneResource.getOrphanRemoval());
        oneToOneResource.setOrphanRemoval(Boolean.FALSE);
        GenericOrmOneToOneMapping2_0Tests.assertEquals((Object)Boolean.FALSE, (Object)mappingsOrphanRemoval.getSpecifiedOrphanRemoval());
        GenericOrmOneToOneMapping2_0Tests.assertEquals((Object)Boolean.FALSE, (Object)oneToOneResource.getOrphanRemoval());
    }

    public void testModifySpecifiedOrphanRemoval() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "model.Foo");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("oneToOne", "oneToOneMapping");
        OrmOneToOneMapping2_0 ormOneToOneMapping = (OrmOneToOneMapping2_0)ormPersistentAttribute.getMapping();
        OrmOrphanRemovable2_0 mappingsOrphanRemoval = this.getOrphanRemovalOf((OneToOneMapping2_0)ormOneToOneMapping);
        XmlOneToOne oneToOneResource = (XmlOneToOne)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getOneToOnes().get(0);
        GenericOrmOneToOneMapping2_0Tests.assertEquals(null, (Object)mappingsOrphanRemoval.getSpecifiedOrphanRemoval());
        GenericOrmOneToOneMapping2_0Tests.assertEquals(null, (Object)oneToOneResource.getOrphanRemoval());
        mappingsOrphanRemoval.setSpecifiedOrphanRemoval(Boolean.TRUE);
        GenericOrmOneToOneMapping2_0Tests.assertEquals((Object)Boolean.TRUE, (Object)oneToOneResource.getOrphanRemoval());
        GenericOrmOneToOneMapping2_0Tests.assertEquals((Object)Boolean.TRUE, (Object)mappingsOrphanRemoval.getSpecifiedOrphanRemoval());
        mappingsOrphanRemoval.setSpecifiedOrphanRemoval(Boolean.FALSE);
        GenericOrmOneToOneMapping2_0Tests.assertEquals((Object)Boolean.FALSE, (Object)oneToOneResource.getOrphanRemoval());
        GenericOrmOneToOneMapping2_0Tests.assertEquals((Object)Boolean.FALSE, (Object)mappingsOrphanRemoval.getSpecifiedOrphanRemoval());
    }

    public void testVirtualJoinTable() throws Exception {
        this.createTestEntityWithValidOneToOneMapping();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.getAttributeNamed("address");
        JavaOneToOneMapping2_0 javaOneToOneMapping = (JavaOneToOneMapping2_0)ormPersistentAttribute.getJavaPersistentAttribute().getMapping();
        OrmOneToOneMapping2_0 ormOneToOneMapping = (OrmOneToOneMapping2_0)ormPersistentAttribute.getMapping();
        javaOneToOneMapping.getRelationshipReference().setJoinTableJoiningStrategy();
        OrmJoinTable ormJoinTable = ormOneToOneMapping.getRelationshipReference().getJoinTableJoiningStrategy().getJoinTable();
        GenericOrmOneToOneMapping2_0Tests.assertTrue((boolean)ormPersistentAttribute.isVirtual());
        GenericOrmOneToOneMapping2_0Tests.assertEquals(null, (String)ormJoinTable.getSpecifiedName());
        this.createTestTargetEntityAddress();
        this.getEntityMappings().addPersistentType("entity", "test.Address");
        GenericOrmOneToOneMapping2_0Tests.assertEquals((String)"AnnotationTestType_Address", (String)ormJoinTable.getSpecifiedName());
        GenericOrmOneToOneMapping2_0Tests.assertNull((Object)ormJoinTable.getSpecifiedCatalog());
        GenericOrmOneToOneMapping2_0Tests.assertNull((Object)ormJoinTable.getSpecifiedSchema());
        GenericOrmOneToOneMapping2_0Tests.assertEquals((int)0, (int)ormJoinTable.specifiedJoinColumnsSize());
        GenericOrmOneToOneMapping2_0Tests.assertEquals((int)0, (int)ormJoinTable.specifiedInverseJoinColumnsSize());
        OrmJoinColumn ormJoinColumn = ormJoinTable.getDefaultJoinColumn();
        GenericOrmOneToOneMapping2_0Tests.assertEquals((String)"AnnotationTestType_Address", (String)ormJoinColumn.getDefaultTable());
        GenericOrmOneToOneMapping2_0Tests.assertEquals((String)"AnnotationTestType_id", (String)ormJoinColumn.getDefaultName());
        GenericOrmOneToOneMapping2_0Tests.assertEquals((String)"id", (String)ormJoinColumn.getDefaultReferencedColumnName());
        OrmJoinColumn inverseOrmJoinColumn = ormJoinTable.getDefaultInverseJoinColumn();
        GenericOrmOneToOneMapping2_0Tests.assertEquals((String)"AnnotationTestType_Address", (String)inverseOrmJoinColumn.getDefaultTable());
        GenericOrmOneToOneMapping2_0Tests.assertEquals((String)"address_id", (String)inverseOrmJoinColumn.getDefaultName());
        GenericOrmOneToOneMapping2_0Tests.assertEquals((String)"id", (String)inverseOrmJoinColumn.getDefaultReferencedColumnName());
        JavaJoinTable javaJoinTable = javaOneToOneMapping.getRelationshipReference().getJoinTableJoiningStrategy().getJoinTable();
        javaJoinTable.setSpecifiedName("FOO");
        javaJoinTable.setSpecifiedCatalog("CATALOG");
        javaJoinTable.setSpecifiedSchema("SCHEMA");
        JavaJoinColumn javaJoinColumn = javaJoinTable.addSpecifiedJoinColumn(0);
        javaJoinColumn.setSpecifiedName("NAME");
        javaJoinColumn.setSpecifiedReferencedColumnName("REFERENCED_NAME");
        JavaJoinColumn inverseJavaJoinColumn = javaJoinTable.addSpecifiedInverseJoinColumn(0);
        inverseJavaJoinColumn.setSpecifiedName("INVERSE_NAME");
        inverseJavaJoinColumn.setSpecifiedReferencedColumnName("INVERSE_REFERENCED_NAME");
        GenericOrmOneToOneMapping2_0Tests.assertEquals((String)"FOO", (String)ormJoinTable.getSpecifiedName());
        GenericOrmOneToOneMapping2_0Tests.assertEquals((String)"CATALOG", (String)ormJoinTable.getSpecifiedCatalog());
        GenericOrmOneToOneMapping2_0Tests.assertEquals((String)"SCHEMA", (String)ormJoinTable.getSpecifiedSchema());
        GenericOrmOneToOneMapping2_0Tests.assertEquals((int)1, (int)ormJoinTable.specifiedJoinColumnsSize());
        GenericOrmOneToOneMapping2_0Tests.assertEquals((int)1, (int)ormJoinTable.specifiedInverseJoinColumnsSize());
        ormJoinColumn = (OrmJoinColumn)ormJoinTable.specifiedJoinColumns().next();
        GenericOrmOneToOneMapping2_0Tests.assertEquals((String)"NAME", (String)ormJoinColumn.getSpecifiedName());
        GenericOrmOneToOneMapping2_0Tests.assertEquals((String)"REFERENCED_NAME", (String)ormJoinColumn.getSpecifiedReferencedColumnName());
        inverseOrmJoinColumn = (OrmJoinColumn)ormJoinTable.specifiedInverseJoinColumns().next();
        GenericOrmOneToOneMapping2_0Tests.assertEquals((String)"INVERSE_NAME", (String)inverseOrmJoinColumn.getSpecifiedName());
        GenericOrmOneToOneMapping2_0Tests.assertEquals((String)"INVERSE_REFERENCED_NAME", (String)inverseOrmJoinColumn.getSpecifiedReferencedColumnName());
    }

    public void testUpdateDefaultNameFromJavaTable() throws Exception {
        this.createTestEntityWithValidOneToOneMapping();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("oneToOne", "address");
        OrmOneToOneMapping2_0 ormOneToOneMapping = (OrmOneToOneMapping2_0)ormPersistentAttribute.getMapping();
        ormOneToOneMapping.getRelationshipReference().setJoinTableJoiningStrategy();
        OrmJoinTable ormJoinTable = ormOneToOneMapping.getRelationshipReference().getJoinTableJoiningStrategy().getJoinTable();
        GenericOrmOneToOneMapping2_0Tests.assertEquals(null, (String)ormJoinTable.getDefaultName());
        this.createTestTargetEntityAddress();
        OrmPersistentType targetPersistentType = this.getEntityMappings().addPersistentType("entity", "test.Address");
        GenericOrmOneToOneMapping2_0Tests.assertEquals((String)"AnnotationTestType_Address", (String)ormJoinTable.getDefaultName());
        ((JavaEntity)targetPersistentType.getJavaPersistentType().getMapping()).getTable().setSpecifiedName("FOO");
        GenericOrmOneToOneMapping2_0Tests.assertEquals((String)"AnnotationTestType_FOO", (String)ormJoinTable.getDefaultName());
        ((JavaEntity)ormPersistentType.getJavaPersistentType().getMapping()).getTable().setSpecifiedName("BAR");
        GenericOrmOneToOneMapping2_0Tests.assertEquals((String)"BAR_FOO", (String)ormJoinTable.getDefaultName());
        JavaOneToOneMapping2_0 javaOneToOneMapping = (JavaOneToOneMapping2_0)ormPersistentType.getJavaPersistentType().getAttributeNamed("address").getMapping();
        javaOneToOneMapping.getRelationshipReference().setJoinTableJoiningStrategy();
        javaOneToOneMapping.getRelationshipReference().getJoinTableJoiningStrategy().getJoinTable().setSpecifiedName("JAVA_JOIN_TABLE");
        GenericOrmOneToOneMapping2_0Tests.assertEquals((String)"BAR_FOO", (String)ormJoinTable.getDefaultName());
        this.getEntityMappings().getPersistenceUnitMetadata().setXmlMappingMetadataComplete(true);
        GenericOrmOneToOneMapping2_0Tests.assertEquals((String)"AnnotationTestType_Address", (String)ormJoinTable.getDefaultName());
        this.getEntityMappings().getPersistenceUnitMetadata().setXmlMappingMetadataComplete(false);
        ormPersistentAttribute.makeVirtual();
        ormPersistentAttribute = ormPersistentType.getAttributeNamed("address");
        ormOneToOneMapping = (OrmOneToOneMapping2_0)ormPersistentAttribute.getMapping();
        ormJoinTable = ormOneToOneMapping.getRelationshipReference().getJoinTableJoiningStrategy().getJoinTable();
        GenericOrmOneToOneMapping2_0Tests.assertTrue((boolean)ormPersistentAttribute.isVirtual());
        GenericOrmOneToOneMapping2_0Tests.assertEquals((String)"JAVA_JOIN_TABLE", (String)ormJoinTable.getSpecifiedName());
        javaOneToOneMapping.getRelationshipReference().getJoinTableJoiningStrategy().getJoinTable().setSpecifiedName(null);
        ormJoinTable = ormOneToOneMapping.getRelationshipReference().getJoinTableJoiningStrategy().getJoinTable();
        GenericOrmOneToOneMapping2_0Tests.assertNull((Object)ormJoinTable);
        javaOneToOneMapping.getRelationshipReference().setJoinTableJoiningStrategy();
        ormJoinTable = ormOneToOneMapping.getRelationshipReference().getJoinTableJoiningStrategy().getJoinTable();
        GenericOrmOneToOneMapping2_0Tests.assertEquals((String)"BAR_FOO", (String)ormJoinTable.getSpecifiedName());
        GenericOrmOneToOneMapping2_0Tests.assertEquals((String)"BAR_FOO", (String)ormJoinTable.getDefaultName());
        ((OrmEntity)ormPersistentType.getMapping()).getTable().setSpecifiedName("ORM_TABLE_NAME");
        GenericOrmOneToOneMapping2_0Tests.assertEquals((String)"ORM_TABLE_NAME_FOO", (String)ormJoinTable.getDefaultName());
        ((OrmEntity)targetPersistentType.getMapping()).getTable().setSpecifiedName("ORM_TARGET");
        GenericOrmOneToOneMapping2_0Tests.assertEquals((String)"ORM_TABLE_NAME_ORM_TARGET", (String)ormJoinTable.getDefaultName());
    }

    public void testModifyPredominantJoiningStrategy() throws Exception {
        this.createTestEntityWithOneToOneMapping();
        OrmPersistentType contextType = this.getEntityMappings().getPersistentType("test.AnnotationTestType");
        OrmPersistentAttribute contextAttribute = contextType.getAttributeNamed("id");
        OrmOneToOneMapping2_0 contextMapping = (OrmOneToOneMapping2_0)contextAttribute.getMapping();
        OrmOneToOneRelationshipReference2_0 relationshipReference = contextMapping.getRelationshipReference();
        XmlEntity resourceEntity = (XmlEntity)contextType.getMapping().getResourceTypeMapping();
        XmlOneToOne resourceMapping = (XmlOneToOne)resourceEntity.getAttributes().getOneToOnes().get(0);
        GenericOrmOneToOneMapping2_0Tests.assertTrue((boolean)resourceMapping.getJoinColumns().isEmpty());
        GenericOrmOneToOneMapping2_0Tests.assertTrue((boolean)resourceMapping.getPrimaryKeyJoinColumns().isEmpty());
        GenericOrmOneToOneMapping2_0Tests.assertNull((Object)resourceMapping.getMappedBy());
        GenericOrmOneToOneMapping2_0Tests.assertNull((Object)resourceMapping.getJoinTable());
        GenericOrmOneToOneMapping2_0Tests.assertTrue((boolean)relationshipReference.usesJoinColumnJoiningStrategy());
        GenericOrmOneToOneMapping2_0Tests.assertFalse((boolean)relationshipReference.usesPrimaryKeyJoinColumnJoiningStrategy());
        GenericOrmOneToOneMapping2_0Tests.assertFalse((boolean)relationshipReference.usesMappedByJoiningStrategy());
        GenericOrmOneToOneMapping2_0Tests.assertFalse((boolean)relationshipReference.usesJoinTableJoiningStrategy());
        relationshipReference.setMappedByJoiningStrategy();
        GenericOrmOneToOneMapping2_0Tests.assertTrue((boolean)resourceMapping.getJoinColumns().isEmpty());
        GenericOrmOneToOneMapping2_0Tests.assertTrue((boolean)resourceMapping.getPrimaryKeyJoinColumns().isEmpty());
        GenericOrmOneToOneMapping2_0Tests.assertNotNull((Object)resourceMapping.getMappedBy());
        GenericOrmOneToOneMapping2_0Tests.assertNull((Object)resourceMapping.getJoinTable());
        GenericOrmOneToOneMapping2_0Tests.assertFalse((boolean)relationshipReference.usesJoinColumnJoiningStrategy());
        GenericOrmOneToOneMapping2_0Tests.assertFalse((boolean)relationshipReference.usesPrimaryKeyJoinColumnJoiningStrategy());
        GenericOrmOneToOneMapping2_0Tests.assertTrue((boolean)relationshipReference.usesMappedByJoiningStrategy());
        GenericOrmOneToOneMapping2_0Tests.assertFalse((boolean)relationshipReference.usesJoinTableJoiningStrategy());
        relationshipReference.setPrimaryKeyJoinColumnJoiningStrategy();
        GenericOrmOneToOneMapping2_0Tests.assertTrue((boolean)resourceMapping.getJoinColumns().isEmpty());
        GenericOrmOneToOneMapping2_0Tests.assertFalse((boolean)resourceMapping.getPrimaryKeyJoinColumns().isEmpty());
        GenericOrmOneToOneMapping2_0Tests.assertNull((Object)resourceMapping.getMappedBy());
        GenericOrmOneToOneMapping2_0Tests.assertNull((Object)resourceMapping.getJoinTable());
        GenericOrmOneToOneMapping2_0Tests.assertFalse((boolean)relationshipReference.usesJoinColumnJoiningStrategy());
        GenericOrmOneToOneMapping2_0Tests.assertTrue((boolean)relationshipReference.usesPrimaryKeyJoinColumnJoiningStrategy());
        GenericOrmOneToOneMapping2_0Tests.assertFalse((boolean)relationshipReference.usesMappedByJoiningStrategy());
        GenericOrmOneToOneMapping2_0Tests.assertFalse((boolean)relationshipReference.usesJoinTableJoiningStrategy());
        relationshipReference.setJoinTableJoiningStrategy();
        GenericOrmOneToOneMapping2_0Tests.assertTrue((boolean)resourceMapping.getJoinColumns().isEmpty());
        GenericOrmOneToOneMapping2_0Tests.assertTrue((boolean)resourceMapping.getPrimaryKeyJoinColumns().isEmpty());
        GenericOrmOneToOneMapping2_0Tests.assertNull((Object)resourceMapping.getMappedBy());
        GenericOrmOneToOneMapping2_0Tests.assertNotNull((Object)resourceMapping.getJoinTable());
        GenericOrmOneToOneMapping2_0Tests.assertFalse((boolean)relationshipReference.usesJoinColumnJoiningStrategy());
        GenericOrmOneToOneMapping2_0Tests.assertFalse((boolean)relationshipReference.usesPrimaryKeyJoinColumnJoiningStrategy());
        GenericOrmOneToOneMapping2_0Tests.assertFalse((boolean)relationshipReference.usesMappedByJoiningStrategy());
        GenericOrmOneToOneMapping2_0Tests.assertTrue((boolean)relationshipReference.usesJoinTableJoiningStrategy());
        relationshipReference.setJoinColumnJoiningStrategy();
        GenericOrmOneToOneMapping2_0Tests.assertTrue((boolean)resourceMapping.getJoinColumns().isEmpty());
        GenericOrmOneToOneMapping2_0Tests.assertTrue((boolean)resourceMapping.getPrimaryKeyJoinColumns().isEmpty());
        GenericOrmOneToOneMapping2_0Tests.assertNull((Object)resourceMapping.getMappedBy());
        GenericOrmOneToOneMapping2_0Tests.assertNull((Object)resourceMapping.getJoinTable());
        GenericOrmOneToOneMapping2_0Tests.assertTrue((boolean)relationshipReference.usesJoinColumnJoiningStrategy());
        GenericOrmOneToOneMapping2_0Tests.assertFalse((boolean)relationshipReference.usesPrimaryKeyJoinColumnJoiningStrategy());
        GenericOrmOneToOneMapping2_0Tests.assertFalse((boolean)relationshipReference.usesMappedByJoiningStrategy());
        GenericOrmOneToOneMapping2_0Tests.assertFalse((boolean)relationshipReference.usesJoinTableJoiningStrategy());
    }

    public void testUpdatePredominantJoiningStrategy() throws Exception {
        this.createTestEntityWithOneToOneMapping();
        OrmPersistentType contextType = this.getEntityMappings().getPersistentType("test.AnnotationTestType");
        OrmPersistentAttribute contextAttribute = contextType.getAttributeNamed("id");
        OrmOneToOneMapping2_0 contextMapping = (OrmOneToOneMapping2_0)contextAttribute.getMapping();
        OrmOneToOneRelationshipReference2_0 relationshipReference = contextMapping.getRelationshipReference();
        XmlEntity resourceEntity = (XmlEntity)contextType.getMapping().getResourceTypeMapping();
        XmlOneToOne resourceMapping = (XmlOneToOne)resourceEntity.getAttributes().getOneToOnes().get(0);
        GenericOrmOneToOneMapping2_0Tests.assertTrue((boolean)resourceMapping.getJoinColumns().isEmpty());
        GenericOrmOneToOneMapping2_0Tests.assertTrue((boolean)resourceMapping.getPrimaryKeyJoinColumns().isEmpty());
        GenericOrmOneToOneMapping2_0Tests.assertNull((Object)resourceMapping.getMappedBy());
        GenericOrmOneToOneMapping2_0Tests.assertNull((Object)resourceMapping.getJoinTable());
        GenericOrmOneToOneMapping2_0Tests.assertTrue((boolean)relationshipReference.usesJoinColumnJoiningStrategy());
        GenericOrmOneToOneMapping2_0Tests.assertFalse((boolean)relationshipReference.usesPrimaryKeyJoinColumnJoiningStrategy());
        GenericOrmOneToOneMapping2_0Tests.assertFalse((boolean)relationshipReference.usesMappedByJoiningStrategy());
        GenericOrmOneToOneMapping2_0Tests.assertFalse((boolean)relationshipReference.usesJoinTableJoiningStrategy());
        resourceMapping.getPrimaryKeyJoinColumns().add((Object)OrmFactory.eINSTANCE.createXmlPrimaryKeyJoinColumn());
        this.getJpaProject().synchronizeContextModel();
        GenericOrmOneToOneMapping2_0Tests.assertTrue((boolean)resourceMapping.getJoinColumns().isEmpty());
        GenericOrmOneToOneMapping2_0Tests.assertFalse((boolean)resourceMapping.getPrimaryKeyJoinColumns().isEmpty());
        GenericOrmOneToOneMapping2_0Tests.assertNull((Object)resourceMapping.getMappedBy());
        GenericOrmOneToOneMapping2_0Tests.assertNull((Object)resourceMapping.getJoinTable());
        GenericOrmOneToOneMapping2_0Tests.assertFalse((boolean)relationshipReference.usesJoinColumnJoiningStrategy());
        GenericOrmOneToOneMapping2_0Tests.assertTrue((boolean)relationshipReference.usesPrimaryKeyJoinColumnJoiningStrategy());
        GenericOrmOneToOneMapping2_0Tests.assertFalse((boolean)relationshipReference.usesMappedByJoiningStrategy());
        GenericOrmOneToOneMapping2_0Tests.assertFalse((boolean)relationshipReference.usesJoinTableJoiningStrategy());
        resourceMapping.getJoinColumns().add((Object)OrmFactory.eINSTANCE.createXmlJoinColumn());
        this.getJpaProject().synchronizeContextModel();
        GenericOrmOneToOneMapping2_0Tests.assertFalse((boolean)resourceMapping.getJoinColumns().isEmpty());
        GenericOrmOneToOneMapping2_0Tests.assertFalse((boolean)resourceMapping.getPrimaryKeyJoinColumns().isEmpty());
        GenericOrmOneToOneMapping2_0Tests.assertNull((Object)resourceMapping.getMappedBy());
        GenericOrmOneToOneMapping2_0Tests.assertNull((Object)resourceMapping.getJoinTable());
        GenericOrmOneToOneMapping2_0Tests.assertFalse((boolean)relationshipReference.usesJoinColumnJoiningStrategy());
        GenericOrmOneToOneMapping2_0Tests.assertTrue((boolean)relationshipReference.usesPrimaryKeyJoinColumnJoiningStrategy());
        GenericOrmOneToOneMapping2_0Tests.assertFalse((boolean)relationshipReference.usesMappedByJoiningStrategy());
        GenericOrmOneToOneMapping2_0Tests.assertFalse((boolean)relationshipReference.usesJoinTableJoiningStrategy());
        resourceMapping.setMappedBy("foo");
        this.getJpaProject().synchronizeContextModel();
        GenericOrmOneToOneMapping2_0Tests.assertFalse((boolean)resourceMapping.getJoinColumns().isEmpty());
        GenericOrmOneToOneMapping2_0Tests.assertFalse((boolean)resourceMapping.getPrimaryKeyJoinColumns().isEmpty());
        GenericOrmOneToOneMapping2_0Tests.assertNotNull((Object)resourceMapping.getMappedBy());
        GenericOrmOneToOneMapping2_0Tests.assertNull((Object)resourceMapping.getJoinTable());
        GenericOrmOneToOneMapping2_0Tests.assertFalse((boolean)relationshipReference.usesJoinColumnJoiningStrategy());
        GenericOrmOneToOneMapping2_0Tests.assertFalse((boolean)relationshipReference.usesPrimaryKeyJoinColumnJoiningStrategy());
        GenericOrmOneToOneMapping2_0Tests.assertTrue((boolean)relationshipReference.usesMappedByJoiningStrategy());
        GenericOrmOneToOneMapping2_0Tests.assertFalse((boolean)relationshipReference.usesJoinTableJoiningStrategy());
        resourceMapping.setJoinTable(OrmFactory.eINSTANCE.createXmlJoinTable());
        this.getJpaProject().synchronizeContextModel();
        GenericOrmOneToOneMapping2_0Tests.assertFalse((boolean)resourceMapping.getJoinColumns().isEmpty());
        GenericOrmOneToOneMapping2_0Tests.assertFalse((boolean)resourceMapping.getPrimaryKeyJoinColumns().isEmpty());
        GenericOrmOneToOneMapping2_0Tests.assertNotNull((Object)resourceMapping.getMappedBy());
        GenericOrmOneToOneMapping2_0Tests.assertNotNull((Object)resourceMapping.getJoinTable());
        GenericOrmOneToOneMapping2_0Tests.assertFalse((boolean)relationshipReference.usesJoinColumnJoiningStrategy());
        GenericOrmOneToOneMapping2_0Tests.assertFalse((boolean)relationshipReference.usesPrimaryKeyJoinColumnJoiningStrategy());
        GenericOrmOneToOneMapping2_0Tests.assertTrue((boolean)relationshipReference.usesMappedByJoiningStrategy());
        GenericOrmOneToOneMapping2_0Tests.assertFalse((boolean)relationshipReference.usesJoinTableJoiningStrategy());
        resourceMapping.getPrimaryKeyJoinColumns().clear();
        this.getJpaProject().synchronizeContextModel();
        GenericOrmOneToOneMapping2_0Tests.assertFalse((boolean)resourceMapping.getJoinColumns().isEmpty());
        GenericOrmOneToOneMapping2_0Tests.assertTrue((boolean)resourceMapping.getPrimaryKeyJoinColumns().isEmpty());
        GenericOrmOneToOneMapping2_0Tests.assertNotNull((Object)resourceMapping.getMappedBy());
        GenericOrmOneToOneMapping2_0Tests.assertNotNull((Object)resourceMapping.getJoinTable());
        GenericOrmOneToOneMapping2_0Tests.assertFalse((boolean)relationshipReference.usesJoinColumnJoiningStrategy());
        GenericOrmOneToOneMapping2_0Tests.assertFalse((boolean)relationshipReference.usesPrimaryKeyJoinColumnJoiningStrategy());
        GenericOrmOneToOneMapping2_0Tests.assertTrue((boolean)relationshipReference.usesMappedByJoiningStrategy());
        GenericOrmOneToOneMapping2_0Tests.assertFalse((boolean)relationshipReference.usesJoinTableJoiningStrategy());
        resourceMapping.getJoinColumns().clear();
        this.getJpaProject().synchronizeContextModel();
        GenericOrmOneToOneMapping2_0Tests.assertTrue((boolean)resourceMapping.getJoinColumns().isEmpty());
        GenericOrmOneToOneMapping2_0Tests.assertTrue((boolean)resourceMapping.getPrimaryKeyJoinColumns().isEmpty());
        GenericOrmOneToOneMapping2_0Tests.assertNotNull((Object)resourceMapping.getMappedBy());
        GenericOrmOneToOneMapping2_0Tests.assertNotNull((Object)resourceMapping.getJoinTable());
        GenericOrmOneToOneMapping2_0Tests.assertFalse((boolean)relationshipReference.usesJoinColumnJoiningStrategy());
        GenericOrmOneToOneMapping2_0Tests.assertFalse((boolean)relationshipReference.usesPrimaryKeyJoinColumnJoiningStrategy());
        GenericOrmOneToOneMapping2_0Tests.assertTrue((boolean)relationshipReference.usesMappedByJoiningStrategy());
        GenericOrmOneToOneMapping2_0Tests.assertFalse((boolean)relationshipReference.usesJoinTableJoiningStrategy());
        resourceMapping.setMappedBy(null);
        this.getJpaProject().synchronizeContextModel();
        GenericOrmOneToOneMapping2_0Tests.assertTrue((boolean)resourceMapping.getJoinColumns().isEmpty());
        GenericOrmOneToOneMapping2_0Tests.assertTrue((boolean)resourceMapping.getPrimaryKeyJoinColumns().isEmpty());
        GenericOrmOneToOneMapping2_0Tests.assertNull((Object)resourceMapping.getMappedBy());
        GenericOrmOneToOneMapping2_0Tests.assertNotNull((Object)resourceMapping.getJoinTable());
        GenericOrmOneToOneMapping2_0Tests.assertFalse((boolean)relationshipReference.usesJoinColumnJoiningStrategy());
        GenericOrmOneToOneMapping2_0Tests.assertFalse((boolean)relationshipReference.usesPrimaryKeyJoinColumnJoiningStrategy());
        GenericOrmOneToOneMapping2_0Tests.assertFalse((boolean)relationshipReference.usesMappedByJoiningStrategy());
        GenericOrmOneToOneMapping2_0Tests.assertTrue((boolean)relationshipReference.usesJoinTableJoiningStrategy());
        resourceMapping.setJoinTable(null);
        this.getJpaProject().synchronizeContextModel();
        GenericOrmOneToOneMapping2_0Tests.assertTrue((boolean)resourceMapping.getJoinColumns().isEmpty());
        GenericOrmOneToOneMapping2_0Tests.assertTrue((boolean)resourceMapping.getPrimaryKeyJoinColumns().isEmpty());
        GenericOrmOneToOneMapping2_0Tests.assertNull((Object)resourceMapping.getMappedBy());
        GenericOrmOneToOneMapping2_0Tests.assertNull((Object)resourceMapping.getJoinTable());
        GenericOrmOneToOneMapping2_0Tests.assertTrue((boolean)relationshipReference.usesJoinColumnJoiningStrategy());
        GenericOrmOneToOneMapping2_0Tests.assertFalse((boolean)relationshipReference.usesPrimaryKeyJoinColumnJoiningStrategy());
        GenericOrmOneToOneMapping2_0Tests.assertFalse((boolean)relationshipReference.usesMappedByJoiningStrategy());
        GenericOrmOneToOneMapping2_0Tests.assertFalse((boolean)relationshipReference.usesJoinTableJoiningStrategy());
    }

    public void testVirtualMappingMetadataCompleteFalse() throws Exception {
        this.createTestEntityOneToOneMapping();
        this.createTestTargetEntityAddress();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        this.getEntityMappings().addPersistentType("entity", "test.Address");
        GenericOrmOneToOneMapping2_0Tests.assertEquals((int)3, (int)ormPersistentType.virtualAttributesSize());
        OrmPersistentAttribute ormPersistentAttribute = (OrmPersistentAttribute)ormPersistentType.virtualAttributes().next();
        OrmOneToOneMapping2_0 ormOneToOneMapping = (OrmOneToOneMapping2_0)ormPersistentAttribute.getMapping();
        GenericOrmOneToOneMapping2_0Tests.assertEquals((String)"address", (String)ormOneToOneMapping.getName());
        GenericOrmOneToOneMapping2_0Tests.assertEquals((Object)FetchType.LAZY, (Object)ormOneToOneMapping.getSpecifiedFetch());
        GenericOrmOneToOneMapping2_0Tests.assertEquals((Object)Boolean.FALSE, (Object)ormOneToOneMapping.getSpecifiedOptional());
        GenericOrmOneToOneMapping2_0Tests.assertEquals((String)"Address", (String)ormOneToOneMapping.getSpecifiedTargetEntity());
        GenericOrmOneToOneMapping2_0Tests.assertNull((Object)ormOneToOneMapping.getRelationshipReference().getMappedByJoiningStrategy().getMappedByAttribute());
        OrmJoinColumn ormJoinColumn = (OrmJoinColumn)ormOneToOneMapping.getRelationshipReference().getJoinColumnJoiningStrategy().specifiedJoinColumns().next();
        GenericOrmOneToOneMapping2_0Tests.assertEquals((String)"MY_COLUMN", (String)ormJoinColumn.getSpecifiedName());
        GenericOrmOneToOneMapping2_0Tests.assertEquals((String)"MY_REFERENCED_COLUMN", (String)ormJoinColumn.getSpecifiedReferencedColumnName());
        GenericOrmOneToOneMapping2_0Tests.assertEquals((Object)Boolean.TRUE, (Object)ormJoinColumn.getSpecifiedUnique());
        GenericOrmOneToOneMapping2_0Tests.assertEquals((Object)Boolean.FALSE, (Object)ormJoinColumn.getSpecifiedNullable());
        GenericOrmOneToOneMapping2_0Tests.assertEquals((Object)Boolean.FALSE, (Object)ormJoinColumn.getSpecifiedInsertable());
        GenericOrmOneToOneMapping2_0Tests.assertEquals((Object)Boolean.FALSE, (Object)ormJoinColumn.getSpecifiedUpdatable());
        GenericOrmOneToOneMapping2_0Tests.assertEquals((String)"COLUMN_DEFINITION", (String)ormJoinColumn.getColumnDefinition());
        GenericOrmOneToOneMapping2_0Tests.assertEquals((String)"MY_TABLE", (String)ormJoinColumn.getSpecifiedTable());
        OrmCascade2_0 cascade = ormOneToOneMapping.getCascade();
        GenericOrmOneToOneMapping2_0Tests.assertTrue((boolean)cascade.isAll());
        GenericOrmOneToOneMapping2_0Tests.assertTrue((boolean)cascade.isMerge());
        GenericOrmOneToOneMapping2_0Tests.assertTrue((boolean)cascade.isPersist());
        GenericOrmOneToOneMapping2_0Tests.assertTrue((boolean)cascade.isRemove());
        GenericOrmOneToOneMapping2_0Tests.assertTrue((boolean)cascade.isRefresh());
        GenericOrmOneToOneMapping2_0Tests.assertTrue((boolean)cascade.isDetach());
        GenericOrmOneToOneMapping2_0Tests.assertTrue((boolean)((OrmOrphanRemovalHolder2_0)ormOneToOneMapping).getOrphanRemoval().isOrphanRemoval());
    }

    public void testVirtualMappingMetadataCompleteTrue() throws Exception {
        this.createTestEntityOneToOneMapping();
        this.createTestTargetEntityAddress();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        this.getEntityMappings().addPersistentType("entity", "test.Address");
        ormPersistentType.getMapping().setSpecifiedMetadataComplete(Boolean.TRUE);
        GenericOrmOneToOneMapping2_0Tests.assertEquals((int)3, (int)ormPersistentType.virtualAttributesSize());
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.getAttributeNamed("address");
        GenericOrmOneToOneMapping2_0Tests.assertEquals((String)MappingKeys.NULL_ATTRIBUTE_MAPPING_KEY, (String)ormPersistentAttribute.getMappingKey());
        GenericOrmOneToOneMapping2_0Tests.assertTrue((boolean)ormPersistentAttribute.isVirtual());
        ormPersistentAttribute.makeSpecified("oneToOne");
        ormPersistentAttribute = (OrmPersistentAttribute)ormPersistentType.specifiedAttributes().next();
        OrmOneToOneMapping2_0 ormOneToOneMapping = (OrmOneToOneMapping2_0)ormPersistentAttribute.getMapping();
        GenericOrmOneToOneMapping2_0Tests.assertEquals((String)"address", (String)ormOneToOneMapping.getName());
        GenericOrmOneToOneMapping2_0Tests.assertEquals((Object)FetchType.EAGER, (Object)ormOneToOneMapping.getFetch());
        GenericOrmOneToOneMapping2_0Tests.assertEquals((boolean)true, (boolean)ormOneToOneMapping.isOptional());
        GenericOrmOneToOneMapping2_0Tests.assertEquals((String)"test.Address", (String)ormOneToOneMapping.getTargetEntity());
        GenericOrmOneToOneMapping2_0Tests.assertNull((Object)ormOneToOneMapping.getRelationshipReference().getMappedByJoiningStrategy().getMappedByAttribute());
        OrmCascade2_0 cascade = ormOneToOneMapping.getCascade();
        GenericOrmOneToOneMapping2_0Tests.assertFalse((boolean)cascade.isAll());
        GenericOrmOneToOneMapping2_0Tests.assertFalse((boolean)cascade.isMerge());
        GenericOrmOneToOneMapping2_0Tests.assertFalse((boolean)cascade.isPersist());
        GenericOrmOneToOneMapping2_0Tests.assertFalse((boolean)cascade.isRemove());
        GenericOrmOneToOneMapping2_0Tests.assertFalse((boolean)cascade.isRefresh());
        GenericOrmOneToOneMapping2_0Tests.assertFalse((boolean)cascade.isDetach());
        GenericOrmOneToOneMapping2_0Tests.assertFalse((boolean)((OrmOrphanRemovalHolder2_0)ormOneToOneMapping).getOrphanRemoval().isOrphanRemoval());
    }
}

