/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.tests.internal.model;

import junit.framework.TestCase;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jpt.core.JptCorePlugin;
import org.eclipse.jpt.core.internal.facet.JpaFacetInstallDataModelProvider;
import org.eclipse.jpt.core.tests.internal.projects.TestFacetedProject;
import org.eclipse.jpt.core.tests.internal.projects.TestJavaProject;
import org.eclipse.jpt.core.tests.internal.projects.TestPlatformProject;
import org.eclipse.jpt.utility.internal.ReflectionTools;
import org.eclipse.wst.common.frameworks.datamodel.DataModelFactory;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JpaProjectManagerTests
extends TestCase {
    public static final String CR = System.getProperty("line.separator");
    protected TestFacetedProject testProject;

    public JpaProjectManagerTests(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        if (this.debug()) {
            this.printName();
        }
        this.testProject = this.buildTestProject();
    }

    private boolean debug() {
        Boolean debug = (Boolean)ReflectionTools.getStaticFieldValue(this.getGenericJpaProjectManagerClass(), (String)"DEBUG");
        return debug;
    }

    private Class<?> getGenericJpaProjectManagerClass() {
        return JptCorePlugin.getJpaProjectManager().getClass();
    }

    private void printName() {
        String name = this.getName();
        System.out.println();
        System.out.println();
        this.printNameBorder(name);
        System.out.println(name);
        this.printNameBorder(name);
    }

    private void printNameBorder(String name) {
        int i = name.length();
        while (i-- > 0) {
            System.out.print('=');
        }
        System.out.println();
    }

    protected void tearDown() throws Exception {
        this.testProject.getProject().delete(true, true, null);
        this.testProject = null;
        super.tearDown();
    }

    private TestFacetedProject buildTestProject() throws Exception {
        TestJavaProject tjp = TestJavaProject.buildJavaProject(((Object)((Object)this)).getClass().getSimpleName(), true);
        tjp.installFacet("jst.utility", "1.0");
        tjp.createCompilationUnit("test.pkg", "TestEntity.java", "@Entity public class TestEntity {}");
        tjp.createCompilationUnit("test.pkg", "TestEntity2.java", "@Entity public class TestEntity2 {}");
        return tjp;
    }

    private IFile getFile(TestPlatformProject p, String path) {
        return p.getProject().getFile((IPath)new Path(path));
    }

    public void testDEBUG() {
        this.verifyDEBUG(this.getGenericJpaProjectManagerClass());
    }

    private void verifyDEBUG(Class<?> clazz) {
        JpaProjectManagerTests.assertFalse((String)("Recompile with \"DEBUG = false\": " + clazz.getName()), (boolean)((Boolean)ReflectionTools.getStaticFieldValue(clazz, (String)"DEBUG")));
    }

    public void testJpaProjectManager() {
        JpaProjectManagerTests.assertNotNull((Object)JptCorePlugin.getJpaProjectManager());
    }

    protected IDataModel buildJpaConfigDataModel() {
        IDataModel dataModel = DataModelFactory.createDataModel((IDataModelProvider)new JpaFacetInstallDataModelProvider());
        dataModel.setProperty("JpaFacetInstallDataModelProperties.CREATE_ORM_XML", (Object)Boolean.TRUE);
        return dataModel;
    }
}

