/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.tests.internal.resource.java;

import java.util.Iterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.core.resource.java.InheritanceAnnotation;
import org.eclipse.jpt.core.resource.java.InheritanceType;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentType;
import org.eclipse.jpt.core.tests.internal.resource.java.JavaResourceModelTestCase;
import org.eclipse.jpt.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.utility.internal.iterators.ArrayIterator;

public class InheritanceTests
extends JavaResourceModelTestCase {
    public InheritanceTests(String name) {
        super(name);
    }

    private ICompilationUnit createTestInheritance() throws Exception {
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Inheritance"});
            }

            @Override
            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Inheritance");
            }
        });
    }

    private ICompilationUnit createTestInheritanceWithStrategy() throws Exception {
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Inheritance", "javax.persistence.InheritanceType"});
            }

            @Override
            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Inheritance(strategy = InheritanceType.JOINED)");
            }
        });
    }

    public void testInheritance() throws Exception {
        ICompilationUnit cu = this.createTestInheritance();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        InheritanceAnnotation inheritance = (InheritanceAnnotation)typeResource.getAnnotation("javax.persistence.Inheritance");
        InheritanceTests.assertNotNull((Object)inheritance);
    }

    public void testGetStrategy() throws Exception {
        ICompilationUnit cu = this.createTestInheritanceWithStrategy();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        InheritanceAnnotation inheritance = (InheritanceAnnotation)typeResource.getAnnotation("javax.persistence.Inheritance");
        InheritanceTests.assertEquals((Object)InheritanceType.JOINED, (Object)inheritance.getStrategy());
    }

    public void testSetStrategy() throws Exception {
        ICompilationUnit cu = this.createTestInheritance();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        InheritanceAnnotation inheritance = (InheritanceAnnotation)typeResource.getAnnotation("javax.persistence.Inheritance");
        inheritance.setStrategy(InheritanceType.TABLE_PER_CLASS);
        this.assertSourceContains("@Inheritance(strategy = TABLE_PER_CLASS)", cu);
        inheritance.setStrategy(null);
        this.assertSourceDoesNotContain("@Inheritance", cu);
    }
}

