/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.tests.internal.resource.java;

import java.util.Iterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentAttribute;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentType;
import org.eclipse.jpt.core.resource.java.PrimaryKeyJoinColumnAnnotation;
import org.eclipse.jpt.core.tests.internal.resource.java.JavaResourceModelTestCase;
import org.eclipse.jpt.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.jpt.utility.internal.iterators.ArrayIterator;

public class PrimaryKeyJoinColumnsTests
extends JavaResourceModelTestCase {
    private static final String COLUMN_NAME = "MY_COLUMN";
    private static final String COLUMN_COLUMN_DEFINITION = "COLUMN_DEFINITION";
    private static final String COLUMN_REFERENCED_COLUMN_NAME = "MY_REF_COLUMN_NAME";

    public PrimaryKeyJoinColumnsTests(String name) {
        super(name);
    }

    private ICompilationUnit createTestPrimaryKeyJoinColumns() throws Exception {
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.PrimaryKeyJoinColumn", "javax.persistence.PrimaryKeyJoinColumns"});
            }

            @Override
            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@PrimaryKeyJoinColumns(@PrimaryKeyJoinColumn)");
            }
        });
    }

    private ICompilationUnit createTestPrimaryKeyJoinColumnWithName() throws Exception {
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.PrimaryKeyJoinColumn", "javax.persistence.PrimaryKeyJoinColumns"});
            }

            @Override
            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@PrimaryKeyJoinColumns(@PrimaryKeyJoinColumn(name = \"MY_COLUMN\"))");
            }
        });
    }

    private ICompilationUnit createTestPrimaryKeyJoinColumnWithReferencedColumnName() throws Exception {
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.PrimaryKeyJoinColumn", "javax.persistence.PrimaryKeyJoinColumns"});
            }

            @Override
            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@PrimaryKeyJoinColumns(@PrimaryKeyJoinColumn(referencedColumnName = \"MY_REF_COLUMN_NAME\"))");
            }
        });
    }

    private ICompilationUnit createTestPrimaryKeyJoinColumnWithColumnDefinition() throws Exception {
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.PrimaryKeyJoinColumn", "javax.persistence.PrimaryKeyJoinColumns"});
            }

            @Override
            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@PrimaryKeyJoinColumns(@PrimaryKeyJoinColumn(columnDefinition = \"COLUMN_DEFINITION\"))");
            }
        });
    }

    private ICompilationUnit createTestPrimaryKeyJoinColumn() throws Exception {
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.PrimaryKeyJoinColumn", "javax.persistence.PrimaryKeyJoinColumns"});
            }

            @Override
            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@PrimaryKeyJoinColumn(name = \"BAR\", columnDefinition = \"COLUMN_DEF\", referencedColumnName = \"REF_NAME\")");
            }
        });
    }

    public void testGetName() throws Exception {
        ICompilationUnit cu = this.createTestPrimaryKeyJoinColumnWithName();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        PrimaryKeyJoinColumnAnnotation column = (PrimaryKeyJoinColumnAnnotation)attributeResource.annotations("javax.persistence.PrimaryKeyJoinColumn", "javax.persistence.PrimaryKeyJoinColumns").next();
        PrimaryKeyJoinColumnsTests.assertNotNull((Object)column);
        PrimaryKeyJoinColumnsTests.assertEquals((String)COLUMN_NAME, (String)column.getName());
    }

    public void testGetNull() throws Exception {
        ICompilationUnit cu = this.createTestPrimaryKeyJoinColumns();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        PrimaryKeyJoinColumnAnnotation column = (PrimaryKeyJoinColumnAnnotation)attributeResource.annotations("javax.persistence.PrimaryKeyJoinColumn", "javax.persistence.PrimaryKeyJoinColumns").next();
        PrimaryKeyJoinColumnsTests.assertNotNull((Object)column);
        PrimaryKeyJoinColumnsTests.assertNull((Object)column.getName());
        PrimaryKeyJoinColumnsTests.assertNull((Object)column.getReferencedColumnName());
        PrimaryKeyJoinColumnsTests.assertNull((Object)column.getColumnDefinition());
    }

    public void testSetName() throws Exception {
        ICompilationUnit cu = this.createTestPrimaryKeyJoinColumns();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        PrimaryKeyJoinColumnAnnotation column = (PrimaryKeyJoinColumnAnnotation)attributeResource.annotations("javax.persistence.PrimaryKeyJoinColumn", "javax.persistence.PrimaryKeyJoinColumns").next();
        PrimaryKeyJoinColumnsTests.assertNotNull((Object)column);
        PrimaryKeyJoinColumnsTests.assertNull((Object)column.getName());
        column.setName("Foo");
        PrimaryKeyJoinColumnsTests.assertEquals((String)"Foo", (String)column.getName());
        this.assertSourceContains("@PrimaryKeyJoinColumns(@PrimaryKeyJoinColumn(name = \"Foo\"))", cu);
    }

    public void testSetNameNull() throws Exception {
        ICompilationUnit cu = this.createTestPrimaryKeyJoinColumnWithName();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        PrimaryKeyJoinColumnAnnotation column = (PrimaryKeyJoinColumnAnnotation)attributeResource.annotations("javax.persistence.PrimaryKeyJoinColumn", "javax.persistence.PrimaryKeyJoinColumns").next();
        PrimaryKeyJoinColumnsTests.assertEquals((String)COLUMN_NAME, (String)column.getName());
        column.setName(null);
        PrimaryKeyJoinColumnsTests.assertNull((Object)column.getName());
        this.assertSourceDoesNotContain("@PrimaryKeyJoinColumn", cu);
    }

    public void testGetReferencedColumnName() throws Exception {
        ICompilationUnit cu = this.createTestPrimaryKeyJoinColumnWithReferencedColumnName();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        PrimaryKeyJoinColumnAnnotation column = (PrimaryKeyJoinColumnAnnotation)attributeResource.annotations("javax.persistence.PrimaryKeyJoinColumn", "javax.persistence.PrimaryKeyJoinColumns").next();
        PrimaryKeyJoinColumnsTests.assertEquals((String)COLUMN_REFERENCED_COLUMN_NAME, (String)column.getReferencedColumnName());
    }

    public void testSetReferencedColumnName() throws Exception {
        ICompilationUnit cu = this.createTestPrimaryKeyJoinColumns();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        PrimaryKeyJoinColumnAnnotation column = (PrimaryKeyJoinColumnAnnotation)attributeResource.annotations("javax.persistence.PrimaryKeyJoinColumn", "javax.persistence.PrimaryKeyJoinColumns").next();
        PrimaryKeyJoinColumnsTests.assertNotNull((Object)column);
        PrimaryKeyJoinColumnsTests.assertNull((Object)column.getReferencedColumnName());
        column.setReferencedColumnName("Foo");
        PrimaryKeyJoinColumnsTests.assertEquals((String)"Foo", (String)column.getReferencedColumnName());
        this.assertSourceContains("@PrimaryKeyJoinColumns(@PrimaryKeyJoinColumn(referencedColumnName = \"Foo\"))", cu);
        column.setReferencedColumnName(null);
        this.assertSourceDoesNotContain("@PrimaryKeyJoinColumn", cu);
    }

    public void testGetColumnDefinition() throws Exception {
        ICompilationUnit cu = this.createTestPrimaryKeyJoinColumnWithColumnDefinition();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        PrimaryKeyJoinColumnAnnotation column = (PrimaryKeyJoinColumnAnnotation)attributeResource.annotations("javax.persistence.PrimaryKeyJoinColumn", "javax.persistence.PrimaryKeyJoinColumns").next();
        PrimaryKeyJoinColumnsTests.assertEquals((String)COLUMN_COLUMN_DEFINITION, (String)column.getColumnDefinition());
    }

    public void testSetColumnDefinition() throws Exception {
        ICompilationUnit cu = this.createTestPrimaryKeyJoinColumns();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        PrimaryKeyJoinColumnAnnotation column = (PrimaryKeyJoinColumnAnnotation)attributeResource.annotations("javax.persistence.PrimaryKeyJoinColumn", "javax.persistence.PrimaryKeyJoinColumns").next();
        PrimaryKeyJoinColumnsTests.assertNotNull((Object)column);
        PrimaryKeyJoinColumnsTests.assertNull((Object)column.getColumnDefinition());
        column.setColumnDefinition("Foo");
        PrimaryKeyJoinColumnsTests.assertEquals((String)"Foo", (String)column.getColumnDefinition());
        this.assertSourceContains("@PrimaryKeyJoinColumns(@PrimaryKeyJoinColumn(columnDefinition = \"Foo\"))", cu);
        column.setColumnDefinition(null);
        this.assertSourceDoesNotContain("@PrimaryKeyJoinColumn", cu);
    }

    public void testAddPrimaryKeyJoinColumnCopyExisting() throws Exception {
        ICompilationUnit cu = this.createTestPrimaryKeyJoinColumn();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        PrimaryKeyJoinColumnAnnotation joinColumn = (PrimaryKeyJoinColumnAnnotation)attributeResource.addAnnotation(1, "javax.persistence.PrimaryKeyJoinColumn", "javax.persistence.PrimaryKeyJoinColumns");
        joinColumn.setName("FOO");
        this.assertSourceContains("@PrimaryKeyJoinColumns({@PrimaryKeyJoinColumn(name = \"BAR\", columnDefinition = \"COLUMN_DEF\", referencedColumnName = \"REF_NAME\"),@PrimaryKeyJoinColumn(name = \"FOO\")})", cu);
        PrimaryKeyJoinColumnsTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.PrimaryKeyJoinColumn"));
        PrimaryKeyJoinColumnsTests.assertNotNull((Object)attributeResource.getAnnotation("javax.persistence.PrimaryKeyJoinColumns"));
        PrimaryKeyJoinColumnsTests.assertEquals((int)2, (int)CollectionTools.size((Iterator)attributeResource.annotations("javax.persistence.PrimaryKeyJoinColumn", "javax.persistence.PrimaryKeyJoinColumns")));
    }

    public void testAddPrimaryKeyJoinColumnToBeginningOfList() throws Exception {
        ICompilationUnit cu = this.createTestPrimaryKeyJoinColumn();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        PrimaryKeyJoinColumnAnnotation joinColumn = (PrimaryKeyJoinColumnAnnotation)attributeResource.addAnnotation(1, "javax.persistence.PrimaryKeyJoinColumn", "javax.persistence.PrimaryKeyJoinColumns");
        joinColumn.setName("FOO");
        this.assertSourceContains("@PrimaryKeyJoinColumns({@PrimaryKeyJoinColumn(name = \"BAR\", columnDefinition = \"COLUMN_DEF\", referencedColumnName = \"REF_NAME\"),@PrimaryKeyJoinColumn(name = \"FOO\")})", cu);
        joinColumn = (PrimaryKeyJoinColumnAnnotation)attributeResource.addAnnotation(0, "javax.persistence.PrimaryKeyJoinColumn", "javax.persistence.PrimaryKeyJoinColumns");
        joinColumn.setName("BAZ");
        this.assertSourceContains("@PrimaryKeyJoinColumns({@PrimaryKeyJoinColumn(name = \"BAZ\"),@PrimaryKeyJoinColumn(name = \"BAR\", columnDefinition = \"COLUMN_DEF\", referencedColumnName = \"REF_NAME\"), @PrimaryKeyJoinColumn(name = \"FOO\")})", cu);
        Iterator pkJoinColumns = attributeResource.annotations("javax.persistence.PrimaryKeyJoinColumn", "javax.persistence.PrimaryKeyJoinColumns");
        PrimaryKeyJoinColumnsTests.assertEquals((String)"BAZ", (String)((PrimaryKeyJoinColumnAnnotation)pkJoinColumns.next()).getName());
        PrimaryKeyJoinColumnsTests.assertEquals((String)"BAR", (String)((PrimaryKeyJoinColumnAnnotation)pkJoinColumns.next()).getName());
        PrimaryKeyJoinColumnsTests.assertEquals((String)"FOO", (String)((PrimaryKeyJoinColumnAnnotation)pkJoinColumns.next()).getName());
        PrimaryKeyJoinColumnsTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.PrimaryKeyJoinColumn"));
        PrimaryKeyJoinColumnsTests.assertNotNull((Object)attributeResource.getAnnotation("javax.persistence.PrimaryKeyJoinColumns"));
        PrimaryKeyJoinColumnsTests.assertEquals((int)3, (int)CollectionTools.size((Iterator)attributeResource.annotations("javax.persistence.PrimaryKeyJoinColumn", "javax.persistence.PrimaryKeyJoinColumns")));
    }

    public void testRemovePrimaryKeyJoinColumnCopyExisting() throws Exception {
        ICompilationUnit cu = this.createTestPrimaryKeyJoinColumn();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        PrimaryKeyJoinColumnAnnotation joinColumn = (PrimaryKeyJoinColumnAnnotation)attributeResource.addAnnotation(1, "javax.persistence.PrimaryKeyJoinColumn", "javax.persistence.PrimaryKeyJoinColumns");
        joinColumn.setName("FOO");
        this.assertSourceContains("@PrimaryKeyJoinColumns({@PrimaryKeyJoinColumn(name = \"BAR\", columnDefinition = \"COLUMN_DEF\", referencedColumnName = \"REF_NAME\"),@PrimaryKeyJoinColumn(name = \"FOO\")})", cu);
        attributeResource.removeAnnotation(1, "javax.persistence.PrimaryKeyJoinColumn", "javax.persistence.PrimaryKeyJoinColumns");
        this.assertSourceContains("@PrimaryKeyJoinColumn(name = \"BAR\", columnDefinition = \"COLUMN_DEF\", referencedColumnName = \"REF_NAME\")", cu);
    }
}

