/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.context;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jst.jsf.context.IDelegatingFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractDelegatingFactory
implements IDelegatingFactory {
    protected final CopyOnWriteArrayList<IAdaptable> _delegates = new CopyOnWriteArrayList();
    private final List<Class> _supportedDelegates;

    protected AbstractDelegatingFactory(Class[] supportedDelegateTypes) {
        ArrayList<Class> supportedTypes = new ArrayList<Class>();
        supportedTypes.addAll(Arrays.asList(supportedDelegateTypes));
        this._supportedDelegates = Collections.unmodifiableList(supportedTypes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void addFactoryDelegate(IAdaptable delegate) {
        if (this.isValidDelegate(delegate)) {
            CopyOnWriteArrayList<IAdaptable> copyOnWriteArrayList = this._delegates;
            synchronized (copyOnWriteArrayList) {
                this._delegates.addIfAbsent(delegate);
                if (this._delegates.size() > 1) {
                    ArrayList<IAdaptable> delegates = new ArrayList<IAdaptable>(this._delegates);
                    Collections.sort(delegates, new Comparator(){

                        public int compare(Object delegate1, Object delegate2) {
                            Class<?> clazz1 = delegate1.getClass();
                            Class<?> clazz2 = delegate2.getClass();
                            Package package1 = clazz1.getPackage();
                            Package package2 = clazz2.getPackage();
                            boolean package1IsOSS = package1.getName().startsWith("org.eclipse.jst");
                            boolean package2IsOSS = package2.getName().startsWith("org.eclipse.jst");
                            if (package1IsOSS && !package2IsOSS) {
                                return 1;
                            }
                            if (!package1IsOSS && package2IsOSS) {
                                return -1;
                            }
                            return clazz1.getName().compareTo(clazz2.getName());
                        }
                    });
                    this._delegates.clear();
                    this._delegates.addAll(delegates);
                }
            }
        }
    }

    @Override
    public final boolean removeFactoryDelegate(IAdaptable delegate) {
        return this._delegates.remove(delegate);
    }

    @Override
    public final List<Class> getValidDelegateTypes() {
        return this._supportedDelegates;
    }

    @Override
    public final boolean isValidDelegate(IAdaptable delegate) {
        for (Class clazz : this._supportedDelegates) {
            if (delegate.getAdapter(clazz) == null) continue;
            return true;
        }
        return false;
    }
}

