/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.componentcore.ui.propertypage;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.internal.ComponentResource;
import org.eclipse.wst.common.componentcore.internal.DefaultModuleHandler;
import org.eclipse.wst.common.componentcore.internal.IModuleHandler;
import org.eclipse.wst.common.componentcore.internal.StructureEdit;
import org.eclipse.wst.common.componentcore.internal.WorkbenchComponent;
import org.eclipse.wst.common.componentcore.internal.impl.TaskModel;
import org.eclipse.wst.common.componentcore.internal.operation.AddReferenceDataModelProvider;
import org.eclipse.wst.common.componentcore.internal.operation.RemoveReferenceDataModelProvider;
import org.eclipse.wst.common.componentcore.internal.resources.VirtualReference;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualFolder;
import org.eclipse.wst.common.componentcore.resources.IVirtualReference;
import org.eclipse.wst.common.componentcore.ui.Messages;
import org.eclipse.wst.common.componentcore.ui.ModuleCoreUIPlugin;
import org.eclipse.wst.common.componentcore.ui.internal.propertypage.ComponentDependencyContentProvider;
import org.eclipse.wst.common.componentcore.ui.internal.propertypage.DependencyPageExtensionManager;
import org.eclipse.wst.common.componentcore.ui.internal.propertypage.NewReferenceWizard;
import org.eclipse.wst.common.componentcore.ui.internal.propertypage.ResourceMappingFilterExtensionRegistry;
import org.eclipse.wst.common.componentcore.ui.internal.propertypage.verifier.DeploymentAssemblyVerifierHelper;
import org.eclipse.wst.common.componentcore.ui.internal.taskwizard.TaskWizard;
import org.eclipse.wst.common.componentcore.ui.internal.taskwizard.WizardFragment;
import org.eclipse.wst.common.componentcore.ui.propertypage.IModuleDependenciesControl;
import org.eclipse.wst.common.componentcore.ui.propertypage.ModuleAssemblyRootPage;
import org.eclipse.wst.common.frameworks.datamodel.DataModelFactory;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelOperation;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelProvider;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.internal.facets.FacetUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AddModuleDependenciesPropertiesPage
implements Listener,
IModuleDependenciesControl,
ILabelProviderListener {
    public static final int SOURCE_COLUMN = 0;
    public static final int DEPLOY_COLUMN = 1;
    protected static final String SOURCE_PROPERTY = new Integer(0).toString();
    protected static final String DEPLOY_PATH_PROPERTY = new Integer(1).toString();
    protected final String PATH_SEPARATOR = String.valueOf('/');
    private boolean hasInitialized = false;
    protected final IProject project;
    protected final IRuntime runtime;
    protected final ModuleAssemblyRootPage propPage;
    protected IVirtualComponent rootComponent = null;
    protected Text componentNameText;
    protected TreeViewer availableComponentsViewer;
    protected Button addMappingButton;
    protected Button addReferenceButton;
    protected Button editReferenceButton;
    protected Button removeButton;
    protected Composite buttonColumn;
    protected static final IStatus OK_STATUS = IDataModelProvider.OK_STATUS;
    protected Listener labelListener;
    protected ArrayList<IVirtualReference> originalReferences = new ArrayList();
    protected ArrayList<IVirtualReference> currentReferences = new ArrayList();
    protected ArrayList<ComponentResourceProxy> resourceMappings = new ArrayList();
    protected ArrayList<ComponentResourceProxy> hiddenMappings = new ArrayList();
    protected boolean resourceMappingsChanged = false;
    protected IModuleHandler moduleHandler;

    public static String getSafeRuntimePath(IVirtualReference ref) {
        Path runtimePath;
        String archiveName = ref.getDependencyType() == 1 ? null : ref.getArchiveName();
        String val = null;
        val = archiveName != null ? ((runtimePath = new Path(archiveName)).segmentCount() > 1 ? archiveName : ref.getRuntimePath().append(archiveName).toString()) : ref.getRuntimePath().toString();
        if (val == null) {
            val = "/";
        }
        return val;
    }

    public static void setRuntimePathSafe(IVirtualReference ref, String newPath) {
        if (ref.getDependencyType() == 1) {
            ref.setRuntimePath((IPath)new Path(newPath == null ? "/" : newPath));
        } else {
            Path path2 = new Path(newPath == null ? "/" : newPath);
            ref.setRuntimePath((IPath)(path2.segmentCount() > 1 ? path2.removeLastSegments(1) : new Path("/")));
            ref.setArchiveName(path2.segmentCount() > 0 ? path2.lastSegment() : "");
        }
    }

    public AddModuleDependenciesPropertiesPage(IProject project, ModuleAssemblyRootPage page) {
        this.project = project;
        this.propPage = page;
        this.runtime = this.setRuntime();
        this.rootComponent = ComponentCore.createComponent((IProject)project);
    }

    private IRuntime setRuntime() {
        IRuntime aRuntime = null;
        try {
            aRuntime = this.getServerRuntime(this.project);
        }
        catch (CoreException e) {
            ModuleCoreUIPlugin.log((Exception)((Object)e));
        }
        return aRuntime;
    }

    @Override
    public Composite createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "org.eclipse.wst.common.modulecore.ui.DEPLOYMENT_ASSEMBLY_PREFERENCE_PAGE_DEPLOYMENT_ASSEMBLY_TAB");
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        this.createDescriptionComposite(composite);
        this.createListGroup(composite);
        this.refresh();
        Dialog.applyDialogFont((Control)parent);
        return composite;
    }

    protected void createDescriptionComposite(Composite parent) {
        ModuleAssemblyRootPage.createDescriptionComposite(parent, this.getModuleAssemblyRootPageDescription());
    }

    protected String getModuleAssemblyRootPageDescription() {
        return Messages.ModuleAssemblyRootPageDescription;
    }

    protected void createListGroup(Composite parent) {
        Composite listGroup = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        listGroup.setLayout((Layout)layout);
        listGroup.setLayoutData((Object)new GridData(1808));
        this.createTableComposite(listGroup);
    }

    protected void createTableComposite(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridData gData = new GridData(1808);
        composite.setLayoutData((Object)gData);
        this.fillTableComposite(composite);
    }

    public void fillTableComposite(Composite parent) {
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        parent.setLayout((Layout)layout);
        parent.setLayoutData((Object)new GridData(1808));
        this.createTable(parent);
        this.createButtonColumn(parent);
    }

    protected void createButtonColumn(Composite parent) {
        this.buttonColumn = this.createButtonColumnComposite(parent);
        GridData data = new GridData(128);
        this.buttonColumn.setLayoutData((Object)data);
        this.createPushButtons();
    }

    protected void createPushButtons() {
        this.addReferenceButton = this.createPushButton(Messages.AddEllipsis);
        this.editReferenceButton = this.createPushButton(Messages.EditEllipsis);
        this.removeButton = this.createPushButton(Messages.RemoveSelected);
    }

    protected Button createPushButton(String label) {
        Button aButton = new Button(this.buttonColumn, 8);
        aButton.setText(label);
        aButton.addListener(13, (Listener)this);
        GridDataFactory.defaultsFor((Control)aButton).applyTo((Control)aButton);
        return aButton;
    }

    public Composite createButtonColumnComposite(Composite parent) {
        Composite aButtonColumn = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        aButtonColumn.setLayout((Layout)layout);
        GridData data = new GridData(258);
        aButtonColumn.setLayoutData((Object)data);
        return aButtonColumn;
    }

    public Group createGroup(Composite parent) {
        return new Group(parent, 0);
    }

    protected void createTable(Composite parent) {
        if (this.rootComponent != null) {
            this.availableComponentsViewer = this.createAvailableComponentsViewer(parent);
            GridData gd = new GridData(1808);
            this.availableComponentsViewer.getTree().setLayoutData((Object)gd);
            ComponentDependencyContentProvider provider = this.createProvider();
            provider.setComponent(this.rootComponent);
            provider.setRuntimePaths(this.currentReferences);
            provider.setResourceMappings(this.resourceMappings);
            this.availableComponentsViewer.setContentProvider((IContentProvider)provider);
            this.availableComponentsViewer.setLabelProvider((IBaseLabelProvider)provider);
            this.addTableListeners();
        }
    }

    protected ComponentDependencyContentProvider createProvider() {
        return new ComponentDependencyContentProvider(this);
    }

    protected void addTableListeners() {
        this.addHoverHelpListeners();
        this.addDoubleClickListener();
        this.addSelectionListener();
    }

    protected void addHoverHelpListeners() {
        Tree tree = this.availableComponentsViewer.getTree();
        this.createLabelListener(tree);
    }

    protected void createLabelListener(final Tree tree) {
        this.labelListener = new Listener(){

            public void handleEvent(Event event) {
                Label label = (Label)event.widget;
                Shell shell = label.getShell();
                switch (event.type) {
                    case 3: {
                        Event e = new Event();
                        e.item = (TreeItem)label.getData("_TreeItem");
                        tree.setSelection(new TreeItem[]{(TreeItem)e.item});
                        tree.notifyListeners(13, e);
                        shell.dispose();
                        tree.setFocus();
                        break;
                    }
                    case 7: {
                        shell.dispose();
                    }
                }
            }
        };
    }

    protected void addDoubleClickListener() {
        this.availableComponentsViewer.setColumnProperties(new String[]{SOURCE_PROPERTY, DEPLOY_PATH_PROPERTY});
        CellEditor[] editors = new CellEditor[]{new TextCellEditor(), new TextCellEditor((Composite)this.availableComponentsViewer.getTree())};
        this.availableComponentsViewer.setCellEditors(editors);
        this.availableComponentsViewer.setCellModifier((ICellModifier)this.getRuntimePathCellModifier());
    }

    protected RuntimePathCellModifier getRuntimePathCellModifier() {
        return new RuntimePathCellModifier();
    }

    protected void addSelectionListener() {
        this.availableComponentsViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                AddModuleDependenciesPropertiesPage.this.viewerSelectionChanged();
            }
        });
    }

    protected void viewerSelectionChanged() {
        this.editReferenceButton.setEnabled(this.hasEditWizardPage(this.getSelectedObject()));
        this.removeButton.setEnabled(this.canRemove(this.getSelectedObject()));
    }

    protected boolean canRemove(Object selectedObject) {
        return selectedObject != null;
    }

    protected boolean hasEditWizardPage(Object o) {
        if (o == null || !(o instanceof IVirtualReference)) {
            return false;
        }
        WizardFragment wf = NewReferenceWizard.getFirstEditingFragment((IVirtualReference)o);
        return wf != null;
    }

    protected Object getSelectedObject() {
        IStructuredSelection sel = (IStructuredSelection)this.availableComponentsViewer.getSelection();
        return sel.getFirstElement();
    }

    public void handleEvent(Event event) {
        if (event.widget == this.addReferenceButton) {
            this.handleAddReferenceButton();
        } else if (event.widget == this.editReferenceButton) {
            this.handleEditReferenceButton();
        } else if (event.widget == this.removeButton) {
            this.handleRemoveSelectedButton();
        }
    }

    protected void handleAddReferenceButton() {
        this.showReferenceWizard(false);
    }

    protected void handleEditReferenceButton() {
        this.showReferenceWizard(true);
    }

    protected void filterReferenceTypes(List<DependencyPageExtensionManager.ReferenceExtension> defaults) {
    }

    protected void showReferenceWizard(boolean editing) {
        WizardDialog wd;
        Object o;
        List<DependencyPageExtensionManager.ReferenceExtension> extensions = DependencyPageExtensionManager.getManager().getExposedReferenceExtensions();
        Iterator<DependencyPageExtensionManager.ReferenceExtension> itr = extensions.iterator();
        while (itr.hasNext()) {
            DependencyPageExtensionManager.ReferenceExtension extension = itr.next();
            if (extension.isApplicable(this.project)) continue;
            itr.remove();
        }
        this.filterReferenceTypes(extensions);
        NewReferenceWizard wizard = new NewReferenceWizard(extensions);
        wizard.getTaskModel().putObject("root.project", this.project);
        wizard.getTaskModel().putObject("root.component", this.rootComponent);
        wizard.getTaskModel().putObject("module.handler", this.getModuleHandler());
        wizard.getTaskModel().putObject("current.references", this.currentReferences);
        ArrayList<Object> directives = new ArrayList<Object>();
        TreeItem[] treeItemArray = this.availableComponentsViewer.getTree().getItems();
        int n = treeItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem item = treeItemArray[n2];
            directives.add(item.getData());
            ++n2;
        }
        wizard.getTaskModel().putObject("all.directives", directives);
        this.setCustomReferenceWizardProperties(wizard.getTaskModel());
        IVirtualReference selected = null;
        if (editing && (o = ((IStructuredSelection)this.availableComponentsViewer.getSelection()).getFirstElement()) instanceof IVirtualReference) {
            selected = (IVirtualReference)o;
            wizard.getTaskModel().putObject("dependency.reference.original", selected);
        }
        if ((wd = new WizardDialog(this.addReferenceButton.getShell(), (IWizard)wizard)).open() != 1) {
            if (editing && selected != null) {
                this.currentReferences.remove(selected);
            }
            this.handleAddDirective(wizard);
            this.refresh();
        }
    }

    protected void setCustomReferenceWizardProperties(TaskModel model) {
    }

    protected void handleAddDirective(TaskWizard wizard) {
        Object folderMapping = wizard.getTaskModel().getObject("folder.mapping");
        if (folderMapping != null && folderMapping instanceof ComponentResourceProxy) {
            ComponentResourceProxy proxy = (ComponentResourceProxy)folderMapping;
            this.resourceMappings.add(proxy);
            this.resourceMappingsChanged = true;
        } else {
            Object reference = wizard.getTaskModel().getObject("dependency.reference.final");
            if (reference != null) {
                IVirtualReference[] iVirtualReferenceArray;
                if (reference instanceof IVirtualReference) {
                    IVirtualReference[] iVirtualReferenceArray2 = new IVirtualReference[1];
                    iVirtualReferenceArray = iVirtualReferenceArray2;
                    iVirtualReferenceArray2[0] = (IVirtualReference)reference;
                } else {
                    iVirtualReferenceArray = (IVirtualReference[])reference;
                }
                IVirtualReference[] referenceArray = iVirtualReferenceArray;
                this.currentReferences.addAll(Arrays.asList(referenceArray));
            }
        }
    }

    protected String getRuntimePath(IVirtualComponent addedComp, String wizardPath) {
        return wizardPath;
    }

    protected void handleRemoveSelectedButton() {
        ISelection sel = this.availableComponentsViewer.getSelection();
        if (sel instanceof IStructuredSelection) {
            IStructuredSelection sel2 = (IStructuredSelection)sel;
            Object[] selectedStuff = sel2.toArray();
            int i = 0;
            while (i < selectedStuff.length) {
                Object o = selectedStuff[i];
                this.remove(o);
                ++i;
            }
            this.refresh();
        }
    }

    protected void remove(Object selectedItem) {
        if (selectedItem instanceof IVirtualReference) {
            this.currentReferences.remove(selectedItem);
        } else if (selectedItem instanceof ComponentResourceProxy) {
            this.resourceMappings.remove(selectedItem);
            this.resourceMappingsChanged = true;
        }
    }

    public TreeViewer createAvailableComponentsViewer(Composite parent) {
        int flags = 67586;
        Tree tree = new Tree(parent, flags);
        TreeViewer tempViewer = new TreeViewer(tree);
        TableLayout tableLayout = new TableLayout();
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(400, true));
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(500, true));
        tree.setLayout((Layout)tableLayout);
        tree.setHeaderVisible(true);
        tree.setLinesVisible(true);
        tempViewer.setSorter(null);
        TreeColumn projectColumn = new TreeColumn(tree, 0, 0);
        projectColumn.setText(Messages.SourceColumn);
        projectColumn.setResizable(true);
        TreeColumn bndColumn = new TreeColumn(tree, 0, 1);
        bndColumn.setText(Messages.DeployPathColumn);
        bndColumn.setResizable(true);
        tableLayout.layout((Composite)tree, true);
        return tempViewer;
    }

    public void refresh() {
        this.resetTableUI();
        if (!this.hasInitialized) {
            this.initialize();
            this.resetTableUI();
        }
        this.verify();
    }

    protected void verify() {
        ArrayList<ComponentResourceProxy> allMappings = new ArrayList<ComponentResourceProxy>();
        allMappings.addAll(this.resourceMappings);
        allMappings.addAll(this.hiddenMappings);
        IStatus status = DeploymentAssemblyVerifierHelper.verify(this.rootComponent, this.runtime, this.currentReferences, allMappings, this.resourceMappingsChanged);
        this.propPage.setErrorMessage(null);
        this.propPage.setMessage(null);
        if (status.isMultiStatus()) {
            MultiStatus multi = (MultiStatus)status;
            if (!multi.isOK()) {
                this.propPage.setMessage(this.getMessage(multi), multi.getSeverity());
                if (multi.getSeverity() == 4) {
                    this.propPage.setErrorMessage(this.getMessage(multi));
                    this.propPage.setValid(false);
                } else {
                    this.propPage.setValid(true);
                }
            } else {
                this.propPage.setValid(true);
            }
        } else if (status.isOK()) {
            this.propPage.setValid(true);
        }
        this.propPage.getContainer().updateMessage();
    }

    private String getMessage(MultiStatus multi) {
        StringBuffer message = new StringBuffer();
        int i = 0;
        while (i < multi.getChildren().length) {
            IStatus status = multi.getChildren()[i];
            if (!status.isOK() && status.getMessage() != null) {
                message.append(status.getMessage());
                message.append(" ");
            }
            ++i;
        }
        return message.toString();
    }

    protected void resetTableUI() {
        IWorkspaceRoot input = ResourcesPlugin.getWorkspace().getRoot();
        this.availableComponentsViewer.setInput((Object)input);
        GridData data = new GridData(1808);
        int numlines = Math.min(10, this.availableComponentsViewer.getTree().getItemCount());
        data.heightHint = this.availableComponentsViewer.getTree().getItemHeight() * numlines;
        this.availableComponentsViewer.getTree().setLayoutData((Object)data);
        GridData btndata = new GridData(258);
        this.buttonColumn.setLayoutData((Object)btndata);
    }

    protected void initialize() {
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("REQUESTED_REFERENCE_TYPE", "DISPLAYABLE_REFERENCES");
        IVirtualReference[] refs = this.rootComponent.getReferences(options);
        this.originalReferences.addAll(Arrays.asList(refs));
        this.currentReferences.addAll(Arrays.asList(this.cloneReferences(refs)));
        ComponentResource[] allMappings = this.findAllExposedMappings();
        int i = 0;
        while (i < allMappings.length) {
            this.resourceMappings.add(new ComponentResourceProxy(allMappings[i].getSourcePath(), allMappings[i].getRuntimePath()));
            ++i;
        }
        ComponentResource[] onlyHiddenMappings = this.findOnlyHiddenMappings();
        int i2 = 0;
        while (i2 < onlyHiddenMappings.length) {
            this.hiddenMappings.add(new ComponentResourceProxy(onlyHiddenMappings[i2].getSourcePath(), onlyHiddenMappings[i2].getRuntimePath()));
            ++i2;
        }
        if (this.editReferenceButton != null) {
            this.editReferenceButton.setEnabled(false);
        }
        if (this.removeButton != null) {
            this.removeButton.setEnabled(false);
        }
        this.hasInitialized = true;
    }

    private IRuntime getServerRuntime(IProject project2) throws CoreException {
        if (this.project == null) {
            return null;
        }
        IFacetedProject facetedProject = ProjectFacetsManager.create((IProject)this.project);
        if (facetedProject == null) {
            return null;
        }
        org.eclipse.wst.common.project.facet.core.runtime.IRuntime runtime = facetedProject.getRuntime();
        if (runtime == null) {
            return null;
        }
        return FacetUtil.getRuntime((org.eclipse.wst.common.project.facet.core.runtime.IRuntime)runtime);
    }

    protected IVirtualReference[] cloneReferences(IVirtualReference[] refs) {
        IVirtualReference[] result = new IVirtualReference[refs.length];
        int i = 0;
        while (i < result.length) {
            VirtualReference temp = new VirtualReference(refs[i].getEnclosingComponent(), refs[i].getReferencedComponent());
            temp.setDependencyType(refs[i].getDependencyType());
            temp.setDerived(refs[i].isDerived());
            temp.setArchiveName(refs[i].getArchiveName());
            temp.setRuntimePath(refs[i].getRuntimePath());
            result[i] = temp;
            ++i;
        }
        return result;
    }

    protected ComponentResource[] findAllMappings() {
        StructureEdit structureEdit = null;
        try {
            structureEdit = StructureEdit.getStructureEditForRead((IProject)this.project);
            WorkbenchComponent component = structureEdit.getComponent();
            Object[] arr = component.getResources().toArray();
            ComponentResource[] result = new ComponentResource[arr.length];
            int i = 0;
            while (i < arr.length) {
                result[i] = (ComponentResource)arr[i];
                ++i;
            }
            ComponentResource[] componentResourceArray = result;
            return componentResourceArray;
        }
        catch (NullPointerException e) {
            ModuleCoreUIPlugin.logError(e);
        }
        finally {
            if (structureEdit != null) {
                structureEdit.dispose();
            }
        }
        return new ComponentResource[0];
    }

    protected ComponentResource[] findAllExposedMappings() {
        StructureEdit structureEdit = null;
        try {
            structureEdit = StructureEdit.getStructureEditForRead((IProject)this.project);
            WorkbenchComponent component = structureEdit.getComponent();
            Object[] arr = component.getResources().toArray();
            ArrayList<ComponentResource> result = new ArrayList<ComponentResource>();
            int i = 0;
            while (i < arr.length) {
                ComponentResource resource = (ComponentResource)arr[i];
                if (!ResourceMappingFilterExtensionRegistry.shouldFilter(resource.getSourcePath())) {
                    result.add((ComponentResource)arr[i]);
                }
                ++i;
            }
            ComponentResource[] componentResourceArray = result.toArray(new ComponentResource[result.size()]);
            return componentResourceArray;
        }
        catch (NullPointerException e) {
            ModuleCoreUIPlugin.logError(e);
        }
        finally {
            if (structureEdit != null) {
                structureEdit.dispose();
            }
        }
        return new ComponentResource[0];
    }

    protected ComponentResource[] findOnlyHiddenMappings() {
        StructureEdit structureEdit = null;
        try {
            structureEdit = StructureEdit.getStructureEditForRead((IProject)this.project);
            WorkbenchComponent component = structureEdit.getComponent();
            Object[] arr = component.getResources().toArray();
            ArrayList<ComponentResource> result = new ArrayList<ComponentResource>();
            int i = 0;
            while (i < arr.length) {
                ComponentResource resource = (ComponentResource)arr[i];
                if (ResourceMappingFilterExtensionRegistry.shouldFilter(resource.getSourcePath())) {
                    result.add((ComponentResource)arr[i]);
                }
                ++i;
            }
            ComponentResource[] componentResourceArray = result.toArray(new ComponentResource[result.size()]);
            return componentResourceArray;
        }
        catch (NullPointerException e) {
            ModuleCoreUIPlugin.logError(e);
        }
        finally {
            if (structureEdit != null) {
                structureEdit.dispose();
            }
        }
        return new ComponentResource[0];
    }

    @Override
    public void setVisible(boolean visible) {
    }

    @Override
    public void performDefaults() {
        this.currentReferences.clear();
        IVirtualReference[] currentTmp = this.originalReferences.toArray(new IVirtualReference[this.originalReferences.size()]);
        this.currentReferences.addAll(Arrays.asList(this.cloneReferences(currentTmp)));
        this.resourceMappings.clear();
        ComponentResource[] allMappings = this.findAllExposedMappings();
        int i = 0;
        while (i < allMappings.length) {
            this.resourceMappings.add(new ComponentResourceProxy(allMappings[i].getSourcePath(), allMappings[i].getRuntimePath()));
            ++i;
        }
        this.refresh();
    }

    @Override
    public boolean performCancel() {
        return true;
    }

    @Override
    public void dispose() {
        if (this.availableComponentsViewer != null) {
            this.availableComponentsViewer.getTree();
        }
    }

    protected boolean preHandleChanges(IProgressMonitor monitor) {
        return true;
    }

    protected boolean postHandleChanges(IProgressMonitor monitor) {
        return true;
    }

    @Override
    public boolean performOk() {
        boolean result = true;
        result &= this.saveResourceChanges();
        return result &= this.saveReferenceChanges();
    }

    protected boolean saveResourceChanges() {
        if (this.resourceMappingsChanged) {
            this.removeAllResourceMappings();
            this.addNewResourceMappings();
            this.addAllHiddenResourceMappings();
        }
        return true;
    }

    private void addAllHiddenResourceMappings() {
        ComponentResourceProxy[] proxies = this.hiddenMappings.toArray(new ComponentResourceProxy[this.hiddenMappings.size()]);
        IVirtualFolder rootFolder = this.rootComponent.getRootFolder();
        int i = 0;
        while (i < proxies.length) {
            try {
                rootFolder.getFolder(proxies[i].runtimePath).createLink(proxies[i].source, 0, null);
            }
            catch (CoreException ce) {
                ModuleCoreUIPlugin.logError(ce);
            }
            ++i;
        }
    }

    protected boolean addNewResourceMappings() {
        ComponentResourceProxy[] proxies = this.resourceMappings.toArray(new ComponentResourceProxy[this.resourceMappings.size()]);
        IVirtualFolder rootFolder = this.rootComponent.getRootFolder();
        int i = 0;
        while (i < proxies.length) {
            try {
                rootFolder.getFolder(proxies[i].runtimePath).createLink(proxies[i].source, 0, null);
            }
            catch (CoreException ce) {
                ModuleCoreUIPlugin.logError(ce);
            }
            ++i;
        }
        this.resourceMappingsChanged = false;
        return true;
    }

    protected boolean removeAllResourceMappings() {
        StructureEdit moduleCore = null;
        try {
            moduleCore = StructureEdit.getStructureEditForWrite((IProject)this.project);
            moduleCore.getComponent().getResources().clear();
        }
        finally {
            if (moduleCore != null) {
                moduleCore.saveIfNecessary((IProgressMonitor)new NullProgressMonitor());
                moduleCore.dispose();
            }
        }
        return true;
    }

    protected boolean saveReferenceChanges() {
        ArrayList<IVirtualReference> added = new ArrayList<IVirtualReference>();
        ArrayList<IVirtualReference> removed = new ArrayList<IVirtualReference>();
        HashMap<IVirtualComponent, IVirtualReference> map = new HashMap<IVirtualComponent, IVirtualReference>();
        for (IVirtualReference v1 : this.currentReferences) {
            map.put(v1.getReferencedComponent(), v1);
        }
        for (IVirtualReference origRef : this.originalReferences) {
            IVirtualReference newRef = (IVirtualReference)map.get(origRef.getReferencedComponent());
            if (newRef == null) {
                removed.add(origRef);
            } else if (!AddModuleDependenciesPropertiesPage.getSafeRuntimePath(origRef).equals(AddModuleDependenciesPropertiesPage.getSafeRuntimePath(newRef))) {
                removed.add(origRef);
                added.add(newRef);
            }
            map.remove(origRef.getReferencedComponent());
        }
        added.addAll(map.values());
        NullProgressMonitor monitor = new NullProgressMonitor();
        boolean subResult = this.preHandleChanges((IProgressMonitor)monitor);
        if (!subResult) {
            return false;
        }
        this.handleRemoved(removed);
        this.handleAdded(added);
        subResult &= this.postHandleChanges((IProgressMonitor)monitor);
        this.originalReferences.clear();
        this.originalReferences.addAll(this.currentReferences);
        this.currentReferences.clear();
        IVirtualReference[] currentTmp = this.originalReferences.toArray(new IVirtualReference[this.originalReferences.size()]);
        this.currentReferences.addAll(Arrays.asList(this.cloneReferences(currentTmp)));
        return subResult;
    }

    protected void handleRemoved(ArrayList<IVirtualReference> removed) {
        if (removed.isEmpty()) {
            return;
        }
        final ArrayList<IVirtualReference> refs = new ArrayList<IVirtualReference>();
        for (IVirtualReference o : removed) {
            refs.add(o);
        }
        IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                AddModuleDependenciesPropertiesPage.this.removeReferences(refs);
            }
        };
        try {
            ResourcesPlugin.getWorkspace().run(runnable, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            ModuleCoreUIPlugin.logError(e);
        }
    }

    protected void removeReferences(ArrayList<IVirtualReference> removed) {
        Iterator<IVirtualReference> i = removed.iterator();
        while (i.hasNext()) {
            this.removeOneReference(i.next());
        }
    }

    protected void removeOneReference(IVirtualReference comp) {
        try {
            IDataModelOperation operation = this.getRemoveComponentOperation(comp);
            operation.execute(null, null);
        }
        catch (ExecutionException e) {
            ModuleCoreUIPlugin.logError(e);
        }
    }

    protected IDataModelOperation getRemoveComponentOperation(IVirtualReference reference) {
        IDataModelProvider provider = this.getRemoveReferenceDataModelProvider(reference);
        IDataModel model = DataModelFactory.createDataModel((IDataModelProvider)provider);
        model.setProperty("IAddReferenceDataModelProperties.SOURCE_COMPONENT", (Object)this.rootComponent);
        ArrayList<IVirtualReference> toRemove = new ArrayList<IVirtualReference>();
        toRemove.add(reference);
        model.setProperty("IAddReferenceDataModelProperties.TARGET_REFERENCE_LIST", toRemove);
        return model.getDefaultOperation();
    }

    protected IDataModelProvider getRemoveReferenceDataModelProvider(IVirtualReference reference) {
        return new RemoveReferenceDataModelProvider();
    }

    protected void handleAdded(ArrayList<IVirtualReference> added) {
        final ArrayList<IVirtualReference> refs = new ArrayList<IVirtualReference>();
        for (IVirtualReference o : added) {
            refs.add(o);
        }
        IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                AddModuleDependenciesPropertiesPage.this.addReferences(refs);
            }
        };
        try {
            ResourcesPlugin.getWorkspace().run(runnable, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            ModuleCoreUIPlugin.logError(e);
        }
    }

    protected void addReferences(ArrayList<IVirtualReference> refs) throws CoreException {
        Iterator<IVirtualReference> i = refs.iterator();
        while (i.hasNext()) {
            this.addOneReference(i.next());
        }
    }

    protected IDataModelProvider getAddReferenceDataModelProvider(IVirtualReference component) {
        return new AddReferenceDataModelProvider();
    }

    protected void addOneReference(IVirtualReference ref) throws CoreException {
        IDataModelProvider provider = this.getAddReferenceDataModelProvider(ref);
        IDataModel dm = DataModelFactory.createDataModel((IDataModelProvider)provider);
        dm.setProperty("IAddReferenceDataModelProperties.SOURCE_COMPONENT", (Object)this.rootComponent);
        dm.setProperty("IAddReferenceDataModelProperties.TARGET_REFERENCE_LIST", Arrays.asList(ref));
        IStatus stat = dm.validateProperty("IAddReferenceDataModelProperties.TARGET_REFERENCE_LIST");
        if (stat != OK_STATUS) {
            throw new CoreException(stat);
        }
        try {
            dm.getDefaultOperation().execute((IProgressMonitor)new NullProgressMonitor(), null);
        }
        catch (ExecutionException e) {
            ModuleCoreUIPlugin.logError(e);
        }
    }

    public void labelProviderChanged(LabelProviderChangedEvent event) {
        if (!this.availableComponentsViewer.getTree().isDisposed()) {
            this.availableComponentsViewer.refresh(true);
        }
    }

    protected IModuleHandler getModuleHandler() {
        if (this.moduleHandler == null) {
            this.moduleHandler = new DefaultModuleHandler();
        }
        return this.moduleHandler;
    }

    @Override
    public void performApply() {
        this.performOk();
        this.verify();
    }

    public static class ComponentResourceProxy {
        public IPath source;
        public IPath runtimePath;

        public ComponentResourceProxy(IPath source, IPath runtimePath) {
            this.source = source;
            this.runtimePath = runtimePath;
        }
    }

    protected class RuntimePathCellModifier
    implements ICellModifier {
        protected RuntimePathCellModifier() {
        }

        public boolean canModify(Object element, String property) {
            if (property.equals(DEPLOY_PATH_PROPERTY)) {
                if (element instanceof IVirtualReference && !((IVirtualReference)element).isDerived()) {
                    return true;
                }
                if (element instanceof ComponentResourceProxy) {
                    return true;
                }
            }
            return false;
        }

        public Object getValue(Object element, String property) {
            if (element instanceof IVirtualReference) {
                return AddModuleDependenciesPropertiesPage.getSafeRuntimePath((IVirtualReference)element);
            }
            if (element instanceof ComponentResourceProxy) {
                return ((ComponentResourceProxy)element).runtimePath.toString();
            }
            return new Path("/");
        }

        public void modify(Object element, String property, Object value) {
            if (property.equals(DEPLOY_PATH_PROPERTY)) {
                TreeItem item = (TreeItem)element;
                TreeItem[] components = AddModuleDependenciesPropertiesPage.this.availableComponentsViewer.getTree().getItems();
                int tableIndex = -1;
                int i = 0;
                while (i < components.length) {
                    if (components[i] == item) {
                        tableIndex = i;
                        break;
                    }
                    ++i;
                }
                if (item.getData() instanceof IVirtualReference) {
                    AddModuleDependenciesPropertiesPage.setRuntimePathSafe((IVirtualReference)item.getData(), (String)value);
                    if (tableIndex >= 0) {
                        components[tableIndex].setText(1, (String)value);
                    }
                } else if (item.getData() instanceof ComponentResourceProxy) {
                    ComponentResourceProxy c = (ComponentResourceProxy)item.getData();
                    c.runtimePath = new Path((String)value);
                    AddModuleDependenciesPropertiesPage.this.resourceMappingsChanged = true;
                    if (tableIndex >= 0) {
                        components[tableIndex].setText(1, (String)value);
                    }
                }
                AddModuleDependenciesPropertiesPage.this.verify();
            }
        }
    }
}

