/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.jaxws.dom.runtime.tests.dom.persistence.sync;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.ISourceManipulation;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jst.ws.jaxws.dom.runtime.api.IServiceEndpointInterface;
import org.eclipse.jst.ws.jaxws.dom.runtime.api.IWebService;
import org.eclipse.jst.ws.jaxws.dom.runtime.api.IWebServiceProject;
import org.eclipse.jst.ws.jaxws.dom.runtime.persistence.JaxWsWorkspaceResource;
import org.eclipse.jst.ws.jaxws.dom.runtime.tests.dom.persistence.sync.SynchronizationTestFixture;
import org.eclipse.jst.ws.jaxws.testutils.jobs.JobUtils;
import org.eclipse.jst.ws.jaxws.testutils.project.TestEjb3Project;
import org.eclipse.jst.ws.jaxws.testutils.project.TestProject;
import org.eclipse.jst.ws.jaxws.testutils.project.TestProjectsUtils;

public class ModelSynchronizationTests
extends SynchronizationTestFixture {
    private void assertBeforeAfterAreTheSame() {
        IWebServiceProject newRefWsPrj1 = this.domUtil.findProjectByName(this.target.getDOM(), this.testPrj1.getJavaProject().getElementName());
        ModelSynchronizationTests.assertEquals((Object)this.wsPrj1, (Object)newRefWsPrj1);
        ModelSynchronizationTests.assertEquals((Object)this.ws1, (Object)this.domUtil.findWsByImplName(newRefWsPrj1, "com.sap.test.modelsync1.WS1"));
        ModelSynchronizationTests.assertEquals((Object)this.sei1, (Object)this.domUtil.findSeiByImplName(newRefWsPrj1, "com.sap.test.modelsync1.Sei1"));
        IWebServiceProject newRefWsPrj2 = this.domUtil.findProjectByName(this.target.getDOM(), this.testPrj2.getJavaProject().getElementName());
        ModelSynchronizationTests.assertEquals((Object)this.wsPrj2, (Object)newRefWsPrj2);
        ModelSynchronizationTests.assertEquals((Object)this.ws2, (Object)this.domUtil.findWsByImplName(newRefWsPrj2, "com.sap.test.modelsync2.WS2"));
        ModelSynchronizationTests.assertEquals((Object)this.sei2, (Object)this.domUtil.findSeiByImplName(newRefWsPrj2, "com.sap.test.modelsync2.Sei2"));
    }

    public void test_openedWsProjectSynched() throws Exception {
        TestProject testPrj3 = new TestProject(new TestEjb3Project("TestEJBProject3").getProject());
        try {
            this.allowedProjects.add(testPrj3.getJavaProject().getElementName());
            IPackageFragment modelSync3 = testPrj3.createPackage("com.sap.test.modelsync3");
            testPrj3.createType(modelSync3, "Sei3.java", "@javax.jws.WebService(name=\"Sei3Name\") public interface Sei3 {}");
            testPrj3.createType(modelSync3, "WS3.java", "@javax.jws.WebService(serviceName=\"WS3Name\", endpointInterface=\"com.sap.test.modelsync1.Sei3Name\") public class WS3 {}");
            testPrj3.getProject().close(null);
            JobUtils.waitForJobs();
            this.target.startSynchronizing();
            testPrj3.getProject().open(null);
            JobUtils.waitForJobs();
            this.assertBeforeAfterAreTheSame();
            IWebServiceProject wsPrj3 = this.domUtil.findProjectByName(this.target.getDOM(), testPrj3.getJavaProject().getElementName());
            ModelSynchronizationTests.assertNotNull((String)"Web Service Project not synchronized after opened", (Object)wsPrj3);
            IWebService ws3 = this.domUtil.findWsByImplName(wsPrj3, "com.sap.test.modelsync3.WS3");
            ModelSynchronizationTests.assertNotNull((String)"Web Service not synchronized after containing project was oppened", (Object)ws3);
            IServiceEndpointInterface sei3 = this.domUtil.findSeiByImplName(wsPrj3, "com.sap.test.modelsync3.Sei3");
            ModelSynchronizationTests.assertNotNull((String)"Service Endpoint interface not synchronized after containing project was oppened", (Object)sei3);
        }
        finally {
            testPrj3.dispose();
        }
    }

    public void test_openedProjectWithEnumsInitialySynched() throws CoreException, Exception {
        TestProject testPrj3 = new TestProject(new TestEjb3Project("TestEJBProject3").getProject());
        try {
            this.allowedProjects.add(testPrj3.getJavaProject().getElementName());
            IPackageFragment modelSync3 = testPrj3.createPackage("com.sap.test.modelsync3");
            testPrj3.createType(modelSync3, "TestEnum.java", "public enum TestEnum {A, B, C}");
            this.target = this.createTarget();
            JobUtils.waitForJobs();
            this.target.load(null);
            IWebServiceProject wsPrj3 = this.domUtil.findProjectByName(this.target.getDOM(), testPrj3.getJavaProject().getElementName());
            ModelSynchronizationTests.assertNotNull((String)"Web Service Project not synchronized after created", (Object)wsPrj3);
        }
        finally {
            testPrj3.dispose();
        }
    }

    public void test_newSeiCompilationUnitsSynched() throws JavaModelException, CoreException, InterruptedException {
        this.verifySetUpModelEntitesNotChanged();
        IPackageFragment pf = this.testPrj1.createPackage("com.sap.test.newsei");
        JobUtils.waitForJobs();
        this.target.startSynchronizing();
        this.testPrj1.createType(pf, "Sei3.java", "@javax.jws.WebService(name=\"Sei3Name\", targetNamespace=\"http://com.sap.test/\") public interface Sei3 {}");
        JobUtils.waitForJobs();
        this.assertBeforeAfterAreTheSame();
        IWebServiceProject wsPrj1 = this.domUtil.findProjectByName(this.target.getDOM(), this.testPrj1.getJavaProject().getElementName());
        IServiceEndpointInterface sei3 = this.domUtil.findSeiByImplName(wsPrj1, "com.sap.test.newsei.Sei3");
        ModelSynchronizationTests.assertNotNull((String)"Newly added SEI not synched into the model", (Object)sei3);
        ModelSynchronizationTests.assertEquals((String)"Java Intf for newly added SEI does not match the expected", (String)"com.sap.test.newsei.Sei3", (String)sei3.getImplementation());
        ModelSynchronizationTests.assertEquals((String)"Target NS for newly added SEI does not match the expected", (String)"http://com.sap.test/", (String)sei3.getTargetNamespace());
        ModelSynchronizationTests.assertEquals((String)"The name of the newly added sei doesn't match", (String)"Sei3Name", (String)sei3.getName());
    }

    public void test_unreSolvedSeiRefGetsResolvedAfterSeiAdded() throws JavaModelException, CoreException, InterruptedException {
        this.verifySetUpModelEntitesNotChanged();
        IPackageFragment pf = this.testPrj1.createPackage("com.sap.test.newws");
        JobUtils.waitForJobs();
        this.target.startSynchronizing();
        this.testPrj1.createType(pf, "WS3.java", "@javax.jws.WebService(serviceName=\"WS3Name\", endpointInterface=\"com.sap.test.newsei.Sei3\") public class WS3 {}");
        JobUtils.waitForJobs();
        this.assertBeforeAfterAreTheSame();
        IWebServiceProject wsPrj1 = this.domUtil.findProjectByName(this.target.getDOM(), this.testPrj1.getJavaProject().getElementName());
        IWebService ws3 = this.domUtil.findWsByImplName(wsPrj1, "com.sap.test.newws.WS3");
        ModelSynchronizationTests.assertNotNull((String)"Web Service not synchronized after new compilation unit with ws was added", (Object)ws3);
        this.test_newSeiCompilationUnitsSynched();
        IServiceEndpointInterface newlyAddedSei = this.domUtil.findSeiByImplName(wsPrj1, "com.sap.test.newsei.Sei3");
        ModelSynchronizationTests.assertNotNull((String)"Newly added sei not found in the model. Probably the test_newSeiCompilationUnitsSynched() test method has changed the name of the interface it works with", (Object)newlyAddedSei);
        ModelSynchronizationTests.assertSame((String)"Web Service Reference not resolved properly", (Object)newlyAddedSei, (Object)ws3.getServiceEndpoint());
    }

    public void test_newSourceFolderWithJavaContentSynchedWhenAdded() throws JavaModelException, CoreException, InterruptedException {
        IFolder folder = this.testPrj1.getProject().getFolder("src1");
        folder.create(true, true, null);
        IClasspathEntry[] oldEntries = this.testPrj1.getJavaProject().getRawClasspath();
        IClasspathEntry[] newEntries = new IClasspathEntry[oldEntries.length + 1];
        System.arraycopy(oldEntries, 0, newEntries, 0, oldEntries.length);
        IPackageFragmentRoot newSourceFolder = this.testPrj1.getJavaProject().getPackageFragmentRoot((IResource)folder);
        newEntries[oldEntries.length] = JavaCore.newSourceEntry((IPath)newSourceFolder.getPath());
        this.testPrj1.setClasspath(newEntries);
        IPackageFragment pf = newSourceFolder.createPackageFragment("com.sap.test.newws", true, null);
        this.testPrj1.createType(pf, "WS3.java", "@javax.jws.WebService(serviceName=\"WS3Name\", endpointInterface=\"com.sap.test.newsei.Sei3\") public class WS3 {}");
        this.testPrj1.createType(pf, "Sei3.java", "@javax.jws.WebService(name=\"Sei3Name\") public interface Sei3 {}");
        this.testPrj1.setClasspath(oldEntries);
        JobUtils.waitForJobs();
        this.target.startSynchronizing();
        this.testPrj1.setClasspath(newEntries);
        JobUtils.waitForJobs();
        IWebServiceProject wsPrj1 = this.domUtil.findProjectByName(this.target.getDOM(), this.testPrj1.getJavaProject().getElementName());
        IWebService ws3 = this.domUtil.findWsByImplName(wsPrj1, "com.sap.test.newws.WS3");
        ModelSynchronizationTests.assertNotNull((String)"Web Service not synchronized after a source folder in which it was contained was added", (Object)ws3);
        IServiceEndpointInterface sei3 = this.domUtil.findSeiByImplName(wsPrj1, "com.sap.test.newws.Sei3");
        ModelSynchronizationTests.assertNotNull((String)"Sei not synched after a source folder in which it was contained was added", (Object)sei3);
    }

    public void test_removedSourceFolderSyched() throws CoreException, InterruptedException {
        this.test_newSourceFolderWithJavaContentSynchedWhenAdded();
        IClasspathEntry[] oldEntries = this.testPrj1.getJavaProject().getRawClasspath();
        IClasspathEntry[] newEntries = new IClasspathEntry[oldEntries.length - 1];
        System.arraycopy(oldEntries, 0, newEntries, 0, newEntries.length);
        this.testPrj1.setClasspath(newEntries);
        JobUtils.waitForJobs();
        ModelSynchronizationTests.assertNull((Object)this.domUtil.findWsByImplName(this.wsPrj1, "com.sap.test.newws.WS3"));
        ModelSynchronizationTests.assertNull((Object)this.domUtil.findSeiByImplName(this.wsPrj1, "com.sap.test.newws.Sei3"));
    }

    public void test_removedOrClosedProjectSynched() throws JavaModelException, CoreException {
        this.target.startSynchronizing();
        IPackageFragment modelSync1 = this.testPrj1.createPackage("com.sap.test.modelsync1_1");
        this.testPrj1.createType(modelSync1, "WS3.java", "@javax.jws.WebService(serviceName=\"WS3Name\", endpointInterface=\"com.sap.test.modelsync2_1.Sei3\") public class WS3 {}");
        IPackageFragment modelSync2 = this.testPrj2.createPackage("com.sap.test.modelsync2_1");
        this.testPrj2.createType(modelSync2, "Sei3.java", "@javax.jws.WebService(name=\"Sei3Name\") public interface Sei3 {}");
        JobUtils.waitForJobs();
        IWebService ws3 = this.domUtil.findWsByImplName(this.wsPrj1, "com.sap.test.modelsync1_1.WS3");
        ModelSynchronizationTests.assertNotNull((Object)ws3);
        IServiceEndpointInterface sei3 = this.domUtil.findSeiByImplName(this.wsPrj2, "com.sap.test.modelsync2_1.Sei3");
        ModelSynchronizationTests.assertNotNull((Object)sei3);
        ModelSynchronizationTests.assertEquals((Object)sei3, (Object)ws3.getServiceEndpoint());
        String testPrj2Name = this.testPrj2.getJavaProject().getElementName();
        this.testPrj2.getProject().close(null);
        JobUtils.waitForJobs();
        ModelSynchronizationTests.assertNull((Object)this.domUtil.findProjectByName(this.target.getDOM(), testPrj2Name));
        ModelSynchronizationTests.assertNull((String)"The web service returns a sei instance which is contained in a closed project", (Object)ws3.getServiceEndpoint());
    }

    public void test_deletedCUWithSeiSynched() throws JavaModelException, CoreException {
        this.target.startSynchronizing();
        ICompilationUnit sei1CU = this.testPrj1.getJavaProject().findType("com.sap.test.modelsync1.Sei1").getCompilationUnit();
        this.delete((ISourceManipulation)sei1CU, true);
        JobUtils.waitForJobs();
        ModelSynchronizationTests.assertFalse((boolean)this.wsPrj1.getServiceEndpointInterfaces().contains((Object)this.sei1));
        ModelSynchronizationTests.assertNull((Object)this.ws1.getServiceEndpoint());
    }

    public void test_deletedCUWithWSSynched() throws JavaModelException, CoreException {
        this.target.startSynchronizing();
        ICompilationUnit ws1CU = this.testPrj1.getJavaProject().findType("com.sap.test.modelsync1.WS1").getCompilationUnit();
        this.delete((ISourceManipulation)ws1CU, true);
        JobUtils.waitForJobs();
        ModelSynchronizationTests.assertFalse((boolean)this.wsPrj1.getWebServices().contains((Object)this.ws1));
        ModelSynchronizationTests.assertFalse((boolean)this.sei1.getImplementingWebServices().contains((Object)this.ws1));
    }

    public void test_deletedCuContentWithSeiSynched() throws CoreException {
        this.target.startSynchronizing();
        ICompilationUnit sei1Cu = this.testPrj1.getJavaProject().findType("com.sap.test.modelsync1.Sei1").getCompilationUnit();
        this.testUtil.setContents(sei1Cu, "");
        JobUtils.waitForJobs();
        ModelSynchronizationTests.assertFalse((boolean)this.wsPrj1.getWebServices().contains((Object)this.sei1));
        ModelSynchronizationTests.assertNull((Object)this.ws1.getServiceEndpoint());
    }

    public void test_deletedCuContentWithWsSynched() throws CoreException {
        this.target.startSynchronizing();
        ICompilationUnit ws1CU = this.testPrj1.getJavaProject().findType("com.sap.test.modelsync1.WS1").getCompilationUnit();
        this.testUtil.setContents(ws1CU, "");
        JobUtils.waitForJobs();
        ModelSynchronizationTests.assertFalse((boolean)this.wsPrj1.getWebServices().contains((Object)this.ws1));
        ModelSynchronizationTests.assertFalse((boolean)this.sei1.getImplementingWebServices().contains((Object)this.ws1));
    }

    public void test_movedCUWithWSInOtherProjectWithSameJavaNameSynched() throws JavaModelException, CoreException {
        this.target.startSynchronizing();
        ICompilationUnit ws1CU = this.testPrj1.getJavaProject().findType("com.sap.test.modelsync1.WS1").getCompilationUnit();
        IPackageFragment moveIn = this.testPrj2.getSourceFolder().createPackageFragment(ws1CU.getParent().getElementName(), true, null);
        ws1CU.move((IJavaElement)moveIn, null, null, false, null);
        JobUtils.waitForJobs();
        ModelSynchronizationTests.assertFalse((boolean)this.wsPrj1.getWebServices().contains((Object)this.ws1));
        ModelSynchronizationTests.assertTrue((boolean)this.wsPrj2.getWebServices().contains((Object)this.ws1));
        ModelSynchronizationTests.assertTrue((boolean)this.sei1.getImplementingWebServices().contains((Object)this.ws1));
    }

    public void test_movedCUWithSeiInOtherProjectWithSameJavaNameSynched() throws JavaModelException, CoreException {
        this.target.startSynchronizing();
        ICompilationUnit se1CU = this.testPrj1.getJavaProject().findType("com.sap.test.modelsync1.Sei1").getCompilationUnit();
        IPackageFragment moveIn = this.testPrj2.getSourceFolder().createPackageFragment(se1CU.getParent().getElementName(), true, null);
        se1CU.move((IJavaElement)moveIn, null, null, false, null);
        JobUtils.waitForJobs();
        ModelSynchronizationTests.assertFalse((boolean)this.wsPrj1.getServiceEndpointInterfaces().contains((Object)this.sei1));
        ModelSynchronizationTests.assertTrue((boolean)this.wsPrj2.getServiceEndpointInterfaces().contains((Object)this.sei1));
        ModelSynchronizationTests.assertSame((Object)this.ws1.getServiceEndpoint(), (Object)this.sei1);
    }

    public void test_renamedCUWithSeiSynched() throws JavaModelException, CoreException {
        this.target.startSynchronizing();
        ICompilationUnit se1CU = this.testPrj1.getJavaProject().findType("com.sap.test.modelsync1.Sei1").getCompilationUnit();
        se1CU.findPrimaryType().rename("Sei1NewName", false, null);
        JobUtils.waitForJobs();
        ICompilationUnit se1CURenamed = this.testPrj1.getJavaProject().findType("com.sap.test.modelsync1.Sei1NewName").getCompilationUnit();
        ModelSynchronizationTests.assertEquals((String)"Sei1NewName.java", (String)se1CURenamed.getElementName());
        IServiceEndpointInterface renamedSei1 = this.domUtil.findSeiByImplName(this.wsPrj1, se1CURenamed.findPrimaryType().getFullyQualifiedName());
        ModelSynchronizationTests.assertNotNull((Object)renamedSei1);
        ModelSynchronizationTests.assertNull((Object)this.ws1.getServiceEndpoint());
    }

    public void test_renamedCUWithWSSynched() throws JavaModelException, CoreException {
        this.target.startSynchronizing();
        ICompilationUnit ws1CU = this.testPrj1.getJavaProject().findType("com.sap.test.modelsync1.WS1").getCompilationUnit();
        ws1CU.findPrimaryType().rename("WS1NewName", false, null);
        JobUtils.waitForJobs();
        ICompilationUnit ws1CURenamed = this.testPrj1.getJavaProject().findType("com.sap.test.modelsync1.WS1NewName").getCompilationUnit();
        ModelSynchronizationTests.assertEquals((String)"WS1NewName.java", (String)ws1CURenamed.getElementName());
        IWebService renamedWS1 = this.domUtil.findWsByImplName(this.wsPrj1, ws1CURenamed.findPrimaryType().getFullyQualifiedName());
        ModelSynchronizationTests.assertNotNull((Object)renamedWS1);
        ModelSynchronizationTests.assertFalse((boolean)this.sei1.getImplementingWebServices().contains((Object)this.ws1));
        ModelSynchronizationTests.assertTrue((boolean)this.sei1.getImplementingWebServices().contains((Object)renamedWS1));
        ModelSynchronizationTests.assertSame((Object)this.sei1, (Object)renamedWS1.getServiceEndpoint());
    }

    public void test_removedWSAnnotationFromSeiSynched() throws JavaModelException, CoreException {
        this.target.startSynchronizing();
        ICompilationUnit se1CU = this.testPrj1.getJavaProject().findType("com.sap.test.modelsync1.Sei1").getCompilationUnit();
        this.testUtil.setContents(se1CU, "public interface Sei1 {}");
        JobUtils.waitForJobs();
        ModelSynchronizationTests.assertNull((Object)this.domUtil.findSeiByImplName(this.wsPrj1, "com.sap.test.modelsync1.Sei1"));
        ModelSynchronizationTests.assertNull((Object)this.ws1.getServiceEndpoint());
    }

    public void test_removedWSAnnotationFromWSSynched() throws JavaModelException, CoreException {
        this.target.startSynchronizing();
        ICompilationUnit se1CU = this.testPrj1.getJavaProject().findType("com.sap.test.modelsync1.WS1").getCompilationUnit();
        this.testUtil.setContents(se1CU, "public class WS1 {}");
        JobUtils.waitForJobs();
        ModelSynchronizationTests.assertNull((Object)this.domUtil.findSeiByImplName(this.wsPrj1, "com.sap.test.modelsync1.WS1"));
        ModelSynchronizationTests.assertTrue((this.sei1.getImplementingWebServices().size() == 0 ? 1 : 0) != 0);
    }

    public void test_addedWSAnnotaionToClassSynched() throws JavaModelException, CoreException {
        this.target.startSynchronizing();
        IPackageFragment modelSync4 = this.testPrj1.createPackage("com.sap.test.modelsync4");
        ICompilationUnit ws4CU = this.testPrj1.createType(modelSync4, "WS4.java", "public class WS4 {}").getCompilationUnit();
        this.testUtil.setContents(ws4CU, "@javax.jws.WebService(serviceName=\"WS4Name\", endpointInterface=\"com.sap.test.modelsync1.Sei1\", portName=\"TestPortName\", targetNamespace=\"http://com.sap/test\", wsdlLocation=\"C:/test/wsdl/location\") public class WS4 {}");
        JobUtils.waitForJobs();
        IWebService addedWS4 = this.domUtil.findWsByImplName(this.wsPrj1, ws4CU.findPrimaryType().getFullyQualifiedName());
        ModelSynchronizationTests.assertNotNull((Object)addedWS4);
        ModelSynchronizationTests.assertTrue((addedWS4.getServiceEndpoint() == this.sei1 ? 1 : 0) != 0);
        ModelSynchronizationTests.assertEquals((String)"portName not same", (String)"TestPortName", (String)addedWS4.getPortName());
        ModelSynchronizationTests.assertEquals((String)"targetNamespace not same", (String)"http://com.sap/test", (String)addedWS4.getTargetNamespace());
        ModelSynchronizationTests.assertEquals((String)"wsdlLocation not same", (String)"C:/test/wsdl/location", (String)addedWS4.getWsdlLocation());
    }

    public void test_addedWSAnnotationToSeiSynched() throws JavaModelException, CoreException {
        this.target.startSynchronizing();
        IPackageFragment modelSync4 = this.testPrj1.createPackage("com.sap.test.modelsync4");
        IType ws4Type = this.testPrj1.createType(modelSync4, "WS4.java", "@javax.jws.WebService(serviceName=\"WS4Name\", endpointInterface=\"com.sap.test.modelsync4.Sei4\") public class WS4 {}");
        JobUtils.waitForJobs();
        IWebService ws4 = this.domUtil.findWsByImplName(this.wsPrj1, ws4Type.getFullyQualifiedName());
        ModelSynchronizationTests.assertNotNull((Object)ws4);
        ModelSynchronizationTests.assertNull((Object)ws4.getServiceEndpoint());
        ICompilationUnit sei4CU = this.testPrj1.createType(modelSync4, "Sei4.java", "public interface Sei4 {}").getCompilationUnit();
        this.testUtil.setContents(sei4CU, "@javax.jws.WebService(name=\"Sei4Name\") public interface Sei4 {}");
        JobUtils.waitForJobs();
        IServiceEndpointInterface addedWS4 = this.domUtil.findSeiByImplName(this.wsPrj1, sei4CU.findPrimaryType().getFullyQualifiedName());
        ModelSynchronizationTests.assertNotNull((Object)addedWS4);
        ModelSynchronizationTests.assertSame((Object)ws4.getServiceEndpoint(), (Object)addedWS4);
    }

    public void test_changedSeiRefSynched() throws JavaModelException, CoreException {
        this.target.startSynchronizing();
        ICompilationUnit ws1CU = this.testPrj1.getJavaProject().findType(this.ws1.getImplementation()).getCompilationUnit();
        this.testUtil.setContents(ws1CU, "@javax.jws.WebService(serviceName=\"WS1Name\", endpointInterface=\"com.sap.test.modelsync2.Sei2\") public class WS1 {}");
        JobUtils.waitForJobs();
        ModelSynchronizationTests.assertSame((Object)this.sei2, (Object)this.ws1.getServiceEndpoint());
        ModelSynchronizationTests.assertSame((Object)this.ws1, (Object)this.domUtil.findWsByImplName(this.wsPrj1, this.ws1.getImplementation()));
    }

    public void test_changedSeiRefWithUnxesistingSynched() throws JavaModelException, CoreException {
        this.target.startSynchronizing();
        ICompilationUnit ws1CU = this.testPrj1.getJavaProject().findType(this.ws1.getImplementation()).getCompilationUnit();
        this.testUtil.setContents(ws1CU, "@javax.jws.WebService(serviceName=\"WS1Name\", endpointInterface=\"com.sap.test.modelsync2.SeiUnexisting\") public class WS1 {}");
        JobUtils.waitForJobs();
        ModelSynchronizationTests.assertNull((Object)this.ws1.getServiceEndpoint());
        ModelSynchronizationTests.assertSame((Object)this.ws1, (Object)this.domUtil.findWsByImplName(this.wsPrj1, this.ws1.getImplementation()));
    }

    public void test_changedFromExplicitToImplicit() throws JavaModelException, CoreException {
        this.target.startSynchronizing();
        ICompilationUnit ws1CU = this.testPrj1.getJavaProject().findType(this.ws1.getImplementation()).getCompilationUnit();
        this.testUtil.setContents(ws1CU, "@javax.jws.WebService(serviceName=\"WS1Name\", name=\"ImplicitInterfaceName\") public class WS1 {}");
        JobUtils.waitForJobs();
        ModelSynchronizationTests.assertNotSame((Object)this.sei2, (Object)this.ws1.getServiceEndpoint());
        ModelSynchronizationTests.assertTrue((boolean)this.ws1.getServiceEndpoint().isImplicit());
        ModelSynchronizationTests.assertEquals((String)"ImplicitInterfaceName", (String)this.ws1.getServiceEndpoint().getName());
    }

    public void test_deletedPackageSynched() throws CoreException {
        this.target.startSynchronizing();
        IPackageFragment modelSync3 = this.testPrj1.createPackage("com.sap.test.modelsync3");
        this.testPrj1.createType(modelSync3, "WS4.java", "@javax.jws.WebService(serviceName=\"WS1Name\", endpointInterface=\"com.sap.test.modelsync1.Sei1\") public class WS4 {}");
        JobUtils.waitForJobs();
        IWebService ws4 = this.domUtil.findWsByImplName(this.wsPrj1, "com.sap.test.modelsync3.WS4");
        ModelSynchronizationTests.assertNotNull((Object)ws4);
        ModelSynchronizationTests.assertSame((Object)this.sei1, (Object)ws4.getServiceEndpoint());
        IPackageFragment pf = this.testPrj1.getSourceFolder().getPackageFragment("com.sap.test.modelsync1");
        this.delete((ISourceManipulation)pf, true);
        JobUtils.waitForJobs();
        ModelSynchronizationTests.assertNull((Object)this.domUtil.findSeiByImplName(this.wsPrj1, "com.sap.test.modelsync1.Sei1"));
        ModelSynchronizationTests.assertNull((Object)this.domUtil.findWsByImplName(this.wsPrj1, "com.sap.test.modelsync1.WS1"));
        ModelSynchronizationTests.assertNull((Object)ws4.getServiceEndpoint());
    }

    public void test_addedPackageWithCompilationUnitsSynched() throws CoreException, IOException {
        this.target.startSynchronizing();
        File ioPackage = new File(this.testPrj1.getSourceFolder().getResource().getRawLocation().toOSString(), "com/sap/test/modelsync4");
        ioPackage.mkdirs();
        FileWriter writer = new FileWriter(new File(ioPackage, "WS4.java"));
        try {
            writer.write("package com.sap.test.modelsync4;\n @javax.jws.WebService(serviceName=\"WS1Name\", endpointInterface=\"com.sap.test.modelsync1.Sei1\") public class WS4 {}");
            writer.flush();
        }
        finally {
            writer.close();
        }
        this.testPrj1.getSourceFolder().getResource().refreshLocal(2, null);
        JobUtils.waitForJobs();
        ModelSynchronizationTests.assertNotNull((Object)this.domUtil.findWsByImplName(this.wsPrj1, "com.sap.test.modelsync4.WS4"));
    }

    public void test_changedClassToInterface() throws CoreException {
        this.target.startSynchronizing();
        IPackageFragment modelSync = this.testPrj1.createPackage("com.sap.test.modelsync4");
        ICompilationUnit wsCU = this.testPrj1.createType(modelSync, "WS4.java", "@javax.jws.WebService() public class WS4 {}").getCompilationUnit();
        JobUtils.waitForJobs();
        IWebService ws4 = this.domUtil.findWsByImplName(this.wsPrj1, wsCU.findPrimaryType().getFullyQualifiedName());
        ModelSynchronizationTests.assertNotNull((Object)ws4);
        this.testUtil.setContents(wsCU, "@javax.jws.WebService() public interface WS4 {}");
        JobUtils.waitForJobs();
        ws4 = this.domUtil.findWsByImplName(this.wsPrj1, wsCU.findPrimaryType().getFullyQualifiedName());
        ModelSynchronizationTests.assertNull((Object)ws4);
        IServiceEndpointInterface sei = this.domUtil.findSeiByImplName(this.wsPrj1, wsCU.findPrimaryType().getFullyQualifiedName());
        ModelSynchronizationTests.assertNotNull((Object)sei);
        ModelSynchronizationTests.assertFalse((boolean)sei.isImplicit());
    }

    public void test_changedInterfaceToClass() throws CoreException {
        this.target.startSynchronizing();
        IPackageFragment modelSync = this.testPrj1.createPackage("com.sap.test.modelsync4");
        ICompilationUnit wsCU = this.testPrj1.createType(modelSync, "WS4.java", "@javax.jws.WebService() public interface WS4 {}").getCompilationUnit();
        JobUtils.waitForJobs();
        IServiceEndpointInterface sei = this.domUtil.findSeiByImplName(this.wsPrj1, wsCU.findPrimaryType().getFullyQualifiedName());
        ModelSynchronizationTests.assertNotNull((Object)sei);
        ModelSynchronizationTests.assertFalse((boolean)sei.isImplicit());
        this.testUtil.setContents(wsCU, "@javax.jws.WebService() public class WS4 {}");
        JobUtils.waitForJobs();
        sei = this.domUtil.findSeiByImplName(this.wsPrj1, wsCU.findPrimaryType().getFullyQualifiedName());
        ModelSynchronizationTests.assertNotNull((Object)sei);
        ModelSynchronizationTests.assertTrue((boolean)sei.isImplicit());
        IWebService ws4 = this.domUtil.findWsByImplName(this.wsPrj1, wsCU.findPrimaryType().getFullyQualifiedName());
        ModelSynchronizationTests.assertNotNull((Object)ws4);
    }

    public void test_changedInterfaceAndClassWithSimilarNamesNotRemovedFromDom() throws CoreException {
        this.target.startSynchronizing();
        IPackageFragment modelSync = this.testPrj1.createPackage("com.sap.test.modelsync5");
        ICompilationUnit wsCU = this.testPrj1.createType(modelSync, "Test.java", "@javax.jws.WebService() public class Test {}").getCompilationUnit();
        JobUtils.waitForJobs();
        ModelSynchronizationTests.assertNotNull((Object)this.domUtil.findWsByImplName(this.wsPrj1, wsCU.findPrimaryType().getFullyQualifiedName()));
        ICompilationUnit seiCU = this.testPrj1.createType(modelSync, "TestSei.java", "@javax.jws.WebService() public interface TestSei {}").getCompilationUnit();
        JobUtils.waitForJobs();
        ModelSynchronizationTests.assertNotNull((Object)this.domUtil.findSeiByImplName(this.wsPrj1, seiCU.findPrimaryType().getFullyQualifiedName()));
        this.testUtil.setContents(wsCU, "@javax.jws.WebService(serviceName=\"TestService\") public class Test {}");
        JobUtils.waitForJobs();
        ModelSynchronizationTests.assertNotNull((Object)this.domUtil.findSeiByImplName(this.wsPrj1, seiCU.findPrimaryType().getFullyQualifiedName()));
        ModelSynchronizationTests.assertNotNull((Object)this.domUtil.findWsByImplName(this.wsPrj1, wsCU.findPrimaryType().getFullyQualifiedName()));
    }

    public void test_WsChangedToUseExplicitSEI() throws CoreException {
        this.target.startSynchronizing();
        IPackageFragment modelSync = this.testPrj1.createPackage("com.sap.test.modelsync4");
        ICompilationUnit wsCU = this.testPrj1.createType(modelSync, "WS4.java", "@javax.jws.WebService() public class WS4 {}").getCompilationUnit();
        JobUtils.waitForJobs();
        IServiceEndpointInterface sei = this.domUtil.findSeiByImplName(this.wsPrj1, wsCU.findPrimaryType().getFullyQualifiedName());
        ModelSynchronizationTests.assertNotNull((Object)sei);
        ModelSynchronizationTests.assertTrue((boolean)sei.isImplicit());
        this.testUtil.setContents(wsCU, "@javax.jws.WebService(endpointInterface=\"com.sap.test.modelsync1.Sei1\") public class WS4 {}");
        JobUtils.waitForJobs();
        sei = this.domUtil.findSeiByImplName(this.wsPrj1, wsCU.findPrimaryType().getFullyQualifiedName());
        ModelSynchronizationTests.assertNull((Object)sei);
    }

    public void test_WsOpenedInWorkingCopyContentChangedReconcileCalled() throws CoreException {
        this.target.startSynchronizing();
        IPackageFragment modelSync = this.testPrj1.createPackage("com.sap.test.modelsync4");
        ICompilationUnit wsCu = this.testPrj1.createType(modelSync, "WS3.java", "@javax.jws.WebService() public class WS3 {}").getCompilationUnit();
        JobUtils.waitForJobs();
        IWebService ws3 = this.domUtil.findWsByImplName(this.wsPrj1, wsCu.findPrimaryType().getFullyQualifiedName());
        ModelSynchronizationTests.assertEquals((int)0, (int)ws3.getServiceEndpoint().getWebMethods().size());
        wsCu.becomeWorkingCopy(null);
        wsCu.getBuffer().setContents("@javax.jws.WebService public class WS3 {public void test() {}}");
        wsCu.reconcile(0, false, null, null);
        JobUtils.waitForJobs();
        ModelSynchronizationTests.assertEquals((int)1, (int)ws3.getServiceEndpoint().getWebMethods().size());
    }

    public void test_WsOpenedInWorkingCopyContentChangedReconcileCalledOnNonJavaCU() throws CoreException {
        this.target.startSynchronizing();
        IPackageFragmentRoot root = this.testPrj1.getJavaProject().getPackageFragmentRoot((IResource)this.testPrj1.getProject());
        IPackageFragment pf = root.getPackageFragment("");
        ICompilationUnit cu = pf.createCompilationUnit("NotWS.java", "@javax.jws.WebService public class NotWS {}", true, null);
        cu.becomeWorkingCopy(null);
        cu.getBuffer().setContents("@javax.jws.WebService(serviceName=\"NewNotWs\") public class NotWS {}");
        cu.reconcile(0, false, null, null);
        JobUtils.waitForJobs();
        for (IWebService ws : this.wsPrj1.getWebServices()) {
            if (!ws.getName().equals("NewNotWs")) continue;
            ModelSynchronizationTests.fail((String)"reconcile on java file which is not on project's build path processed incorrectly");
        }
    }

    private JaxWsWorkspaceResource createTarget() {
        return new JaxWsWorkspaceResource(this.javaModel){

            public boolean approveProject(IJavaProject prj) {
                for (String allowedPrj : ModelSynchronizationTests.this.allowedProjects) {
                    if (!prj.getElementName().equals(allowedPrj)) continue;
                    return true;
                }
                return false;
            }
        };
    }

    private void verifySetUpModelEntitesNotChanged() {
        AdapterImpl adapter = new AdapterImpl(){

            public void notifyChanged(Notification msg) {
                ModelSynchronizationTests.fail((String)"should not be called, because the objects created in the setup should not have been changed during this test");
                super.notifyChanged(msg);
            }
        };
        this.ws1.eAdapters().add((Object)adapter);
        this.sei1.eAdapters().add((Object)adapter);
        this.ws2.eAdapters().add((Object)adapter);
        this.sei2.eAdapters().add((Object)adapter);
    }

    private void delete(final ISourceManipulation source, final boolean force) throws CoreException {
        IWorkspaceRunnable deleteRunable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                source.delete(force, monitor);
            }
        };
        TestProjectsUtils.executeWorkspaceRunnable((IWorkspaceRunnable)deleteRunable);
    }
}

