/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.xpath2.processor.internal.types;

import org.apache.xerces.dom.PSVIElementNSImpl;
import org.apache.xerces.xs.XSComplexTypeDefinition;
import org.apache.xerces.xs.XSSimpleTypeDefinition;
import org.apache.xerces.xs.XSTypeDefinition;
import org.eclipse.wst.xml.xpath2.processor.ResultSequence;
import org.eclipse.wst.xml.xpath2.processor.ResultSequenceFactory;
import org.eclipse.wst.xml.xpath2.processor.internal.types.AnyType;
import org.eclipse.wst.xml.xpath2.processor.internal.types.NodeType;
import org.eclipse.wst.xml.xpath2.processor.internal.types.QName;
import org.eclipse.wst.xml.xpath2.processor.internal.types.XSBoolean;
import org.eclipse.wst.xml.xpath2.processor.internal.types.XSUntypedAtomic;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.w3c.dom.TypeInfo;

public class ElementType
extends NodeType {
    private static final String ELEMENT = "element";
    private Element _value;
    private String _string_value;

    public ElementType() {
        this(null);
    }

    public ElementType(Element v) {
        super(v);
        this._value = v;
        this._string_value = null;
    }

    public ElementType(Element v, int nodePosition) {
        super(v);
        this._value = v;
        this._string_value = null;
    }

    public Element value() {
        return this._value;
    }

    public String string_type() {
        return ELEMENT;
    }

    public String string_value() {
        if (this._string_value != null) {
            return this._string_value;
        }
        this._string_value = ElementType.textnode_strings(this._value);
        return this._string_value;
    }

    public ResultSequence typed_value() {
        ResultSequence rs = ResultSequenceFactory.create_new();
        if (!(this._value instanceof PSVIElementNSImpl)) {
            rs.add(new XSUntypedAtomic(this.string_value()));
            return rs;
        }
        PSVIElementNSImpl typeInfo = (PSVIElementNSImpl)this._value;
        XSTypeDefinition typeDef = typeInfo.getTypeDefinition();
        if (typeDef != null) {
            XSSimpleTypeDefinition simpType = null;
            if (typeDef instanceof XSComplexTypeDefinition) {
                XSComplexTypeDefinition complexTypeDefinition = (XSComplexTypeDefinition)typeDef;
                simpType = complexTypeDefinition.getSimpleType();
            } else {
                simpType = (XSSimpleTypeDefinition)typeDef;
            }
            Object schemaTypeValue = this.getTypedValueForPrimitiveType((XSTypeDefinition)simpType);
            if (schemaTypeValue != null) {
                rs.add((AnyType)schemaTypeValue);
            } else {
                rs.add(new XSUntypedAtomic(this.string_value()));
            }
        } else {
            rs.add(new XSUntypedAtomic(this.string_value()));
        }
        return rs;
    }

    public static String textnode_strings(Node node) {
        String result = "";
        if (node.getNodeType() == 3) {
            Text tn = (Text)node;
            result = String.valueOf(result) + tn.getData();
        }
        NodeList nl = node.getChildNodes();
        StringBuffer buf = new StringBuffer(result);
        int i = 0;
        while (i < nl.getLength()) {
            Node n = nl.item(i);
            buf.append(ElementType.textnode_strings(n));
            ++i;
        }
        result = buf.toString();
        return result;
    }

    public QName node_name() {
        QName name = new QName(this._value.getPrefix(), this._value.getLocalName(), this._value.getNamespaceURI());
        return name;
    }

    public ResultSequence nilled() {
        ResultSequence rs = ResultSequenceFactory.create_new();
        if (this._value instanceof PSVIElementNSImpl) {
            PSVIElementNSImpl psviElement = (PSVIElementNSImpl)this._value;
            rs.add(new XSBoolean(psviElement.getNil()));
        } else {
            rs.add(new XSBoolean(false));
        }
        return rs;
    }

    public boolean isID() {
        return this.isElementType("ID");
    }

    public boolean isIDREF() {
        return this.isElementType("IDREF");
    }

    protected boolean isElementType(String typeName) {
        TypeInfo typeInfo = this._value.getSchemaTypeInfo();
        return this.isType(typeInfo, typeName);
    }
}

