/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.dom;

import org.eclipse.core.runtime.Assert;
import org.eclipse.text.edits.TextEditGroup;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.ChildListPropertyDescriptor;
import org.eclipse.wst.jsdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.wst.jsdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.wst.jsdt.core.dom.rewrite.ListRewrite;

public class ReplaceRewrite {
    protected ASTRewrite fRewrite;
    protected ASTNode[] fToReplace;
    protected StructuralPropertyDescriptor fDescriptor;

    public static ReplaceRewrite create(ASTRewrite rewrite, ASTNode[] nodes) {
        return new ReplaceRewrite(rewrite, nodes);
    }

    protected ReplaceRewrite(ASTRewrite rewrite, ASTNode[] nodes) {
        Assert.isNotNull((Object)rewrite);
        Assert.isNotNull((Object)nodes);
        Assert.isTrue((nodes.length > 0 ? 1 : 0) != 0);
        this.fRewrite = rewrite;
        this.fToReplace = nodes;
        this.fDescriptor = this.fToReplace[0].getLocationInParent();
        if (nodes.length > 1) {
            Assert.isTrue((boolean)(this.fDescriptor instanceof ChildListPropertyDescriptor));
        }
    }

    public void replace(ASTNode[] replacements, TextEditGroup description) {
        if (this.fToReplace.length == 1) {
            if (replacements.length == 1) {
                this.handleOneOne(replacements, description);
            } else {
                this.handleOneMany(replacements, description);
            }
        } else {
            this.handleManyMany(replacements, description);
        }
    }

    protected void handleOneOne(ASTNode[] replacements, TextEditGroup description) {
        this.fRewrite.replace(this.fToReplace[0], replacements[0], description);
    }

    protected void handleOneMany(ASTNode[] replacements, TextEditGroup description) {
        this.handleManyMany(replacements, description);
    }

    protected void handleManyMany(ASTNode[] replacements, TextEditGroup description) {
        block6: {
            ListRewrite container;
            block7: {
                block5: {
                    container = this.fRewrite.getListRewrite(this.fToReplace[0].getParent(), (ChildListPropertyDescriptor)this.fDescriptor);
                    if (this.fToReplace.length != replacements.length) break block5;
                    int i = 0;
                    while (i < this.fToReplace.length) {
                        container.replace(this.fToReplace[i], replacements[i], description);
                        ++i;
                    }
                    break block6;
                }
                if (this.fToReplace.length >= replacements.length) break block7;
                int i = 0;
                while (i < this.fToReplace.length) {
                    container.replace(this.fToReplace[i], replacements[i], description);
                    ++i;
                }
                i = this.fToReplace.length;
                while (i < replacements.length) {
                    container.insertAfter(replacements[i], replacements[i - 1], description);
                    ++i;
                }
                break block6;
            }
            if (this.fToReplace.length <= replacements.length) break block6;
            int delta = this.fToReplace.length - replacements.length;
            int i = 0;
            while (i < delta) {
                container.remove(this.fToReplace[i], description);
                ++i;
            }
            i = delta;
            int r = 0;
            while (i < this.fToReplace.length) {
                container.replace(this.fToReplace[i], replacements[r], description);
                ++i;
                ++r;
            }
        }
    }
}

