/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core.tests.compiler.parser;

import java.util.Hashtable;
import java.util.Map;
import org.eclipse.wst.jsdt.core.tests.compiler.regression.AbstractRegressionTest;

public class ParserTest
extends AbstractRegressionTest {
    public ParserTest(String name) {
        super(name);
    }

    public void test001() {
        this.runNegativeTest(new String[]{"X.js", "\tfunction foo(){\n\t\tthrows\n}\n"}, "----------\n1. ERROR in X.js (at line 2)\n\tthrows\n\t^^^^^^\nSyntax error on token \"throws\", delete this token\n----------\n");
    }

    public void test002() {
        this.runNegativeTest(new String[]{"X.js", "\tfunction foo(){\n\t\tthrows new\n}\n"}, "----------\n1. ERROR in X.js (at line 2)\n\tthrows new\n\t^^^^^^^^^^\nSyntax error on tokens, delete these tokens\n----------\n");
    }

    public void test003() {
        this.runNegativeTest(new String[]{"X.js", "\tfunction foo(){\n\t\tthrows new X\n}\n"}, "----------\n1. ERROR in X.js (at line 2)\n\tthrows new X\n\t^^^^^^\nSyntax error on token \"throws\", throw expected\n----------\n2. ERROR in X.js (at line 2)\n\tthrows new X\n\t           ^\nSyntax error, unexpected end of method\n----------\n");
    }

    public void test006() {
        this.runNegativeTest(new String[]{"X.js", "\t{\n\t\tthrows new X\n}\n"}, "----------\n1. ERROR in X.js (at line 3)\n\tthrows new X\n\t^^^^^^\nSyntax error on token \"throws\", throw expected\n----------\n2. ERROR in X.js (at line 3)\n\tthrows new X\n\t           ^\nSyntax error, unexpected end of initializer\n----------\n");
    }

    public void test009() {
        this.runNegativeTest(new String[]{"X.js", "\tfunction foo(){\n\t\tthrows e\n}\n"}, "----------\n1. ERROR in X.js (at line 2)\n\tthrows e\n\t^^^^^^^^\nSyntax error on tokens, delete these tokens\n----------\n");
    }

    public void test012() {
        Hashtable<String, String> nls = new Hashtable<String, String>();
        nls.put("org.eclipse.wst.jsdt.core.compiler.problem.nonExternalizedStringLiteral", "error");
        this.runNegativeTest(new String[]{"X.js", "\tfunction foo() {\n\t\t\"foo\".equals(\"bar\");\n\t\t;\n}\n"}, "----------\n1. ERROR in X.js (at line 2)\n\t\"foo\".equals(\"bar\");\n\t^^^^^\nNon-externalized string literal; it should be followed by //$NON-NLS-<n>$\n----------\n2. ERROR in X.js (at line 2)\n\t\"foo\".equals(\"bar\");\n\t             ^^^^^\nNon-externalized string literal; it should be followed by //$NON-NLS-<n>$\n----------\n", null, true, nls);
    }

    public void test013() {
        Hashtable<String, String> nls = new Hashtable<String, String>();
        nls.put("org.eclipse.wst.jsdt.core.compiler.problem.nonExternalizedStringLiteral", "error");
        this.runNegativeTest(new String[]{"X.js", "\tfunction foo() {\n\t\t\"foo\".equals(\"bar\");\n\t\t//;\n}\n"}, "----------\n1. ERROR in X.js (at line 2)\n\t\"foo\".equals(\"bar\");\n\t^^^^^\nNon-externalized string literal; it should be followed by //$NON-NLS-<n>$\n----------\n2. ERROR in X.js (at line 2)\n\t\"foo\".equals(\"bar\");\n\t             ^^^^^\nNon-externalized string literal; it should be followed by //$NON-NLS-<n>$\n----------\n", null, true, nls);
    }

    public void _test015() {
        this.runNegativeTest(new String[]{"X.js", "function foo() {\n// some code\n}\n/*\n// some comments\n"}, "----------\n1. ERROR in X.js (at line 4)\n\t/*\n// some comments\n\n\t^^^^^^^^^^^^^^^^^^^^\nUnexpected end of comment\n----------\n");
    }

    public void test016() {
        this.runNegativeTest(new String[]{"X.js", "function foo() {\n\tvar s = \""}, "----------\n1. ERROR in X.js (at line 2)\n\tvar s = \"\n\t           ^\nString literal is not properly closed by a double-quote\n----------\n");
    }

    public void test017() {
        this.runNegativeTest(new String[]{"X.js", "function foo() {\n\tvar c = '"}, "----------\n1. ERROR in X.js (at line 2)\n\tvar c = '\n\t         ^\nInvalid character constant\n----------\n");
    }

    public void test018() {
        this.runNegativeTest(new String[]{"X.js", "function foo() {\n\tvar c = '\\u0"}, "----------\n1. ERROR in X.js (at line 2)\n\tvar c = '\\u0\n\t          ^^^\nInvalid unicode\n----------\n");
    }

    public void test019() {
        this.runNegativeTest(new String[]{"X.js", "\tfunction doit() {\n\t\tvar foo = null;\n\t\tfoo[0] = \n}"}, "----------\n1. ERROR in X.js (at line 3)\n\tfoo[0] = \n\t     ^\nSyntax error, insert \"AssignmentOperator Expression\" to complete Assignment\n----------\n2. ERROR in X.js (at line 3)\n\tfoo[0] = \n\t     ^\nSyntax error, insert \";\" to complete Statement\n----------\n");
    }

    public void test020() {
        this.runNegativeTest(new String[]{"X.js", "\tfunction main( args) {\n\t}\n\tfunction newLibraryEntry() {\n\t\tif (sourceAttachmentPath != null) {\n\t\t\tif (sourceAttachmentPath.isEmpty()) { && !\nsourceAttachmentPath.isAbsolute()) {\n\t\t\tfoo();\n\t\t}\n\t\treturn null;\n\t}\n\t}\n\tfunction foo() {\n\t}\n\tfunction bar() {\n\t}\n"}, "----------\n1. ERROR in X.js (at line 5)\n\tif (sourceAttachmentPath.isEmpty()) { && !\n\t                                      ^^\nSyntax error on token \"&&\", invalid (\n----------\n2. ERROR in X.js (at line 6)\n\tsourceAttachmentPath.isAbsolute()) {\n\t                                   ^\nSyntax error on token \"{\", invalid AssignmentOperator\n----------\n");
    }

    public void test021() {
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < 1000) {
            buffer.append("\tvar field_" + i + " = 0; \n");
            ++i;
        }
        i = 0;
        while (i < 1000) {
            if (i == 0) {
                buffer.append("\tfunction method_" + i + "() { /* default */ } \n");
            } else {
                buffer.append("\tfunction method_" + i + "() { method_" + (i - 1) + "() \n");
            }
            ++i;
        }
        Hashtable<String, String> options = new Hashtable<String, String>();
        options.put("org.eclipse.wst.jsdt.core.compiler.maxProblemPerUnit", "10");
        this.runNegativeTest(new String[]{"X.js", buffer.toString()}, "----------\n1. ERROR in X.js (at line 1002)\n\tvoid method_1() { method_0() \n\t                           ^\nSyntax error, insert \"}\" to complete MethodBody\n----------\n2. ERROR in X.js (at line 1002)\n\tvoid method_1() { method_0() \n\t                           ^\nSyntax error, insert \";\" to complete BlockStatements\n----------\n3. ERROR in X.js (at line 1003)\n\tvoid method_2() { method_1() \n\t                           ^\nSyntax error, insert \"}\" to complete MethodBody\n----------\n4. ERROR in X.js (at line 1003)\n\tvoid method_2() { method_1() \n\t                           ^\nSyntax error, insert \";\" to complete BlockStatements\n----------\n5. ERROR in X.js (at line 1004)\n\tvoid method_3() { method_2() \n\t                           ^\nSyntax error, insert \"}\" to complete MethodBody\n----------\n6. ERROR in X.js (at line 1004)\n\tvoid method_3() { method_2() \n\t                           ^\nSyntax error, insert \";\" to complete BlockStatements\n----------\n7. ERROR in X.js (at line 1005)\n\tvoid method_4() { method_3() \n\t                           ^\nSyntax error, insert \"}\" to complete MethodBody\n----------\n8. ERROR in X.js (at line 1005)\n\tvoid method_4() { method_3() \n\t                           ^\nSyntax error, insert \";\" to complete BlockStatements\n----------\n9. ERROR in X.js (at line 1006)\n\tvoid method_5() { method_4() \n\t                           ^\nSyntax error, insert \"}\" to complete MethodBody\n----------\n10. ERROR in X.js (at line 2001)\n\t}\n\t^\nSyntax error, insert \"}\" to complete ClassBody\n----------\n", null, true, options);
    }

    public void test022() {
        Map options = this.getCompilerOptions();
        options.put("org.eclipse.wst.jsdt.core.compiler.problem.emptyStatement", "error");
        this.runNegativeTest(new String[]{"X.js", "interface X {\n    int f= 1;;\n}"}, "----------\n1. ERROR in X.js (at line 2)\n\tint f= 1;;\n\t         ^\nUnnecessary semicolon\n----------\n", null, true, options);
    }

    public void test023() {
        Map options = this.getCompilerOptions();
        options.put("org.eclipse.wst.jsdt.core.compiler.problem.emptyStatement", "error");
        this.runNegativeTest(new String[]{"X.js", "class X {\n    int f= 1;;\n}"}, "----------\n1. ERROR in X.js (at line 2)\n\tint f= 1;;\n\t         ^\nUnnecessary semicolon\n----------\n", null, true, options);
    }

    public void test024() {
        Map options = this.getCompilerOptions();
        options.put("org.eclipse.wst.jsdt.core.compiler.problem.emptyStatement", "error");
        this.runNegativeTest(new String[]{"X.js", "interface X {\n    int f= 1;\\u003B\n}"}, "----------\n1. ERROR in X.js (at line 2)\n\tint f= 1;\\u003B\n\t         ^^^^^^\nUnnecessary semicolon\n----------\n", null, true, options);
    }

    public void test025() {
        Map options = this.getCompilerOptions();
        options.put("org.eclipse.wst.jsdt.core.compiler.problem.undocumentedEmptyBlock", "error");
        this.runNegativeTest(new String[]{"X.js", "public class X {\n        static class Y {\n                public void foo(int i) {}\n        }\n        static Y FakeInvocationSite = new Y(){\n                public void foo(int i) {}\n        };\n}"}, "----------\n1. ERROR in X.js (at line 3)\n\tpublic void foo(int i) {}\n\t                       ^^\nEmpty block should be documented\n----------\n2. ERROR in X.js (at line 6)\n\tpublic void foo(int i) {}\n\t                       ^^\nEmpty block should be documented\n----------\n", null, true, options);
    }

    public void test026() {
        Map options = this.getCompilerOptions();
        options.put("org.eclipse.wst.jsdt.core.compiler.problem.undocumentedEmptyBlock", "error");
        this.runNegativeTest(new String[]{"X.js", "public class X {\n        static class Y {\n                public void foo(int i) {}\n        }\n        static Y FakeInvocationSite = new Y(){\n                public void foo(int i) {\n\t\t\t\t\tclass A {\n\t\t\t\t\t\tA() {}\n\t\t\t\t\t\tpublic void bar() {}\n\t\t\t\t\t}\n\t\t\t\t\tnew A().bar();\n\t\t\t\t }\n        };\n}"}, "----------\n1. ERROR in X.js (at line 3)\n\tpublic void foo(int i) {}\n\t                       ^^\nEmpty block should be documented\n----------\n2. ERROR in X.js (at line 8)\n\tA() {}\n\t    ^^\nEmpty block should be documented\n----------\n3. ERROR in X.js (at line 9)\n\tpublic void bar() {}\n\t                  ^^\nEmpty block should be documented\n----------\n", null, true, options);
    }
}

