/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.ui;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jst.j2ee.classpathdep.ClasspathDependencyUtil;
import org.eclipse.jst.j2ee.classpathdep.IClasspathDependencyConstants;
import org.eclipse.jst.j2ee.internal.classpathdep.ClasspathDependencyExtensions;
import org.eclipse.jst.j2ee.internal.plugin.J2EEUIPlugin;
import org.eclipse.jst.j2ee.internal.ui.J2EEModuleDependenciesPropertyPage;
import org.eclipse.jst.j2ee.project.JavaEEProjectUtilities;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.wst.common.componentcore.ui.internal.taskwizard.IWizardHandle;
import org.eclipse.wst.common.componentcore.ui.internal.taskwizard.WizardFragment;

public final class AddJavaBuildPathEntriesWizardFragment
extends WizardFragment {
    public static final String PROP_SELECTION = "selection";
    private IWizardHandle wizard;
    private TreeViewer viewer;
    private IJavaProject jproj;

    public AddJavaBuildPathEntriesWizardFragment() {
        this.setComplete(false);
    }

    public boolean hasComposite() {
        return true;
    }

    public Composite createComposite(Composite parent, IWizardHandle handle) {
        this.wizard = handle;
        handle.setTitle(Resources.title);
        handle.setDescription(Resources.description);
        handle.setImageDescriptor(JavaPluginImages.DESC_WIZBAN_ADD_LIBRARY);
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        this.viewer = new TreeViewer(composite, 2050);
        GridData gd = new GridData(1808);
        gd.widthHint = 390;
        gd.heightHint = 185;
        this.viewer.getTree().setLayoutData((Object)gd);
        this.viewer.setContentProvider((IContentProvider)new BuildPathEntriesContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new BuildPathEntriesLabelProvider());
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                AddJavaBuildPathEntriesWizardFragment.this.handleSelectionChanged();
            }
        });
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                AddJavaBuildPathEntriesWizardFragment.this.handleDoubleClick();
            }
        });
        IProject proj = (IProject)this.getTaskModel().getObject("root.project");
        this.jproj = JavaCore.create((IProject)proj);
        this.viewer.setInput(new Object());
        return composite;
    }

    private void handleSelectionChanged() {
        ArrayList<IClasspathEntry> list = new ArrayList<IClasspathEntry>();
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        boolean isWebApp = JavaEEProjectUtilities.isDynamicWebProject((IProject)this.jproj.getProject());
        for (Object obj : selection) {
            if (obj instanceof IClasspathEntry) {
                IClasspathEntry cpeOriginal = (IClasspathEntry)obj;
                IPath runtimePath = ClasspathDependencyUtil.getDefaultRuntimePath((boolean)isWebApp, (boolean)ClasspathDependencyUtil.isClassFolderEntry((IClasspathEntry)cpeOriginal));
                IClasspathEntry cpeTagged = ClasspathDependencyUtil.modifyDependencyPath((IClasspathEntry)cpeOriginal, (IPath)runtimePath);
                list.add(cpeTagged);
                continue;
            }
            list.clear();
            break;
        }
        this.getTaskModel().putObject(PROP_SELECTION, list);
        this.setComplete(!list.isEmpty());
        this.wizard.update();
    }

    private void handleDoubleClick() {
        this.advanceToNextPageOrFinish();
    }

    private IJavaProject getJavaProject() {
        return this.jproj;
    }

    public static String getClasspathEntryText(IJavaProject jproj, IClasspathEntry cpe) {
        int type = cpe.getEntryKind();
        if (type == 5) {
            try {
                IClasspathContainer container = JavaCore.getClasspathContainer((IPath)cpe.getPath(), (IJavaProject)jproj);
                return container.getDescription();
            }
            catch (Exception e) {
                J2EEUIPlugin.logError(e);
            }
        } else if (type == 1) {
            IPath path = cpe.getPath();
            StringBuilder buf = new StringBuilder();
            buf.append(path.lastSegment());
            buf.append(" - ");
            buf.append(path.removeLastSegments(1).toOSString());
            return buf.toString();
        }
        return cpe.getPath().toPortableString();
    }

    public static Image getClasspathEntryImage(IJavaProject jproj, IClasspathEntry cpe) {
        int type = cpe.getEntryKind();
        String imgId = type == 5 ? "org.eclipse.jdt.ui.library_obj.gif" : (type == 1 ? "org.eclipse.jdt.ui.jar_obj.gif" : (type == 4 ? "org.eclipse.jdt.ui.envvar_obj.gif" : null));
        return imgId == null ? null : JavaUI.getSharedImages().getImage(imgId);
    }

    private final class BuildPathEntriesContentProvider
    implements ITreeContentProvider {
        private BuildPathEntriesContentProvider() {
        }

        public Object[] getElements(Object input) {
            ArrayList<IClasspathEntry> elements = new ArrayList<IClasspathEntry>();
            List filteredContainerIds = ClasspathDependencyExtensions.get().getFilteredClasspathContainerIDs();
            try {
                IClasspathEntry[] iClasspathEntryArray = AddJavaBuildPathEntriesWizardFragment.this.getJavaProject().getRawClasspath();
                int n = iClasspathEntryArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IClasspathEntry cpe = iClasspathEntryArray[n2];
                    int type = cpe.getEntryKind();
                    IPath path = cpe.getPath();
                    boolean relevant = false;
                    if (type == 5) {
                        if (path.segmentCount() > 0 && !filteredContainerIds.contains(path.segment(0))) {
                            relevant = true;
                        }
                    } else if (type == 1 || type == 4) {
                        relevant = true;
                    }
                    if (relevant && ClasspathDependencyUtil.checkForComponentDependencyAttribute((IClasspathEntry)cpe, (IClasspathDependencyConstants.DependencyAttributeType)IClasspathDependencyConstants.DependencyAttributeType.CLASSPATH_COMPONENT_NONDEPENDENCY) != null) {
                        relevant = false;
                    }
                    if (relevant) {
                        boolean found = false;
                        for (Object directive : (List)AddJavaBuildPathEntriesWizardFragment.this.getTaskModel().getObject("all.directives")) {
                            if (!(directive instanceof J2EEModuleDependenciesPropertyPage.ClasspathEntryProxy)) continue;
                            J2EEModuleDependenciesPropertyPage.ClasspathEntryProxy proxy = (J2EEModuleDependenciesPropertyPage.ClasspathEntryProxy)directive;
                            if (type != proxy.entry.getEntryKind() || !path.equals((Object)proxy.entry.getPath())) continue;
                            found = true;
                            break;
                        }
                        if (found) {
                            relevant = false;
                        }
                    }
                    if (relevant) {
                        elements.add(cpe);
                    }
                    ++n2;
                }
            }
            catch (CoreException e) {
                J2EEUIPlugin.logError(e);
            }
            return elements.toArray();
        }

        public boolean hasChildren(Object element) {
            return element instanceof IClasspathEntry && ((IClasspathEntry)element).getEntryKind() == 5;
        }

        public Object[] getChildren(Object parent) {
            IClasspathEntry cpe;
            if (parent instanceof IClasspathEntry && (cpe = (IClasspathEntry)parent).getEntryKind() == 5) {
                ArrayList<ChildClasspathEntry> children = new ArrayList<ChildClasspathEntry>();
                try {
                    IClasspathContainer container = JavaCore.getClasspathContainer((IPath)cpe.getPath(), (IJavaProject)AddJavaBuildPathEntriesWizardFragment.this.getJavaProject());
                    if (container != null) {
                        IClasspathEntry[] iClasspathEntryArray = container.getClasspathEntries();
                        int n = iClasspathEntryArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IClasspathEntry child = iClasspathEntryArray[n2];
                            children.add(new ChildClasspathEntry(cpe, child));
                            ++n2;
                        }
                    }
                }
                catch (Exception e) {
                    J2EEUIPlugin.logError(e);
                }
                return children.toArray();
            }
            return new Object[0];
        }

        public Object getParent(Object element) {
            if (element instanceof ChildClasspathEntry) {
                return ((ChildClasspathEntry)element).parent;
            }
            return null;
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }
    }

    private final class BuildPathEntriesLabelProvider
    extends LabelProvider {
        private BuildPathEntriesLabelProvider() {
        }

        public String getText(Object element) {
            IClasspathEntry cpe = element instanceof IClasspathEntry ? (IClasspathEntry)element : ((ChildClasspathEntry)element).entry;
            return AddJavaBuildPathEntriesWizardFragment.getClasspathEntryText(AddJavaBuildPathEntriesWizardFragment.this.getJavaProject(), cpe);
        }

        public Image getImage(Object element) {
            IClasspathEntry cpe = element instanceof IClasspathEntry ? (IClasspathEntry)element : ((ChildClasspathEntry)element).entry;
            return AddJavaBuildPathEntriesWizardFragment.getClasspathEntryImage(AddJavaBuildPathEntriesWizardFragment.this.getJavaProject(), cpe);
        }
    }

    private static final class ChildClasspathEntry {
        public final IClasspathEntry parent;
        public final IClasspathEntry entry;

        public ChildClasspathEntry(IClasspathEntry parent, IClasspathEntry entry) {
            this.parent = parent;
            this.entry = entry;
        }
    }

    public static final class Resources
    extends NLS {
        public static String title;
        public static String description;

        static {
            Resources.initializeMessages((String)AddJavaBuildPathEntriesWizardFragment.class.getName(), Resources.class);
        }
    }
}

