/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.eclipselink.core.internal.context.java;

import java.util.List;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.core.context.JpaContextNode;
import org.eclipse.jpt.core.context.PersistentType;
import org.eclipse.jpt.core.context.java.JavaTypeMapping;
import org.eclipse.jpt.core.internal.context.java.AbstractJavaJpaContextNode;
import org.eclipse.jpt.core.internal.jpa2.context.java.NullJavaCacheable2_0;
import org.eclipse.jpt.core.jpa2.JpaFactory2_0;
import org.eclipse.jpt.core.jpa2.context.CacheableHolder2_0;
import org.eclipse.jpt.core.jpa2.context.java.JavaCacheable2_0;
import org.eclipse.jpt.core.jpa2.context.java.JavaCacheableHolder2_0;
import org.eclipse.jpt.core.jpa2.context.persistence.PersistenceUnit2_0;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentType;
import org.eclipse.jpt.core.utility.TextRange;
import org.eclipse.jpt.eclipselink.core.context.EclipseLinkCacheCoordinationType;
import org.eclipse.jpt.eclipselink.core.context.EclipseLinkCacheType;
import org.eclipse.jpt.eclipselink.core.context.EclipseLinkExistenceType;
import org.eclipse.jpt.eclipselink.core.context.EclipseLinkExpiryTimeOfDay;
import org.eclipse.jpt.eclipselink.core.context.java.JavaEclipseLinkCaching;
import org.eclipse.jpt.eclipselink.core.internal.DefaultEclipseLinkJpaValidationMessages;
import org.eclipse.jpt.eclipselink.core.internal.context.java.JavaEclipseLinkExpiryTimeOfDay;
import org.eclipse.jpt.eclipselink.core.resource.java.EclipseLinkCacheAnnotation;
import org.eclipse.jpt.eclipselink.core.resource.java.EclipseLinkExistenceCheckingAnnotation;
import org.eclipse.jpt.eclipselink.core.resource.java.EclipseLinkTimeOfDayAnnotation;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaEclipseLinkCachingImpl
extends AbstractJavaJpaContextNode
implements JavaEclipseLinkCaching,
JavaCacheableHolder2_0 {
    protected EclipseLinkCacheType specifiedType;
    protected Integer specifiedSize;
    protected Boolean specifiedShared;
    protected Boolean specifiedAlwaysRefresh;
    protected Boolean specifiedRefreshOnlyIfNewer;
    protected Boolean specifiedDisableHits;
    protected boolean existenceChecking;
    protected EclipseLinkExistenceType specifiedExistenceType;
    protected EclipseLinkExistenceType defaultExistenceType;
    protected EclipseLinkCacheCoordinationType specifiedCoordinationType;
    protected Integer expiry;
    protected JavaEclipseLinkExpiryTimeOfDay expiryTimeOfDay;
    protected final JavaCacheable2_0 cacheable = this.buildCacheable();
    protected JavaResourcePersistentType resourcePersistentType;

    public JavaEclipseLinkCachingImpl(JavaTypeMapping parent) {
        super((JpaContextNode)parent);
    }

    public JavaTypeMapping getParent() {
        return (JavaTypeMapping)super.getParent();
    }

    protected EclipseLinkCacheAnnotation getCacheAnnotation() {
        return (EclipseLinkCacheAnnotation)this.resourcePersistentType.getNonNullAnnotation(this.getCacheAnnotationName());
    }

    protected EclipseLinkExistenceCheckingAnnotation getExistenceCheckingAnnotation() {
        return (EclipseLinkExistenceCheckingAnnotation)this.resourcePersistentType.getAnnotation(this.getExistenceCheckingAnnotationName());
    }

    protected String getCacheAnnotationName() {
        return "org.eclipse.persistence.annotations.Cache";
    }

    protected String getExistenceCheckingAnnotationName() {
        return "org.eclipse.persistence.annotations.ExistenceChecking";
    }

    @Override
    public EclipseLinkCacheType getType() {
        return this.getSpecifiedType() == null ? this.getDefaultType() : this.getSpecifiedType();
    }

    @Override
    public EclipseLinkCacheType getDefaultType() {
        return DEFAULT_TYPE;
    }

    @Override
    public EclipseLinkCacheType getSpecifiedType() {
        return this.specifiedType;
    }

    @Override
    public void setSpecifiedType(EclipseLinkCacheType newSpecifiedType) {
        EclipseLinkCacheType oldSpecifiedType = this.specifiedType;
        this.specifiedType = newSpecifiedType;
        this.getCacheAnnotation().setType(EclipseLinkCacheType.toJavaResourceModel(newSpecifiedType));
        this.firePropertyChanged("specifiedType", (Object)oldSpecifiedType, (Object)newSpecifiedType);
    }

    protected void setSpecifiedType_(EclipseLinkCacheType newSpecifiedType) {
        EclipseLinkCacheType oldSpecifiedType = this.specifiedType;
        this.specifiedType = newSpecifiedType;
        this.firePropertyChanged("specifiedType", (Object)oldSpecifiedType, (Object)newSpecifiedType);
    }

    @Override
    public int getSize() {
        return this.getSpecifiedSize() == null ? this.getDefaultSize() : this.getSpecifiedSize().intValue();
    }

    @Override
    public int getDefaultSize() {
        return 100;
    }

    @Override
    public Integer getSpecifiedSize() {
        return this.specifiedSize;
    }

    @Override
    public void setSpecifiedSize(Integer newSpecifiedSize) {
        Integer oldSpecifiedSize = this.specifiedSize;
        this.specifiedSize = newSpecifiedSize;
        this.getCacheAnnotation().setSize(newSpecifiedSize);
        this.firePropertyChanged("specifiedSize", oldSpecifiedSize, newSpecifiedSize);
    }

    protected void setSpecifiedSize_(Integer newSpecifiedSize) {
        Integer oldSpecifiedSize = this.specifiedSize;
        this.specifiedSize = newSpecifiedSize;
        this.firePropertyChanged("specifiedSize", oldSpecifiedSize, newSpecifiedSize);
    }

    @Override
    public boolean isShared() {
        return this.specifiedShared == null ? this.isDefaultShared() : this.specifiedShared.booleanValue();
    }

    @Override
    public boolean isDefaultShared() {
        return true;
    }

    @Override
    public Boolean getSpecifiedShared() {
        return this.specifiedShared;
    }

    @Override
    public void setSpecifiedShared(Boolean newSpecifiedShared) {
        Boolean oldShared = this.specifiedShared;
        this.specifiedShared = newSpecifiedShared;
        this.getCacheAnnotation().setShared(newSpecifiedShared);
        this.firePropertyChanged("specifiedShared", oldShared, newSpecifiedShared);
        if (newSpecifiedShared == Boolean.FALSE) {
            this.setSpecifiedType(null);
            this.setSpecifiedSize(null);
            this.setSpecifiedAlwaysRefresh(null);
            this.setSpecifiedRefreshOnlyIfNewer(null);
            this.setSpecifiedDisableHits(null);
            this.setSpecifiedCoordinationType(null);
            this.setExpiry(null);
            if (this.expiryTimeOfDay != null) {
                this.removeExpiryTimeOfDay();
            }
        }
    }

    protected void setSpecifiedShared_(Boolean newSpecifiedShared) {
        Boolean oldSpecifiedShared = this.specifiedShared;
        this.specifiedShared = newSpecifiedShared;
        this.firePropertyChanged("specifiedShared", oldSpecifiedShared, newSpecifiedShared);
    }

    @Override
    public boolean isAlwaysRefresh() {
        return this.specifiedAlwaysRefresh == null ? this.isDefaultAlwaysRefresh() : this.specifiedAlwaysRefresh.booleanValue();
    }

    @Override
    public boolean isDefaultAlwaysRefresh() {
        return false;
    }

    @Override
    public Boolean getSpecifiedAlwaysRefresh() {
        return this.specifiedAlwaysRefresh;
    }

    @Override
    public void setSpecifiedAlwaysRefresh(Boolean newSpecifiedAlwaysRefresh) {
        Boolean oldAlwaysRefresh = this.specifiedAlwaysRefresh;
        this.specifiedAlwaysRefresh = newSpecifiedAlwaysRefresh;
        this.getCacheAnnotation().setAlwaysRefresh(newSpecifiedAlwaysRefresh);
        this.firePropertyChanged("specifiedAlwaysRefresh", oldAlwaysRefresh, newSpecifiedAlwaysRefresh);
    }

    protected void setSpecifiedAlwaysRefresh_(Boolean newSpecifiedAlwaysRefresh) {
        Boolean oldAlwaysRefresh = this.specifiedAlwaysRefresh;
        this.specifiedAlwaysRefresh = newSpecifiedAlwaysRefresh;
        this.firePropertyChanged("specifiedAlwaysRefresh", oldAlwaysRefresh, newSpecifiedAlwaysRefresh);
    }

    @Override
    public boolean isRefreshOnlyIfNewer() {
        return this.specifiedRefreshOnlyIfNewer == null ? this.isDefaultRefreshOnlyIfNewer() : this.specifiedRefreshOnlyIfNewer.booleanValue();
    }

    @Override
    public boolean isDefaultRefreshOnlyIfNewer() {
        return false;
    }

    @Override
    public Boolean getSpecifiedRefreshOnlyIfNewer() {
        return this.specifiedRefreshOnlyIfNewer;
    }

    @Override
    public void setSpecifiedRefreshOnlyIfNewer(Boolean newSpecifiedRefreshOnlyIfNewer) {
        Boolean oldRefreshOnlyIfNewer = this.specifiedRefreshOnlyIfNewer;
        this.specifiedRefreshOnlyIfNewer = newSpecifiedRefreshOnlyIfNewer;
        this.getCacheAnnotation().setRefreshOnlyIfNewer(newSpecifiedRefreshOnlyIfNewer);
        this.firePropertyChanged("specifiedRefreshOnlyIfNewer", oldRefreshOnlyIfNewer, newSpecifiedRefreshOnlyIfNewer);
    }

    protected void setSpecifiedRefreshOnlyIfNewer_(Boolean newSpecifiedRefreshOnlyIfNewer) {
        Boolean oldRefreshOnlyIfNewer = this.specifiedRefreshOnlyIfNewer;
        this.specifiedRefreshOnlyIfNewer = newSpecifiedRefreshOnlyIfNewer;
        this.firePropertyChanged("specifiedRefreshOnlyIfNewer", oldRefreshOnlyIfNewer, newSpecifiedRefreshOnlyIfNewer);
    }

    @Override
    public boolean isDisableHits() {
        return this.specifiedDisableHits == null ? this.isDefaultDisableHits() : this.specifiedDisableHits.booleanValue();
    }

    @Override
    public boolean isDefaultDisableHits() {
        return false;
    }

    @Override
    public Boolean getSpecifiedDisableHits() {
        return this.specifiedDisableHits;
    }

    @Override
    public void setSpecifiedDisableHits(Boolean newSpecifiedDisableHits) {
        Boolean oldDisableHits = this.specifiedDisableHits;
        this.specifiedDisableHits = newSpecifiedDisableHits;
        this.getCacheAnnotation().setDisableHits(newSpecifiedDisableHits);
        this.firePropertyChanged("specifiedDisableHits", oldDisableHits, newSpecifiedDisableHits);
    }

    protected void setSpecifiedDisableHits_(Boolean newSpecifiedDisableHits) {
        Boolean oldDisableHits = this.specifiedDisableHits;
        this.specifiedDisableHits = newSpecifiedDisableHits;
        this.firePropertyChanged("specifiedDisableHits", oldDisableHits, newSpecifiedDisableHits);
    }

    @Override
    public EclipseLinkCacheCoordinationType getCoordinationType() {
        return this.getSpecifiedCoordinationType() == null ? this.getDefaultCoordinationType() : this.getSpecifiedCoordinationType();
    }

    @Override
    public EclipseLinkCacheCoordinationType getDefaultCoordinationType() {
        return DEFAULT_COORDINATION_TYPE;
    }

    @Override
    public EclipseLinkCacheCoordinationType getSpecifiedCoordinationType() {
        return this.specifiedCoordinationType;
    }

    @Override
    public void setSpecifiedCoordinationType(EclipseLinkCacheCoordinationType newSpecifiedCoordinationType) {
        EclipseLinkCacheCoordinationType oldSpecifiedCoordinationType = this.specifiedCoordinationType;
        this.specifiedCoordinationType = newSpecifiedCoordinationType;
        this.getCacheAnnotation().setCoordinationType(EclipseLinkCacheCoordinationType.toJavaResourceModel(newSpecifiedCoordinationType));
        this.firePropertyChanged("specifiedCoordinationType", (Object)oldSpecifiedCoordinationType, (Object)newSpecifiedCoordinationType);
    }

    protected void setSpecifiedCoordinationType_(EclipseLinkCacheCoordinationType newSpecifiedCoordinationType) {
        EclipseLinkCacheCoordinationType oldSpecifiedCoordinationType = this.specifiedCoordinationType;
        this.specifiedCoordinationType = newSpecifiedCoordinationType;
        this.firePropertyChanged("specifiedCoordinationType", (Object)oldSpecifiedCoordinationType, (Object)newSpecifiedCoordinationType);
    }

    @Override
    public boolean hasExistenceChecking() {
        return this.existenceChecking;
    }

    @Override
    public void setExistenceChecking(boolean newExistenceChecking) {
        boolean oldExistenceChecking = this.existenceChecking;
        this.existenceChecking = newExistenceChecking;
        if (newExistenceChecking) {
            this.resourcePersistentType.addAnnotation(this.getExistenceCheckingAnnotationName());
        } else {
            this.resourcePersistentType.removeAnnotation(this.getExistenceCheckingAnnotationName());
        }
        this.firePropertyChanged("existenceChecking", oldExistenceChecking, newExistenceChecking);
        this.setDefaultExistenceType(this.caclulateDefaultExistenceType());
    }

    protected void setExistenceChecking_(boolean newExistenceChecking) {
        boolean oldExistenceChecking = this.existenceChecking;
        this.existenceChecking = newExistenceChecking;
        this.firePropertyChanged("existenceChecking", oldExistenceChecking, newExistenceChecking);
    }

    protected EclipseLinkExistenceType caclulateDefaultExistenceType() {
        if (this.hasExistenceChecking()) {
            return EclipseLinkExistenceType.CHECK_CACHE;
        }
        return DEFAULT_EXISTENCE_TYPE;
    }

    @Override
    public EclipseLinkExistenceType getExistenceType() {
        return this.getSpecifiedExistenceType() == null ? this.getDefaultExistenceType() : this.getSpecifiedExistenceType();
    }

    @Override
    public EclipseLinkExistenceType getDefaultExistenceType() {
        return this.defaultExistenceType;
    }

    protected void setDefaultExistenceType(EclipseLinkExistenceType newDefaultExistenceType) {
        EclipseLinkExistenceType oldDefaultExistenceType = this.defaultExistenceType;
        this.defaultExistenceType = newDefaultExistenceType;
        this.firePropertyChanged("defaultExistenceType", (Object)oldDefaultExistenceType, (Object)newDefaultExistenceType);
    }

    @Override
    public EclipseLinkExistenceType getSpecifiedExistenceType() {
        return this.specifiedExistenceType;
    }

    @Override
    public void setSpecifiedExistenceType(EclipseLinkExistenceType newSpecifiedExistenceType) {
        if (!this.hasExistenceChecking()) {
            if (newSpecifiedExistenceType != null) {
                this.setExistenceChecking(true);
            } else {
                return;
            }
        }
        EclipseLinkExistenceType oldSpecifiedExistenceType = this.specifiedExistenceType;
        this.specifiedExistenceType = newSpecifiedExistenceType;
        this.getExistenceCheckingAnnotation().setValue(EclipseLinkExistenceType.toJavaResourceModel(newSpecifiedExistenceType));
        this.firePropertyChanged("specifiedExistenceType", (Object)oldSpecifiedExistenceType, (Object)newSpecifiedExistenceType);
    }

    protected void setSpecifiedExistenceType_(EclipseLinkExistenceType newSpecifiedExistenceType) {
        EclipseLinkExistenceType oldSpecifiedExistenceType = this.specifiedExistenceType;
        this.specifiedExistenceType = newSpecifiedExistenceType;
        this.firePropertyChanged("specifiedExistenceType", (Object)oldSpecifiedExistenceType, (Object)newSpecifiedExistenceType);
    }

    @Override
    public Integer getExpiry() {
        return this.expiry;
    }

    @Override
    public void setExpiry(Integer newExpiry) {
        Integer oldExpiry = this.expiry;
        this.expiry = newExpiry;
        this.getCacheAnnotation().setExpiry(newExpiry);
        this.firePropertyChanged("expiry", oldExpiry, newExpiry);
        if (newExpiry != null && this.expiryTimeOfDay != null) {
            this.removeExpiryTimeOfDay();
        }
    }

    protected void setExpiry_(Integer newExpiry) {
        Integer oldExpiry = this.expiry;
        this.expiry = newExpiry;
        this.firePropertyChanged("expiry", oldExpiry, newExpiry);
    }

    @Override
    public EclipseLinkExpiryTimeOfDay getExpiryTimeOfDay() {
        return this.expiryTimeOfDay;
    }

    @Override
    public EclipseLinkExpiryTimeOfDay addExpiryTimeOfDay() {
        JavaEclipseLinkExpiryTimeOfDay newExpiryTimeOfDay;
        if (this.expiryTimeOfDay != null) {
            throw new IllegalStateException("expiryTimeOfDay already exists, use getExpiryTimeOfDay()");
        }
        if (this.resourcePersistentType.getAnnotation(this.getCacheAnnotationName()) == null) {
            this.resourcePersistentType.addAnnotation(this.getCacheAnnotationName());
        }
        this.expiryTimeOfDay = newExpiryTimeOfDay = new JavaEclipseLinkExpiryTimeOfDay(this);
        EclipseLinkTimeOfDayAnnotation timeOfDayAnnotation = this.getCacheAnnotation().addExpiryTimeOfDay();
        newExpiryTimeOfDay.initialize(timeOfDayAnnotation);
        this.firePropertyChanged("expiryTimeOfDay", null, newExpiryTimeOfDay);
        this.setExpiry(null);
        return newExpiryTimeOfDay;
    }

    @Override
    public void removeExpiryTimeOfDay() {
        if (this.expiryTimeOfDay == null) {
            throw new IllegalStateException("timeOfDayExpiry does not exist");
        }
        JavaEclipseLinkExpiryTimeOfDay oldExpiryTimeOfDay = this.expiryTimeOfDay;
        this.expiryTimeOfDay = null;
        this.getCacheAnnotation().removeExpiryTimeOfDay();
        this.firePropertyChanged("expiryTimeOfDay", oldExpiryTimeOfDay, null);
    }

    protected void setExpiryTimeOfDay(JavaEclipseLinkExpiryTimeOfDay newExpiryTimeOfDay) {
        JavaEclipseLinkExpiryTimeOfDay oldExpiryTimeOfDay = this.expiryTimeOfDay;
        this.expiryTimeOfDay = newExpiryTimeOfDay;
        this.firePropertyChanged("expiryTimeOfDay", oldExpiryTimeOfDay, newExpiryTimeOfDay);
    }

    protected JavaCacheable2_0 buildCacheable() {
        return this.isJpa2_0Compatible() ? ((JpaFactory2_0)this.getJpaFactory()).buildJavaCacheable((JavaCacheableHolder2_0)this) : new NullJavaCacheable2_0((JavaCacheableHolder2_0)this);
    }

    public JavaCacheable2_0 getCacheable() {
        return this.cacheable;
    }

    public boolean calculateDefaultCacheable() {
        CacheableHolder2_0 cacheableHolder = this.getCacheableSuperPersistentType((PersistentType)this.getParent().getPersistentType());
        if (cacheableHolder != null) {
            return cacheableHolder.getCacheable().isCacheable();
        }
        return ((PersistenceUnit2_0)this.getPersistenceUnit()).calculateDefaultCacheable();
    }

    protected CacheableHolder2_0 getCacheableSuperPersistentType(PersistentType persistentType) {
        PersistentType superPersistentType = persistentType.getSuperPersistentType();
        if (superPersistentType != null) {
            if (superPersistentType.getMapping() instanceof CacheableHolder2_0) {
                return (CacheableHolder2_0)superPersistentType.getMapping();
            }
            return this.getCacheableSuperPersistentType(superPersistentType);
        }
        return null;
    }

    @Override
    public void initialize(JavaResourcePersistentType resourcePersistentType) {
        this.resourcePersistentType = resourcePersistentType;
        this.initialize(this.getCacheAnnotation());
        this.initialize(this.getExistenceCheckingAnnotation());
        this.cacheable.initialize(resourcePersistentType);
    }

    protected void initialize(EclipseLinkCacheAnnotation cache) {
        this.specifiedType = this.specifiedType(cache);
        this.specifiedSize = this.specifiedSize(cache);
        this.specifiedShared = this.specifiedShared(cache);
        this.specifiedAlwaysRefresh = this.specifiedAlwaysRefresh(cache);
        this.specifiedRefreshOnlyIfNewer = this.specifiedRefreshOnlyIfNewer(cache);
        this.specifiedDisableHits = this.specifiedDisableHits(cache);
        this.specifiedCoordinationType = this.specifiedCoordinationType(cache);
        this.initializeExpiry(cache);
    }

    protected void initialize(EclipseLinkExistenceCheckingAnnotation existenceChecking) {
        this.existenceChecking = existenceChecking != null;
        this.specifiedExistenceType = this.specifiedExistenceType(existenceChecking);
        this.defaultExistenceType = this.caclulateDefaultExistenceType();
    }

    protected void initializeExpiry(EclipseLinkCacheAnnotation cache) {
        if (cache.getExpiryTimeOfDay() == null) {
            this.expiry = cache.getExpiry();
        } else if (cache.getExpiry() == null) {
            this.expiryTimeOfDay = new JavaEclipseLinkExpiryTimeOfDay(this);
            this.expiryTimeOfDay.initialize(cache.getExpiryTimeOfDay());
        }
    }

    @Override
    public void update(JavaResourcePersistentType resourcePersistentType) {
        this.resourcePersistentType = resourcePersistentType;
        this.update(this.getCacheAnnotation());
        this.update(this.getExistenceCheckingAnnotation());
        this.updateExpiry(this.getCacheAnnotation());
        this.cacheable.update(resourcePersistentType);
    }

    protected void update(EclipseLinkCacheAnnotation cache) {
        this.setSpecifiedType_(this.specifiedType(cache));
        this.setSpecifiedSize_(this.specifiedSize(cache));
        this.setSpecifiedShared_(this.specifiedShared(cache));
        this.setSpecifiedAlwaysRefresh_(this.specifiedAlwaysRefresh(cache));
        this.setSpecifiedRefreshOnlyIfNewer_(this.specifiedRefreshOnlyIfNewer(cache));
        this.setSpecifiedDisableHits_(this.specifiedDisableHits(cache));
        this.setSpecifiedCoordinationType_(this.specifiedCoordinationType(cache));
    }

    protected void update(EclipseLinkExistenceCheckingAnnotation existenceChecking) {
        this.setExistenceChecking_(existenceChecking != null);
        this.setSpecifiedExistenceType_(this.specifiedExistenceType(existenceChecking));
        this.setDefaultExistenceType(this.caclulateDefaultExistenceType());
    }

    protected void updateExpiry(EclipseLinkCacheAnnotation cache) {
        if (cache.getExpiryTimeOfDay() == null) {
            this.setExpiryTimeOfDay(null);
            this.setExpiry_(cache.getExpiry());
        } else if (this.expiryTimeOfDay != null) {
            this.expiryTimeOfDay.update(cache.getExpiryTimeOfDay());
        } else if (cache.getExpiry() == null) {
            this.setExpiryTimeOfDay(new JavaEclipseLinkExpiryTimeOfDay(this));
            this.expiryTimeOfDay.initialize(cache.getExpiryTimeOfDay());
        } else {
            this.setExpiryTimeOfDay(null);
        }
    }

    protected EclipseLinkCacheType specifiedType(EclipseLinkCacheAnnotation cache) {
        return EclipseLinkCacheType.fromJavaResourceModel(cache.getType());
    }

    protected Integer specifiedSize(EclipseLinkCacheAnnotation cache) {
        return cache.getSize();
    }

    protected Boolean specifiedShared(EclipseLinkCacheAnnotation cache) {
        return cache.getShared();
    }

    protected Boolean specifiedAlwaysRefresh(EclipseLinkCacheAnnotation cache) {
        return cache.getAlwaysRefresh();
    }

    protected Boolean specifiedRefreshOnlyIfNewer(EclipseLinkCacheAnnotation cache) {
        return cache.getRefreshOnlyIfNewer();
    }

    protected Boolean specifiedDisableHits(EclipseLinkCacheAnnotation cache) {
        return cache.getDisableHits();
    }

    protected EclipseLinkCacheCoordinationType specifiedCoordinationType(EclipseLinkCacheAnnotation cache) {
        return EclipseLinkCacheCoordinationType.fromJavaResourceModel(cache.getCoordinationType());
    }

    protected Integer expiry(EclipseLinkCacheAnnotation cache) {
        return cache.getExpiry();
    }

    protected EclipseLinkExistenceType specifiedExistenceType(EclipseLinkExistenceCheckingAnnotation existenceChecking) {
        if (existenceChecking == null) {
            return null;
        }
        return EclipseLinkExistenceType.fromJavaResourceModel(existenceChecking.getValue());
    }

    public TextRange getValidationTextRange(CompilationUnit astRoot) {
        TextRange textRange = this.getCacheAnnotation().getTextRange(astRoot);
        return textRange != null ? textRange : this.getParent().getValidationTextRange(astRoot);
    }

    public void validate(List<IMessage> messages, IReporter reporter, CompilationUnit astRoot) {
        super.validate(messages, reporter, astRoot);
        this.validateExpiry(messages, astRoot);
    }

    protected void validateExpiry(List<IMessage> messages, CompilationUnit astRoot) {
        EclipseLinkCacheAnnotation cache = this.getCacheAnnotation();
        if (cache.getExpiry() != null && cache.getExpiryTimeOfDay() != null) {
            messages.add(DefaultEclipseLinkJpaValidationMessages.buildMessage(1, "CACHE_EXPIRY_AND_EXPIRY_TIME_OF_DAY_BOTH_SPECIFIED", new String[]{this.getParent().getPersistentType().getName()}, this, this.getValidationTextRange(astRoot)));
        }
    }
}

