/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jaxb.ui.internal.wizards.schemagen;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceRuleFactory;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jpt.jaxb.core.internal.SchemaGenerator;
import org.eclipse.jpt.jaxb.ui.JptJaxbUiPlugin;
import org.eclipse.jpt.jaxb.ui.internal.JptJaxbUiMessages;
import org.eclipse.jpt.jaxb.ui.internal.wizards.schemagen.ProjectWizardPage;
import org.eclipse.jpt.jaxb.ui.internal.wizards.schemagen.SchemaGeneratorWizardPage;
import org.eclipse.jpt.utility.internal.ArrayTools;
import org.eclipse.jpt.utility.internal.FileTools;
import org.eclipse.ui.IExportWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SchemaGeneratorWizard
extends Wizard
implements IExportWizard {
    protected IStructuredSelection selection;
    private ProjectWizardPage javaProjectWizardPage;
    protected SchemaGeneratorWizardPage schemaGenWizardPage;
    public static final String XSD_EXTENSION = ".xsd";

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.selection = this.getValidSelection();
        this.setWindowTitle(JptJaxbUiMessages.SchemaGeneratorWizard_title);
        this.setDefaultPageImageDescriptor(JptJaxbUiPlugin.getImageDescriptor("full/wizban/NewXSD"));
        this.setNeedsProgressMonitor(true);
    }

    public void addPages() {
        super.addPages();
        if (this.selection.isEmpty()) {
            this.javaProjectWizardPage = new ProjectWizardPage();
            this.addPage((IWizardPage)this.javaProjectWizardPage);
        }
        this.schemaGenWizardPage = new SchemaGeneratorWizardPage(this.selection);
        this.addPage((IWizardPage)this.schemaGenWizardPage);
    }

    public boolean performFinish() {
        IJavaProject javaProject = this.getJavaProject();
        String[] sourceClassNames = this.buildSourceClassNames(this.getAllCheckedItems());
        GenerateSchemaJob genEntitiesJob = new GenerateSchemaJob(javaProject, sourceClassNames, this.getTargetSchema(), this.usesMoxy());
        genEntitiesJob.schedule();
        return true;
    }

    private String getTargetSchema() {
        String targetSchema = this.schemaGenWizardPage.getSchemaPath();
        if (!FileTools.extension((String)targetSchema).equalsIgnoreCase(XSD_EXTENSION)) {
            targetSchema = String.valueOf(targetSchema) + XSD_EXTENSION;
        }
        return targetSchema;
    }

    private IJavaProject getJavaProject() {
        return this.schemaGenWizardPage.getJavaProject();
    }

    private boolean usesMoxy() {
        return this.schemaGenWizardPage.usesMoxy();
    }

    private Object[] getAllCheckedItems() {
        return this.schemaGenWizardPage.getAllCheckedItems();
    }

    private String[] buildSourceClassNames(Object[] checkedElements) {
        ArrayList<String> classNames = new ArrayList<String>();
        Object[] objectArray = checkedElements;
        int n = checkedElements.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            IJavaElement javaElement = (IJavaElement)element;
            String packageName = javaElement.getParent().getElementName();
            String elementName = javaElement.getElementName();
            String className = FileTools.stripExtension((String)elementName);
            classNames.add(String.valueOf(packageName) + '.' + className);
            ++n2;
        }
        return (String[])ArrayTools.array(classNames, (Object[])new String[0]);
    }

    private IStructuredSelection getValidSelection() {
        ISelection currentSelection = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getSelectionService().getSelection();
        if (currentSelection instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)currentSelection;
            ArrayList<IAdaptable> selectedElements = new ArrayList<IAdaptable>(structuredSelection.size());
            for (Object selectedElement : structuredSelection) {
                if (selectedElement instanceof IProject) {
                    this.addProject(selectedElements, (IProject)selectedElement);
                    continue;
                }
                if (!(selectedElement instanceof IJavaElement)) continue;
                this.addJavaElement(selectedElements, (IJavaElement)selectedElement);
            }
            return new StructuredSelection(selectedElements);
        }
        return StructuredSelection.EMPTY;
    }

    private void addJavaElement(List<IAdaptable> selectedElements, IJavaElement javaElement) {
        if (javaElement.getElementType() == 4 && !SchemaGeneratorWizard.isInArchiveOrExternal(javaElement)) {
            selectedElements.add((IAdaptable)javaElement);
        }
    }

    private void addProject(List<IAdaptable> selectedElements, IProject project) {
        try {
            if (project.hasNature("org.eclipse.jdt.core.javanature")) {
                selectedElements.add((IAdaptable)JavaCore.create((IProject)project));
            }
        }
        catch (CoreException coreException) {}
    }

    private static boolean isInArchiveOrExternal(IJavaElement element) {
        IPackageFragmentRoot root = (IPackageFragmentRoot)element.getAncestor(3);
        return root != null && (root.isArchive() || root.isExternal());
    }

    static class GenerateSchemaJob
    extends WorkspaceJob {
        private final IJavaProject javaProject;
        private final String[] sourceClassNames;
        private final String targetSchema;
        private final boolean useMoxy;

        GenerateSchemaJob(IJavaProject project, String[] sourceClassNames, String targetSchema, boolean useMoxy) {
            super(JptJaxbUiMessages.SchemaGeneratorWizard_generatingSchema);
            this.javaProject = project;
            this.sourceClassNames = sourceClassNames;
            this.targetSchema = targetSchema;
            this.useMoxy = useMoxy;
            IResourceRuleFactory ruleFactory = ResourcesPlugin.getWorkspace().getRuleFactory();
            this.setRule(ruleFactory.modifyRule((IResource)this.javaProject.getProject()));
        }

        public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
            try {
                SchemaGenerator.generate(this.javaProject, this.targetSchema, this.sourceClassNames, this.useMoxy, monitor);
            }
            catch (OperationCanceledException operationCanceledException) {}
            return Status.OK_STATUS;
        }
    }
}

