/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.compiler.ast;

import org.eclipse.wst.jsdt.core.ast.IForStatement;
import org.eclipse.wst.jsdt.internal.compiler.ASTVisitor;
import org.eclipse.wst.jsdt.internal.compiler.ast.Assignment;
import org.eclipse.wst.jsdt.internal.compiler.ast.EmptyStatement;
import org.eclipse.wst.jsdt.internal.compiler.ast.Expression;
import org.eclipse.wst.jsdt.internal.compiler.ast.SingleNameReference;
import org.eclipse.wst.jsdt.internal.compiler.ast.Statement;
import org.eclipse.wst.jsdt.internal.compiler.flow.FlowContext;
import org.eclipse.wst.jsdt.internal.compiler.flow.FlowInfo;
import org.eclipse.wst.jsdt.internal.compiler.flow.LoopingFlowContext;
import org.eclipse.wst.jsdt.internal.compiler.flow.UnconditionalFlowInfo;
import org.eclipse.wst.jsdt.internal.compiler.impl.Constant;
import org.eclipse.wst.jsdt.internal.compiler.lookup.BlockScope;
import org.eclipse.wst.jsdt.internal.compiler.lookup.CompilationUnitScope;
import org.eclipse.wst.jsdt.internal.compiler.lookup.LocalVariableBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.TypeBinding;

public class ForStatement
extends Statement
implements IForStatement {
    public Statement[] initializations;
    public Expression condition;
    public Statement[] increments;
    public Statement action;
    public boolean neededScope;
    public BlockScope scope;
    int preCondInitStateIndex = -1;
    int preIncrementsInitStateIndex = -1;
    int condIfTrueInitStateIndex = -1;
    int mergedInitStateIndex = -1;

    public ForStatement(Statement[] initializations, Expression condition, Statement[] increments, Statement action, boolean neededScope, int s, int e) {
        this.sourceStart = s;
        this.sourceEnd = e;
        this.initializations = initializations;
        this.condition = condition;
        this.increments = increments;
        this.action = action;
        if (action instanceof EmptyStatement) {
            action.bits |= 1;
        }
        this.neededScope = neededScope;
    }

    public FlowInfo analyseCode(BlockScope currentScope, FlowContext flowContext, FlowInfo flowInfo) {
        LoopingFlowContext loopingContext;
        UnconditionalFlowInfo actionInfo;
        boolean isContinue = true;
        if (this.initializations != null) {
            int i = 0;
            int count = this.initializations.length;
            while (i < count) {
                flowInfo = this.initializations[i].analyseCode(this.scope, flowContext, flowInfo);
                ++i;
            }
        }
        Constant cst = this.condition == null ? null : this.condition.constant;
        boolean isConditionTrue = cst == null || cst != Constant.NotAConstant && cst.booleanValue();
        boolean isConditionFalse = cst != null && cst != Constant.NotAConstant && !cst.booleanValue();
        cst = this.condition == null ? null : this.condition.optimizedBooleanConstant();
        boolean isConditionOptimizedTrue = cst == null || cst != Constant.NotAConstant && cst.booleanValue();
        boolean isConditionOptimizedFalse = cst != null && cst != Constant.NotAConstant && !cst.booleanValue();
        LoopingFlowContext condLoopContext = null;
        FlowInfo condInfo = flowInfo.nullInfoLessUnconditionalCopy();
        if (this.condition != null && !isConditionTrue) {
            condLoopContext = new LoopingFlowContext(flowContext, flowInfo, this, this.scope);
            condInfo = this.condition.analyseCode(this.scope, condLoopContext, condInfo);
        }
        if (this.action == null || this.action.isEmptyBlock() && currentScope.compilerOptions().complianceLevel <= 0x2F0000L) {
            if (condLoopContext != null) {
                condLoopContext.complainOnDeferredFinalChecks(this.scope, condInfo);
            }
            if (isConditionTrue) {
                if (condLoopContext != null) {
                    condLoopContext.complainOnDeferredNullChecks(currentScope, condInfo);
                }
                return FlowInfo.DEAD_END;
            }
            if (isConditionFalse) {
                isContinue = false;
            }
            actionInfo = condInfo.initsWhenTrue().unconditionalCopy();
            loopingContext = new LoopingFlowContext(flowContext, flowInfo, this, this.scope);
        } else {
            loopingContext = new LoopingFlowContext(flowContext, flowInfo, this, this.scope);
            FlowInfo initsWhenTrue = condInfo.initsWhenTrue();
            if (isConditionFalse) {
                actionInfo = FlowInfo.DEAD_END;
            } else {
                actionInfo = initsWhenTrue.unconditionalCopy();
                if (isConditionOptimizedFalse) {
                    actionInfo.setReachMode(1);
                }
            }
            if (!this.action.complainIfUnreachable(actionInfo, this.scope, false)) {
                actionInfo = this.action.analyseCode(this.scope, loopingContext, actionInfo).unconditionalInits();
            }
            if ((actionInfo.tagBits & loopingContext.initsOnContinue.tagBits & 1) != 0) {
                isContinue = false;
            } else {
                if (condLoopContext != null) {
                    condLoopContext.complainOnDeferredFinalChecks(this.scope, condInfo);
                }
                actionInfo = actionInfo.mergedWith(loopingContext.initsOnContinue);
                loopingContext.complainOnDeferredFinalChecks(this.scope, actionInfo);
            }
        }
        FlowInfo exitBranch = flowInfo.copy();
        LoopingFlowContext incrementContext = null;
        if (isContinue) {
            if (this.increments != null) {
                incrementContext = new LoopingFlowContext(flowContext, flowInfo, this, this.scope);
                FlowInfo incrementInfo = actionInfo;
                int i = 0;
                int count = this.increments.length;
                while (i < count) {
                    incrementInfo = this.increments[i].analyseCode(this.scope, incrementContext, incrementInfo);
                    ++i;
                }
                actionInfo = ((FlowInfo)incrementInfo).unconditionalInits();
                incrementContext.complainOnDeferredFinalChecks(this.scope, actionInfo);
            }
            exitBranch.addPotentialInitializationsFrom(actionInfo).addInitializationsFrom(condInfo.initsWhenFalse());
        } else {
            exitBranch.addInitializationsFrom(condInfo.initsWhenFalse());
        }
        if (condLoopContext != null) {
            condLoopContext.complainOnDeferredNullChecks(currentScope, actionInfo);
        }
        loopingContext.complainOnDeferredNullChecks(currentScope, actionInfo);
        if (incrementContext != null) {
            incrementContext.complainOnDeferredNullChecks(currentScope, actionInfo);
        }
        UnconditionalFlowInfo mergedInfo = FlowInfo.mergedOptimizedBranches((loopingContext.initsOnBreak.tagBits & 1) != 0 ? loopingContext.initsOnBreak : flowInfo.addInitializationsFrom(loopingContext.initsOnBreak), isConditionOptimizedTrue, exitBranch, isConditionOptimizedFalse, !isConditionTrue);
        return mergedInfo;
    }

    public StringBuffer printStatement(int tab, StringBuffer output) {
        int i;
        ForStatement.printIndent(tab, output).append("for (");
        if (this.initializations != null) {
            i = 0;
            while (i < this.initializations.length) {
                if (i > 0) {
                    output.append(", ");
                }
                this.initializations[i].print(0, output);
                ++i;
            }
        }
        output.append("; ");
        if (this.condition != null) {
            this.condition.printExpression(0, output);
        }
        output.append("; ");
        if (this.increments != null) {
            i = 0;
            while (i < this.increments.length) {
                if (i > 0) {
                    output.append(", ");
                }
                this.increments[i].print(0, output);
                ++i;
            }
        }
        output.append(") ");
        if (this.action == null) {
            output.append(';');
        } else {
            output.append('\n');
            this.action.printStatement(tab + 1, output);
        }
        return output;
    }

    public void resolve(BlockScope upperScope) {
        int length;
        int i;
        BlockScope blockScope = this.scope = this.neededScope ? new BlockScope(upperScope) : upperScope;
        if (this.initializations != null) {
            i = 0;
            length = this.initializations.length;
            while (i < length) {
                LocalVariableBinding bind1;
                Assignment as;
                this.initializations[i].resolve(this.scope);
                if (this.initializations[i] instanceof Assignment && (as = (Assignment)this.initializations[i]).getLeftHandSide() instanceof SingleNameReference && ((bind1 = as.localVariableBinding()) == null || bind1.declaringScope instanceof CompilationUnitScope)) {
                    upperScope.problemReporter().looseVariableDecleration(this, as);
                }
                ++i;
            }
        }
        if (this.condition != null) {
            this.condition.resolveTypeExpecting(this.scope, TypeBinding.BOOLEAN);
        }
        if (this.increments != null) {
            i = 0;
            length = this.increments.length;
            while (i < length) {
                this.increments[i].resolve(this.scope);
                ++i;
            }
        }
        if (this.action != null) {
            this.action.resolve(this.scope);
        }
    }

    public void traverse(ASTVisitor visitor, BlockScope blockScope) {
        BlockScope visitScope;
        BlockScope blockScope2 = visitScope = this.scope != null ? this.scope : blockScope;
        if (visitor.visit(this, blockScope)) {
            int i;
            if (this.initializations != null) {
                int initializationsLength = this.initializations.length;
                i = 0;
                while (i < initializationsLength) {
                    this.initializations[i].traverse(visitor, visitScope);
                    ++i;
                }
            }
            if (this.condition != null) {
                this.condition.traverse(visitor, visitScope);
            }
            if (this.increments != null) {
                int incrementsLength = this.increments.length;
                i = 0;
                while (i < incrementsLength) {
                    this.increments[i].traverse(visitor, visitScope);
                    ++i;
                }
            }
            if (this.action != null) {
                this.action.traverse(visitor, visitScope);
            }
        }
        visitor.endVisit(this, blockScope);
    }

    public int getASTType() {
        return 41;
    }
}

