/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.server.core.internal;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jst.server.core.internal.RuntimeComponentProviderDelegate;
import org.eclipse.jst.server.core.internal.Trace;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntimeComponent;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IRuntimeType;
import org.eclipse.wst.server.core.internal.ServerPlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RuntimeComponentProviderWrapper {
    private IConfigurationElement element;
    private RuntimeComponentProviderDelegate delegate;

    public RuntimeComponentProviderWrapper(IConfigurationElement element) {
        this.element = element;
    }

    protected IConfigurationElement getElement() {
        return this.element;
    }

    public String getId() {
        return this.element.getAttribute("id");
    }

    public String[] getRuntimeTypeIds() {
        try {
            ArrayList<String> list = new ArrayList<String>();
            StringTokenizer st = new StringTokenizer(this.element.getAttribute("runtimeTypeIds"), ",");
            while (st.hasMoreTokens()) {
                String str = st.nextToken();
                if (str == null || str.length() <= 0) continue;
                list.add(str.trim());
            }
            String[] s = new String[list.size()];
            list.toArray(s);
            return s;
        }
        catch (Exception exception) {
            Trace.trace((byte)2, "Could not parse runtime type ids: " + this.element);
            return null;
        }
    }

    public boolean supportsRuntimeType(IRuntimeType runtimeType) {
        if (runtimeType == null) {
            return false;
        }
        String id = runtimeType.getId();
        if (id == null || id.length() == 0) {
            return false;
        }
        String[] s = this.getRuntimeTypeIds();
        if (s == null) {
            return false;
        }
        String[] stringArray = s;
        int n = s.length;
        int n2 = 0;
        while (n2 < n) {
            String ss = stringArray[n2];
            if (ss.endsWith("*") ? id.length() >= ss.length() && id.startsWith(ss.substring(0, ss.length() - 1)) : id.equals(ss)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    protected RuntimeComponentProviderDelegate getDelegate() {
        if (this.delegate == null) {
            try {
                this.delegate = (RuntimeComponentProviderDelegate)((Object)this.element.createExecutableExtension("class"));
            }
            catch (Throwable t) {
                ServerPlugin.logExtensionFailure((String)this.toString(), (Throwable)t);
            }
        }
        return this.delegate;
    }

    public List<IRuntimeComponent> getComponents(IRuntime runtime) {
        if (runtime == null) {
            return null;
        }
        try {
            return this.getDelegate().getRuntimeComponents(runtime);
        }
        catch (Exception e) {
            ServerPlugin.logExtensionFailure((String)this.toString(), (Throwable)e);
            return null;
        }
    }

    public String toString() {
        return "RuntimeComponentProviderWrapper[" + this.getId() + "]";
    }
}

