/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.context.orm;

import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Vector;
import org.eclipse.jpt.core.context.JoinColumn;
import org.eclipse.jpt.core.context.JoinColumnEnabledRelationshipReference;
import org.eclipse.jpt.core.context.JoinColumnJoiningStrategy;
import org.eclipse.jpt.core.context.RelationshipMapping;
import org.eclipse.jpt.core.context.TypeMapping;
import org.eclipse.jpt.core.context.orm.OrmJoinColumn;
import org.eclipse.jpt.core.context.orm.OrmJoinColumnJoiningStrategy;
import org.eclipse.jpt.core.internal.context.orm.AbstractOrmXmlContextNode;
import org.eclipse.jpt.core.resource.orm.OrmFactory;
import org.eclipse.jpt.core.resource.orm.XmlJoinColumn;
import org.eclipse.jpt.core.resource.orm.XmlJoinColumnsMapping;
import org.eclipse.jpt.db.Table;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.jpt.utility.internal.iterators.CloneIterator;
import org.eclipse.jpt.utility.internal.iterators.CloneListIterator;
import org.eclipse.jpt.utility.internal.iterators.EmptyIterator;
import org.eclipse.jpt.utility.internal.iterators.EmptyListIterator;
import org.eclipse.jpt.utility.internal.iterators.SingleElementListIterator;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractOrmJoinColumnJoiningStrategy
extends AbstractOrmXmlContextNode
implements OrmJoinColumnJoiningStrategy {
    protected OrmJoinColumn defaultJoinColumn;
    protected final Vector<OrmJoinColumn> specifiedJoinColumns = new Vector();
    protected final OrmJoinColumn.Owner joinColumnOwner;
    protected XmlJoinColumnsMapping resource;

    protected AbstractOrmJoinColumnJoiningStrategy(JoinColumnEnabledRelationshipReference parent, XmlJoinColumnsMapping resource) {
        super(parent);
        this.resource = resource;
        this.joinColumnOwner = this.buildJoinColumnOwner();
        this.initializeSpecifiedJoinColumns();
        this.initializeDefaultJoinColumn();
    }

    @Override
    public void initializeFrom(JoinColumnJoiningStrategy oldStrategy) {
        for (JoinColumn joinColumn : CollectionTools.iterable(oldStrategy.joinColumns())) {
            OrmJoinColumn newJoinColumn = this.addSpecifiedJoinColumn(this.specifiedJoinColumnsSize());
            newJoinColumn.setSpecifiedName(joinColumn.getName());
            newJoinColumn.setSpecifiedReferencedColumnName(joinColumn.getReferencedColumnName());
        }
    }

    protected abstract OrmJoinColumn.Owner buildJoinColumnOwner();

    protected void initializeSpecifiedJoinColumns() {
        for (XmlJoinColumn resourceJoinColumn : this.resource.getJoinColumns()) {
            this.specifiedJoinColumns.add(this.buildJoinColumn(resourceJoinColumn));
        }
    }

    protected void initializeDefaultJoinColumn() {
        if (this.mayHaveDefaultJoinColumn()) {
            this.defaultJoinColumn = this.buildJoinColumn(null);
        }
    }

    @Override
    public JoinColumnEnabledRelationshipReference getParent() {
        return (JoinColumnEnabledRelationshipReference)super.getParent();
    }

    @Override
    public JoinColumnEnabledRelationshipReference getRelationshipReference() {
        return this.getParent();
    }

    public RelationshipMapping getRelationshipMapping() {
        return this.getRelationshipReference().getRelationshipMapping();
    }

    @Override
    public String getTableName() {
        TypeMapping typeMapping = this.getRelationshipSource();
        return typeMapping == null ? null : this.getRelationshipSource().getPrimaryTableName();
    }

    @Override
    public Table getDbTable(String tableName) {
        TypeMapping typeMapping = this.getRelationshipSource();
        return typeMapping == null ? null : typeMapping.getDbTable(tableName);
    }

    @Override
    public boolean tableNameIsInvalid(String tableName) {
        TypeMapping typeMapping = this.getRelationshipSource();
        return typeMapping == null ? false : typeMapping.tableNameIsInvalid(tableName);
    }

    protected Iterator<String> candidateTableNames() {
        TypeMapping typeMapping = this.getRelationshipSource();
        return typeMapping == null ? EmptyIterator.instance() : typeMapping.associatedTableNamesIncludingInherited();
    }

    @Override
    public void addStrategy() {
        if (this.specifiedJoinColumnsSize() == 0) {
            this.addSpecifiedJoinColumn(0);
        }
    }

    @Override
    public void removeStrategy() {
        for (JoinColumn each : CollectionTools.iterable(this.specifiedJoinColumns())) {
            this.removeSpecifiedJoinColumn(each);
        }
    }

    public Table getReferencedColumnDbTable() {
        TypeMapping relationshipTarget = this.getRelationshipTarget();
        return relationshipTarget == null ? null : relationshipTarget.getPrimaryDbTable();
    }

    @Override
    public ListIterator<OrmJoinColumn> joinColumns() {
        return this.hasSpecifiedJoinColumns() ? this.specifiedJoinColumns() : this.defaultJoinColumns();
    }

    @Override
    public int joinColumnsSize() {
        return this.hasSpecifiedJoinColumns() ? this.specifiedJoinColumnsSize() : this.defaultJoinColumnsSize();
    }

    @Override
    public OrmJoinColumn getDefaultJoinColumn() {
        return this.defaultJoinColumn;
    }

    protected void setDefaultJoinColumn(OrmJoinColumn joinColumn) {
        OrmJoinColumn old = this.defaultJoinColumn;
        this.defaultJoinColumn = joinColumn;
        this.firePropertyChanged("defaultJoinColumn", old, joinColumn);
    }

    protected ListIterator<OrmJoinColumn> defaultJoinColumns() {
        if (this.defaultJoinColumn != null) {
            return new SingleElementListIterator((Object)this.defaultJoinColumn);
        }
        return EmptyListIterator.instance();
    }

    protected int defaultJoinColumnsSize() {
        return this.defaultJoinColumn == null ? 0 : 1;
    }

    @Override
    public ListIterator<OrmJoinColumn> specifiedJoinColumns() {
        return new CloneListIterator(this.specifiedJoinColumns);
    }

    @Override
    public int specifiedJoinColumnsSize() {
        return this.specifiedJoinColumns.size();
    }

    @Override
    public boolean hasSpecifiedJoinColumns() {
        return !this.specifiedJoinColumns.isEmpty();
    }

    @Override
    public OrmJoinColumn addSpecifiedJoinColumn(int index) {
        OrmJoinColumn oldDefaultJoinColumn = this.defaultJoinColumn;
        if (oldDefaultJoinColumn != null) {
            this.defaultJoinColumn = null;
        }
        XmlJoinColumn resourceJoinColumn = OrmFactory.eINSTANCE.createXmlJoinColumn();
        OrmJoinColumn contextJoinColumn = this.buildJoinColumn(resourceJoinColumn);
        this.specifiedJoinColumns.add(index, contextJoinColumn);
        this.resource.getJoinColumns().add(index, (Object)resourceJoinColumn);
        this.fireItemAdded("specifiedJoinColumns", index, contextJoinColumn);
        if (oldDefaultJoinColumn != null) {
            this.firePropertyChanged("defaultJoinColumn", oldDefaultJoinColumn, null);
        }
        return contextJoinColumn;
    }

    protected void addSpecifiedJoinColumn(int index, OrmJoinColumn joinColumn) {
        this.addItemToList(index, joinColumn, this.specifiedJoinColumns, "specifiedJoinColumns");
    }

    protected void addSpecifiedJoinColumn(OrmJoinColumn joinColumn) {
        this.addSpecifiedJoinColumn(this.specifiedJoinColumns.size(), joinColumn);
    }

    @Override
    public void removeSpecifiedJoinColumn(JoinColumn joinColumn) {
        this.removeSpecifiedJoinColumn(this.specifiedJoinColumns.indexOf(joinColumn));
    }

    @Override
    public void removeSpecifiedJoinColumn(int index) {
        OrmJoinColumn removedJoinColumn = this.specifiedJoinColumns.remove(index);
        if (this.specifiedJoinColumns.isEmpty()) {
            this.defaultJoinColumn = this.buildJoinColumn(null);
        }
        this.resource.getJoinColumns().remove(index);
        this.fireItemRemoved("specifiedJoinColumns", index, removedJoinColumn);
        if (this.defaultJoinColumn != null) {
            this.firePropertyChanged("defaultJoinColumn", null, this.defaultJoinColumn);
        }
    }

    protected void removeSpecifiedJoinColumn_(OrmJoinColumn joinColumn) {
        this.removeItemFromList(joinColumn, this.specifiedJoinColumns, "specifiedJoinColumns");
    }

    @Override
    public void moveSpecifiedJoinColumn(int targetIndex, int sourceIndex) {
        CollectionTools.move(this.specifiedJoinColumns, (int)targetIndex, (int)sourceIndex);
        this.resource.getJoinColumns().move(targetIndex, sourceIndex);
        this.fireItemMoved("specifiedJoinColumns", targetIndex, sourceIndex);
    }

    protected OrmJoinColumn buildJoinColumn(XmlJoinColumn resourceJoinColumn) {
        return this.getXmlContextNodeFactory().buildOrmJoinColumn(this, this.joinColumnOwner, resourceJoinColumn);
    }

    @Override
    public void update() {
        this.updateSpecifiedJoinColumns();
        this.updateDefaultJoinColumn();
    }

    protected void updateSpecifiedJoinColumns() {
        CloneIterator xmlJoinColumns = new CloneIterator(this.resource.getJoinColumns());
        ListIterator<OrmJoinColumn> contextJoinColumns = this.specifiedJoinColumns();
        while (contextJoinColumns.hasNext()) {
            OrmJoinColumn contextJoinColumn = (OrmJoinColumn)contextJoinColumns.next();
            if (xmlJoinColumns.hasNext()) {
                contextJoinColumn.update((XmlJoinColumn)xmlJoinColumns.next());
                continue;
            }
            this.removeSpecifiedJoinColumn_(contextJoinColumn);
        }
        while (xmlJoinColumns.hasNext()) {
            this.addSpecifiedJoinColumn(this.buildJoinColumn((XmlJoinColumn)xmlJoinColumns.next()));
        }
    }

    protected void updateDefaultJoinColumn() {
        if (this.mayHaveDefaultJoinColumn()) {
            if (this.defaultJoinColumn == null) {
                this.setDefaultJoinColumn(this.buildJoinColumn(null));
            } else {
                this.defaultJoinColumn.update(null);
            }
        } else {
            this.setDefaultJoinColumn(null);
        }
    }

    protected boolean mayHaveDefaultJoinColumn() {
        return this.getRelationshipReference().mayHaveDefaultJoinColumn() && !this.hasSpecifiedJoinColumns();
    }

    @Override
    public void validate(List<IMessage> messages, IReporter reporter) {
        super.validate(messages, reporter);
        ListIterator<OrmJoinColumn> stream = this.joinColumns();
        while (stream.hasNext()) {
            ((OrmJoinColumn)stream.next()).validate(messages, reporter);
        }
    }
}

