/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.eclipselink.ui.internal.details.orm;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.ListIterator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jpt.eclipselink.core.context.EclipseLinkConverter;
import org.eclipse.jpt.eclipselink.core.context.EclipseLinkCustomConverter;
import org.eclipse.jpt.eclipselink.core.context.EclipseLinkObjectTypeConverter;
import org.eclipse.jpt.eclipselink.core.context.EclipseLinkStructConverter;
import org.eclipse.jpt.eclipselink.core.context.EclipseLinkTypeConverter;
import org.eclipse.jpt.eclipselink.core.context.orm.EclipseLinkConverterHolder;
import org.eclipse.jpt.eclipselink.ui.internal.details.EclipseLinkCustomConverterComposite;
import org.eclipse.jpt.eclipselink.ui.internal.details.EclipseLinkObjectTypeConverterComposite;
import org.eclipse.jpt.eclipselink.ui.internal.details.EclipseLinkStructConverterComposite;
import org.eclipse.jpt.eclipselink.ui.internal.details.EclipseLinkTypeConverterComposite;
import org.eclipse.jpt.eclipselink.ui.internal.details.orm.EclipseLinkConverterDialog;
import org.eclipse.jpt.ui.internal.util.ControlSwitcher;
import org.eclipse.jpt.ui.internal.widgets.AddRemoveListPane;
import org.eclipse.jpt.ui.internal.widgets.AddRemovePane;
import org.eclipse.jpt.ui.internal.widgets.Pane;
import org.eclipse.jpt.utility.internal.Transformer;
import org.eclipse.jpt.utility.internal.iterators.TransformationIterator;
import org.eclipse.jpt.utility.internal.model.value.CompositeListValueModel;
import org.eclipse.jpt.utility.internal.model.value.ItemPropertyListValueModelAdapter;
import org.eclipse.jpt.utility.internal.model.value.ListAspectAdapter;
import org.eclipse.jpt.utility.internal.model.value.SimplePropertyValueModel;
import org.eclipse.jpt.utility.internal.model.value.TransformationPropertyValueModel;
import org.eclipse.jpt.utility.internal.model.value.swing.ObjectListSelectionModel;
import org.eclipse.jpt.utility.model.value.ListValueModel;
import org.eclipse.jpt.utility.model.value.PropertyValueModel;
import org.eclipse.jpt.utility.model.value.WritablePropertyValueModel;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.part.PageBook;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OrmEclipseLinkConvertersComposite
extends Pane<EclipseLinkConverterHolder> {
    private AddRemoveListPane<EclipseLinkConverterHolder> listPane;
    private EclipseLinkCustomConverterComposite converterComposite;
    private EclipseLinkObjectTypeConverterComposite objectTypeConverterComposite;
    private EclipseLinkStructConverterComposite structConverterComposite;
    private EclipseLinkTypeConverterComposite typeConverterComposite;
    private WritablePropertyValueModel<EclipseLinkConverter> selectedConverterHolder;

    public OrmEclipseLinkConvertersComposite(Pane<?> parentPane, PropertyValueModel<? extends EclipseLinkConverterHolder> subjectHolder, Composite parent) {
        super(parentPane, subjectHolder, parent, false);
    }

    protected void initialize() {
        super.initialize();
        this.selectedConverterHolder = this.buildSelectedConverterHolder();
    }

    private WritablePropertyValueModel<EclipseLinkConverter> buildSelectedConverterHolder() {
        return new SimplePropertyValueModel();
    }

    protected void initializeLayout(Composite container) {
        this.listPane = this.addListPane(container);
        PageBook pageBook = new PageBook(container, 0);
        pageBook.setLayoutData((Object)new GridData(768));
        this.converterComposite = new EclipseLinkCustomConverterComposite(this.buildCustomConverterHolder(), (Composite)pageBook, this.getWidgetFactory());
        this.registerSubPane(this.converterComposite);
        this.objectTypeConverterComposite = new EclipseLinkObjectTypeConverterComposite(this.buildObjectTypeConverterHolder(), (Composite)pageBook, this.getWidgetFactory());
        this.registerSubPane(this.objectTypeConverterComposite);
        this.structConverterComposite = new EclipseLinkStructConverterComposite(this.buildStructConverterHolder(), (Composite)pageBook, this.getWidgetFactory());
        this.registerSubPane(this.structConverterComposite);
        this.typeConverterComposite = new EclipseLinkTypeConverterComposite(this.buildTypeConverterHolder(), (Composite)pageBook, this.getWidgetFactory());
        this.registerSubPane(this.typeConverterComposite);
        this.installPaneSwitcher(pageBook);
    }

    private AddRemoveListPane<EclipseLinkConverterHolder> addListPane(Composite container) {
        return new AddRemoveListPane<EclipseLinkConverterHolder>((Pane)this, container, this.buildConvertersAdapter(), this.buildDisplayableConvertersListHolder(), this.selectedConverterHolder, this.buildConvertersListLabelProvider(), null){

            public void enableWidgets(boolean enabled) {
                super.enableWidgets(true);
            }
        };
    }

    private void installPaneSwitcher(PageBook pageBook) {
        new ControlSwitcher(this.selectedConverterHolder, this.buildPaneTransformer(), pageBook);
    }

    private AddRemovePane.Adapter buildConvertersAdapter() {
        return new AddRemovePane.AbstractAdapter(){

            public void addNewItem(ObjectListSelectionModel listSelectionModel) {
                OrmEclipseLinkConvertersComposite.this.addConverter();
            }

            public void removeSelectedItems(ObjectListSelectionModel listSelectionModel) {
                Object[] objectArray = listSelectionModel.selectedValues();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object item = objectArray[n2];
                    if (((EclipseLinkConverter)item).getType() == "customConverter") {
                        ((EclipseLinkConverterHolder)OrmEclipseLinkConvertersComposite.this.getSubject()).removeCustomConverter((EclipseLinkCustomConverter)item);
                    } else if (((EclipseLinkConverter)item).getType() == "objectTypeConverter") {
                        ((EclipseLinkConverterHolder)OrmEclipseLinkConvertersComposite.this.getSubject()).removeObjectTypeConverter((EclipseLinkObjectTypeConverter)item);
                    } else if (((EclipseLinkConverter)item).getType() == "structConverter") {
                        ((EclipseLinkConverterHolder)OrmEclipseLinkConvertersComposite.this.getSubject()).removeStructConverter((EclipseLinkStructConverter)item);
                    } else if (((EclipseLinkConverter)item).getType() == "typeConverter") {
                        ((EclipseLinkConverterHolder)OrmEclipseLinkConvertersComposite.this.getSubject()).removeTypeConverter((EclipseLinkTypeConverter)item);
                    }
                    ++n2;
                }
            }
        };
    }

    private void addConverter() {
        this.addEclipseLinkConverterFromDialog(this.buildEclipseLinkConverterDialog());
    }

    protected EclipseLinkConverterDialog buildEclipseLinkConverterDialog() {
        return new EclipseLinkConverterDialog(this.getShell());
    }

    protected void addEclipseLinkConverterFromDialog(EclipseLinkConverterDialog dialog) {
        EclipseLinkCustomConverter converter;
        if (dialog.open() != 0) {
            return;
        }
        String converterType = dialog.getConverterType();
        if (converterType == "customConverter") {
            converter = ((EclipseLinkConverterHolder)this.getSubject()).addCustomConverter(((EclipseLinkConverterHolder)this.getSubject()).customConvertersSize());
        } else if (converterType == "objectTypeConverter") {
            converter = ((EclipseLinkConverterHolder)this.getSubject()).addObjectTypeConverter(((EclipseLinkConverterHolder)this.getSubject()).objectTypeConvertersSize());
        } else if (converterType == "structConverter") {
            converter = ((EclipseLinkConverterHolder)this.getSubject()).addStructConverter(((EclipseLinkConverterHolder)this.getSubject()).structConvertersSize());
        } else if (converterType == "typeConverter") {
            converter = ((EclipseLinkConverterHolder)this.getSubject()).addTypeConverter(((EclipseLinkConverterHolder)this.getSubject()).typeConvertersSize());
        } else {
            throw new IllegalArgumentException();
        }
        converter.setName(dialog.getName());
        this.selectedConverterHolder.setValue((Object)converter);
    }

    private Transformer<EclipseLinkConverter, Control> buildPaneTransformer() {
        return new Transformer<EclipseLinkConverter, Control>(){

            public Control transform(EclipseLinkConverter converter) {
                if (converter == null) {
                    return null;
                }
                if (converter.getType() == "customConverter") {
                    return OrmEclipseLinkConvertersComposite.this.converterComposite.getControl();
                }
                if (converter.getType() == "objectTypeConverter") {
                    return OrmEclipseLinkConvertersComposite.this.objectTypeConverterComposite.getControl();
                }
                if (converter.getType() == "structConverter") {
                    return OrmEclipseLinkConvertersComposite.this.structConverterComposite.getControl();
                }
                if (converter.getType() == "typeConverter") {
                    return OrmEclipseLinkConvertersComposite.this.typeConverterComposite.getControl();
                }
                return null;
            }
        };
    }

    private ListValueModel<EclipseLinkConverter> buildDisplayableConvertersListHolder() {
        return new ItemPropertyListValueModelAdapter(this.buildEclipseLinkConvertersHolder(), new String[]{"name"});
    }

    private ListValueModel<EclipseLinkConverter> buildEclipseLinkConvertersHolder() {
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(this.buildCustomConvertersListHolder());
        list.add(this.buildObjectTypeConvertersListHolder());
        list.add(this.buildStructConvertersListHolder());
        list.add(this.buildTypeConvertersListHolder());
        return new CompositeListValueModel(list);
    }

    private ListValueModel<EclipseLinkCustomConverter> buildCustomConvertersListHolder() {
        return new ListAspectAdapter<EclipseLinkConverterHolder, EclipseLinkCustomConverter>(this.getSubjectHolder(), new String[]{"customConverters"}){

            protected ListIterator<EclipseLinkCustomConverter> listIterator_() {
                return ((EclipseLinkConverterHolder)this.subject).customConverters();
            }

            protected int size_() {
                return ((EclipseLinkConverterHolder)this.subject).customConvertersSize();
            }
        };
    }

    private ListValueModel<EclipseLinkObjectTypeConverter> buildObjectTypeConvertersListHolder() {
        return new ListAspectAdapter<EclipseLinkConverterHolder, EclipseLinkObjectTypeConverter>(this.getSubjectHolder(), new String[]{"objectTypeConverters"}){

            protected ListIterator<EclipseLinkObjectTypeConverter> listIterator_() {
                return ((EclipseLinkConverterHolder)this.subject).objectTypeConverters();
            }

            protected int size_() {
                return ((EclipseLinkConverterHolder)this.subject).objectTypeConvertersSize();
            }
        };
    }

    private ListValueModel<EclipseLinkStructConverter> buildStructConvertersListHolder() {
        return new ListAspectAdapter<EclipseLinkConverterHolder, EclipseLinkStructConverter>(this.getSubjectHolder(), new String[]{"structConverters"}){

            protected ListIterator<EclipseLinkStructConverter> listIterator_() {
                return ((EclipseLinkConverterHolder)this.subject).structConverters();
            }

            protected int size_() {
                return ((EclipseLinkConverterHolder)this.subject).structConvertersSize();
            }
        };
    }

    private ListValueModel<EclipseLinkTypeConverter> buildTypeConvertersListHolder() {
        return new ListAspectAdapter<EclipseLinkConverterHolder, EclipseLinkTypeConverter>(this.getSubjectHolder(), new String[]{"typeConverters"}){

            protected ListIterator<EclipseLinkTypeConverter> listIterator_() {
                return ((EclipseLinkConverterHolder)this.subject).typeConverters();
            }

            protected int size_() {
                return ((EclipseLinkConverterHolder)this.subject).typeConvertersSize();
            }
        };
    }

    private PropertyValueModel<EclipseLinkCustomConverter> buildCustomConverterHolder() {
        return new TransformationPropertyValueModel<EclipseLinkConverter, EclipseLinkCustomConverter>(this.selectedConverterHolder){

            protected EclipseLinkCustomConverter transform_(EclipseLinkConverter value) {
                return value.getType() == "customConverter" ? (EclipseLinkCustomConverter)value : null;
            }
        };
    }

    private PropertyValueModel<EclipseLinkObjectTypeConverter> buildObjectTypeConverterHolder() {
        return new TransformationPropertyValueModel<EclipseLinkConverter, EclipseLinkObjectTypeConverter>(this.selectedConverterHolder){

            protected EclipseLinkObjectTypeConverter transform_(EclipseLinkConverter value) {
                return value.getType() == "objectTypeConverter" ? (EclipseLinkObjectTypeConverter)value : null;
            }
        };
    }

    private PropertyValueModel<EclipseLinkStructConverter> buildStructConverterHolder() {
        return new TransformationPropertyValueModel<EclipseLinkConverter, EclipseLinkStructConverter>(this.selectedConverterHolder){

            protected EclipseLinkStructConverter transform_(EclipseLinkConverter value) {
                return value.getType() == "structConverter" ? (EclipseLinkStructConverter)value : null;
            }
        };
    }

    private PropertyValueModel<EclipseLinkTypeConverter> buildTypeConverterHolder() {
        return new TransformationPropertyValueModel<EclipseLinkConverter, EclipseLinkTypeConverter>(this.selectedConverterHolder){

            protected EclipseLinkTypeConverter transform_(EclipseLinkConverter value) {
                return value.getType() == "typeConverter" ? (EclipseLinkTypeConverter)value : null;
            }
        };
    }

    private ILabelProvider buildConvertersListLabelProvider() {
        return new LabelProvider(){

            public String getText(Object element) {
                return ((EclipseLinkConverter)element).getName();
            }
        };
    }

    public void enableWidgets(boolean enabled) {
        super.enableWidgets(enabled);
        this.listPane.enableWidgets(enabled);
    }

    private Iterator<String> converterNames() {
        return new TransformationIterator<EclipseLinkCustomConverter, String>((Iterator)((EclipseLinkConverterHolder)this.getSubject()).customConverters()){

            protected String transform(EclipseLinkCustomConverter next) {
                return next.getName();
            }
        };
    }
}

