/*******************************************************************************
 * Copyright (c) 2007, 2009 Oracle. All rights reserved.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0, which accompanies this distribution
 * and is available at http://www.eclipse.org/legal/epl-v10.html.
 * 
 * Contributors:
 *     Oracle - initial API and implementation
 ******************************************************************************/
package org.eclipse.jpt.core.internal.jpa1.context.java;

import org.eclipse.jpt.core.context.java.JavaJpaContextNode;
import org.eclipse.jpt.core.internal.context.java.AbstractJavaSequenceGenerator;

/**
 * 
 */
public class GenericJavaSequenceGenerator extends AbstractJavaSequenceGenerator
{

	public GenericJavaSequenceGenerator(JavaJpaContextNode parent) {
		super(parent);
	}

	// ********** database stuff **********

	/**
	 * The JPA spec does not allow a sequence to have a schema.
	 */
	@Override
	protected String getSchema() {
		return this.getContextDefaultSchema();
	}

	/**
	 * The JPA spec does not allow a sequence to have a catalog.
	 */
	@Override
	protected String getCatalog() {
		return this.getContextDefaultCatalog();
	}

}
