/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.jaxws.ui.views;

import java.lang.reflect.Method;
import java.util.List;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.ArrayInitializer;
import org.eclipse.jdt.core.dom.BooleanLiteral;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.MemberValuePair;
import org.eclipse.jdt.core.dom.NormalAnnotation;
import org.eclipse.jdt.core.dom.SingleMemberAnnotation;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jst.ws.annotations.core.utils.AnnotationUtils;
import org.eclipse.jst.ws.internal.jaxws.ui.JAXWSUIPlugin;
import org.eclipse.swt.graphics.Image;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationsValuesColumnLabelProvider
extends ColumnLabelProvider {
    private TreeViewer annotationTreeViewer;
    private Image true_image;
    private Image false_image;

    public AnnotationsValuesColumnLabelProvider(TreeViewer annotationTreeViewer) {
        this.annotationTreeViewer = annotationTreeViewer;
        this.true_image = JAXWSUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.jst.ws.jaxws.ui", (String)"icons/obj16/true.gif").createImage();
        this.false_image = JAXWSUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.jst.ws.jaxws.ui", (String)"icons/obj16/false.gif").createImage();
    }

    public String getText(Object element) {
        if (element instanceof Method) {
            return this.getTextForMethod((Method)element);
        }
        return "";
    }

    private String getTextForMethod(Method method) {
        IJavaElement javaElement;
        if (this.annotationTreeViewer.getInput() instanceof IJavaElement && (javaElement = (IJavaElement)this.annotationTreeViewer.getInput()).exists()) {
            return this.getTextForMethod(method, javaElement);
        }
        return "";
    }

    private String getTextForMethod(Method method, IJavaElement annotatedElement) {
        List annotations = AnnotationUtils.getAnnotations((IJavaElement)annotatedElement);
        for (Annotation annotation : annotations) {
            Class<?> declaringClass;
            String annotationName = AnnotationUtils.getAnnotationName((Annotation)annotation);
            if (!annotationName.equals((declaringClass = method.getDeclaringClass()).getSimpleName()) && !annotationName.equals(declaringClass.getCanonicalName())) continue;
            if (annotation.isNormalAnnotation()) {
                NormalAnnotation normalAnnotation = (NormalAnnotation)annotation;
                List memberValuePairs = normalAnnotation.values();
                for (MemberValuePair memberValuePair : memberValuePairs) {
                    if (!memberValuePair.getName().getIdentifier().equals(method.getName())) continue;
                    return this.getTextForMethod(method.getReturnType(), memberValuePair.getValue());
                }
                continue;
            }
            if (!annotation.isSingleMemberAnnotation()) continue;
            SingleMemberAnnotation singleMemberAnnotation = (SingleMemberAnnotation)annotation;
            return this.getTextForMethod(method.getReturnType(), singleMemberAnnotation.getValue());
        }
        return "";
    }

    private String getTextForMethod(Class<?> returnType, Expression expression) {
        if (returnType.equals(String.class)) {
            return expression.toString();
        }
        if (returnType.equals(Class.class)) {
            return String.valueOf(expression.toString()) + ".class";
        }
        if (returnType.isPrimitive() && (returnType.equals(Byte.TYPE) || returnType.equals(Short.TYPE) || returnType.equals(Integer.TYPE) || returnType.equals(Long.TYPE) || returnType.equals(Float.TYPE) || returnType.equals(Double.TYPE))) {
            return expression.toString();
        }
        if (returnType.isArray() && expression instanceof ArrayInitializer) {
            ArrayInitializer arrayInitializer = (ArrayInitializer)expression;
            if (arrayInitializer.expressions().size() > 0) {
                return "[]{...}";
            }
            return "[]{}";
        }
        if (returnType.isEnum()) {
            String enumValue = expression.toString();
            return enumValue.substring(enumValue.lastIndexOf(".") + 1);
        }
        return "";
    }

    public Image getImage(Object element) {
        try {
            if (element instanceof Class) {
                return this.getImageForClass((Class)element);
            }
            if (element instanceof Method) {
                return this.getImageForMethod((Method)element);
            }
        }
        catch (JavaModelException jme) {
            JAXWSUIPlugin.log(jme.getStatus());
        }
        return null;
    }

    private Image getImageForClass(Class<?> aClass) throws JavaModelException {
        IJavaElement javaElement;
        if (this.annotationTreeViewer.getInput() instanceof IJavaElement && (javaElement = (IJavaElement)this.annotationTreeViewer.getInput()).exists()) {
            return this.getImageForClass(aClass, javaElement);
        }
        return null;
    }

    private Image getImageForClass(Class<?> aClass, IJavaElement javaElement) throws JavaModelException {
        List annotations = AnnotationUtils.getAnnotations((IJavaElement)javaElement);
        for (Annotation annotation : annotations) {
            String annotationName = AnnotationUtils.getAnnotationName((Annotation)annotation);
            if (!annotationName.equals(aClass.getSimpleName()) && !annotationName.equals(aClass.getCanonicalName())) continue;
            return this.true_image;
        }
        return this.false_image;
    }

    private Image getImageForMethod(Method method) throws JavaModelException {
        IJavaElement javaElement;
        if (method.getReturnType().equals(Boolean.TYPE) && this.annotationTreeViewer.getInput() instanceof IJavaElement && (javaElement = (IJavaElement)this.annotationTreeViewer.getInput()).exists()) {
            return this.getImageForMethod(method, javaElement);
        }
        return null;
    }

    private Image getImageForMethod(Method method, IJavaElement javaElement) throws JavaModelException {
        List annotations = AnnotationUtils.getAnnotations((IJavaElement)javaElement);
        for (Annotation annotation : annotations) {
            SingleMemberAnnotation singleMemberAnnotation;
            Class<?> declaringClass;
            String annotationName = AnnotationUtils.getAnnotationName((Annotation)annotation);
            if (!annotationName.equals((declaringClass = method.getDeclaringClass()).getSimpleName()) && !annotationName.equals(declaringClass.getCanonicalName())) continue;
            if (annotation.isNormalAnnotation()) {
                NormalAnnotation normalAnnotation = (NormalAnnotation)annotation;
                List memberValuePairs = normalAnnotation.values();
                for (MemberValuePair memberValuePair : memberValuePairs) {
                    if (!memberValuePair.getName().getIdentifier().equals(method.getName()) || !(memberValuePair.getValue() instanceof BooleanLiteral) || !((BooleanLiteral)memberValuePair.getValue()).booleanValue()) continue;
                    return this.true_image;
                }
                continue;
            }
            if (!annotation.isSingleMemberAnnotation() || !((singleMemberAnnotation = (SingleMemberAnnotation)annotation).getValue() instanceof BooleanLiteral) || !((BooleanLiteral)singleMemberAnnotation.getValue()).booleanValue()) continue;
            return this.true_image;
        }
        return this.false_image;
    }

    public void dispose() {
        super.dispose();
        this.true_image.dispose();
        this.false_image.dispose();
    }
}

