/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.test.util.mock;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import junit.framework.Assert;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jst.jsf.test.util.mock.IMockResourceFactory;
import org.eclipse.jst.jsf.test.util.mock.MockContainer;
import org.eclipse.jst.jsf.test.util.mock.MockFile;
import org.eclipse.jst.jsf.test.util.mock.MockFolder;
import org.eclipse.jst.jsf.test.util.mock.MockProject;
import org.eclipse.jst.jsf.test.util.mock.MockResource;
import org.eclipse.jst.jsf.test.util.mock.MockWorkspace;
import org.eclipse.jst.jsf.test.util.mock.MockWorkspaceRoot;

public class MockWorkspaceContext {
    private final MockWorkspace _ws;
    private final Map<IPath, MockResource> _ownedResources;

    public MockWorkspaceContext(MockWorkspace ws) {
        this._ws = ws;
        this._ownedResources = new HashMap<IPath, MockResource>();
        ((MockWorkspaceRoot)ws.getRoot()).setContext(this);
    }

    public MockWorkspaceContext() {
        this(new MockWorkspace(new MockWorkspaceRoot()));
    }

    public void fireWorkspaceEvent(IResourceChangeEvent event) {
        this._ws.fireResourceChangeEvent(event);
    }

    public void dispose() throws Exception {
        for (Map.Entry<IPath, MockResource> entry : this._ownedResources.entrySet()) {
            entry.getValue().dispose();
        }
        this._ownedResources.clear();
        this._ws.dispose();
    }

    public MockWorkspace getWorkspace() {
        return this._ws;
    }

    public MockResource getResource(IPath path) {
        return this._ownedResources.get(path);
    }

    public MockFile getFile(IPath path) {
        return (MockFile)this.getResource(path);
    }

    public MockProject getProject(IPath path) {
        return (MockProject)this._ownedResources.get(path);
    }

    public MockProject createProject(IPath path, boolean replace) {
        MockProject project = new MockProject(path, new MyMockResourceFactory());
        this.attachProject(project, replace);
        return project;
    }

    public MockProject createProject(String baseId) {
        int i = 0;
        while (this._ownedResources.get(this.generateName(baseId, i)) != null) {
            ++i;
        }
        return this.createProject((IPath)this.generateName(baseId, i), false);
    }

    private Path generateName(String baseId, int i) {
        return new Path(String.valueOf(baseId) + "_TestProject_" + i);
    }

    public MockProject createProject(IPath path) {
        return this.createProject(path, false);
    }

    public void attachProject(MockProject project, boolean replace) {
        this.checkExists(project.getFullPath(), replace);
        project.setWorkspace(this._ws);
        this._ownedResources.put(project.getFullPath(), project);
    }

    public MockProject loadProject(IPath path, ZipFile zip) throws Exception {
        return this.loadProject(path, zip, "");
    }

    public MockProject loadProject(IPath path, ZipFile zip, String pathIntoZip) throws Exception {
        this.checkExists(path, false);
        MockProject project = new MockProject(path, new MyMockResourceFactory(zip, pathIntoZip));
        this.attachProject(project, false);
        return project;
    }

    public MockFile attachFile(MockProject project, IPath projectRelativePath, File file) {
        Assert.assertEquals((Object)this.checkExists(project.getFullPath(), true), (Object)project);
        this.checkExists(project.getFullPath().append(projectRelativePath), false);
        Assert.assertTrue((boolean)file.exists());
        MockFile iFile = (MockFile)project.getFile(projectRelativePath);
        FileInputStream inStream = null;
        try {
            inStream = new FileInputStream(file);
            iFile.setContents(inStream, 0, null);
            MockFile mockFile = iFile;
            return mockFile;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (CoreException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (inStream != null) {
                try {
                    ((InputStream)inStream).close();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    private MockResource checkExists(IPath path, boolean replace) {
        MockResource resource = this._ownedResources.get(path);
        if (resource != null && !replace) {
            throw new IllegalArgumentException(String.valueOf(path.toString()) + " already exists");
        }
        return resource;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MyMockResourceFactory
    implements IMockResourceFactory {
        private ZipFile _zip;
        private final String _pathIntoZip;

        public MyMockResourceFactory() {
            this._pathIntoZip = "";
        }

        public MyMockResourceFactory(ZipFile zip, String pathIntoZip) throws Exception {
            this._zip = zip;
            this._pathIntoZip = pathIntoZip;
        }

        @Override
        public MockFile createFile(MockContainer container, IPath path) throws CoreException, IOException {
            IPath newFileFullPath = container.getFullPath().append(path);
            MockResource resource = MockWorkspaceContext.this.checkExists(newFileFullPath, true);
            if (resource == null) {
                resource = new MockFile(newFileFullPath);
                resource.setWorkspace(MockWorkspaceContext.this._ws);
                resource.setProject(container.getProject());
                if (this._zip != null) {
                    InputStream inputStream;
                    ZipEntry entry = this._zip.getEntry(String.valueOf(this._pathIntoZip) + path.toString());
                    if (entry != null && (inputStream = this._zip.getInputStream(entry)) != null) {
                        ((MockFile)resource).setContents(inputStream, false, true, (IProgressMonitor)new NullProgressMonitor());
                    }
                    this.ensurePathToNewResource(container, path);
                }
                MockWorkspaceContext.this._ownedResources.put(newFileFullPath, resource);
            }
            return (MockFile)resource;
        }

        @Override
        public MockFolder createFolder(MockContainer container, IPath path) {
            IPath newFileFullPath = container.getFullPath().append(path);
            MockResource resource = MockWorkspaceContext.this.checkExists(newFileFullPath, true);
            if (resource == null) {
                resource = new MockFolder(newFileFullPath, this);
                resource.setWorkspace(MockWorkspaceContext.this._ws);
                resource.setProject(container.getProject());
                this.ensurePathToNewResource(container, path);
                MockWorkspaceContext.this._ownedResources.put(newFileFullPath, resource);
            }
            return (MockFolder)resource;
        }

        protected void ensurePathToNewResource(MockContainer container, IPath path) {
            IPath leadingPath = path.removeLastSegments(1);
            IPath curPath = container.getFullPath();
            while (leadingPath.segmentCount() > 0) {
                String nextSegment = leadingPath.segments()[0];
                curPath = curPath.append(nextSegment);
                leadingPath = leadingPath.removeFirstSegments(1);
                MockResource newContainer = MockWorkspaceContext.this.checkExists(curPath, true);
                if (newContainer != null) continue;
                this.newFolder(container, curPath);
            }
        }

        protected void newFolder(MockContainer container, IPath curPath) {
            MockFolder newContainer = new MockFolder(curPath, this);
            newContainer.setWorkspace(MockWorkspaceContext.this._ws);
            newContainer.setProject(container.getProject());
            MockWorkspaceContext.this._ownedResources.put(curPath, newContainer);
        }

        @Override
        public void dispose() throws Exception {
            if (this._zip != null) {
                this._zip.close();
            }
        }

        @Override
        public List<MockResource> getCurrentMembers(MockContainer container) {
            ArrayList<MockResource> members = new ArrayList<MockResource>();
            IPath containerPath = container.getFullPath();
            for (IPath path : MockWorkspaceContext.this._ownedResources.keySet()) {
                if (!containerPath.isPrefixOf(path) || path.segmentCount() != containerPath.segmentCount() + 1) continue;
                members.add((MockResource)MockWorkspaceContext.this._ownedResources.get(path));
            }
            return members;
        }

        @Override
        public void forceLoad(MockProject project) throws Exception {
            Enumeration<? extends ZipEntry> entries = this._zip.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                String name = entry.getName();
                int removeIdx = name.indexOf(this._pathIntoZip);
                if (removeIdx <= -1) continue;
                name = name.substring(this._pathIntoZip.length());
                if (entry.isDirectory()) {
                    this.newFolder(project, (IPath)new Path(name));
                    continue;
                }
                this.createFile(project, (IPath)new Path(name));
            }
        }
    }
}

