/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.web.ui.tests.style;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import junit.framework.TestCase;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.wst.jsdt.core.IJavaScriptProject;
import org.eclipse.wst.jsdt.core.JavaScriptCore;
import org.eclipse.wst.jsdt.core.LibrarySuperType;
import org.eclipse.wst.jsdt.internal.core.JavaProject;
import org.eclipse.wst.jsdt.web.core.internal.project.JsWebNature;

public class StyleTests
extends TestCase {
    static /* synthetic */ Class class$0;

    public StyleTests() {
    }

    public StyleTests(String name) {
        super(name);
    }

    public void testKeywordStyle() throws CoreException {
        String projectName = this.getName();
        String fileName = String.valueOf(projectName) + ".html";
        String contents = "<html><head><script> var params = \"someBadString\".substring(1,2,3,4);\nparahnas.shift();</script></head><body> </body></html>";
        IProjectDescription description = ResourcesPlugin.getWorkspace().newProjectDescription(projectName);
        description.setNatureIds(new String[]{"org.eclipse.wst.jsdt.core.jsNature"});
        IProject iProject = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        iProject.create(description, (IProgressMonitor)new NullProgressMonitor());
        iProject.open(null);
        IJavaScriptProject project = JavaScriptCore.create((IProject)iProject);
        project.setRawIncludepath(null, (IProgressMonitor)new NullProgressMonitor());
        LibrarySuperType superType = new LibrarySuperType((IPath)new Path("org.eclipse.wst.jsdt.launching.JRE_CONTAINER"), project, "Global");
        ((JavaProject)project).setCommonSuperType(superType);
        new JsWebNature(iProject, null).configure();
        IFile file = iProject.getFile(fileName);
        file.create((InputStream)new ByteArrayInputStream(contents.getBytes()), true, null);
        IEditorPart editor = IDE.openEditor((IWorkbenchPage)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage(), (IFile)file);
        StyleTests.assertNotNull((String)"editor failed to open", (Object)editor);
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.swt.widgets.Control");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Control control = (Control)editor.getAdapter((Class)clazz);
        StyleTests.assertNotNull((String)"editor did not return a Control adapter", (Object)control);
        StyleTests.assertTrue((String)"editor Control adapter is not a StyledText widget", (boolean)(control instanceof StyledText));
        int varIndex = contents.indexOf("var");
        StyleRange[] styleRanges = ((StyledText)control).getStyleRanges(varIndex, 3);
        StyleTests.assertTrue((String)"no style range for 'var' keyword (this test may fail due to unpredictable timing issues with the test workbench)", (styleRanges.length > 0 ? 1 : 0) != 0);
        StyleTests.assertNotNull((String)"no foreground color for 'var' keyword", (Object)styleRanges[0].foreground);
        StyleTests.assertNotSame((String)"foreground color has same RGB as black", (Object)PlatformUI.getWorkbench().getDisplay().getSystemColor(2).getRGB(), (Object)styleRanges[0].foreground.getRGB());
    }
}

