/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.test.util.mock;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.jst.jsf.test.util.mock.MockFile;
import org.eclipse.jst.jsf.test.util.mock.MockProject;
import org.eclipse.jst.jsf.test.util.mock.MockResourceChangeEvent;
import org.eclipse.jst.jsf.test.util.mock.MockResourceDelta;
import org.eclipse.jst.jsf.test.util.mock.MockResourceDeltaFactory;
import org.eclipse.jst.jsf.test.util.mock.MockWorkspaceContext;

public class MockResourceChangeEventFactory {
    private final MockResourceDeltaFactory _deltaFactory;

    public MockResourceChangeEventFactory(MockResourceDeltaFactory deltaFactory) {
        this._deltaFactory = deltaFactory;
    }

    public MockResourceChangeEventFactory(MockWorkspaceContext wsContext) {
        this(new MockResourceDeltaFactory(wsContext));
    }

    public IResourceChangeEvent createSimpleFileChange(MockFile file, boolean incrementModStamp) {
        MockResourceDelta delta = this._deltaFactory.createSimpleFileChange(file);
        if (incrementModStamp) {
            file.incrementModStamp();
        }
        return this.newPostChangeEvent(delta);
    }

    public IResourceChangeEvent createSimpleFileRemove(MockFile file) {
        MockResourceDelta delta = this._deltaFactory.createSimpleFileRemoved(file);
        return this.newPostChangeEvent(delta);
    }

    public IResourceChangeEvent createSimpleFileAdded(MockFile file) {
        MockResourceDelta delta = this._deltaFactory.createSimpleFileAdded(file);
        return this.newPostChangeEvent(delta);
    }

    public IResourceChangeEvent createSimpleProjectClosed(MockProject project) {
        return new MockResourceChangeEvent(project, 2, null);
    }

    public IResourceChangeEvent createSimpleProjectDeleted(MockProject project) {
        return new MockResourceChangeEvent(project, 4, null);
    }

    public IResourceChangeEvent createSimpleFolderAdded(IFolder folder) {
        MockResourceDelta delta = this._deltaFactory.createSimpleFolderAdded(folder);
        return this.newPostChangeEvent(delta);
    }

    public IResourceChangeEvent createSimpleFolderDeleted(IFolder folder) {
        MockResourceDelta delta = this._deltaFactory.createSimpleFolderRemoved(folder);
        return this.newPostChangeEvent(delta);
    }

    public IResourceChangeEvent createRecursiveFolderDeleted(IFolder folder) {
        MockResourceDelta delta = this._deltaFactory.createRecursiveFolderRemoved(folder);
        return this.newPostChangeEvent(delta);
    }

    public IResourceChangeEvent createSimpleFolderRename(IFolder folder, IFolder newFolderName) {
        MockResourceDelta delta = this._deltaFactory.createFolderRename(folder, newFolderName);
        return this.newPostChangeEvent(delta);
    }

    public IResourceChangeEvent createSimpleFileRename(IFile file, IFile newFile) {
        MockResourceDelta delta = this._deltaFactory.createFileRename(file, newFile);
        return this.newPostChangeEvent(delta);
    }

    private MockResourceChangeEvent newPostChangeEvent(MockResourceDelta delta) {
        return new MockResourceChangeEvent(1, delta);
    }
}

