/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core.tests.model;

import junit.framework.Test;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.wst.jsdt.core.IBuffer;
import org.eclipse.wst.jsdt.core.IField;
import org.eclipse.wst.jsdt.core.IFunction;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.IOpenable;
import org.eclipse.wst.jsdt.core.IPackageFragment;
import org.eclipse.wst.jsdt.core.JavaScriptCore;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.core.WorkingCopyOwner;
import org.eclipse.wst.jsdt.core.tests.model.ModifyingResourceTests;
import org.eclipse.wst.jsdt.core.tests.model.TestBuffer;
import org.eclipse.wst.jsdt.core.tests.model.TestPessimisticProvider;
import org.eclipse.wst.jsdt.internal.core.util.Util;

public class WorkingCopyTests
extends ModifyingResourceTests {
    IJavaScriptUnit cu = null;
    IJavaScriptUnit copy = null;
    static /* synthetic */ Class class$0;

    public WorkingCopyTests(String name) {
        super(name);
    }

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.jsdt.core.tests.model.WorkingCopyTests");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return WorkingCopyTests.buildModelTestSuite(clazz);
    }

    protected void setUp() throws Exception {
        super.setUp();
        try {
            this.createJavaProject("P", new String[]{"src"}, new String[]{this.getSystemJsPathString(), "lib"});
            this.createFile("P/src/A.js", "  var FIELD;\n  var field1;\n  var field2;\n  function foo() {\n  }\n");
            this.cu = this.getCompilationUnit("P/src/A.js");
            this.copy = this.cu.getWorkingCopy(null);
        }
        catch (CoreException e) {
            e.printStackTrace();
            throw new RuntimeException(e.getMessage());
        }
    }

    protected void tearDown() throws Exception {
        if (this.copy != null) {
            this.copy.discardWorkingCopy();
        }
        this.deleteProject("P");
        super.tearDown();
    }

    public void testCancelMakeConsistent() throws JavaScriptModelException {
        String newContents = " function bar() {\n  }\n";
        this.copy.getBuffer().setContents(newContents);
        NullProgressMonitor monitor = new NullProgressMonitor();
        monitor.setCanceled(true);
        try {
            this.copy.makeConsistent((IProgressMonitor)monitor);
        }
        catch (OperationCanceledException operationCanceledException) {}
        WorkingCopyTests.assertTrue((String)"Working copy should be opened", (boolean)this.copy.isOpen());
    }

    public void testChangeContent() throws CoreException {
        String newContents = "  function bar() {\n}";
        this.copy.getBuffer().setContents(newContents);
        this.copy.reconcile(0, false, null, null);
        this.assertSourceEquals("Unexpected working copy contents", newContents, this.copy.getBuffer().getContents());
        this.copy.commitWorkingCopy(true, null);
        this.assertSourceEquals("Unexpected original cu contents", newContents, this.cu.getBuffer().getContents());
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testChangeContentOfReadOnlyCU1() throws CoreException {
        if (!Util.isReadOnlySupported()) {
            return;
        }
        IResource resource = this.cu.getUnderlyingResource();
        boolean readOnlyFlag = Util.isReadOnly((IResource)resource);
        boolean didComplain = false;
        try {
            try {
                Util.setReadOnly((IResource)resource, (boolean)true);
                this.copy.getBuffer().setContents("invalid");
                this.copy.commitWorkingCopy(true, null);
            }
            catch (JavaScriptModelException javaScriptModelException) {
                didComplain = true;
            }
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            Util.setReadOnly((IResource)resource, (boolean)readOnlyFlag);
            throw throwable;
        }
        {
            Object var4_6 = null;
        }
        Util.setReadOnly((IResource)resource, (boolean)readOnlyFlag);
        WorkingCopyTests.assertTrue((String)"Should have complained about modifying a read-only unit:", (boolean)didComplain);
        WorkingCopyTests.assertTrue((String)"ReadOnly buffer got modified:", (!this.cu.getBuffer().getContents().equals("invalid") ? 1 : 0) != 0);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testChangeContentOfReadOnlyCU2() throws CoreException {
        if (!Util.isReadOnlySupported()) {
            return;
        }
        String newContents = "  function bar() {\n}";
        IResource resource = this.cu.getUnderlyingResource();
        IProject project = resource.getProject();
        boolean readOnlyFlag = Util.isReadOnly((IResource)resource);
        try {
            RepositoryProvider.map((IProject)project, (String)"org.eclipse.wst.jsdt.core.tests.model.pessimisticnature");
            TestPessimisticProvider.markWritableOnSave = true;
            Util.setReadOnly((IResource)resource, (boolean)true);
            this.copy.getBuffer().setContents(newContents);
            this.copy.commitWorkingCopy(true, null);
            this.assertSourceEquals("Unexpected original cu contents", newContents, this.cu.getBuffer().getContents());
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            TestPessimisticProvider.markWritableOnSave = false;
            RepositoryProvider.unmap((IProject)project);
            Util.setReadOnly((IResource)resource, (boolean)readOnlyFlag);
            throw throwable;
        }
        {
            Object var5_7 = null;
            TestPessimisticProvider.markWritableOnSave = false;
        }
        RepositoryProvider.unmap((IProject)project);
        Util.setReadOnly((IResource)resource, (boolean)readOnlyFlag);
    }

    public void testContents() throws CoreException {
        String originalSource = this.cu.getSource();
        IField type = this.cu.getField("field1");
        this.assertDeletion((IJavaScriptElement)type);
        this.assertSourceEquals("source code of copy should still be original", originalSource, this.copy.getSource());
    }

    public void testCreation() {
        WorkingCopyTests.assertTrue((String)"Failed to create X.js compilation unit", (this.cu != null && this.cu.exists() ? 1 : 0) != 0);
        WorkingCopyTests.assertTrue((String)"Failed to create working copy on X.js", (this.copy != null && this.copy.exists() ? 1 : 0) != 0);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testCustomizedBuffer() throws JavaScriptModelException {
        TestWorkingCopyOwner owner = new TestWorkingCopyOwner();
        IJavaScriptUnit customizedCopy = this.cu.getWorkingCopy((WorkingCopyOwner)owner, null);
        try {
            WorkingCopyTests.assertTrue((String)"Unexpected buffer", (boolean)(customizedCopy.getBuffer() instanceof TestBuffer));
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            customizedCopy.discardWorkingCopy();
            throw throwable;
        }
        {
            Object var3_5 = null;
        }
        customizedCopy.discardWorkingCopy();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testCustomizedBuffer2() throws JavaScriptModelException {
        TestWorkingCopyOwner owner = new TestWorkingCopyOwner();
        IJavaScriptUnit customizedCopy = this.cu.getWorkingCopy((WorkingCopyOwner)owner, null);
        try {
            customizedCopy.close();
            customizedCopy.open(null);
            WorkingCopyTests.assertTrue((String)"Unexpected buffer", (boolean)(customizedCopy.getBuffer() instanceof TestBuffer));
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            customizedCopy.discardWorkingCopy();
            throw throwable;
        }
        {
            Object var3_5 = null;
        }
        customizedCopy.discardWorkingCopy();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testDelete2Fields() throws CoreException {
        try {
            this.startDeltas();
            JavaScriptCore.run((IWorkspaceRunnable)new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) throws CoreException {
                    IField field1 = WorkingCopyTests.this.copy.getField("field1");
                    IField field2 = WorkingCopyTests.this.copy.getField("field2");
                    field1.delete(false, monitor);
                    field2.delete(false, monitor);
                }
            }, null);
            this.assertDeltas("Unexpected delta", "field1[-]: {}\nfield2[-]: {}");
        }
        catch (Throwable throwable) {
            Object var1_2 = null;
            this.stopDeltas();
            throw throwable;
        }
        {
            Object var1_3 = null;
        }
        this.stopDeltas();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testGeneral() throws JavaScriptModelException, CoreException {
        WorkingCopyTests.assertTrue((String)"copy and actual should not be equal", (!this.copy.equals(this.cu) ? 1 : 0) != 0);
        IField copyfield = this.copy.getField("field1");
        WorkingCopyTests.assertEquals((String)"primary should be the samel", (Object)this.cu, (Object)this.cu.getPrimary());
        WorkingCopyTests.assertEquals((String)"getting working copy from a copy should yield original copy", (Object)this.copy, (Object)this.copy.getWorkingCopy(null));
        boolean ex = false;
        this.assertDeletion((IJavaScriptElement)copyfield);
        ((IOpenable)this.cu.getParent()).close();
        WorkingCopyTests.assertTrue((String)"copy should still be open", (boolean)this.copy.isOpen());
        WorkingCopyTests.assertTrue((String)"actual type should still be present", (boolean)this.cu.getField("field1").exists());
        IJavaScriptUnit copy2 = this.cu.getWorkingCopy(null);
        try {
            WorkingCopyTests.assertTrue((String)"working copies should be unique ", (!this.copy.equals(copy2) ? 1 : 0) != 0);
            IFunction method = copy2.getFunction("foo", null);
            this.assertDeletion((IJavaScriptElement)method);
            IFunction originalMethod = this.cu.getFunction("foo", null);
            WorkingCopyTests.assertTrue((String)"method should still be present in original", (boolean)originalMethod.exists());
            copy2.commitWorkingCopy(false, null);
            WorkingCopyTests.assertTrue((String)"copy always has unsaved changes", (boolean)copy2.hasUnsavedChanges());
            WorkingCopyTests.assertTrue((String)"method should no longer be present in original after commit", (!originalMethod.exists() ? 1 : 0) != 0);
            try {
                this.copy.commitWorkingCopy(false, null);
                WorkingCopyTests.assertTrue((String)"commit should have failed", (boolean)ex);
            }
            catch (JavaScriptModelException javaScriptModelException) {}
            try {
                this.copy.commitWorkingCopy(true, null);
            }
            catch (JavaScriptModelException javaScriptModelException) {
                WorkingCopyTests.assertTrue((String)"commit should work", (boolean)false);
            }
            WorkingCopyTests.assertTrue((String)"original type should no longer be present", (!this.cu.getField("field1").exists() ? 1 : 0) != 0);
            this.copy.close();
            ex = false;
            try {
                this.copy.open(null);
            }
            catch (JavaScriptModelException javaScriptModelException) {
                ex = true;
            }
            WorkingCopyTests.assertTrue((String)"should be able to open working copy a 2nd time", (!ex ? 1 : 0) != 0);
            this.copy.discardWorkingCopy();
            ex = false;
            try {
                this.copy.open(null);
            }
            catch (JavaScriptModelException javaScriptModelException) {
                ex = true;
            }
            WorkingCopyTests.assertTrue((String)"should not be able to open working copy again", (boolean)ex);
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            copy2.discardWorkingCopy();
            throw throwable;
        }
        {
            Object var6_8 = null;
        }
        copy2.discardWorkingCopy();
    }

    public void testGetPrimaryCU() {
        IJavaScriptElement primary = this.copy.getPrimaryElement();
        WorkingCopyTests.assertTrue((String)"Element is not a cu", (primary instanceof IJavaScriptUnit && !((IJavaScriptUnit)primary).isWorkingCopy() ? 1 : 0) != 0);
        WorkingCopyTests.assertTrue((String)"Element should exist", (boolean)primary.exists());
    }

    public void testGetPrimaryField() {
        IJavaScriptElement primary = this.copy.getField("FIELD").getPrimaryElement();
        WorkingCopyTests.assertTrue((String)"Element is not a field", (primary instanceof IField && !((IJavaScriptUnit)primary.getParent()).isWorkingCopy() ? 1 : 0) != 0);
        WorkingCopyTests.assertTrue((String)"Element should exist", (boolean)primary.exists());
    }

    public void testGetPrimaryMethod() throws JavaScriptModelException {
        IJavaScriptElement primary = this.copy.getFunctions()[0].getPrimaryElement();
        WorkingCopyTests.assertTrue((String)"Element is not a method", (boolean)(primary instanceof IFunction));
        WorkingCopyTests.assertTrue((String)"Element should exist", (boolean)primary.exists());
    }

    public void testRenameMethod() throws JavaScriptModelException {
        IFunction method = this.copy.getFunctions()[0];
        IJavaScriptElement primary = method.getPrimaryElement();
        method.rename("bar", false, null);
        WorkingCopyTests.assertEquals((String)"Invalid name of working copy method", (String)"bar", (String)this.copy.getFunctions()[0].getElementName());
        WorkingCopyTests.assertEquals((String)"Invalid name of primary method", (String)"foo", (String)primary.getElementName());
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testMoveTypeToAnotherWorkingCopy() throws CoreException {
        this.createFile("P/src/B.js", "function B() {\n}");
        IJavaScriptUnit cu2 = this.getCompilationUnit("P/src/B.js");
        IJavaScriptUnit copy2 = cu2.getWorkingCopy(null);
        try {
            IField fld1 = this.copy.getField("field1");
            fld1.move((IJavaScriptElement)copy2, null, null, false, null);
            WorkingCopyTests.assertTrue((String)"A should not exist", (!fld1.exists() ? 1 : 0) != 0);
            WorkingCopyTests.assertTrue((String)"B.A should exist", (boolean)copy2.getField("field1").exists());
            WorkingCopyTests.assertTrue((String)"Buffer for A should not be null", (this.copy.getBuffer() != null ? 1 : 0) != 0);
            this.assertSourceEquals("Invalid content for A", "  var FIELD;\n  var field2;\n  function foo() {\n  }\n", this.copy.getBuffer().getContents());
            WorkingCopyTests.assertTrue((String)"Buffer for B should not be null", (copy2.getBuffer() != null ? 1 : 0) != 0);
            this.assertSourceEquals("Invalid content for B", "var field1;\n\nfunction B() {\n}", copy2.getBuffer().getContents());
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            copy2.discardWorkingCopy();
            throw throwable;
        }
        {
            Object var4_6 = null;
        }
        copy2.discardWorkingCopy();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testShared1() throws JavaScriptModelException {
        WorkingCopyOwner owner = new WorkingCopyOwner(){};
        IJavaScriptUnit shared = this.cu.getWorkingCopy(owner, null);
        try {
            WorkingCopyTests.assertTrue((String)"Should find shared working copy", (this.cu.findWorkingCopy(owner) == shared ? 1 : 0) != 0);
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            shared.discardWorkingCopy();
            throw throwable;
        }
        {
            Object var3_5 = null;
        }
        shared.discardWorkingCopy();
        WorkingCopyTests.assertTrue((String)"Should not find cu with same owner", (this.cu.findWorkingCopy(owner) == null ? 1 : 0) != 0);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testShared2() throws JavaScriptModelException {
        WorkingCopyOwner owner = new WorkingCopyOwner(){};
        IJavaScriptUnit shared = this.cu.getWorkingCopy(owner, null);
        try {
            IJavaScriptUnit shared2 = this.cu.getWorkingCopy(owner, null);
            WorkingCopyTests.assertTrue((String)"Second working copy should be identical to first one", (shared2 == shared ? 1 : 0) != 0);
            Object var4_6 = null;
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            shared.discardWorkingCopy();
            try {
                WorkingCopyTests.assertTrue((String)"Should find shared working copy", (this.cu.findWorkingCopy(owner) == shared ? 1 : 0) != 0);
                Object var6_10 = null;
            }
            catch (Throwable throwable2) {
                Object var6_9 = null;
                shared.discardWorkingCopy();
                throw throwable2;
            }
            shared.discardWorkingCopy();
            throw throwable;
        }
        shared.discardWorkingCopy();
        try {}
        catch (Throwable throwable) {
            Object var6_11 = null;
            shared.discardWorkingCopy();
            throw throwable;
        }
        WorkingCopyTests.assertTrue((String)"Should find shared working copy", (this.cu.findWorkingCopy(owner) == shared ? 1 : 0) != 0);
        Object var6_12 = null;
        shared.discardWorkingCopy();
        WorkingCopyTests.assertTrue((String)"Should not find cu with same owner", (this.cu.findWorkingCopy(owner) == null ? 1 : 0) != 0);
    }

    public void testMultipleCommit() {
        try {
            this.copy.createMethod("function anotherMethod() {}\n", null, false, null);
        }
        catch (JavaScriptModelException javaScriptModelException) {
            WorkingCopyTests.assertTrue((String)"creation failed", (boolean)false);
        }
        try {
            this.copy.commitWorkingCopy(false, null);
        }
        catch (JavaScriptModelException javaScriptModelException) {
            WorkingCopyTests.assertTrue((String)"commit failed", (boolean)false);
        }
        WorkingCopyTests.assertTrue((String)"method should exist after commit", (boolean)this.cu.getFunction("anotherMethod", new String[0]).exists());
        try {
            this.copy.createMethod("function anotherAnotherMethod() {}\n", null, false, null);
        }
        catch (JavaScriptModelException javaScriptModelException) {
            WorkingCopyTests.assertTrue((String)"Creation failed 2", (boolean)false);
        }
        try {
            this.copy.commitWorkingCopy(false, null);
        }
        catch (JavaScriptModelException javaScriptModelException) {
            WorkingCopyTests.assertTrue((String)"commit2 failed", (boolean)false);
        }
        WorkingCopyTests.assertTrue((String)"second method added should exist after commit", (boolean)this.cu.getFunction("anotherAnotherMethod", new String[0]).exists());
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testNonExistingCU() throws JavaScriptModelException {
        IJavaScriptUnit nonExistingCU;
        block6: {
            nonExistingCU = this.getCompilationUnit("P/src/NonExisting.js");
            IJavaScriptUnit workingCopy = null;
            try {
                workingCopy = nonExistingCU.getWorkingCopy(null);
                this.assertSourceEquals("Buffer should be empty", "", workingCopy.getBuffer().getContents());
                WorkingCopyTests.assertTrue((String)"Working copy should exists", (boolean)workingCopy.exists());
                WorkingCopyTests.assertEquals((String)"Corresponding resource should be null", null, (Object)workingCopy.getCorrespondingResource());
                WorkingCopyTests.assertEquals((String)"Unexpected orginal element", (Object)nonExistingCU, (Object)workingCopy.getPrimaryElement());
                WorkingCopyTests.assertEquals((String)"Unexpected path", (Object)new Path("/P/src/NonExisting.js"), (Object)workingCopy.getPath());
                WorkingCopyTests.assertEquals((String)"Unexpected resource", (Object)nonExistingCU.getResource(), (Object)workingCopy.getResource());
                WorkingCopyTests.assertTrue((String)"Working copy should be consistent", (boolean)workingCopy.isConsistent());
                boolean exception = false;
                try {
                    workingCopy.restore();
                }
                catch (JavaScriptModelException javaScriptModelException) {
                    exception = true;
                }
                WorkingCopyTests.assertTrue((String)"Should not be able to restore from primary element", (boolean)exception);
                workingCopy.getBuffer().setContents("function X() {\n}");
                WorkingCopyTests.assertTrue((String)"Working copy should not be consistent", (!workingCopy.isConsistent() ? 1 : 0) != 0);
                workingCopy.makeConsistent(null);
                WorkingCopyTests.assertTrue((String)"Working copy should be consistent", (boolean)workingCopy.isConsistent());
                workingCopy.getBuffer().setContents("function Y() {\n}");
                workingCopy.save(null, false);
                WorkingCopyTests.assertTrue((String)"Working copy should be consistent after save", (boolean)workingCopy.isConsistent());
                WorkingCopyTests.assertTrue((String)"Primary cu should not exist", (!nonExistingCU.exists() ? 1 : 0) != 0);
                workingCopy.commitWorkingCopy(false, null);
                WorkingCopyTests.assertTrue((String)"Primary cu should exist", (boolean)nonExistingCU.exists());
                WorkingCopyTests.assertTrue((String)"Working copy's resource should now not mark as changed", (!workingCopy.hasResourceChanged() ? 1 : 0) != 0);
            }
            catch (Throwable throwable) {
                Object var4_5 = null;
                if (workingCopy != null) {
                    workingCopy.discardWorkingCopy();
                }
                if (!nonExistingCU.exists()) throw throwable;
                nonExistingCU.delete(true, null);
                throw throwable;
            }
            {
                Object var4_6 = null;
                if (workingCopy == null) break block6;
            }
            workingCopy.discardWorkingCopy();
        }
        if (!nonExistingCU.exists()) return;
        nonExistingCU.delete(true, null);
    }

    public void testOperations() throws JavaScriptModelException {
        boolean ex = false;
        try {
            this.copy.rename("someName.js", false, null);
        }
        catch (JavaScriptModelException jme) {
            WorkingCopyTests.assertTrue((String)"Incorrect status code for attempting to rename working copy", (jme.getStatus().getCode() == 967 ? 1 : 0) != 0);
            ex = true;
        }
        WorkingCopyTests.assertTrue((String)"renaming a working copy should fail", (boolean)ex);
        ex = false;
        try {
            this.copy.move(this.cu.getParent(), null, "someName.js", false, null);
        }
        catch (JavaScriptModelException jme) {
            WorkingCopyTests.assertTrue((String)"Incorrect status code for attempting to move working copy", (jme.getStatus().getCode() == 967 ? 1 : 0) != 0);
            ex = true;
        }
        WorkingCopyTests.assertTrue((String)"moving a working copy should fail", (boolean)ex);
        IPackageFragment pkg = this.getPackageFragment("P", "src", "");
        this.copy.copy((IJavaScriptElement)pkg, null, "someName.js", false, null);
        this.assertCreation((IJavaScriptElement)this.copy);
    }

    public class TestWorkingCopyOwner
    extends WorkingCopyOwner {
        public IBuffer createBuffer(IJavaScriptUnit workingCopy) {
            return new TestBuffer((IOpenable)workingCopy);
        }
    }
}

