/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core.tests.compiler.regression;

import org.eclipse.wst.jsdt.core.tests.compiler.regression.AbstractRegressionTest;

public class BasicResolveTests
extends AbstractRegressionTest {
    public BasicResolveTests(String name) {
        super(name);
    }

    public void test002() {
        this.runNegativeTest(new String[]{"X.js", "\tfunction foo(){\n\t  abc(); \n}\n"}, "----------\n1. ERROR in X.js (at line 2)\n\tabc(); \n\t^^^\nThe function abc() is undefined\n----------\n");
        this.runNegativeTest(new String[]{"X.js", "\tfunction foo(a){\n\t  foo(a); \n}\n"}, "");
    }

    public void test003() {
        this.runNegativeTest(new String[]{"X.js", "var i;i=1;\n\n"}, "");
        this.runNegativeTest(new String[]{"X.js", "var i;\ni=j;\n"}, "----------\n1. ERROR in X.js (at line 2)\n\ti=j;\n\t  ^\nj cannot be resolved\n----------\n");
    }

    public void test004() {
        this.runNegativeTest(new String[]{"X.js", "var win=debugger;\nObject();\n\n"}, "");
        this.runNegativeTest(new String[]{"X.js", "var i;\ni=j;\n"}, "----------\n1. ERROR in X.js (at line 2)\n\ti=j;\n\t  ^\nj cannot be resolved\n----------\n");
    }

    public void test005() {
        this.runNegativeTest(new String[]{"X.js", "Object();\n\n"}, "");
    }

    public void test010() {
        this.runNegativeTest(new String[]{"X.js", "MyClass.prototype.someMethod = MyClass_someMethod;function MyClass(){}function MyClass_someMethod(){}var myClassObj = new MyClass();\nmyClassObj.someMethod();\n"}, "");
    }

    public void test011() {
        this.runNegativeTest(new String[]{"X.js", "function MyClass() {\n  this.url = \"\";\n  this.activate = function(){}\n}\nvar myClassObj = new MyClass();\nvar u=myClassObj.url;\n\n"}, "");
    }

    public void test012() {
        this.runNegativeTest(new String[]{"X.js", "function Bob(firstname, lastname) {\n   this.Firstname = firstname;\n   this.Lastname = lastname;\n}\nBob.prototype.name = function () {return this.Firstname + this.Lastname;};\n"}, "");
    }

    public void test013() {
        this.runNegativeTest(new String[]{"X.js", "var SingleQuote = {\n   Version: '1.1-beta2' \n}\n"}, "");
    }

    public void test014() {
        this.runNegativeTest(new String[]{"X.js", "var o = {x:1, y: 2, name: \"print\" };\no.Z = 0; \n"}, "");
    }

    public void test020() {
        this.runNegativeTest(new String[]{"X.js", "function foo() {\n\t\tvar t = new Test();\n}\n   function Test()\n{\n}\n"}, "----------\n1. WARNING in X.js (at line 2)\n\tvar t = new Test();\n\t    ^\nThe local variable t is never read\n----------\n");
    }

    public void test021() {
        this.runNegativeTest(new String[]{"X.js", "function foo() {\n\tvar i=1;\n\tif (2>i )\n\t\tfoo();\n}\n"}, "");
    }

    public void test022() {
        this.runNegativeTest(new String[]{"X.js", "function foo() {\n\tvar ff=function(p) \n\t{var c=p;};\n\tff(1);\n}\n"}, "----------\n1. WARNING in X.js (at line 3)\n\t{var c=p;};\n\t     ^\nThe local variable c is never read\n----------\n");
    }

    public void test022b() {
        this.runNegativeTest(new String[]{"X.js", "\tvar ff=function(p) \n\t{var c=p;};\n\tff(1);\n"}, "----------\n1. WARNING in X.js (at line 2)\n\t{var c=p;};\n\t     ^\nThe local variable c is never read\n----------\n");
    }

    public void test023() {
        this.runNegativeTest(new String[]{"X.js", "\tvar ff=new String();\n"}, "");
    }

    public void test024() {
        this.runNegativeTest(new String[]{"X.js", " function bar() {;\nreturn Test.x;\n}\nTest.prototype=new Object();\nTest.x=1;\n"}, "");
    }

    public void test025() {
        this.runNegativeTest(new String[]{"X.js", " function g() {\nreturn null;\n}\nfunction foo() {\n\tg();\n}\n"}, "");
    }

    public void test026() {
        this.runNegativeTest(new String[]{"X.js", "var i=[10];\n"}, "");
    }

    public void test027() {
        this.runNegativeTest(new String[]{"X.js", " function bar(vv) {;\nreturn vv%4;\n}\n"}, "");
    }

    public void test028() {
        this.runNegativeTest(new String[]{"X.js", "var c=false;\nvar d=!c;\n"}, "");
    }

    public void test029() {
        this.runNegativeTest(new String[]{"X.js", "var d=new Date(1);\n"}, "");
    }

    public void test030() {
        this.runNegativeTest(new String[]{"X.js", "function foo(e) {\nvar x= 10, z = null, i, j;\n}\n"}, "----------\n1. WARNING in X.js (at line 2)\n\tvar x= 10, z = null, i, j;\n\t    ^\nThe local variable x is never read\n----------\n2. WARNING in X.js (at line 2)\n\tvar x= 10, z = null, i, j;\n\t           ^\nThe local variable z is never read\n----------\n3. WARNING in X.js (at line 2)\n\tvar x= 10, z = null, i, j;\n\t                     ^\nThe local variable i is never read\n----------\n4. WARNING in X.js (at line 2)\n\tvar x= 10, z = null, i, j;\n\t                        ^\nThe local variable j is never read\n----------\n");
    }

    public void test031() {
        this.runNegativeTest(new String[]{"X.js", "function OBJ(){}\nvar o = new OBJ();\n"}, "");
    }

    public void test032() {
        this.runNegativeTest(new String[]{"X.js", "var foo = {};\n foo.onMouseDown = function () { return 1; };\n foo.onMouseDown();\n"}, "");
    }

    public void test032b() {
        this.runNegativeTest(new String[]{"X.js", "var foo = {};\n foo.level1=new Object();\n foo.level1.onMouseDown = function () { return 1; };\n foo.level1.onMouseDown();\n"}, "");
    }

    public void test033() {
        this.runNegativeTest(new String[]{"X.js", " if (typeof abc == \"undefined\") {}\n"}, "");
    }

    public void test034() {
        this.runNegativeTest(new String[]{"X.js", " if (true) {\n   var abc=1;}\n var d=abc;\n"}, "");
    }

    public void test035() {
        this.runNegativeTest(new String[]{"X.js", " function foo() {\n   var vv=arguments;}\n"}, "----------\n1. WARNING in X.js (at line 2)\n\tvar vv=arguments;}\n\t    ^^\nThe local variable vv is never read\n----------\n");
    }

    public void test036() {
        this.runNegativeTest(new String[]{"X.js", " function foo() {\n   function inner(){}\n   inner();\n   }\n"}, "");
    }

    public void test037() {
        this.runNegativeTest(new String[]{"X.js", " var s = new String();\n var sub=s.substring(0,0);\n var i=sub.length;\n"}, "");
    }

    public void test038() {
        this.runNegativeTest(new String[]{"X.js", " s = new String();\n sub=s.substring(0,0);\n i=sub.length;\n"}, "");
    }

    public void test039() {
        this.runNegativeTest(new String[]{"X.js", " var s = \"\";\n with (s) {\n   var i=length;\n }\n"}, "");
    }

    public void test040() {
        this.runNegativeTest(new String[]{"X.js", " var s = \"\";\n with (s) {\n   var i=charAt(0);\n }\n"}, "");
    }

    public void test041() {
        this.runNegativeTest(new String[]{"X.js", "var x = {};\nvar b=x;\n;b.a=\"\";\n;x.a = \"\""}, "");
    }

    public void test042() {
        this.runNegativeTest(new String[]{"X.js", "var x = {};\nx.a.b = \"\""}, "----------\n1. WARNING in X.js (at line 2)\n\tx.a.b = \"\"\n\t  ^\na cannot be resolved or is not a field\n----------\n");
    }

    public void test043() {
        this.runNegativeTest(new String[]{"X.js", "var x = null;\nx>3;var y;\ny=null;\ny>3"}, "");
    }

    public void test044() {
        this.runNegativeTest(new String[]{"X.js", " if (typeof abc == \"undefined\") { abc=1;}\n var c= abc;\n"}, "");
    }

    public void test045() {
        this.runNegativeTest(new String[]{"X.js", " var a,b=1;\n var c= b;\n function abc(){ var d= 1,e=4;\n var f=e;}\n"}, "----------\n1. WARNING in X.js (at line 3)\n\tfunction abc(){ var d= 1,e=4;\n\t                    ^\nThe local variable d is never read\n----------\n2. WARNING in X.js (at line 4)\n\tvar f=e;}\n\t    ^\nThe local variable f is never read\n----------\n");
    }

    public void test046() {
        this.runNegativeTest(new String[]{"X.js", "function debug2() {\n var keyFunct = null;\n keyFunct = function () {};\n  keyFunct();\n  }\n"}, "");
    }

    public void test046b() {
        this.runNegativeTest(new String[]{"X.js", "function debug2() {\n var keyFunct = null;\n keyFunct = new function () {};\n  keyFunct();\n  }\n"}, "");
    }

    public void test047() {
        this.runNegativeTest(new String[]{"X.js", "function Config() {}\nConfig.printDocTypes = function() { throw new (\"doctype 1.\"); };\nConfig.prototype.toString = function () { return \"\"; };\nfunction main() {\n    Config.printDocTypes();\n}   \n"}, "");
    }

    public void test048() {
        this.runNegativeTest(new String[]{"X.js", "function Config2() {};\nConfig2.INPUT_DIR = \"\";\nConfig2.OUTPUT_DIR = Config2.INPUT_DIR  ;\nConfig2.getNum = function() { return 1; }\nfunction numberGen() { \n    return Config2.getNum(); \n}   \n"}, "");
    }

    public void test049() {
        this.runNegativeTest(new String[]{"X.js", "var arr=[];\nvar ref=arr.length;\nvar o=arr.pop();\n"}, "");
    }

    public void test050() {
        this.runNegativeTest(new String[]{"X.js", "function getDateTime() {\n\t    this.ctime = new Object();\n\t    this.ctime.getDay = new function() { return \"Mon\"; };\n\t    return this;\n\t}\n\tfunction debug3() {\n\t    var newObj = getDateTime();\n\t    return newObj.ctime.getDay();\n\t}\n"}, "");
    }

    public void test050b() {
        this.runNegativeTest(new String[]{"X.js", "function getDateTime() {\n\t    this.ctime = new Object();\n\t    this.ctime.getDay = new function() { return \"Mon\"; };\n\t    return this;\n\t}\n\tfunction debug3() {\n\t    var newObj = new getDateTime();\n\t    return newObj.ctime.getDay();\n\t}\n"}, "");
    }

    public void test051() {
        this.runNegativeTest(new String[]{"X.js", "var ns = {};\nns.foo = function(){\n};\nns.foo.prototype.bar = \"\";\nns.foo.prototype.bar2 = function(){\n  return \"\";\n}\nc=new ns.foo();\nc.bar2();\ni=c.bar;\n"}, "");
    }

    public void test052() {
        this.runNegativeTest(new String[]{"X.js", "var myObject=new Object();\nmyObject.ctor=   function(){\n};\nmyObject.ctor.prototype.bar = \"\";\nmyObject.ctor.prototype.bar2 = function(){\n  return \"\";\n}\nc=new myObject.ctor();\nc.bar2();\ni=c.bar;\n"}, "");
    }

    public void test053() {
        this.runNegativeTest(new String[]{"X.js", "function funccall(pp){}\nfunccall({\nmeth : function(){  \n  var c=this.i; },\n i : 1 \n});\n"}, "----------\n1. WARNING in X.js (at line 4)\n\tvar c=this.i; },\n\t    ^\nThe local variable c is never read\n----------\n");
    }

    public void test054() {
        this.runNegativeTest(new String[]{"X.js", "function func1(pp){}\nfunc1();\nfunction obj(){}\nvar o=new obj(1);\n"}, "----------\n1. WARNING in X.js (at line 2)\n\tfunc1();\n\t^^^^^^^\nWrong number of arguments for the function func1 (), expecting 1 argument(s), but there was 0 \n----------\n2. WARNING in X.js (at line 4)\n\tvar o=new obj(1);\n\t      ^^^^^^^^^^\nWrong number of arguments for the function obj (), expecting 0 argument(s), but there was 1 \n----------\n");
    }

    public void test055() {
        this.runNegativeTest(new String[]{"X.js", "function func1(base,mixin){\nvar bp = (base||0).prototype;\n}\n"}, "----------\n1. WARNING in X.js (at line 2)\n\tvar bp = (base||0).prototype;\n\t    ^^\nThe local variable bp is never read\n----------\n");
    }

    public void test056() {
        this.runNegativeTest(new String[]{"X.js", "var arr=[];\narr.push(1);\n"}, "");
    }

    public void test057() {
        this.runNegativeTest(new String[]{"X.js", "var arr= {\n  func: function(){ \n       this.func();\n   } \n};\n"}, "");
    }

    public void test058() {
        this.runNegativeTest(new String[]{"X.js", "var cls= {};\ncls.arr={};\ncls.arr[\"ss\"]=1;\nvar dd=cls.arr[\"ssd\"];\n"}, "");
    }

    public void test059() {
        this.runNegativeTest(new String[]{"X.js", "/**\n * Valid class javadoc\n * @param {String | Number} p1 param def\n */\nfunction foo(p1){\np1.length;\np1.toPrecision(1);\n}\n"}, "");
    }

    public void test060() {
        this.runNegativeTest(new String[]{"X.js", "function foo(p1){\np1();\n}\n"}, "");
    }

    public void test061() {
        this.runNegativeTest(new String[]{"X.js", "function foo(){\np1=1;\np1();\n}\n"}, "----------\n1. WARNING in X.js (at line 3)\n\tp1();\n\t^^\np1 is not a function \n----------\n");
    }

    public void test062() {
        this.runNegativeTest(new String[]{"X.js", "var cc=function(){\n  function inner(){}\n  var dd=inner;\n}\n"}, "----------\n1. WARNING in X.js (at line 3)\n\tvar dd=inner;\n\t    ^^\nThe local variable dd is never read\n----------\n");
    }

    public void test063() {
        this.runNegativeTest(new String[]{"X.js", "var cc=function(){\n  var ii;\n  function inner(){\n    var dd=ii;\n  }\n}\n"}, "----------\n1. WARNING in X.js (at line 4)\n\tvar dd=ii;\n\t    ^^\nThe local variable dd is never read\n----------\n2. WARNING in X.js (at line 4)\n\tvar dd=ii;\n\t       ^^\nThe local variable ii may not have been initialized\n----------\n");
    }

    public void test064() {
        this.runNegativeTest(new String[]{"X.js", "  function inner(){\n  var ii=0,i2=ii+1;\n}\n"}, "----------\n1. WARNING in X.js (at line 2)\n\tvar ii=0,i2=ii+1;\n\t         ^^\nThe local variable i2 is never read\n----------\n");
    }

    public void test065() {
        this.runNegativeTest(new String[]{"X.js", "  function inner(aArray){\n  var number = 0;\n  number -= aArray.length;\n  number += aArray.length;\n  return number;\n}\n"}, "");
    }

    public void test066() {
        this.runNegativeTest(new String[]{"X.js", "  TestClass = function() {\n  }\n  TestClass.prototype = new Object();\n  ns=new Object();\n  ns.TestClass = function() {\n  }\n  ns.TestClass.prototype = new Object();\n"}, "");
    }

    public void test067() {
        this.runNegativeTest(new String[]{"X.js", "\tfunction foo(a){\n\t  doo(a); \n}\n", "Y.js", "\tfunction doo(a){\n\t  foo(a); \n}\n"}, "");
    }

    public void test068() {
        this.runNegativeTest(new String[]{"X.js", "\tfunction foo(param1 , param2){\n\tif(\"\" || 0) {} \n\t var value = param1 || param2; \n\t if(param1 || param2) {} \n}\n"}, "----------\n1. WARNING in X.js (at line 3)\n\tvar value = param1 || param2; \n\t    ^^^^^\nThe local variable value is never read\n----------\n");
    }

    public void test070() {
        this.runNegativeTest(new String[]{"X.js", "\tvar s=new String();\n\ts.length=1; \n\n"}, "");
    }

    public void testbug255428() {
        this.runNegativeTest(new String[]{"X.js", "\t function MyClass(){}\n MyClass.prototype = {\n    a : 0,\n     myfunc : function(){} \n };\nfunction test() { \n     var lObj = new MyClass();\n     lObj.a = 2;\n     lObj.myfunc();\n}\n"}, "");
    }

    public void testbug259187_String_slice() {
        this.runNegativeTest(new String[]{"X.js", "var params = \"some?string\".slice('?');\n"}, "----------\n1. WARNING in X.js (at line 1)\n\tvar params = \"some?string\".slice('?');\n\t             ^^^^^^^^^^^^^^^^^^^^^^^^\nWrong number of arguments for the function slice (), expecting 2 argument(s), but there was 1 \n----------\n");
        this.runBasicTest(new String[]{"Yprime.js", "var aString = \"some?string\".slice(2, 4);\naString.length;"});
    }

    public void testbug259187_String_split() {
        this.runNegativeTest(new String[]{"Y.js", "var params = \"some?string\".split('?');\nvar base = params.shift();"}, "----------\n1. WARNING in Y.js (at line 1)\n\tvar params = \"some?string\".split('?');\n\t             ^^^^^^^^^^^^^^^^^^^^^^^^\nWrong number of arguments for the function split (), expecting 2 argument(s), but there was 1 \n----------\n");
        this.runBasicTest(new String[]{"Yprime.js", "var count = \"some?string\".split(\",\", 3);\ncount.length;"});
    }

    public void testbug259187_String_substring() {
        this.runNegativeTest(new String[]{"Z.js", "var count = \"some?string\".substring('?');"}, "----------\n1. WARNING in Z.js (at line 1)\n\tvar count = \"some?string\".substring('?');\n\t            ^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nWrong number of arguments for the function substring (), expecting 2 argument(s), but there was 1 \n----------\n");
        this.runBasicTest(new String[]{"Zprime.js", "var count = \"some?string\".substring(4, 3);\ncount.substring(4, 3);"});
    }

    public void Xtestbug196377_1() {
        this.runNegativeTest(new String[]{"Z.js", "(function() {\nhasClass();\nfunction hasClass() {}\n})();"}, "");
    }

    public void Xtestbug196377_2() {
        this.runNegativeTest(new String[]{"Z.js", "top();function top() {\ninner();\nfunction inner() {}\n}"}, "");
    }

    public void testbug196377_3() {
        this.runNegativeTest(new String[]{"Z.js", "top();\nfunction top() {}\n"}, "");
    }

    public void testbug196377_4() {
        this.runNegativeTest(new String[]{"Z.js", "top(1);\nfunction top(a) {}\n"}, "");
    }

    public void testbug283663() {
        this.runNegativeTest(new String[]{"Z.js", "var myNum = 3;\nif(myNum === undefined){}\nif(myNum == undefined){}\n"}, "");
    }

    public void testbug262728_A() {
        this.runNegativeTest(new String[]{"Z.js", "function top() {\nvar x = function() {};\nvar x1 = 3;\ninner();\nfunction inner() {\nvar p = x1 + 3;\nx();\ninner2();\nfunction inner2() {}\ninner2();\n}\nx();\ntop();\n}\ntop();"}, "----------\n1. WARNING in Z.js (at line 6)\n\tvar p = x1 + 3;\n\t    ^\nThe local variable p is never read\n----------\n");
    }

    public void testbug262728_B() {
        this.runNegativeTest(new String[]{"Z.js", "function class2() {\nthis.publicFunction = function() {\nprivateFunction();\n};\nfunction privateFunction() {\nreturn null;\n};\n}\nfunction class1() {\nfunction privateFunction() {\nreturn null;\n};\nthis.publicFunction = function() {\nprivateFunction();\n};\n}"}, "");
    }

    public void testbug262728_C() {
        this.runNegativeTest(new String[]{"Z.js", "inner();\nfunction top() {\ninner();\nfunction inner(){};\ninner();\n}\ninner();"}, "----------\n1. ERROR in Z.js (at line 1)\n\tinner();\n\t^^^^^\nThe function inner() is undefined\n----------\n2. ERROR in Z.js (at line 7)\n\tinner();\n\t^^^^^\nThe function inner() is undefined\n----------\n");
    }

    public void testbug262728_D() {
        this.runNegativeTest(new String[]{"Z.js", "(function() {\nprivateFunction();\nvar x;\nfunction privateFunction() {\nx + 3;\n}\n})();"}, "----------\n1. WARNING in Z.js (at line 5)\n\tx + 3;\n\t^\nThe local variable x may not have been initialized\n----------\n");
    }

    public void testbug269203() {
        this.runNegativeTest(new String[]{"Z.js", "function Square() {}\nvar sq = new Square();\nsq.area = function() {};"}, "");
    }

    public void testbug290414() {
        this.runNegativeTest(new String[]{"Z.js", "function Test(w) {this.w1 = w;}\nvar t = new Test(3);\nt.area = function() {};\nvar area = t.area();"}, "");
    }

    public void testbug268989_1() {
        this.runNegativeTest(new String[]{"Z.js", "/**@return {Date}*/function test(w) {return w}\nvar t = test(3);\nt.getTime();"}, "");
    }

    public void testbug268989_2() {
        this.runNegativeTest(new String[]{"Z.js", "/**@returns {Date}*/function test(w) {return w}\nvar t = test(3);\nt.getTime();"}, "");
    }

    public void testObject() {
        this.runNegativeTest(new String[]{"Z.js", "var o = new Object();\nvar x = o.toString();\nx.charAt(0);\nvar x = o.toLocaleString();\nx.charAt(0);\nvar x = o.valueOf();\nx.toLocaleString();\nvar x = o.hasOwnProperty(1);\nvar x = o.isPrototypeOf(1);\nvar x = o.propertyIsEnumerable(1);\nvar x = o.constructor;\nx.call();"}, "");
    }

    public void testbug247201() {
        this.runNegativeTest(new String[]{"Z.js", "function Car() { this.color = 'red'; this.Move = function() {};};\nCar.Stop = function() {};\nCar.engine = 'diesel';\nvar o = '';\no += 'color => '+Car.color.prototype+'<br />';\nvar p = new Car();\no += 'Stop => '+p.Stop()+'<br />';\no += 'engine => '+p.engine+'<br />';\no += 'engine => '+p.engine.prototype+'<br />';\nvar MyCar = Car;\nc = MyCar.Move;\no += 'Move => '+MyCar.Move()+'<br />';\no += 'Stop => '+MyCar.Stop+'<br />';\no += 'engine => '+MyCar.engine+'<br />';"}, "----------\n1. ERROR in Z.js (at line 5)\n\to += 'color => '+Car.color.prototype+'<br />';\n\t                     ^^^^^\nCannot make a static reference to the non-static field color\n----------\n2. WARNING in Z.js (at line 7)\n\to += 'Stop => '+p.Stop()+'<br />';\n\t                ^^^^^^^^\nThe static function Stop() from the type Car should be accessed in a static way\n----------\n3. WARNING in Z.js (at line 8)\n\to += 'engine => '+p.engine+'<br />';\n\t                    ^^^^^^\nThe static field Car.engine should be accessed in a static way\n----------\n4. WARNING in Z.js (at line 9)\n\to += 'engine => '+p.engine.prototype+'<br />';\n\t                    ^^^^^^\nThe static field Car.engine should be accessed in a static way\n----------\n5. ERROR in Z.js (at line 11)\n\tc = MyCar.Move;\n\t    ^^^^^^^^^^\nCannot make a static reference to the non-static function Move() from the type Car\n----------\n6. ERROR in Z.js (at line 12)\n\to += 'Move => '+MyCar.Move()+'<br />';\n\t                ^^^^^^^^^^^^\nCannot make a static reference to the non-static function Move() from the type Car\n----------\n");
    }

    public void testbug242871() {
        this.runNegativeTest(new String[]{"Z.js", "TestClassBase = function() {};\nTestFunction = function() {};\nTestClass = function() {\n\tTestFunction.call(this, 1);\n\tTestClassBase.call(this, 2);\n};\nTestClass.prototype = new TestClassBase();"}, "");
    }

    public void testbug242871_2() {
        this.runNegativeTest(new String[]{"Z.js", "function TestClassBase() {};\nTestFunction = function() {};\nTestClass = function() {\n\tTestFunction.call(this, 1);\n\tTestClassBase.call(this, 2);\n};\nTestClass.prototype = new TestClassBase();"}, "");
    }

    public void testbug242871_3() {
        this.runNegativeTest(new String[]{"Z.js", "TestClassBase = function() {};\nTestFunction = function() {};\nTestClass = function() {\n\tTestFunction.call(this, 1);\n\tTestClassBase.call2(this, 2);\n};\nTestClass.prototype = new TestClassBase();"}, "----------\n1. ERROR in Z.js (at line 5)\n\tTestClassBase.call2(this, 2);\n\t              ^^^^^\nThe function call2(TestClass, Number) is undefined for the type TestClassBase\n----------\n");
    }

    public void testbug269094() {
        this.runNegativeTest(new String[]{"Z.js", "function myFunc() {\nreturn myFunc.a++;\n}\nmyFunc.a = 0;"}, "");
    }

    public void testbug269094_2() {
        this.runNegativeTest(new String[]{"Z.js", "function myFunc() {\nreturn 3;\n}\nmyFunc.a = 0;"}, "");
    }

    public void testbug269094_3() {
        this.runNegativeTest(new String[]{"Z.js", "function myFunc() {\nreturn 3;\n}"}, "");
    }

    public void testbug269094_4() {
        this.runNegativeTest(new String[]{"Z.js", "/**@returns {String}*/\nfunction myFunc() {\nreturn 3;\n}"}, "----------\n1. WARNING in Z.js (at line 3)\n\treturn 3;\n\t       ^\nType mismatch: cannot convert from Number to String\n----------\n");
    }

    public void testbug269094_5() {
        this.runNegativeTest(new String[]{"Z.js", "/**@returns {Number}*/\nfunction myFunc() {\nreturn 3;\n}"}, "");
    }

    public void testbug278172() {
        this.runNegativeTest(new String[]{"Z.js", "/**\n* @param {boolean} options\n*/\nfunction foo(options) {\noptions = options || {};\nif (!options.bar)\noptions.bar = 42;\n}"}, "");
    }

    public void testbug278172_2() {
        this.runNegativeTest(new String[]{"Z.js", "/**\n* @param {boolean} options\n*/\nfunction foo(options) {\nif(options && 1 == 1) {}\n}"}, "");
    }

    public void testbug318004() {
        this.runNegativeTest(new String[]{"Z.js", "var obj = {};\nobj.first = {};\nobj.first.second = function() {};\nobj.first.second.prototype = new Object();\nif({} != obj.first.second) {}"}, "");
    }

    public void testbug324241() {
        this.runNegativeTest(new String[]{"Z.js", "var com = {};\ncom.MyType = function() {};\ncom.MyType.prototype.reload = function() {};\nvar c = new com.MyType();\nvar y = c.reload();\nvar x = c.reload;\nc.reload2();\nc.reload2;"}, "----------\n1. ERROR in Z.js (at line 7)\n\tc.reload2();\n\t  ^^^^^^^\nThe function reload2() is undefined for the type com.MyType\n----------\n2. WARNING in Z.js (at line 8)\n\tc.reload2;\n\t  ^^^^^^^\nreload2 cannot be resolved or is not a field\n----------\n");
    }

    public void testbug333781() {
        this.runNegativeTest(new String[]{"Z.js", "var com = {};\ncom.meth1 = function(){};\ncom[\"meth2\"] = function(){};\ncom.att1 = 1;\ncom[\"att2\"] = 2;\ncom.meth1();\ncom.meth2;com.att1;\ncom.att2;"}, "");
    }
}

