/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core.tests.compiler.regression;

import org.eclipse.wst.jsdt.core.infer.InferOptions;
import org.eclipse.wst.jsdt.core.tests.compiler.regression.AbstractRegressionTest;

public class InferTypesTests
extends AbstractRegressionTest {
    public InferTypesTests(String name) {
        super(name);
    }

    private InferOptions getDefaultOptions() {
        InferOptions inferOptions = new InferOptions();
        inferOptions.setDefaultOptions();
        return inferOptions;
    }

    public void test001() {
        this.runInferTest("function MyClass() {\n  this.url = \"\";\n  this.activate = function(){}\n}\nvar myClassObj = new MyClass();\n\n", "X.js", "class MyClass extends Object{\n  String url;\n  void activate()\n  MyClass()\n}\n", this.getDefaultOptions());
    }

    public void test002() {
        this.runInferTest("Shape.prototype.GetArea = Shape_GetArea;function Shape(){}function Shape_GetArea(){ var area = 5;return area;}", "X.js", "class Shape extends Object{\n  Number GetArea()\n  Shape()\n}\n", this.getDefaultOptions());
    }

    public void test003() {
        this.runInferTest("Shape.prototype.GetArea = function(a){};function Shape(){}\n", "X.js", "class Shape extends Object{\n  void GetArea(a)\n  Shape()\n}\n", this.getDefaultOptions());
    }

    public void test004() {
        this.runInferTest("Shape.prototype.GetArea = Shape_GetArea;function Shape(){}function Shape_GetArea(){return this.area;}Circle.prototype = new Shape();Circle.prototype.constructor = Circle;Circle.prototype.GetArea = Circle_GetArea;function Circle_GetArea(){}", "X.js", "class Shape extends Object{\n  ?? GetArea()\n  Shape()\n}\nclass Circle extends Shape{\n  ?? constructor;\n  void GetArea()\n}\n", this.getDefaultOptions());
    }

    public void test010() {
        this.runInferTest("function Bob(firstname, lastname) {\n   this.Firstname = firstname;\n   this.Lastname = lastname;\n}\nBob.prototype.name = function () {return this.Firstname + this.Lastname;};\n", "X.js", "class Bob extends Object{\n  ?? Firstname;\n  ?? Lastname;\n  ?? name()\n  Bob(firstname, lastname)\n}\n", this.getDefaultOptions());
    }

    public void test011() {
        this.runInferTest("function X() {\n  this.h=1;\n  this.i=[];\n}\nfunction X_foo() {\n}\nX.prototype.foo=X_foo;\n", "X.js", "class X extends Object{\n  Number h;\n  Array i;\n  void foo()\n  X()\n}\n", this.getDefaultOptions());
    }

    public void test011b() {
        this.runInferTest("P.prototype=new Object();\nP.prototype.f=1;\nfunction P(){}\nfunction a(){}\nfunction m() {\n                this.f++;\n                var p= new P();\n                    a();}\nP.prototype.mm=m;\n", "X.js", "class P extends Object{\n  Number f;\n  void mm()\n  P()\n}\n", this.getDefaultOptions());
    }

    public void test012() {
        this.runInferTest("Test.prototype=new Object();\nTest.x=1;\n", "X.js", "class Test extends Object{\n  static Number x;\n}\n", this.getDefaultOptions());
    }

    public void test013() {
        this.runInferTest("function MyClass() {\n  this.arr = [1];\n}\nvar myClassObj = new MyClass();\n\n", "X.js", "class MyClass extends Object{\n  Array(Number) arr;\n  MyClass()\n}\n", this.getDefaultOptions());
    }

    public void test020() {
        this.runInferTest("var foo;\n  foo.onMouseDown = function () { return 1; };\n\n", "X.js", "class ___foo0 extends Object{\n  static Number onMouseDown()\n}\n", this.getDefaultOptions());
    }

    public void test040() {
        this.runInferTest("/**\n * @constructor \n */\nfunction MyClass(){}/**\n * @memberOf MyClass \n * @type String \n */\nvar s;/**\n * @memberOf MyClass \n * @type Number \n */\nfunction numValue(){};\n", "X.js", "class MyClass extends Object{\n  String s;\n  MyClass()\n  Number numValue()\n}\n", this.getDefaultOptions());
    }

    public void test041() {
        this.runInferTest(" i= { \n/**\n   * @memberOf MyClass\n   * @type Number\n */\n a: 2 ,\n/**\n   * @memberOf MyClass\n   * @type String\n */\n b: function(){}};\n", "X.js", "class MyClass extends Object{\n  Number a;\n  String b()\n}\n", this.getDefaultOptions());
    }

    public void test041a() {
        this.runInferTest(" i= { \n/**\n   * @memberOf jsns.MyClass\n   * @type jsns.Number\n */\n a: 2 ,\n/**\n   * @memberOf jsns.MyClass\n   * @type jsns.String\n */\n b: function(){}};\n", "X.js", "class jsns.MyClass extends Object{\n  jsns.Number a;\n  jsns.String b()\n}\n", this.getDefaultOptions());
    }

    public void test042() {
        this.runInferTest("/**\n * @constructor \n * @extends String \n */\nfunction MyClass(){}MyClass.prototype = { \n/**\n   * @memberOf MyClass\n   * @type Number\n */\n a: 2 ,\n/**\n   * @memberOf MyClass\n   * @type String\n */\n b: function(){}};\n", "X.js", "class MyClass extends String{\n  Number a;\n  MyClass()\n  String b()\n}\n", this.getDefaultOptions());
    }

    public void test042a() {
        this.runInferTest("/**\n * @constructor \n * @extends String \n */\nfunction MyClass(){}MyClass.prototype = { \n/**\n   * @memberOf MyClass\n   * @type jsns.Number\n */\n a: 2 ,\n/**\n   * @memberOf MyClass\n   * @type jsns.String\n */\n b: function(){}};\n", "X.js", "class MyClass extends String{\n  jsns.Number a;\n  MyClass()\n  jsns.String b()\n}\n", this.getDefaultOptions());
    }

    public void test043() {
        this.runInferTest("/**\n * @constructor \n */\nfunction MyClass(){}/**\n * @memberOf MyClass \n * @param {Number} p1\n * @type String \n */\nfunction foo(p1){};\n", "X.js", "class MyClass extends Object{\n  MyClass()\n  String foo(Number p1)\n}\n", this.getDefaultOptions());
    }

    public void test043a() {
        this.runInferTest("/**\n * @constructor \n */\nfunction MyClass(){}/**\n * @memberOf MyClass \n * @param {jsns2.Number} p1\n * @type jsns.String \n */\nfunction foo(p1){};\n", "X.js", "class MyClass extends Object{\n  MyClass()\n  jsns.String foo(jsns2.Number p1)\n}\n", this.getDefaultOptions());
    }

    public void test060() {
        this.runInferTest("Shape.prototype.GetArea = Shape_GetArea;function Shape_GetArea(){ var str=\"\";return str;}", "X.js", "class Shape extends Object{\n  String GetArea()\n}\n", this.getDefaultOptions());
    }

    public void test061() {
        this.runInferTest("var foo = {  bar: \"bar\",  bar2: function(){}}", "X.js", "class ___anonymous10_44 extends Object{\n  String bar;\n  void bar2()\n}\n", this.getDefaultOptions());
    }

    public void test062() {
        this.runInferTest("var foo;foo = {  bar: \"bar\",  bar2: function(){}}", "X.js", "class ___anonymous14_48 extends Object{\n  String bar;\n  void bar2()\n}\n", this.getDefaultOptions());
    }

    public void test063() {
        this.runInferTest("var foo = {  bar: \"bar\",  bar2: {    bar3: \"bar3\"  }}", "X.js", "class ___anonymous10_52 extends Object{\n  String bar;\n  ___anonymous32_51 bar2;\n}\nclass ___anonymous32_51 extends Object{\n  String bar3;\n}\n", this.getDefaultOptions());
    }

    public void test064() {
        this.runInferTest("var ns = {};ns.foo = \"\";ns.bar = function(){  return \"\";}", "X.js", "class ___anonymous9_10 extends Object{\n  String foo;\n  String bar()\n}\n", this.getDefaultOptions());
    }

    public void test065() {
        this.runInferTest("var ns = {};ns.foo = {  bar: \"\"};", "X.js", "class ___anonymous9_10 extends Object{\n  ___anonymous21_31 foo;\n}\nclass ___anonymous21_31 extends Object{\n  String bar;\n}\n", this.getDefaultOptions());
    }

    public void test066() {
        this.runInferTest("function foo(){};foo.prototype = {  bar: \"\"}", "X.js", "class foo extends Object{\n  String bar;\n  foo()\n}\n", this.getDefaultOptions());
    }

    public void test067() {
        this.runInferTest("function foo(){};foo.prototype.bar = {  bar2: \"\"}", "X.js", "class foo extends Object{\n  ___anonymous37_48 bar;\n  foo()\n}\nclass ___anonymous37_48 extends Object{\n  String bar2;\n}\n", this.getDefaultOptions());
    }

    public void test068() {
        this.runInferTest("var ns = {};ns.foo = function(){};ns.foo.prototype.bar = \"\";ns.foo.prototype.bar2 = function(){  return \"\";}", "X.js", "class ___anonymous9_10 extends Object{\n  void foo()\n}\nclass ns.foo extends Object{\n  String bar;\n  String bar2()\n  ns.foo()\n}\n", this.getDefaultOptions());
    }

    public void test068b() {
        this.runInferTest("var ns = {};ns.foo = function(){};function abc(){};ns.foo2 = abc;", "X.js", "class ___anonymous9_10 extends Object{\n  void foo()\n  void foo2()\n}\n", this.getDefaultOptions());
    }

    public void test068c() {
        this.runInferTest("var ns = {};ns.foo = function(){};ns.foo2 = ns.foo;", "X.js", "class ___anonymous9_10 extends Object{\n  void foo()\n  void foo2()\n}\n", this.getDefaultOptions());
    }

    public void test069() {
        this.runInferTest("var ns1 = {  ns2: {}};ns1.ns2.foo = function(){};ns1.ns2.foo.prototype.bar = \"\";ns1.ns2.foo.prototype.bar2 = function(){  return \"\";}", "X.js", "class ___anonymous10_20 extends Object{\n  ___anonymous18_19 ns2;\n}\nclass ___anonymous18_19 extends Object{\n  void foo()\n}\nclass ns1.ns2.foo extends Object{\n  String bar;\n  String bar2()\n  ns1.ns2.foo()\n}\n", this.getDefaultOptions());
    }

    public void test070() {
        this.runInferTest("var foo = {  a: \"\",  b: function(){    return \"\";  }};foo.c = \"\";foo.d = function(x, y, z) {  return { x : \"\", y : \"\", z : \"\" };};", "X.js", "class ___anonymous10_52 extends Object{\n  String a;\n  String c;\n  String b()\n  ___anonymous101_126 d(x, y, z)\n}\nclass ___anonymous101_126 extends Object{\n  String x;\n  String y;\n  String z;\n}\n", this.getDefaultOptions());
    }

    public void test071() {
        this.runInferTest("if( true ){  var foo = {};}foo.bar = \"\"", "X.js", "class ___anonymous23_24 extends Object{\n  String bar;\n}\n", this.getDefaultOptions());
    }

    public void test072() {
        this.runInferTest("var foo = function(){\treturn {\t\tx: \"\",\t\ty: \"\"\t}};", "X.js", "class ___anonymous29_46 extends Object{\n  String x;\n  String y;\n}\n", this.getDefaultOptions());
    }

    public void test073() {
        this.runInferTest("var foo = function(){\tvar bar = {\t\tx: \"\",\t\ty: \"\"\t}};", "X.js", "class ___anonymous32_49 extends Object{\n  String x;\n  String y;\n}\n", this.getDefaultOptions());
    }

    public void test074() {
        this.runInferTest("/**\n  * Object Node()\n  * @super Object\n  * @constructor\n  * @class Node\n  * @since Standard ECMA-262 3rd. Edition\n  * @since Level 2 Document Object Model Core Definition.\n  * @link   http://www.w3.org/TR/2000/REC-DOM-Level-2-Core-20001113/ecma-script-binding.html\n */\nfunction Node(){};\n/**\n  * Property firstChild\n  * @type Node\n  * @class Node\n  * @see Node\n\n  * @since Standard ECMA-262 3rd. Edition\n  * @since Level 2 Document Object Model Core Definition.\n  * @link    http://www.w3.org/TR/2000/REC-DOM-Level-2-Core-20001113/ecma-script-binding.html\n */\nNode.prototype.firstChild=new Node();\n/**\n  * function insertBefore(newChild, refChild)\n  * @type Node\n  * @class Node\n  * @param newChilds Node\n  * @param refChild Node\n  * @return Node\n  * @throws DOMException\n  * @see Node\n  * @since Standard ECMA-262 3rd. Edition\n  * @since Level 2 Document Object Model Core Definition.\n  * @link    http://www.w3.org/TR/2000/REC-DOM-Level-2-Core-20001113/ecma-script-binding.html\n */\nNode.prototype.insertBefore = function(newChild, refChild){};\n", "X.js", "class Node extends Object{\n  Node firstChild;\n  Node()\n  Node insertBefore(newChild, refChild)\n}\n", this.getDefaultOptions());
    }

    public void test075() {
        this.runInferTest("var x = function(){};x.prototype = {};x.foo = \"\";x.bar = function(){  return \"\";}", "X.js", "class x extends Object{\n  static String foo;\n  static String bar()\n  x()\n}\n", this.getDefaultOptions());
    }

    public void test075b() {
        this.runInferTest("function x(){};x.foo = \"\";x.bar = function(){  return \"\";}", "X.js", "class x extends Object{\n  static String foo;\n  static String bar()\n  x()\n}\n", this.getDefaultOptions());
    }

    public void test080() {
        this.runInferTest("(function(){this.someField = 1;})();", "X.js", "class Global extends Object{\n  Number someField;\n}\n", this.getDefaultOptions());
    }

    public void test081() {
        this.runInferTest("String.foo = \"\";String.bar = function(){  return \"\";}", "X.js", "class String extends Object{\n  static String foo;\n  static String bar()\n}\n", this.getDefaultOptions());
    }

    public void test082() {
        this.runInferTest("String.foo = \"\";String.bar1 = String.bar2 = function(){  return \"\";}", "X.js", "class String extends Object{\n  static String foo;\n  static String bar1()\n  static String bar2()\n}\n", this.getDefaultOptions());
    }

    public void test083() {
        this.runInferTest("function Car() {\tthis.color = 'red';\tthis.Move = function() { return \"I'm moving\"; };};Car.Stop = function() { return \"I'm not moving\"; };Car.engine = 'diesel';", "X.js", "class Car extends Object{\n  String color;\n  static String engine;\n  String Move()\n  static String Stop()\n  Car()\n}\n", this.getDefaultOptions());
    }

    public void test084() {
        this.runInferTest("function Car() {\tthis.color = 'red';\tthis.Move = function() { return \"I'm moving\"; };};", "X.js", "class Car extends Object{\n  String color;\n  String Move()\n  Car()\n}\n", this.getDefaultOptions());
    }

    public void test085() {
        this.runInferTest("function Shape(l, w){\tthis.length = l;\tthis.width = w;}", "X.js", "class Shape extends Object{\n  ?? length;\n  ?? width;\n  Shape(l, w)\n}\n", this.getDefaultOptions());
    }

    public void test086() {
        this.runInferTest("function Shape(l, w){\tthis.length = l;\tthis.width = w;\treturn this.length * this.width;}", "X.js", "class Shape extends Object{\n  ?? length;\n  ?? width;\n  Shape(l, w)\n}\n", this.getDefaultOptions());
    }

    public void test087() {
        this.runInferTest("function Shape(l, w){\tthis.length = l;\tthis.width = w;}var s = new Shape(2, 3);s.area = function() {return this.length * this.width;};", "X.js", "class Shape extends Object{\n  ?? length;\n  ?? width;\n  Shape(l, w)\n}\nclass ___s0 extends Shape{\n  Number area()\n}\n", this.getDefaultOptions());
    }

    public void test088() {
        this.runInferTest("function Shape(l, w){\tthis.length = l;\tthis.width = w;\tthis.area = function() {return this.length * this.width;};}", "X.js", "class Shape extends Object{\n  ?? length;\n  ?? width;\n  Number area()\n  Shape(l, w)\n}\n", this.getDefaultOptions());
    }

    public void test089() {
        this.runInferTest("function Shape(l, w){\tthis.length = l;\tthis.width = w;}Shape.prototype.area = function() {return this.length * this.width;};", "X.js", "class Shape extends Object{\n  ?? length;\n  ?? width;\n  Number area()\n  Shape(l, w)\n}\n", this.getDefaultOptions());
    }

    public void test090() {
        this.runInferTest("function Shape(l, w){\tthis.length = l;\tthis.width = w;}Shape.CONSTANT = 3;", "X.js", "class Shape extends Object{\n  ?? length;\n  ?? width;\n  static Number CONSTANT;\n  Shape(l, w)\n}\n", this.getDefaultOptions());
    }

    public void test091() {
        this.runInferTest("function Round(r){\tthis.rad = r;}Round.PI = 3.14;Round.prototype.area = function() {return Round.PI * this.rad * this.rad;};Round.equal = function(a, b) {if(a == b) return true;return false;};", "X.js", "class Round extends Object{\n  ?? rad;\n  static Number PI;\n  Number area()\n  static Boolean equal(a, b)\n  Round(r)\n}\n", this.getDefaultOptions());
    }

    public void test092() {
        this.runInferTest("function Com(r, i){\tthis.r1 = r;\tthis.i1 = i;}Com.prototype.meth1 = function() {return 1;};Com.prototype.meth2 = function() {return new Com(1, 2);};Com.prototype.meth3 = function(that) {return new Com(that+1, that-1);};Com.prototype.toString = function() {return \"hi\"};Com.classMeth1 = function(a, b) {return new Com(a, b);};Com.classMeth2 = function(a, b) {return new Com(a, b);};Com.ZERO = new Com(0,0);Com.ONE = new Com(1,0);", "X.js", "class Com extends Object{\n  ?? r1;\n  ?? i1;\n  static Com ZERO;\n  static Com ONE;\n  Number meth1()\n  Com meth2()\n  Com meth3(that)\n  String toString()\n  static Com classMeth1(a, b)\n  static Com classMeth2(a, b)\n  Com(r, i)\n}\n", this.getDefaultOptions());
    }

    public void test093() {
        this.runInferTest("function Shape(l, w){\tthis.length = function() {return l;};\tthis.width = function() {return w;};}Shape.prototype.perimeter = function() {return (this.length * 2) + (this.width * 2);};", "X.js", "class Shape extends Object{\n  ?? length()\n  ?? width()\n  Number perimeter()\n  Shape(l, w)\n}\n", this.getDefaultOptions());
    }

    public void test094() {
        this.runInferTest("function Shape(l, w){\tthis.length = l;\tthis.width = w;}Shape.prototype.area = function() {return this.length * this.width;};function SubShape(l, w, x) {Shape.call(this, l, w);this.x = y;}SubShape.prototype = new Shape();SubShape.prototype.meth = function() {return 1};", "X.js", "class Shape extends Object{\n  ?? length;\n  ?? width;\n  Number area()\n  Shape(l, w)\n}\nclass SubShape extends Shape{\n  ?? x;\n  Number meth()\n  SubShape(l, w, x)\n}\n", this.getDefaultOptions());
    }

    public void test095() {
        this.runInferTest("function Abc(){\tthis.mult = function(a, b){return a * b;};\tthis.div = function(a, b){return a / b;};\tthis.rem = function(a, b){return a % b;};\tthis.sub = function(a, b){return a - b;};}", "X.js", "class Abc extends Object{\n  Number mult(a, b)\n  Number div(a, b)\n  Number rem(a, b)\n  Number sub(a, b)\n  Abc()\n}\n", this.getDefaultOptions());
    }

    public void test096() {
        this.runInferTest("function Plus(){\tthis.strings = function(){return \"a\" + \"b\";};\tthis.oneStringOneNumber = function(){return \"a\" + 1;};\tthis.oneStringOneNumber2 = function(){return \"3\" + 1;};\tthis.numbers = function(){return 1 + 2;};\tthis.unknownString = function(a){return a + \"b\";};\tthis.unknownNumber = function(a){return a + 3;};\tthis.unknownUnknown = function(a, b){return a + b;};}", "X.js", "class Plus extends Object{\n  String strings()\n  String oneStringOneNumber()\n  String oneStringOneNumber2()\n  Number numbers()\n  String unknownString(a)\n  ?? unknownNumber(a)\n  ?? unknownUnknown(a, b)\n  Plus()\n}\n", this.getDefaultOptions());
    }

    public void test097() {
        this.runInferTest("function Equality(){\tthis.equalsEquals = function(){return \"a\" == \"b\";};\tthis.equalsEqualsEquals = function(){return \"a\" === \"b\";};\tthis.notEquals = function(){return \"a\" != \"b\";};\tthis.notEqualsEquals = function(){return \"a\" !== \"b\";};}", "X.js", "class Equality extends Object{\n  Boolean equalsEquals()\n  Boolean equalsEqualsEquals()\n  Boolean notEquals()\n  Boolean notEqualsEquals()\n  Equality()\n}\n", this.getDefaultOptions());
    }

    public void test098() {
        this.runInferTest("var MyFunc = function () {};\nMyFunc.myMeth = function () {};", "X.js", "class MyFunc extends Function{\n  static void myMeth()\n  MyFunc()\n}\n", this.getDefaultOptions());
    }

    public void test099() {
        this.runInferTest("function MyType(){}MyType.prototype = new Object();\n/**\n  * Property length\n  * @type    Number\n  * @memberOf   MyType\n  * @see     MyType\n  * @since   WTP 3.2.2\n */\nMyType.prototype.length = \"\";\n", "X.js", "class MyType extends Object{\n  Number length;\n  MyType()\n}\n", this.getDefaultOptions());
    }

    public void test099a() {
        this.runInferTest("function MyType(){}MyType.prototype = new Object();\n/**\n  * Property length\n  * @type    Number\n  * @memberOf   MyType\n  * @see     MyType\n  * @since   WTP 3.2.2\n */\nMyType.prototype.length = \"\";\nMyType.prototype.name = \"\";\n", "X.js", "class MyType extends Object{\n  Number length;\n  String name;\n  MyType()\n}\n", this.getDefaultOptions());
    }

    public void test099b() {
        this.runInferTest("function MyType(){}MyType.prototype = new Object();\n/**\n  * Property length\n  * @type    Number\n  * @memberOf   MyType\n  * @see     MyType\n  * @since   WTP 3.2.2\n */\nMyType.prototype.length = \"\";\nMyType.prototype.name = \"\";\nMyType.prototype.date = new Date();\n", "X.js", "class MyType extends Object{\n  Number length;\n  String name;\n  Date date;\n  MyType()\n}\n", this.getDefaultOptions());
    }

    public void test099c() {
        this.runInferTest("function MyType(){}MyType.prototype = new Object();\n/**\n  * Property length\n  * @type    String\n  * @memberOf   MyType\n  * @see     MyType\n  * @since   WTP 3.2.2\n */\nMyType.prototype.time = 1;\n/**\n  * Property length\n  * @type    Number\n  * @memberOf   MyType\n  * @see     MyType\n  * @since   WTP 3.2.2\n */\nMyType.prototype.length = \"\";\nMyType.prototype.name = \"\";\nMyType.prototype.date = new Date();\n", "X.js", "class MyType extends Object{\n  String time;\n  Number length;\n  String name;\n  Date date;\n  MyType()\n}\n", this.getDefaultOptions());
    }

    public void test100() {
        this.runInferTest("function MyType(){}MyType.prototype = new Object();\n/**\n  * Property length\n  * @memberOf   MyType\n  * @see     MyType\n  * @since   WTP 3.2.2\n */\nMyType.prototype.length = \"\";\n", "X.js", "class MyType extends Object{\n  String length;\n  MyType()\n}\n", this.getDefaultOptions());
    }

    public void test101() {
        this.runInferTest("MyType = {\n/**\n  * Property length\n  * @type    Number\n  * @memberOf   MyType\n  * @see     MyType\n  * @since   WTP 3.2.2\n */\nlength : \"value\"\n};", "X.js", "class MyType extends Object{\n  Number length;\n}\n", this.getDefaultOptions());
    }

    public void test102() {
        this.runInferTest("MyType = {\n/**\n  * Property length\n  * @memberOf   MyType\n  * @see     MyType\n  * @since   WTP 3.2.2\n */\nlength : \"value\"\n};", "X.js", "class MyType extends Object{\n  String length;\n}\n", this.getDefaultOptions());
    }

    public void test103() {
        this.runInferTest("MyTypeInner = {\n/**\n  * @memberOf   MyTypeInner\n */\nlength: 5\n};\nMyType = {\n/**\n  * Property events\n  * @memberOf   MyType\n  * @see     MyType\n  * @type    MyTypeInner\n  * @since   WTP 3.2.2\n */\nevents : \"\"\n};", "X.js", "class MyTypeInner extends Object{\n  Number length;\n}\nclass MyType extends Object{\n  MyTypeInner events;\n}\n", this.getDefaultOptions());
    }

    public void test104() {
        this.runInferTest("MyTypeInner = {\n/**\n  * @memberOf   MyTypeInner\n */\nlength: 5\n};\nMyType = {\n/**\n  * Property events\n  * @memberOf   MyType\n  * @see     MyType\n  * @type    MyTypeInner\n  * @since   WTP 3.2.2\n */\nevents : {}\n};", "X.js", "class MyTypeInner extends Object{\n  Number length;\n}\nclass MyType extends Object{\n  MyTypeInner events;\n}\n", this.getDefaultOptions());
    }

    public void test105() {
        this.runInferTest("MyTypeInner = {\n/**\n  * @memberOf   MyTypeInner\n */\nlength: 5\n};\nMyType = {\na : \"\",\n/**\n  * Property events\n  * @memberOf   MyType\n  * @see     MyType\n  * @type    MyTypeInner\n  * @since   WTP 3.2.2\n */\nevents : {},\nb : 7\n};", "X.js", "class MyTypeInner extends Object{\n  Number length;\n}\nclass MyType extends Object{\n  String a;\n  MyTypeInner events;\n  Number b;\n}\n", this.getDefaultOptions());
    }

    public void test106() {
        this.runInferTest("MyTypeInner = {\n/**\n  * @memberOf   MyTypeInner\n */\nlength: 5\n};\nMyType = {\na : {},\n/**\n  * Property events\n  * @memberOf   MyType\n  * @see     MyType\n  * @type    MyTypeInner\n  * @since   WTP 3.2.2\n */\nevents : {},\nb : {}\n};", "X.js", "class MyTypeInner extends Object{\n  Number length;\n}\nclass MyType extends Object{\n  ___anonymous80_81 a;\n  MyTypeInner events;\n  ___anonymous220_221 b;\n}\nclass ___anonymous80_81 extends Object{\n}\nclass ___anonymous220_221 extends Object{\n}\n", this.getDefaultOptions());
    }

    public void test107() {
        this.runInferTest("MyTypeInner = {\n/**\n  * @memberOf   MyTypeInner\n */\nlength: 5\n};\nMyType = {\na : {},\n/**\n  * Property events\n  * @memberOf   MyType\n  * @see     MyType\n  * @type    MyTypeInner\n  * @since   WTP 3.2.2\n */\nevents : {},\n/**\n  * Property b\n  * @memberOf   MyType\n  * @see     MyType\n  * @type    String\n  * @since   WTP 3.2.2\n */\nb : {}\n};", "X.js", "class MyTypeInner extends Object{\n  Number length;\n}\nclass MyType extends Object{\n  ___anonymous80_81 a;\n  MyTypeInner events;\n  String b;\n}\nclass ___anonymous80_81 extends Object{\n}\n", this.getDefaultOptions());
    }

    public void test108() {
        this.runInferTest("MyTypeInner = {\n/**\n  * @memberOf   MyTypeInner\n */\nlength: 5\n};\nMyType = {\na : {},\n/**\n  * Property events\n  * @memberOf   MyType\n  * @see     MyType\n  * @type    MyTypeInner\n  * @since   WTP 3.2.2\n */\nevents : {},\nb : {}\n};", "X.js", "class MyTypeInner extends Object{\n  Number length;\n}\nclass MyType extends Object{\n  ___anonymous80_81 a;\n  MyTypeInner events;\n  ___anonymous220_221 b;\n}\nclass ___anonymous80_81 extends Object{\n}\nclass ___anonymous220_221 extends Object{\n}\n", this.getDefaultOptions());
    }

    public void test108a() {
        this.runInferTest("MyType = {\n/**\n  * Property events\n  * @memberOf   MyType\n  * @type    MyOwnNamespace.String\n */\nevents : {},\nb : \"\"\n};", "X.js", "class MyType extends Object{\n  MyOwnNamespace.String events;\n  String b;\n}\n", this.getDefaultOptions());
    }

    public void test108d() {
        this.runInferTest("MyTypeInner = {\n/**\n  * @memberOf   MyTypeInner\n */\nlength: 5\n};\nMyType = {\na : {},\n/**\n  * Property events\n  * @memberOf   MyType\n  * @see     MyType\n  * @type    MyTypeInner\n  * @since   WTP 3.2.2\n */\nevents : {},\nb : 5\n};", "X.js", "class MyTypeInner extends Object{\n  Number length;\n}\nclass MyType extends Object{\n  ___anonymous80_81 a;\n  MyTypeInner events;\n  Number b;\n}\nclass ___anonymous80_81 extends Object{\n}\n", this.getDefaultOptions());
    }

    public void test108b() {
        this.runInferTest("MyTypeInner = {\n/**\n  * @memberOf   MyTypeInner\n */\nlength: 5\n};\nMyType = {\n/**\n  * Property events\n  * @memberOf   MyType\n  * @see     MyType\n  * @type    MyTypeInner\n  * @since   WTP 3.2.2\n */\nevents : {},\nb : \"\"\n};", "X.js", "class MyTypeInner extends Object{\n  Number length;\n}\nclass MyType extends Object{\n  MyTypeInner events;\n  String b;\n}\n", this.getDefaultOptions());
    }

    public void test108c() {
        this.runInferTest("MyTypeInner = {\n/**\n  * @memberOf   MyTypeInner\n */\nlength: 5\n};\nMyType = {\n/**\n  * Property a\n  * @memberOf   MyType\n  * @see     MyType\n  * @since   WTP 3.2.2\n */\na : 5,\n/**\n  * Property events\n  * @memberOf   MyType\n  * @see     MyType\n  * @type    MyTypeInner\n  * @since   WTP 3.2.2\n */\nevents : {},\nb : {}\n};", "X.js", "class MyTypeInner extends Object{\n  Number length;\n}\nclass MyType extends Object{\n  Number a;\n  MyTypeInner events;\n  ___anonymous308_309 b;\n}\nclass ___anonymous308_309 extends Object{\n}\n", this.getDefaultOptions());
    }

    public void testBug329803_1() {
        this.runInferTest("var fun1 = function() {\tthis.abc = 1}", "X.js", "class fun1 extends Object{\n  Number abc;\n  fun1()\n}\n", this.getDefaultOptions());
    }

    public void test201() {
        this.runInferTest("foo.bar.Awesome = function(){\nthis.test = \"\";\nthis.func = function(){}\n}\n", "X.js", "class foo.bar.Awesome extends Object{\n  String test;\n  void func()\n  foo.bar.Awesome()\n}\n", this.getDefaultOptions());
    }
}

