/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core.tests.junit.extension;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.StringTokenizer;
import junit.framework.ComparisonFailure;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.wst.jsdt.core.Flags;
import org.eclipse.wst.jsdt.internal.compiler.batch.Main;

public class TestCase
extends junit.framework.TestCase {
    public static final String METHOD_PREFIX = "test";
    public static String RUN_ONLY_ID;
    public static final int NO_ORDER = 0;
    public static final int ALPHABETICAL_SORT = 1;
    public static final int ALPHA_REVERSE_SORT = 2;
    public static final int RANDOM_ORDER_JDT = 3;
    public static final int RANDOM_ORDER_TIME = 4;
    public static final long ORDERING;
    static final int MAX_GC = 5;
    static final int TIME_GC = 200;
    static final int DELTA_GC = 1000;
    public static final File MEM_LOG_FILE;
    public static final File MEM_LOG_DIR;
    public static Class CURRENT_CLASS;
    public static String CURRENT_CLASS_NAME;
    public static final String STORE_MEMORY;
    public static final boolean ALL_TESTS_LOG;
    public static final boolean RUN_GC;
    private boolean first;
    public static String TESTS_PREFIX;
    public static String[] TESTS_NAMES;
    public static int[] TESTS_NUMBERS;
    public static int[] TESTS_RANGE;
    static /* synthetic */ Class class$0;

    static {
        int index;
        RUN_ONLY_ID = "ONLY_";
        long ordering = 0L;
        try {
            long seed = Long.parseLong(System.getProperty("ordering", "0"));
            try {
                int kind = Integer.parseInt(System.getProperty("ordering", "0"));
                switch (kind) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        ordering = kind;
                        System.err.println("Note that tests will be run sorted using alphabetical order...");
                        break;
                    }
                    case 2: {
                        ordering = kind;
                        System.err.println("Note that tests will be run sorted using alphabetical reverse order...");
                        break;
                    }
                    case 3: {
                        String version = new Main(null, null, false).bind("compiler.version");
                        try {
                            String v_number = version.substring(2, 5);
                            ordering = Long.parseLong(v_number);
                            System.err.println("Note that tests will be run in random order using seed=" + v_number + " (ie. JDT/Core version)");
                        }
                        catch (NumberFormatException numberFormatException) {
                            System.err.println("Cannot extract valid JDT/Core version number from 'compiler.version': " + version + " => no order will be finally used...");
                            ordering = 0L;
                        }
                        break;
                    }
                    case 4: {
                        ordering = System.currentTimeMillis();
                        System.err.println("Note that tests will be run in random order using seed=" + ordering + " (ie. current time)");
                        break;
                    }
                    default: {
                        ordering = seed;
                        System.err.println("Note that tests will be run in random order using seed=" + seed + " (ie. given value)");
                        break;
                    }
                }
            }
            catch (NumberFormatException numberFormatException) {
                ordering = seed;
                System.err.println("Note that tests will be run in random order using seed=" + seed + " (ie. given value)");
            }
        }
        catch (NumberFormatException numberFormatException) {
            System.err.println("Only integer or long values are allowed for 'ordering' system property: " + System.getProperty("ordering", "0") + " is not valid ! => no order will be finally used...");
            ordering = 0L;
        }
        ORDERING = ordering;
        String storeMemory = System.getProperty("storeMemory");
        boolean allTestsLog = false;
        boolean runGc = false;
        File memLogDir = new File(System.getProperty("user.home"));
        if (storeMemory != null && (index = storeMemory.indexOf(44)) > 0) {
            StringTokenizer parameters = new StringTokenizer(storeMemory.substring(storeMemory.indexOf(44) + 1), ",");
            while (parameters.hasMoreTokens()) {
                String param = parameters.nextToken();
                if ("all".equals(param)) {
                    allTestsLog = true;
                    continue;
                }
                if ("gc".equals(param)) {
                    runGc = true;
                    continue;
                }
                if (!param.startsWith("dir=")) continue;
                memLogDir = new File(param.substring(4));
            }
            storeMemory = storeMemory.substring(0, index);
        }
        STORE_MEMORY = storeMemory;
        ALL_TESTS_LOG = allTestsLog;
        RUN_GC = runGc;
        if (!TestCase.verifyLogDir(memLogDir)) {
            memLogDir = null;
        }
        MEM_LOG_DIR = memLogDir;
        MEM_LOG_FILE = TestCase.createMemLogFile();
        if (STORE_MEMORY != null && MEM_LOG_FILE != null) {
            System.out.println("Memory storage activated:");
            System.out.println("\tdata stored in file " + MEM_LOG_FILE);
            System.out.println("\tall tests log: " + ALL_TESTS_LOG);
            System.out.println("\tgc activated: " + RUN_GC);
        }
        TESTS_PREFIX = null;
        TESTS_NAMES = null;
        TESTS_NUMBERS = null;
        TESTS_RANGE = null;
    }

    public TestCase(String name) {
        this.setName(name);
    }

    public static void assertEquals(String expected, String actual) {
        TestCase.assertEquals(null, expected, actual);
    }

    public static void assertEquals(String message, String expected, String actual) {
        TestCase.assertStringEquals(message, expected, actual, true);
    }

    public static void assertStringEquals(String expected, String actual, boolean showLineSeparators) {
        TestCase.assertStringEquals(null, expected, actual, showLineSeparators);
    }

    public static void assertStringEquals(String message, String expected, String actual, boolean showLineSeparators) {
        if (expected == null && actual == null) {
            return;
        }
        if (expected != null && expected.equals(actual)) {
            return;
        }
        String formatted = message != null ? String.valueOf(message) + "." : "";
        if (showLineSeparators) {
            String expectedWithLineSeparators = TestCase.showLineSeparators(expected);
            String actualWithLineSeparators = TestCase.showLineSeparators(actual);
            throw new ComparisonFailure(String.valueOf(formatted) + "\n----------- Expected ------------\n" + expectedWithLineSeparators + "\n------------ but was ------------\n" + actualWithLineSeparators + "\n--------- Difference is ----------\n", expectedWithLineSeparators, actualWithLineSeparators);
        }
        throw new ComparisonFailure(String.valueOf(formatted) + "\n----------- Expected ------------\n" + expected + "\n------------ but was ------------\n" + actual + "\n--------- Difference is ----------\n", expected, actual);
    }

    public static List buildTestsList(Class evaluationTestClass) {
        return TestCase.buildTestsList(evaluationTestClass, 0, ORDERING);
    }

    public static List buildTestsList(Class evaluationTestClass, int inheritedDepth) {
        return TestCase.buildTestsList(evaluationTestClass, inheritedDepth, ORDERING);
    }

    public static List buildTestsList(Class evaluationTestClass, int inheritedDepth, long ordering) {
        ArrayList<String> names;
        ArrayList tests = new ArrayList();
        ArrayList<String> testNames = new ArrayList<String>();
        ArrayList<String> onlyNames = new ArrayList<String>();
        Constructor constructor = null;
        try {
            Class[] classArray = new Class[1];
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            classArray[0] = clazz;
            Class[] paramTypes = classArray;
            constructor = evaluationTestClass.getConstructor(paramTypes);
        }
        catch (Exception exception) {
            return tests;
        }
        Method[] methods = evaluationTestClass.getDeclaredMethods();
        Class evaluationTestSuperclass = evaluationTestClass.getSuperclass();
        int i = 0;
        while (i < inheritedDepth && !Flags.isAbstract((int)evaluationTestSuperclass.getModifiers())) {
            Method[] superMethods = evaluationTestSuperclass.getDeclaredMethods();
            Method[] mergedMethods = new Method[methods.length + superMethods.length];
            System.arraycopy(superMethods, 0, mergedMethods, 0, superMethods.length);
            System.arraycopy(methods, 0, mergedMethods, superMethods.length, methods.length);
            methods = mergedMethods;
            evaluationTestSuperclass = evaluationTestSuperclass.getSuperclass();
            ++i;
        }
        int methodPrefixLength = METHOD_PREFIX.length();
        int m = 0;
        int max = methods.length;
        while (m < max) {
            block39: {
                String methName;
                int modifiers = methods[m].getModifiers();
                if (Flags.isPublic((int)modifiers) && !Flags.isStatic((int)modifiers) && (methName = methods[m].getName()).startsWith(METHOD_PREFIX)) {
                    boolean isOnly;
                    boolean bl = isOnly = RUN_ONLY_ID != null && methName.substring(methodPrefixLength).startsWith(RUN_ONLY_ID);
                    if (isOnly) {
                        if (!onlyNames.contains(methName)) {
                            onlyNames.add(methName);
                        }
                    } else if (TESTS_PREFIX == null && TESTS_NAMES == null && TESTS_NUMBERS == null && TESTS_RANGE == null) {
                        if (!testNames.contains(methName)) {
                            testNames.add(methName);
                        }
                    } else if (TESTS_PREFIX == null || methName.startsWith(TESTS_PREFIX)) {
                        block40: {
                            int length;
                            int numStart;
                            int n = numStart = TESTS_PREFIX == null ? methodPrefixLength : TESTS_PREFIX.length();
                            if (TESTS_NAMES != null) {
                                int i2 = 0;
                                int imax = TESTS_NAMES.length;
                                while (i2 < imax) {
                                    if (methName.indexOf(TESTS_NAMES[i2]) >= 0) {
                                        if (!testNames.contains(methName)) {
                                            testNames.add(methName);
                                        }
                                        break block39;
                                    }
                                    ++i2;
                                }
                            }
                            if (numStart < (length = methName.length())) {
                                while (numStart < length && !Character.isDigit(methName.charAt(numStart))) {
                                    ++numStart;
                                }
                                while (numStart < length && methName.charAt(numStart) == '0') {
                                    ++numStart;
                                }
                                int n2 = numStart;
                                while (n2 < length && Character.isDigit(methName.charAt(n2))) {
                                    ++n2;
                                }
                                if (n2 > numStart && n2 <= length) {
                                    try {
                                        int num = Integer.parseInt(methName.substring(numStart, n2));
                                        if (TESTS_NUMBERS != null && !testNames.contains(methName)) {
                                            int i3 = 0;
                                            while (i3 < TESTS_NUMBERS.length) {
                                                if (TESTS_NUMBERS[i3] == num) {
                                                    testNames.add(methName);
                                                    break block39;
                                                }
                                                ++i3;
                                            }
                                        }
                                        if (TESTS_RANGE == null || TESTS_RANGE.length != 2 || testNames.contains(methName) || TESTS_RANGE[0] != -1 && num < TESTS_RANGE[0] || TESTS_RANGE[1] != -1 && num > TESTS_RANGE[1]) break block40;
                                        testNames.add(methName);
                                        break block39;
                                    }
                                    catch (NumberFormatException e) {
                                        System.out.println("Method " + methods[m] + " has an invalid number format: " + e.getMessage());
                                    }
                                }
                            }
                        }
                        if (TESTS_NAMES == null && TESTS_NUMBERS == null && TESTS_RANGE == null && !testNames.contains(methName)) {
                            testNames.add(methName);
                        }
                    }
                }
            }
            ++m;
        }
        ArrayList<String> arrayList = names = onlyNames.size() > 0 ? onlyNames : testNames;
        if (ordering == 2L) {
            Collections.sort(names, Collections.reverseOrder());
        } else if (ordering == 1L) {
            Collections.sort(names);
        } else if (ordering != 0L) {
            Collections.shuffle(names, new Random(ordering));
        }
        Iterator iterator = names.iterator();
        while (iterator.hasNext()) {
            String testName = (String)iterator.next();
            try {
                tests.add(constructor.newInstance(testName));
            }
            catch (Exception e) {
                System.err.println("Method " + testName + " removed from suite due to exception: " + e.getMessage());
            }
        }
        return tests;
    }

    public static Test buildTestSuite(Class evaluationTestClass) {
        return TestCase.buildTestSuite(evaluationTestClass, null);
    }

    public static Test buildTestSuite(Class evaluationTestClass, String suiteName) {
        TestSuite suite = new TestSuite(suiteName == null ? evaluationTestClass.getName() : suiteName);
        List tests = TestCase.buildTestsList(evaluationTestClass);
        int index = 0;
        int size = tests.size();
        while (index < size) {
            suite.addTest((Test)tests.get(index));
            ++index;
        }
        return suite;
    }

    private static File createMemLogFile() {
        if (STORE_MEMORY == null || MEM_LOG_DIR == null) {
            return null;
        }
        File logFile = new File(MEM_LOG_DIR, String.valueOf(STORE_MEMORY) + ".log");
        try {
            boolean fileExist = logFile.exists();
            PrintStream stream = new PrintStream(new FileOutputStream(logFile, true));
            if (fileExist) {
                stream.println();
            }
            Date date = new Date(System.currentTimeMillis());
            stream.println("Tests:\t" + STORE_MEMORY);
            stream.println("Date:\t" + DateFormat.getDateInstance(3).format(date));
            stream.println("Time:\t" + DateFormat.getTimeInstance(3).format(date));
            stream.print("Class");
            if (ALL_TESTS_LOG) {
                stream.print("\tTest");
            }
            stream.print("\tUsed\tTotal\tMax");
            stream.println();
            stream.close();
            System.out.println("Log file " + logFile.getPath() + " opened.");
            return logFile;
        }
        catch (FileNotFoundException fileNotFoundException) {
            return null;
        }
    }

    protected static String showLineSeparators(String string) {
        if (string == null) {
            return null;
        }
        StringBuffer buffer = new StringBuffer();
        int length = string.length();
        int i = 0;
        while (i < length) {
            char car = string.charAt(i);
            switch (car) {
                case '\n': {
                    buffer.append("\\n\n");
                    break;
                }
                case '\r': {
                    if (i < length - 1 && string.charAt(i + 1) == '\n') {
                        buffer.append("\\r\\n\n");
                        ++i;
                        break;
                    }
                    buffer.append("\\r\n");
                    break;
                }
                default: {
                    buffer.append(car);
                }
            }
            ++i;
        }
        return buffer.toString();
    }

    private static boolean verifyLogDir(File logDir) {
        if (logDir.exists()) {
            if (logDir.isDirectory()) {
                return true;
            }
            System.err.println(logDir + " is not a valid directory. Log files will NOT be written!");
        } else {
            if (logDir.mkdir()) {
                return true;
            }
            System.err.println("Cannot create " + logDir + " as its parent does not exist. Log files will NOT be written!");
        }
        return false;
    }

    public void assertPerformance() {
    }

    protected void clean() {
        System.out.println("Clean test " + this.getName());
        int iterations = 0;
        long delta = 0L;
        long free = 0L;
        int i = 0;
        while (i < 5) {
            free = Runtime.getRuntime().freeMemory();
            System.gc();
            delta = Runtime.getRuntime().freeMemory() - free;
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException interruptedException) {}
            ++i;
        }
        if (iterations == 5 && delta > 1000L) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public void commitMeasurements() {
    }

    protected boolean isFirst() {
        return this.first;
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.first = false;
        if (CURRENT_CLASS == null || CURRENT_CLASS != ((Object)((Object)this)).getClass()) {
            if (CURRENT_CLASS != null && RUN_GC) {
                this.clean();
            }
            CURRENT_CLASS = ((Object)((Object)this)).getClass();
            this.first = true;
            CURRENT_CLASS_NAME = ((Object)((Object)this)).getClass().getName();
            CURRENT_CLASS_NAME = CURRENT_CLASS_NAME.substring(CURRENT_CLASS_NAME.indexOf(".tests.") + 7, CURRENT_CLASS_NAME.length());
        }
        if (STORE_MEMORY != null && MEM_LOG_FILE != null && ALL_TESTS_LOG && MEM_LOG_FILE.exists()) {
            PrintStream stream = new PrintStream(new FileOutputStream(MEM_LOG_FILE, true));
            stream.print(CURRENT_CLASS_NAME);
            stream.print('\t');
            String testName = this.getName();
            stream.print(testName);
            stream.print('\t');
            long total = Runtime.getRuntime().totalMemory();
            long used = total - Runtime.getRuntime().freeMemory();
            stream.print(used);
            stream.print('\t');
            stream.print(total);
            stream.print('\t');
            stream.print(Runtime.getRuntime().maxMemory());
            stream.println();
            stream.close();
        }
    }

    public void startMeasuring() {
    }

    public void stopMeasuring() {
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        if (STORE_MEMORY != null && MEM_LOG_FILE != null && (this.first || ALL_TESTS_LOG) && MEM_LOG_FILE.exists()) {
            PrintStream stream = new PrintStream(new FileOutputStream(MEM_LOG_FILE, true));
            stream.print(CURRENT_CLASS_NAME);
            stream.print('\t');
            if (ALL_TESTS_LOG) {
                String testName = this.getName();
                String str = "";
                int length = testName.length() - 4;
                int i = 0;
                while (i < length) {
                    str = String.valueOf(str) + '.';
                    ++i;
                }
                stream.print(str);
                stream.print("end:");
                stream.print('\t');
            }
            long total = Runtime.getRuntime().totalMemory();
            long used = total - Runtime.getRuntime().freeMemory();
            stream.print(used);
            stream.print('\t');
            stream.print(total);
            stream.print('\t');
            stream.print(Runtime.getRuntime().maxMemory());
            stream.println();
            stream.close();
        }
    }
}

