/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.editors.palette;

import java.util.List;
import org.eclipse.jst.jsf.common.metadata.Entity;
import org.eclipse.jst.jsf.common.metadata.Model;
import org.eclipse.jst.jsf.common.metadata.Trait;
import org.eclipse.jst.jsf.common.metadata.query.ITaglibDomainMetaDataModelContext;
import org.eclipse.jst.jsf.common.metadata.query.TaglibDomainMetaDataQueryHelper;
import org.eclipse.jst.jsf.tagdisplay.internal.paletteinfos.PaletteInfo;
import org.eclipse.jst.jsf.tagdisplay.internal.paletteinfos.PaletteInfos;
import org.eclipse.jst.jsf.tagdisplay.internal.paletteinfos.TagCreationAttribute;
import org.eclipse.jst.jsf.tagdisplay.internal.paletteinfos.TagCreationInfo;
import org.eclipse.jst.pagedesigner.editors.palette.ITagDropSourceData;
import org.eclipse.jst.pagedesigner.utils.CommandUtil;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MetadataTagDropSourceData
implements ITagDropSourceData {
    private final IDOMModel _model;
    private final TagCreationInfo _tagCreationInfo;
    private final ITagDropSourceData _delegate;

    public MetadataTagDropSourceData(ITagDropSourceData creationProvider, IDOMModel model) {
        this._delegate = creationProvider;
        this._model = model;
        this._tagCreationInfo = this.getTagCreationInfo();
    }

    public List<TagCreationAttribute> getAttributes() {
        if (this._tagCreationInfo != null) {
            return this._tagCreationInfo.getAttributes();
        }
        return null;
    }

    public String getTemplate() {
        if (this._tagCreationInfo != null) {
            return (String)this._tagCreationInfo.getTemplate();
        }
        return null;
    }

    @Override
    public String getDefaultPrefix() {
        return this._delegate.getDefaultPrefix();
    }

    @Override
    public String getTagName() {
        return this._delegate.getTagName();
    }

    @Override
    public String getNamespace() {
        return this._delegate.getNamespace();
    }

    private TagCreationInfo getTagCreationInfo() {
        ITaglibDomainMetaDataModelContext metadataContext = CommandUtil.getMetadataContext(this.getNamespace(), this._model);
        TagCreationInfo tagCreationInfo = null;
        String id = this.getId();
        if (metadataContext != null && id != null) {
            tagCreationInfo = MetadataTagDropSourceData.createCreationInfo(metadataContext, id, this.getTagName());
        }
        return tagCreationInfo;
    }

    @Override
    public String getId() {
        return this._delegate.getId();
    }

    static TagCreationInfo createCreationInfo(ITaglibDomainMetaDataModelContext metaDataContext, String id, String tagName) {
        Model model = TaglibDomainMetaDataQueryHelper.getModel((ITaglibDomainMetaDataModelContext)metaDataContext);
        if (model != null) {
            PaletteInfos pis;
            PaletteInfo pi;
            Trait trait = TaglibDomainMetaDataQueryHelper.getTrait((Entity)model, (String)"paletteInfos");
            if (trait != null && (pi = (pis = (PaletteInfos)trait.getValue()).findPaletteInfoById(id)) != null) {
                return pi.getTagCreation();
            }
            Entity tag = MetadataTagDropSourceData.getTagEntity(metaDataContext, tagName);
            if (tag != null && (trait = TaglibDomainMetaDataQueryHelper.getTrait((Entity)tag, (String)"tag-create")) != null && trait.getValue() != null) {
                return (TagCreationInfo)trait.getValue();
            }
        }
        return null;
    }

    private static Entity getTagEntity(ITaglibDomainMetaDataModelContext metaDataContext, String tagName) {
        return TaglibDomainMetaDataQueryHelper.getEntity((ITaglibDomainMetaDataModelContext)metaDataContext, (String)tagName);
    }
}

