/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.xpath2.processor.internal.function;

import com.ibm.icu.lang.UCharacter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.wst.xml.xpath2.processor.DynamicError;
import org.eclipse.wst.xml.xpath2.processor.ResultSequence;
import org.eclipse.wst.xml.xpath2.processor.ResultSequenceFactory;
import org.eclipse.wst.xml.xpath2.processor.internal.SeqType;
import org.eclipse.wst.xml.xpath2.processor.internal.function.Function;
import org.eclipse.wst.xml.xpath2.processor.internal.types.QName;
import org.eclipse.wst.xml.xpath2.processor.internal.types.XSDouble;
import org.eclipse.wst.xml.xpath2.processor.internal.types.XSString;
import org.eclipse.wst.xml.xpath2.processor.internal.utils.StringCodePointIterator;

public class FnSubstring
extends Function {
    public FnSubstring() {
        super(new QName("substring"), 2, 3);
    }

    public ResultSequence evaluate(Collection args) throws DynamicError {
        return FnSubstring.substring(args);
    }

    public static ResultSequence substring(Collection args) throws DynamicError {
        Collection cargs = Function.convert_arguments(args, FnSubstring.expected_args(args));
        ResultSequence rs = ResultSequenceFactory.create_new();
        Iterator argi = cargs.iterator();
        ResultSequence stringArg = (ResultSequence)argi.next();
        ResultSequence startPosArg = (ResultSequence)argi.next();
        ResultSequence lengthArg = null;
        if (argi.hasNext()) {
            lengthArg = (ResultSequence)argi.next();
        }
        if (stringArg.empty()) {
            return FnSubstring.emptyString(rs);
        }
        String str = ((XSString)stringArg.first()).value();
        double dstart = ((XSDouble)startPosArg.first()).double_value();
        if (Double.isNaN(dstart) || Double.NEGATIVE_INFINITY == dstart) {
            return FnSubstring.emptyString(rs);
        }
        long istart = Math.round(dstart);
        long ilength = Long.MAX_VALUE;
        if (lengthArg != null) {
            double dlength = ((XSDouble)lengthArg.first()).double_value();
            if (Double.isNaN(dlength)) {
                return FnSubstring.emptyString(rs);
            }
            ilength = Math.round(dlength);
            if (ilength <= 0L) {
                return FnSubstring.emptyString(rs);
            }
        }
        StringBuffer sb = new StringBuffer((int)Math.min((long)str.length(), ilength));
        StringCodePointIterator strIter = new StringCodePointIterator(str);
        long p = 1L;
        while (strIter.current() != -1) {
            if (istart <= p && p - istart < ilength) {
                sb.append(UCharacter.toChars((int)strIter.current()));
            }
            ++p;
            strIter.next();
        }
        rs.add(new XSString(sb.toString()));
        return rs;
    }

    private static ResultSequence emptyString(ResultSequence rs) {
        rs.add(new XSString(""));
        return rs;
    }

    public static Collection expected_args(Collection actualArgs) {
        ArrayList<SeqType> _expected_args = new ArrayList<SeqType>();
        _expected_args.add(new SeqType(new XSString(), 3));
        _expected_args.add(new SeqType(new XSDouble(), 0));
        if (actualArgs.size() == 3) {
            _expected_args.add(new SeqType(new XSDouble(), 0));
        }
        return _expected_args;
    }
}

