/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.utility.tests.internal;

import junit.framework.TestCase;
import org.eclipse.jpt.utility.internal.BooleanReference;

public class BooleanReferenceTests
extends TestCase {
    public BooleanReferenceTests(String name) {
        super(name);
    }

    public void testGetValue() {
        BooleanReference br = new BooleanReference(true);
        BooleanReferenceTests.assertTrue((boolean)br.getValue());
    }

    public void testGetValueDefault() {
        BooleanReference br = new BooleanReference();
        BooleanReferenceTests.assertFalse((boolean)br.getValue());
    }

    public void testIs() {
        BooleanReference br = new BooleanReference(true);
        BooleanReferenceTests.assertTrue((boolean)br.is(true));
        BooleanReferenceTests.assertFalse((boolean)br.is(false));
    }

    public void testIsNot() {
        BooleanReference br = new BooleanReference(true);
        BooleanReferenceTests.assertFalse((boolean)br.isNot(true));
        BooleanReferenceTests.assertTrue((boolean)br.isNot(false));
    }

    public void testIsTrue() {
        BooleanReference br = new BooleanReference(true);
        BooleanReferenceTests.assertTrue((boolean)br.isTrue());
    }

    public void testIsFalse() {
        BooleanReference br = new BooleanReference(true);
        BooleanReferenceTests.assertFalse((boolean)br.isFalse());
        br.setFalse();
        BooleanReferenceTests.assertTrue((boolean)br.isFalse());
    }

    public void testSetValue() {
        BooleanReference br = new BooleanReference(true);
        BooleanReferenceTests.assertTrue((boolean)br.getValue());
        br.setValue(false);
        BooleanReferenceTests.assertFalse((boolean)br.getValue());
    }

    public void testFlip() {
        BooleanReference br = new BooleanReference(true);
        BooleanReferenceTests.assertTrue((boolean)br.getValue());
        BooleanReferenceTests.assertFalse((boolean)br.flip());
        BooleanReferenceTests.assertFalse((boolean)br.getValue());
        BooleanReferenceTests.assertTrue((boolean)br.flip());
        BooleanReferenceTests.assertTrue((boolean)br.getValue());
    }

    public void testSetNotBoolean() {
        BooleanReference br = new BooleanReference(false);
        BooleanReferenceTests.assertFalse((boolean)br.getValue());
        br.setNot(true);
        BooleanReferenceTests.assertFalse((boolean)br.getValue());
        br.setNot(true);
        BooleanReferenceTests.assertFalse((boolean)br.getValue());
        br.setNot(false);
        BooleanReferenceTests.assertTrue((boolean)br.getValue());
    }

    public void testSetTrue() {
        BooleanReference br = new BooleanReference(false);
        BooleanReferenceTests.assertFalse((boolean)br.getValue());
        br.setTrue();
        BooleanReferenceTests.assertTrue((boolean)br.getValue());
    }

    public void testSetFalse() {
        BooleanReference br = new BooleanReference(true);
        BooleanReferenceTests.assertTrue((boolean)br.getValue());
        br.setFalse();
        BooleanReferenceTests.assertFalse((boolean)br.getValue());
    }

    public void testClone() {
        BooleanReference br = new BooleanReference(true);
        BooleanReference clone = (BooleanReference)br.clone();
        BooleanReferenceTests.assertTrue((boolean)clone.getValue());
        BooleanReferenceTests.assertEquals((Object)br, (Object)clone);
    }

    public void testEquals() {
        BooleanReference br1 = new BooleanReference(true);
        BooleanReference br2 = new BooleanReference(true);
        BooleanReferenceTests.assertEquals((Object)br1, (Object)br2);
        BooleanReference br3 = new BooleanReference(false);
        BooleanReferenceTests.assertFalse((boolean)br1.equals((Object)br3));
    }

    public void testHashCode() {
        BooleanReference br1 = new BooleanReference(true);
        BooleanReferenceTests.assertEquals((int)1, (int)br1.hashCode());
        br1.setFalse();
        BooleanReferenceTests.assertEquals((int)0, (int)br1.hashCode());
    }

    public void testToString() {
        BooleanReference br1 = new BooleanReference(true);
        BooleanReferenceTests.assertEquals((String)"[true]", (String)br1.toString());
        br1.setFalse();
        BooleanReferenceTests.assertEquals((String)"[false]", (String)br1.toString());
    }
}

