/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.xpath2.processor.testsuite.functions;

import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.xerces.xs.XSModel;
import org.eclipse.wst.xml.xpath2.processor.DefaultDynamicContext;
import org.eclipse.wst.xml.xpath2.processor.DefaultEvaluator;
import org.eclipse.wst.xml.xpath2.processor.DynamicContext;
import org.eclipse.wst.xml.xpath2.processor.DynamicError;
import org.eclipse.wst.xml.xpath2.processor.ResultSequence;
import org.eclipse.wst.xml.xpath2.processor.StaticError;
import org.eclipse.wst.xml.xpath2.processor.XPathParserException;
import org.eclipse.wst.xml.xpath2.processor.XercesLoader;
import org.eclipse.wst.xml.xpath2.processor.ast.XPath;
import org.eclipse.wst.xml.xpath2.processor.internal.ast.XPathNode;
import org.eclipse.wst.xml.xpath2.processor.test.AbstractPsychoPathTest;
import org.w3c.dom.Document;

public class SeqCollectionFuncTest
extends AbstractPsychoPathTest {
    private static final String COLLECTION2 = "http://www.w3.org/2005/xpath-functions/collection2";
    private static final String COLLECTION1 = "http://www.w3.org/2005/xpath-functions/collection1";

    public void test_fn_collection_1() throws Exception {
        String inputFile = "/TestSources/emptydoc.xml";
        String xqFile = "/Queries/XQuery/Functions/NodeSeqFunc/SeqCollectionFunc/fn-collection-1.xq";
        String expectedResult = "XPST0017";
        URL fileURL = this.bundle.getEntry(inputFile);
        this.loadDOMDocument(fileURL);
        XSModel schema = this.getGrammar();
        DefaultDynamicContext dc = this.setupDynamicContext(schema);
        String xpath = this.extractXPathExpression(xqFile, inputFile);
        String actual = null;
        try {
            XPath path = this.compileXPath((DynamicContext)dc, xpath);
            DefaultEvaluator eval = new DefaultEvaluator((DynamicContext)dc, this.domDoc);
            ResultSequence rs = eval.evaluate((XPathNode)path);
            actual = this.buildResultString(rs);
        }
        catch (XPathParserException ex) {
            actual = ex.code();
        }
        catch (StaticError ex) {
            actual = ex.code();
        }
        catch (DynamicError ex) {
            actual = ex.code();
        }
        SeqCollectionFuncTest.assertEquals((String)("XPath Result Error " + xqFile + ":"), (String)expectedResult, (String)actual);
    }

    public void test_fn_collection_2() throws Exception {
        String inputFile = "/TestSources/emptydoc.xml";
        String xqFile = "/Queries/XQuery/Functions/NodeSeqFunc/SeqCollectionFunc/fn-collection-2.xq";
        String expectedResult = "FODC0004";
        URL fileURL = this.bundle.getEntry(inputFile);
        this.loadDOMDocument(fileURL);
        XSModel schema = this.getGrammar();
        DefaultDynamicContext dc = this.setupDynamicContext(schema);
        String xpath = this.extractXPathExpression(xqFile, inputFile);
        String actual = null;
        try {
            XPath path = this.compileXPath((DynamicContext)dc, xpath);
            DefaultEvaluator eval = new DefaultEvaluator((DynamicContext)dc, this.domDoc);
            ResultSequence rs = eval.evaluate((XPathNode)path);
            actual = this.buildResultString(rs);
        }
        catch (XPathParserException ex) {
            actual = ex.code();
        }
        catch (StaticError ex) {
            actual = ex.code();
        }
        catch (DynamicError ex) {
            actual = ex.code();
        }
        SeqCollectionFuncTest.assertEquals((String)("XPath Result Error " + xqFile + ":"), (String)expectedResult, (String)actual);
    }

    public void test_fn_collection_3() throws Exception {
        String inputFile = "/TestSources/emptydoc.xml";
        String xqFile = "/Queries/XQuery/Functions/NodeSeqFunc/SeqCollectionFunc/fn-collection-3.xq";
        String expectedResult = "FODC0002";
        URL fileURL = this.bundle.getEntry(inputFile);
        this.loadDOMDocument(fileURL);
        XSModel schema = this.getGrammar();
        DefaultDynamicContext dc = this.setupDynamicContext(schema);
        String xpath = this.extractXPathExpression(xqFile, inputFile);
        String actual = null;
        try {
            XPath path = this.compileXPath((DynamicContext)dc, xpath);
            DefaultEvaluator eval = new DefaultEvaluator((DynamicContext)dc, this.domDoc);
            ResultSequence rs = eval.evaluate((XPathNode)path);
            actual = this.buildResultString(rs);
        }
        catch (XPathParserException ex) {
            actual = ex.code();
        }
        catch (StaticError ex) {
            actual = ex.code();
        }
        catch (DynamicError ex) {
            actual = ex.code();
        }
        SeqCollectionFuncTest.assertEquals((String)("XPath Result Error " + xqFile + ":"), (String)expectedResult, (String)actual);
    }

    public void test_fn_collection_4() throws Exception {
        String inputFile = "/TestSources/emptydoc.xml";
        String xqFile = "/Queries/XQuery/Functions/NodeSeqFunc/SeqCollectionFunc/fn-collection-4.xq";
        String resultFile = "/ExpectedTestResults/Functions/NodeSeqFunc/SeqCollectionFunc/fn-collection-4.txt";
        String expectedResult = this.getExpectedResult(resultFile);
        URL fileURL = this.bundle.getEntry(inputFile);
        this.loadDOMDocument(fileURL);
        XSModel schema = this.getGrammar();
        DefaultDynamicContext dc = this.setupDynamicContext(schema);
        this.loadCollection1Default((DynamicContext)dc);
        String xpath = "fn:count(fn:collection(\"http://www.w3.org/2005/xpath-functions/collection1\"))";
        String actual = null;
        try {
            XPath path = this.compileXPath((DynamicContext)dc, xpath);
            DefaultEvaluator eval = new DefaultEvaluator((DynamicContext)dc, this.domDoc);
            ResultSequence rs = eval.evaluate((XPathNode)path);
            actual = this.buildResultString(rs);
        }
        catch (XPathParserException ex) {
            actual = ex.code();
        }
        catch (StaticError ex) {
            actual = ex.code();
        }
        catch (DynamicError ex) {
            actual = ex.code();
        }
        SeqCollectionFuncTest.assertEquals((String)("XPath Result Error " + xqFile + ":"), (String)expectedResult, (String)actual);
    }

    public void test_fn_collection_4d() throws Exception {
        String inputFile = "/TestSources/emptydoc.xml";
        String xqFile = "/Queries/XQuery/Functions/NodeSeqFunc/SeqCollectionFunc/fn-collection-4d.xq";
        String resultFile = "/ExpectedTestResults/Functions/NodeSeqFunc/SeqCollectionFunc/fn-collection-4.txt";
        String expectedResult = this.getExpectedResult(resultFile);
        URL fileURL = this.bundle.getEntry(inputFile);
        this.loadDOMDocument(fileURL);
        XSModel schema = this.getGrammar();
        DefaultDynamicContext dc = this.setupDynamicContext(schema);
        this.loadCollection1Default((DynamicContext)dc);
        String xpath = this.extractXPathExpression(xqFile, inputFile);
        String actual = null;
        try {
            XPath path = this.compileXPath((DynamicContext)dc, xpath);
            DefaultEvaluator eval = new DefaultEvaluator((DynamicContext)dc, this.domDoc);
            ResultSequence rs = eval.evaluate((XPathNode)path);
            actual = this.buildResultString(rs);
        }
        catch (XPathParserException ex) {
            actual = ex.code();
        }
        catch (StaticError ex) {
            actual = ex.code();
        }
        catch (DynamicError ex) {
            actual = ex.code();
        }
        SeqCollectionFuncTest.assertEquals((String)("XPath Result Error " + xqFile + ":"), (String)expectedResult, (String)actual);
    }

    public void test_fn_collection_5() throws Exception {
        String inputFile = "/TestSources/emptydoc.xml";
        String xqFile = "/Queries/XQuery/Functions/NodeSeqFunc/SeqCollectionFunc/fn-collection-5.xq";
        String resultFile = "/ExpectedTestResults/Functions/NodeSeqFunc/SeqCollectionFunc/fn-collection-5.txt";
        String expectedResult = this.getExpectedResult(resultFile);
        URL fileURL = this.bundle.getEntry(inputFile);
        this.loadDOMDocument(fileURL);
        XSModel schema = this.getGrammar();
        DefaultDynamicContext dc = this.setupDynamicContext(schema);
        this.loadCollection2Default((DynamicContext)dc);
        String xpath = "fn:count(fn:collection(\"http://www.w3.org/2005/xpath-functions/collection2\"))";
        String actual = null;
        try {
            XPath path = this.compileXPath((DynamicContext)dc, xpath);
            DefaultEvaluator eval = new DefaultEvaluator((DynamicContext)dc, this.domDoc);
            ResultSequence rs = eval.evaluate((XPathNode)path);
            actual = this.buildResultString(rs);
        }
        catch (XPathParserException ex) {
            actual = ex.code();
        }
        catch (StaticError ex) {
            actual = ex.code();
        }
        catch (DynamicError ex) {
            actual = ex.code();
        }
        SeqCollectionFuncTest.assertEquals((String)("XPath Result Error " + xqFile + ":"), (String)expectedResult, (String)actual);
    }

    public void test_fn_collection_5d() throws Exception {
        String inputFile = "/TestSources/emptydoc.xml";
        String xqFile = "/Queries/XQuery/Functions/NodeSeqFunc/SeqCollectionFunc/fn-collection-5d.xq";
        String resultFile = "/ExpectedTestResults/Functions/NodeSeqFunc/SeqCollectionFunc/fn-collection-5.txt";
        String expectedResult = this.getExpectedResult(resultFile);
        URL fileURL = this.bundle.getEntry(inputFile);
        this.loadDOMDocument(fileURL);
        XSModel schema = this.getGrammar();
        DefaultDynamicContext dc = this.setupDynamicContext(schema);
        this.loadCollection2Default((DynamicContext)dc);
        String xpath = this.extractXPathExpression(xqFile, inputFile);
        String actual = null;
        try {
            XPath path = this.compileXPath((DynamicContext)dc, xpath);
            DefaultEvaluator eval = new DefaultEvaluator((DynamicContext)dc, this.domDoc);
            ResultSequence rs = eval.evaluate((XPathNode)path);
            actual = this.buildResultString(rs);
        }
        catch (XPathParserException ex) {
            actual = ex.code();
        }
        catch (StaticError ex) {
            actual = ex.code();
        }
        catch (DynamicError ex) {
            actual = ex.code();
        }
        SeqCollectionFuncTest.assertEquals((String)("XPath Result Error " + xqFile + ":"), (String)expectedResult, (String)actual);
    }

    public void test_fn_collection_7() throws Exception {
        String inputFile = "/TestSources/emptydoc.xml";
        String xqFile = "/Queries/XQuery/Functions/NodeSeqFunc/SeqCollectionFunc/fn-collection-7.xq";
        String resultFile = "/ExpectedTestResults/Functions/NodeSeqFunc/SeqCollectionFunc/fn-collection-7.txt";
        String expectedResult = "<result>" + this.getExpectedResult(resultFile) + "</result>";
        URL fileURL = this.bundle.getEntry(inputFile);
        this.loadDOMDocument(fileURL);
        XSModel schema = this.getGrammar();
        DefaultDynamicContext dc = this.setupDynamicContext(schema);
        this.loadCollection2Default((DynamicContext)dc);
        String xpath = "fn:collection(\"http://www.w3.org/2005/xpath-functions/collection2\")//*[text()[contains(.,\"TCP/IP\")]]";
        String actual = null;
        try {
            XPath path = this.compileXPath((DynamicContext)dc, xpath);
            DefaultEvaluator eval = new DefaultEvaluator((DynamicContext)dc, this.domDoc);
            ResultSequence rs = eval.evaluate((XPathNode)path);
            actual = "<result>" + this.buildXMLResultString(rs) + "</result>";
        }
        catch (XPathParserException ex) {
            actual = ex.code();
        }
        catch (StaticError ex) {
            actual = ex.code();
        }
        catch (DynamicError ex) {
            actual = ex.code();
        }
        this.assertXMLEqual("XPath Result Error " + xqFile + ":", expectedResult, actual);
    }

    public void test_fn_collection_8() throws Exception {
        String inputFile = "/TestSources/emptydoc.xml";
        String xqFile = "/Queries/XQuery/Functions/NodeSeqFunc/SeqCollectionFunc/fn-collection-8.xq";
        String resultFile = "/ExpectedTestResults/Functions/NodeSeqFunc/SeqCollectionFunc/fn-collection-8.txt";
        String expectedResult = "<result>" + this.getExpectedResult(resultFile) + "</result>";
        URL fileURL = this.bundle.getEntry(inputFile);
        this.loadDOMDocument(fileURL);
        XSModel schema = this.getGrammar();
        DefaultDynamicContext dc = this.setupDynamicContext(schema);
        this.loadCollection1Default((DynamicContext)dc);
        String xpath = "for $d in fn:collection(\"http://www.w3.org/2005/xpath-functions/collection1\") return ($d//title)[1]";
        String actual = null;
        try {
            XPath path = this.compileXPath((DynamicContext)dc, xpath);
            DefaultEvaluator eval = new DefaultEvaluator((DynamicContext)dc, this.domDoc);
            ResultSequence rs = eval.evaluate((XPathNode)path);
            actual = "<result>" + this.buildXMLResultString(rs) + "</result>";
        }
        catch (XPathParserException ex) {
            actual = ex.code();
        }
        catch (StaticError ex) {
            actual = ex.code();
        }
        catch (DynamicError ex) {
            actual = ex.code();
        }
        this.assertXMLEqual("XPath Result Error " + xqFile + ":", expectedResult, actual);
    }

    private void loadCollection1Default(DynamicContext dc) throws Exception {
        XercesLoader domload = new XercesLoader();
        URL fileURL = this.bundle.getEntry("/TestSources/bib.xml");
        Document dom1 = domload.load(fileURL.openStream());
        fileURL = this.bundle.getEntry("/TestSources/reviews.xml");
        Document dom2 = domload.load(fileURL.openStream());
        ArrayList<Document> arraylist = new ArrayList<Document>();
        arraylist.add(dom1);
        arraylist.add(dom2);
        HashMap<String, ArrayList<Document>> map = new HashMap<String, ArrayList<Document>>();
        map.put("http://www.w3.org/2005/xpath-functions/collection/default", arraylist);
        map.put(COLLECTION1, arraylist);
        dc.set_collections(map);
    }

    private void loadCollection2Default(DynamicContext dc) throws Exception {
        XercesLoader domload = new XercesLoader();
        URL fileURL = this.bundle.getEntry("/TestSources/bib.xml");
        Document dom1 = domload.load(fileURL.openStream());
        fileURL = this.bundle.getEntry("/TestSources/reviews.xml");
        Document dom2 = domload.load(fileURL.openStream());
        fileURL = this.bundle.getEntry("/TestSources/books.xml");
        Document dom3 = domload.load(fileURL.openStream());
        ArrayList<Document> arraylist = new ArrayList<Document>();
        arraylist.add(dom1);
        arraylist.add(dom2);
        arraylist.add(dom3);
        HashMap<String, ArrayList<Document>> map = new HashMap<String, ArrayList<Document>>();
        map.put("http://www.w3.org/2005/xpath-functions/collection/default", arraylist);
        map.put(COLLECTION2, arraylist);
        dc.set_collections(map);
    }
}

