/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsl.ui.tests.contentassist;

import java.io.File;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.xsl.ui.tests.AbstractSourceViewerTest;

public class TestElementCompletionProposal
extends AbstractSourceViewerTest {
    public void testXSLPropsoalAvailable() throws Exception {
        this.fileName = "testElementProposals.xsl";
        String xslFilePath = String.valueOf(this.projectName) + File.separator + this.fileName;
        this.loadFileForTesting(xslFilePath);
        IStructuredDocument document = (IStructuredDocument)this.sourceViewer.getDocument();
        int column = 16;
        int line = 5;
        int offset = document.getLineOffset(line) + column;
        ICompletionProposal[] proposals = this.getProposals(offset);
        TestElementCompletionProposal.assertNotNull((String)"Did not find proposals.", (Object)proposals);
    }

    public void testXSLApplyTemplatesPropsoalAvailable() throws Exception {
        this.fileName = "testElementProposals.xsl";
        String xslFilePath = String.valueOf(this.projectName) + File.separator + this.fileName;
        this.loadFileForTesting(xslFilePath);
        IStructuredDocument document = (IStructuredDocument)this.sourceViewer.getDocument();
        int column = 16;
        int line = 5;
        int offset = document.getLineOffset(line) + column;
        ICompletionProposal[] proposals = this.getProposals(offset);
        TestElementCompletionProposal.assertNotNull((String)"Did not find proposals.", (Object)proposals);
        String proposalName = "";
        int cnt = 0;
        while (cnt < proposals.length) {
            if (proposals[cnt].getDisplayString().equals("xsl:apply-templates")) {
                proposalName = proposals[cnt].getDisplayString();
            }
            ++cnt;
        }
        TestElementCompletionProposal.assertEquals((String)"Did not find expected proposal.", (String)"xsl:apply-templates", (String)proposalName);
    }

    public void testXSLChoosePropsoalAvailable() throws Exception {
        this.fileName = "testElementProposals.xsl";
        String xslFilePath = String.valueOf(this.projectName) + File.separator + this.fileName;
        this.loadFileForTesting(xslFilePath);
        IStructuredDocument document = (IStructuredDocument)this.sourceViewer.getDocument();
        int column = 16;
        int line = 5;
        int offset = document.getLineOffset(line) + column;
        ICompletionProposal[] proposals = this.getProposals(offset);
        TestElementCompletionProposal.assertNotNull((String)"Did not find proposals.", (Object)proposals);
        String proposalName = "";
        int cnt = 0;
        while (cnt < proposals.length) {
            if (proposals[cnt].getDisplayString().equals("xsl:choose")) {
                proposalName = proposals[cnt].getDisplayString();
            }
            ++cnt;
        }
        TestElementCompletionProposal.assertEquals((String)"Did not find expected proposal.", (String)"xsl:choose", (String)proposalName);
    }

    public void testXSLWhenPropsoalNotAvailable() throws Exception {
        this.fileName = "testElementProposals.xsl";
        String xslFilePath = String.valueOf(this.projectName) + File.separator + this.fileName;
        this.loadFileForTesting(xslFilePath);
        IStructuredDocument document = (IStructuredDocument)this.sourceViewer.getDocument();
        int column = 16;
        int line = 5;
        int offset = document.getLineOffset(line) + column;
        ICompletionProposal[] proposals = this.getProposals(offset);
        TestElementCompletionProposal.assertNotNull((String)"Did not find proposals.", (Object)proposals);
        String proposalName = "";
        int cnt = 0;
        while (cnt < proposals.length) {
            if (proposals[cnt].getDisplayString().equals("xsl:when")) {
                proposalName = proposals[cnt].getDisplayString();
            }
            ++cnt;
        }
        TestElementCompletionProposal.assertFalse((String)"xsl:when proposal found when it shouldn't have been.", (boolean)proposalName.equals("xsl:when"));
    }
}

