/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.utility;

import java.io.PrintWriter;
import java.io.Writer;

public class IndentingPrintWriter
extends PrintWriter {
    private final String indent;
    private int indentLevel;
    private boolean needsIndent;
    public static String DEFAULT_INDENT = "\t";

    public IndentingPrintWriter(Writer out) {
        this(out, DEFAULT_INDENT);
    }

    public IndentingPrintWriter(Writer out, String indent) {
        super(out);
        this.indent = indent;
        this.indentLevel = 0;
        this.needsIndent = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println() {
        Object object = this.lock;
        synchronized (object) {
            super.println();
            this.needsIndent = true;
        }
    }

    private void printIndent() {
        if (this.needsIndent) {
            this.needsIndent = false;
            int i = this.indentLevel;
            while (i-- > 0) {
                this.print(this.indent);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(char[] buf, int off, int len) {
        Object object = this.lock;
        synchronized (object) {
            this.printIndent();
            super.write(buf, off, len);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(int c) {
        Object object = this.lock;
        synchronized (object) {
            this.printIndent();
            super.write(c);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(String s, int off, int len) {
        Object object = this.lock;
        synchronized (object) {
            this.printIndent();
            super.write(s, off, len);
        }
    }

    public void indent() {
        this.incrementIndentLevel();
    }

    public void undent() {
        this.decrementIndentLevel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void incrementIndentLevel() {
        Object object = this.lock;
        synchronized (object) {
            ++this.indentLevel;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void decrementIndentLevel() {
        Object object = this.lock;
        synchronized (object) {
            --this.indentLevel;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getIndentLevel() {
        Object object = this.lock;
        synchronized (object) {
            return this.indentLevel;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int setIndentLevel(int indentLevel) {
        Object object = this.lock;
        synchronized (object) {
            int old = this.indentLevel;
            this.indentLevel = indentLevel;
            return old;
        }
    }
}

