/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.utility.tests.internal.iterables;

import java.util.ArrayList;
import junit.framework.TestCase;
import org.eclipse.jpt.utility.internal.Transformer;
import org.eclipse.jpt.utility.internal.iterables.TransformationIterable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransformationIterableTests
extends TestCase {
    public TransformationIterableTests(String name) {
        super(name);
    }

    public void testTransform1() {
        int i = 1;
        for (Integer integer : this.buildIterable1()) {
            TransformationIterableTests.assertEquals((int)i++, (int)integer);
        }
    }

    private Iterable<Integer> buildIterable1() {
        return this.buildTransformationIterable1(this.buildNestedIterable());
    }

    private Iterable<Integer> buildTransformationIterable1(Iterable<String> nestedIterable) {
        return new TransformationIterable<String, Integer>(nestedIterable){

            protected Integer transform(String next) {
                return new Integer(next.length());
            }
        };
    }

    public void testTransform2() {
        int i = 1;
        for (Integer integer : this.buildIterable2()) {
            TransformationIterableTests.assertEquals((int)i++, (int)integer);
        }
    }

    private Iterable<Integer> buildIterable2() {
        return this.buildTransformationIterable2(this.buildNestedIterable());
    }

    private Iterable<Integer> buildTransformationIterable2(Iterable<String> nestedIterable) {
        return new TransformationIterable(nestedIterable, this.buildTransformer());
    }

    private Transformer<String, Integer> buildTransformer() {
        return new Transformer<String, Integer>(){

            public Integer transform(String next) {
                return new Integer(next.length());
            }
        };
    }

    private Iterable<String> buildNestedIterable() {
        ArrayList<String> c = new ArrayList<String>();
        c.add("1");
        c.add("22");
        c.add("333");
        c.add("4444");
        c.add("55555");
        c.add("666666");
        c.add("7777777");
        c.add("88888888");
        return c;
    }

    public void testToString() {
        TransformationIterableTests.assertNotNull((Object)this.buildIterable1().toString());
    }

    public void testMissingTransformer() {
        TransformationIterable iterable = new TransformationIterable(this.buildNestedIterable());
        boolean exCaught = false;
        try {
            int i = 1;
            for (Integer integer : iterable) {
                TransformationIterableTests.assertEquals((int)i++, (int)integer);
            }
        }
        catch (RuntimeException runtimeException) {
            exCaught = true;
        }
        TransformationIterableTests.assertTrue((boolean)exCaught);
    }
}

