/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.utility.tests.internal.model;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashSet;
import java.util.List;
import junit.framework.TestCase;
import org.eclipse.jpt.utility.internal.ArrayTools;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.jpt.utility.internal.ListenerList;
import org.eclipse.jpt.utility.internal.ReflectionTools;
import org.eclipse.jpt.utility.internal.Tools;
import org.eclipse.jpt.utility.internal.model.AbstractModel;
import org.eclipse.jpt.utility.internal.model.ChangeSupport;
import org.eclipse.jpt.utility.model.Model;
import org.eclipse.jpt.utility.model.event.CollectionAddEvent;
import org.eclipse.jpt.utility.model.event.CollectionChangeEvent;
import org.eclipse.jpt.utility.model.event.CollectionClearEvent;
import org.eclipse.jpt.utility.model.event.CollectionEvent;
import org.eclipse.jpt.utility.model.event.CollectionRemoveEvent;
import org.eclipse.jpt.utility.model.event.ListAddEvent;
import org.eclipse.jpt.utility.model.event.ListChangeEvent;
import org.eclipse.jpt.utility.model.event.ListClearEvent;
import org.eclipse.jpt.utility.model.event.ListEvent;
import org.eclipse.jpt.utility.model.event.ListMoveEvent;
import org.eclipse.jpt.utility.model.event.ListRemoveEvent;
import org.eclipse.jpt.utility.model.event.ListReplaceEvent;
import org.eclipse.jpt.utility.model.event.PropertyChangeEvent;
import org.eclipse.jpt.utility.model.event.StateChangeEvent;
import org.eclipse.jpt.utility.model.event.TreeAddEvent;
import org.eclipse.jpt.utility.model.event.TreeChangeEvent;
import org.eclipse.jpt.utility.model.event.TreeClearEvent;
import org.eclipse.jpt.utility.model.event.TreeEvent;
import org.eclipse.jpt.utility.model.event.TreeRemoveEvent;
import org.eclipse.jpt.utility.model.listener.ChangeAdapter;
import org.eclipse.jpt.utility.model.listener.ChangeListener;
import org.eclipse.jpt.utility.model.listener.CollectionChangeAdapter;
import org.eclipse.jpt.utility.model.listener.CollectionChangeListener;
import org.eclipse.jpt.utility.model.listener.ListChangeAdapter;
import org.eclipse.jpt.utility.model.listener.ListChangeListener;
import org.eclipse.jpt.utility.model.listener.PropertyChangeAdapter;
import org.eclipse.jpt.utility.model.listener.PropertyChangeListener;
import org.eclipse.jpt.utility.model.listener.StateChangeAdapter;
import org.eclipse.jpt.utility.model.listener.StateChangeListener;
import org.eclipse.jpt.utility.model.listener.TreeChangeAdapter;
import org.eclipse.jpt.utility.model.listener.TreeChangeListener;
import org.eclipse.jpt.utility.tests.internal.TestTools;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChangeSupportTests
extends TestCase {
    TestModel testModel;
    static final String TEST_TO_STRING = "this is a test";
    ChangeListener changeListener = new Adapter();
    StateChangeEvent stateChangeEvent;
    boolean stateChangedCalled = false;
    PropertyChangeEvent propertyChangeEvent;
    boolean propertyChangeCalled = false;
    static final String PROPERTY_NAME = "propertyName";
    static final Object OLD_OBJECT_VALUE = new Object();
    static final Object NEW_OBJECT_VALUE = new Object();
    static final Integer OLD_INT_VALUE = new Integer(27);
    static final Boolean OLD_BOOLEAN_VALUE = Boolean.TRUE;
    static final Integer NEW_INT_VALUE = new Integer(42);
    static final Boolean NEW_BOOLEAN_VALUE = Boolean.FALSE;
    CollectionEvent collectionEvent;
    boolean itemsAddedCollectionCalled = false;
    boolean itemsRemovedCollectionCalled = false;
    boolean collectionChangedCalled = false;
    boolean collectionClearedCalled = false;
    static final String COLLECTION_NAME = "collectionName";
    static final Object ADDED_OBJECT_VALUE = new Object();
    static final Object ADDED_OBJECT_VALUE_2 = new Object();
    static final Object REMOVED_OBJECT_VALUE = new Object();
    static final int TARGET_INDEX = 7;
    static final int SOURCE_INDEX = 22;
    ListEvent listEvent;
    boolean itemsAddedListCalled = false;
    boolean itemsRemovedListCalled = false;
    boolean itemsReplacedListCalled = false;
    boolean itemsMovedListCalled = false;
    boolean listChangedCalled = false;
    boolean listClearedCalled = false;
    static final String LIST_NAME = "listName";
    static final int ADD_INDEX = 3;
    static final int REMOVE_INDEX = 5;
    static final int REPLACE_INDEX = 2;
    TreeEvent treeEvent;
    boolean nodeAddedCalled = false;
    boolean nodeRemovedCalled = false;
    boolean treeChangedCalled = false;
    boolean treeClearedCalled = false;
    static final String TREE_NAME = "treeName";
    static final List<Object> OBJECT_PATH = Arrays.asList(new Object(), new Object(), new String());
    private static final String ISE_MESSAGE = "this object is no longer listening to localA";

    public ChangeSupportTests(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.testModel = new TestModel();
    }

    protected void tearDown() throws Exception {
        TestTools.clear(this);
        super.tearDown();
    }

    public void testNullSource() {
        boolean exCaught = false;
        try {
            ChangeSupport cs = new ChangeSupport(null);
            ChangeSupportTests.fail((String)("bogus change support: " + cs));
        }
        catch (NullPointerException nullPointerException) {
            exCaught = true;
        }
        ChangeSupportTests.assertTrue((boolean)exCaught);
    }

    public void testFireStateChange() {
        this.stateChangeEvent = null;
        this.stateChangedCalled = false;
        this.testModel.addChangeListener(this.changeListener);
        this.testModel.testFireStateChange();
        ChangeSupportTests.assertNotNull((Object)this.stateChangeEvent);
        ChangeSupportTests.assertEquals((Object)this.testModel, (Object)this.stateChangeEvent.getSource());
        ChangeSupportTests.assertTrue((boolean)this.stateChangedCalled);
    }

    public void testHasAnyStateChangeListeners() {
        ChangeSupportTests.assertTrue((boolean)this.testModel.hasNoStateChangeListeners());
        this.testModel.addChangeListener(this.changeListener);
        ChangeSupportTests.assertTrue((boolean)this.testModel.hasAnyStateChangeListeners());
        this.testModel.removeChangeListener(this.changeListener);
        ChangeSupportTests.assertTrue((boolean)this.testModel.hasNoStateChangeListeners());
    }

    public void testHasAnyStateChangeListenersDuplicate() {
        ChangeSupportTests.assertTrue((boolean)this.testModel.hasNoStateChangeListeners());
        this.testModel.addChangeListener(this.changeListener);
        boolean exCaught = false;
        try {
            this.testModel.addChangeListener(this.changeListener);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            exCaught = true;
        }
        ChangeSupportTests.assertTrue((boolean)exCaught);
        ChangeSupportTests.assertTrue((boolean)this.testModel.hasAnyStateChangeListeners());
        this.testModel.removeChangeListener(this.changeListener);
        ChangeSupportTests.assertTrue((boolean)this.testModel.hasNoStateChangeListeners());
        exCaught = false;
        try {
            this.testModel.removeChangeListener(this.changeListener);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            exCaught = true;
        }
        ChangeSupportTests.assertTrue((boolean)this.testModel.hasNoStateChangeListeners());
    }

    public void testAddNullStateListener() {
        boolean exCaught = false;
        try {
            this.testModel.addStateChangeListener(null);
        }
        catch (NullPointerException nullPointerException) {
            exCaught = true;
        }
        ChangeSupportTests.assertTrue((boolean)exCaught);
    }

    public void testRemoveBogusStateListener() {
        boolean exCaught = false;
        try {
            this.testModel.removeChangeListener(this.changeListener);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            exCaught = true;
        }
        ChangeSupportTests.assertTrue((boolean)exCaught);
        this.testModel.addPropertyChangeListener("foo", (PropertyChangeListener)this.changeListener);
        exCaught = false;
        try {
            this.testModel.removeChangeListener(this.changeListener);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            exCaught = true;
        }
        ChangeSupportTests.assertTrue((boolean)exCaught);
        this.testModel.addChangeListener(this.changeListener);
        exCaught = false;
        try {
            this.testModel.removeStateChangeListener((StateChangeListener)new Adapter());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            exCaught = true;
        }
        ChangeSupportTests.assertTrue((boolean)exCaught);
        exCaught = false;
        try {
            this.testModel.removeStateChangeListener((StateChangeListener)new StateChangeAdapter());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            exCaught = true;
        }
        ChangeSupportTests.assertTrue((boolean)exCaught);
    }

    public void testFirePropertyChangedEvent() {
        this.propertyChangeEvent = null;
        this.propertyChangeCalled = false;
        this.testModel.addChangeListener(this.changeListener);
        this.testModel.testFirePropertyChangedEvent();
        this.verifyPropertyChangeEvent(OLD_OBJECT_VALUE, NEW_OBJECT_VALUE);
        ChangeSupportTests.assertTrue((boolean)this.propertyChangeCalled);
        this.propertyChangeEvent = null;
        this.propertyChangeCalled = false;
        this.testModel.removeChangeListener(this.changeListener);
        this.testModel.testFirePropertyChangedEvent();
        ChangeSupportTests.assertNull((Object)this.propertyChangeEvent);
        ChangeSupportTests.assertFalse((boolean)this.propertyChangeCalled);
        this.propertyChangeEvent = null;
        this.propertyChangeCalled = false;
        this.testModel.addPropertyChangeListener(PROPERTY_NAME, (PropertyChangeListener)this.changeListener);
        this.testModel.testFirePropertyChangedEvent();
        this.verifyPropertyChangeEvent(OLD_OBJECT_VALUE, NEW_OBJECT_VALUE);
        ChangeSupportTests.assertTrue((boolean)this.propertyChangeCalled);
        this.propertyChangeEvent = null;
        this.propertyChangeCalled = false;
        this.testModel.removePropertyChangeListener(PROPERTY_NAME, (PropertyChangeListener)this.changeListener);
        this.testModel.testFirePropertyChangedEvent();
        ChangeSupportTests.assertNull((Object)this.propertyChangeEvent);
        ChangeSupportTests.assertFalse((boolean)this.propertyChangeCalled);
    }

    public void testFirePropertyChangedEventNoChange() {
        this.propertyChangeEvent = null;
        this.propertyChangeCalled = false;
        this.testModel.addChangeListener(this.changeListener);
        this.testModel.testFirePropertyChangedEventNoChange();
        ChangeSupportTests.assertNull((Object)this.propertyChangeEvent);
        ChangeSupportTests.assertFalse((boolean)this.propertyChangeCalled);
        this.propertyChangeEvent = null;
        this.propertyChangeCalled = false;
        this.testModel.removeChangeListener(this.changeListener);
        this.testModel.testFirePropertyChangedEventNoChange();
        ChangeSupportTests.assertNull((Object)this.propertyChangeEvent);
        ChangeSupportTests.assertFalse((boolean)this.propertyChangeCalled);
        this.propertyChangeEvent = null;
        this.propertyChangeCalled = false;
        this.testModel.addPropertyChangeListener(PROPERTY_NAME, (PropertyChangeListener)this.changeListener);
        this.testModel.testFirePropertyChangedEventNoChange();
        ChangeSupportTests.assertNull((Object)this.propertyChangeEvent);
        ChangeSupportTests.assertFalse((boolean)this.propertyChangeCalled);
        this.propertyChangeEvent = null;
        this.propertyChangeCalled = false;
        this.testModel.removePropertyChangeListener(PROPERTY_NAME, (PropertyChangeListener)this.changeListener);
        this.testModel.testFirePropertyChangedEventNoChange();
        ChangeSupportTests.assertNull((Object)this.propertyChangeEvent);
        ChangeSupportTests.assertFalse((boolean)this.propertyChangeCalled);
    }

    public void testFirePropertyChangedObjectObject() {
        this.propertyChangeEvent = null;
        this.propertyChangeCalled = false;
        this.testModel.addChangeListener(this.changeListener);
        this.testModel.testFirePropertyChangedObjectObject();
        this.verifyPropertyChangeEvent(OLD_OBJECT_VALUE, NEW_OBJECT_VALUE);
        ChangeSupportTests.assertTrue((boolean)this.propertyChangeCalled);
        this.propertyChangeEvent = null;
        this.propertyChangeCalled = false;
        this.testModel.removeChangeListener(this.changeListener);
        this.testModel.testFirePropertyChangedObjectObject();
        ChangeSupportTests.assertNull((Object)this.propertyChangeEvent);
        ChangeSupportTests.assertFalse((boolean)this.propertyChangeCalled);
        this.propertyChangeEvent = null;
        this.propertyChangeCalled = false;
        this.testModel.addPropertyChangeListener(PROPERTY_NAME, (PropertyChangeListener)this.changeListener);
        this.testModel.testFirePropertyChangedObjectObject();
        this.verifyPropertyChangeEvent(OLD_OBJECT_VALUE, NEW_OBJECT_VALUE);
        ChangeSupportTests.assertTrue((boolean)this.propertyChangeCalled);
        this.propertyChangeEvent = null;
        this.propertyChangeCalled = false;
        this.testModel.removePropertyChangeListener(PROPERTY_NAME, (PropertyChangeListener)this.changeListener);
        this.testModel.testFirePropertyChangedObjectObject();
        ChangeSupportTests.assertNull((Object)this.propertyChangeEvent);
        ChangeSupportTests.assertFalse((boolean)this.propertyChangeCalled);
    }

    public void testFirePropertyChangedObjectObjectNoChange() {
        this.propertyChangeEvent = null;
        this.propertyChangeCalled = false;
        this.testModel.addChangeListener(this.changeListener);
        this.testModel.testFirePropertyChangedObjectObjectNoChange();
        ChangeSupportTests.assertNull((Object)this.propertyChangeEvent);
        ChangeSupportTests.assertFalse((boolean)this.propertyChangeCalled);
        this.propertyChangeEvent = null;
        this.propertyChangeCalled = false;
        this.testModel.removeChangeListener(this.changeListener);
        this.testModel.testFirePropertyChangedObjectObjectNoChange();
        ChangeSupportTests.assertNull((Object)this.propertyChangeEvent);
        ChangeSupportTests.assertFalse((boolean)this.propertyChangeCalled);
        this.propertyChangeEvent = null;
        this.propertyChangeCalled = false;
        this.testModel.addPropertyChangeListener(PROPERTY_NAME, (PropertyChangeListener)this.changeListener);
        this.testModel.testFirePropertyChangedObjectObjectNoChange();
        ChangeSupportTests.assertNull((Object)this.propertyChangeEvent);
        ChangeSupportTests.assertFalse((boolean)this.propertyChangeCalled);
        this.propertyChangeEvent = null;
        this.propertyChangeCalled = false;
        this.testModel.removePropertyChangeListener(PROPERTY_NAME, (PropertyChangeListener)this.changeListener);
        this.testModel.testFirePropertyChangedObjectObjectNoChange();
        ChangeSupportTests.assertNull((Object)this.propertyChangeEvent);
        ChangeSupportTests.assertFalse((boolean)this.propertyChangeCalled);
    }

    public void testFirePropertyChangedObject() {
        this.propertyChangeEvent = null;
        this.propertyChangeCalled = false;
        this.testModel.addChangeListener(this.changeListener);
        this.testModel.testFirePropertyChangedObject();
        this.verifyPropertyChangeEvent(null, NEW_OBJECT_VALUE);
        ChangeSupportTests.assertTrue((boolean)this.propertyChangeCalled);
        this.propertyChangeEvent = null;
        this.propertyChangeCalled = false;
        this.testModel.removeChangeListener(this.changeListener);
        this.testModel.testFirePropertyChangedObject();
        ChangeSupportTests.assertNull((Object)this.propertyChangeEvent);
        ChangeSupportTests.assertFalse((boolean)this.propertyChangeCalled);
        this.propertyChangeEvent = null;
        this.propertyChangeCalled = false;
        this.testModel.addPropertyChangeListener(PROPERTY_NAME, (PropertyChangeListener)this.changeListener);
        this.testModel.testFirePropertyChangedObject();
        this.verifyPropertyChangeEvent(null, NEW_OBJECT_VALUE);
        ChangeSupportTests.assertTrue((boolean)this.propertyChangeCalled);
        this.propertyChangeEvent = null;
        this.propertyChangeCalled = false;
        this.testModel.removePropertyChangeListener(PROPERTY_NAME, (PropertyChangeListener)this.changeListener);
        this.testModel.testFirePropertyChangedObject();
        ChangeSupportTests.assertNull((Object)this.propertyChangeEvent);
        ChangeSupportTests.assertFalse((boolean)this.propertyChangeCalled);
    }

    public void testFirePropertyChangedObjectNoChange() {
        this.propertyChangeEvent = null;
        this.propertyChangeCalled = false;
        this.testModel.addChangeListener(this.changeListener);
        this.testModel.testFirePropertyChangedObjectNoChange();
        ChangeSupportTests.assertNull((Object)this.propertyChangeEvent);
        ChangeSupportTests.assertFalse((boolean)this.propertyChangeCalled);
        this.propertyChangeEvent = null;
        this.propertyChangeCalled = false;
        this.testModel.removeChangeListener(this.changeListener);
        this.testModel.testFirePropertyChangedObjectNoChange();
        ChangeSupportTests.assertNull((Object)this.propertyChangeEvent);
        ChangeSupportTests.assertFalse((boolean)this.propertyChangeCalled);
        this.propertyChangeEvent = null;
        this.propertyChangeCalled = false;
        this.testModel.addPropertyChangeListener(PROPERTY_NAME, (PropertyChangeListener)this.changeListener);
        this.testModel.testFirePropertyChangedObjectNoChange();
        ChangeSupportTests.assertNull((Object)this.propertyChangeEvent);
        ChangeSupportTests.assertFalse((boolean)this.propertyChangeCalled);
        this.propertyChangeEvent = null;
        this.propertyChangeCalled = false;
        this.testModel.removePropertyChangeListener(PROPERTY_NAME, (PropertyChangeListener)this.changeListener);
        this.testModel.testFirePropertyChangedObjectNoChange();
        ChangeSupportTests.assertNull((Object)this.propertyChangeEvent);
        ChangeSupportTests.assertFalse((boolean)this.propertyChangeCalled);
    }

    public void testFirePropertyChangedIntInt() {
        this.propertyChangeEvent = null;
        this.propertyChangeCalled = false;
        this.testModel.addChangeListener(this.changeListener);
        this.testModel.testFirePropertyChangedIntInt();
        this.verifyPropertyChangeEvent(OLD_INT_VALUE, NEW_INT_VALUE);
        ChangeSupportTests.assertTrue((boolean)this.propertyChangeCalled);
        this.propertyChangeEvent = null;
        this.propertyChangeCalled = false;
        this.testModel.removeChangeListener(this.changeListener);
        this.testModel.testFirePropertyChangedIntInt();
        ChangeSupportTests.assertNull((Object)this.propertyChangeEvent);
        ChangeSupportTests.assertFalse((boolean)this.propertyChangeCalled);
        this.propertyChangeEvent = null;
        this.propertyChangeCalled = false;
        this.testModel.addPropertyChangeListener(PROPERTY_NAME, (PropertyChangeListener)this.changeListener);
        this.testModel.testFirePropertyChangedIntInt();
        this.verifyPropertyChangeEvent(OLD_INT_VALUE, NEW_INT_VALUE);
        ChangeSupportTests.assertTrue((boolean)this.propertyChangeCalled);
        this.propertyChangeEvent = null;
        this.propertyChangeCalled = false;
        this.testModel.removePropertyChangeListener(PROPERTY_NAME, (PropertyChangeListener)this.changeListener);
        this.testModel.testFirePropertyChangedIntInt();
        ChangeSupportTests.assertNull((Object)this.propertyChangeEvent);
        ChangeSupportTests.assertFalse((boolean)this.propertyChangeCalled);
    }

    public void testFirePropertyChangedIntIntNoChange() {
        this.propertyChangeEvent = null;
        this.propertyChangeCalled = false;
        this.testModel.addChangeListener(this.changeListener);
        this.testModel.testFirePropertyChangedIntIntNoChange();
        ChangeSupportTests.assertNull((Object)this.propertyChangeEvent);
        ChangeSupportTests.assertFalse((boolean)this.propertyChangeCalled);
        this.propertyChangeEvent = null;
        this.propertyChangeCalled = false;
        this.testModel.removeChangeListener(this.changeListener);
        this.testModel.testFirePropertyChangedIntIntNoChange();
        ChangeSupportTests.assertNull((Object)this.propertyChangeEvent);
        ChangeSupportTests.assertFalse((boolean)this.propertyChangeCalled);
        this.propertyChangeEvent = null;
        this.propertyChangeCalled = false;
        this.testModel.addPropertyChangeListener(PROPERTY_NAME, (PropertyChangeListener)this.changeListener);
        this.testModel.testFirePropertyChangedIntIntNoChange();
        ChangeSupportTests.assertNull((Object)this.propertyChangeEvent);
        ChangeSupportTests.assertFalse((boolean)this.propertyChangeCalled);
        this.propertyChangeEvent = null;
        this.propertyChangeCalled = false;
        this.testModel.removePropertyChangeListener(PROPERTY_NAME, (PropertyChangeListener)this.changeListener);
        this.testModel.testFirePropertyChangedIntIntNoChange();
        ChangeSupportTests.assertNull((Object)this.propertyChangeEvent);
        ChangeSupportTests.assertFalse((boolean)this.propertyChangeCalled);
    }

    public void testFirePropertyChangedBooleanBoolean() {
        this.propertyChangeEvent = null;
        this.propertyChangeCalled = false;
        this.testModel.addChangeListener(this.changeListener);
        this.testModel.testFirePropertyChangedBooleanBoolean();
        this.verifyPropertyChangeEvent(OLD_BOOLEAN_VALUE, NEW_BOOLEAN_VALUE);
        ChangeSupportTests.assertTrue((boolean)this.propertyChangeCalled);
        this.propertyChangeEvent = null;
        this.propertyChangeCalled = false;
        this.testModel.removeChangeListener(this.changeListener);
        this.testModel.testFirePropertyChangedBooleanBoolean();
        ChangeSupportTests.assertNull((Object)this.propertyChangeEvent);
        ChangeSupportTests.assertFalse((boolean)this.propertyChangeCalled);
        this.propertyChangeEvent = null;
        this.propertyChangeCalled = false;
        this.testModel.addPropertyChangeListener(PROPERTY_NAME, (PropertyChangeListener)this.changeListener);
        this.testModel.testFirePropertyChangedBooleanBoolean();
        this.verifyPropertyChangeEvent(OLD_BOOLEAN_VALUE, NEW_BOOLEAN_VALUE);
        ChangeSupportTests.assertTrue((boolean)this.propertyChangeCalled);
        this.propertyChangeEvent = null;
        this.propertyChangeCalled = false;
        this.testModel.removePropertyChangeListener(PROPERTY_NAME, (PropertyChangeListener)this.changeListener);
        this.testModel.testFirePropertyChangedBooleanBoolean();
        ChangeSupportTests.assertNull((Object)this.propertyChangeEvent);
        ChangeSupportTests.assertFalse((boolean)this.propertyChangeCalled);
    }

    public void testFirePropertyChangedBooleanBooleanNoChange() {
        this.propertyChangeEvent = null;
        this.propertyChangeCalled = false;
        this.testModel.addChangeListener(this.changeListener);
        this.testModel.testFirePropertyChangedBooleanBooleanNoChange();
        ChangeSupportTests.assertNull((Object)this.propertyChangeEvent);
        ChangeSupportTests.assertFalse((boolean)this.propertyChangeCalled);
        this.propertyChangeEvent = null;
        this.propertyChangeCalled = false;
        this.testModel.removeChangeListener(this.changeListener);
        this.testModel.testFirePropertyChangedBooleanBooleanNoChange();
        ChangeSupportTests.assertNull((Object)this.propertyChangeEvent);
        ChangeSupportTests.assertFalse((boolean)this.propertyChangeCalled);
        this.propertyChangeEvent = null;
        this.propertyChangeCalled = false;
        this.testModel.addPropertyChangeListener(PROPERTY_NAME, (PropertyChangeListener)this.changeListener);
        this.testModel.testFirePropertyChangedBooleanBooleanNoChange();
        ChangeSupportTests.assertNull((Object)this.propertyChangeEvent);
        ChangeSupportTests.assertFalse((boolean)this.propertyChangeCalled);
        this.propertyChangeEvent = null;
        this.propertyChangeCalled = false;
        this.testModel.removePropertyChangeListener(PROPERTY_NAME, (PropertyChangeListener)this.changeListener);
        this.testModel.testFirePropertyChangedBooleanBooleanNoChange();
        ChangeSupportTests.assertNull((Object)this.propertyChangeEvent);
        ChangeSupportTests.assertFalse((boolean)this.propertyChangeCalled);
    }

    public void testHasAnyPropertyChangeListeners() {
        ChangeSupportTests.assertTrue((boolean)this.testModel.hasNoPropertyChangeListeners(PROPERTY_NAME));
        this.testModel.addChangeListener(this.changeListener);
        ChangeSupportTests.assertTrue((boolean)this.testModel.hasAnyPropertyChangeListeners(PROPERTY_NAME));
        this.testModel.removeChangeListener(this.changeListener);
        ChangeSupportTests.assertTrue((boolean)this.testModel.hasNoPropertyChangeListeners(PROPERTY_NAME));
        ChangeSupportTests.assertTrue((boolean)this.testModel.hasNoPropertyChangeListeners(PROPERTY_NAME));
        this.testModel.addPropertyChangeListener(PROPERTY_NAME, (PropertyChangeListener)this.changeListener);
        ChangeSupportTests.assertTrue((boolean)this.testModel.hasAnyPropertyChangeListeners(PROPERTY_NAME));
        this.testModel.removePropertyChangeListener(PROPERTY_NAME, (PropertyChangeListener)this.changeListener);
        ChangeSupportTests.assertTrue((boolean)this.testModel.hasNoPropertyChangeListeners(PROPERTY_NAME));
    }

    public void testAddNullPropertyListener() {
        boolean exCaught = false;
        try {
            this.testModel.addChangeListener(null);
        }
        catch (NullPointerException nullPointerException) {
            exCaught = true;
        }
        ChangeSupportTests.assertTrue((boolean)exCaught);
    }

    public void testAddNullPropertyListenerName() {
        boolean exCaught = false;
        try {
            this.testModel.addPropertyChangeListener("foo", null);
        }
        catch (NullPointerException nullPointerException) {
            exCaught = true;
        }
        ChangeSupportTests.assertTrue((boolean)exCaught);
    }

    public void testRemoveBogusPropertyListener() {
        boolean exCaught = false;
        try {
            this.testModel.removePropertyChangeListener("foo", (PropertyChangeListener)new PropertyChangeAdapter());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            exCaught = true;
        }
        ChangeSupportTests.assertTrue((boolean)exCaught);
        this.testModel.addCollectionChangeListener("foo", (CollectionChangeListener)this.changeListener);
        exCaught = false;
        try {
            this.testModel.removePropertyChangeListener("foo", (PropertyChangeListener)this.changeListener);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            exCaught = true;
        }
        ChangeSupportTests.assertTrue((boolean)exCaught);
        this.testModel.addPropertyChangeListener("foo", (PropertyChangeListener)this.changeListener);
        exCaught = false;
        try {
            this.testModel.removePropertyChangeListener("foo", (PropertyChangeListener)new PropertyChangeAdapter());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            exCaught = true;
        }
        ChangeSupportTests.assertTrue((boolean)exCaught);
        exCaught = false;
        try {
            this.testModel.removePropertyChangeListener("foo", (PropertyChangeListener)new PropertyChangeAdapter());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            exCaught = true;
        }
        ChangeSupportTests.assertTrue((boolean)exCaught);
    }

    private void verifyPropertyChangeEvent(Object oldValue, Object newValue) {
        this.verifyPropertyChangeEvent(this.testModel, oldValue, newValue);
    }

    private void verifyPropertyChangeEvent(Object source, Object oldValue, Object newValue) {
        ChangeSupportTests.assertNotNull((Object)this.propertyChangeEvent);
        ChangeSupportTests.assertEquals((Object)source, (Object)this.propertyChangeEvent.getSource());
        ChangeSupportTests.assertEquals((String)PROPERTY_NAME, (String)this.propertyChangeEvent.getPropertyName());
        ChangeSupportTests.assertEquals((Object)oldValue, (Object)this.propertyChangeEvent.getOldValue());
        ChangeSupportTests.assertEquals((Object)newValue, (Object)this.propertyChangeEvent.getNewValue());
    }

    public void testFireItemsAddedCollectionEvent() {
        this.collectionEvent = null;
        this.itemsAddedCollectionCalled = false;
        this.testModel.addChangeListener(this.changeListener);
        this.testModel.testFireItemsAddedCollectionEvent();
        this.verifyCollectionEvent(ADDED_OBJECT_VALUE);
        ChangeSupportTests.assertTrue((boolean)this.itemsAddedCollectionCalled);
        this.collectionEvent = null;
        this.itemsAddedCollectionCalled = false;
        this.testModel.removeChangeListener(this.changeListener);
        this.testModel.testFireItemsAddedCollectionEvent();
        ChangeSupportTests.assertNull((Object)this.collectionEvent);
        ChangeSupportTests.assertFalse((boolean)this.itemsAddedCollectionCalled);
        this.collectionEvent = null;
        this.itemsAddedCollectionCalled = false;
        this.testModel.addCollectionChangeListener(COLLECTION_NAME, (CollectionChangeListener)this.changeListener);
        this.testModel.testFireItemsAddedCollectionEvent();
        this.verifyCollectionEvent(ADDED_OBJECT_VALUE);
        ChangeSupportTests.assertTrue((boolean)this.itemsAddedCollectionCalled);
        this.collectionEvent = null;
        this.itemsAddedCollectionCalled = false;
        this.testModel.removeCollectionChangeListener(COLLECTION_NAME, (CollectionChangeListener)this.changeListener);
        this.testModel.testFireItemsAddedCollectionEvent();
        ChangeSupportTests.assertNull((Object)this.collectionEvent);
        ChangeSupportTests.assertFalse((boolean)this.itemsAddedCollectionCalled);
    }

    public void testFireItemsAddedCollectionEventNoChange() {
        this.collectionEvent = null;
        this.itemsAddedCollectionCalled = false;
        this.testModel.addChangeListener(this.changeListener);
        this.testModel.testFireItemsAddedCollectionEventNoChange();
        ChangeSupportTests.assertNull((Object)this.collectionEvent);
        ChangeSupportTests.assertFalse((boolean)this.itemsAddedCollectionCalled);
        this.collectionEvent = null;
        this.itemsAddedCollectionCalled = false;
        this.testModel.removeChangeListener(this.changeListener);
        this.testModel.testFireItemsAddedCollectionEventNoChange();
        ChangeSupportTests.assertNull((Object)this.collectionEvent);
        ChangeSupportTests.assertFalse((boolean)this.itemsAddedCollectionCalled);
        this.collectionEvent = null;
        this.itemsAddedCollectionCalled = false;
        this.testModel.addCollectionChangeListener(COLLECTION_NAME, (CollectionChangeListener)this.changeListener);
        this.testModel.testFireItemsAddedCollectionEventNoChange();
        ChangeSupportTests.assertNull((Object)this.collectionEvent);
        ChangeSupportTests.assertFalse((boolean)this.itemsAddedCollectionCalled);
        this.collectionEvent = null;
        this.itemsAddedCollectionCalled = false;
        this.testModel.removeCollectionChangeListener(COLLECTION_NAME, (CollectionChangeListener)this.changeListener);
        this.testModel.testFireItemsAddedCollectionEventNoChange();
        ChangeSupportTests.assertNull((Object)this.collectionEvent);
        ChangeSupportTests.assertFalse((boolean)this.itemsAddedCollectionCalled);
    }

    public void testFireItemsAddedCollection() {
        this.collectionEvent = null;
        this.itemsAddedCollectionCalled = false;
        this.testModel.addChangeListener(this.changeListener);
        this.testModel.testFireItemsAddedCollection();
        this.verifyCollectionEvent(ADDED_OBJECT_VALUE);
        ChangeSupportTests.assertTrue((boolean)this.itemsAddedCollectionCalled);
        this.collectionEvent = null;
        this.itemsAddedCollectionCalled = false;
        this.testModel.removeChangeListener(this.changeListener);
        this.testModel.testFireItemsAddedCollection();
        ChangeSupportTests.assertNull((Object)this.collectionEvent);
        ChangeSupportTests.assertFalse((boolean)this.itemsAddedCollectionCalled);
        this.collectionEvent = null;
        this.itemsAddedCollectionCalled = false;
        this.testModel.addCollectionChangeListener(COLLECTION_NAME, (CollectionChangeListener)this.changeListener);
        this.testModel.testFireItemsAddedCollection();
        this.verifyCollectionEvent(ADDED_OBJECT_VALUE);
        ChangeSupportTests.assertTrue((boolean)this.itemsAddedCollectionCalled);
        this.collectionEvent = null;
        this.itemsAddedCollectionCalled = false;
        this.testModel.removeCollectionChangeListener(COLLECTION_NAME, (CollectionChangeListener)this.changeListener);
        this.testModel.testFireItemsAddedCollection();
        ChangeSupportTests.assertNull((Object)this.collectionEvent);
        ChangeSupportTests.assertFalse((boolean)this.itemsAddedCollectionCalled);
    }

    public void testFireItemsAddedCollectionNoChange() {
        this.collectionEvent = null;
        this.itemsAddedCollectionCalled = false;
        this.testModel.addChangeListener(this.changeListener);
        this.testModel.testFireItemsAddedCollectionNoChange();
        ChangeSupportTests.assertNull((Object)this.collectionEvent);
        ChangeSupportTests.assertFalse((boolean)this.itemsAddedCollectionCalled);
        this.collectionEvent = null;
        this.itemsAddedCollectionCalled = false;
        this.testModel.removeChangeListener(this.changeListener);
        this.testModel.testFireItemsAddedCollectionNoChange();
        ChangeSupportTests.assertNull((Object)this.collectionEvent);
        ChangeSupportTests.assertFalse((boolean)this.itemsAddedCollectionCalled);
        this.collectionEvent = null;
        this.itemsAddedCollectionCalled = false;
        this.testModel.addCollectionChangeListener(COLLECTION_NAME, (CollectionChangeListener)this.changeListener);
        this.testModel.testFireItemsAddedCollectionNoChange();
        ChangeSupportTests.assertNull((Object)this.collectionEvent);
        ChangeSupportTests.assertFalse((boolean)this.itemsAddedCollectionCalled);
        this.collectionEvent = null;
        this.itemsAddedCollectionCalled = false;
        this.testModel.removeCollectionChangeListener(COLLECTION_NAME, (CollectionChangeListener)this.changeListener);
        this.testModel.testFireItemsAddedCollectionNoChange();
        ChangeSupportTests.assertNull((Object)this.collectionEvent);
        ChangeSupportTests.assertFalse((boolean)this.itemsAddedCollectionCalled);
    }

    public void testFireItemAddedCollection() {
        this.collectionEvent = null;
        this.itemsAddedCollectionCalled = false;
        this.testModel.addChangeListener(this.changeListener);
        this.testModel.testFireItemAddedCollection();
        this.verifyCollectionEvent(ADDED_OBJECT_VALUE);
        ChangeSupportTests.assertTrue((boolean)this.itemsAddedCollectionCalled);
        this.collectionEvent = null;
        this.itemsAddedCollectionCalled = false;
        this.testModel.removeChangeListener(this.changeListener);
        this.testModel.testFireItemAddedCollection();
        ChangeSupportTests.assertNull((Object)this.collectionEvent);
        ChangeSupportTests.assertFalse((boolean)this.itemsAddedCollectionCalled);
        this.collectionEvent = null;
        this.itemsAddedCollectionCalled = false;
        this.testModel.addCollectionChangeListener(COLLECTION_NAME, (CollectionChangeListener)this.changeListener);
        this.testModel.testFireItemAddedCollection();
        this.verifyCollectionEvent(ADDED_OBJECT_VALUE);
        ChangeSupportTests.assertTrue((boolean)this.itemsAddedCollectionCalled);
        this.collectionEvent = null;
        this.itemsAddedCollectionCalled = false;
        this.testModel.removeCollectionChangeListener(COLLECTION_NAME, (CollectionChangeListener)this.changeListener);
        this.testModel.testFireItemAddedCollection();
        ChangeSupportTests.assertNull((Object)this.collectionEvent);
        ChangeSupportTests.assertFalse((boolean)this.itemsAddedCollectionCalled);
    }

    public void testFireItemsRemovedCollectionEvent() {
        this.collectionEvent = null;
        this.itemsRemovedCollectionCalled = false;
        this.testModel.addChangeListener(this.changeListener);
        this.testModel.testFireItemsRemovedCollectionEvent();
        this.verifyCollectionEvent(REMOVED_OBJECT_VALUE);
        ChangeSupportTests.assertTrue((boolean)this.itemsRemovedCollectionCalled);
        this.collectionEvent = null;
        this.itemsRemovedCollectionCalled = false;
        this.testModel.removeChangeListener(this.changeListener);
        this.testModel.testFireItemsRemovedCollectionEvent();
        ChangeSupportTests.assertNull((Object)this.collectionEvent);
        ChangeSupportTests.assertFalse((boolean)this.itemsRemovedCollectionCalled);
        this.collectionEvent = null;
        this.itemsRemovedCollectionCalled = false;
        this.testModel.addCollectionChangeListener(COLLECTION_NAME, (CollectionChangeListener)this.changeListener);
        this.testModel.testFireItemsRemovedCollectionEvent();
        this.verifyCollectionEvent(REMOVED_OBJECT_VALUE);
        ChangeSupportTests.assertTrue((boolean)this.itemsRemovedCollectionCalled);
        this.collectionEvent = null;
        this.itemsRemovedCollectionCalled = false;
        this.testModel.removeCollectionChangeListener(COLLECTION_NAME, (CollectionChangeListener)this.changeListener);
        this.testModel.testFireItemsRemovedCollectionEvent();
        ChangeSupportTests.assertNull((Object)this.collectionEvent);
        ChangeSupportTests.assertFalse((boolean)this.itemsRemovedCollectionCalled);
    }

    public void testFireItemsRemovedCollectionEventNoChange() {
        this.collectionEvent = null;
        this.itemsRemovedCollectionCalled = false;
        this.testModel.addChangeListener(this.changeListener);
        this.testModel.testFireItemsRemovedCollectionEventNoChange();
        ChangeSupportTests.assertNull((Object)this.collectionEvent);
        ChangeSupportTests.assertFalse((boolean)this.itemsRemovedCollectionCalled);
        this.collectionEvent = null;
        this.itemsRemovedCollectionCalled = false;
        this.testModel.removeChangeListener(this.changeListener);
        this.testModel.testFireItemsRemovedCollectionEventNoChange();
        ChangeSupportTests.assertNull((Object)this.collectionEvent);
        ChangeSupportTests.assertFalse((boolean)this.itemsRemovedCollectionCalled);
        this.collectionEvent = null;
        this.itemsRemovedCollectionCalled = false;
        this.testModel.addCollectionChangeListener(COLLECTION_NAME, (CollectionChangeListener)this.changeListener);
        this.testModel.testFireItemsRemovedCollectionEventNoChange();
        ChangeSupportTests.assertNull((Object)this.collectionEvent);
        ChangeSupportTests.assertFalse((boolean)this.itemsRemovedCollectionCalled);
        this.collectionEvent = null;
        this.itemsRemovedCollectionCalled = false;
        this.testModel.removeCollectionChangeListener(COLLECTION_NAME, (CollectionChangeListener)this.changeListener);
        this.testModel.testFireItemsRemovedCollectionEventNoChange();
        ChangeSupportTests.assertNull((Object)this.collectionEvent);
        ChangeSupportTests.assertFalse((boolean)this.itemsRemovedCollectionCalled);
    }

    public void testFireItemsRemovedCollection() {
        this.collectionEvent = null;
        this.itemsRemovedCollectionCalled = false;
        this.testModel.addChangeListener(this.changeListener);
        this.testModel.testFireItemsRemovedCollection();
        this.verifyCollectionEvent(REMOVED_OBJECT_VALUE);
        ChangeSupportTests.assertTrue((boolean)this.itemsRemovedCollectionCalled);
        this.collectionEvent = null;
        this.itemsRemovedCollectionCalled = false;
        this.testModel.removeChangeListener(this.changeListener);
        this.testModel.testFireItemsRemovedCollection();
        ChangeSupportTests.assertNull((Object)this.collectionEvent);
        ChangeSupportTests.assertFalse((boolean)this.itemsRemovedCollectionCalled);
        this.collectionEvent = null;
        this.itemsRemovedCollectionCalled = false;
        this.testModel.addCollectionChangeListener(COLLECTION_NAME, (CollectionChangeListener)this.changeListener);
        this.testModel.testFireItemsRemovedCollection();
        this.verifyCollectionEvent(REMOVED_OBJECT_VALUE);
        ChangeSupportTests.assertTrue((boolean)this.itemsRemovedCollectionCalled);
        this.collectionEvent = null;
        this.itemsRemovedCollectionCalled = false;
        this.testModel.removeCollectionChangeListener(COLLECTION_NAME, (CollectionChangeListener)this.changeListener);
        this.testModel.testFireItemsRemovedCollection();
        ChangeSupportTests.assertNull((Object)this.collectionEvent);
        ChangeSupportTests.assertFalse((boolean)this.itemsRemovedCollectionCalled);
    }

    public void testFireItemsRemovedCollectionNoChange() {
        this.collectionEvent = null;
        this.itemsRemovedCollectionCalled = false;
        this.testModel.addChangeListener(this.changeListener);
        this.testModel.testFireItemsRemovedCollectionNoChange();
        ChangeSupportTests.assertNull((Object)this.collectionEvent);
        ChangeSupportTests.assertFalse((boolean)this.itemsRemovedCollectionCalled);
        this.collectionEvent = null;
        this.itemsRemovedCollectionCalled = false;
        this.testModel.removeChangeListener(this.changeListener);
        this.testModel.testFireItemsRemovedCollectionNoChange();
        ChangeSupportTests.assertNull((Object)this.collectionEvent);
        ChangeSupportTests.assertFalse((boolean)this.itemsRemovedCollectionCalled);
        this.collectionEvent = null;
        this.itemsRemovedCollectionCalled = false;
        this.testModel.addCollectionChangeListener(COLLECTION_NAME, (CollectionChangeListener)this.changeListener);
        this.testModel.testFireItemsRemovedCollectionNoChange();
        ChangeSupportTests.assertNull((Object)this.collectionEvent);
        ChangeSupportTests.assertFalse((boolean)this.itemsRemovedCollectionCalled);
        this.collectionEvent = null;
        this.itemsRemovedCollectionCalled = false;
        this.testModel.removeCollectionChangeListener(COLLECTION_NAME, (CollectionChangeListener)this.changeListener);
        this.testModel.testFireItemsRemovedCollectionNoChange();
        ChangeSupportTests.assertNull((Object)this.collectionEvent);
        ChangeSupportTests.assertFalse((boolean)this.itemsRemovedCollectionCalled);
    }

    public void testFireItemRemovedCollection() {
        this.collectionEvent = null;
        this.itemsRemovedCollectionCalled = false;
        this.testModel.addChangeListener(this.changeListener);
        this.testModel.testFireItemRemovedCollection();
        this.verifyCollectionEvent(REMOVED_OBJECT_VALUE);
        ChangeSupportTests.assertTrue((boolean)this.itemsRemovedCollectionCalled);
        this.collectionEvent = null;
        this.itemsRemovedCollectionCalled = false;
        this.testModel.removeChangeListener(this.changeListener);
        this.testModel.testFireItemRemovedCollection();
        ChangeSupportTests.assertNull((Object)this.collectionEvent);
        ChangeSupportTests.assertFalse((boolean)this.itemsRemovedCollectionCalled);
        this.collectionEvent = null;
        this.itemsRemovedCollectionCalled = false;
        this.testModel.addCollectionChangeListener(COLLECTION_NAME, (CollectionChangeListener)this.changeListener);
        this.testModel.testFireItemRemovedCollection();
        this.verifyCollectionEvent(REMOVED_OBJECT_VALUE);
        ChangeSupportTests.assertTrue((boolean)this.itemsRemovedCollectionCalled);
        this.collectionEvent = null;
        this.itemsRemovedCollectionCalled = false;
        this.testModel.removeCollectionChangeListener(COLLECTION_NAME, (CollectionChangeListener)this.changeListener);
        this.testModel.testFireItemRemovedCollection();
        ChangeSupportTests.assertNull((Object)this.collectionEvent);
        ChangeSupportTests.assertFalse((boolean)this.itemsRemovedCollectionCalled);
    }

    public void testFireCollectionCleared() {
        this.collectionEvent = null;
        this.collectionClearedCalled = false;
        this.testModel.addChangeListener(this.changeListener);
        this.testModel.testFireCollectionCleared();
        this.verifyCollectionEvent(null);
        ChangeSupportTests.assertTrue((boolean)this.collectionClearedCalled);
        this.collectionEvent = null;
        this.collectionClearedCalled = false;
        this.testModel.removeChangeListener(this.changeListener);
        this.testModel.testFireCollectionCleared();
        ChangeSupportTests.assertNull((Object)this.collectionEvent);
        ChangeSupportTests.assertFalse((boolean)this.collectionClearedCalled);
        this.collectionEvent = null;
        this.collectionClearedCalled = false;
        this.testModel.addCollectionChangeListener(COLLECTION_NAME, (CollectionChangeListener)this.changeListener);
        this.testModel.testFireCollectionCleared();
        this.verifyCollectionEvent(null);
        ChangeSupportTests.assertTrue((boolean)this.collectionClearedCalled);
        this.collectionEvent = null;
        this.collectionClearedCalled = false;
        this.testModel.removeCollectionChangeListener(COLLECTION_NAME, (CollectionChangeListener)this.changeListener);
        this.testModel.testFireCollectionCleared();
        ChangeSupportTests.assertNull((Object)this.collectionEvent);
        ChangeSupportTests.assertFalse((boolean)this.collectionClearedCalled);
    }

    public void testFireCollectionChangedEvent() {
        this.collectionEvent = null;
        this.collectionChangedCalled = false;
        this.testModel.addChangeListener(this.changeListener);
        this.testModel.testFireCollectionChangedEvent();
        this.verifyCollectionEvent(null);
        ChangeSupportTests.assertTrue((boolean)this.collectionChangedCalled);
        this.collectionEvent = null;
        this.collectionChangedCalled = false;
        this.testModel.removeChangeListener(this.changeListener);
        this.testModel.testFireCollectionChangedEvent();
        ChangeSupportTests.assertNull((Object)this.collectionEvent);
        ChangeSupportTests.assertFalse((boolean)this.collectionChangedCalled);
        this.collectionEvent = null;
        this.collectionChangedCalled = false;
        this.testModel.addCollectionChangeListener(COLLECTION_NAME, (CollectionChangeListener)this.changeListener);
        this.testModel.testFireCollectionChangedEvent();
        this.verifyCollectionEvent(null);
        ChangeSupportTests.assertTrue((boolean)this.collectionChangedCalled);
        this.collectionEvent = null;
        this.collectionChangedCalled = false;
        this.testModel.removeCollectionChangeListener(COLLECTION_NAME, (CollectionChangeListener)this.changeListener);
        this.testModel.testFireCollectionChangedEvent();
        ChangeSupportTests.assertNull((Object)this.collectionEvent);
        ChangeSupportTests.assertFalse((boolean)this.collectionChangedCalled);
    }

    public void testFireCollectionChanged() {
        this.collectionEvent = null;
        this.collectionChangedCalled = false;
        this.testModel.addChangeListener(this.changeListener);
        this.testModel.testFireCollectionChanged();
        this.verifyCollectionEvent(null);
        ChangeSupportTests.assertTrue((boolean)this.collectionChangedCalled);
        this.collectionEvent = null;
        this.collectionChangedCalled = false;
        this.testModel.removeChangeListener(this.changeListener);
        this.testModel.testFireCollectionChanged();
        ChangeSupportTests.assertNull((Object)this.collectionEvent);
        ChangeSupportTests.assertFalse((boolean)this.collectionChangedCalled);
        this.collectionEvent = null;
        this.collectionChangedCalled = false;
        this.testModel.addCollectionChangeListener(COLLECTION_NAME, (CollectionChangeListener)this.changeListener);
        this.testModel.testFireCollectionChanged();
        this.verifyCollectionEvent(null);
        ChangeSupportTests.assertTrue((boolean)this.collectionChangedCalled);
        this.collectionEvent = null;
        this.collectionChangedCalled = false;
        this.testModel.removeCollectionChangeListener(COLLECTION_NAME, (CollectionChangeListener)this.changeListener);
        this.testModel.testFireCollectionChanged();
        ChangeSupportTests.assertNull((Object)this.collectionEvent);
        ChangeSupportTests.assertFalse((boolean)this.collectionChangedCalled);
    }

    public void testAddItemToCollection() {
        this.collectionEvent = null;
        this.itemsAddedCollectionCalled = false;
        this.testModel.addChangeListener(this.changeListener);
        ChangeSupportTests.assertTrue((boolean)this.testModel.testAddItemToCollection());
        this.verifyCollectionEvent(ADDED_OBJECT_VALUE);
        ChangeSupportTests.assertTrue((boolean)this.itemsAddedCollectionCalled);
        this.collectionEvent = null;
        this.itemsAddedCollectionCalled = false;
        this.testModel.removeChangeListener(this.changeListener);
        ChangeSupportTests.assertTrue((boolean)this.testModel.testAddItemToCollection());
        ChangeSupportTests.assertNull((Object)this.collectionEvent);
        ChangeSupportTests.assertFalse((boolean)this.itemsAddedCollectionCalled);
        this.collectionEvent = null;
        this.itemsAddedCollectionCalled = false;
        this.testModel.addCollectionChangeListener(COLLECTION_NAME, (CollectionChangeListener)this.changeListener);
        ChangeSupportTests.assertTrue((boolean)this.testModel.testAddItemToCollection());
        this.verifyCollectionEvent(ADDED_OBJECT_VALUE);
        ChangeSupportTests.assertTrue((boolean)this.itemsAddedCollectionCalled);
        this.collectionEvent = null;
        this.itemsAddedCollectionCalled = false;
        this.testModel.removeCollectionChangeListener(COLLECTION_NAME, (CollectionChangeListener)this.changeListener);
        ChangeSupportTests.assertTrue((boolean)this.testModel.testAddItemToCollection());
        ChangeSupportTests.assertNull((Object)this.collectionEvent);
        ChangeSupportTests.assertFalse((boolean)this.itemsAddedCollectionCalled);
    }

    public void testAddItemToCollectionNoChange() {
        this.collectionEvent = null;
        this.itemsAddedCollectionCalled = false;
        this.testModel.addChangeListener(this.changeListener);
        ChangeSupportTests.assertFalse((boolean)this.testModel.testAddItemToCollectionNoChange());
        ChangeSupportTests.assertNull((Object)this.collectionEvent);
        ChangeSupportTests.assertFalse((boolean)this.itemsAddedCollectionCalled);
        this.collectionEvent = null;
        this.itemsAddedCollectionCalled = false;
        this.testModel.removeChangeListener(this.changeListener);
        ChangeSupportTests.assertFalse((boolean)this.testModel.testAddItemToCollectionNoChange());
        ChangeSupportTests.assertNull((Object)this.collectionEvent);
        ChangeSupportTests.assertFalse((boolean)this.itemsAddedCollectionCalled);
        this.collectionEvent = null;
        this.itemsAddedCollectionCalled = false;
        this.testModel.addCollectionChangeListener(COLLECTION_NAME, (CollectionChangeListener)this.changeListener);
        ChangeSupportTests.assertFalse((boolean)this.testModel.testAddItemToCollectionNoChange());
        ChangeSupportTests.assertNull((Object)this.collectionEvent);
        ChangeSupportTests.assertFalse((boolean)this.itemsAddedCollectionCalled);
        this.collectionEvent = null;
        this.itemsAddedCollectionCalled = false;
        this.testModel.removeCollectionChangeListener(COLLECTION_NAME, (CollectionChangeListener)this.changeListener);
        ChangeSupportTests.assertFalse((boolean)this.testModel.testAddItemToCollectionNoChange());
        ChangeSupportTests.assertNull((Object)this.collectionEvent);
        ChangeSupportTests.assertFalse((boolean)this.itemsAddedCollectionCalled);
    }

    public void testAddItemsToCollection() {
        this.collectionEvent = null;
        this.itemsAddedCollectionCalled = false;
        this.testModel.addChangeListener(this.changeListener);
        ChangeSupportTests.assertTrue((boolean)this.testModel.testAddItemsToCollection());
        this.verifyCollectionEvent(ADDED_OBJECT_VALUE);
        ChangeSupportTests.assertTrue((boolean)this.itemsAddedCollectionCalled);
        this.collectionEvent = null;
        this.itemsAddedCollectionCalled = false;
        this.testModel.removeChangeListener(this.changeListener);
        ChangeSupportTests.assertTrue((boolean)this.testModel.testAddItemsToCollection());
        ChangeSupportTests.assertNull((Object)this.collectionEvent);
        ChangeSupportTests.assertFalse((boolean)this.itemsAddedCollectionCalled);
        this.collectionEvent = null;
        this.itemsAddedCollectionCalled = false;
        this.testModel.addCollectionChangeListener(COLLECTION_NAME, (CollectionChangeListener)this.changeListener);
        ChangeSupportTests.assertTrue((boolean)this.testModel.testAddItemsToCollection());
        this.verifyCollectionEvent(ADDED_OBJECT_VALUE);
        ChangeSupportTests.assertTrue((boolean)this.itemsAddedCollectionCalled);
        this.collectionEvent = null;
        this.itemsAddedCollectionCalled = false;
        this.testModel.removeCollectionChangeListener(COLLECTION_NAME, (CollectionChangeListener)this.changeListener);
        ChangeSupportTests.assertTrue((boolean)this.testModel.testAddItemsToCollection());
        ChangeSupportTests.assertNull((Object)this.collectionEvent);
        ChangeSupportTests.assertFalse((boolean)this.itemsAddedCollectionCalled);
    }

    public void testAddItemsToCollectionNoChange() {
        this.collectionEvent = null;
        this.itemsAddedCollectionCalled = false;
        this.testModel.addChangeListener(this.changeListener);
        ChangeSupportTests.assertFalse((boolean)this.testModel.testAddItemsToCollectionNoChange());
        ChangeSupportTests.assertNull((Object)this.collectionEvent);
        ChangeSupportTests.assertFalse((boolean)this.itemsAddedCollectionCalled);
        this.collectionEvent = null;
        this.itemsAddedCollectionCalled = false;
        this.testModel.removeChangeListener(this.changeListener);
        ChangeSupportTests.assertFalse((boolean)this.testModel.testAddItemsToCollectionNoChange());
        ChangeSupportTests.assertNull((Object)this.collectionEvent);
        ChangeSupportTests.assertFalse((boolean)this.itemsAddedCollectionCalled);
        this.collectionEvent = null;
        this.itemsAddedCollectionCalled = false;
        this.testModel.addCollectionChangeListener(COLLECTION_NAME, (CollectionChangeListener)this.changeListener);
        ChangeSupportTests.assertFalse((boolean)this.testModel.testAddItemsToCollectionNoChange());
        ChangeSupportTests.assertNull((Object)this.collectionEvent);
        ChangeSupportTests.assertFalse((boolean)this.itemsAddedCollectionCalled);
        this.collectionEvent = null;
        this.itemsAddedCollectionCalled = false;
        this.testModel.removeCollectionChangeListener(COLLECTION_NAME, (CollectionChangeListener)this.changeListener);
        ChangeSupportTests.assertFalse((boolean)this.testModel.testAddItemsToCollectionNoChange());
        ChangeSupportTests.assertNull((Object)this.collectionEvent);
        ChangeSupportTests.assertFalse((boolean)this.itemsAddedCollectionCalled);
    }

    public void testAddItemsToCollectionMixed() {
        this.collectionEvent = null;
        this.itemsAddedCollectionCalled = false;
        this.testModel.addChangeListener(this.changeListener);
        ChangeSupportTests.assertTrue((boolean)this.testModel.testAddItemsToCollectionMixed());
        this.verifyCollectionEvent(ADDED_OBJECT_VALUE_2);
        ChangeSupportTests.assertTrue((boolean)this.itemsAddedCollectionCalled);
        this.collectionEvent = null;
        this.itemsAddedCollectionCalled = false;
        this.testModel.removeChangeListener(this.changeListener);
        ChangeSupportTests.assertTrue((boolean)this.testModel.testAddItemsToCollectionMixed());
        ChangeSupportTests.assertNull((Object)this.collectionEvent);
        ChangeSupportTests.assertFalse((boolean)this.itemsAddedCollectionCalled);
        this.collectionEvent = null;
        this.itemsAddedCollectionCalled = false;
        this.testModel.addCollectionChangeListener(COLLECTION_NAME, (CollectionChangeListener)this.changeListener);
        ChangeSupportTests.assertTrue((boolean)this.testModel.testAddItemsToCollectionMixed());
        this.verifyCollectionEvent(ADDED_OBJECT_VALUE_2);
        ChangeSupportTests.assertTrue((boolean)this.itemsAddedCollectionCalled);
        this.collectionEvent = null;
        this.itemsAddedCollectionCalled = false;
        this.testModel.removeCollectionChangeListener(COLLECTION_NAME, (CollectionChangeListener)this.changeListener);
        ChangeSupportTests.assertTrue((boolean)this.testModel.testAddItemsToCollectionMixed());
        ChangeSupportTests.assertNull((Object)this.collectionEvent);
        ChangeSupportTests.assertFalse((boolean)this.itemsAddedCollectionCalled);
    }

    public void testRemoveItemFromCollection() {
        this.collectionEvent = null;
        this.itemsRemovedCollectionCalled = false;
        this.testModel.addChangeListener(this.changeListener);
        ChangeSupportTests.assertTrue((boolean)this.testModel.testRemoveItemFromCollection());
        this.verifyCollectionEvent(REMOVED_OBJECT_VALUE);
        ChangeSupportTests.assertTrue((boolean)this.itemsRemovedCollectionCalled);
        this.collectionEvent = null;
        this.itemsRemovedCollectionCalled = false;
        this.testModel.removeChangeListener(this.changeListener);
        ChangeSupportTests.assertTrue((boolean)this.testModel.testRemoveItemFromCollection());
        ChangeSupportTests.assertNull((Object)this.collectionEvent);
        ChangeSupportTests.assertFalse((boolean)this.itemsRemovedCollectionCalled);
        this.collectionEvent = null;
        this.itemsRemovedCollectionCalled = false;
        this.testModel.addCollectionChangeListener(COLLECTION_NAME, (CollectionChangeListener)this.changeListener);
        ChangeSupportTests.assertTrue((boolean)this.testModel.testRemoveItemFromCollection());
        this.verifyCollectionEvent(REMOVED_OBJECT_VALUE);
        ChangeSupportTests.assertTrue((boolean)this.itemsRemovedCollectionCalled);
        this.collectionEvent = null;
        this.itemsRemovedCollectionCalled = false;
        this.testModel.removeCollectionChangeListener(COLLECTION_NAME, (CollectionChangeListener)this.changeListener);
        ChangeSupportTests.assertTrue((boolean)this.testModel.testRemoveItemFromCollection());
        ChangeSupportTests.assertNull((Object)this.collectionEvent);
        ChangeSupportTests.assertFalse((boolean)this.itemsRemovedCollectionCalled);
    }

    public void testRemoveItemFromCollectionNoChange() {
        this.collectionEvent = null;
        this.itemsRemovedCollectionCalled = false;
        this.testModel.addChangeListener(this.changeListener);
        ChangeSupportTests.assertFalse((boolean)this.testModel.testRemoveItemFromCollectionNoChange());
        ChangeSupportTests.assertNull((Object)this.collectionEvent);
        ChangeSupportTests.assertFalse((boolean)this.itemsRemovedCollectionCalled);
        this.collectionEvent = null;
        this.itemsRemovedCollectionCalled = false;
        this.testModel.removeChangeListener(this.changeListener);
        ChangeSupportTests.assertFalse((boolean)this.testModel.testRemoveItemFromCollectionNoChange());
        ChangeSupportTests.assertNull((Object)this.collectionEvent);
        ChangeSupportTests.assertFalse((boolean)this.itemsRemovedCollectionCalled);
        this.collectionEvent = null;
        this.itemsRemovedCollectionCalled = false;
        this.testModel.addCollectionChangeListener(COLLECTION_NAME, (CollectionChangeListener)this.changeListener);
        ChangeSupportTests.assertFalse((boolean)this.testModel.testRemoveItemFromCollectionNoChange());
        ChangeSupportTests.assertNull((Object)this.collectionEvent);
        ChangeSupportTests.assertFalse((boolean)this.itemsRemovedCollectionCalled);
        this.collectionEvent = null;
        this.itemsRemovedCollectionCalled = false;
        this.testModel.removeCollectionChangeListener(COLLECTION_NAME, (CollectionChangeListener)this.changeListener);
        ChangeSupportTests.assertFalse((boolean)this.testModel.testRemoveItemFromCollectionNoChange());
        ChangeSupportTests.assertNull((Object)this.collectionEvent);
        ChangeSupportTests.assertFalse((boolean)this.itemsRemovedCollectionCalled);
    }

    public void testRemoveItemsFromCollection() {
        this.collectionEvent = null;
        this.itemsRemovedCollectionCalled = false;
        this.testModel.addChangeListener(this.changeListener);
        ChangeSupportTests.assertTrue((boolean)this.testModel.testRemoveItemsFromCollection());
        this.verifyCollectionChangeEvent2(REMOVED_OBJECT_VALUE, "foo", "bar");
        ChangeSupportTests.assertTrue((boolean)this.itemsRemovedCollectionCalled);
        this.collectionEvent = null;
        this.itemsRemovedCollectionCalled = false;
        this.testModel.removeChangeListener(this.changeListener);
        ChangeSupportTests.assertTrue((boolean)this.testModel.testRemoveItemsFromCollection());
        ChangeSupportTests.assertNull((Object)this.collectionEvent);
        ChangeSupportTests.assertFalse((boolean)this.itemsRemovedCollectionCalled);
        this.collectionEvent = null;
        this.itemsRemovedCollectionCalled = false;
        this.testModel.addCollectionChangeListener(COLLECTION_NAME, (CollectionChangeListener)this.changeListener);
        ChangeSupportTests.assertTrue((boolean)this.testModel.testRemoveItemsFromCollection());
        this.verifyCollectionChangeEvent2(REMOVED_OBJECT_VALUE, "foo", "bar");
        ChangeSupportTests.assertTrue((boolean)this.itemsRemovedCollectionCalled);
        this.collectionEvent = null;
        this.itemsRemovedCollectionCalled = false;
        this.testModel.removeCollectionChangeListener(COLLECTION_NAME, (CollectionChangeListener)this.changeListener);
        ChangeSupportTests.assertTrue((boolean)this.testModel.testRemoveItemsFromCollection());
        ChangeSupportTests.assertNull((Object)this.collectionEvent);
        ChangeSupportTests.assertFalse((boolean)this.itemsRemovedCollectionCalled);
    }

    public void testRemoveItemsFromCollectionNoChange1() {
        this.collectionEvent = null;
        this.itemsRemovedCollectionCalled = false;
        this.testModel.addChangeListener(this.changeListener);
        ChangeSupportTests.assertFalse((boolean)this.testModel.testRemoveItemsFromCollectionNoChange1());
        ChangeSupportTests.assertNull((Object)this.collectionEvent);
        ChangeSupportTests.assertFalse((boolean)this.itemsRemovedCollectionCalled);
        this.collectionEvent = null;
        this.itemsRemovedCollectionCalled = false;
        this.testModel.removeChangeListener(this.changeListener);
        ChangeSupportTests.assertFalse((boolean)this.testModel.testRemoveItemsFromCollectionNoChange1());
        ChangeSupportTests.assertNull((Object)this.collectionEvent);
        ChangeSupportTests.assertFalse((boolean)this.itemsRemovedCollectionCalled);
        this.collectionEvent = null;
        this.itemsRemovedCollectionCalled = false;
        this.testModel.addCollectionChangeListener(COLLECTION_NAME, (CollectionChangeListener)this.changeListener);
        ChangeSupportTests.assertFalse((boolean)this.testModel.testRemoveItemsFromCollectionNoChange1());
        ChangeSupportTests.assertNull((Object)this.collectionEvent);
        ChangeSupportTests.assertFalse((boolean)this.itemsRemovedCollectionCalled);
        this.collectionEvent = null;
        this.itemsRemovedCollectionCalled = false;
        this.testModel.removeCollectionChangeListener(COLLECTION_NAME, (CollectionChangeListener)this.changeListener);
        ChangeSupportTests.assertFalse((boolean)this.testModel.testRemoveItemsFromCollectionNoChange1());
        ChangeSupportTests.assertNull((Object)this.collectionEvent);
        ChangeSupportTests.assertFalse((boolean)this.itemsRemovedCollectionCalled);
    }

    public void testRemoveItemsFromCollectionNoChange2() {
        this.collectionEvent = null;
        this.itemsRemovedCollectionCalled = false;
        this.testModel.addChangeListener(this.changeListener);
        ChangeSupportTests.assertFalse((boolean)this.testModel.testRemoveItemsFromCollectionNoChange2());
        ChangeSupportTests.assertNull((Object)this.collectionEvent);
        ChangeSupportTests.assertFalse((boolean)this.itemsRemovedCollectionCalled);
        this.collectionEvent = null;
        this.itemsRemovedCollectionCalled = false;
        this.testModel.removeChangeListener(this.changeListener);
        ChangeSupportTests.assertFalse((boolean)this.testModel.testRemoveItemsFromCollectionNoChange2());
        ChangeSupportTests.assertNull((Object)this.collectionEvent);
        ChangeSupportTests.assertFalse((boolean)this.itemsRemovedCollectionCalled);
        this.collectionEvent = null;
        this.itemsRemovedCollectionCalled = false;
        this.testModel.addCollectionChangeListener(COLLECTION_NAME, (CollectionChangeListener)this.changeListener);
        ChangeSupportTests.assertFalse((boolean)this.testModel.testRemoveItemsFromCollectionNoChange2());
        ChangeSupportTests.assertNull((Object)this.collectionEvent);
        ChangeSupportTests.assertFalse((boolean)this.itemsRemovedCollectionCalled);
        this.collectionEvent = null;
        this.itemsRemovedCollectionCalled = false;
        this.testModel.removeCollectionChangeListener(COLLECTION_NAME, (CollectionChangeListener)this.changeListener);
        ChangeSupportTests.assertFalse((boolean)this.testModel.testRemoveItemsFromCollectionNoChange2());
        ChangeSupportTests.assertNull((Object)this.collectionEvent);
        ChangeSupportTests.assertFalse((boolean)this.itemsRemovedCollectionCalled);
    }

    public void testRemoveItemsFromCollectionNoChange3() {
        this.collectionEvent = null;
        this.itemsRemovedCollectionCalled = false;
        this.testModel.addChangeListener(this.changeListener);
        ChangeSupportTests.assertFalse((boolean)this.testModel.testRemoveItemsFromCollectionNoChange3());
        ChangeSupportTests.assertNull((Object)this.collectionEvent);
        ChangeSupportTests.assertFalse((boolean)this.itemsRemovedCollectionCalled);
        this.collectionEvent = null;
        this.itemsRemovedCollectionCalled = false;
        this.testModel.removeChangeListener(this.changeListener);
        ChangeSupportTests.assertFalse((boolean)this.testModel.testRemoveItemsFromCollectionNoChange3());
        ChangeSupportTests.assertNull((Object)this.collectionEvent);
        ChangeSupportTests.assertFalse((boolean)this.itemsRemovedCollectionCalled);
        this.collectionEvent = null;
        this.itemsRemovedCollectionCalled = false;
        this.testModel.addCollectionChangeListener(COLLECTION_NAME, (CollectionChangeListener)this.changeListener);
        ChangeSupportTests.assertFalse((boolean)this.testModel.testRemoveItemsFromCollectionNoChange3());
        ChangeSupportTests.assertNull((Object)this.collectionEvent);
        ChangeSupportTests.assertFalse((boolean)this.itemsRemovedCollectionCalled);
        this.collectionEvent = null;
        this.itemsRemovedCollectionCalled = false;
        this.testModel.removeCollectionChangeListener(COLLECTION_NAME, (CollectionChangeListener)this.changeListener);
        ChangeSupportTests.assertFalse((boolean)this.testModel.testRemoveItemsFromCollectionNoChange3());
        ChangeSupportTests.assertNull((Object)this.collectionEvent);
        ChangeSupportTests.assertFalse((boolean)this.itemsRemovedCollectionCalled);
    }

    public void testRetainItemsInCollection1() {
        this.collectionEvent = null;
        this.itemsRemovedCollectionCalled = false;
        this.testModel.addChangeListener(this.changeListener);
        ChangeSupportTests.assertTrue((boolean)this.testModel.testRetainItemsInCollection1());
        this.verifyCollectionEvent(REMOVED_OBJECT_VALUE);
        ChangeSupportTests.assertTrue((boolean)this.itemsRemovedCollectionCalled);
        this.collectionEvent = null;
        this.itemsRemovedCollectionCalled = false;
        this.testModel.removeChangeListener(this.changeListener);
        ChangeSupportTests.assertTrue((boolean)this.testModel.testRetainItemsInCollection1());
        ChangeSupportTests.assertNull((Object)this.collectionEvent);
        ChangeSupportTests.assertFalse((boolean)this.itemsRemovedCollectionCalled);
        this.collectionEvent = null;
        this.itemsRemovedCollectionCalled = false;
        this.testModel.addCollectionChangeListener(COLLECTION_NAME, (CollectionChangeListener)this.changeListener);
        ChangeSupportTests.assertTrue((boolean)this.testModel.testRetainItemsInCollection1());
        this.verifyCollectionEvent(REMOVED_OBJECT_VALUE);
        ChangeSupportTests.assertTrue((boolean)this.itemsRemovedCollectionCalled);
        this.collectionEvent = null;
        this.itemsRemovedCollectionCalled = false;
        this.testModel.removeCollectionChangeListener(COLLECTION_NAME, (CollectionChangeListener)this.changeListener);
        ChangeSupportTests.assertTrue((boolean)this.testModel.testRetainItemsInCollection1());
        ChangeSupportTests.assertNull((Object)this.collectionEvent);
        ChangeSupportTests.assertFalse((boolean)this.itemsRemovedCollectionCalled);
    }

    public void testRetainItemsInCollection2() {
        this.collectionEvent = null;
        this.collectionClearedCalled = false;
        this.testModel.addChangeListener(this.changeListener);
        ChangeSupportTests.assertTrue((boolean)this.testModel.testRetainItemsInCollection2());
        this.verifyCollectionEvent(null);
        ChangeSupportTests.assertTrue((boolean)this.collectionClearedCalled);
        this.collectionEvent = null;
        this.collectionClearedCalled = false;
        this.testModel.removeChangeListener(this.changeListener);
        ChangeSupportTests.assertTrue((boolean)this.testModel.testRetainItemsInCollection2());
        ChangeSupportTests.assertNull((Object)this.collectionEvent);
        ChangeSupportTests.assertFalse((boolean)this.collectionClearedCalled);
        this.collectionEvent = null;
        this.collectionClearedCalled = false;
        this.testModel.addCollectionChangeListener(COLLECTION_NAME, (CollectionChangeListener)this.changeListener);
        ChangeSupportTests.assertTrue((boolean)this.testModel.testRetainItemsInCollection2());
        this.verifyCollectionEvent(null);
        ChangeSupportTests.assertTrue((boolean)this.collectionClearedCalled);
        this.collectionEvent = null;
        this.collectionClearedCalled = false;
        this.testModel.removeCollectionChangeListener(COLLECTION_NAME, (CollectionChangeListener)this.changeListener);
        ChangeSupportTests.assertTrue((boolean)this.testModel.testRetainItemsInCollection2());
        ChangeSupportTests.assertNull((Object)this.collectionEvent);
        ChangeSupportTests.assertFalse((boolean)this.collectionClearedCalled);
    }

    public void testRetainItemsInCollectionNoChange1() {
        this.collectionEvent = null;
        this.itemsRemovedCollectionCalled = false;
        this.testModel.addChangeListener(this.changeListener);
        ChangeSupportTests.assertFalse((boolean)this.testModel.testRetainItemsInCollectionNoChange1());
        ChangeSupportTests.assertNull((Object)this.collectionEvent);
        ChangeSupportTests.assertFalse((boolean)this.itemsRemovedCollectionCalled);
        this.collectionEvent = null;
        this.itemsRemovedCollectionCalled = false;
        this.testModel.removeChangeListener(this.changeListener);
        ChangeSupportTests.assertFalse((boolean)this.testModel.testRetainItemsInCollectionNoChange1());
        ChangeSupportTests.assertNull((Object)this.collectionEvent);
        ChangeSupportTests.assertFalse((boolean)this.itemsRemovedCollectionCalled);
        this.collectionEvent = null;
        this.itemsRemovedCollectionCalled = false;
        this.testModel.addCollectionChangeListener(COLLECTION_NAME, (CollectionChangeListener)this.changeListener);
        ChangeSupportTests.assertFalse((boolean)this.testModel.testRetainItemsInCollectionNoChange1());
        ChangeSupportTests.assertNull((Object)this.collectionEvent);
        ChangeSupportTests.assertFalse((boolean)this.itemsRemovedCollectionCalled);
        this.collectionEvent = null;
        this.itemsRemovedCollectionCalled = false;
        this.testModel.removeCollectionChangeListener(COLLECTION_NAME, (CollectionChangeListener)this.changeListener);
        ChangeSupportTests.assertFalse((boolean)this.testModel.testRetainItemsInCollectionNoChange1());
        ChangeSupportTests.assertNull((Object)this.collectionEvent);
        ChangeSupportTests.assertFalse((boolean)this.itemsRemovedCollectionCalled);
    }

    public void testRetainItemsInCollectionNoChange2() {
        this.collectionEvent = null;
        this.itemsRemovedCollectionCalled = false;
        this.testModel.addChangeListener(this.changeListener);
        ChangeSupportTests.assertFalse((boolean)this.testModel.testRetainItemsInCollectionNoChange2());
        ChangeSupportTests.assertNull((Object)this.collectionEvent);
        ChangeSupportTests.assertFalse((boolean)this.itemsRemovedCollectionCalled);
        this.collectionEvent = null;
        this.itemsRemovedCollectionCalled = false;
        this.testModel.removeChangeListener(this.changeListener);
        ChangeSupportTests.assertFalse((boolean)this.testModel.testRetainItemsInCollectionNoChange2());
        ChangeSupportTests.assertNull((Object)this.collectionEvent);
        ChangeSupportTests.assertFalse((boolean)this.itemsRemovedCollectionCalled);
        this.collectionEvent = null;
        this.itemsRemovedCollectionCalled = false;
        this.testModel.addCollectionChangeListener(COLLECTION_NAME, (CollectionChangeListener)this.changeListener);
        ChangeSupportTests.assertFalse((boolean)this.testModel.testRetainItemsInCollectionNoChange2());
        ChangeSupportTests.assertNull((Object)this.collectionEvent);
        ChangeSupportTests.assertFalse((boolean)this.itemsRemovedCollectionCalled);
        this.collectionEvent = null;
        this.itemsRemovedCollectionCalled = false;
        this.testModel.removeCollectionChangeListener(COLLECTION_NAME, (CollectionChangeListener)this.changeListener);
        ChangeSupportTests.assertFalse((boolean)this.testModel.testRetainItemsInCollectionNoChange2());
        ChangeSupportTests.assertNull((Object)this.collectionEvent);
        ChangeSupportTests.assertFalse((boolean)this.itemsRemovedCollectionCalled);
    }

    public void testClearCollection() {
        this.collectionEvent = null;
        this.collectionClearedCalled = false;
        this.testModel.addChangeListener(this.changeListener);
        ChangeSupportTests.assertTrue((boolean)this.testModel.testClearCollection());
        this.verifyCollectionEvent(null);
        ChangeSupportTests.assertTrue((boolean)this.collectionClearedCalled);
        this.collectionEvent = null;
        this.collectionClearedCalled = false;
        this.testModel.removeChangeListener(this.changeListener);
        ChangeSupportTests.assertTrue((boolean)this.testModel.testClearCollection());
        ChangeSupportTests.assertNull((Object)this.collectionEvent);
        ChangeSupportTests.assertFalse((boolean)this.collectionClearedCalled);
        this.collectionEvent = null;
        this.collectionClearedCalled = false;
        this.testModel.addCollectionChangeListener(COLLECTION_NAME, (CollectionChangeListener)this.changeListener);
        ChangeSupportTests.assertTrue((boolean)this.testModel.testClearCollection());
        this.verifyCollectionEvent(null);
        ChangeSupportTests.assertTrue((boolean)this.collectionClearedCalled);
        this.collectionEvent = null;
        this.collectionClearedCalled = false;
        this.testModel.removeCollectionChangeListener(COLLECTION_NAME, (CollectionChangeListener)this.changeListener);
        ChangeSupportTests.assertTrue((boolean)this.testModel.testClearCollection());
        ChangeSupportTests.assertNull((Object)this.collectionEvent);
        ChangeSupportTests.assertFalse((boolean)this.collectionClearedCalled);
    }

    public void testClearCollectionNoChange() {
        this.collectionEvent = null;
        this.collectionClearedCalled = false;
        this.testModel.addChangeListener(this.changeListener);
        ChangeSupportTests.assertFalse((boolean)this.testModel.testClearCollectionNoChange());
        ChangeSupportTests.assertNull((Object)this.collectionEvent);
        ChangeSupportTests.assertFalse((boolean)this.collectionClearedCalled);
        this.collectionEvent = null;
        this.collectionClearedCalled = false;
        this.testModel.removeChangeListener(this.changeListener);
        ChangeSupportTests.assertFalse((boolean)this.testModel.testClearCollectionNoChange());
        ChangeSupportTests.assertNull((Object)this.collectionEvent);
        ChangeSupportTests.assertFalse((boolean)this.collectionClearedCalled);
        this.collectionEvent = null;
        this.collectionClearedCalled = false;
        this.testModel.addCollectionChangeListener(COLLECTION_NAME, (CollectionChangeListener)this.changeListener);
        ChangeSupportTests.assertFalse((boolean)this.testModel.testClearCollectionNoChange());
        ChangeSupportTests.assertNull((Object)this.collectionEvent);
        ChangeSupportTests.assertFalse((boolean)this.collectionClearedCalled);
        this.collectionEvent = null;
        this.collectionClearedCalled = false;
        this.testModel.removeCollectionChangeListener(COLLECTION_NAME, (CollectionChangeListener)this.changeListener);
        ChangeSupportTests.assertFalse((boolean)this.testModel.testClearCollectionNoChange());
        ChangeSupportTests.assertNull((Object)this.collectionEvent);
        ChangeSupportTests.assertFalse((boolean)this.collectionClearedCalled);
    }

    public void testSynchronizeCollection1() {
        CollectionSynchListener csl = new CollectionSynchListener();
        this.testModel.addChangeListener((ChangeListener)csl);
        ChangeSupportTests.assertTrue((boolean)this.testModel.testSynchronizeCollection1());
        ChangeSupportTests.assertTrue((boolean)csl.itemsAdded);
        ChangeSupportTests.assertTrue((boolean)csl.itemsRemoved);
        ChangeSupportTests.assertFalse((boolean)csl.collectionChanged);
        ChangeSupportTests.assertFalse((boolean)csl.collectionCleared);
        ChangeSupportTests.assertEquals((int)2, (int)csl.addedItems.size());
        ChangeSupportTests.assertTrue((boolean)CollectionTools.containsAll(csl.addedItems, (Object[])new Object[]{"joo", "jar"}));
        ChangeSupportTests.assertEquals((int)2, (int)csl.removedItems.size());
        ChangeSupportTests.assertTrue((boolean)CollectionTools.containsAll(csl.removedItems, (Object[])new Object[]{"foo", "bar"}));
    }

    public void testSynchronizeCollection2() {
        CollectionSynchListener csl = new CollectionSynchListener();
        this.testModel.addChangeListener((ChangeListener)csl);
        ChangeSupportTests.assertTrue((boolean)this.testModel.testSynchronizeCollection2());
        ChangeSupportTests.assertFalse((boolean)csl.itemsAdded);
        ChangeSupportTests.assertFalse((boolean)csl.itemsRemoved);
        ChangeSupportTests.assertFalse((boolean)csl.collectionChanged);
        ChangeSupportTests.assertTrue((boolean)csl.collectionCleared);
        ChangeSupportTests.assertTrue((boolean)csl.addedItems.isEmpty());
        ChangeSupportTests.assertTrue((boolean)csl.removedItems.isEmpty());
    }

    public void testSynchronizeCollection3() {
        CollectionSynchListener csl = new CollectionSynchListener();
        this.testModel.addChangeListener((ChangeListener)csl);
        ChangeSupportTests.assertTrue((boolean)this.testModel.testSynchronizeCollection3());
        ChangeSupportTests.assertTrue((boolean)csl.itemsAdded);
        ChangeSupportTests.assertFalse((boolean)csl.itemsRemoved);
        ChangeSupportTests.assertFalse((boolean)csl.collectionChanged);
        ChangeSupportTests.assertFalse((boolean)csl.collectionCleared);
        ChangeSupportTests.assertEquals((int)3, (int)csl.addedItems.size());
        ChangeSupportTests.assertTrue((boolean)CollectionTools.containsAll(csl.addedItems, (Object[])new Object[]{"joo", "jar", "baz"}));
        ChangeSupportTests.assertTrue((boolean)csl.removedItems.isEmpty());
    }

    public void testHasAnyCollectionChangeListeners() {
        ChangeSupportTests.assertTrue((boolean)this.testModel.hasNoCollectionChangeListeners(COLLECTION_NAME));
        this.testModel.addChangeListener(this.changeListener);
        ChangeSupportTests.assertTrue((boolean)this.testModel.hasAnyCollectionChangeListeners(COLLECTION_NAME));
        this.testModel.removeChangeListener(this.changeListener);
        ChangeSupportTests.assertTrue((boolean)this.testModel.hasNoCollectionChangeListeners(COLLECTION_NAME));
        ChangeSupportTests.assertTrue((boolean)this.testModel.hasNoCollectionChangeListeners(COLLECTION_NAME));
        this.testModel.addCollectionChangeListener(COLLECTION_NAME, (CollectionChangeListener)this.changeListener);
        ChangeSupportTests.assertTrue((boolean)this.testModel.hasAnyCollectionChangeListeners(COLLECTION_NAME));
        this.testModel.removeCollectionChangeListener(COLLECTION_NAME, (CollectionChangeListener)this.changeListener);
        ChangeSupportTests.assertTrue((boolean)this.testModel.hasNoCollectionChangeListeners(COLLECTION_NAME));
    }

    public void testAddNullCollectionListener() {
        boolean exCaught = false;
        try {
            this.testModel.addCollectionChangeListener("foo", null);
        }
        catch (NullPointerException nullPointerException) {
            exCaught = true;
        }
        ChangeSupportTests.assertTrue((boolean)exCaught);
    }

    public void testRemoveBogusCollectionListener() {
        boolean exCaught = false;
        try {
            this.testModel.removeCollectionChangeListener("foo", (CollectionChangeListener)this.changeListener);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            exCaught = true;
        }
        ChangeSupportTests.assertTrue((boolean)exCaught);
        this.testModel.addPropertyChangeListener("foo", (PropertyChangeListener)this.changeListener);
        exCaught = false;
        try {
            this.testModel.removeCollectionChangeListener("foo", (CollectionChangeListener)this.changeListener);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            exCaught = true;
        }
        ChangeSupportTests.assertTrue((boolean)exCaught);
        this.testModel.addCollectionChangeListener("foo", (CollectionChangeListener)this.changeListener);
        exCaught = false;
        try {
            this.testModel.removeCollectionChangeListener("foo", (CollectionChangeListener)new CollectionChangeAdapter());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            exCaught = true;
        }
        ChangeSupportTests.assertTrue((boolean)exCaught);
        exCaught = false;
        try {
            this.testModel.removeCollectionChangeListener("foo", (CollectionChangeListener)new CollectionChangeAdapter());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            exCaught = true;
        }
        ChangeSupportTests.assertTrue((boolean)exCaught);
    }

    private void verifyCollectionEvent(Object item) {
        ChangeSupportTests.assertNotNull((Object)this.collectionEvent);
        ChangeSupportTests.assertEquals((Object)this.testModel, (Object)this.collectionEvent.getSource());
        ChangeSupportTests.assertEquals((String)COLLECTION_NAME, (String)this.collectionEvent.getCollectionName());
        if (item != null) {
            ChangeSupportTests.assertEquals((Object)item, this.getCollectionEventItems().iterator().next());
        }
    }

    private Iterable<?> getCollectionEventItems() {
        if (this.collectionEvent instanceof CollectionAddEvent) {
            return ((CollectionAddEvent)this.collectionEvent).getItems();
        }
        if (this.collectionEvent instanceof CollectionRemoveEvent) {
            return ((CollectionRemoveEvent)this.collectionEvent).getItems();
        }
        throw new IllegalStateException();
    }

    private void verifyCollectionChangeEvent2(Object ... items) {
        ChangeSupportTests.assertNotNull((Object)this.collectionEvent);
        ChangeSupportTests.assertEquals((Object)this.testModel, (Object)this.collectionEvent.getSource());
        ChangeSupportTests.assertEquals((String)COLLECTION_NAME, (String)this.collectionEvent.getCollectionName());
        ChangeSupportTests.assertEquals((int)items.length, (int)this.getCollectionEventItemsSize());
        Object[] objectArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            Object item = objectArray[n2];
            ChangeSupportTests.assertTrue((boolean)CollectionTools.contains(this.getCollectionEventItems(), (Object)item));
            ++n2;
        }
    }

    private int getCollectionEventItemsSize() {
        if (this.collectionEvent instanceof CollectionAddEvent) {
            return ((CollectionAddEvent)this.collectionEvent).getItemsSize();
        }
        if (this.collectionEvent instanceof CollectionRemoveEvent) {
            return ((CollectionRemoveEvent)this.collectionEvent).getItemsSize();
        }
        throw new IllegalStateException();
    }

    public void testFireItemsAddedListEvent() {
        this.listEvent = null;
        this.itemsAddedListCalled = false;
        this.testModel.addChangeListener(this.changeListener);
        this.testModel.testFireItemsAddedListEvent();
        this.verifyListAddEvent(3, ADDED_OBJECT_VALUE);
        ChangeSupportTests.assertTrue((boolean)this.itemsAddedListCalled);
        this.listEvent = null;
        this.itemsAddedListCalled = false;
        this.testModel.removeChangeListener(this.changeListener);
        this.testModel.testFireItemsAddedListEvent();
        ChangeSupportTests.assertNull((Object)this.listEvent);
        ChangeSupportTests.assertFalse((boolean)this.itemsAddedListCalled);
        this.listEvent = null;
        this.itemsAddedListCalled = false;
        this.testModel.addListChangeListener(LIST_NAME, (ListChangeListener)this.changeListener);
        this.testModel.testFireItemsAddedListEvent();
        this.verifyListAddEvent(3, ADDED_OBJECT_VALUE);
        ChangeSupportTests.assertTrue((boolean)this.itemsAddedListCalled);
        this.listEvent = null;
        this.itemsAddedListCalled = false;
        this.testModel.removeListChangeListener(LIST_NAME, (ListChangeListener)this.changeListener);
        this.testModel.testFireItemsAddedListEvent();
        ChangeSupportTests.assertNull((Object)this.listEvent);
        ChangeSupportTests.assertFalse((boolean)this.itemsAddedListCalled);
    }

    public void testFireItemsAddedListEventNoChange() {
        this.listEvent = null;
        this.itemsAddedListCalled = false;
        this.testModel.addChangeListener(this.changeListener);
        this.testModel.testFireItemsAddedListEventNoChange();
        ChangeSupportTests.assertNull((Object)this.listEvent);
        ChangeSupportTests.assertFalse((boolean)this.itemsAddedListCalled);
        this.listEvent = null;
        this.itemsAddedListCalled = false;
        this.testModel.removeChangeListener(this.changeListener);
        this.testModel.testFireItemsAddedListEventNoChange();
        ChangeSupportTests.assertNull((Object)this.listEvent);
        ChangeSupportTests.assertFalse((boolean)this.itemsAddedListCalled);
        this.listEvent = null;
        this.itemsAddedListCalled = false;
        this.testModel.addListChangeListener(LIST_NAME, (ListChangeListener)this.changeListener);
        this.testModel.testFireItemsAddedListEventNoChange();
        ChangeSupportTests.assertNull((Object)this.listEvent);
        ChangeSupportTests.assertFalse((boolean)this.itemsAddedListCalled);
        this.listEvent = null;
        this.itemsAddedListCalled = false;
        this.testModel.removeListChangeListener(LIST_NAME, (ListChangeListener)this.changeListener);
        this.testModel.testFireItemsAddedListEventNoChange();
        ChangeSupportTests.assertNull((Object)this.listEvent);
        ChangeSupportTests.assertFalse((boolean)this.itemsAddedListCalled);
    }

    public void testFireItemsAddedList() {
        this.listEvent = null;
        this.itemsAddedListCalled = false;
        this.testModel.addChangeListener(this.changeListener);
        this.testModel.testFireItemsAddedList();
        this.verifyListAddEvent(3, ADDED_OBJECT_VALUE);
        ChangeSupportTests.assertTrue((boolean)this.itemsAddedListCalled);
        this.listEvent = null;
        this.itemsAddedListCalled = false;
        this.testModel.removeChangeListener(this.changeListener);
        this.testModel.testFireItemsAddedList();
        ChangeSupportTests.assertNull((Object)this.listEvent);
        ChangeSupportTests.assertFalse((boolean)this.itemsAddedListCalled);
        this.listEvent = null;
        this.itemsAddedListCalled = false;
        this.testModel.addListChangeListener(LIST_NAME, (ListChangeListener)this.changeListener);
        this.testModel.testFireItemsAddedList();
        this.verifyListAddEvent(3, ADDED_OBJECT_VALUE);
        ChangeSupportTests.assertTrue((boolean)this.itemsAddedListCalled);
        this.listEvent = null;
        this.itemsAddedListCalled = false;
        this.testModel.removeListChangeListener(LIST_NAME, (ListChangeListener)this.changeListener);
        this.testModel.testFireItemsAddedList();
        ChangeSupportTests.assertNull((Object)this.listEvent);
        ChangeSupportTests.assertFalse((boolean)this.itemsAddedListCalled);
    }

    public void testFireItemsAddedListNoChange() {
        this.listEvent = null;
        this.itemsAddedListCalled = false;
        this.testModel.addChangeListener(this.changeListener);
        this.testModel.testFireItemsAddedListNoChange();
        ChangeSupportTests.assertNull((Object)this.listEvent);
        ChangeSupportTests.assertFalse((boolean)this.itemsAddedListCalled);
        this.listEvent = null;
        this.itemsAddedListCalled = false;
        this.testModel.removeChangeListener(this.changeListener);
        this.testModel.testFireItemsAddedListNoChange();
        ChangeSupportTests.assertNull((Object)this.listEvent);
        ChangeSupportTests.assertFalse((boolean)this.itemsAddedListCalled);
        this.listEvent = null;
        this.itemsAddedListCalled = false;
        this.testModel.addListChangeListener(LIST_NAME, (ListChangeListener)this.changeListener);
        this.testModel.testFireItemsAddedListNoChange();
        ChangeSupportTests.assertNull((Object)this.listEvent);
        ChangeSupportTests.assertFalse((boolean)this.itemsAddedListCalled);
        this.listEvent = null;
        this.itemsAddedListCalled = false;
        this.testModel.removeListChangeListener(LIST_NAME, (ListChangeListener)this.changeListener);
        this.testModel.testFireItemsAddedListNoChange();
        ChangeSupportTests.assertNull((Object)this.listEvent);
        ChangeSupportTests.assertFalse((boolean)this.itemsAddedListCalled);
    }

    public void testFireItemAddedList() {
        this.listEvent = null;
        this.itemsAddedListCalled = false;
        this.testModel.addChangeListener(this.changeListener);
        this.testModel.testFireItemAddedList();
        this.verifyListAddEvent(3, ADDED_OBJECT_VALUE);
        ChangeSupportTests.assertTrue((boolean)this.itemsAddedListCalled);
        this.listEvent = null;
        this.itemsAddedListCalled = false;
        this.testModel.removeChangeListener(this.changeListener);
        this.testModel.testFireItemAddedList();
        ChangeSupportTests.assertNull((Object)this.listEvent);
        ChangeSupportTests.assertFalse((boolean)this.itemsAddedListCalled);
        this.listEvent = null;
        this.itemsAddedListCalled = false;
        this.testModel.addListChangeListener(LIST_NAME, (ListChangeListener)this.changeListener);
        this.testModel.testFireItemAddedList();
        this.verifyListAddEvent(3, ADDED_OBJECT_VALUE);
        ChangeSupportTests.assertTrue((boolean)this.itemsAddedListCalled);
        this.listEvent = null;
        this.itemsAddedListCalled = false;
        this.testModel.removeListChangeListener(LIST_NAME, (ListChangeListener)this.changeListener);
        this.testModel.testFireItemAddedList();
        ChangeSupportTests.assertNull((Object)this.listEvent);
        ChangeSupportTests.assertFalse((boolean)this.itemsAddedListCalled);
    }

    public void testFireItemsRemovedListEvent() {
        this.listEvent = null;
        this.itemsRemovedListCalled = false;
        this.testModel.addChangeListener(this.changeListener);
        this.testModel.testFireItemsRemovedListEvent();
        this.verifyListRemoveEvent(5, REMOVED_OBJECT_VALUE);
        ChangeSupportTests.assertTrue((boolean)this.itemsRemovedListCalled);
        this.listEvent = null;
        this.itemsRemovedListCalled = false;
        this.testModel.removeChangeListener(this.changeListener);
        this.testModel.testFireItemsRemovedListEvent();
        ChangeSupportTests.assertNull((Object)this.listEvent);
        ChangeSupportTests.assertFalse((boolean)this.itemsRemovedListCalled);
        this.listEvent = null;
        this.itemsRemovedListCalled = false;
        this.testModel.addListChangeListener(LIST_NAME, (ListChangeListener)this.changeListener);
        this.testModel.testFireItemsRemovedListEvent();
        this.verifyListRemoveEvent(5, REMOVED_OBJECT_VALUE);
        ChangeSupportTests.assertTrue((boolean)this.itemsRemovedListCalled);
        this.listEvent = null;
        this.itemsRemovedListCalled = false;
        this.testModel.removeListChangeListener(LIST_NAME, (ListChangeListener)this.changeListener);
        this.testModel.testFireItemsRemovedListEvent();
        ChangeSupportTests.assertNull((Object)this.listEvent);
        ChangeSupportTests.assertFalse((boolean)this.itemsRemovedListCalled);
    }

    public void testFireItemsRemovedListEventNoChange() {
        this.listEvent = null;
        this.itemsRemovedListCalled = false;
        this.testModel.addChangeListener(this.changeListener);
        this.testModel.testFireItemsRemovedListEventNoChange();
        ChangeSupportTests.assertNull((Object)this.listEvent);
        ChangeSupportTests.assertFalse((boolean)this.itemsRemovedListCalled);
        this.listEvent = null;
        this.itemsRemovedListCalled = false;
        this.testModel.removeChangeListener(this.changeListener);
        this.testModel.testFireItemsRemovedListEventNoChange();
        ChangeSupportTests.assertNull((Object)this.listEvent);
        ChangeSupportTests.assertFalse((boolean)this.itemsRemovedListCalled);
        this.listEvent = null;
        this.itemsRemovedListCalled = false;
        this.testModel.addListChangeListener(LIST_NAME, (ListChangeListener)this.changeListener);
        this.testModel.testFireItemsRemovedListEventNoChange();
        ChangeSupportTests.assertNull((Object)this.listEvent);
        ChangeSupportTests.assertFalse((boolean)this.itemsRemovedListCalled);
        this.listEvent = null;
        this.itemsRemovedListCalled = false;
        this.testModel.removeListChangeListener(LIST_NAME, (ListChangeListener)this.changeListener);
        this.testModel.testFireItemsRemovedListEventNoChange();
        ChangeSupportTests.assertNull((Object)this.listEvent);
        ChangeSupportTests.assertFalse((boolean)this.itemsRemovedListCalled);
    }

    public void testFireItemsRemovedList() {
        this.listEvent = null;
        this.itemsRemovedListCalled = false;
        this.testModel.addChangeListener(this.changeListener);
        this.testModel.testFireItemsRemovedList();
        this.verifyListRemoveEvent(5, REMOVED_OBJECT_VALUE);
        ChangeSupportTests.assertTrue((boolean)this.itemsRemovedListCalled);
        this.listEvent = null;
        this.itemsRemovedListCalled = false;
        this.testModel.removeChangeListener(this.changeListener);
        this.testModel.testFireItemsRemovedList();
        ChangeSupportTests.assertNull((Object)this.listEvent);
        ChangeSupportTests.assertFalse((boolean)this.itemsRemovedListCalled);
        this.listEvent = null;
        this.itemsRemovedListCalled = false;
        this.testModel.addListChangeListener(LIST_NAME, (ListChangeListener)this.changeListener);
        this.testModel.testFireItemsRemovedList();
        this.verifyListRemoveEvent(5, REMOVED_OBJECT_VALUE);
        ChangeSupportTests.assertTrue((boolean)this.itemsRemovedListCalled);
        this.listEvent = null;
        this.itemsRemovedListCalled = false;
        this.testModel.removeListChangeListener(LIST_NAME, (ListChangeListener)this.changeListener);
        this.testModel.testFireItemsRemovedList();
        ChangeSupportTests.assertNull((Object)this.listEvent);
        ChangeSupportTests.assertFalse((boolean)this.itemsRemovedListCalled);
    }

    public void testFireItemsRemovedListNoChange() {
        this.listEvent = null;
        this.itemsRemovedListCalled = false;
        this.testModel.addChangeListener(this.changeListener);
        this.testModel.testFireItemsRemovedListNoChange();
        ChangeSupportTests.assertNull((Object)this.listEvent);
        ChangeSupportTests.assertFalse((boolean)this.itemsRemovedListCalled);
        this.listEvent = null;
        this.itemsRemovedListCalled = false;
        this.testModel.removeChangeListener(this.changeListener);
        this.testModel.testFireItemsRemovedListNoChange();
        ChangeSupportTests.assertNull((Object)this.listEvent);
        ChangeSupportTests.assertFalse((boolean)this.itemsRemovedListCalled);
        this.listEvent = null;
        this.itemsRemovedListCalled = false;
        this.testModel.addListChangeListener(LIST_NAME, (ListChangeListener)this.changeListener);
        this.testModel.testFireItemsRemovedListNoChange();
        ChangeSupportTests.assertNull((Object)this.listEvent);
        ChangeSupportTests.assertFalse((boolean)this.itemsRemovedListCalled);
        this.listEvent = null;
        this.itemsRemovedListCalled = false;
        this.testModel.removeListChangeListener(LIST_NAME, (ListChangeListener)this.changeListener);
        this.testModel.testFireItemsRemovedListNoChange();
        ChangeSupportTests.assertNull((Object)this.listEvent);
        ChangeSupportTests.assertFalse((boolean)this.itemsRemovedListCalled);
    }

    public void testFireItemRemovedList() {
        this.listEvent = null;
        this.itemsRemovedListCalled = false;
        this.testModel.addChangeListener(this.changeListener);
        this.testModel.testFireItemRemovedList();
        this.verifyListRemoveEvent(5, REMOVED_OBJECT_VALUE);
        ChangeSupportTests.assertTrue((boolean)this.itemsRemovedListCalled);
        this.listEvent = null;
        this.itemsRemovedListCalled = false;
        this.testModel.removeChangeListener(this.changeListener);
        this.testModel.testFireItemRemovedList();
        ChangeSupportTests.assertNull((Object)this.listEvent);
        ChangeSupportTests.assertFalse((boolean)this.itemsRemovedListCalled);
        this.listEvent = null;
        this.itemsRemovedListCalled = false;
        this.testModel.addListChangeListener(LIST_NAME, (ListChangeListener)this.changeListener);
        this.testModel.testFireItemRemovedList();
        this.verifyListRemoveEvent(5, REMOVED_OBJECT_VALUE);
        ChangeSupportTests.assertTrue((boolean)this.itemsRemovedListCalled);
        this.listEvent = null;
        this.itemsRemovedListCalled = false;
        this.testModel.removeListChangeListener(LIST_NAME, (ListChangeListener)this.changeListener);
        this.testModel.testFireItemRemovedList();
        ChangeSupportTests.assertNull((Object)this.listEvent);
        ChangeSupportTests.assertFalse((boolean)this.itemsRemovedListCalled);
    }

    public void testFireItemsReplacedListEvent() {
        this.listEvent = null;
        this.itemsReplacedListCalled = false;
        this.testModel.addChangeListener(this.changeListener);
        this.testModel.testFireItemsReplacedListEvent();
        this.verifyListReplaceEvent(2, ADDED_OBJECT_VALUE, REMOVED_OBJECT_VALUE);
        ChangeSupportTests.assertTrue((boolean)this.itemsReplacedListCalled);
        this.listEvent = null;
        this.itemsReplacedListCalled = false;
        this.testModel.removeChangeListener(this.changeListener);
        this.testModel.testFireItemsReplacedListEvent();
        ChangeSupportTests.assertNull((Object)this.listEvent);
        ChangeSupportTests.assertFalse((boolean)this.itemsReplacedListCalled);
        this.listEvent = null;
        this.itemsReplacedListCalled = false;
        this.testModel.addListChangeListener(LIST_NAME, (ListChangeListener)this.changeListener);
        this.testModel.testFireItemsReplacedListEvent();
        this.verifyListReplaceEvent(2, ADDED_OBJECT_VALUE, REMOVED_OBJECT_VALUE);
        ChangeSupportTests.assertTrue((boolean)this.itemsReplacedListCalled);
        this.listEvent = null;
        this.itemsReplacedListCalled = false;
        this.testModel.removeListChangeListener(LIST_NAME, (ListChangeListener)this.changeListener);
        this.testModel.testFireItemsReplacedListEvent();
        ChangeSupportTests.assertNull((Object)this.listEvent);
        ChangeSupportTests.assertFalse((boolean)this.itemsReplacedListCalled);
    }

    public void testFireItemsReplacedListEventNoChange() {
        this.listEvent = null;
        this.itemsReplacedListCalled = false;
        this.testModel.addChangeListener(this.changeListener);
        this.testModel.testFireItemsReplacedListEventNoChange();
        ChangeSupportTests.assertNull((Object)this.listEvent);
        ChangeSupportTests.assertFalse((boolean)this.itemsReplacedListCalled);
        this.listEvent = null;
        this.itemsReplacedListCalled = false;
        this.testModel.removeChangeListener(this.changeListener);
        this.testModel.testFireItemsReplacedListEventNoChange();
        ChangeSupportTests.assertNull((Object)this.listEvent);
        ChangeSupportTests.assertFalse((boolean)this.itemsReplacedListCalled);
        this.listEvent = null;
        this.itemsReplacedListCalled = false;
        this.testModel.addListChangeListener(LIST_NAME, (ListChangeListener)this.changeListener);
        this.testModel.testFireItemsReplacedListEventNoChange();
        ChangeSupportTests.assertNull((Object)this.listEvent);
        ChangeSupportTests.assertFalse((boolean)this.itemsReplacedListCalled);
        this.listEvent = null;
        this.itemsReplacedListCalled = false;
        this.testModel.removeListChangeListener(LIST_NAME, (ListChangeListener)this.changeListener);
        this.testModel.testFireItemsReplacedListEventNoChange();
        ChangeSupportTests.assertNull((Object)this.listEvent);
        ChangeSupportTests.assertFalse((boolean)this.itemsReplacedListCalled);
    }

    public void testFireItemsReplacedList() {
        this.listEvent = null;
        this.itemsReplacedListCalled = false;
        this.testModel.addChangeListener(this.changeListener);
        this.testModel.testFireItemsReplacedList();
        this.verifyListReplaceEvent(2, ADDED_OBJECT_VALUE, REMOVED_OBJECT_VALUE);
        ChangeSupportTests.assertTrue((boolean)this.itemsReplacedListCalled);
        this.listEvent = null;
        this.itemsReplacedListCalled = false;
        this.testModel.removeChangeListener(this.changeListener);
        this.testModel.testFireItemsReplacedList();
        ChangeSupportTests.assertNull((Object)this.listEvent);
        ChangeSupportTests.assertFalse((boolean)this.itemsReplacedListCalled);
        this.listEvent = null;
        this.itemsReplacedListCalled = false;
        this.testModel.addListChangeListener(LIST_NAME, (ListChangeListener)this.changeListener);
        this.testModel.testFireItemsReplacedList();
        this.verifyListReplaceEvent(2, ADDED_OBJECT_VALUE, REMOVED_OBJECT_VALUE);
        ChangeSupportTests.assertTrue((boolean)this.itemsReplacedListCalled);
        this.listEvent = null;
        this.itemsReplacedListCalled = false;
        this.testModel.removeListChangeListener(LIST_NAME, (ListChangeListener)this.changeListener);
        this.testModel.testFireItemsReplacedList();
        ChangeSupportTests.assertNull((Object)this.listEvent);
        ChangeSupportTests.assertFalse((boolean)this.itemsReplacedListCalled);
    }

    public void testFireItemsReplacedListNoChange() {
        this.listEvent = null;
        this.itemsReplacedListCalled = false;
        this.testModel.addChangeListener(this.changeListener);
        this.testModel.testFireItemsReplacedListNoChange();
        ChangeSupportTests.assertNull((Object)this.listEvent);
        ChangeSupportTests.assertFalse((boolean)this.itemsReplacedListCalled);
        this.listEvent = null;
        this.itemsReplacedListCalled = false;
        this.testModel.removeChangeListener(this.changeListener);
        this.testModel.testFireItemsReplacedListNoChange();
        ChangeSupportTests.assertNull((Object)this.listEvent);
        ChangeSupportTests.assertFalse((boolean)this.itemsReplacedListCalled);
        this.listEvent = null;
        this.itemsReplacedListCalled = false;
        this.testModel.addListChangeListener(LIST_NAME, (ListChangeListener)this.changeListener);
        this.testModel.testFireItemsReplacedListNoChange();
        ChangeSupportTests.assertNull((Object)this.listEvent);
        ChangeSupportTests.assertFalse((boolean)this.itemsReplacedListCalled);
        this.listEvent = null;
        this.itemsReplacedListCalled = false;
        this.testModel.removeListChangeListener(LIST_NAME, (ListChangeListener)this.changeListener);
        this.testModel.testFireItemsReplacedListNoChange();
        ChangeSupportTests.assertNull((Object)this.listEvent);
        ChangeSupportTests.assertFalse((boolean)this.itemsReplacedListCalled);
    }

    public void testFireItemReplacedList() {
        this.listEvent = null;
        this.itemsReplacedListCalled = false;
        this.testModel.addChangeListener(this.changeListener);
        this.testModel.testFireItemReplacedList();
        this.verifyListReplaceEvent(2, ADDED_OBJECT_VALUE, REMOVED_OBJECT_VALUE);
        ChangeSupportTests.assertTrue((boolean)this.itemsReplacedListCalled);
        this.listEvent = null;
        this.itemsReplacedListCalled = false;
        this.testModel.removeChangeListener(this.changeListener);
        this.testModel.testFireItemReplacedList();
        ChangeSupportTests.assertNull((Object)this.listEvent);
        ChangeSupportTests.assertFalse((boolean)this.itemsReplacedListCalled);
        this.listEvent = null;
        this.itemsReplacedListCalled = false;
        this.testModel.addListChangeListener(LIST_NAME, (ListChangeListener)this.changeListener);
        this.testModel.testFireItemReplacedList();
        this.verifyListReplaceEvent(2, ADDED_OBJECT_VALUE, REMOVED_OBJECT_VALUE);
        ChangeSupportTests.assertTrue((boolean)this.itemsReplacedListCalled);
        this.listEvent = null;
        this.itemsReplacedListCalled = false;
        this.testModel.removeListChangeListener(LIST_NAME, (ListChangeListener)this.changeListener);
        this.testModel.testFireItemReplacedList();
        ChangeSupportTests.assertNull((Object)this.listEvent);
        ChangeSupportTests.assertFalse((boolean)this.itemsReplacedListCalled);
    }

    public void testFireItemsMovedListEvent() {
        this.listEvent = null;
        this.itemsMovedListCalled = false;
        this.testModel.addChangeListener(this.changeListener);
        this.testModel.testFireItemsMovedListEvent();
        this.verifyListMoveEvent(7, 22);
        ChangeSupportTests.assertTrue((boolean)this.itemsMovedListCalled);
        this.listEvent = null;
        this.itemsMovedListCalled = false;
        this.testModel.removeChangeListener(this.changeListener);
        this.testModel.testFireItemsMovedListEvent();
        ChangeSupportTests.assertNull((Object)this.listEvent);
        ChangeSupportTests.assertFalse((boolean)this.itemsMovedListCalled);
        this.listEvent = null;
        this.itemsMovedListCalled = false;
        this.testModel.addListChangeListener(LIST_NAME, (ListChangeListener)this.changeListener);
        this.testModel.testFireItemsMovedListEvent();
        this.verifyListMoveEvent(7, 22);
        ChangeSupportTests.assertTrue((boolean)this.itemsMovedListCalled);
        this.listEvent = null;
        this.itemsMovedListCalled = false;
        this.testModel.removeListChangeListener(LIST_NAME, (ListChangeListener)this.changeListener);
        this.testModel.testFireItemsMovedListEvent();
        ChangeSupportTests.assertNull((Object)this.listEvent);
        ChangeSupportTests.assertFalse((boolean)this.itemsMovedListCalled);
    }

    public void testFireItemsMovedListEventNoChange() {
        this.listEvent = null;
        this.itemsMovedListCalled = false;
        this.testModel.addChangeListener(this.changeListener);
        this.testModel.testFireItemsMovedListEventNoChange();
        ChangeSupportTests.assertNull((Object)this.listEvent);
        ChangeSupportTests.assertFalse((boolean)this.itemsMovedListCalled);
        this.listEvent = null;
        this.itemsMovedListCalled = false;
        this.testModel.removeChangeListener(this.changeListener);
        this.testModel.testFireItemsMovedListEventNoChange();
        ChangeSupportTests.assertNull((Object)this.listEvent);
        ChangeSupportTests.assertFalse((boolean)this.itemsMovedListCalled);
        this.listEvent = null;
        this.itemsMovedListCalled = false;
        this.testModel.addListChangeListener(LIST_NAME, (ListChangeListener)this.changeListener);
        this.testModel.testFireItemsMovedListEventNoChange();
        ChangeSupportTests.assertNull((Object)this.listEvent);
        ChangeSupportTests.assertFalse((boolean)this.itemsMovedListCalled);
        this.listEvent = null;
        this.itemsMovedListCalled = false;
        this.testModel.removeListChangeListener(LIST_NAME, (ListChangeListener)this.changeListener);
        this.testModel.testFireItemsMovedListEventNoChange();
        ChangeSupportTests.assertNull((Object)this.listEvent);
        ChangeSupportTests.assertFalse((boolean)this.itemsMovedListCalled);
    }

    public void testFireItemsMovedList() {
        this.listEvent = null;
        this.itemsMovedListCalled = false;
        this.testModel.addChangeListener(this.changeListener);
        this.testModel.testFireItemsMovedList();
        this.verifyListMoveEvent(7, 22);
        ChangeSupportTests.assertTrue((boolean)this.itemsMovedListCalled);
        this.listEvent = null;
        this.itemsMovedListCalled = false;
        this.testModel.removeChangeListener(this.changeListener);
        this.testModel.testFireItemsMovedList();
        ChangeSupportTests.assertNull((Object)this.listEvent);
        ChangeSupportTests.assertFalse((boolean)this.itemsMovedListCalled);
        this.listEvent = null;
        this.itemsMovedListCalled = false;
        this.testModel.addListChangeListener(LIST_NAME, (ListChangeListener)this.changeListener);
        this.testModel.testFireItemsMovedList();
        this.verifyListMoveEvent(7, 22);
        ChangeSupportTests.assertTrue((boolean)this.itemsMovedListCalled);
        this.listEvent = null;
        this.itemsMovedListCalled = false;
        this.testModel.removeListChangeListener(LIST_NAME, (ListChangeListener)this.changeListener);
        this.testModel.testFireItemsMovedList();
        ChangeSupportTests.assertNull((Object)this.listEvent);
        ChangeSupportTests.assertFalse((boolean)this.itemsMovedListCalled);
    }

    public void testFireItemsMovedListNoChange() {
        this.listEvent = null;
        this.itemsMovedListCalled = false;
        this.testModel.addChangeListener(this.changeListener);
        this.testModel.testFireItemsMovedListNoChange();
        ChangeSupportTests.assertNull((Object)this.listEvent);
        ChangeSupportTests.assertFalse((boolean)this.itemsMovedListCalled);
        this.listEvent = null;
        this.itemsMovedListCalled = false;
        this.testModel.removeChangeListener(this.changeListener);
        this.testModel.testFireItemsMovedListNoChange();
        ChangeSupportTests.assertNull((Object)this.listEvent);
        ChangeSupportTests.assertFalse((boolean)this.itemsMovedListCalled);
        this.listEvent = null;
        this.itemsMovedListCalled = false;
        this.testModel.addListChangeListener(LIST_NAME, (ListChangeListener)this.changeListener);
        this.testModel.testFireItemsMovedListNoChange();
        ChangeSupportTests.assertNull((Object)this.listEvent);
        ChangeSupportTests.assertFalse((boolean)this.itemsMovedListCalled);
        this.listEvent = null;
        this.itemsMovedListCalled = false;
        this.testModel.removeListChangeListener(LIST_NAME, (ListChangeListener)this.changeListener);
        this.testModel.testFireItemsMovedListNoChange();
        ChangeSupportTests.assertNull((Object)this.listEvent);
        ChangeSupportTests.assertFalse((boolean)this.itemsMovedListCalled);
    }

    public void testFireItemMovedList() {
        this.listEvent = null;
        this.itemsMovedListCalled = false;
        this.testModel.addChangeListener(this.changeListener);
        this.testModel.testFireItemMovedList();
        this.verifyListMoveEvent(7, 22);
        ChangeSupportTests.assertTrue((boolean)this.itemsMovedListCalled);
        this.listEvent = null;
        this.itemsMovedListCalled = false;
        this.testModel.removeChangeListener(this.changeListener);
        this.testModel.testFireItemMovedList();
        ChangeSupportTests.assertNull((Object)this.listEvent);
        ChangeSupportTests.assertFalse((boolean)this.itemsMovedListCalled);
        this.listEvent = null;
        this.itemsMovedListCalled = false;
        this.testModel.addListChangeListener(LIST_NAME, (ListChangeListener)this.changeListener);
        this.testModel.testFireItemMovedList();
        this.verifyListMoveEvent(7, 22);
        ChangeSupportTests.assertTrue((boolean)this.itemsMovedListCalled);
        this.listEvent = null;
        this.itemsMovedListCalled = false;
        this.testModel.removeListChangeListener(LIST_NAME, (ListChangeListener)this.changeListener);
        this.testModel.testFireItemMovedList();
        ChangeSupportTests.assertNull((Object)this.listEvent);
        ChangeSupportTests.assertFalse((boolean)this.itemsMovedListCalled);
    }

    public void testFireListClearedEvent() {
        this.listEvent = null;
        this.listClearedCalled = false;
        this.testModel.addChangeListener(this.changeListener);
        this.testModel.testFireListClearedEvent();
        this.verifyListClearEvent();
        ChangeSupportTests.assertTrue((boolean)this.listClearedCalled);
        this.listEvent = null;
        this.listClearedCalled = false;
        this.testModel.removeChangeListener(this.changeListener);
        this.testModel.testFireListClearedEvent();
        ChangeSupportTests.assertNull((Object)this.listEvent);
        ChangeSupportTests.assertFalse((boolean)this.listClearedCalled);
        this.listEvent = null;
        this.listClearedCalled = false;
        this.testModel.addListChangeListener(LIST_NAME, (ListChangeListener)this.changeListener);
        this.testModel.testFireListClearedEvent();
        this.verifyListClearEvent();
        ChangeSupportTests.assertTrue((boolean)this.listClearedCalled);
        this.listEvent = null;
        this.listClearedCalled = false;
        this.testModel.removeListChangeListener(LIST_NAME, (ListChangeListener)this.changeListener);
        this.testModel.testFireListClearedEvent();
        ChangeSupportTests.assertNull((Object)this.listEvent);
        ChangeSupportTests.assertFalse((boolean)this.listClearedCalled);
    }

    public void testFireListCleared() {
        this.listEvent = null;
        this.listClearedCalled = false;
        this.testModel.addChangeListener(this.changeListener);
        this.testModel.testFireListCleared();
        this.verifyListClearEvent();
        ChangeSupportTests.assertTrue((boolean)this.listClearedCalled);
        this.listEvent = null;
        this.listClearedCalled = false;
        this.testModel.removeChangeListener(this.changeListener);
        this.testModel.testFireListCleared();
        ChangeSupportTests.assertNull((Object)this.listEvent);
        ChangeSupportTests.assertFalse((boolean)this.listClearedCalled);
        this.listEvent = null;
        this.listClearedCalled = false;
        this.testModel.addListChangeListener(LIST_NAME, (ListChangeListener)this.changeListener);
        this.testModel.testFireListCleared();
        this.verifyListClearEvent();
        ChangeSupportTests.assertTrue((boolean)this.listClearedCalled);
        this.listEvent = null;
        this.listClearedCalled = false;
        this.testModel.removeListChangeListener(LIST_NAME, (ListChangeListener)this.changeListener);
        this.testModel.testFireListCleared();
        ChangeSupportTests.assertNull((Object)this.listEvent);
        ChangeSupportTests.assertFalse((boolean)this.listClearedCalled);
    }

    public void testFireListChangedEvent() {
        this.listEvent = null;
        this.listChangedCalled = false;
        this.testModel.addChangeListener(this.changeListener);
        this.testModel.testFireListChangedEvent();
        this.verifyListChangeEvent();
        ChangeSupportTests.assertTrue((boolean)this.listChangedCalled);
        this.listEvent = null;
        this.listChangedCalled = false;
        this.testModel.removeChangeListener(this.changeListener);
        this.testModel.testFireListChangedEvent();
        ChangeSupportTests.assertNull((Object)this.listEvent);
        ChangeSupportTests.assertFalse((boolean)this.listChangedCalled);
        this.listEvent = null;
        this.listChangedCalled = false;
        this.testModel.addListChangeListener(LIST_NAME, (ListChangeListener)this.changeListener);
        this.testModel.testFireListChangedEvent();
        this.verifyListChangeEvent();
        ChangeSupportTests.assertTrue((boolean)this.listChangedCalled);
        this.listEvent = null;
        this.listChangedCalled = false;
        this.testModel.removeListChangeListener(LIST_NAME, (ListChangeListener)this.changeListener);
        this.testModel.testFireListChangedEvent();
        ChangeSupportTests.assertNull((Object)this.listEvent);
        ChangeSupportTests.assertFalse((boolean)this.listChangedCalled);
    }

    public void testFireListChanged() {
        this.listEvent = null;
        this.listChangedCalled = false;
        this.testModel.addChangeListener(this.changeListener);
        this.testModel.testFireListChanged();
        this.verifyListChangeEvent();
        ChangeSupportTests.assertTrue((boolean)this.listChangedCalled);
        this.listEvent = null;
        this.listChangedCalled = false;
        this.testModel.removeChangeListener(this.changeListener);
        this.testModel.testFireListChanged();
        ChangeSupportTests.assertNull((Object)this.listEvent);
        ChangeSupportTests.assertFalse((boolean)this.listChangedCalled);
        this.listEvent = null;
        this.listChangedCalled = false;
        this.testModel.addListChangeListener(LIST_NAME, (ListChangeListener)this.changeListener);
        this.testModel.testFireListChanged();
        this.verifyListChangeEvent();
        ChangeSupportTests.assertTrue((boolean)this.listChangedCalled);
        this.listEvent = null;
        this.listChangedCalled = false;
        this.testModel.removeListChangeListener(LIST_NAME, (ListChangeListener)this.changeListener);
        this.testModel.testFireListChanged();
        ChangeSupportTests.assertNull((Object)this.listEvent);
        ChangeSupportTests.assertFalse((boolean)this.listChangedCalled);
    }

    public void testAddItemToListIndex() {
        this.listEvent = null;
        this.itemsAddedListCalled = false;
        this.testModel.addChangeListener(this.changeListener);
        this.testModel.testAddItemToListIndex();
        this.verifyListAddEvent(2, "joo");
        ChangeSupportTests.assertTrue((boolean)this.itemsAddedListCalled);
        this.listEvent = null;
        this.itemsAddedListCalled = false;
        this.testModel.removeChangeListener(this.changeListener);
        this.testModel.testAddItemToListIndex();
        ChangeSupportTests.assertNull((Object)this.listEvent);
        ChangeSupportTests.assertFalse((boolean)this.itemsAddedListCalled);
        this.listEvent = null;
        this.itemsAddedListCalled = false;
        this.testModel.addListChangeListener(LIST_NAME, (ListChangeListener)this.changeListener);
        this.testModel.testAddItemToListIndex();
        this.verifyListAddEvent(2, "joo");
        ChangeSupportTests.assertTrue((boolean)this.itemsAddedListCalled);
        this.listEvent = null;
        this.itemsAddedListCalled = false;
        this.testModel.removeListChangeListener(LIST_NAME, (ListChangeListener)this.changeListener);
        this.testModel.testAddItemToListIndex();
        ChangeSupportTests.assertNull((Object)this.listEvent);
        ChangeSupportTests.assertFalse((boolean)this.itemsAddedListCalled);
    }

    public void testAddItemToList() {
        this.listEvent = null;
        this.itemsAddedListCalled = false;
        this.testModel.addChangeListener(this.changeListener);
        this.testModel.testAddItemToList();
        this.verifyListAddEvent(3, "joo");
        ChangeSupportTests.assertTrue((boolean)this.itemsAddedListCalled);
        this.listEvent = null;
        this.itemsAddedListCalled = false;
        this.testModel.removeChangeListener(this.changeListener);
        this.testModel.testAddItemToList();
        ChangeSupportTests.assertNull((Object)this.listEvent);
        ChangeSupportTests.assertFalse((boolean)this.itemsAddedListCalled);
        this.listEvent = null;
        this.itemsAddedListCalled = false;
        this.testModel.addListChangeListener(LIST_NAME, (ListChangeListener)this.changeListener);
        this.testModel.testAddItemToList();
        this.verifyListAddEvent(3, "joo");
        ChangeSupportTests.assertTrue((boolean)this.itemsAddedListCalled);
        this.listEvent = null;
        this.itemsAddedListCalled = false;
        this.testModel.removeListChangeListener(LIST_NAME, (ListChangeListener)this.changeListener);
        this.testModel.testAddItemToList();
        ChangeSupportTests.assertNull((Object)this.listEvent);
        ChangeSupportTests.assertFalse((boolean)this.itemsAddedListCalled);
    }

    public void testAddItemsToListIndex() {
        this.listEvent = null;
        this.itemsAddedListCalled = false;
        this.testModel.addChangeListener(this.changeListener);
        this.testModel.testAddItemsToListIndex();
        this.verifyListAddEvent(2, "joo");
        ChangeSupportTests.assertTrue((boolean)this.itemsAddedListCalled);
        this.listEvent = null;
        this.itemsAddedListCalled = false;
        this.testModel.removeChangeListener(this.changeListener);
        this.testModel.testAddItemsToListIndex();
        ChangeSupportTests.assertNull((Object)this.listEvent);
        ChangeSupportTests.assertFalse((boolean)this.itemsAddedListCalled);
        this.listEvent = null;
        this.itemsAddedListCalled = false;
        this.testModel.addListChangeListener(LIST_NAME, (ListChangeListener)this.changeListener);
        this.testModel.testAddItemsToListIndex();
        this.verifyListAddEvent(2, "joo");
        ChangeSupportTests.assertTrue((boolean)this.itemsAddedListCalled);
        this.listEvent = null;
        this.itemsAddedListCalled = false;
        this.testModel.removeListChangeListener(LIST_NAME, (ListChangeListener)this.changeListener);
        this.testModel.testAddItemsToListIndex();
        ChangeSupportTests.assertNull((Object)this.listEvent);
        ChangeSupportTests.assertFalse((boolean)this.itemsAddedListCalled);
    }

    public void testAddItemsToListIndexNoChange() {
        this.listEvent = null;
        this.itemsAddedListCalled = false;
        this.testModel.addChangeListener(this.changeListener);
        this.testModel.testAddItemsToListIndexNoChange();
        ChangeSupportTests.assertNull((Object)this.listEvent);
        ChangeSupportTests.assertFalse((boolean)this.itemsAddedListCalled);
        this.listEvent = null;
        this.itemsAddedListCalled = false;
        this.testModel.removeChangeListener(this.changeListener);
        this.testModel.testAddItemsToListIndexNoChange();
        ChangeSupportTests.assertNull((Object)this.listEvent);
        ChangeSupportTests.assertFalse((boolean)this.itemsAddedListCalled);
        this.listEvent = null;
        this.itemsAddedListCalled = false;
        this.testModel.addListChangeListener(LIST_NAME, (ListChangeListener)this.changeListener);
        this.testModel.testAddItemsToListIndexNoChange();
        ChangeSupportTests.assertNull((Object)this.listEvent);
        ChangeSupportTests.assertFalse((boolean)this.itemsAddedListCalled);
        this.listEvent = null;
        this.itemsAddedListCalled = false;
        this.testModel.removeListChangeListener(LIST_NAME, (ListChangeListener)this.changeListener);
        this.testModel.testAddItemsToListIndexNoChange();
        ChangeSupportTests.assertNull((Object)this.listEvent);
        ChangeSupportTests.assertFalse((boolean)this.itemsAddedListCalled);
    }

    public void testAddItemsToList() {
        this.listEvent = null;
        this.itemsAddedListCalled = false;
        this.testModel.addChangeListener(this.changeListener);
        this.testModel.testAddItemsToList();
        this.verifyListAddEvent(3, "joo");
        ChangeSupportTests.assertTrue((boolean)this.itemsAddedListCalled);
        this.listEvent = null;
        this.itemsAddedListCalled = false;
        this.testModel.removeChangeListener(this.changeListener);
        this.testModel.testAddItemsToList();
        ChangeSupportTests.assertNull((Object)this.listEvent);
        ChangeSupportTests.assertFalse((boolean)this.itemsAddedListCalled);
        this.listEvent = null;
        this.itemsAddedListCalled = false;
        this.testModel.addListChangeListener(LIST_NAME, (ListChangeListener)this.changeListener);
        this.testModel.testAddItemsToList();
        this.verifyListAddEvent(3, "joo");
        ChangeSupportTests.assertTrue((boolean)this.itemsAddedListCalled);
        this.listEvent = null;
        this.itemsAddedListCalled = false;
        this.testModel.removeListChangeListener(LIST_NAME, (ListChangeListener)this.changeListener);
        this.testModel.testAddItemsToList();
        ChangeSupportTests.assertNull((Object)this.listEvent);
        ChangeSupportTests.assertFalse((boolean)this.itemsAddedListCalled);
    }

    public void testAddItemsToListNoChange() {
        this.listEvent = null;
        this.itemsAddedListCalled = false;
        this.testModel.addChangeListener(this.changeListener);
        this.testModel.testAddItemsToListNoChange();
        ChangeSupportTests.assertNull((Object)this.listEvent);
        ChangeSupportTests.assertFalse((boolean)this.itemsAddedListCalled);
        this.listEvent = null;
        this.itemsAddedListCalled = false;
        this.testModel.removeChangeListener(this.changeListener);
        this.testModel.testAddItemsToListNoChange();
        ChangeSupportTests.assertNull((Object)this.listEvent);
        ChangeSupportTests.assertFalse((boolean)this.itemsAddedListCalled);
        this.listEvent = null;
        this.itemsAddedListCalled = false;
        this.testModel.addListChangeListener(LIST_NAME, (ListChangeListener)this.changeListener);
        this.testModel.testAddItemsToListNoChange();
        ChangeSupportTests.assertNull((Object)this.listEvent);
        ChangeSupportTests.assertFalse((boolean)this.itemsAddedListCalled);
        this.listEvent = null;
        this.itemsAddedListCalled = false;
        this.testModel.removeListChangeListener(LIST_NAME, (ListChangeListener)this.changeListener);
        this.testModel.testAddItemsToListNoChange();
        ChangeSupportTests.assertNull((Object)this.listEvent);
        ChangeSupportTests.assertFalse((boolean)this.itemsAddedListCalled);
    }

    public void testRemoveItemFromListIndex() {
        this.listEvent = null;
        this.itemsRemovedListCalled = false;
        this.testModel.addChangeListener(this.changeListener);
        this.testModel.testRemoveItemFromListIndex();
        this.verifyListRemoveEvent(1, "bar");
        ChangeSupportTests.assertTrue((boolean)this.itemsRemovedListCalled);
        this.listEvent = null;
        this.itemsRemovedListCalled = false;
        this.testModel.removeChangeListener(this.changeListener);
        this.testModel.testRemoveItemFromListIndex();
        ChangeSupportTests.assertNull((Object)this.listEvent);
        ChangeSupportTests.assertFalse((boolean)this.itemsRemovedListCalled);
        this.listEvent = null;
        this.itemsRemovedListCalled = false;
        this.testModel.addListChangeListener(LIST_NAME, (ListChangeListener)this.changeListener);
        this.testModel.testRemoveItemFromListIndex();
        this.verifyListRemoveEvent(1, "bar");
        ChangeSupportTests.assertTrue((boolean)this.itemsRemovedListCalled);
        this.listEvent = null;
        this.itemsRemovedListCalled = false;
        this.testModel.removeListChangeListener(LIST_NAME, (ListChangeListener)this.changeListener);
        this.testModel.testRemoveItemFromListIndex();
        ChangeSupportTests.assertNull((Object)this.listEvent);
        ChangeSupportTests.assertFalse((boolean)this.itemsRemovedListCalled);
    }

    public void testRemoveItemFromList() {
        this.listEvent = null;
        this.itemsRemovedListCalled = false;
        this.testModel.addChangeListener(this.changeListener);
        this.testModel.testRemoveItemFromList();
        this.verifyListRemoveEvent(1, "bar");
        ChangeSupportTests.assertTrue((boolean)this.itemsRemovedListCalled);
        this.listEvent = null;
        this.itemsRemovedListCalled = false;
        this.testModel.removeChangeListener(this.changeListener);
        this.testModel.testRemoveItemFromList();
        ChangeSupportTests.assertNull((Object)this.listEvent);
        ChangeSupportTests.assertFalse((boolean)this.itemsRemovedListCalled);
        this.listEvent = null;
        this.itemsRemovedListCalled = false;
        this.testModel.addListChangeListener(LIST_NAME, (ListChangeListener)this.changeListener);
        this.testModel.testRemoveItemFromList();
        this.verifyListRemoveEvent(1, "bar");
        ChangeSupportTests.assertTrue((boolean)this.itemsRemovedListCalled);
        this.listEvent = null;
        this.itemsRemovedListCalled = false;
        this.testModel.removeListChangeListener(LIST_NAME, (ListChangeListener)this.changeListener);
        this.testModel.testRemoveItemFromList();
        ChangeSupportTests.assertNull((Object)this.listEvent);
        ChangeSupportTests.assertFalse((boolean)this.itemsRemovedListCalled);
    }

    public void testRemoveItemsFromListIndex() {
        this.listEvent = null;
        this.itemsRemovedListCalled = false;
        this.testModel.addChangeListener(this.changeListener);
        this.testModel.testRemoveItemsFromListIndex();
        this.verifyListRemoveEvent(1, "bar");
        ChangeSupportTests.assertTrue((boolean)this.itemsRemovedListCalled);
        this.listEvent = null;
        this.itemsRemovedListCalled = false;
        this.testModel.removeChangeListener(this.changeListener);
        this.testModel.testRemoveItemsFromListIndex();
        ChangeSupportTests.assertNull((Object)this.listEvent);
        ChangeSupportTests.assertFalse((boolean)this.itemsRemovedListCalled);
        this.listEvent = null;
        this.itemsRemovedListCalled = false;
        this.testModel.addListChangeListener(LIST_NAME, (ListChangeListener)this.changeListener);
        this.testModel.testRemoveItemsFromListIndex();
        this.verifyListRemoveEvent(1, "bar");
        ChangeSupportTests.assertTrue((boolean)this.itemsRemovedListCalled);
        this.listEvent = null;
        this.itemsRemovedListCalled = false;
        this.testModel.removeListChangeListener(LIST_NAME, (ListChangeListener)this.changeListener);
        this.testModel.testRemoveItemsFromListIndex();
        ChangeSupportTests.assertNull((Object)this.listEvent);
        ChangeSupportTests.assertFalse((boolean)this.itemsRemovedListCalled);
    }

    public void testRemoveItemsFromListIndexNoChange() {
        this.listEvent = null;
        this.itemsRemovedListCalled = false;
        this.testModel.addChangeListener(this.changeListener);
        this.testModel.testRemoveItemsFromListIndexNoChange();
        ChangeSupportTests.assertNull((Object)this.listEvent);
        ChangeSupportTests.assertFalse((boolean)this.itemsRemovedListCalled);
        this.listEvent = null;
        this.itemsRemovedListCalled = false;
        this.testModel.removeChangeListener(this.changeListener);
        this.testModel.testRemoveItemsFromListIndexNoChange();
        ChangeSupportTests.assertNull((Object)this.listEvent);
        ChangeSupportTests.assertFalse((boolean)this.itemsRemovedListCalled);
        this.listEvent = null;
        this.itemsRemovedListCalled = false;
        this.testModel.addListChangeListener(LIST_NAME, (ListChangeListener)this.changeListener);
        this.testModel.testRemoveItemsFromListIndexNoChange();
        ChangeSupportTests.assertNull((Object)this.listEvent);
        ChangeSupportTests.assertFalse((boolean)this.itemsRemovedListCalled);
        this.listEvent = null;
        this.itemsRemovedListCalled = false;
        this.testModel.removeListChangeListener(LIST_NAME, (ListChangeListener)this.changeListener);
        this.testModel.testRemoveItemsFromListIndexNoChange();
        ChangeSupportTests.assertNull((Object)this.listEvent);
        ChangeSupportTests.assertFalse((boolean)this.itemsRemovedListCalled);
    }

    public void testRemoveItemsFromList() {
        this.listEvent = null;
        this.itemsRemovedListCalled = false;
        this.testModel.addChangeListener(this.changeListener);
        this.testModel.testRemoveItemsFromList();
        this.verifyListRemoveEvent(1, "bar");
        ChangeSupportTests.assertTrue((boolean)this.itemsRemovedListCalled);
        this.listEvent = null;
        this.itemsRemovedListCalled = false;
        this.testModel.removeChangeListener(this.changeListener);
        this.testModel.testRemoveItemsFromList();
        ChangeSupportTests.assertNull((Object)this.listEvent);
        ChangeSupportTests.assertFalse((boolean)this.itemsRemovedListCalled);
        this.listEvent = null;
        this.itemsRemovedListCalled = false;
        this.testModel.addListChangeListener(LIST_NAME, (ListChangeListener)this.changeListener);
        this.testModel.testRemoveItemsFromList();
        this.verifyListRemoveEvent(1, "bar");
        ChangeSupportTests.assertTrue((boolean)this.itemsRemovedListCalled);
        this.listEvent = null;
        this.itemsRemovedListCalled = false;
        this.testModel.removeListChangeListener(LIST_NAME, (ListChangeListener)this.changeListener);
        this.testModel.testRemoveItemsFromList();
        ChangeSupportTests.assertNull((Object)this.listEvent);
        ChangeSupportTests.assertFalse((boolean)this.itemsRemovedListCalled);
    }

    public void testRemoveItemsFromListNoChange() {
        this.listEvent = null;
        this.itemsRemovedListCalled = false;
        this.testModel.addChangeListener(this.changeListener);
        this.testModel.testRemoveItemsFromListNoChange();
        ChangeSupportTests.assertNull((Object)this.listEvent);
        ChangeSupportTests.assertFalse((boolean)this.itemsRemovedListCalled);
        this.listEvent = null;
        this.itemsRemovedListCalled = false;
        this.testModel.removeChangeListener(this.changeListener);
        this.testModel.testRemoveItemsFromListNoChange();
        ChangeSupportTests.assertNull((Object)this.listEvent);
        ChangeSupportTests.assertFalse((boolean)this.itemsRemovedListCalled);
        this.listEvent = null;
        this.itemsRemovedListCalled = false;
        this.testModel.addListChangeListener(LIST_NAME, (ListChangeListener)this.changeListener);
        this.testModel.testRemoveItemsFromListNoChange();
        ChangeSupportTests.assertNull((Object)this.listEvent);
        ChangeSupportTests.assertFalse((boolean)this.itemsRemovedListCalled);
        this.listEvent = null;
        this.itemsRemovedListCalled = false;
        this.testModel.removeListChangeListener(LIST_NAME, (ListChangeListener)this.changeListener);
        this.testModel.testRemoveItemsFromListNoChange();
        ChangeSupportTests.assertNull((Object)this.listEvent);
        ChangeSupportTests.assertFalse((boolean)this.itemsRemovedListCalled);
    }

    public void testRetainItemsInList() {
        this.listEvent = null;
        this.itemsRemovedListCalled = false;
        this.testModel.addChangeListener(this.changeListener);
        this.testModel.testRetainItemsInList();
        this.verifyListRemoveEvent(0, "foo");
        ChangeSupportTests.assertTrue((boolean)this.itemsRemovedListCalled);
        this.listEvent = null;
        this.itemsRemovedListCalled = false;
        this.testModel.removeChangeListener(this.changeListener);
        this.testModel.testRetainItemsInList();
        ChangeSupportTests.assertNull((Object)this.listEvent);
        ChangeSupportTests.assertFalse((boolean)this.itemsRemovedListCalled);
        this.listEvent = null;
        this.itemsRemovedListCalled = false;
        this.testModel.addListChangeListener(LIST_NAME, (ListChangeListener)this.changeListener);
        this.testModel.testRetainItemsInList();
        this.verifyListRemoveEvent(0, "foo");
        ChangeSupportTests.assertTrue((boolean)this.itemsRemovedListCalled);
        this.listEvent = null;
        this.itemsRemovedListCalled = false;
        this.testModel.removeListChangeListener(LIST_NAME, (ListChangeListener)this.changeListener);
        this.testModel.testRetainItemsInList();
        ChangeSupportTests.assertNull((Object)this.listEvent);
        ChangeSupportTests.assertFalse((boolean)this.itemsRemovedListCalled);
    }

    public void testReplaceItemInList() {
        this.listEvent = null;
        this.itemsReplacedListCalled = false;
        this.testModel.addChangeListener(this.changeListener);
        this.testModel.testReplaceItemInList();
        this.verifyListReplaceEvent(1, "xxx", "bar");
        ChangeSupportTests.assertTrue((boolean)this.itemsReplacedListCalled);
        this.listEvent = null;
        this.itemsReplacedListCalled = false;
        this.testModel.removeChangeListener(this.changeListener);
        this.testModel.testReplaceItemInList();
        ChangeSupportTests.assertNull((Object)this.listEvent);
        ChangeSupportTests.assertFalse((boolean)this.itemsReplacedListCalled);
        this.listEvent = null;
        this.itemsReplacedListCalled = false;
        this.testModel.addListChangeListener(LIST_NAME, (ListChangeListener)this.changeListener);
        this.testModel.testReplaceItemInList();
        this.verifyListReplaceEvent(1, "xxx", "bar");
        ChangeSupportTests.assertTrue((boolean)this.itemsReplacedListCalled);
        this.listEvent = null;
        this.itemsReplacedListCalled = false;
        this.testModel.removeListChangeListener(LIST_NAME, (ListChangeListener)this.changeListener);
        this.testModel.testReplaceItemInList();
        ChangeSupportTests.assertNull((Object)this.listEvent);
        ChangeSupportTests.assertFalse((boolean)this.itemsReplacedListCalled);
    }

    public void testSetItemsInList() {
        this.listEvent = null;
        this.itemsReplacedListCalled = false;
        this.testModel.addChangeListener(this.changeListener);
        this.testModel.testSetItemsInList();
        this.verifyListReplaceEvent(1, "xxx", "bar");
        ChangeSupportTests.assertTrue((boolean)this.itemsReplacedListCalled);
        this.listEvent = null;
        this.itemsReplacedListCalled = false;
        this.testModel.removeChangeListener(this.changeListener);
        this.testModel.testSetItemsInList();
        ChangeSupportTests.assertNull((Object)this.listEvent);
        ChangeSupportTests.assertFalse((boolean)this.itemsReplacedListCalled);
        this.listEvent = null;
        this.itemsReplacedListCalled = false;
        this.testModel.addListChangeListener(LIST_NAME, (ListChangeListener)this.changeListener);
        this.testModel.testSetItemsInList();
        this.verifyListReplaceEvent(1, "xxx", "bar");
        ChangeSupportTests.assertTrue((boolean)this.itemsReplacedListCalled);
        this.listEvent = null;
        this.itemsReplacedListCalled = false;
        this.testModel.removeListChangeListener(LIST_NAME, (ListChangeListener)this.changeListener);
        this.testModel.testSetItemsInList();
        ChangeSupportTests.assertNull((Object)this.listEvent);
        ChangeSupportTests.assertFalse((boolean)this.itemsReplacedListCalled);
    }

    public void testMoveItemsInList() {
        this.listEvent = null;
        this.itemsMovedListCalled = false;
        this.testModel.addChangeListener(this.changeListener);
        this.testModel.testMoveItemsInList();
        this.verifyListMoveEvent(2, 4, 2);
        ChangeSupportTests.assertTrue((boolean)this.itemsMovedListCalled);
        this.listEvent = null;
        this.itemsMovedListCalled = false;
        this.testModel.removeChangeListener(this.changeListener);
        this.testModel.testMoveItemsInList();
        ChangeSupportTests.assertNull((Object)this.listEvent);
        ChangeSupportTests.assertFalse((boolean)this.itemsMovedListCalled);
        this.listEvent = null;
        this.itemsMovedListCalled = false;
        this.testModel.addListChangeListener(LIST_NAME, (ListChangeListener)this.changeListener);
        this.testModel.testMoveItemsInList();
        this.verifyListMoveEvent(2, 4, 2);
        ChangeSupportTests.assertTrue((boolean)this.itemsMovedListCalled);
        this.listEvent = null;
        this.itemsMovedListCalled = false;
        this.testModel.removeListChangeListener(LIST_NAME, (ListChangeListener)this.changeListener);
        this.testModel.testMoveItemsInList();
        ChangeSupportTests.assertNull((Object)this.listEvent);
        ChangeSupportTests.assertFalse((boolean)this.itemsMovedListCalled);
    }

    public void testClearList() {
        this.listEvent = null;
        this.listClearedCalled = false;
        this.testModel.addChangeListener(this.changeListener);
        this.testModel.testClearList();
        this.verifyListClearEvent();
        ChangeSupportTests.assertTrue((boolean)this.listClearedCalled);
        this.listEvent = null;
        this.listClearedCalled = false;
        this.testModel.removeChangeListener(this.changeListener);
        this.testModel.testClearList();
        ChangeSupportTests.assertNull((Object)this.listEvent);
        ChangeSupportTests.assertFalse((boolean)this.listClearedCalled);
        this.listEvent = null;
        this.listClearedCalled = false;
        this.testModel.addListChangeListener(LIST_NAME, (ListChangeListener)this.changeListener);
        this.testModel.testClearList();
        this.verifyListClearEvent();
        ChangeSupportTests.assertTrue((boolean)this.listClearedCalled);
        this.listEvent = null;
        this.listClearedCalled = false;
        this.testModel.removeListChangeListener(LIST_NAME, (ListChangeListener)this.changeListener);
        this.testModel.testClearList();
        ChangeSupportTests.assertNull((Object)this.listEvent);
        ChangeSupportTests.assertFalse((boolean)this.listClearedCalled);
    }

    public void testSynchronizeList() {
        this.listEvent = null;
        this.itemsReplacedListCalled = false;
        this.itemsRemovedListCalled = false;
        this.testModel.addChangeListener(this.changeListener);
        this.testModel.testSynchronizeList();
        ChangeSupportTests.assertNotNull((Object)this.listEvent);
        ChangeSupportTests.assertTrue((boolean)this.itemsReplacedListCalled);
        ChangeSupportTests.assertTrue((boolean)this.itemsRemovedListCalled);
        this.listEvent = null;
        this.itemsReplacedListCalled = false;
        this.itemsRemovedListCalled = false;
        this.testModel.removeChangeListener(this.changeListener);
        this.testModel.testSynchronizeList();
        ChangeSupportTests.assertNull((Object)this.listEvent);
        ChangeSupportTests.assertFalse((boolean)this.itemsReplacedListCalled);
        ChangeSupportTests.assertFalse((boolean)this.itemsRemovedListCalled);
        this.listEvent = null;
        this.itemsReplacedListCalled = false;
        this.itemsRemovedListCalled = false;
        this.testModel.addListChangeListener(LIST_NAME, (ListChangeListener)this.changeListener);
        this.testModel.testSynchronizeList();
        ChangeSupportTests.assertNotNull((Object)this.listEvent);
        ChangeSupportTests.assertTrue((boolean)this.itemsReplacedListCalled);
        ChangeSupportTests.assertTrue((boolean)this.itemsRemovedListCalled);
        this.listEvent = null;
        this.itemsReplacedListCalled = false;
        this.itemsRemovedListCalled = false;
        this.testModel.removeListChangeListener(LIST_NAME, (ListChangeListener)this.changeListener);
        this.testModel.testSynchronizeList();
        ChangeSupportTests.assertNull((Object)this.listEvent);
        ChangeSupportTests.assertFalse((boolean)this.itemsReplacedListCalled);
        ChangeSupportTests.assertFalse((boolean)this.itemsRemovedListCalled);
    }

    public void testHasAnyListChangeListeners() {
        ChangeSupportTests.assertTrue((boolean)this.testModel.hasNoListChangeListeners(LIST_NAME));
        this.testModel.addChangeListener(this.changeListener);
        ChangeSupportTests.assertTrue((boolean)this.testModel.hasAnyListChangeListeners(LIST_NAME));
        this.testModel.removeChangeListener(this.changeListener);
        ChangeSupportTests.assertTrue((boolean)this.testModel.hasNoListChangeListeners(LIST_NAME));
        ChangeSupportTests.assertTrue((boolean)this.testModel.hasNoListChangeListeners(LIST_NAME));
        this.testModel.addListChangeListener(LIST_NAME, (ListChangeListener)this.changeListener);
        ChangeSupportTests.assertTrue((boolean)this.testModel.hasAnyListChangeListeners(LIST_NAME));
        this.testModel.removeListChangeListener(LIST_NAME, (ListChangeListener)this.changeListener);
        ChangeSupportTests.assertTrue((boolean)this.testModel.hasNoListChangeListeners(LIST_NAME));
    }

    public void testAddNullListListener() {
        boolean exCaught = false;
        try {
            this.testModel.addListChangeListener("foo", null);
        }
        catch (NullPointerException nullPointerException) {
            exCaught = true;
        }
        ChangeSupportTests.assertTrue((boolean)exCaught);
    }

    public void testRemoveBogusListListener() {
        boolean exCaught = false;
        try {
            this.testModel.removeListChangeListener("foo", (ListChangeListener)this.changeListener);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            exCaught = true;
        }
        ChangeSupportTests.assertTrue((boolean)exCaught);
        this.testModel.addPropertyChangeListener("foo", (PropertyChangeListener)this.changeListener);
        exCaught = false;
        try {
            this.testModel.removeListChangeListener("foo", (ListChangeListener)this.changeListener);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            exCaught = true;
        }
        ChangeSupportTests.assertTrue((boolean)exCaught);
        this.testModel.addListChangeListener("foo", (ListChangeListener)this.changeListener);
        exCaught = false;
        try {
            this.testModel.removeListChangeListener("foo", (ListChangeListener)new ListChangeAdapter());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            exCaught = true;
        }
        ChangeSupportTests.assertTrue((boolean)exCaught);
        exCaught = false;
        try {
            this.testModel.removeListChangeListener("foo", (ListChangeListener)new ListChangeAdapter());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            exCaught = true;
        }
        ChangeSupportTests.assertTrue((boolean)exCaught);
    }

    private void verifyListAddEvent(int index, Object item) {
        ChangeSupportTests.assertNotNull((Object)this.listEvent);
        ChangeSupportTests.assertEquals((Object)this.testModel, (Object)this.listEvent.getSource());
        ChangeSupportTests.assertEquals((String)LIST_NAME, (String)this.listEvent.getListName());
        ChangeSupportTests.assertEquals((int)index, (int)((ListAddEvent)this.listEvent).getIndex());
        ChangeSupportTests.assertEquals((Object)item, ((ListAddEvent)this.listEvent).getItems().iterator().next());
    }

    private void verifyListRemoveEvent(int index, Object item) {
        ChangeSupportTests.assertNotNull((Object)this.listEvent);
        ChangeSupportTests.assertEquals((Object)this.testModel, (Object)this.listEvent.getSource());
        ChangeSupportTests.assertEquals((String)LIST_NAME, (String)this.listEvent.getListName());
        ChangeSupportTests.assertEquals((int)index, (int)((ListRemoveEvent)this.listEvent).getIndex());
        ChangeSupportTests.assertEquals((Object)item, ((ListRemoveEvent)this.listEvent).getItems().iterator().next());
    }

    private void verifyListReplaceEvent(int index, Object newItem, Object oldItem) {
        ChangeSupportTests.assertNotNull((Object)this.listEvent);
        ChangeSupportTests.assertEquals((Object)this.testModel, (Object)this.listEvent.getSource());
        ChangeSupportTests.assertEquals((String)LIST_NAME, (String)this.listEvent.getListName());
        ChangeSupportTests.assertEquals((int)index, (int)((ListReplaceEvent)this.listEvent).getIndex());
        ChangeSupportTests.assertEquals((Object)newItem, ((ListReplaceEvent)this.listEvent).getNewItems().iterator().next());
        ChangeSupportTests.assertEquals((Object)oldItem, ((ListReplaceEvent)this.listEvent).getOldItems().iterator().next());
    }

    private void verifyListMoveEvent(int targetIndex, int sourceIndex) {
        this.verifyListMoveEvent(targetIndex, sourceIndex, 1);
    }

    private void verifyListMoveEvent(int targetIndex, int sourceIndex, int length) {
        ChangeSupportTests.assertNotNull((Object)this.listEvent);
        ChangeSupportTests.assertEquals((Object)this.testModel, (Object)this.listEvent.getSource());
        ChangeSupportTests.assertEquals((String)LIST_NAME, (String)this.listEvent.getListName());
        ChangeSupportTests.assertEquals((int)targetIndex, (int)((ListMoveEvent)this.listEvent).getTargetIndex());
        ChangeSupportTests.assertEquals((int)sourceIndex, (int)((ListMoveEvent)this.listEvent).getSourceIndex());
        ChangeSupportTests.assertEquals((int)length, (int)((ListMoveEvent)this.listEvent).getLength());
    }

    private void verifyListClearEvent() {
        ChangeSupportTests.assertNotNull((Object)this.listEvent);
        ChangeSupportTests.assertEquals((Object)this.testModel, (Object)this.listEvent.getSource());
        ChangeSupportTests.assertEquals((String)LIST_NAME, (String)this.listEvent.getListName());
        ChangeSupportTests.assertEquals(ListClearEvent.class, this.listEvent.getClass());
    }

    private void verifyListChangeEvent() {
        ChangeSupportTests.assertNotNull((Object)this.listEvent);
        ChangeSupportTests.assertEquals((Object)this.testModel, (Object)this.listEvent.getSource());
        ChangeSupportTests.assertEquals((String)LIST_NAME, (String)this.listEvent.getListName());
        ChangeSupportTests.assertEquals(ListChangeEvent.class, this.listEvent.getClass());
    }

    public void testFireNodeAddedTree() {
        this.treeEvent = null;
        this.nodeAddedCalled = false;
        this.testModel.addChangeListener(this.changeListener);
        this.testModel.testFireNodeAddedTree();
        this.verifyTreeEvent(OBJECT_PATH);
        ChangeSupportTests.assertTrue((boolean)this.nodeAddedCalled);
        this.treeEvent = null;
        this.nodeAddedCalled = false;
        this.testModel.removeChangeListener(this.changeListener);
        this.testModel.testFireNodeAddedTree();
        ChangeSupportTests.assertNull((Object)this.treeEvent);
        ChangeSupportTests.assertFalse((boolean)this.nodeAddedCalled);
        this.treeEvent = null;
        this.nodeAddedCalled = false;
        this.testModel.addTreeChangeListener(TREE_NAME, (TreeChangeListener)this.changeListener);
        this.testModel.testFireNodeAddedTree();
        this.verifyTreeEvent(OBJECT_PATH);
        ChangeSupportTests.assertTrue((boolean)this.nodeAddedCalled);
        this.treeEvent = null;
        this.nodeAddedCalled = false;
        this.testModel.removeTreeChangeListener(TREE_NAME, (TreeChangeListener)this.changeListener);
        this.testModel.testFireNodeAddedTree();
        ChangeSupportTests.assertNull((Object)this.treeEvent);
        ChangeSupportTests.assertFalse((boolean)this.nodeAddedCalled);
    }

    public void testFireNodeAddedTreeEvent() {
        this.treeEvent = null;
        this.nodeAddedCalled = false;
        this.testModel.addChangeListener(this.changeListener);
        this.testModel.testFireNodeAddedTreeEvent();
        this.verifyTreeEvent(OBJECT_PATH);
        ChangeSupportTests.assertTrue((boolean)this.nodeAddedCalled);
        this.treeEvent = null;
        this.nodeAddedCalled = false;
        this.testModel.removeChangeListener(this.changeListener);
        this.testModel.testFireNodeAddedTreeEvent();
        ChangeSupportTests.assertNull((Object)this.treeEvent);
        ChangeSupportTests.assertFalse((boolean)this.nodeAddedCalled);
        this.treeEvent = null;
        this.nodeAddedCalled = false;
        this.testModel.addTreeChangeListener(TREE_NAME, (TreeChangeListener)this.changeListener);
        this.testModel.testFireNodeAddedTreeEvent();
        this.verifyTreeEvent(OBJECT_PATH);
        ChangeSupportTests.assertTrue((boolean)this.nodeAddedCalled);
        this.treeEvent = null;
        this.nodeAddedCalled = false;
        this.testModel.removeTreeChangeListener(TREE_NAME, (TreeChangeListener)this.changeListener);
        this.testModel.testFireNodeAddedTreeEvent();
        ChangeSupportTests.assertNull((Object)this.treeEvent);
        ChangeSupportTests.assertFalse((boolean)this.nodeAddedCalled);
    }

    public void testFireNodeRemovedTreeEvent() {
        this.treeEvent = null;
        this.nodeRemovedCalled = false;
        this.testModel.addChangeListener(this.changeListener);
        this.testModel.testFireNodeRemovedTreeEvent();
        this.verifyTreeEvent(OBJECT_PATH);
        ChangeSupportTests.assertTrue((boolean)this.nodeRemovedCalled);
        this.treeEvent = null;
        this.nodeRemovedCalled = false;
        this.testModel.removeChangeListener(this.changeListener);
        this.testModel.testFireNodeRemovedTreeEvent();
        ChangeSupportTests.assertNull((Object)this.treeEvent);
        ChangeSupportTests.assertFalse((boolean)this.nodeRemovedCalled);
        this.treeEvent = null;
        this.nodeRemovedCalled = false;
        this.testModel.addTreeChangeListener(TREE_NAME, (TreeChangeListener)this.changeListener);
        this.testModel.testFireNodeRemovedTreeEvent();
        this.verifyTreeEvent(OBJECT_PATH);
        ChangeSupportTests.assertTrue((boolean)this.nodeRemovedCalled);
        this.treeEvent = null;
        this.nodeRemovedCalled = false;
        this.testModel.removeTreeChangeListener(TREE_NAME, (TreeChangeListener)this.changeListener);
        this.testModel.testFireNodeRemovedTreeEvent();
        ChangeSupportTests.assertNull((Object)this.treeEvent);
        ChangeSupportTests.assertFalse((boolean)this.nodeRemovedCalled);
    }

    public void testFireNodeRemovedTree() {
        this.treeEvent = null;
        this.nodeRemovedCalled = false;
        this.testModel.addChangeListener(this.changeListener);
        this.testModel.testFireNodeRemovedTree();
        this.verifyTreeEvent(OBJECT_PATH);
        ChangeSupportTests.assertTrue((boolean)this.nodeRemovedCalled);
        this.treeEvent = null;
        this.nodeRemovedCalled = false;
        this.testModel.removeChangeListener(this.changeListener);
        this.testModel.testFireNodeRemovedTree();
        ChangeSupportTests.assertNull((Object)this.treeEvent);
        ChangeSupportTests.assertFalse((boolean)this.nodeRemovedCalled);
        this.treeEvent = null;
        this.nodeRemovedCalled = false;
        this.testModel.addTreeChangeListener(TREE_NAME, (TreeChangeListener)this.changeListener);
        this.testModel.testFireNodeRemovedTree();
        this.verifyTreeEvent(OBJECT_PATH);
        ChangeSupportTests.assertTrue((boolean)this.nodeRemovedCalled);
        this.treeEvent = null;
        this.nodeRemovedCalled = false;
        this.testModel.removeTreeChangeListener(TREE_NAME, (TreeChangeListener)this.changeListener);
        this.testModel.testFireNodeRemovedTree();
        ChangeSupportTests.assertNull((Object)this.treeEvent);
        ChangeSupportTests.assertFalse((boolean)this.nodeRemovedCalled);
    }

    public void testFireTreeClearedEvent() {
        this.treeEvent = null;
        this.treeClearedCalled = false;
        this.testModel.addChangeListener(this.changeListener);
        this.testModel.testFireTreeClearedEvent();
        this.verifyTreeEvent(null);
        ChangeSupportTests.assertTrue((boolean)this.treeClearedCalled);
        this.treeEvent = null;
        this.treeClearedCalled = false;
        this.testModel.removeChangeListener(this.changeListener);
        this.testModel.testFireTreeClearedEvent();
        ChangeSupportTests.assertNull((Object)this.treeEvent);
        ChangeSupportTests.assertFalse((boolean)this.treeClearedCalled);
        this.treeEvent = null;
        this.treeClearedCalled = false;
        this.testModel.addTreeChangeListener(TREE_NAME, (TreeChangeListener)this.changeListener);
        this.testModel.testFireTreeClearedEvent();
        this.verifyTreeEvent(null);
        ChangeSupportTests.assertTrue((boolean)this.treeClearedCalled);
        this.treeEvent = null;
        this.treeClearedCalled = false;
        this.testModel.removeTreeChangeListener(TREE_NAME, (TreeChangeListener)this.changeListener);
        this.testModel.testFireTreeClearedEvent();
        ChangeSupportTests.assertNull((Object)this.treeEvent);
        ChangeSupportTests.assertFalse((boolean)this.treeClearedCalled);
    }

    public void testFireTreeCleared() {
        this.treeEvent = null;
        this.treeClearedCalled = false;
        this.testModel.addChangeListener(this.changeListener);
        this.testModel.testFireTreeCleared();
        this.verifyTreeEvent(null);
        ChangeSupportTests.assertTrue((boolean)this.treeClearedCalled);
        this.treeEvent = null;
        this.treeClearedCalled = false;
        this.testModel.removeChangeListener(this.changeListener);
        this.testModel.testFireTreeCleared();
        ChangeSupportTests.assertNull((Object)this.treeEvent);
        ChangeSupportTests.assertFalse((boolean)this.treeClearedCalled);
        this.treeEvent = null;
        this.treeClearedCalled = false;
        this.testModel.addTreeChangeListener(TREE_NAME, (TreeChangeListener)this.changeListener);
        this.testModel.testFireTreeCleared();
        this.verifyTreeEvent(null);
        ChangeSupportTests.assertTrue((boolean)this.treeClearedCalled);
        this.treeEvent = null;
        this.treeClearedCalled = false;
        this.testModel.removeTreeChangeListener(TREE_NAME, (TreeChangeListener)this.changeListener);
        this.testModel.testFireTreeCleared();
        ChangeSupportTests.assertNull((Object)this.treeEvent);
        ChangeSupportTests.assertFalse((boolean)this.treeClearedCalled);
    }

    public void testFireTreeChangedEvent() {
        this.treeEvent = null;
        this.treeChangedCalled = false;
        this.testModel.addChangeListener(this.changeListener);
        this.testModel.testFireTreeChangedEvent();
        this.verifyTreeEvent(null);
        ChangeSupportTests.assertTrue((boolean)this.treeChangedCalled);
        this.treeEvent = null;
        this.treeChangedCalled = false;
        this.testModel.removeChangeListener(this.changeListener);
        this.testModel.testFireTreeChangedEvent();
        ChangeSupportTests.assertNull((Object)this.treeEvent);
        ChangeSupportTests.assertFalse((boolean)this.treeChangedCalled);
        this.treeEvent = null;
        this.treeChangedCalled = false;
        this.testModel.addTreeChangeListener(TREE_NAME, (TreeChangeListener)this.changeListener);
        this.testModel.testFireTreeChangedEvent();
        this.verifyTreeEvent(null);
        ChangeSupportTests.assertTrue((boolean)this.treeChangedCalled);
        this.treeEvent = null;
        this.treeChangedCalled = false;
        this.testModel.removeTreeChangeListener(TREE_NAME, (TreeChangeListener)this.changeListener);
        this.testModel.testFireTreeChangedEvent();
        ChangeSupportTests.assertNull((Object)this.treeEvent);
        ChangeSupportTests.assertFalse((boolean)this.treeChangedCalled);
    }

    public void testFireTreeChanged() {
        this.treeEvent = null;
        this.treeChangedCalled = false;
        this.testModel.addChangeListener(this.changeListener);
        this.testModel.testFireTreeChanged();
        this.verifyTreeEvent(null);
        ChangeSupportTests.assertTrue((boolean)this.treeChangedCalled);
        this.treeEvent = null;
        this.treeChangedCalled = false;
        this.testModel.removeChangeListener(this.changeListener);
        this.testModel.testFireTreeChanged();
        ChangeSupportTests.assertNull((Object)this.treeEvent);
        ChangeSupportTests.assertFalse((boolean)this.treeChangedCalled);
        this.treeEvent = null;
        this.treeChangedCalled = false;
        this.testModel.addTreeChangeListener(TREE_NAME, (TreeChangeListener)this.changeListener);
        this.testModel.testFireTreeChanged();
        this.verifyTreeEvent(null);
        ChangeSupportTests.assertTrue((boolean)this.treeChangedCalled);
        this.treeEvent = null;
        this.treeChangedCalled = false;
        this.testModel.removeTreeChangeListener(TREE_NAME, (TreeChangeListener)this.changeListener);
        this.testModel.testFireTreeChanged();
        ChangeSupportTests.assertNull((Object)this.treeEvent);
        ChangeSupportTests.assertFalse((boolean)this.treeChangedCalled);
    }

    public void testHasAnyTreeChangeListeners() {
        ChangeSupportTests.assertTrue((boolean)this.testModel.hasNoTreeChangeListeners(TREE_NAME));
        this.testModel.addChangeListener(this.changeListener);
        ChangeSupportTests.assertTrue((boolean)this.testModel.hasAnyTreeChangeListeners(TREE_NAME));
        this.testModel.removeChangeListener(this.changeListener);
        ChangeSupportTests.assertTrue((boolean)this.testModel.hasNoTreeChangeListeners(TREE_NAME));
        ChangeSupportTests.assertTrue((boolean)this.testModel.hasNoTreeChangeListeners(TREE_NAME));
        this.testModel.addTreeChangeListener(TREE_NAME, (TreeChangeListener)this.changeListener);
        ChangeSupportTests.assertTrue((boolean)this.testModel.hasAnyTreeChangeListeners(TREE_NAME));
        this.testModel.removeTreeChangeListener(TREE_NAME, (TreeChangeListener)this.changeListener);
        ChangeSupportTests.assertTrue((boolean)this.testModel.hasNoTreeChangeListeners(TREE_NAME));
    }

    public void testAddNullTreeListener() {
        boolean exCaught = false;
        try {
            this.testModel.addTreeChangeListener("foo", null);
        }
        catch (NullPointerException nullPointerException) {
            exCaught = true;
        }
        ChangeSupportTests.assertTrue((boolean)exCaught);
    }

    public void testRemoveBogusTreeListener() {
        boolean exCaught = false;
        try {
            this.testModel.removeTreeChangeListener("foo", (TreeChangeListener)this.changeListener);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            exCaught = true;
        }
        ChangeSupportTests.assertTrue((boolean)exCaught);
        this.testModel.addPropertyChangeListener("foo", (PropertyChangeListener)this.changeListener);
        exCaught = false;
        try {
            this.testModel.removeTreeChangeListener("foo", (TreeChangeListener)this.changeListener);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            exCaught = true;
        }
        ChangeSupportTests.assertTrue((boolean)exCaught);
        this.testModel.addTreeChangeListener("foo", (TreeChangeListener)this.changeListener);
        exCaught = false;
        try {
            this.testModel.removeTreeChangeListener("foo", (TreeChangeListener)new TreeChangeAdapter());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            exCaught = true;
        }
        ChangeSupportTests.assertTrue((boolean)exCaught);
        exCaught = false;
        try {
            this.testModel.removeTreeChangeListener("foo", (TreeChangeListener)new TreeChangeAdapter());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            exCaught = true;
        }
        ChangeSupportTests.assertTrue((boolean)exCaught);
    }

    private void verifyTreeEvent(List<?> path) {
        ChangeSupportTests.assertNotNull((Object)this.treeEvent);
        ChangeSupportTests.assertEquals((Object)this.testModel, (Object)this.treeEvent.getSource());
        ChangeSupportTests.assertEquals((String)TREE_NAME, (String)this.treeEvent.getTreeName());
        ChangeSupportTests.assertEquals(path, this.getListPath());
    }

    private List<?> getListPath() {
        Iterable<?> iterable = this.getPath();
        return iterable == null ? null : CollectionTools.list(iterable);
    }

    private Iterable<?> getPath() {
        if (this.treeEvent instanceof TreeAddEvent) {
            return ((TreeAddEvent)this.treeEvent).getPath();
        }
        if (this.treeEvent instanceof TreeRemoveEvent) {
            return ((TreeRemoveEvent)this.treeEvent).getPath();
        }
        return null;
    }

    public void testElementsAreEqual() {
        ArrayList<String> c1 = new ArrayList<String>();
        c1.add("foo");
        c1.add("bar");
        c1.add("baz");
        ArrayList<String> c2 = new ArrayList<String>();
        c2.add("foo");
        c2.add("bar");
        c2.add("baz");
        ChangeSupportTests.assertTrue((boolean)this.testModel.testElementsAreEqual(c1, c2));
    }

    public void testElementsAreDifferent() {
        ArrayList<String> c1 = new ArrayList<String>();
        c1.add("foo");
        c1.add("bar");
        c1.add("baz");
        ArrayList<String> c2 = new ArrayList<String>();
        c2.add("baz");
        c2.add("bar");
        c2.add("foo");
        ChangeSupportTests.assertTrue((boolean)this.testModel.testElementsAreDifferent(c1, c2));
    }

    public void testAbstractModelValuesAreEqual1() {
        ChangeSupportTests.assertTrue((boolean)this.testModel.testValuesAreEqual(null, null));
    }

    public void testAbstractModelValuesAreEqual2() {
        ChangeSupportTests.assertTrue((boolean)this.testModel.testValuesAreEqual("foo", "foo"));
    }

    public void testAbstractModelValuesAreEqual3() {
        ChangeSupportTests.assertFalse((boolean)this.testModel.testValuesAreEqual("foo", null));
    }

    public void testAbstractModelValuesAreEqual4() {
        ChangeSupportTests.assertFalse((boolean)this.testModel.testValuesAreEqual(null, "foo"));
    }

    public void testAbstractModelValuesAreEqual5() {
        ChangeSupportTests.assertFalse((boolean)this.testModel.testValuesAreEqual("bar", "foo"));
    }

    public void testAbstractModelValuesAreDifferent1() {
        ChangeSupportTests.assertFalse((boolean)this.testModel.testValuesAreDifferent(null, null));
    }

    public void testAbstractModelValuesAreDifferent2() {
        ChangeSupportTests.assertFalse((boolean)this.testModel.testValuesAreDifferent("foo", "foo"));
    }

    public void testAbstractModelValuesAreDifferent3() {
        ChangeSupportTests.assertTrue((boolean)this.testModel.testValuesAreDifferent("foo", null));
    }

    public void testAbstractModelValuesAreDifferent4() {
        ChangeSupportTests.assertTrue((boolean)this.testModel.testValuesAreDifferent(null, "foo"));
    }

    public void testAbstractModelValuesAreDifferent5() {
        ChangeSupportTests.assertTrue((boolean)this.testModel.testValuesAreDifferent("bar", "foo"));
    }

    public void testAbstractModelAttributeValueHasChanged1() {
        ChangeSupportTests.assertFalse((boolean)this.testModel.testAttributeValueHasChanged(null, null));
    }

    public void testAbstractModelAttributeValueHasChanged2() {
        ChangeSupportTests.assertFalse((boolean)this.testModel.testAttributeValueHasChanged("foo", "foo"));
    }

    public void testAbstractModelAttributeValueHasChanged3() {
        ChangeSupportTests.assertTrue((boolean)this.testModel.testAttributeValueHasChanged("foo", null));
    }

    public void testAbstractModelAttributeValueHasChanged4() {
        ChangeSupportTests.assertTrue((boolean)this.testModel.testAttributeValueHasChanged(null, "foo"));
    }

    public void testAbstractModelAttributeValueHasChanged5() {
        ChangeSupportTests.assertTrue((boolean)this.testModel.testAttributeValueHasChanged("bar", "foo"));
    }

    public void testAbstractModelAttributeValueHasNotChanged1() {
        ChangeSupportTests.assertTrue((boolean)this.testModel.testAttributeValueHasNotChanged(null, null));
    }

    public void testAbstractModelAttributeValueHasNotChanged2() {
        ChangeSupportTests.assertTrue((boolean)this.testModel.testAttributeValueHasNotChanged("foo", "foo"));
    }

    public void testAbstractModelAttributeValueHasNotChanged3() {
        ChangeSupportTests.assertFalse((boolean)this.testModel.testAttributeValueHasNotChanged("foo", null));
    }

    public void testAbstractModelAttributeValueHasNotChanged4() {
        ChangeSupportTests.assertFalse((boolean)this.testModel.testAttributeValueHasNotChanged(null, "foo"));
    }

    public void testAbstractModelAttributeValueHasNotChanged5() {
        ChangeSupportTests.assertFalse((boolean)this.testModel.testAttributeValueHasNotChanged("bar", "foo"));
    }

    public void testAbstractModelClone() {
        ChangeSupportTests.assertFalse((boolean)this.testModel.hasAnyPropertyChangeListeners(PROPERTY_NAME));
        this.testModel.addChangeListener(this.changeListener);
        ChangeSupportTests.assertTrue((boolean)this.testModel.hasAnyPropertyChangeListeners(PROPERTY_NAME));
        TestModel clone = this.testModel.clone();
        ChangeSupportTests.assertFalse((boolean)clone.hasAnyPropertyChangeListeners(PROPERTY_NAME));
        clone.addChangeListener(this.changeListener);
        ChangeSupportTests.assertTrue((boolean)clone.hasAnyPropertyChangeListeners(PROPERTY_NAME));
        ChangeSupportTests.assertTrue((boolean)this.testModel.hasAnyPropertyChangeListeners(PROPERTY_NAME));
        this.propertyChangeEvent = null;
        this.propertyChangeCalled = false;
        this.testModel.testFirePropertyChangedObjectObject();
        this.verifyPropertyChangeEvent(OLD_OBJECT_VALUE, NEW_OBJECT_VALUE);
        ChangeSupportTests.assertTrue((boolean)this.propertyChangeCalled);
        this.propertyChangeEvent = null;
        this.propertyChangeCalled = false;
        clone.testFirePropertyChangedObjectObject();
        this.verifyPropertyChangeEvent(clone, OLD_OBJECT_VALUE, NEW_OBJECT_VALUE);
        ChangeSupportTests.assertTrue((boolean)this.propertyChangeCalled);
    }

    public void testAbstractModelToString() {
        ChangeSupportTests.assertTrue((boolean)this.testModel.toString().contains("(this is a test)"));
    }

    public void testSerialization() throws IOException, ClassNotFoundException {
        if (Tools.jvmIsSun()) {
            this.verifySerialization();
        }
    }

    private void verifySerialization() throws IOException, ClassNotFoundException {
        LocalModel model1 = new LocalModel();
        Foo foo1 = new Foo();
        Bar bar1 = new Bar();
        Joo joo1 = new Joo();
        Jar jar1 = new Jar();
        model1.addStateChangeListener(foo1);
        model1.addStateChangeListener(bar1);
        model1.addListChangeListener("foo", (ListChangeListener)joo1);
        model1.addListChangeListener("foo", (ListChangeListener)jar1);
        Iterable<EventListener> listeners1 = this.getListeners(model1, StateChangeListener.class, null);
        Object[] listenersArray1 = ArrayTools.array(listeners1);
        ChangeSupportTests.assertEquals((int)2, (int)listenersArray1.length);
        ChangeSupportTests.assertEquals(Foo.class, listenersArray1[0].getClass());
        ChangeSupportTests.assertEquals(Bar.class, listenersArray1[1].getClass());
        listeners1 = this.getListeners(model1, ListChangeListener.class, "foo");
        listenersArray1 = ArrayTools.array(listeners1);
        ChangeSupportTests.assertEquals((int)2, (int)listenersArray1.length);
        ChangeSupportTests.assertEquals(Joo.class, listenersArray1[0].getClass());
        ChangeSupportTests.assertEquals(Jar.class, listenersArray1[1].getClass());
        LocalModel model2 = TestTools.serialize(model1);
        Iterable<EventListener> listeners2 = this.getListeners(model2, StateChangeListener.class, null);
        Object[] listenersArray2 = ArrayTools.array(listeners2);
        ChangeSupportTests.assertEquals((int)1, (int)listenersArray2.length);
        ChangeSupportTests.assertEquals(Foo.class, listenersArray2[0].getClass());
        listeners2 = this.getListeners(model2, ListChangeListener.class, "foo");
        listenersArray2 = ArrayTools.array(listeners2);
        ChangeSupportTests.assertEquals((int)1, (int)listenersArray2.length);
        ChangeSupportTests.assertEquals(Joo.class, listenersArray2[0].getClass());
    }

    private Iterable<EventListener> getListeners(LocalModel model, Class<? extends EventListener> listenerClass, String aspectName) {
        return this.getListenerList(model, listenerClass, aspectName).getListeners();
    }

    private ListenerList<EventListener> getListenerList(LocalModel model, Class<? extends EventListener> listenerClass, String aspectName) {
        ChangeSupport changeSupport = (ChangeSupport)ReflectionTools.getFieldValue((Object)model, (String)"changeSupport");
        return (ListenerList)ReflectionTools.executeMethod((Object)changeSupport, (String)"getListenerList_", (Class[])new Class[]{Class.class, String.class}, (Object[])new Object[]{listenerClass, aspectName});
    }

    public void testIndirectRemoveStateListener() {
        this.verifyIndirectRemoveListener(new NotifyCommand(){

            public void notifyListeners(LocalA localA) {
                localA.notifyStateListeners();
            }
        });
    }

    public void testIndirectRemovePropertyListener() {
        this.verifyIndirectRemoveListener(new NotifyCommand(){

            public void notifyListeners(LocalA localA) {
                localA.notifyPropertyListeners();
            }
        });
    }

    public void testIndirectRemoveCollectionListener() {
        this.verifyIndirectRemoveListener(new NotifyCommand(){

            public void notifyListeners(LocalA localA) {
                localA.notifyCollectionListeners();
            }
        });
    }

    public void testIndirectRemoveListListener() {
        this.verifyIndirectRemoveListener(new NotifyCommand(){

            public void notifyListeners(LocalA localA) {
                localA.notifyListListeners();
            }
        });
    }

    public void testIndirectRemoveTreeListener() {
        this.verifyIndirectRemoveListener(new NotifyCommand(){

            public void notifyListeners(LocalA localA) {
                localA.notifyTreeListeners();
            }
        });
    }

    public void verifyIndirectRemoveListener(NotifyCommand command) {
        LocalA localA = new LocalA();
        LocalB localB = new LocalB(localA);
        LocalC[] localCs = new LocalC[1000];
        int i = localCs.length;
        while (i-- > 0) {
            localCs[i] = new LocalC(localA, localB);
        }
        boolean exCaught = false;
        try {
            command.notifyListeners(localA);
        }
        catch (IllegalStateException ex) {
            if (ex.getMessage() == ISE_MESSAGE) {
                exCaught = true;
            }
            throw ex;
        }
        ChangeSupportTests.assertFalse((boolean)exCaught);
        int i2 = localCs.length;
        while (i2-- > 0) {
            ChangeSupportTests.assertFalse((boolean)localCs[i2].isListeningToLocalA());
        }
    }

    class Adapter
    implements ChangeListener {
        Adapter() {
        }

        public void stateChanged(StateChangeEvent e) {
            ChangeSupportTests.this.stateChangedCalled = true;
            ChangeSupportTests.this.stateChangeEvent = e;
        }

        public void propertyChanged(PropertyChangeEvent e) {
            ChangeSupportTests.this.propertyChangeCalled = true;
            ChangeSupportTests.this.propertyChangeEvent = e;
        }

        public void itemsAdded(CollectionAddEvent e) {
            ChangeSupportTests.this.itemsAddedCollectionCalled = true;
            ChangeSupportTests.this.collectionEvent = e;
        }

        public void itemsRemoved(CollectionRemoveEvent e) {
            ChangeSupportTests.this.itemsRemovedCollectionCalled = true;
            ChangeSupportTests.this.collectionEvent = e;
        }

        public void collectionCleared(CollectionClearEvent e) {
            ChangeSupportTests.this.collectionClearedCalled = true;
            ChangeSupportTests.this.collectionEvent = e;
        }

        public void collectionChanged(CollectionChangeEvent e) {
            ChangeSupportTests.this.collectionChangedCalled = true;
            ChangeSupportTests.this.collectionEvent = e;
        }

        public void itemsAdded(ListAddEvent e) {
            ChangeSupportTests.this.itemsAddedListCalled = true;
            ChangeSupportTests.this.listEvent = e;
        }

        public void itemsRemoved(ListRemoveEvent e) {
            ChangeSupportTests.this.itemsRemovedListCalled = true;
            ChangeSupportTests.this.listEvent = e;
        }

        public void itemsReplaced(ListReplaceEvent e) {
            ChangeSupportTests.this.itemsReplacedListCalled = true;
            ChangeSupportTests.this.listEvent = e;
        }

        public void itemsMoved(ListMoveEvent e) {
            ChangeSupportTests.this.itemsMovedListCalled = true;
            ChangeSupportTests.this.listEvent = e;
        }

        public void listCleared(ListClearEvent e) {
            ChangeSupportTests.this.listClearedCalled = true;
            ChangeSupportTests.this.listEvent = e;
        }

        public void listChanged(ListChangeEvent e) {
            ChangeSupportTests.this.listChangedCalled = true;
            ChangeSupportTests.this.listEvent = e;
        }

        public void nodeAdded(TreeAddEvent e) {
            ChangeSupportTests.this.nodeAddedCalled = true;
            ChangeSupportTests.this.treeEvent = e;
        }

        public void nodeRemoved(TreeRemoveEvent e) {
            ChangeSupportTests.this.nodeRemovedCalled = true;
            ChangeSupportTests.this.treeEvent = e;
        }

        public void treeCleared(TreeClearEvent e) {
            ChangeSupportTests.this.treeClearedCalled = true;
            ChangeSupportTests.this.treeEvent = e;
        }

        public void treeChanged(TreeChangeEvent e) {
            ChangeSupportTests.this.treeChangedCalled = true;
            ChangeSupportTests.this.treeEvent = e;
        }
    }

    private static class Bar
    implements StateChangeListener {
        Bar() {
        }

        public void stateChanged(StateChangeEvent event) {
        }
    }

    class CollectionSynchListener
    extends ChangeAdapter {
        boolean itemsAdded = false;
        boolean itemsRemoved = false;
        boolean collectionChanged = false;
        boolean collectionCleared = false;
        Collection<Object> addedItems = new ArrayList<Object>();
        Collection<Object> removedItems = new ArrayList<Object>();

        CollectionSynchListener() {
        }

        public void collectionChanged(CollectionChangeEvent event) {
            this.collectionChanged = true;
        }

        public void collectionCleared(CollectionClearEvent event) {
            this.collectionCleared = true;
        }

        public void itemsAdded(CollectionAddEvent event) {
            this.itemsAdded = true;
            CollectionTools.addAll(this.addedItems, (Iterable)event.getItems());
        }

        public void itemsRemoved(CollectionRemoveEvent event) {
            this.itemsRemoved = true;
            CollectionTools.addAll(this.removedItems, (Iterable)event.getItems());
        }
    }

    private static class Foo
    implements Serializable,
    StateChangeListener {
        Foo() {
        }

        public void stateChanged(StateChangeEvent event) {
        }
    }

    private static class Jar
    extends ListChangeAdapter {
        Jar() {
        }
    }

    private static class Joo
    extends ListChangeAdapter
    implements Serializable {
        Joo() {
        }
    }

    private static class LocalA
    extends AbstractModel {
        LocalA() {
        }

        void notifyStateListeners() {
            this.fireStateChanged();
        }

        void notifyPropertyListeners() {
            this.firePropertyChanged("foo", 1, 2);
        }

        void notifyCollectionListeners() {
            this.fireCollectionChanged("foo", Collections.emptySet());
        }

        void notifyListListeners() {
            this.fireListChanged("foo", Collections.emptyList());
        }

        void notifyTreeListeners() {
            this.fireTreeChanged("foo", Collections.emptySet());
        }
    }

    private static class LocalB
    extends AbstractModel
    implements ChangeListener {
        LocalB(LocalA localA) {
            localA.addChangeListener(this);
        }

        public void stateChanged(StateChangeEvent e) {
            this.fireStateChanged();
        }

        public void propertyChanged(PropertyChangeEvent evt) {
            this.firePropertyChanged("bar", 1, 2);
        }

        public void collectionChanged(CollectionChangeEvent e) {
            this.fireCollectionChanged("bar", Collections.emptySet());
        }

        public void collectionCleared(CollectionClearEvent e) {
        }

        public void itemsAdded(CollectionAddEvent e) {
        }

        public void itemsRemoved(CollectionRemoveEvent e) {
        }

        public void listChanged(ListChangeEvent e) {
            this.fireListChanged("bar", Collections.emptyList());
        }

        public void listCleared(ListClearEvent e) {
        }

        public void itemsAdded(ListAddEvent e) {
        }

        public void itemsRemoved(ListRemoveEvent e) {
        }

        public void itemsReplaced(ListReplaceEvent e) {
        }

        public void itemsMoved(ListMoveEvent e) {
        }

        public void treeChanged(TreeChangeEvent e) {
            this.fireTreeChanged("bar", Collections.emptySet());
        }

        public void treeCleared(TreeClearEvent e) {
        }

        public void nodeAdded(TreeAddEvent e) {
        }

        public void nodeRemoved(TreeRemoveEvent e) {
        }
    }

    private static class LocalC
    extends AbstractModel
    implements ChangeListener {
        private LocalA localA;
        private LocalB localB;
        private boolean listeningToLocalA;

        LocalC(LocalA localA, LocalB localB) {
            this.localA = localA;
            this.localB = localB;
            localA.addChangeListener(this);
            this.listeningToLocalA = true;
            localB.addChangeListener(this);
        }

        boolean isListeningToLocalA() {
            return this.listeningToLocalA;
        }

        public void stateChanged(StateChangeEvent e) {
            Model source = e.getSource();
            if (source == this.localA) {
                if (!this.listeningToLocalA) {
                    throw new IllegalStateException(ChangeSupportTests.ISE_MESSAGE);
                }
            } else if (source == this.localB) {
                this.localA.removeChangeListener(this);
                this.listeningToLocalA = false;
            } else {
                throw new IllegalStateException("bogus event source: " + source);
            }
        }

        public void propertyChanged(PropertyChangeEvent e) {
            Model source = e.getSource();
            if (source == this.localA) {
                if (!this.listeningToLocalA) {
                    throw new IllegalStateException(ChangeSupportTests.ISE_MESSAGE);
                }
            } else if (source == this.localB) {
                this.localA.removeChangeListener(this);
                this.listeningToLocalA = false;
            } else {
                throw new IllegalStateException("bogus event source: " + source);
            }
        }

        public void collectionChanged(CollectionChangeEvent e) {
            Model source = e.getSource();
            if (source == this.localA) {
                if (!this.listeningToLocalA) {
                    throw new IllegalStateException(ChangeSupportTests.ISE_MESSAGE);
                }
            } else if (source == this.localB) {
                this.localA.removeChangeListener(this);
                this.listeningToLocalA = false;
            } else {
                throw new IllegalStateException("bogus event source: " + source);
            }
        }

        public void collectionCleared(CollectionClearEvent e) {
        }

        public void itemsAdded(CollectionAddEvent e) {
        }

        public void itemsRemoved(CollectionRemoveEvent e) {
        }

        public void listChanged(ListChangeEvent e) {
            Model source = e.getSource();
            if (source == this.localA) {
                if (!this.listeningToLocalA) {
                    throw new IllegalStateException(ChangeSupportTests.ISE_MESSAGE);
                }
            } else if (source == this.localB) {
                this.localA.removeChangeListener(this);
                this.listeningToLocalA = false;
            } else {
                throw new IllegalStateException("bogus event source: " + source);
            }
        }

        public void listCleared(ListClearEvent e) {
        }

        public void itemsAdded(ListAddEvent e) {
        }

        public void itemsRemoved(ListRemoveEvent e) {
        }

        public void itemsReplaced(ListReplaceEvent e) {
        }

        public void itemsMoved(ListMoveEvent e) {
        }

        public void treeChanged(TreeChangeEvent e) {
            Model source = e.getSource();
            if (source == this.localA) {
                if (!this.listeningToLocalA) {
                    throw new IllegalStateException(ChangeSupportTests.ISE_MESSAGE);
                }
            } else if (source == this.localB) {
                this.localA.removeChangeListener(this);
                this.listeningToLocalA = false;
            } else {
                throw new IllegalStateException("bogus event source: " + source);
            }
        }

        public void treeCleared(TreeClearEvent e) {
        }

        public void nodeAdded(TreeAddEvent e) {
        }

        public void nodeRemoved(TreeRemoveEvent e) {
        }
    }

    private static class LocalModel
    extends AbstractModel
    implements Serializable {
        LocalModel() {
        }

        private synchronized void writeObject(ObjectOutputStream s) throws IOException {
            s.defaultWriteObject();
            s.writeObject(this.changeSupport);
        }

        private void readObject(ObjectInputStream s) throws ClassNotFoundException, IOException {
            s.defaultReadObject();
            this.changeSupport = (ChangeSupport)s.readObject();
        }
    }

    private static interface NotifyCommand {
        public void notifyListeners(LocalA var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TestModel
    extends AbstractModel
    implements Cloneable {
        TestModel() {
        }

        public void testFireStateChange() {
            this.fireStateChanged();
        }

        public void testFirePropertyChangedEvent() {
            this.firePropertyChanged(new PropertyChangeEvent((Model)this, ChangeSupportTests.PROPERTY_NAME, OLD_OBJECT_VALUE, NEW_OBJECT_VALUE));
        }

        public void testFirePropertyChangedEventNoChange() {
            this.firePropertyChanged(new PropertyChangeEvent((Model)this, ChangeSupportTests.PROPERTY_NAME, OLD_OBJECT_VALUE, OLD_OBJECT_VALUE));
        }

        public void testFirePropertyChangedObjectObject() {
            this.firePropertyChanged(ChangeSupportTests.PROPERTY_NAME, OLD_OBJECT_VALUE, NEW_OBJECT_VALUE);
        }

        public void testFirePropertyChangedObjectObjectNoChange() {
            this.firePropertyChanged(ChangeSupportTests.PROPERTY_NAME, OLD_OBJECT_VALUE, OLD_OBJECT_VALUE);
        }

        public void testFirePropertyChangedObject() {
            this.firePropertyChanged(ChangeSupportTests.PROPERTY_NAME, NEW_OBJECT_VALUE);
        }

        public void testFirePropertyChangedObjectNoChange() {
            this.firePropertyChanged(ChangeSupportTests.PROPERTY_NAME, null);
        }

        public void testFirePropertyChangedIntInt() {
            this.firePropertyChanged(ChangeSupportTests.PROPERTY_NAME, OLD_INT_VALUE, NEW_INT_VALUE);
        }

        public void testFirePropertyChangedIntIntNoChange() {
            this.firePropertyChanged(ChangeSupportTests.PROPERTY_NAME, OLD_INT_VALUE, OLD_INT_VALUE);
        }

        public void testFirePropertyChangedBooleanBoolean() {
            this.firePropertyChanged(ChangeSupportTests.PROPERTY_NAME, OLD_BOOLEAN_VALUE, NEW_BOOLEAN_VALUE);
        }

        public void testFirePropertyChangedBooleanBooleanNoChange() {
            this.firePropertyChanged(ChangeSupportTests.PROPERTY_NAME, OLD_BOOLEAN_VALUE, OLD_BOOLEAN_VALUE);
        }

        public void testFireItemsAddedCollectionEvent() {
            this.fireItemsAdded(new CollectionAddEvent((Model)this, ChangeSupportTests.COLLECTION_NAME, ADDED_OBJECT_VALUE));
        }

        public void testFireItemsAddedCollectionEventNoChange() {
            this.fireItemsAdded(new CollectionAddEvent((Model)this, ChangeSupportTests.COLLECTION_NAME, Collections.emptySet()));
        }

        public void testFireItemsAddedCollection() {
            this.fireItemsAdded(ChangeSupportTests.COLLECTION_NAME, Collections.singleton(ADDED_OBJECT_VALUE));
        }

        public void testFireItemsAddedCollectionNoChange() {
            this.fireItemsAdded(ChangeSupportTests.COLLECTION_NAME, Collections.emptySet());
        }

        public void testFireItemAddedCollection() {
            this.fireItemAdded(ChangeSupportTests.COLLECTION_NAME, ADDED_OBJECT_VALUE);
        }

        public void testFireItemsRemovedCollectionEvent() {
            this.fireItemsRemoved(new CollectionRemoveEvent((Model)this, ChangeSupportTests.COLLECTION_NAME, REMOVED_OBJECT_VALUE));
        }

        public void testFireItemsRemovedCollectionEventNoChange() {
            this.fireItemsRemoved(new CollectionRemoveEvent((Model)this, ChangeSupportTests.COLLECTION_NAME, Collections.emptySet()));
        }

        public void testFireItemsRemovedCollection() {
            this.fireItemsRemoved(ChangeSupportTests.COLLECTION_NAME, Collections.singleton(REMOVED_OBJECT_VALUE));
        }

        public void testFireItemsRemovedCollectionNoChange() {
            this.fireItemsRemoved(ChangeSupportTests.COLLECTION_NAME, Collections.emptySet());
        }

        public void testFireItemRemovedCollection() {
            this.fireItemRemoved(ChangeSupportTests.COLLECTION_NAME, REMOVED_OBJECT_VALUE);
        }

        public void testFireCollectionCleared() {
            this.fireCollectionCleared(ChangeSupportTests.COLLECTION_NAME);
        }

        public void testFireCollectionChangedEvent() {
            this.fireCollectionChanged(new CollectionChangeEvent((Model)this, ChangeSupportTests.COLLECTION_NAME, Collections.emptySet()));
        }

        public void testFireCollectionChanged() {
            this.fireCollectionChanged(ChangeSupportTests.COLLECTION_NAME, Collections.emptySet());
        }

        public boolean testAddItemToCollection() {
            return this.addItemToCollection(ADDED_OBJECT_VALUE, new ArrayList(), ChangeSupportTests.COLLECTION_NAME);
        }

        public boolean testAddItemToCollectionNoChange() {
            HashSet<Object> collection = new HashSet<Object>();
            collection.add(ADDED_OBJECT_VALUE);
            return this.addItemToCollection(ADDED_OBJECT_VALUE, collection, ChangeSupportTests.COLLECTION_NAME);
        }

        public boolean testAddItemsToCollection() {
            return this.addItemsToCollection(Collections.singleton(ADDED_OBJECT_VALUE), new ArrayList(), ChangeSupportTests.COLLECTION_NAME);
        }

        public boolean testAddItemsToCollectionNoChange() {
            HashSet<Object> collection = new HashSet<Object>();
            collection.add(ADDED_OBJECT_VALUE);
            return this.addItemsToCollection(Collections.singleton(ADDED_OBJECT_VALUE), collection, ChangeSupportTests.COLLECTION_NAME);
        }

        public boolean testAddItemsToCollectionMixed() {
            HashSet<Object> collection = new HashSet<Object>();
            collection.add(ADDED_OBJECT_VALUE);
            return this.addItemsToCollection(new Object[]{ADDED_OBJECT_VALUE, ADDED_OBJECT_VALUE_2}, collection, ChangeSupportTests.COLLECTION_NAME);
        }

        public boolean testRemoveItemFromCollection() {
            HashSet<Object> collection = new HashSet<Object>();
            collection.add(REMOVED_OBJECT_VALUE);
            return this.removeItemFromCollection(REMOVED_OBJECT_VALUE, collection, ChangeSupportTests.COLLECTION_NAME);
        }

        public boolean testRemoveItemFromCollectionNoChange() {
            HashSet<Object> collection = new HashSet<Object>();
            collection.add(REMOVED_OBJECT_VALUE);
            return this.removeItemFromCollection("foo", collection, ChangeSupportTests.COLLECTION_NAME);
        }

        public boolean testRemoveItemsFromCollection() {
            HashSet<Object> collection = new HashSet<Object>();
            collection.add(REMOVED_OBJECT_VALUE);
            collection.add("foo");
            collection.add("bar");
            return this.removeItemsFromCollection(new Object[]{"foo", "bar", REMOVED_OBJECT_VALUE}, collection, ChangeSupportTests.COLLECTION_NAME);
        }

        public boolean testRemoveItemsFromCollectionNoChange1() {
            HashSet<Object> collection = new HashSet<Object>();
            collection.add(REMOVED_OBJECT_VALUE);
            return this.removeItemsFromCollection(Collections.emptySet(), collection, ChangeSupportTests.COLLECTION_NAME);
        }

        public boolean testRemoveItemsFromCollectionNoChange2() {
            HashSet collection = new HashSet();
            return this.removeItemsFromCollection(Collections.singleton("foo"), collection, ChangeSupportTests.COLLECTION_NAME);
        }

        public boolean testRemoveItemsFromCollectionNoChange3() {
            HashSet<Object> collection = new HashSet<Object>();
            collection.add(REMOVED_OBJECT_VALUE);
            return this.removeItemsFromCollection(Collections.singleton("foo"), collection, ChangeSupportTests.COLLECTION_NAME);
        }

        public boolean testRetainItemsInCollection1() {
            HashSet<Object> collection = new HashSet<Object>();
            collection.add(REMOVED_OBJECT_VALUE);
            collection.add("foo");
            collection.add("bar");
            return this.retainItemsInCollection(new Object[]{"foo", "bar"}, collection, ChangeSupportTests.COLLECTION_NAME);
        }

        public boolean testRetainItemsInCollection2() {
            HashSet<Object> collection = new HashSet<Object>();
            collection.add(REMOVED_OBJECT_VALUE);
            collection.add("foo");
            collection.add("bar");
            return this.retainItemsInCollection(Collections.emptySet(), collection, ChangeSupportTests.COLLECTION_NAME);
        }

        public boolean testRetainItemsInCollectionNoChange1() {
            HashSet collection = new HashSet();
            return this.retainItemsInCollection(new Object[]{"foo", "bar"}, collection, ChangeSupportTests.COLLECTION_NAME);
        }

        public boolean testRetainItemsInCollectionNoChange2() {
            HashSet<Object> collection = new HashSet<Object>();
            collection.add(REMOVED_OBJECT_VALUE);
            collection.add("foo");
            collection.add("bar");
            return this.retainItemsInCollection(new Object[]{"foo", "bar", REMOVED_OBJECT_VALUE}, collection, ChangeSupportTests.COLLECTION_NAME);
        }

        public boolean testClearCollection() {
            HashSet<Object> collection = new HashSet<Object>();
            collection.add(REMOVED_OBJECT_VALUE);
            collection.add("foo");
            collection.add("bar");
            return this.clearCollection(collection, ChangeSupportTests.COLLECTION_NAME);
        }

        public boolean testClearCollectionNoChange() {
            HashSet collection = new HashSet();
            return this.clearCollection(collection, ChangeSupportTests.COLLECTION_NAME);
        }

        public boolean testSynchronizeCollection1() {
            HashSet<String> collection = new HashSet<String>();
            collection.add("foo");
            collection.add("bar");
            collection.add("baz");
            HashSet<String> newCollection = new HashSet<String>();
            newCollection.add("joo");
            newCollection.add("jar");
            newCollection.add("baz");
            boolean result = this.synchronizeCollection(newCollection, collection, ChangeSupportTests.COLLECTION_NAME);
            ChangeSupportTests.assertEquals(newCollection, collection);
            return result;
        }

        public boolean testSynchronizeCollection2() {
            HashSet<String> collection = new HashSet<String>();
            collection.add("foo");
            collection.add("bar");
            collection.add("baz");
            HashSet newCollection = new HashSet();
            boolean result = this.synchronizeCollection(newCollection, collection, ChangeSupportTests.COLLECTION_NAME);
            ChangeSupportTests.assertEquals(newCollection, collection);
            return result;
        }

        public boolean testSynchronizeCollection3() {
            HashSet collection = new HashSet();
            HashSet<String> newCollection = new HashSet<String>();
            newCollection.add("joo");
            newCollection.add("jar");
            newCollection.add("baz");
            boolean result = this.synchronizeCollection(newCollection, collection, ChangeSupportTests.COLLECTION_NAME);
            ChangeSupportTests.assertEquals(newCollection, collection);
            return result;
        }

        public void testFireItemsAddedListEvent() {
            this.fireItemsAdded(new ListAddEvent((Model)this, ChangeSupportTests.LIST_NAME, 3, ADDED_OBJECT_VALUE));
        }

        public void testFireItemsAddedListEventNoChange() {
            this.fireItemsAdded(new ListAddEvent((Model)this, ChangeSupportTests.LIST_NAME, 3, Collections.emptyList()));
        }

        public void testFireItemsAddedList() {
            this.fireItemsAdded(ChangeSupportTests.LIST_NAME, 3, Collections.singletonList(ADDED_OBJECT_VALUE));
        }

        public void testFireItemsAddedListNoChange() {
            this.fireItemsAdded(ChangeSupportTests.LIST_NAME, 3, Collections.emptyList());
        }

        public void testFireItemAddedList() {
            this.fireItemAdded(ChangeSupportTests.LIST_NAME, 3, ADDED_OBJECT_VALUE);
        }

        public void testFireItemsRemovedListEvent() {
            this.fireItemsRemoved(new ListRemoveEvent((Model)this, ChangeSupportTests.LIST_NAME, 5, REMOVED_OBJECT_VALUE));
        }

        public void testFireItemsRemovedListEventNoChange() {
            this.fireItemsRemoved(new ListRemoveEvent((Model)this, ChangeSupportTests.LIST_NAME, 5, Collections.emptyList()));
        }

        public void testFireItemsRemovedList() {
            this.fireItemsRemoved(ChangeSupportTests.LIST_NAME, 5, Collections.singletonList(REMOVED_OBJECT_VALUE));
        }

        public void testFireItemsRemovedListNoChange() {
            this.fireItemsRemoved(ChangeSupportTests.LIST_NAME, 5, Collections.emptyList());
        }

        public void testFireItemRemovedList() {
            this.fireItemRemoved(ChangeSupportTests.LIST_NAME, 5, REMOVED_OBJECT_VALUE);
        }

        public void testFireItemsReplacedListEvent() {
            this.fireItemsReplaced(new ListReplaceEvent((Model)this, ChangeSupportTests.LIST_NAME, 2, ADDED_OBJECT_VALUE, REMOVED_OBJECT_VALUE));
        }

        public void testFireItemsReplacedListEventNoChange() {
            this.fireItemsReplaced(new ListReplaceEvent((Model)this, ChangeSupportTests.LIST_NAME, 2, Collections.emptyList(), Collections.emptyList()));
        }

        public void testFireItemsReplacedList() {
            this.fireItemsReplaced(ChangeSupportTests.LIST_NAME, 2, Collections.singletonList(ADDED_OBJECT_VALUE), Collections.singletonList(REMOVED_OBJECT_VALUE));
        }

        public void testFireItemsReplacedListNoChange() {
            this.fireItemsReplaced(ChangeSupportTests.LIST_NAME, 2, Collections.emptyList(), Collections.emptyList());
        }

        public void testFireItemReplacedList() {
            this.fireItemReplaced(ChangeSupportTests.LIST_NAME, 2, ADDED_OBJECT_VALUE, REMOVED_OBJECT_VALUE);
        }

        public void testFireItemsMovedListEvent() {
            this.fireItemsMoved(new ListMoveEvent((Model)this, ChangeSupportTests.LIST_NAME, 7, 22, 1));
        }

        public void testFireItemsMovedListEventNoChange() {
            this.fireItemsMoved(new ListMoveEvent((Model)this, ChangeSupportTests.LIST_NAME, 22, 22, 1));
        }

        public void testFireItemsMovedList() {
            this.fireItemsMoved(ChangeSupportTests.LIST_NAME, 7, 22, 1);
        }

        public void testFireItemsMovedListNoChange() {
            this.fireItemsMoved(ChangeSupportTests.LIST_NAME, 22, 22, 1);
        }

        public void testFireItemMovedList() {
            this.fireItemMoved(ChangeSupportTests.LIST_NAME, 7, 22);
        }

        public void testFireListClearedEvent() {
            this.fireListCleared(new ListClearEvent((Model)this, ChangeSupportTests.LIST_NAME));
        }

        public void testFireListCleared() {
            this.fireListCleared(ChangeSupportTests.LIST_NAME);
        }

        public void testFireListChangedEvent() {
            this.fireListChanged(new ListChangeEvent((Model)this, ChangeSupportTests.LIST_NAME, Collections.emptyList()));
        }

        public void testFireListChanged() {
            this.fireListChanged(ChangeSupportTests.LIST_NAME, Collections.emptyList());
        }

        public void testAddItemToListIndex() {
            ArrayList<String> list = new ArrayList<String>();
            list.add("foo");
            list.add("bar");
            list.add("baz");
            this.addItemToList(2, "joo", list, ChangeSupportTests.LIST_NAME);
        }

        public void testAddItemToList() {
            ArrayList<String> list = new ArrayList<String>();
            list.add("foo");
            list.add("bar");
            list.add("baz");
            this.addItemToList("joo", list, ChangeSupportTests.LIST_NAME);
        }

        public void testAddItemsToListIndex() {
            ArrayList<String> list = new ArrayList<String>();
            list.add("foo");
            list.add("bar");
            list.add("baz");
            this.addItemsToList(2, Collections.singletonList("joo"), list, ChangeSupportTests.LIST_NAME);
        }

        public void testAddItemsToListIndexNoChange() {
            ArrayList<String> list = new ArrayList<String>();
            list.add("foo");
            list.add("bar");
            list.add("baz");
            this.addItemsToList(2, Collections.emptyList(), list, ChangeSupportTests.LIST_NAME);
        }

        public void testAddItemsToList() {
            ArrayList<String> list = new ArrayList<String>();
            list.add("foo");
            list.add("bar");
            list.add("baz");
            this.addItemsToList(Collections.singletonList("joo"), list, ChangeSupportTests.LIST_NAME);
        }

        public void testAddItemsToListNoChange() {
            ArrayList<String> list = new ArrayList<String>();
            list.add("foo");
            list.add("bar");
            list.add("baz");
            this.addItemsToList(Collections.emptyList(), list, ChangeSupportTests.LIST_NAME);
        }

        public void testRemoveItemFromListIndex() {
            ArrayList<String> list = new ArrayList<String>();
            list.add("foo");
            list.add("bar");
            list.add("baz");
            this.removeItemFromList(1, list, ChangeSupportTests.LIST_NAME);
        }

        public void testRemoveItemFromList() {
            ArrayList<String> list = new ArrayList<String>();
            list.add("foo");
            list.add("bar");
            list.add("baz");
            this.removeItemFromList("bar", list, ChangeSupportTests.LIST_NAME);
        }

        public void testRemoveItemsFromListIndex() {
            ArrayList<String> list = new ArrayList<String>();
            list.add("foo");
            list.add("bar");
            list.add("baz");
            this.removeItemsFromList(1, 1, list, ChangeSupportTests.LIST_NAME);
        }

        public void testRemoveItemsFromListIndexNoChange() {
            ArrayList<String> list = new ArrayList<String>();
            list.add("foo");
            list.add("bar");
            list.add("baz");
            this.removeItemsFromList(2, 0, list, ChangeSupportTests.LIST_NAME);
        }

        public void testRemoveItemsFromList() {
            ArrayList<String> list = new ArrayList<String>();
            list.add("foo");
            list.add("bar");
            list.add("baz");
            this.removeItemsFromList(Collections.singletonList("bar"), list, ChangeSupportTests.LIST_NAME);
        }

        public void testRemoveItemsFromListNoChange() {
            ArrayList<String> list = new ArrayList<String>();
            list.add("foo");
            list.add("bar");
            list.add("baz");
            this.addItemsToList(Collections.emptyList(), list, ChangeSupportTests.LIST_NAME);
        }

        public void testRetainItemsInList() {
            ArrayList<String> list = new ArrayList<String>();
            list.add("foo");
            list.add("bar");
            list.add("baz");
            this.retainItemsInList(new String[]{"bar", "baz"}, list, ChangeSupportTests.LIST_NAME);
        }

        public void testReplaceItemInList() {
            ArrayList<String> list = new ArrayList<String>();
            list.add("foo");
            list.add("bar");
            list.add("baz");
            this.replaceItemInList("bar", "xxx", list, ChangeSupportTests.LIST_NAME);
        }

        public void testSetItemsInList() {
            ArrayList<String> list = new ArrayList<String>();
            list.add("foo");
            list.add("bar");
            list.add("baz");
            this.setItemsInList(1, new String[]{"xxx"}, list, ChangeSupportTests.LIST_NAME);
        }

        public void testMoveItemsInList() {
            ArrayList<String> list = new ArrayList<String>();
            list.add("foo");
            list.add("bar");
            list.add("baz");
            list.add("xxx");
            list.add("yyy");
            list.add("zzz");
            this.moveItemsInList(2, 4, 2, list, ChangeSupportTests.LIST_NAME);
        }

        public void testClearList() {
            ArrayList<String> list = new ArrayList<String>();
            list.add("foo");
            list.add("bar");
            list.add("baz");
            this.clearList(list, ChangeSupportTests.LIST_NAME);
        }

        public void testSynchronizeList() {
            ArrayList<String> oldList = new ArrayList<String>();
            oldList.add("foo");
            oldList.add("bar");
            oldList.add("baz");
            oldList.add("xxx");
            oldList.add("yyy");
            oldList.add("zzz");
            ArrayList<String> newList = new ArrayList<String>();
            newList.add("foo");
            newList.add("ppp");
            newList.add("baz");
            newList.add("xxx");
            newList.add("qqq");
            this.synchronizeList(newList, oldList, ChangeSupportTests.LIST_NAME);
            ChangeSupportTests.assertEquals(newList, oldList);
        }

        public void testFireNodeAddedTreeEvent() {
            this.fireNodeAdded(new TreeAddEvent((Model)this, ChangeSupportTests.TREE_NAME, OBJECT_PATH));
        }

        public void testFireNodeAddedTree() {
            this.fireNodeAdded(ChangeSupportTests.TREE_NAME, OBJECT_PATH);
        }

        public void testFireNodeRemovedTreeEvent() {
            this.fireNodeRemoved(new TreeRemoveEvent((Model)this, ChangeSupportTests.TREE_NAME, OBJECT_PATH));
        }

        public void testFireNodeRemovedTree() {
            this.fireNodeRemoved(ChangeSupportTests.TREE_NAME, OBJECT_PATH);
        }

        public void testFireTreeClearedEvent() {
            this.fireTreeCleared(new TreeClearEvent((Model)this, ChangeSupportTests.TREE_NAME));
        }

        public void testFireTreeCleared() {
            this.fireTreeCleared(ChangeSupportTests.TREE_NAME);
        }

        public void testFireTreeChangedEvent() {
            this.fireTreeChanged(new TreeChangeEvent((Model)this, ChangeSupportTests.TREE_NAME, OBJECT_PATH));
        }

        public void testFireTreeChanged() {
            this.fireTreeChanged(ChangeSupportTests.TREE_NAME, OBJECT_PATH);
        }

        public boolean testAttributeValueHasChanged(Object value1, Object value2) {
            return this.attributeValueHasChanged(value1, value2);
        }

        public boolean testAttributeValueHasNotChanged(Object value1, Object value2) {
            return this.attributeValueHasNotChanged(value1, value2);
        }

        public TestModel clone() {
            try {
                return (TestModel)super.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new InternalError();
            }
        }

        public boolean testValuesAreDifferent(Object value1, Object value2) {
            return this.valuesAreDifferent(value1, value2);
        }

        public boolean testValuesAreEqual(Object value1, Object value2) {
            return this.valuesAreEqual(value1, value2);
        }

        public boolean testElementsAreDifferent(Iterable<?> iterable1, Iterable<?> iterable2) {
            return this.getChangeSupport().elementsAreDifferent(iterable1, iterable2);
        }

        public boolean testElementsAreEqual(Iterable<?> iterable1, Iterable<?> iterable2) {
            return this.getChangeSupport().elementsAreEqual(iterable1, iterable2);
        }

        public void toString(StringBuilder sb) {
            sb.append(ChangeSupportTests.TEST_TO_STRING);
        }
    }
}

