/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.jaxws.dom.integration.tests.navigator.actions;

import junit.framework.AssertionFailedError;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jst.ws.jaxws.dom.integration.navigator.DOMAdapterFactoryContentProvider;
import org.eclipse.jst.ws.jaxws.dom.integration.navigator.ISEIChildList;
import org.eclipse.jst.ws.jaxws.dom.integration.navigator.IWebServiceChildList;
import org.eclipse.jst.ws.jaxws.dom.integration.navigator.actions.WSActionProvider;
import org.eclipse.jst.ws.jaxws.dom.runtime.api.IDOM;
import org.eclipse.jst.ws.jaxws.dom.runtime.api.IServiceEndpointInterface;
import org.eclipse.jst.ws.jaxws.dom.runtime.api.IWebMethod;
import org.eclipse.jst.ws.jaxws.dom.runtime.api.IWebService;
import org.eclipse.jst.ws.jaxws.dom.runtime.api.IWebServiceProject;
import org.eclipse.jst.ws.jaxws.dom.runtime.persistence.JaxWsWorkspaceResource;
import org.eclipse.jst.ws.jaxws.testutils.jmock.Mock;
import org.eclipse.jst.ws.jaxws.testutils.jmock.MockObjectTestCase;
import org.eclipse.jst.ws.jaxws.testutils.project.TestProject;
import org.eclipse.jst.ws.jaxws.testutils.project.TestProjectsUtils;
import org.eclipse.ui.actions.ActionContext;
import org.eclipse.ui.internal.navigator.NavigatorContentService;
import org.eclipse.ui.internal.navigator.extensions.CommonActionExtensionSite;
import org.eclipse.ui.navigator.ICommonActionExtensionSite;
import org.eclipse.ui.navigator.ICommonViewerSite;
import org.eclipse.ui.navigator.NavigatorContentServiceFactory;

public class WSActionAbstractTest
extends MockObjectTestCase {
    protected static TestProject testPrj1;
    protected static TestProject testPrj2;
    protected static TestProject testPrj3;
    protected static TestProject testPrj4;
    private IWebServiceProject wsProject1;
    private IWebServiceProject wsProject2;
    private IWebServiceProject wsProject3;
    private IWebServiceProject wsProject4;
    protected IPackageFragment modelSync1;
    protected IPackageFragment modelSync2;
    protected IPackageFragment modelSync3;
    protected IPackageFragment modelSync4;
    protected JaxWsWorkspaceResource targetResource;
    protected DOMAdapterFactoryContentProvider adapterFactory;
    protected WSActionProvider wsActionProv = null;

    public void setUp() throws Exception {
        IProject webProject;
        IProject ejbProject;
        if (testPrj1 == null) {
            ejbProject = TestProjectsUtils.createEjb3Project((String)("DOMWSActionTestProject1" + System.currentTimeMillis()));
            testPrj1 = new TestProject(ejbProject.getProject());
            testPrj1.createSourceFolder("src");
            this.modelSync1 = testPrj1.createPackage("org.eclipse.test.modelsync1");
            testPrj1.createType(this.modelSync1, "Sei1.java", "@javax.jws.WebService(name=\"Sei1Name\") public interface Sei1{\n@javax.jws.WebMethod(operationName=\"parentMethod\") public void voidMethodWithNoArgsInParent();\n}");
            testPrj1.createType(this.modelSync1, "Sei2.java", "@javax.jws.WebService(name=\"Sei2Name\") public interface Sei2 extends Sei1 {\n@javax.jws.WebMethod(operationName=\"webMethod\") public void voidMethodWithNoArgsNotInParent();\n}");
            testPrj1.createType(this.modelSync1, "WS1.java", "@javax.ejb.Stateless\n@javax.jws.WebService(serviceName=\"WS1Name\", endpointInterface=\"org.eclipse.test.modelsync1.Sei2\") public class WS1 {}");
        }
        if (testPrj2 == null) {
            webProject = TestProjectsUtils.createWeb25Project((String)("DOMWSActionTestProject2" + System.currentTimeMillis()));
            testPrj2 = new TestProject(webProject.getProject());
            testPrj2.createSourceFolder("src");
            this.modelSync2 = testPrj2.createPackage("org.eclipse.test.modelsync2");
            testPrj2.createType(this.modelSync2, "Sei1.java", "@javax.jws.WebService(name=\"Sei1Name\") public interface Sei1{\n@javax.jws.WebMethod(operationName=\"parentMethod\") public void voidMethodWithNoArgsInParent();\n}");
            testPrj2.createType(this.modelSync2, "Sei2.java", "@javax.jws.WebService(name=\"Sei2Name\") public interface Sei2 extends Sei1 {\n@javax.jws.WebMethod(operationName=\"webMethod\") public void voidMethodWithNoArgsNotInParent();\n}");
            testPrj2.createType(this.modelSync2, "WS1.java", "@javax.jws.WebService(serviceName=\"WS1Name\", endpointInterface=\"org.eclipse.test.modelsync1.Sei2\") public class WS1 {}");
        }
        if (testPrj3 == null) {
            ejbProject = TestProjectsUtils.createEjb3Project((String)("DOMWSActionTestProject3" + System.currentTimeMillis()));
            testPrj3 = new TestProject(ejbProject.getProject());
            testPrj3.createSourceFolder("src");
            this.modelSync3 = testPrj3.createPackage("org.eclipse.test.modelsync3");
            testPrj3.createType(this.modelSync3, "WS1.java", "@javax.jws.WebService(name=\"ImplicitSei1Name\") public class WS1 {\n@javax.jws.WebMethod(operationName=\"superParentMethod\") public void superParentMethod() {}\n}");
            testPrj3.createType(this.modelSync3, "WS2.java", "@javax.jws.WebService(name=\"ImplicitSei2Name\") public class WS2 extends WS1 {\n@javax.jws.WebMethod(operationName=\"parentMethod\") public void parentMethod() {}\n}");
            testPrj3.createType(this.modelSync3, "WS3.java", "@javax.jws.WebService(name=\"ImplicitSei3Name\") public class WS3 extends WS2 {\n@javax.jws.WebMethod(operationName=\"webMethod\") public void webMethod(int param) {}\n}");
        }
        if (testPrj4 == null) {
            webProject = TestProjectsUtils.createWeb25Project((String)("DOMWSActionTestProject4" + System.currentTimeMillis()));
            testPrj4 = new TestProject(webProject.getProject());
            testPrj4.createSourceFolder("src");
            this.modelSync4 = testPrj4.createPackage("org.eclipse.test.modelsync4");
            testPrj4.createType(this.modelSync4, "WS1.java", "@javax.jws.WebService(name=\"ImplicitSei1Name\") public class WS1 {\n@javax.jws.WebMethod(operationName=\"superParentMethod\") public void superParentMethod() {}\n}");
            testPrj4.createType(this.modelSync4, "WS2.java", "@javax.jws.WebService(name=\"ImplicitSei2Name\") public class WS2 extends WS1 {\n@javax.jws.WebMethod(operationName=\"parentMethod\") public void parentMethod() {}\n}");
            testPrj4.createType(this.modelSync4, "WS3.java", "@javax.jws.WebService(name=\"ImplicitSei3Name\") public class WS3 extends WS2 {\n@javax.jws.WebMethod(operationName=\"webMethod\") public void webMethod() {}\n}");
        }
        this.targetResource = new JaxWsWorkspaceResource(JavaCore.create((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot()));
        this.targetResource.load(null);
        for (IWebServiceProject wsProject : this.targetResource.getDOM().getWebServiceProjects()) {
            if (wsProject.getName().equals(testPrj1.getProject().getName())) {
                this.wsProject1 = wsProject;
                continue;
            }
            if (wsProject.getName().equals(testPrj2.getProject().getName())) {
                this.wsProject2 = wsProject;
                continue;
            }
            if (wsProject.getName().equals(testPrj3.getProject().getName())) {
                this.wsProject3 = wsProject;
                continue;
            }
            if (!wsProject.getName().equals(testPrj4.getProject().getName())) continue;
            this.wsProject4 = wsProject;
        }
        WSActionAbstractTest.assertNotNull((Object)this.wsProject1);
        WSActionAbstractTest.assertNotNull((Object)this.wsProject2);
        WSActionAbstractTest.assertNotNull((Object)this.wsProject3);
        WSActionAbstractTest.assertNotNull((Object)this.wsProject4);
        this.adapterFactory = new DOMAdapterFactoryContentProvider(){

            protected IWebServiceProject getWsProject(IDOM dom, IProject project) {
                if (project.getName().equals(WSActionAbstractTest.this.wsProject1.getName())) {
                    return WSActionAbstractTest.this.wsProject1;
                }
                if (project.getName().equals(WSActionAbstractTest.this.wsProject2.getName())) {
                    return WSActionAbstractTest.this.wsProject2;
                }
                if (project.getName().equals(WSActionAbstractTest.this.wsProject3.getName())) {
                    return WSActionAbstractTest.this.wsProject3;
                }
                if (project.getName().equals(WSActionAbstractTest.this.wsProject4.getName())) {
                    return WSActionAbstractTest.this.wsProject4;
                }
                throw new AssertionFailedError("project " + project + "not found in DOM");
            }
        };
    }

    protected IWebService getWSFromEjbProject() {
        Object[] children = this.adapterFactory.getChildren((Object)testPrj1.getProject());
        children = this.adapterFactory.getChildren(children[0]);
        int ii = 0;
        while (ii < children.length) {
            if (children[ii] instanceof IWebServiceChildList) {
                Object[] wSs = this.adapterFactory.getChildren(children[ii]);
                return (IWebService)wSs[0];
            }
            ++ii;
        }
        return null;
    }

    protected IWebService getWSFromWebProject() {
        Object[] children = this.adapterFactory.getChildren((Object)testPrj2.getProject());
        children = this.adapterFactory.getChildren(children[0]);
        int ii = 0;
        while (ii < children.length) {
            if (children[ii] instanceof IWebServiceChildList) {
                Object[] wSs = this.adapterFactory.getChildren(children[ii]);
                return (IWebService)wSs[0];
            }
            ++ii;
        }
        return null;
    }

    protected IServiceEndpointInterface getSEIExpFromEjbProject() {
        Object[] children = this.adapterFactory.getChildren((Object)testPrj1.getProject());
        children = this.adapterFactory.getChildren(children[0]);
        int ii = 0;
        while (ii < children.length) {
            if (children[ii] instanceof ISEIChildList) {
                Object[] sEIs = this.adapterFactory.getChildren(children[ii]);
                return (IServiceEndpointInterface)sEIs[0];
            }
            ++ii;
        }
        return null;
    }

    protected IServiceEndpointInterface getSEIFromTestPrj1(String seiName) {
        Object[] children = this.adapterFactory.getChildren((Object)testPrj1.getProject());
        children = this.adapterFactory.getChildren(children[0]);
        int ii = 0;
        while (ii < children.length) {
            if (children[ii] instanceof ISEIChildList) {
                Object[] sEIs = this.adapterFactory.getChildren(children[ii]);
                int jj = 0;
                while (jj < sEIs.length) {
                    if (((IServiceEndpointInterface)sEIs[jj]).getName().equals(seiName)) {
                        return (IServiceEndpointInterface)sEIs[jj];
                    }
                    ++jj;
                }
            }
            ++ii;
        }
        return null;
    }

    protected IWebService getWSFromTestPrj(TestProject testPrj, String wsName) {
        Object[] children = this.adapterFactory.getChildren((Object)testPrj.getProject());
        children = this.adapterFactory.getChildren(children[0]);
        int ii = 0;
        while (ii < children.length) {
            if (children[ii] instanceof IWebServiceChildList) {
                Object[] wSs = this.adapterFactory.getChildren(children[ii]);
                int jj = 0;
                while (jj < wSs.length) {
                    if (((IWebService)wSs[jj]).getImplementation().equals(wsName)) {
                        return (IWebService)wSs[jj];
                    }
                    ++jj;
                }
            }
            ++ii;
        }
        return null;
    }

    protected IServiceEndpointInterface getSEIFromTestPrj3(String seiName) {
        Object[] children = this.adapterFactory.getChildren((Object)testPrj3.getProject());
        children = this.adapterFactory.getChildren(children[0]);
        int ii = 0;
        while (ii < children.length) {
            if (children[ii] instanceof IWebServiceChildList) {
                Object[] wSs = this.adapterFactory.getChildren(children[ii]);
                int jj = 0;
                while (jj < wSs.length) {
                    if (((IWebService)wSs[jj]).getServiceEndpoint().getName().equals(seiName)) {
                        return ((IWebService)wSs[jj]).getServiceEndpoint();
                    }
                    ++jj;
                }
            }
            ++ii;
        }
        return null;
    }

    protected IServiceEndpointInterface getSEIExpFromWebProject() {
        Object[] children = this.adapterFactory.getChildren((Object)testPrj2.getProject());
        children = this.adapterFactory.getChildren(children[0]);
        int ii = 0;
        while (ii < children.length) {
            if (children[ii] instanceof ISEIChildList) {
                Object[] sEIs = this.adapterFactory.getChildren(children[ii]);
                return (IServiceEndpointInterface)sEIs[0];
            }
            ++ii;
        }
        return null;
    }

    protected IServiceEndpointInterface getSEIImpFromEjbProject() {
        Object[] children = this.adapterFactory.getChildren((Object)testPrj3.getProject());
        children = this.adapterFactory.getChildren(children[0]);
        int ii = 0;
        while (ii < children.length) {
            if (children[ii] instanceof IWebServiceChildList) {
                Object[] wSs = this.adapterFactory.getChildren(children[ii]);
                return ((IWebService)wSs[0]).getServiceEndpoint();
            }
            ++ii;
        }
        return null;
    }

    protected IServiceEndpointInterface getSEIImpFromWebProject() {
        Object[] children = this.adapterFactory.getChildren((Object)testPrj4.getProject());
        children = this.adapterFactory.getChildren(children[0]);
        int ii = 0;
        while (ii < children.length) {
            if (children[ii] instanceof IWebServiceChildList) {
                Object[] wSs = this.adapterFactory.getChildren(children[ii]);
                return ((IWebService)wSs[0]).getServiceEndpoint();
            }
            ++ii;
        }
        return null;
    }

    protected IWebMethod getWSMethodInheritedFromEjbProject() {
        Object[] children = this.adapterFactory.getChildren((Object)testPrj3.getProject());
        children = this.adapterFactory.getChildren(children[0]);
        Object[] wSs = null;
        Object[] webMethods = null;
        int ii = 0;
        while (ii < children.length) {
            if (children[ii] instanceof IWebServiceChildList) {
                wSs = this.adapterFactory.getChildren(children[ii]);
                break;
            }
            ++ii;
        }
        WSActionAbstractTest.assertNotNull((Object)wSs);
        ii = 0;
        while (ii < wSs.length) {
            if (((IWebService)wSs[ii]).getImplementation().equals("org.eclipse.test.modelsync3.WS3")) {
                webMethods = this.adapterFactory.getChildren((Object)((IWebService)wSs[ii]).getServiceEndpoint());
                break;
            }
            ++ii;
        }
        WSActionAbstractTest.assertNotNull((Object)webMethods);
        ii = 0;
        while (ii < webMethods.length) {
            if (((IWebMethod)webMethods[ii]).getName().equals("superParentMethod")) {
                return (IWebMethod)webMethods[ii];
            }
            ++ii;
        }
        return null;
    }

    protected IWebMethod getWSMethodInheritedFromWebProject() {
        Object[] children = this.adapterFactory.getChildren((Object)testPrj4.getProject());
        children = this.adapterFactory.getChildren(children[0]);
        Object[] wSs = null;
        Object[] webMethods = null;
        int ii = 0;
        while (ii < children.length) {
            if (children[ii] instanceof IWebServiceChildList) {
                wSs = this.adapterFactory.getChildren(children[ii]);
                break;
            }
            ++ii;
        }
        WSActionAbstractTest.assertNotNull((Object)wSs);
        ii = 0;
        while (ii < wSs.length) {
            if (((IWebService)wSs[ii]).getImplementation().equals("org.eclipse.test.modelsync4.WS3")) {
                webMethods = this.adapterFactory.getChildren((Object)((IWebService)wSs[ii]).getServiceEndpoint());
                break;
            }
            ++ii;
        }
        WSActionAbstractTest.assertNotNull((Object)webMethods);
        ii = 0;
        while (ii < webMethods.length) {
            if (((IWebMethod)webMethods[ii]).getName().equals("superParentMethod")) {
                return (IWebMethod)webMethods[ii];
            }
            ++ii;
        }
        return null;
    }

    protected IWebMethod getWSMethodNotInheritedFromEjbProject() {
        Object[] children = this.adapterFactory.getChildren((Object)testPrj3.getProject());
        children = this.adapterFactory.getChildren(children[0]);
        Object[] wSs = null;
        Object[] webMethods = null;
        int ii = 0;
        while (ii < children.length) {
            if (children[ii] instanceof IWebServiceChildList) {
                wSs = this.adapterFactory.getChildren(children[ii]);
                break;
            }
            ++ii;
        }
        WSActionAbstractTest.assertNotNull((Object)wSs);
        ii = 0;
        while (ii < wSs.length) {
            if (((IWebService)wSs[ii]).getImplementation().equals("org.eclipse.test.modelsync3.WS3")) {
                webMethods = this.adapterFactory.getChildren((Object)((IWebService)wSs[ii]).getServiceEndpoint());
                break;
            }
            ++ii;
        }
        WSActionAbstractTest.assertNotNull((Object)webMethods);
        ii = 0;
        while (ii < webMethods.length) {
            if (((IWebMethod)webMethods[ii]).getName().equals("webMethod")) {
                return (IWebMethod)webMethods[ii];
            }
            ++ii;
        }
        return null;
    }

    protected IWebMethod getWSMethodNotInheritedFromWebProject() {
        Object[] children = this.adapterFactory.getChildren((Object)testPrj4.getProject());
        children = this.adapterFactory.getChildren(children[0]);
        Object[] wSs = null;
        Object[] webMethods = null;
        int ii = 0;
        while (ii < children.length) {
            if (children[ii] instanceof IWebServiceChildList) {
                wSs = this.adapterFactory.getChildren(children[ii]);
                break;
            }
            ++ii;
        }
        WSActionAbstractTest.assertNotNull((Object)wSs);
        ii = 0;
        while (ii < wSs.length) {
            if (((IWebService)wSs[ii]).getImplementation().equals("org.eclipse.test.modelsync4.WS3")) {
                webMethods = this.adapterFactory.getChildren((Object)((IWebService)wSs[ii]).getServiceEndpoint());
                break;
            }
            ++ii;
        }
        WSActionAbstractTest.assertNotNull((Object)webMethods);
        ii = 0;
        while (ii < webMethods.length) {
            if (((IWebMethod)webMethods[ii]).getName().equals("webMethod")) {
                return (IWebMethod)webMethods[ii];
            }
            ++ii;
        }
        return null;
    }

    protected IWebMethod getSEIMethodInheritedFromEjbProject() {
        Object[] children = this.adapterFactory.getChildren((Object)testPrj1.getProject());
        children = this.adapterFactory.getChildren(children[0]);
        Object[] sEIs = null;
        Object[] webMethods = null;
        int ii = 0;
        while (ii < children.length) {
            if (children[ii] instanceof ISEIChildList) {
                sEIs = this.adapterFactory.getChildren(children[ii]);
                break;
            }
            ++ii;
        }
        WSActionAbstractTest.assertNotNull((Object)sEIs);
        ii = 0;
        while (ii < sEIs.length) {
            if (((IServiceEndpointInterface)sEIs[ii]).getName().equals("Sei2Name")) {
                webMethods = this.adapterFactory.getChildren((Object)((IServiceEndpointInterface)sEIs[ii]));
                break;
            }
            ++ii;
        }
        WSActionAbstractTest.assertNotNull((Object)webMethods);
        ii = 0;
        while (ii < webMethods.length) {
            if (((IWebMethod)webMethods[ii]).getName().equals("parentMethod")) {
                return (IWebMethod)webMethods[ii];
            }
            ++ii;
        }
        return null;
    }

    protected IWebMethod getSEIMethodInheritedFromWebProject() {
        Object[] children = this.adapterFactory.getChildren((Object)testPrj2.getProject());
        children = this.adapterFactory.getChildren(children[0]);
        Object[] sEIs = null;
        Object[] webMethods = null;
        int ii = 0;
        while (ii < children.length) {
            if (children[ii] instanceof ISEIChildList) {
                sEIs = this.adapterFactory.getChildren(children[ii]);
                break;
            }
            ++ii;
        }
        WSActionAbstractTest.assertNotNull((Object)sEIs);
        ii = 0;
        while (ii < sEIs.length) {
            if (((IServiceEndpointInterface)sEIs[ii]).getName().equals("Sei2Name")) {
                webMethods = this.adapterFactory.getChildren((Object)((IServiceEndpointInterface)sEIs[ii]));
                break;
            }
            ++ii;
        }
        WSActionAbstractTest.assertNotNull((Object)webMethods);
        ii = 0;
        while (ii < webMethods.length) {
            if (((IWebMethod)webMethods[ii]).getName().equals("parentMethod")) {
                return (IWebMethod)webMethods[ii];
            }
            ++ii;
        }
        return null;
    }

    protected IWebMethod getSEIMethodNotInheritedFromEjbProject() {
        Object[] children = this.adapterFactory.getChildren((Object)testPrj1.getProject());
        children = this.adapterFactory.getChildren(children[0]);
        Object[] sEIs = null;
        Object[] webMethods = null;
        int ii = 0;
        while (ii < children.length) {
            if (children[ii] instanceof ISEIChildList) {
                sEIs = this.adapterFactory.getChildren(children[ii]);
                break;
            }
            ++ii;
        }
        WSActionAbstractTest.assertNotNull((Object)sEIs);
        ii = 0;
        while (ii < sEIs.length) {
            if (((IServiceEndpointInterface)sEIs[ii]).getName().equals("Sei2Name")) {
                webMethods = this.adapterFactory.getChildren((Object)((IServiceEndpointInterface)sEIs[ii]));
                break;
            }
            ++ii;
        }
        WSActionAbstractTest.assertNotNull((Object)webMethods);
        ii = 0;
        while (ii < webMethods.length) {
            if (((IWebMethod)webMethods[ii]).getName().equals("webMethod")) {
                return (IWebMethod)webMethods[ii];
            }
            ++ii;
        }
        return null;
    }

    protected IWebMethod getSEIMethodNotInheritedFromWebProject() {
        Object[] children = this.adapterFactory.getChildren((Object)testPrj2.getProject());
        children = this.adapterFactory.getChildren(children[0]);
        Object[] sEIs = null;
        Object[] webMethods = null;
        int ii = 0;
        while (ii < children.length) {
            if (children[ii] instanceof ISEIChildList) {
                sEIs = this.adapterFactory.getChildren(children[ii]);
                break;
            }
            ++ii;
        }
        WSActionAbstractTest.assertNotNull((Object)sEIs);
        ii = 0;
        while (ii < sEIs.length) {
            if (((IServiceEndpointInterface)sEIs[ii]).getName().equals("Sei2Name")) {
                webMethods = this.adapterFactory.getChildren((Object)((IServiceEndpointInterface)sEIs[ii]));
                break;
            }
            ++ii;
        }
        WSActionAbstractTest.assertNotNull((Object)webMethods);
        ii = 0;
        while (ii < webMethods.length) {
            if (((IWebMethod)webMethods[ii]).getName().equals("webMethod")) {
                return (IWebMethod)webMethods[ii];
            }
            ++ii;
        }
        return null;
    }

    protected void initWsActionProviderWithTreeSelection(Object[] selection) {
        this.wsActionProv = new WSActionProvider();
        Mock treeViewer = this.mock(TreeViewer.class);
        CommonActionExtensionSite cAExtSite = this.createCommonActionExtensionSiteMock((StructuredViewer)treeViewer.proxy());
        this.wsActionProv.init((ICommonActionExtensionSite)cAExtSite);
        TreePath path = new TreePath(selection);
        TreeSelection sel = new TreeSelection(path);
        ActionContext actCnt = new ActionContext((ISelection)sel);
        this.wsActionProv.setContext(actCnt);
    }

    protected void initWsActionProviderWithStructuredSelection(Object[] selection) {
        this.wsActionProv = new WSActionProvider();
        Mock treeViewer = this.mock(TreeViewer.class);
        CommonActionExtensionSite cAExtSite = this.createCommonActionExtensionSiteMock((StructuredViewer)treeViewer.proxy());
        this.wsActionProv.init((ICommonActionExtensionSite)cAExtSite);
        StructuredSelection sel = new StructuredSelection(selection);
        ActionContext actCnt = new ActionContext((ISelection)sel);
        this.wsActionProv.setContext(actCnt);
    }

    protected IWebServiceProject getWsProject(IProject project) {
        for (IWebServiceProject wsProject : this.targetResource.getDOM().getWebServiceProjects()) {
            if (!wsProject.getName().equals(project.getName())) continue;
            return wsProject;
        }
        throw new AssertionFailedError("project " + project + "not found in DOM");
    }

    protected CommonActionExtensionSite createCommonActionExtensionSiteMock(StructuredViewer viewer) {
        NavigatorContentService contentService = (NavigatorContentService)NavigatorContentServiceFactory.INSTANCE.createContentService("myviewer");
        return new CommonActionExtensionSite("myextensionid", "mypluginid", (ICommonViewerSite)this.mock(ICommonViewerSite.class).proxy(), contentService, viewer);
    }

    protected IContributionItem createContributionItemMock(String itemId) {
        Mock cntrbItem = this.mock(IContributionItem.class);
        cntrbItem.stubs().method("getId").will(this.returnValue(itemId));
        cntrbItem.stubs().method("setParent").will(this.returnValue(null));
        cntrbItem.stubs().method("isDynamic").will(this.returnValue(false));
        return (IContributionItem)cntrbItem.proxy();
    }

    protected void fillMenuWithContributionItems(MenuManager menu, String ... itemIds) {
        String[] stringArray = itemIds;
        int n = itemIds.length;
        int n2 = 0;
        while (n2 < n) {
            String id = stringArray[n2];
            IContributionItem cntrbItem = this.createContributionItemMock(id);
            menu.add(cntrbItem);
            ++n2;
        }
    }
}

